#include "rheolef.h"
using namespace rheolef;
using namespace std;
size_t N;
Float u_ex (const point& x) { return - 1./12.
		+ (x[0]*(1-x[0]) + x[1]*(1-x[1]) + x[2]*(1-x[2]))/(2.*N); }
int main(int argc, char**argv) {
    field uh;
    cin >> uh;
    const space& Xh = uh.get_space();
    N = Xh.dimension();
    field pi_h_u = interpolate(Xh, u_ex);
    form m (Xh, Xh, "mass");
    field one (Xh, 1.0);
warning_macro ("m(uh,1) = " << m(uh,one));
warning_macro ("m(pi_h_u,1) = " << m(pi_h_u,one));
    Float error_l2 = m(uh-pi_h_u,uh-pi_h_u);
    Float error_linf = (uh-pi_h_u).max_abs();
    cerr << "error_l2   = " << error_l2   << endl
         << "error_linf = " << error_linf << endl;
    return (error_l2 < 1e-3) ? 0 : 1;
}
