///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include <boost/numeric/ublas/vector.hpp>
using namespace boost::numeric::ublas;

#include <valarray>
using std::valarray;
using std::slice_array;
using std::slice;

inline std::slice xrange (size_t first, size_t last) {
     return std::slice (first, last-first, 1);
}

#include <iostream>

template <class T>
void f (T v)
{
	for (size_t i = 0; i < 2; i++)
            std::cout << v[i] << std::endl;
}
int main()
{
	valarray<double> u (4);
	u[0] = 1;
	u[1] = 2;
	u[2] = 3;
	u[4] = 4;
	valarray<double> u2 (4);
	u2[0] = 7;
	u2[1] = 9;
	valarray<double> v = u*u;
	const slice_array<double>& w = u [xrange(0, 2)];

	// ok: can affect
	w = u2;

#ifdef MISSING
	// algebra on slice_array is not defined...
	// valarray<double> t =  w+w;
#endif // MISSING

	// bad solution = force to valarray: make some copy !
	valarray<double> t =  valarray<double>(w)* valarray<double>(w);
}
