///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "gradt_grad.h"
using namespace rheolef;
using namespace std;
using namespace ublas;

//          [    u0      u1      u2   ]
//
// [ v0 ]   [ d0^T*d0 d0^T*d1 d0^T*d2 ]
// [ v1 ] = [ d1^T*d0 d1^T*d1 d1^T*d2 ]
// [ v2 ]   [ d2^T*d0 d2^T*d1 d2^T*d2 ]
//
void
gradt_grad::operator() (const geo_element& K, matrix<Float>& dd) const
{
  build_gradt_grad (K, dd);
}
gradt_grad::size_type
gradt_grad::n_derivative() const
{
  if (coordinate_system_type() == fem_helper::cartesian) return 2;
  else return 0;
}
void
gradt_grad::check_after_initialize () const
{
  size_type d = coordinate_dimension();
  check_macro (
	d == get_first_space().n_component() && 
	d == get_second_space().n_component(),
	"unsupported non-vectorial space for `gradt_grad' form");
}
