// Code generated by ./internal/gen/main.go. DO NOT EDIT.

//go:generate go run ./internal/gen/main.go

package encoder

var testCasesSingle = []testCase{
	{ // 0
		mask: EncodeZero,
		in:   "＜2π'ｊ８＄aｗ＜k|\x1bβ\x00σ\vτ７␓>R\x0e␀τ␐β7７␊",
		out:  "＜2π'ｊ８＄aｗ＜k|\x1bβ␀σ\vτ７␓>R\x0e‛␀τ␐β7７␊",
	}, { // 1
		mask: EncodeSlash,
		in:   "｀␓VＪｇ␒Ｋ/\n+\x10／φ␍/π|\x02ρRα%ζ？＜VLν＞ｑ",
		out:  "｀␓VＪｇ␒Ｋ／\n+\x10‛／φ␍／π|\x02ρRα%ζ？＜VLν＞ｑ",
	}, { // 2
		mask: EncodeSingleQuote,
		in:   "γ／＇Ｐｎ/χ\nε␓[υ\x15␇］ζM2ω␊％$\vＡＮ：^'\x0f\x10",
		out:  "γ／‛＇Ｐｎ/χ\nε␓[υ\x15␇］ζM2ω␊％$\vＡＮ：^＇\x0f\x10",
	}, { // 3
		mask: EncodeBackQuote,
		in:   "?／θWfｃＲ％(＊｀\x01Ｖ６τη\a␔>mυ>␜\x18␙βw｛`ρ",
		out:  "?／θWfｃＲ％(＊‛｀\x01Ｖ６τη\a␔>mυ>␜\x18␙βw｛｀ρ",
	}, { // 4
		mask: EncodeLtGt,
		in:   "４␏>ｏ#\tＰι,␙Pυ\x00＜$␐！９tπ＞<＜\x1e(ης␖oε",
		out:  "４␏＞ｏ#\tＰι,␙Pυ␀‛＜$␐！９tπ‛＞＜‛＜\x1e(ης␖oε",
	}, { // 5
		mask: EncodeDollar,
		in:   ")＄βcμ\vωμ\x1e｜$#\"υ␝␒␘\uff00／＊\x13:␜\r\x1a3ｅ｀␋θ",
		out:  ")‛＄βcμ\vωμ\x1e｜＄#\"υ␝␒␘\uff00／＊\x13:␜\r\x1a3ｅ｀␋θ",
	}, { // 6
		mask: EncodeDoubleQuote,
		in:   "Ｆ＝υＢ\x05␟\n\x1c＊␝οｏ:␂ι＂\nIο␘ｂ\"α;eeφ＜%3",
		out:  "Ｆ＝υＢ\x05␟\n\x1c＊␝οｏ:␂ι‛＂\nIο␘ｂ＂α;eeφ＜%3",
	}, { // 7
		mask: EncodeColon,
		in:   "｜\x1a\x0e:μ\x1e␍η`:＆t：+J＃\v␐β␎＋τι\\/μ＃␌␄７",
		out:  "｜\x1a\x0e：μ\x1e␍η`：＆t‛：+J＃\v␐β␎＋τι\\/μ＃␌␄７",
	}, { // 8
		mask: EncodeQuestion,
		in:   "ω\\rEυｅ␍\x06τ？α３\tｚＲ?\x13｀Ｆ␈&␔␟*ν␟Rχ \"",
		out:  "ω\\rEυｅ␍\x06τ‛？α３\tｚＲ？\x13｀Ｆ␈&␔␟*ν␟Rχ \"",
	}, { // 9
		mask: EncodeAsterisk,
		in:   "8b\rγ？ε/␚\\α␑Ｏ\x1dＤBυ␂σ␍␉␊＜－z＊R\x18π*#",
		out:  "8b\rγ？ε/␚\\α␑Ｏ\x1dＤBυ␂σ␍␉␊＜－z‛＊R\x18π＊#",
	}, { // 10
		mask: EncodePipe,
		in:   "ε'λ＼φ｜|!␂␓G>＇\x03＞␉|\x06＋ｃr␜β\x1aωＰgρa＜",
		out:  "ε'λ＼φ‛｜｜!␂␓G>＇\x03＞␉｜\x06＋ｃr␜β\x1aωＰgρa＜",
	}, { // 11
		mask: EncodeHash,
		in:   "␚１␚␕:S\x1d）\x13\x11,ξ#αυ＃F＠３\bφ␞sξ?␛Ｉ＂1χ",
		out:  "␚１␚␕:S\x1d）\x13\x11,ξ＃αυ‛＃F＠３\bφ␞sξ?␛Ｉ＂1χ",
	}, { // 12
		mask: EncodePercent,
		in:   "α\v␑＝␘＇%i␚/＆ζＭ＄0␟γ％GπＵξ\n＿\x01\x1a%mψx",
		out:  "α\v␑＝␘＇％i␚/＆ζＭ＄0␟γ‛％GπＵξ\n＿\x01\x1a％mψx",
	}, { // 13
		mask: EncodeBackSlash,
		in:   "ｌ*｛␓␒Ｆυ␍χ＊ＣυL\x15\x1bμ␅\rＯ␘＼%j\x0e\\ωα\\;p",
		out:  "ｌ*｛␓␒Ｆυ␍χ＊ＣυL\x15\x1bμ␅\rＯ␘‛＼%j\x0e＼ωα＼;p",
	}, { // 14
		mask: EncodeCrLf,
		in:   "\f＜␒␁μ$φ\r\v＞ｉδ\x1f\x1d␊ο␙χ%xI）␍yＧ\n！ςt９",
		out:  "\f＜␒␁μ$φ␍\v＞ｉδ\x1f\x1d‛␊ο␙χ%xI）‛␍yＧ␊！ςt９",
	}, { // 15
		mask: EncodeDel,
		in:   "DδＭ␍ξ＄\x1cρ␟ζ␘␃Ｔ\"␄φ!$Ｏ\x11|d\u007f/γＷＪ%␡:",
		out:  "DδＭ␍ξ＄\x1cρ␟ζ␘␃Ｔ\"␄φ!$Ｏ\x11|d␡/γＷＪ%‛␡:",
	}, { // 16
		mask: EncodeCtl,
		in:   "\x1a\x1f␏␟␚\x1d\x02\x05␍\x03\tσｅｌ\x13␛\x0e␈\x1e\x11␔␞␐α\v\aβ␊Pβ␝\x19\x04ｘλ␉␅␄␎χ␙\x18\x1c␑␓\n␌␁\x12^/␝␊␕\x14␃\b/:␋␅\x10␞␆\f.＇+␘／\x01\"␗\x0e\x1b|\x15\\␖\x14Ｖ\x06\x16␇␂␜\x17\x0f␒\x1b\r␃；",
		out:  "␚␟‛␏‛␟‛␚␝␂␅‛␍␃␉σｅｌ␓‛␛␎‛␈␞␑‛␔‛␞‛␐α␋␇β‛␊Pβ‛␝␙␄ｘλ‛␉‛␅‛␄‛␎χ‛␙␘␜‛␑‛␓␊‛␌‛␁␒^/‛␝‛␊‛␕␔‛␃␈/:‛␋‛␅␐‛␞‛␆␌.＇+‛␘／␁\"‛␗␎␛|␕\\‛␖␔Ｖ␆␖‛␇‛␂‛␜␗␏‛␒␛␍‛␃；",
	},
}

var testCasesSingleEdge = []testCase{
	{ // 0
		mask: EncodeLeftSpace,
		in:   " ",
		out:  "␠",
	}, { // 1
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%ν",
		out:  "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%ν",
	}, { // 2
		mask: EncodeZero | EncodeLeftSpace,
		in:   " ␠n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%ν",
		out:  "␠␠n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%ν",
	}, { // 3
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠␠n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%ν",
		out:  "‛␠␠n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%ν",
	}, { // 4
		mask: EncodeZero | EncodeLeftSpace,
		in:   " ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL␠ν",
		out:  "␠；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL␠ν",
	}, { // 5
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL␠ν",
		out:  "‛␠；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL␠ν",
	}, { // 6
		mask: EncodeZero | EncodeLeftSpace,
		in:   " ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%␠",
		out:  "␠；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%␠",
	}, { // 7
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%␠",
		out:  "‛␠；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%␠",
	}, { // 8
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ψ n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%ν",
		out:  "ψ n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%ν",
	}, { // 9
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ψ␠n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%ν",
		out:  "ψ␠n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%ν",
	}, { // 10
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ψ n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL␠ν",
		out:  "ψ n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL␠ν",
	}, { // 11
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ψ␠n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL␠ν",
		out:  "ψ␠n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL␠ν",
	}, { // 12
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ψ n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%␠",
		out:  "ψ n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%␠",
	}, { // 13
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ψ␠n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%␠",
		out:  "ψ␠n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%␠",
	}, { // 14
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL ν",
		out:  "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL ν",
	}, { // 15
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL␠ν",
		out:  "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL␠ν",
	}, { // 16
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL ␠",
		out:  "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL ␠",
	}, { // 17
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL␠␠",
		out:  "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL␠␠",
	}, { // 18
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL% ",
		out:  "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL% ",
	}, { // 19
		mask: EncodeZero | EncodeLeftSpace,
		in:   "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%␠",
		out:  "ψ；n\x19ζ␓\x023\"\x1c Ｒ␜\nυ|ｔＨ）<：οi␟｝␉ρL%␠",
	}, { // 20
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␃",
		out:  "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␃",
	}, { // 21
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " ␠\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␃",
		out:  "␠␠\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␃",
	}, { // 22
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠␠\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␃",
		out:  "‛␠␠\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␃",
	}, { // 23
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " 2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚␠␃",
		out:  "␠2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚␠␃",
	}, { // 24
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚␠␃",
		out:  "‛␠2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚␠␃",
	}, { // 25
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " 2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␠",
		out:  "␠2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␠",
	}, { // 26
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␠",
		out:  "‛␠2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␠",
	}, { // 27
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\n \x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␃",
		out:  "\n \x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␃",
	}, { // 28
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\n␠\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␃",
		out:  "\n␠\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␃",
	}, { // 29
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\n \x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚␠␃",
		out:  "\n \x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚␠␃",
	}, { // 30
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\n␠\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚␠␃",
		out:  "\n␠\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚␠␃",
	}, { // 31
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\n \x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␠",
		out:  "\n \x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␠",
	}, { // 32
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\n␠\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␠",
		out:  "\n␠\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␠",
	}, { // 33
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚ ␃",
		out:  "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚ ␃",
	}, { // 34
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚␠␃",
		out:  "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚␠␃",
	}, { // 35
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚ ␠",
		out:  "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚ ␠",
	}, { // 36
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚␠␠",
		out:  "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚␠␠",
	}, { // 37
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾ ",
		out:  "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾ ",
	}, { // 38
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␠",
		out:  "\n2\x06␓␗ｃ<␡\x01θ α{ρρOαｔ␡gXＤNζＤ\x04Ｘ␚＾␠",
	}, { // 39
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼39",
		out:  "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼39",
	}, { // 40
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   " ␠９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼39",
		out:  "␠␠９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼39",
	}, { // 41
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "␠␠９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼39",
		out:  "‛␠␠９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼39",
	}, { // 42
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   " ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼␠9",
		out:  "␠␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼␠9",
	}, { // 43
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "␠␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼␠9",
		out:  "‛␠␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼␠9",
	}, { // 44
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   " ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼3␠",
		out:  "␠␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼3␠",
	}, { // 45
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "␠␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼3␠",
		out:  "‛␠␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼3␠",
	}, { // 46
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "υ ９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼39",
		out:  "υ ９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼39",
	}, { // 47
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "υ␠９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼39",
		out:  "υ␠９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼39",
	}, { // 48
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "υ ９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼␠9",
		out:  "υ ９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼␠9",
	}, { // 49
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "υ␠９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼␠9",
		out:  "υ␠９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼␠9",
	}, { // 50
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "υ ９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼3␠",
		out:  "υ ９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼3␠",
	}, { // 51
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "υ␠９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼3␠",
		out:  "υ␠９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼3␠",
	}, { // 52
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼ 9",
		out:  "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼ 9",
	}, { // 53
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼␠9",
		out:  "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼␠9",
	}, { // 54
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼ ␠",
		out:  "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼ ␠",
	}, { // 55
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼␠␠",
		out:  "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼␠␠",
	}, { // 56
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼3 ",
		out:  "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼3 ",
	}, { // 57
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ＇'5φ␔（＼3␠",
		out:  "υ␏９\r␆}Ｃ\r＄\x0e ;ω\b,␎ψ`φυｒ‛＇＇5φ␔（＼3␠",
	}, { // 58
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "｀G␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６\x02θ",
		out:  "‛｀G␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６\x02θ",
	}, { // 59
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   " ␠␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６\x02θ",
		out:  "␠␠␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６\x02θ",
	}, { // 60
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "␠␠␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６\x02θ",
		out:  "‛␠␠␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６\x02θ",
	}, { // 61
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   " G␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６␠θ",
		out:  "␠G␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６␠θ",
	}, { // 62
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "␠G␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６␠θ",
		out:  "‛␠G␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６␠θ",
	}, { // 63
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   " G␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６\x02␠",
		out:  "␠G␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６\x02␠",
	}, { // 64
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "␠G␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６\x02␠",
		out:  "‛␠G␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６\x02␠",
	}, { // 65
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "｀ ␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６\x02θ",
		out:  "‛｀ ␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６\x02θ",
	}, { // 66
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "｀␠␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６\x02θ",
		out:  "‛｀␠␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６\x02θ",
	}, { // 67
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "｀ ␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６␠θ",
		out:  "‛｀ ␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６␠θ",
	}, { // 68
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "｀␠␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６␠θ",
		out:  "‛｀␠␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６␠θ",
	}, { // 69
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "｀ ␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６\x02␠",
		out:  "‛｀ ␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６\x02␠",
	}, { // 70
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "｀␠␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６\x02␠",
		out:  "‛｀␠␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６\x02␠",
	}, { // 71
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "｀G␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６ θ",
		out:  "‛｀G␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６ θ",
	}, { // 72
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "｀G␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６␠θ",
		out:  "‛｀G␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６␠θ",
	}, { // 73
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "｀G␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６ ␠",
		out:  "‛｀G␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６ ␠",
	}, { // 74
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "｀G␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６␠␠",
		out:  "‛｀G␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６␠␠",
	}, { // 75
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "｀G␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６\x02 ",
		out:  "‛｀G␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６\x02 ",
	}, { // 76
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "｀G␘8Ｃοε９｜＝ ␛lγq\r\x02␀\x03ｎ/uＤ8ρ␄ρ６\x02␠",
		out:  "‛｀G␘8Ｃοε９｜＝ ␛lγq\r\x02‛␀\x03ｎ/uＤ8ρ␄ρ６\x02␠",
	}, { // 77
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "\x1dB.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␉/",
		out:  "\x1dB.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␉/",
	}, { // 78
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   " ␠.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␉/",
		out:  "␠␠.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␉/",
	}, { // 79
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␠␠.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␉/",
		out:  "‛␠␠.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␉/",
	}, { // 80
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   " B.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␠/",
		out:  "␠B.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␠/",
	}, { // 81
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␠B.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␠/",
		out:  "‛␠B.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␠/",
	}, { // 82
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   " B.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␉␠",
		out:  "␠B.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␉␠",
	}, { // 83
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␠B.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␉␠",
		out:  "‛␠B.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␉␠",
	}, { // 84
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "\x1d .Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␉/",
		out:  "\x1d .Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␉/",
	}, { // 85
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "\x1d␠.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␉/",
		out:  "\x1d␠.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␉/",
	}, { // 86
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "\x1d .Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␠/",
		out:  "\x1d .Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␠/",
	}, { // 87
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "\x1d␠.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␠/",
		out:  "\x1d␠.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␠/",
	}, { // 88
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "\x1d .Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␉␠",
		out:  "\x1d .Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␉␠",
	}, { // 89
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "\x1d␠.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␉␠",
		out:  "\x1d␠.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␉␠",
	}, { // 90
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "\x1dB.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς /",
		out:  "\x1dB.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς /",
	}, { // 91
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "\x1dB.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␠/",
		out:  "\x1dB.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␠/",
	}, { // 92
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "\x1dB.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς ␠",
		out:  "\x1dB.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς ␠",
	}, { // 93
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "\x1dB.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␠␠",
		out:  "\x1dB.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␠␠",
	}, { // 94
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "\x1dB.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␉ ",
		out:  "\x1dB.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␉ ",
	}, { // 95
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "\x1dB.Ｗ＂ｏ5%？＞ ␡ε：θ\x1e9\x0fβ␝=α\x00␍εＣ␙ς␉␠",
		out:  "\x1dB.Ｗ＂ｏ5%？‛＞ ␡ε：θ\x1e9\x0fβ␝=α␀␍εＣ␙ς␉␠",
	}, { // 96
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ＱK<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ:\x15",
		out:  "ＱK<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ:\x15",
	}, { // 97
		mask: EncodeDollar | EncodeLeftSpace,
		in:   " ␠<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ:\x15",
		out:  "␠␠<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ:\x15",
	}, { // 98
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "␠␠<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ:\x15",
		out:  "‛␠␠<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ:\x15",
	}, { // 99
		mask: EncodeDollar | EncodeLeftSpace,
		in:   " K<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ␠\x15",
		out:  "␠K<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ␠\x15",
	}, { // 100
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "␠K<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ␠\x15",
		out:  "‛␠K<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ␠\x15",
	}, { // 101
		mask: EncodeDollar | EncodeLeftSpace,
		in:   " K<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ:␠",
		out:  "␠K<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ:␠",
	}, { // 102
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "␠K<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ:␠",
		out:  "‛␠K<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ:␠",
	}, { // 103
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "Ｑ <␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ:\x15",
		out:  "Ｑ <␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ:\x15",
	}, { // 104
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "Ｑ␠<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ:\x15",
		out:  "Ｑ␠<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ:\x15",
	}, { // 105
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "Ｑ <␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ␠\x15",
		out:  "Ｑ <␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ␠\x15",
	}, { // 106
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "Ｑ␠<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ␠\x15",
		out:  "Ｑ␠<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ␠\x15",
	}, { // 107
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "Ｑ <␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ:␠",
		out:  "Ｑ <␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ:␠",
	}, { // 108
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "Ｑ␠<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ:␠",
		out:  "Ｑ␠<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ:␠",
	}, { // 109
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ＱK<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ \x15",
		out:  "ＱK<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ \x15",
	}, { // 110
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ＱK<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ␠\x15",
		out:  "ＱK<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ␠\x15",
	}, { // 111
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ＱK<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ ␠",
		out:  "ＱK<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ ␠",
	}, { // 112
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ＱK<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ␠␠",
		out:  "ＱK<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ␠␠",
	}, { // 113
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ＱK<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ: ",
		out:  "ＱK<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ: ",
	}, { // 114
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ＱK<␘βc４\x1f\nＯ L%sκ␀Ｆ／μθ＄φ＼H７Y／ρ:␠",
		out:  "ＱK<␘βc４\x1f\nＯ L%sκ‛␀Ｆ／μθ‛＄φ＼H７Y／ρ:␠",
	}, { // 115
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼＂／",
		out:  "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼‛＂／",
	}, { // 116
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   " ␠1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼＂／",
		out:  "␠␠1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼‛＂／",
	}, { // 117
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␠␠1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼＂／",
		out:  "‛␠␠1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼‛＂／",
	}, { // 118
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   " ５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼␠／",
		out:  "␠５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼␠／",
	}, { // 119
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␠５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼␠／",
		out:  "‛␠５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼␠／",
	}, { // 120
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   " ５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼＂␠",
		out:  "␠５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼‛＂␠",
	}, { // 121
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␠５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼＂␠",
		out:  "‛␠５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼‛＂␠",
	}, { // 122
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "＜ 1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼＂／",
		out:  "＜ 1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼‛＂／",
	}, { // 123
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "＜␠1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼＂／",
		out:  "＜␠1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼‛＂／",
	}, { // 124
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "＜ 1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼␠／",
		out:  "＜ 1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼␠／",
	}, { // 125
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "＜␠1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼␠／",
		out:  "＜␠1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼␠／",
	}, { // 126
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "＜ 1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼＂␠",
		out:  "＜ 1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼‛＂␠",
	}, { // 127
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "＜␠1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼＂␠",
		out:  "＜␠1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼‛＂␠",
	}, { // 128
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼ ／",
		out:  "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼ ／",
	}, { // 129
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼␠／",
		out:  "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼␠／",
	}, { // 130
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼ ␠",
		out:  "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼ ␠",
	}, { // 131
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼␠␠",
		out:  "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼␠␠",
	}, { // 132
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼＂ ",
		out:  "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼‛＂ ",
	}, { // 133
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼＂␠",
		out:  "＜５1\r␈ｄFιφη \v\n\x1e７ｔＣt␊π#υ{␁}$ξ＼‛＂␠",
	}, { // 134
		mask: EncodeColon | EncodeLeftSpace,
		in:   "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1eＧｚ",
		out:  "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1eＧｚ",
	}, { // 135
		mask: EncodeColon | EncodeLeftSpace,
		in:   " ␠／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1eＧｚ",
		out:  "␠␠／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1eＧｚ",
	}, { // 136
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␠␠／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1eＧｚ",
		out:  "‛␠␠／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1eＧｚ",
	}, { // 137
		mask: EncodeColon | EncodeLeftSpace,
		in:   " d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1e␠ｚ",
		out:  "␠d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1e␠ｚ",
	}, { // 138
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␠d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1e␠ｚ",
		out:  "‛␠d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1e␠ｚ",
	}, { // 139
		mask: EncodeColon | EncodeLeftSpace,
		in:   " d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1eＧ␠",
		out:  "␠d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1eＧ␠",
	}, { // 140
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␠d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1eＧ␠",
		out:  "‛␠d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1eＧ␠",
	}, { // 141
		mask: EncodeColon | EncodeLeftSpace,
		in:   "3 ／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1eＧｚ",
		out:  "3 ／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1eＧｚ",
	}, { // 142
		mask: EncodeColon | EncodeLeftSpace,
		in:   "3␠／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1eＧｚ",
		out:  "3␠／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1eＧｚ",
	}, { // 143
		mask: EncodeColon | EncodeLeftSpace,
		in:   "3 ／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1e␠ｚ",
		out:  "3 ／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1e␠ｚ",
	}, { // 144
		mask: EncodeColon | EncodeLeftSpace,
		in:   "3␠／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1e␠ｚ",
		out:  "3␠／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1e␠ｚ",
	}, { // 145
		mask: EncodeColon | EncodeLeftSpace,
		in:   "3 ／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1eＧ␠",
		out:  "3 ／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1eＧ␠",
	}, { // 146
		mask: EncodeColon | EncodeLeftSpace,
		in:   "3␠／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1eＧ␠",
		out:  "3␠／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1eＧ␠",
	}, { // 147
		mask: EncodeColon | EncodeLeftSpace,
		in:   "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1e ｚ",
		out:  "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1e ｚ",
	}, { // 148
		mask: EncodeColon | EncodeLeftSpace,
		in:   "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1e␠ｚ",
		out:  "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1e␠ｚ",
	}, { // 149
		mask: EncodeColon | EncodeLeftSpace,
		in:   "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1e ␠",
		out:  "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1e ␠",
	}, { // 150
		mask: EncodeColon | EncodeLeftSpace,
		in:   "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1e␠␠",
		out:  "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1e␠␠",
	}, { // 151
		mask: EncodeColon | EncodeLeftSpace,
		in:   "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1eＧ ",
		out:  "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1eＧ ",
	}, { // 152
		mask: EncodeColon | EncodeLeftSpace,
		in:   "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ：\vλ\x15\x1eＧ␠",
		out:  "3d／\x15｜ο␊ρρ\x14 ␖ｑ␍％\\β%Ｋ8␊Tσ‛：\vλ\x15\x1eＧ␠",
	}, { // 153
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβＥ",
		out:  "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβＥ",
	}, { // 154
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   " ␠␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβＥ",
		out:  "␠␠␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβＥ",
	}, { // 155
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "␠␠␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβＥ",
		out:  "‛␠␠␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβＥ",
	}, { // 156
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   " T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT␠Ｅ",
		out:  "␠T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT␠Ｅ",
	}, { // 157
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "␠T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT␠Ｅ",
		out:  "‛␠T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT␠Ｅ",
	}, { // 158
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   " T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβ␠",
		out:  "␠T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβ␠",
	}, { // 159
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "␠T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβ␠",
		out:  "‛␠T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβ␠",
	}, { // 160
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "\uff00 ␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβＥ",
		out:  "\uff00 ␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβＥ",
	}, { // 161
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "\uff00␠␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβＥ",
		out:  "\uff00␠␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβＥ",
	}, { // 162
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "\uff00 ␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT␠Ｅ",
		out:  "\uff00 ␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT␠Ｅ",
	}, { // 163
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "\uff00␠␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT␠Ｅ",
		out:  "\uff00␠␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT␠Ｅ",
	}, { // 164
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "\uff00 ␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβ␠",
		out:  "\uff00 ␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβ␠",
	}, { // 165
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "\uff00␠␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβ␠",
		out:  "\uff00␠␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβ␠",
	}, { // 166
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT Ｅ",
		out:  "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT Ｅ",
	}, { // 167
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT␠Ｅ",
		out:  "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT␠Ｅ",
	}, { // 168
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT ␠",
		out:  "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT ␠",
	}, { // 169
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT␠␠",
		out:  "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οT␠␠",
	}, { // 170
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβ ",
		out:  "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβ ",
	}, { // 171
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβ␠",
		out:  "\uff00T␟\uff00\"c\"ηη␊ ␌v％␂9\fεＭ␒\u007f｀\x1eＯ[\x06οTβ␠",
	}, { // 172
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟ｑ",
		out:  "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟ｑ",
	}, { // 173
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   " ␠␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟ｑ",
		out:  "␠␠␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟ｑ",
	}, { // 174
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "␠␠␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟ｑ",
		out:  "‛␠␠␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟ｑ",
	}, { // 175
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   " ｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␠ｑ",
		out:  "␠ｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␠ｑ",
	}, { // 176
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "␠ｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␠ｑ",
		out:  "‛␠ｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␠ｑ",
	}, { // 177
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   " ｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟␠",
		out:  "␠ｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟␠",
	}, { // 178
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "␠ｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟␠",
		out:  "‛␠ｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟␠",
	}, { // 179
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "γ ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟ｑ",
		out:  "γ ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟ｑ",
	}, { // 180
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "γ␠␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟ｑ",
		out:  "γ␠␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟ｑ",
	}, { // 181
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "γ ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␠ｑ",
		out:  "γ ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␠ｑ",
	}, { // 182
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "γ␠␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␠ｑ",
		out:  "γ␠␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␠ｑ",
	}, { // 183
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "γ ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟␠",
		out:  "γ ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟␠",
	}, { // 184
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "γ␠␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟␠",
		out:  "γ␠␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟␠",
	}, { // 185
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν ｑ",
		out:  "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν ｑ",
	}, { // 186
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␠ｑ",
		out:  "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␠ｑ",
	}, { // 187
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν ␠",
		out:  "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν ␠",
	}, { // 188
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␠␠",
		out:  "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␠␠",
	}, { // 189
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟ ",
		out:  "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟ ",
	}, { // 190
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟␠",
		out:  "γｕ␎ａＣ\aX\x19|/ ξ＼<1λ␍?␃jｉhφδ␐=\x1cν␟␠",
	}, { // 191
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c\"",
		out:  "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c\"",
	}, { // 192
		mask: EncodePipe | EncodeLeftSpace,
		in:   " ␠\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c\"",
		out:  "␠␠\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c\"",
	}, { // 193
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␠␠\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c\"",
		out:  "‛␠␠\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c\"",
	}, { // 194
		mask: EncodePipe | EncodeLeftSpace,
		in:   " Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃␠\"",
		out:  "␠Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃␠\"",
	}, { // 195
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␠Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃␠\"",
		out:  "‛␠Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃␠\"",
	}, { // 196
		mask: EncodePipe | EncodeLeftSpace,
		in:   " Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c␠",
		out:  "␠Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c␠",
	}, { // 197
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␠Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c␠",
		out:  "‛␠Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c␠",
	}, { // 198
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␛ \x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c\"",
		out:  "␛ \x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c\"",
	}, { // 199
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␛␠\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c\"",
		out:  "␛␠\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c\"",
	}, { // 200
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␛ \x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃␠\"",
		out:  "␛ \x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃␠\"",
	}, { // 201
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␛␠\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃␠\"",
		out:  "␛␠\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃␠\"",
	}, { // 202
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␛ \x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c␠",
		out:  "␛ \x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c␠",
	}, { // 203
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␛␠\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c␠",
		out:  "␛␠\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c␠",
	}, { // 204
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃ \"",
		out:  "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃ \"",
	}, { // 205
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃␠\"",
		out:  "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃␠\"",
	}, { // 206
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃ ␠",
		out:  "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃ ␠",
	}, { // 207
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃␠␠",
		out:  "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃␠␠",
	}, { // 208
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c ",
		out:  "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c ",
	}, { // 209
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c␠",
		out:  "␛Ｋ\x18\x1d␌␉θTUＥ ␌\x04ｅ/ιχχＱ~ρF␄\"ｖ␍ξ＃\x1c␠",
	}, { // 210
		mask: EncodeHash | EncodeLeftSpace,
		in:   "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␇",
		out:  "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␇",
	}, { // 211
		mask: EncodeHash | EncodeLeftSpace,
		in:   " ␠␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␇",
		out:  "␠␠␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␇",
	}, { // 212
		mask: EncodeHash | EncodeLeftSpace,
		in:   "␠␠␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␇",
		out:  "‛␠␠␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␇",
	}, { // 213
		mask: EncodeHash | EncodeLeftSpace,
		in:   " ＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r␠␇",
		out:  "␠＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r␠␇",
	}, { // 214
		mask: EncodeHash | EncodeLeftSpace,
		in:   "␠＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r␠␇",
		out:  "‛␠＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r␠␇",
	}, { // 215
		mask: EncodeHash | EncodeLeftSpace,
		in:   " ＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␠",
		out:  "␠＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␠",
	}, { // 216
		mask: EncodeHash | EncodeLeftSpace,
		in:   "␠＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␠",
		out:  "‛␠＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␠",
	}, { // 217
		mask: EncodeHash | EncodeLeftSpace,
		in:   "j ␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␇",
		out:  "j ␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␇",
	}, { // 218
		mask: EncodeHash | EncodeLeftSpace,
		in:   "j␠␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␇",
		out:  "j␠␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␇",
	}, { // 219
		mask: EncodeHash | EncodeLeftSpace,
		in:   "j ␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r␠␇",
		out:  "j ␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r␠␇",
	}, { // 220
		mask: EncodeHash | EncodeLeftSpace,
		in:   "j␠␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r␠␇",
		out:  "j␠␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r␠␇",
	}, { // 221
		mask: EncodeHash | EncodeLeftSpace,
		in:   "j ␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␠",
		out:  "j ␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␠",
	}, { // 222
		mask: EncodeHash | EncodeLeftSpace,
		in:   "j␠␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␠",
		out:  "j␠␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␠",
	}, { // 223
		mask: EncodeHash | EncodeLeftSpace,
		in:   "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r ␇",
		out:  "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r ␇",
	}, { // 224
		mask: EncodeHash | EncodeLeftSpace,
		in:   "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r␠␇",
		out:  "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r␠␇",
	}, { // 225
		mask: EncodeHash | EncodeLeftSpace,
		in:   "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r ␠",
		out:  "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r ␠",
	}, { // 226
		mask: EncodeHash | EncodeLeftSpace,
		in:   "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r␠␠",
		out:  "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r␠␠",
	}, { // 227
		mask: EncodeHash | EncodeLeftSpace,
		in:   "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a ",
		out:  "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a ",
	}, { // 228
		mask: EncodeHash | EncodeLeftSpace,
		in:   "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␠",
		out:  "j＜␋␟␟QＸｈρδ θTＶσ>Ｄ␛\x13γ$<ｖ\x1eJ\\ο\r\a␠",
	}, { // 229
		mask: EncodePercent | EncodeLeftSpace,
		in:   "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ+",
		out:  "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ+",
	}, { // 230
		mask: EncodePercent | EncodeLeftSpace,
		in:   " ␠＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ+",
		out:  "␠␠＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ+",
	}, { // 231
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␠␠＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ+",
		out:  "‛␠␠＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ+",
	}, { // 232
		mask: EncodePercent | EncodeLeftSpace,
		in:   " χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ␠+",
		out:  "␠χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ␠+",
	}, { // 233
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␠χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ␠+",
		out:  "‛␠χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ␠+",
	}, { // 234
		mask: EncodePercent | EncodeLeftSpace,
		in:   " χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ␠",
		out:  "␠χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ␠",
	}, { // 235
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␠χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ␠",
		out:  "‛␠χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ␠",
	}, { // 236
		mask: EncodePercent | EncodeLeftSpace,
		in:   "4 ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ+",
		out:  "4 ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ+",
	}, { // 237
		mask: EncodePercent | EncodeLeftSpace,
		in:   "4␠＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ+",
		out:  "4␠＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ+",
	}, { // 238
		mask: EncodePercent | EncodeLeftSpace,
		in:   "4 ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ␠+",
		out:  "4 ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ␠+",
	}, { // 239
		mask: EncodePercent | EncodeLeftSpace,
		in:   "4␠＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ␠+",
		out:  "4␠＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ␠+",
	}, { // 240
		mask: EncodePercent | EncodeLeftSpace,
		in:   "4 ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ␠",
		out:  "4 ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ␠",
	}, { // 241
		mask: EncodePercent | EncodeLeftSpace,
		in:   "4␠＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ␠",
		out:  "4␠＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ␠",
	}, { // 242
		mask: EncodePercent | EncodeLeftSpace,
		in:   "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ +",
		out:  "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ +",
	}, { // 243
		mask: EncodePercent | EncodeLeftSpace,
		in:   "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ␠+",
		out:  "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ␠+",
	}, { // 244
		mask: EncodePercent | EncodeLeftSpace,
		in:   "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ ␠",
		out:  "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ ␠",
	}, { // 245
		mask: EncodePercent | EncodeLeftSpace,
		in:   "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ␠␠",
		out:  "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍ␠␠",
	}, { // 246
		mask: EncodePercent | EncodeLeftSpace,
		in:   "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ ",
		out:  "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ ",
	}, { // 247
		mask: EncodePercent | EncodeLeftSpace,
		in:   "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ␠",
		out:  "4χ＼KＯ）πσ＂r ／sπ␉␄ｖ>\x16β\x11\x17\rN＂␇\x04ｍｅ␠",
	}, { // 248
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "Dg＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D\x1c",
		out:  "Dg＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D\x1c",
	}, { // 249
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " ␠＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D\x1c",
		out:  "␠␠＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D\x1c",
	}, { // 250
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠␠＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D\x1c",
		out:  "‛␠␠＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D\x1c",
	}, { // 251
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " g＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇␠\x1c",
		out:  "␠g＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇␠\x1c",
	}, { // 252
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠g＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇␠\x1c",
		out:  "‛␠g＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇␠\x1c",
	}, { // 253
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " g＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D␠",
		out:  "␠g＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D␠",
	}, { // 254
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠g＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D␠",
		out:  "‛␠g＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D␠",
	}, { // 255
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "D ＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D\x1c",
		out:  "D ＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D\x1c",
	}, { // 256
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "D␠＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D\x1c",
		out:  "D␠＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D\x1c",
	}, { // 257
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "D ＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇␠\x1c",
		out:  "D ＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇␠\x1c",
	}, { // 258
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "D␠＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇␠\x1c",
		out:  "D␠＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇␠\x1c",
	}, { // 259
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "D ＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D␠",
		out:  "D ＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D␠",
	}, { // 260
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "D␠＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D␠",
		out:  "D␠＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D␠",
	}, { // 261
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "Dg＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇ \x1c",
		out:  "Dg＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇ \x1c",
	}, { // 262
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "Dg＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇␠\x1c",
		out:  "Dg＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇␠\x1c",
	}, { // 263
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "Dg＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇ ␠",
		out:  "Dg＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇ ␠",
	}, { // 264
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "Dg＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇␠␠",
		out:  "Dg＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇␠␠",
	}, { // 265
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "Dg＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D ",
		out:  "Dg＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D ",
	}, { // 266
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "Dg＇*／ξδχ␌\\ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D␠",
		out:  "Dg＇*／ξδχ␌＼ vμ\u007f␒νｒ\v５\tv␅εＪ␕ｔＣ＇D␠",
	}, { // 267
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ＾",
		out:  "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ＾",
	}, { // 268
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   " ␠ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ＾",
		out:  "␠␠ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ＾",
	}, { // 269
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "␠␠ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ＾",
		out:  "‛␠␠ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ＾",
	}, { // 270
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   " ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!␠＾",
		out:  "␠␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!␠＾",
	}, { // 271
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "␠␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!␠＾",
		out:  "‛␠␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!␠＾",
	}, { // 272
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   " ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ␠",
		out:  "␠␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ␠",
	}, { // 273
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "␠␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ␠",
		out:  "‛␠␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ␠",
	}, { // 274
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ｓ ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ＾",
		out:  "ｓ ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ＾",
	}, { // 275
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ｓ␠ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ＾",
		out:  "ｓ␠ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ＾",
	}, { // 276
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ｓ ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!␠＾",
		out:  "ｓ ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!␠＾",
	}, { // 277
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ｓ␠ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!␠＾",
		out:  "ｓ␠ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!␠＾",
	}, { // 278
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ｓ ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ␠",
		out:  "ｓ ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ␠",
	}, { // 279
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ｓ␠ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ␠",
		out:  "ｓ␠ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ␠",
	}, { // 280
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃! ＾",
		out:  "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃! ＾",
	}, { // 281
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!␠＾",
		out:  "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!␠＾",
	}, { // 282
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃! ␠",
		out:  "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃! ␠",
	}, { // 283
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!␠␠",
		out:  "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!␠␠",
	}, { // 284
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ ",
		out:  "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ ",
	}, { // 285
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ␠",
		out:  "ｓ␕ψυX２\u007fθ＂␕ `κｐ＄ω␁\u007f3\x0f\x10P]E\f␆␃!μ␠",
	}, { // 286
		mask: EncodeDel | EncodeLeftSpace,
		in:   "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~hＦ",
		out:  "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~hＦ",
	}, { // 287
		mask: EncodeDel | EncodeLeftSpace,
		in:   " ␠␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~hＦ",
		out:  "␠␠␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~hＦ",
	}, { // 288
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠␠␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~hＦ",
		out:  "‛␠␠␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~hＦ",
	}, { // 289
		mask: EncodeDel | EncodeLeftSpace,
		in:   " ω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~␠Ｆ",
		out:  "␠ω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~␠Ｆ",
	}, { // 290
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠ω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~␠Ｆ",
		out:  "‛␠ω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~␠Ｆ",
	}, { // 291
		mask: EncodeDel | EncodeLeftSpace,
		in:   " ω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~h␠",
		out:  "␠ω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~h␠",
	}, { // 292
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠ω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~h␠",
		out:  "‛␠ω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~h␠",
	}, { // 293
		mask: EncodeDel | EncodeLeftSpace,
		in:   "Ｒ ␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~hＦ",
		out:  "Ｒ ␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~hＦ",
	}, { // 294
		mask: EncodeDel | EncodeLeftSpace,
		in:   "Ｒ␠␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~hＦ",
		out:  "Ｒ␠␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~hＦ",
	}, { // 295
		mask: EncodeDel | EncodeLeftSpace,
		in:   "Ｒ ␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~␠Ｆ",
		out:  "Ｒ ␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~␠Ｆ",
	}, { // 296
		mask: EncodeDel | EncodeLeftSpace,
		in:   "Ｒ␠␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~␠Ｆ",
		out:  "Ｒ␠␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~␠Ｆ",
	}, { // 297
		mask: EncodeDel | EncodeLeftSpace,
		in:   "Ｒ ␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~h␠",
		out:  "Ｒ ␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~h␠",
	}, { // 298
		mask: EncodeDel | EncodeLeftSpace,
		in:   "Ｒ␠␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~h␠",
		out:  "Ｒ␠␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~h␠",
	}, { // 299
		mask: EncodeDel | EncodeLeftSpace,
		in:   "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~ Ｆ",
		out:  "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~ Ｆ",
	}, { // 300
		mask: EncodeDel | EncodeLeftSpace,
		in:   "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~␠Ｆ",
		out:  "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~␠Ｆ",
	}, { // 301
		mask: EncodeDel | EncodeLeftSpace,
		in:   "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~ ␠",
		out:  "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~ ␠",
	}, { // 302
		mask: EncodeDel | EncodeLeftSpace,
		in:   "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~␠␠",
		out:  "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~␠␠",
	}, { // 303
		mask: EncodeDel | EncodeLeftSpace,
		in:   "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~h ",
		out:  "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~h ",
	}, { // 304
		mask: EncodeDel | EncodeLeftSpace,
		in:   "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ\u007f␘６~h␠",
		out:  "Ｒω␉\x1a␅*(ω｜\x04 ξD␓：ω␑\x1b@D６β；κ␡␘６~h␠",
	}, { // 305
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "＞\f␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇη＂",
		out:  "＞␌‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇη＂",
	}, { // 306
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " ␠␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇη＂",
		out:  "␠␠‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇη＂",
	}, { // 307
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠␠␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇη＂",
		out:  "‛␠␠‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇη＂",
	}, { // 308
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " \f␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇ␠＂",
		out:  "␠␌‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇ␠＂",
	}, { // 309
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠\f␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇ␠＂",
		out:  "‛␠␌‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇ␠＂",
	}, { // 310
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " \f␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇη␠",
		out:  "␠␌‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇη␠",
	}, { // 311
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠\f␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇη␠",
		out:  "‛␠␌‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇη␠",
	}, { // 312
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "＞ ␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇη＂",
		out:  "＞ ‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇη＂",
	}, { // 313
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "＞␠␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇη＂",
		out:  "＞␠‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇη＂",
	}, { // 314
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "＞ ␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇ␠＂",
		out:  "＞ ‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇ␠＂",
	}, { // 315
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "＞␠␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇ␠＂",
		out:  "＞␠‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇ␠＂",
	}, { // 316
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "＞ ␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇη␠",
		out:  "＞ ‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇη␠",
	}, { // 317
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "＞␠␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇη␠",
		out:  "＞␠‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇη␠",
	}, { // 318
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "＞\f␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇ ＂",
		out:  "＞␌‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇ ＂",
	}, { // 319
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "＞\f␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇ␠＂",
		out:  "＞␌‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇ␠＂",
	}, { // 320
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "＞\f␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇ ␠",
		out:  "＞␌‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇ ␠",
	}, { // 321
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "＞\f␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇ␠␠",
		out:  "＞␌‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇ␠␠",
	}, { // 322
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "＞\f␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇη ",
		out:  "＞␌‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇη ",
	}, { // 323
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "＞\f␐\rλα␘<␚: *Ｕ\\E␗\x01␘b\aＺμ\bπ|ξ＆Ｇη␠",
		out:  "＞␌‛␐␍λα‛␘<‛␚: *Ｕ\\E‛␗␁‛␘b␇Ｚμ␈π|ξ＆Ｇη␠",
	}, { // 324
		mask: EncodeLeftPeriod,
		in:   ".",
		out:  "．",
	}, { // 325
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f␂",
		out:  "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f␂",
	}, { // 326
		mask: EncodeZero | EncodeLeftPeriod,
		in:   ".．'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f␂",
		out:  "．．'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f␂",
	}, { // 327
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "．．'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f␂",
		out:  "‛．．'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f␂",
	}, { // 328
		mask: EncodeZero | EncodeLeftPeriod,
		in:   ".\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖．␂",
		out:  "．\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖．␂",
	}, { // 329
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "．\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖．␂",
		out:  "‛．\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖．␂",
	}, { // 330
		mask: EncodeZero | EncodeLeftPeriod,
		in:   ".\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f．",
		out:  "．\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f．",
	}, { // 331
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "．\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f．",
		out:  "‛．\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f．",
	}, { // 332
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "ｃ.'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f␂",
		out:  "ｃ.'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f␂",
	}, { // 333
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "ｃ．'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f␂",
		out:  "ｃ．'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f␂",
	}, { // 334
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "ｃ.'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖．␂",
		out:  "ｃ.'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖．␂",
	}, { // 335
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "ｃ．'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖．␂",
		out:  "ｃ．'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖．␂",
	}, { // 336
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "ｃ.'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f．",
		out:  "ｃ.'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f．",
	}, { // 337
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "ｃ．'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f．",
		out:  "ｃ．'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f．",
	}, { // 338
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖.␂",
		out:  "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖.␂",
	}, { // 339
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖．␂",
		out:  "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖．␂",
	}, { // 340
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖.．",
		out:  "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖.．",
	}, { // 341
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖．．",
		out:  "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖．．",
	}, { // 342
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f.",
		out:  "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f.",
	}, { // 343
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f．",
		out:  "ｃ\x17'Ｓ␄\x1eα｜｀s.εL\x18９^αｂ{η\x12␡λｐF\u007fτ␖\u007f．",
	}, { // 344
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "πi␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03A,",
		out:  "πi␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03A,",
	}, { // 345
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ".．␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03A,",
		out:  "．．␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03A,",
	}, { // 346
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "．．␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03A,",
		out:  "‛．．␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03A,",
	}, { // 347
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ".i␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03．,",
		out:  "．i␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03．,",
	}, { // 348
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "．i␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03．,",
		out:  "‛．i␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03．,",
	}, { // 349
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ".i␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03A．",
		out:  "．i␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03A．",
	}, { // 350
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "．i␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03A．",
		out:  "‛．i␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03A．",
	}, { // 351
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "π.␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03A,",
		out:  "π.␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03A,",
	}, { // 352
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "π．␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03A,",
		out:  "π．␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03A,",
	}, { // 353
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "π.␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03．,",
		out:  "π.␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03．,",
	}, { // 354
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "π．␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03．,",
		out:  "π．␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03．,",
	}, { // 355
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "π.␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03A．",
		out:  "π.␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03A．",
	}, { // 356
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "π．␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03A．",
		out:  "π．␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03A．",
	}, { // 357
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "πi␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03.,",
		out:  "πi␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03.,",
	}, { // 358
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "πi␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03．,",
		out:  "πi␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03．,",
	}, { // 359
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "πi␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03.．",
		out:  "πi␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03.．",
	}, { // 360
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "πi␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03．．",
		out:  "πi␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03．．",
	}, { // 361
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "πi␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03A.",
		out:  "πi␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03A.",
	}, { // 362
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "πi␄αｂ\r:|bδ.ｍ｜＠θ／␟␡\b{＞\x03␔９τ＆C\x03A．",
		out:  "πi␄αｂ\r:|bδ.ｍ｜＠θ‛／␟␡\b{＞\x03␔９τ＆C\x03A．",
	}, { // 363
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υο",
		out:  "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υο",
	}, { // 364
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   ".．;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υο",
		out:  "．．;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υο",
	}, { // 365
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "．．;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υο",
		out:  "‛．．;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υο",
	}, { // 366
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   ".＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾．ο",
		out:  "．＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾．ο",
	}, { // 367
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "．＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾．ο",
		out:  "‛．＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾．ο",
	}, { // 368
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   ".＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υ．",
		out:  "．＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υ．",
	}, { // 369
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "．＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υ．",
		out:  "‛．＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υ．",
	}, { // 370
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ν.;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υο",
		out:  "ν.;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υο",
	}, { // 371
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ν．;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υο",
		out:  "ν．;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υο",
	}, { // 372
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ν.;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾．ο",
		out:  "ν.;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾．ο",
	}, { // 373
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ν．;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾．ο",
		out:  "ν．;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾．ο",
	}, { // 374
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ν.;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υ．",
		out:  "ν.;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υ．",
	}, { // 375
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ν．;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υ．",
		out:  "ν．;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υ．",
	}, { // 376
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾.ο",
		out:  "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾.ο",
	}, { // 377
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾．ο",
		out:  "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾．ο",
	}, { // 378
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾.．",
		out:  "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾.．",
	}, { // 379
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾．．",
		out:  "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾．．",
	}, { // 380
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υ.",
		out:  "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υ.",
	}, { // 381
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υ．",
		out:  "ν＃;3␁\r＊１PE.＃τXβＴ\r\r\x01*η\f２Ｍ␉␞ｏ＾υ．",
	}, { // 382
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［<",
		out:  "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［<",
	}, { // 383
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   ".．'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［<",
		out:  "．．'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［<",
	}, { // 384
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "．．'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［<",
		out:  "‛．．'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［<",
	}, { // 385
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   ".ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘．<",
		out:  "．ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘．<",
	}, { // 386
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "．ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘．<",
		out:  "‛．ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘．<",
	}, { // 387
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   ".ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［．",
		out:  "．ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［．",
	}, { // 388
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "．ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［．",
		out:  "‛．ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［．",
	}, { // 389
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\x16.'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［<",
		out:  "\x16.'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［<",
	}, { // 390
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\x16．'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［<",
		out:  "\x16．'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［<",
	}, { // 391
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\x16.'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘．<",
		out:  "\x16.'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘．<",
	}, { // 392
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\x16．'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘．<",
		out:  "\x16．'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘．<",
	}, { // 393
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\x16.'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［．",
		out:  "\x16.'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［．",
	}, { // 394
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\x16．'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［．",
		out:  "\x16．'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［．",
	}, { // 395
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘.<",
		out:  "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘.<",
	}, { // 396
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘．<",
		out:  "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘．<",
	}, { // 397
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘.．",
		out:  "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘.．",
	}, { // 398
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘．．",
		out:  "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘．．",
	}, { // 399
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［.",
		out:  "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［.",
	}, { // 400
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［．",
		out:  "\x16ε'k?～ιｐ／Ｖ.yτ\\8?6Ｊ\\␏␈α␝λ8（ς␘［．",
	}, { // 401
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_τ",
		out:  "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_τ",
	}, { // 402
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   ".．υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_τ",
		out:  "．．υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_τ",
	}, { // 403
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "．．υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_τ",
		out:  "‛．．υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_τ",
	}, { // 404
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   ".＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m．τ",
		out:  "．＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m．τ",
	}, { // 405
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "．＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m．τ",
		out:  "‛．＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m．τ",
	}, { // 406
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   ".＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_．",
		out:  "．＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_．",
	}, { // 407
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "．＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_．",
		out:  "‛．＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_．",
	}, { // 408
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\a.υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_τ",
		out:  "\a.υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_τ",
	}, { // 409
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\a．υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_τ",
		out:  "\a．υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_τ",
	}, { // 410
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\a.υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m．τ",
		out:  "\a.υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m．τ",
	}, { // 411
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\a．υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m．τ",
		out:  "\a．υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m．τ",
	}, { // 412
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\a.υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_．",
		out:  "\a.υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_．",
	}, { // 413
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\a．υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_．",
		out:  "\a．υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_．",
	}, { // 414
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m.τ",
		out:  "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m.τ",
	}, { // 415
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m．τ",
		out:  "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m．τ",
	}, { // 416
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m.．",
		out:  "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m.．",
	}, { // 417
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m．．",
		out:  "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m．．",
	}, { // 418
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_.",
		out:  "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_.",
	}, { // 419
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_．",
		out:  "\a＄υ␊␙κvＹ－\x10.ωK｜␕ｖｍ\rς%\vIδb＆\n５m_．",
	}, { // 420
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x10rc␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎχ2",
		out:  "\x10rc␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎχ2",
	}, { // 421
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   ".．c␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎχ2",
		out:  "．．c␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎχ2",
	}, { // 422
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "．．c␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎχ2",
		out:  "‛．．c␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎχ2",
	}, { // 423
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   ".rc␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎ．2",
		out:  "．rc␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎ．2",
	}, { // 424
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "．rc␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎ．2",
		out:  "‛．rc␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎ．2",
	}, { // 425
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   ".rc␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎχ．",
		out:  "．rc␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎχ．",
	}, { // 426
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "．rc␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎχ．",
		out:  "‛．rc␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎχ．",
	}, { // 427
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x10.c␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎχ2",
		out:  "\x10.c␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎχ2",
	}, { // 428
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x10．c␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎχ2",
		out:  "\x10．c␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎχ2",
	}, { // 429
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x10.c␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎ．2",
		out:  "\x10.c␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎ．2",
	}, { // 430
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x10．c␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎ．2",
		out:  "\x10．c␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎ．2",
	}, { // 431
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x10.c␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎχ．",
		out:  "\x10.c␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎχ．",
	}, { // 432
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x10．c␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎχ．",
		out:  "\x10．c␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎχ．",
	}, { // 433
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x10rc␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎ.2",
		out:  "\x10rc␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎ.2",
	}, { // 434
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x10rc␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎ．2",
		out:  "\x10rc␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎ．2",
	}, { // 435
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x10rc␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎ.．",
		out:  "\x10rc␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎ.．",
	}, { // 436
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x10rc␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎ．．",
		out:  "\x10rc␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎ．．",
	}, { // 437
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x10rc␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎχ.",
		out:  "\x10rc␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎχ.",
	}, { // 438
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x10rc␞B\r］ξ\x0e\v.␙Ｆ$XＥξ：\nθ␜＿␙μ%␛␍Ｎχ．",
		out:  "\x10rc␞B\r］ξ\x0e\v.␙Ｆ＄XＥξ：\nθ␜＿␙μ%␛␍Ｎχ．",
	}, { // 439
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "~/\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘>μ",
		out:  "~/\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘>μ",
	}, { // 440
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   ".．\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘>μ",
		out:  "．．\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘>μ",
	}, { // 441
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "．．\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘>μ",
		out:  "‛．．\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘>μ",
	}, { // 442
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "./\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘．μ",
		out:  "．/\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘．μ",
	}, { // 443
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "．/\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘．μ",
		out:  "‛．/\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘．μ",
	}, { // 444
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "./\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘>．",
		out:  "．/\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘>．",
	}, { // 445
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "．/\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘>．",
		out:  "‛．/\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘>．",
	}, { // 446
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "~.\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘>μ",
		out:  "~.\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘>μ",
	}, { // 447
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "~．\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘>μ",
		out:  "~．\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘>μ",
	}, { // 448
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "~.\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘．μ",
		out:  "~.\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘．μ",
	}, { // 449
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "~．\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘．μ",
		out:  "~．\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘．μ",
	}, { // 450
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "~.\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘>．",
		out:  "~.\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘>．",
	}, { // 451
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "~．\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘>．",
		out:  "~．\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘>．",
	}, { // 452
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "~/\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘.μ",
		out:  "~/\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘.μ",
	}, { // 453
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "~/\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘．μ",
		out:  "~/\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘．μ",
	}, { // 454
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "~/\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘.．",
		out:  "~/\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘.．",
	}, { // 455
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "~/\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘．．",
		out:  "~/\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘．．",
	}, { // 456
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "~/\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘>.",
		out:  "~/\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘>.",
	}, { // 457
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "~/\x1d\x00␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n＂Ｋ␘>．",
		out:  "~/\x1d␀␍％|+␡ｎ.τＭς␍π＿ccＩλn\v␍\n‛＂Ｋ␘>．",
	}, { // 458
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5␋",
		out:  "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5␋",
	}, { // 459
		mask: EncodeColon | EncodeLeftPeriod,
		in:   ".．？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5␋",
		out:  "．．？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5␋",
	}, { // 460
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "．．？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5␋",
		out:  "‛．．？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5␋",
	}, { // 461
		mask: EncodeColon | EncodeLeftPeriod,
		in:   ".3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜．␋",
		out:  "．3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜．␋",
	}, { // 462
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "．3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜．␋",
		out:  "‛．3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜．␋",
	}, { // 463
		mask: EncodeColon | EncodeLeftPeriod,
		in:   ".3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5．",
		out:  "．3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5．",
	}, { // 464
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "．3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5．",
		out:  "‛．3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5．",
	}, { // 465
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "σ.？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5␋",
		out:  "σ.？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5␋",
	}, { // 466
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "σ．？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5␋",
		out:  "σ．？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5␋",
	}, { // 467
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "σ.？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜．␋",
		out:  "σ.？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜．␋",
	}, { // 468
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "σ．？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜．␋",
		out:  "σ．？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜．␋",
	}, { // 469
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "σ.？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5．",
		out:  "σ.？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5．",
	}, { // 470
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "σ．？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5．",
		out:  "σ．？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5．",
	}, { // 471
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜.␋",
		out:  "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜.␋",
	}, { // 472
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜．␋",
		out:  "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜．␋",
	}, { // 473
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜.．",
		out:  "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜.．",
	}, { // 474
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜．．",
		out:  "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜．．",
	}, { // 475
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5.",
		out:  "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5.",
	}, { // 476
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5．",
		out:  "σ3？λｏ\f\uff00ｓ␊\t./ρgｒ5Ｇ／\x17\x13ηP'Vβζ␟＜5．",
	}, { // 477
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η\"",
		out:  "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η\"",
	}, { // 478
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   ".．W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η\"",
		out:  "．．W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η\"",
	}, { // 479
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "．．W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η\"",
		out:  "‛．．W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η\"",
	}, { // 480
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   ".τW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏．\"",
		out:  "．τW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏．\"",
	}, { // 481
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "．τW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏．\"",
		out:  "‛．τW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏．\"",
	}, { // 482
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   ".τW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η．",
		out:  "．τW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η．",
	}, { // 483
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "．τW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η．",
		out:  "‛．τW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η．",
	}, { // 484
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "ｘ.W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η\"",
		out:  "ｘ.W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η\"",
	}, { // 485
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "ｘ．W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η\"",
		out:  "ｘ．W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η\"",
	}, { // 486
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "ｘ.W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏．\"",
		out:  "ｘ.W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏．\"",
	}, { // 487
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "ｘ．W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏．\"",
		out:  "ｘ．W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏．\"",
	}, { // 488
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "ｘ.W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η．",
		out:  "ｘ.W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η．",
	}, { // 489
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "ｘ．W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η．",
		out:  "ｘ．W３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η．",
	}, { // 490
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏.\"",
		out:  "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏.\"",
	}, { // 491
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏．\"",
		out:  "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏．\"",
	}, { // 492
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏.．",
		out:  "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏.．",
	}, { // 493
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏．．",
		out:  "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏．．",
	}, { // 494
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η.",
		out:  "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η.",
	}, { // 495
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η．",
		out:  "ｘτW３π；\x14␖␃Ｐ..4\x1a␂τａμ/Ｐ\x03\"\x1e/␂0υ␏η．",
	}, { // 496
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５：",
		out:  "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５：",
	}, { // 497
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   ".．＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５：",
		out:  "．．＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５：",
	}, { // 498
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "．．＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５：",
		out:  "‛．．＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５：",
	}, { // 499
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   ".ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕．：",
		out:  "．ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕．：",
	}, { // 500
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "．ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕．：",
		out:  "‛．ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕．：",
	}, { // 501
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   ".ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５．",
		out:  "．ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５．",
	}, { // 502
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "．ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５．",
		out:  "‛．ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５．",
	}, { // 503
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "␙.＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５：",
		out:  "␙.＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５：",
	}, { // 504
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "␙．＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５：",
		out:  "␙．＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５：",
	}, { // 505
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "␙.＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕．：",
		out:  "␙.＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕．：",
	}, { // 506
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "␙．＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕．：",
		out:  "␙．＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕．：",
	}, { // 507
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "␙.＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５．",
		out:  "␙.＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５．",
	}, { // 508
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "␙．＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５．",
		out:  "␙．＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５．",
	}, { // 509
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕.：",
		out:  "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕.：",
	}, { // 510
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕．：",
		out:  "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕．：",
	}, { // 511
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕.．",
		out:  "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕.．",
	}, { // 512
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕．．",
		out:  "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕．．",
	}, { // 513
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５.",
		out:  "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５.",
	}, { // 514
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５．",
		out:  "␙ψ＂␒?␇X|<a.ｒＱ5/χ０ζφ\nｉψ\x17\bφH％␕５．",
	}, { // 515
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "＝=\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜)m",
		out:  "＝=␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜)m",
	}, { // 516
		mask: EncodePipe | EncodeLeftPeriod,
		in:   ".．\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜)m",
		out:  "．．␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜)m",
	}, { // 517
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．．\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜)m",
		out:  "‛．．␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜)m",
	}, { // 518
		mask: EncodePipe | EncodeLeftPeriod,
		in:   ".=\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜．m",
		out:  "．=␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜．m",
	}, { // 519
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．=\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜．m",
		out:  "‛．=␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜．m",
	}, { // 520
		mask: EncodePipe | EncodeLeftPeriod,
		in:   ".=\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜)．",
		out:  "．=␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜)．",
	}, { // 521
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．=\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜)．",
		out:  "‛．=␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜)．",
	}, { // 522
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "＝.\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜)m",
		out:  "＝.␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜)m",
	}, { // 523
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "＝．\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜)m",
		out:  "＝．␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜)m",
	}, { // 524
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "＝.\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜．m",
		out:  "＝.␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜．m",
	}, { // 525
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "＝．\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜．m",
		out:  "＝．␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜．m",
	}, { // 526
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "＝.\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜)．",
		out:  "＝.␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜)．",
	}, { // 527
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "＝．\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜)．",
		out:  "＝．␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜)．",
	}, { // 528
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "＝=\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜.m",
		out:  "＝=␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜.m",
	}, { // 529
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "＝=\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜．m",
		out:  "＝=␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜．m",
	}, { // 530
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "＝=\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜.．",
		out:  "＝=␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜.．",
	}, { // 531
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "＝=\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜．．",
		out:  "＝=␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜．．",
	}, { // 532
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "＝=\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜).",
		out:  "＝=␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜).",
	}, { // 533
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "＝=\x00ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/｜)．",
		out:  "＝=␀ｆθr␌uψδ.\x11␙␋\x12jλ%ＨφＤμ＜␔ｉ｀/‛｜)．",
	}, { // 534
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσλ",
		out:  "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσλ",
	}, { // 535
		mask: EncodeHash | EncodeLeftPeriod,
		in:   ".．／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσλ",
		out:  "．．／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσλ",
	}, { // 536
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "．．／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσλ",
		out:  "‛．．／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσλ",
	}, { // 537
		mask: EncodeHash | EncodeLeftPeriod,
		in:   ".␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f．λ",
		out:  "．␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f．λ",
	}, { // 538
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "．␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f．λ",
		out:  "‛．␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f．λ",
	}, { // 539
		mask: EncodeHash | EncodeLeftPeriod,
		in:   ".␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσ．",
		out:  "．␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσ．",
	}, { // 540
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "．␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσ．",
		out:  "‛．␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσ．",
	}, { // 541
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "τ.／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσλ",
		out:  "τ.／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσλ",
	}, { // 542
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "τ．／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσλ",
		out:  "τ．／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσλ",
	}, { // 543
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "τ.／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f．λ",
		out:  "τ.／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f．λ",
	}, { // 544
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "τ．／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f．λ",
		out:  "τ．／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f．λ",
	}, { // 545
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "τ.／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσ．",
		out:  "τ.／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσ．",
	}, { // 546
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "τ．／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσ．",
		out:  "τ．／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσ．",
	}, { // 547
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f.λ",
		out:  "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f.λ",
	}, { // 548
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f．λ",
		out:  "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f．λ",
	}, { // 549
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f.．",
		out:  "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f.．",
	}, { // 550
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f．．",
		out:  "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007f．．",
	}, { // 551
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσ.",
		out:  "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσ.",
	}, { // 552
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσ．",
		out:  "τ␂／θ␍｀ αhＮ.␄\v␞|A,％ρ８－\x15ＥX\x0e\x16ｔ\u007fσ．",
	}, { // 553
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～ｆ",
		out:  "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～ｆ",
	}, { // 554
		mask: EncodePercent | EncodeLeftPeriod,
		in:   ".．:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～ｆ",
		out:  "．．:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～ｆ",
	}, { // 555
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "．．:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～ｆ",
		out:  "‛．．:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～ｆ",
	}, { // 556
		mask: EncodePercent | EncodeLeftPeriod,
		in:   ".\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ．ｆ",
		out:  "．\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ．ｆ",
	}, { // 557
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "．\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ．ｆ",
		out:  "‛．\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ．ｆ",
	}, { // 558
		mask: EncodePercent | EncodeLeftPeriod,
		in:   ".\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～．",
		out:  "．\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～．",
	}, { // 559
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "．\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～．",
		out:  "‛．\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～．",
	}, { // 560
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "a.:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～ｆ",
		out:  "a.:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～ｆ",
	}, { // 561
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "a．:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～ｆ",
		out:  "a．:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～ｆ",
	}, { // 562
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "a.:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ．ｆ",
		out:  "a.:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ．ｆ",
	}, { // 563
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "a．:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ．ｆ",
		out:  "a．:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ．ｆ",
	}, { // 564
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "a.:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～．",
		out:  "a.:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～．",
	}, { // 565
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "a．:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～．",
		out:  "a．:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～．",
	}, { // 566
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ.ｆ",
		out:  "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ.ｆ",
	}, { // 567
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ．ｆ",
		out:  "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ．ｆ",
	}, { // 568
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ.．",
		out:  "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ.．",
	}, { // 569
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ．．",
		out:  "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ．．",
	}, { // 570
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～.",
		out:  "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～.",
	}, { // 571
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～．",
		out:  "a\x18:ｙ\x11＜ρ｜ε-.␄4φ\x04ψ＄／κ'\x1c␖s＠\\χmＣ～．",
	}, { // 572
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "␓SκfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π␍␜",
		out:  "␓SκfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π␍␜",
	}, { // 573
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   ".．κfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π␍␜",
		out:  "．．κfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π␍␜",
	}, { // 574
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "．．κfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π␍␜",
		out:  "‛．．κfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π␍␜",
	}, { // 575
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   ".SκfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π．␜",
		out:  "．SκfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π．␜",
	}, { // 576
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "．SκfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π．␜",
		out:  "‛．SκfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π．␜",
	}, { // 577
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   ".SκfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π␍．",
		out:  "．SκfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π␍．",
	}, { // 578
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "．SκfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π␍．",
		out:  "‛．SκfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π␍．",
	}, { // 579
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "␓.κfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π␍␜",
		out:  "␓.κfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π␍␜",
	}, { // 580
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "␓．κfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π␍␜",
		out:  "␓．κfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π␍␜",
	}, { // 581
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "␓.κfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π．␜",
		out:  "␓.κfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π．␜",
	}, { // 582
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "␓．κfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π．␜",
		out:  "␓．κfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π．␜",
	}, { // 583
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "␓.κfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π␍．",
		out:  "␓.κfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π␍．",
	}, { // 584
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "␓．κfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π␍．",
		out:  "␓．κfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π␍．",
	}, { // 585
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "␓SκfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π.␜",
		out:  "␓SκfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π.␜",
	}, { // 586
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "␓SκfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π．␜",
		out:  "␓SκfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π．␜",
	}, { // 587
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "␓SκfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π.．",
		out:  "␓SκfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π.．",
	}, { // 588
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "␓SκfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π．．",
		out:  "␓SκfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π．．",
	}, { // 589
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "␓SκfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π␍.",
		out:  "␓SκfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π␍.",
	}, { // 590
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "␓SκfＦz6*３％.\x00Ａτ\n｀[＃/？\u007fη\x1f；χ=＼π␍．",
		out:  "␓SκfＦz6*３％.␀Ａτ\n｀[＃/？\u007fη\x1f；χ=‛＼π␍．",
	}, { // 591
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "φψｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17ζU",
		out:  "φψｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17ζU",
	}, { // 592
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   ".．ｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17ζU",
		out:  "．．ｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17ζU",
	}, { // 593
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "．．ｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17ζU",
		out:  "‛．．ｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17ζU",
	}, { // 594
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   ".ψｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17．U",
		out:  "．ψｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17．U",
	}, { // 595
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "．ψｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17．U",
		out:  "‛．ψｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17．U",
	}, { // 596
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   ".ψｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17ζ．",
		out:  "．ψｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17ζ．",
	}, { // 597
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "．ψｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17ζ．",
		out:  "‛．ψｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17ζ．",
	}, { // 598
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "φ.ｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17ζU",
		out:  "φ.ｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17ζU",
	}, { // 599
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "φ．ｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17ζU",
		out:  "φ．ｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17ζU",
	}, { // 600
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "φ.ｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17．U",
		out:  "φ.ｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17．U",
	}, { // 601
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "φ．ｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17．U",
		out:  "φ．ｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17．U",
	}, { // 602
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "φ.ｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17ζ．",
		out:  "φ.ｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17ζ．",
	}, { // 603
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "φ．ｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17ζ．",
		out:  "φ．ｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17ζ．",
	}, { // 604
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "φψｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17.U",
		out:  "φψｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17.U",
	}, { // 605
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "φψｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17．U",
		out:  "φψｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17．U",
	}, { // 606
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "φψｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17.．",
		out:  "φψｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17.．",
	}, { // 607
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "φψｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17．．",
		out:  "φψｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17．．",
	}, { // 608
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "φψｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17ζ.",
		out:  "φψｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17ζ.",
	}, { // 609
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "φψｕψ␛Sｓ＝␆\x10.\x1b␊\v\x02Ｅ!␔Ｗβ␝\nnV8θ␘\x17ζ．",
		out:  "φψｕψ␛Sｓ＝␆\x10.\x1b‛␊\v\x02Ｅ!␔Ｗβ␝␊nV8θ␘\x17ζ．",
	}, { // 610
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␚Ｇσ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|εｊ",
		out:  "␚Ｇσ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|εｊ",
	}, { // 611
		mask: EncodeDel | EncodeLeftPeriod,
		in:   ".．σ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|εｊ",
		out:  "．．σ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|εｊ",
	}, { // 612
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "．．σ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|εｊ",
		out:  "‛．．σ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|εｊ",
	}, { // 613
		mask: EncodeDel | EncodeLeftPeriod,
		in:   ".Ｇσ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|．ｊ",
		out:  "．Ｇσ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|．ｊ",
	}, { // 614
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "．Ｇσ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|．ｊ",
		out:  "‛．Ｇσ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|．ｊ",
	}, { // 615
		mask: EncodeDel | EncodeLeftPeriod,
		in:   ".Ｇσ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|ε．",
		out:  "．Ｇσ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|ε．",
	}, { // 616
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "．Ｇσ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|ε．",
		out:  "‛．Ｇσ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|ε．",
	}, { // 617
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␚.σ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|εｊ",
		out:  "␚.σ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|εｊ",
	}, { // 618
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␚．σ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|εｊ",
		out:  "␚．σ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|εｊ",
	}, { // 619
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␚.σ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|．ｊ",
		out:  "␚.σ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|．ｊ",
	}, { // 620
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␚．σ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|．ｊ",
		out:  "␚．σ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|．ｊ",
	}, { // 621
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␚.σ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|ε．",
		out:  "␚.σ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|ε．",
	}, { // 622
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␚．σ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|ε．",
		out:  "␚．σ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|ε．",
	}, { // 623
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␚Ｇσ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|.ｊ",
		out:  "␚Ｇσ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|.ｊ",
	}, { // 624
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␚Ｇσ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|．ｊ",
		out:  "␚Ｇσ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|．ｊ",
	}, { // 625
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␚Ｇσ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|.．",
		out:  "␚Ｇσ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|.．",
	}, { // 626
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␚Ｇσ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|．．",
		out:  "␚Ｇσ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|．．",
	}, { // 627
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␚Ｇσ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|ε.",
		out:  "␚Ｇσ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|ε.",
	}, { // 628
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␚Ｇσ␐ＣＮＮφ）\x0f.\"\u007fκ>υ␍␎K␆ε(\x14S\x19{␀|ε．",
		out:  "␚Ｇσ␐ＣＮＮφ）\x0f.\"␡κ>υ␍␎K␆ε(\x14S\x19{‛␀|ε．",
	}, { // 629
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "～\x03\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ｜|",
		out:  "～␃\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ｜|",
	}, { // 630
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   ".．\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ｜|",
		out:  "．．\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ｜|",
	}, { // 631
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "．．\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ｜|",
		out:  "‛．．\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ｜|",
	}, { // 632
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   ".\x03\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ．|",
		out:  "．␃\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ．|",
	}, { // 633
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "．\x03\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ．|",
		out:  "‛．␃\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ．|",
	}, { // 634
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   ".\x03\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ｜．",
		out:  "．␃\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ｜．",
	}, { // 635
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "．\x03\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ｜．",
		out:  "‛．␃\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ｜．",
	}, { // 636
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "～.\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ｜|",
		out:  "～.\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ｜|",
	}, { // 637
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "～．\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ｜|",
		out:  "～．\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ｜|",
	}, { // 638
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "～.\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ．|",
		out:  "～.\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ．|",
	}, { // 639
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "～．\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ．|",
		out:  "～．\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ．|",
	}, { // 640
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "～.\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ｜．",
		out:  "～.\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ｜．",
	}, { // 641
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "～．\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ｜．",
		out:  "～．\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ｜．",
	}, { // 642
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "～\x03\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ.|",
		out:  "～␃\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ.|",
	}, { // 643
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "～\x03\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ．|",
		out:  "～␃\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ．|",
	}, { // 644
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "～\x03\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ.．",
		out:  "～␃\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ.．",
	}, { // 645
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "～\x03\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ．．",
		out:  "～␃\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ．．",
	}, { // 646
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "～\x03\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ｜.",
		out:  "～␃\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ｜.",
	}, { // 647
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "～\x03\\μ4L␋^ＷＹ.ζ\t３␀\x1a（\x05$νωθ＊υB␙LＷ｜．",
		out:  "～␃\\μ4L‛␋^ＷＹ.ζ␉３‛␀␚（␅$νωθ＊υB‛␙LＷ｜．",
	}, { // 648
		mask: EncodeLeftTilde,
		in:   "~",
		out:  "～",
	}, { // 649
		mask: EncodeZero | EncodeLeftTilde,
		in:   "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀ＦI",
		out:  "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀ＦI",
	}, { // 650
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~～XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀ＦI",
		out:  "～～XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀ＦI",
	}, { // 651
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～～XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀ＦI",
		out:  "‛～～XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀ＦI",
	}, { // 652
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀～I",
		out:  "～＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀～I",
	}, { // 653
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀～I",
		out:  "‛～＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀～I",
	}, { // 654
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀Ｆ～",
		out:  "～＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀Ｆ～",
	}, { // 655
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀Ｆ～",
		out:  "‛～＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀Ｆ～",
	}, { // 656
		mask: EncodeZero | EncodeLeftTilde,
		in:   "ο~XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀ＦI",
		out:  "ο~XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀ＦI",
	}, { // 657
		mask: EncodeZero | EncodeLeftTilde,
		in:   "ο～XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀ＦI",
		out:  "ο～XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀ＦI",
	}, { // 658
		mask: EncodeZero | EncodeLeftTilde,
		in:   "ο~XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀～I",
		out:  "ο~XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀～I",
	}, { // 659
		mask: EncodeZero | EncodeLeftTilde,
		in:   "ο～XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀～I",
		out:  "ο～XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀～I",
	}, { // 660
		mask: EncodeZero | EncodeLeftTilde,
		in:   "ο~XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀Ｆ～",
		out:  "ο~XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀Ｆ～",
	}, { // 661
		mask: EncodeZero | EncodeLeftTilde,
		in:   "ο～XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀Ｆ～",
		out:  "ο～XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀Ｆ～",
	}, { // 662
		mask: EncodeZero | EncodeLeftTilde,
		in:   "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀~I",
		out:  "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀~I",
	}, { // 663
		mask: EncodeZero | EncodeLeftTilde,
		in:   "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀～I",
		out:  "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀～I",
	}, { // 664
		mask: EncodeZero | EncodeLeftTilde,
		in:   "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀~～",
		out:  "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀~～",
	}, { // 665
		mask: EncodeZero | EncodeLeftTilde,
		in:   "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀～～",
		out:  "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀～～",
	}, { // 666
		mask: EncodeZero | EncodeLeftTilde,
		in:   "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀Ｆ~",
		out:  "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀Ｆ~",
	}, { // 667
		mask: EncodeZero | EncodeLeftTilde,
		in:   "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀Ｆ～",
		out:  "ο＾XwＥ：ο␡｀␊~？οτ\x1d\f\bＲｇ\t\x16β\x03Wｊ]b｀Ｆ～",
	}, { // 668
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<j",
		out:  "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<j",
	}, { // 669
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~～＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<j",
		out:  "～～＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<j",
	}, { // 670
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～～＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<j",
		out:  "‛～～＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<j",
	}, { // 671
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ～j",
		out:  "～\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ～j",
	}, { // 672
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ～j",
		out:  "‛～\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ～j",
	}, { // 673
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<～",
		out:  "～\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<～",
	}, { // 674
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<～",
		out:  "‛～\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<～",
	}, { // 675
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "|~＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<j",
		out:  "|~＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<j",
	}, { // 676
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "|～＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<j",
		out:  "|～＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<j",
	}, { // 677
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "|~＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ～j",
		out:  "|~＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ～j",
	}, { // 678
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "|～＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ～j",
		out:  "|～＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ～j",
	}, { // 679
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "|~＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<～",
		out:  "|~＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<～",
	}, { // 680
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "|～＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<～",
		out:  "|～＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<～",
	}, { // 681
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ~j",
		out:  "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ~j",
	}, { // 682
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ～j",
		out:  "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ～j",
	}, { // 683
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ~～",
		out:  "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ~～",
	}, { // 684
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ～～",
		out:  "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ～～",
	}, { // 685
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<~",
		out:  "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<~",
	}, { // 686
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<～",
		out:  "|\x18＊＊␑$\uff00π：+~γ\x1c？Z\x1cκ␊␞\x14４！ψ␍Xξκｕ<～",
	}, { // 687
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇！κ",
		out:  "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇！κ",
	}, { // 688
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "~～\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇！κ",
		out:  "～～\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇！κ",
	}, { // 689
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "～～\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇！κ",
		out:  "‛～～\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇！κ",
	}, { // 690
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "~３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇～κ",
		out:  "～３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇～κ",
	}, { // 691
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "～３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇～κ",
		out:  "‛～３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇～κ",
	}, { // 692
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "~３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇！～",
		out:  "～３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇！～",
	}, { // 693
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "～３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇！～",
		out:  "‛～３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇！～",
	}, { // 694
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "␗~\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇！κ",
		out:  "␗~\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇！κ",
	}, { // 695
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "␗～\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇！κ",
		out:  "␗～\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇！κ",
	}, { // 696
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "␗~\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇～κ",
		out:  "␗~\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇～κ",
	}, { // 697
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "␗～\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇～κ",
		out:  "␗～\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇～κ",
	}, { // 698
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "␗~\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇！～",
		out:  "␗~\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇！～",
	}, { // 699
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "␗～\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇！～",
		out:  "␗～\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇！～",
	}, { // 700
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇~κ",
		out:  "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇~κ",
	}, { // 701
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇～κ",
		out:  "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇～κ",
	}, { // 702
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇~～",
		out:  "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇~～",
	}, { // 703
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇～～",
		out:  "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇～～",
	}, { // 704
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇！~",
		out:  "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇！~",
	}, { // 705
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!\x00κ\r＇！～",
		out:  "␗３\x17α!ｘ␄8␇１~zl/␌ｚλπ␛␉\x01κ\b!␀κ\r‛＇！～",
	}, { // 706
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χη",
		out:  "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χη",
	}, { // 707
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "~～\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χη",
		out:  "～～\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χη",
	}, { // 708
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "～～\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χη",
		out:  "‛～～\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χη",
	}, { // 709
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "~'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜～η",
		out:  "～'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜～η",
	}, { // 710
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "～'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜～η",
		out:  "‛～'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜～η",
	}, { // 711
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "~'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χ～",
		out:  "～'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χ～",
	}, { // 712
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "～'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χ～",
		out:  "‛～'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χ～",
	}, { // 713
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "f~\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χη",
		out:  "f~\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χη",
	}, { // 714
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "f～\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χη",
		out:  "f～\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χη",
	}, { // 715
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "f~\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜～η",
		out:  "f~\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜～η",
	}, { // 716
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "f～\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜～η",
		out:  "f～\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜～η",
	}, { // 717
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "f~\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χ～",
		out:  "f~\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χ～",
	}, { // 718
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "f～\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χ～",
		out:  "f～\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χ～",
	}, { // 719
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜~η",
		out:  "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜~η",
	}, { // 720
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜～η",
		out:  "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜～η",
	}, { // 721
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜~～",
		out:  "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜~～",
	}, { // 722
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜～～",
		out:  "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜～～",
	}, { // 723
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χ~",
		out:  "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χ~",
	}, { // 724
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χ～",
		out:  "f'\x0eλ\vς␇／nφ~ ／％π?T\x17－.␚７\r３␖\t␗＜χ～",
	}, { // 725
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏８",
		out:  "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏８",
	}, { // 726
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "~～n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏８",
		out:  "～～n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏８",
	}, { // 727
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "～～n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏８",
		out:  "‛～～n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏８",
	}, { // 728
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "~ηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚～８",
		out:  "～ηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚～８",
	}, { // 729
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "～ηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚～８",
		out:  "‛～ηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚～８",
	}, { // 730
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "~ηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏～",
		out:  "～ηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏～",
	}, { // 731
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "～ηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏～",
		out:  "‛～ηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏～",
	}, { // 732
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "U~n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏８",
		out:  "U~n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏８",
	}, { // 733
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "U～n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏８",
		out:  "U～n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏８",
	}, { // 734
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "U~n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚～８",
		out:  "U~n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚～８",
	}, { // 735
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "U～n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚～８",
		out:  "U～n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚～８",
	}, { // 736
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "U~n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏～",
		out:  "U~n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏～",
	}, { // 737
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "U～n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏～",
		out:  "U～n\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏～",
	}, { // 738
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚~８",
		out:  "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚~８",
	}, { // 739
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚～８",
		out:  "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚～８",
	}, { // 740
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚~～",
		out:  "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚~～",
	}, { // 741
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚～～",
		out:  "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚～～",
	}, { // 742
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏~",
		out:  "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏~",
	}, { // 743
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏～",
		out:  "Uηn\x11\x19C␆i\x16ε~\x1cｏ－ｏψ｜\x02θtηλｇ｜Iｓ\n␚␏～",
	}, { // 744
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜\x03β",
		out:  "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜\x03β",
	}, { // 745
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "~～ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜\x03β",
		out:  "～～ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜\x03β",
	}, { // 746
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "～～ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜\x03β",
		out:  "‛～～ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜\x03β",
	}, { // 747
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "~ηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜～β",
		out:  "～ηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜～β",
	}, { // 748
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "～ηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜～β",
		out:  "‛～ηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜～β",
	}, { // 749
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "~ηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜\x03～",
		out:  "～ηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜\x03～",
	}, { // 750
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "～ηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜\x03～",
		out:  "‛～ηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜\x03～",
	}, { // 751
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "ο~ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜\x03β",
		out:  "ο~ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜\x03β",
	}, { // 752
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "ο～ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜\x03β",
		out:  "ο～ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜\x03β",
	}, { // 753
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "ο~ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜～β",
		out:  "ο~ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜～β",
	}, { // 754
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "ο～ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜～β",
		out:  "ο～ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜～β",
	}, { // 755
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "ο~ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜\x03～",
		out:  "ο~ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜\x03～",
	}, { // 756
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "ο～ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜\x03～",
		out:  "ο～ｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜\x03～",
	}, { // 757
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜~β",
		out:  "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜~β",
	}, { // 758
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜～β",
		out:  "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜～β",
	}, { // 759
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜~～",
		out:  "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜~～",
	}, { // 760
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜～～",
		out:  "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜～～",
	}, { // 761
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜\x03~",
		out:  "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜\x03~",
	}, { // 762
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒＄\r\nθjＭεＥ␒␜＜\x03～",
		out:  "οηｎＮt\x02%υ␞３~P|\x1c\x1b␌␒‛＄\r\nθjＭεＥ␒␜＜\x03～",
	}, { // 763
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ν1␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r＇\x1e",
		out:  "ν1␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r＇\x1e",
	}, { // 764
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "~～␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r＇\x1e",
		out:  "～～␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r＇\x1e",
	}, { // 765
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "～～␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r＇\x1e",
		out:  "‛～～␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r＇\x1e",
	}, { // 766
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "~1␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r～\x1e",
		out:  "～1␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r～\x1e",
	}, { // 767
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "～1␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r～\x1e",
		out:  "‛～1␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r～\x1e",
	}, { // 768
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "~1␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r＇～",
		out:  "～1␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r＇～",
	}, { // 769
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "～1␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r＇～",
		out:  "‛～1␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r＇～",
	}, { // 770
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ν~␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r＇\x1e",
		out:  "ν~␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r＇\x1e",
	}, { // 771
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ν～␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r＇\x1e",
		out:  "ν～␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r＇\x1e",
	}, { // 772
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ν~␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r～\x1e",
		out:  "ν~␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r～\x1e",
	}, { // 773
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ν～␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r～\x1e",
		out:  "ν～␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r～\x1e",
	}, { // 774
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ν~␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r＇～",
		out:  "ν~␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r＇～",
	}, { // 775
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ν～␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r＇～",
		out:  "ν～␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r＇～",
	}, { // 776
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ν1␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r~\x1e",
		out:  "ν1␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r~\x1e",
	}, { // 777
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ν1␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r～\x1e",
		out:  "ν1␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r～\x1e",
	}, { // 778
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ν1␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r~～",
		out:  "ν1␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r~～",
	}, { // 779
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ν1␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r～～",
		out:  "ν1␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r～～",
	}, { // 780
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ν1␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r＇~",
		out:  "ν1␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r＇~",
	}, { // 781
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "ν1␎\"＝/ραZ\"~５C｜｝｀#␏φ\x06χ２φ\"ｊ␆\x02\r＇～",
		out:  "ν1␎＂＝/ραZ＂~５C｜｝｀#␏φ\x06χ２φ＂ｊ␆\x02\r＇～",
	}, { // 782
		mask: EncodeColon | EncodeLeftTilde,
		in:   "α'?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&@",
		out:  "α'?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&@",
	}, { // 783
		mask: EncodeColon | EncodeLeftTilde,
		in:   "~～?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&@",
		out:  "～～?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&@",
	}, { // 784
		mask: EncodeColon | EncodeLeftTilde,
		in:   "～～?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&@",
		out:  "‛～～?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&@",
	}, { // 785
		mask: EncodeColon | EncodeLeftTilde,
		in:   "~'?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ～@",
		out:  "～'?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ～@",
	}, { // 786
		mask: EncodeColon | EncodeLeftTilde,
		in:   "～'?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ～@",
		out:  "‛～'?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ～@",
	}, { // 787
		mask: EncodeColon | EncodeLeftTilde,
		in:   "~'?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&～",
		out:  "～'?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&～",
	}, { // 788
		mask: EncodeColon | EncodeLeftTilde,
		in:   "～'?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&～",
		out:  "‛～'?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&～",
	}, { // 789
		mask: EncodeColon | EncodeLeftTilde,
		in:   "α~?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&@",
		out:  "α~?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&@",
	}, { // 790
		mask: EncodeColon | EncodeLeftTilde,
		in:   "α～?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&@",
		out:  "α～?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&@",
	}, { // 791
		mask: EncodeColon | EncodeLeftTilde,
		in:   "α~?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ～@",
		out:  "α~?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ～@",
	}, { // 792
		mask: EncodeColon | EncodeLeftTilde,
		in:   "α～?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ～@",
		out:  "α～?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ～@",
	}, { // 793
		mask: EncodeColon | EncodeLeftTilde,
		in:   "α~?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&～",
		out:  "α~?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&～",
	}, { // 794
		mask: EncodeColon | EncodeLeftTilde,
		in:   "α～?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&～",
		out:  "α～?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&～",
	}, { // 795
		mask: EncodeColon | EncodeLeftTilde,
		in:   "α'?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ~@",
		out:  "α'?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ~@",
	}, { // 796
		mask: EncodeColon | EncodeLeftTilde,
		in:   "α'?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ～@",
		out:  "α'?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ～@",
	}, { // 797
		mask: EncodeColon | EncodeLeftTilde,
		in:   "α'?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ~～",
		out:  "α'?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ~～",
	}, { // 798
		mask: EncodeColon | EncodeLeftTilde,
		in:   "α'?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ～～",
		out:  "α'?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ～～",
	}, { // 799
		mask: EncodeColon | EncodeLeftTilde,
		in:   "α'?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&~",
		out:  "α'?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&~",
	}, { // 800
		mask: EncodeColon | EncodeLeftTilde,
		in:   "α'?p␏＞ＭQαｅ~\r\x06@␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&～",
		out:  "α'?p␏＞ＭQαｅ~\r\x06@‛␀g/␑ｘπ␑Ｄ＞λ\vπｅＲ&～",
	}, { // 801
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ｜\uff00",
		out:  "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ｜\uff00",
	}, { // 802
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "~～␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ｜\uff00",
		out:  "～～␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ｜\uff00",
	}, { // 803
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "～～␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ｜\uff00",
		out:  "‛～～␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ｜\uff00",
	}, { // 804
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "~>␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ～\uff00",
		out:  "～>␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ～\uff00",
	}, { // 805
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "～>␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ～\uff00",
		out:  "‛～>␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ～\uff00",
	}, { // 806
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "~>␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ｜～",
		out:  "～>␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ｜～",
	}, { // 807
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "～>␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ｜～",
		out:  "‛～>␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ｜～",
	}, { // 808
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␆~␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ｜\uff00",
		out:  "␆~␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ｜\uff00",
	}, { // 809
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␆～␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ｜\uff00",
		out:  "␆～␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ｜\uff00",
	}, { // 810
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␆~␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ～\uff00",
		out:  "␆~␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ～\uff00",
	}, { // 811
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␆～␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ～\uff00",
		out:  "␆～␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ～\uff00",
	}, { // 812
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␆~␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ｜～",
		out:  "␆~␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ｜～",
	}, { // 813
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␆～␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ｜～",
		out:  "␆～␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ｜～",
	}, { // 814
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ~\uff00",
		out:  "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ~\uff00",
	}, { // 815
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ～\uff00",
		out:  "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ～\uff00",
	}, { // 816
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ~～",
		out:  "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ~～",
	}, { // 817
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ～～",
		out:  "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ～～",
	}, { // 818
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ｜~",
		out:  "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ｜~",
	}, { // 819
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v？μψχ\u007fβφ\x15]γ} ｑ｜～",
		out:  "␆>␡/␚ｆ－ｚ␊h~p␆\x13\v‛？μψχ\u007fβφ\x15]γ} ｑ｜～",
	}, { // 820
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍θ␈",
		out:  "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍θ␈",
	}, { // 821
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "~～σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍θ␈",
		out:  "～～σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍θ␈",
	}, { // 822
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "～～σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍θ␈",
		out:  "‛～～σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍θ␈",
	}, { // 823
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "~\x05σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍～␈",
		out:  "～\x05σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍～␈",
	}, { // 824
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "～\x05σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍～␈",
		out:  "‛～\x05σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍～␈",
	}, { // 825
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "~\x05σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍θ～",
		out:  "～\x05σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍θ～",
	}, { // 826
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "～\x05σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍θ～",
		out:  "‛～\x05σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍θ～",
	}, { // 827
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "\x17~σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍θ␈",
		out:  "\x17~σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍θ␈",
	}, { // 828
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "\x17～σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍θ␈",
		out:  "\x17～σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍θ␈",
	}, { // 829
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "\x17~σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍～␈",
		out:  "\x17~σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍～␈",
	}, { // 830
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "\x17～σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍～␈",
		out:  "\x17～σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍～␈",
	}, { // 831
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "\x17~σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍θ～",
		out:  "\x17~σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍θ～",
	}, { // 832
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "\x17～σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍θ～",
		out:  "\x17～σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍θ～",
	}, { // 833
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍~␈",
		out:  "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍~␈",
	}, { // 834
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍～␈",
		out:  "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍～␈",
	}, { // 835
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍~～",
		out:  "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍~～",
	}, { // 836
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍～～",
		out:  "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍～～",
	}, { // 837
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍θ~",
		out:  "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍θ~",
	}, { // 838
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy*Pν\uff00m\x02␘\r^VＷ␐␍θ～",
		out:  "\x17\x05σｅ␃ν％\x0fP＃~εＳｖy＊Pν\uff00m\x02␘\r^VＷ␐␍θ～",
	}, { // 839
		mask: EncodePipe | EncodeLeftTilde,
		in:   "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？␀\r",
		out:  "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？‛␀\r",
	}, { // 840
		mask: EncodePipe | EncodeLeftTilde,
		in:   "~～（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？␀\r",
		out:  "～～（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？‛␀\r",
	}, { // 841
		mask: EncodePipe | EncodeLeftTilde,
		in:   "～～（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？␀\r",
		out:  "‛～～（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？‛␀\r",
	}, { // 842
		mask: EncodePipe | EncodeLeftTilde,
		in:   "~α（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？～\r",
		out:  "～α（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？～\r",
	}, { // 843
		mask: EncodePipe | EncodeLeftTilde,
		in:   "～α（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？～\r",
		out:  "‛～α（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？～\r",
	}, { // 844
		mask: EncodePipe | EncodeLeftTilde,
		in:   "~α（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？␀～",
		out:  "～α（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？‛␀～",
	}, { // 845
		mask: EncodePipe | EncodeLeftTilde,
		in:   "～α（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？␀～",
		out:  "‛～α（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？‛␀～",
	}, { // 846
		mask: EncodePipe | EncodeLeftTilde,
		in:   "Ｆ~（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？␀\r",
		out:  "Ｆ~（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？‛␀\r",
	}, { // 847
		mask: EncodePipe | EncodeLeftTilde,
		in:   "Ｆ～（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？␀\r",
		out:  "Ｆ～（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？‛␀\r",
	}, { // 848
		mask: EncodePipe | EncodeLeftTilde,
		in:   "Ｆ~（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？～\r",
		out:  "Ｆ~（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？～\r",
	}, { // 849
		mask: EncodePipe | EncodeLeftTilde,
		in:   "Ｆ～（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？～\r",
		out:  "Ｆ～（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？～\r",
	}, { // 850
		mask: EncodePipe | EncodeLeftTilde,
		in:   "Ｆ~（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？␀～",
		out:  "Ｆ~（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？‛␀～",
	}, { // 851
		mask: EncodePipe | EncodeLeftTilde,
		in:   "Ｆ～（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？␀～",
		out:  "Ｆ～（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？‛␀～",
	}, { // 852
		mask: EncodePipe | EncodeLeftTilde,
		in:   "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？~\r",
		out:  "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？~\r",
	}, { // 853
		mask: EncodePipe | EncodeLeftTilde,
		in:   "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？～\r",
		out:  "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？～\r",
	}, { // 854
		mask: EncodePipe | EncodeLeftTilde,
		in:   "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？~～",
		out:  "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？~～",
	}, { // 855
		mask: EncodePipe | EncodeLeftTilde,
		in:   "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？～～",
		out:  "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？～～",
	}, { // 856
		mask: EncodePipe | EncodeLeftTilde,
		in:   "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？␀~",
		out:  "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？‛␀~",
	}, { // 857
		mask: EncodePipe | EncodeLeftTilde,
		in:   "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？␀～",
		out:  "Ｆα（␐\x15＼ξοωζ~*\nDκ＾;Ｙ\r？Ｍ␃]\"%3g？‛␀～",
	}, { // 858
		mask: EncodeHash | EncodeLeftTilde,
		in:   "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ：",
		out:  "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ：",
	}, { // 859
		mask: EncodeHash | EncodeLeftTilde,
		in:   "~～ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ：",
		out:  "～～ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ：",
	}, { // 860
		mask: EncodeHash | EncodeLeftTilde,
		in:   "～～ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ：",
		out:  "‛～～ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ：",
	}, { // 861
		mask: EncodeHash | EncodeLeftTilde,
		in:   "~＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ～：",
		out:  "～＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ～：",
	}, { // 862
		mask: EncodeHash | EncodeLeftTilde,
		in:   "～＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ～：",
		out:  "‛～＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ～：",
	}, { // 863
		mask: EncodeHash | EncodeLeftTilde,
		in:   "~＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ～",
		out:  "～＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ～",
	}, { // 864
		mask: EncodeHash | EncodeLeftTilde,
		in:   "～＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ～",
		out:  "‛～＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ～",
	}, { // 865
		mask: EncodeHash | EncodeLeftTilde,
		in:   "␡~ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ：",
		out:  "␡~ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ：",
	}, { // 866
		mask: EncodeHash | EncodeLeftTilde,
		in:   "␡～ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ：",
		out:  "␡～ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ：",
	}, { // 867
		mask: EncodeHash | EncodeLeftTilde,
		in:   "␡~ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ～：",
		out:  "␡~ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ～：",
	}, { // 868
		mask: EncodeHash | EncodeLeftTilde,
		in:   "␡～ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ～：",
		out:  "␡～ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ～：",
	}, { // 869
		mask: EncodeHash | EncodeLeftTilde,
		in:   "␡~ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ～",
		out:  "␡~ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ～",
	}, { // 870
		mask: EncodeHash | EncodeLeftTilde,
		in:   "␡～ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ～",
		out:  "␡～ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ～",
	}, { // 871
		mask: EncodeHash | EncodeLeftTilde,
		in:   "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ~：",
		out:  "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ~：",
	}, { // 872
		mask: EncodeHash | EncodeLeftTilde,
		in:   "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ～：",
		out:  "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ～：",
	}, { // 873
		mask: EncodeHash | EncodeLeftTilde,
		in:   "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ~～",
		out:  "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ~～",
	}, { // 874
		mask: EncodeHash | EncodeLeftTilde,
		in:   "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ～～",
		out:  "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`Ｓ～～",
	}, { // 875
		mask: EncodeHash | EncodeLeftTilde,
		in:   "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ~",
		out:  "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ~",
	}, { // 876
		mask: EncodeHash | EncodeLeftTilde,
		in:   "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ～",
		out:  "␡＆ｔ＞,␄␉s\x01；~λ(fτα:>γ\x19ｂ␝\x16\x12␌κ`ＳQ～",
	}, { // 877
		mask: EncodePercent | EncodeLeftTilde,
		in:   "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00\vｘ",
		out:  "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00\vｘ",
	}, { // 878
		mask: EncodePercent | EncodeLeftTilde,
		in:   "~～-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00\vｘ",
		out:  "～～-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00\vｘ",
	}, { // 879
		mask: EncodePercent | EncodeLeftTilde,
		in:   "～～-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00\vｘ",
		out:  "‛～～-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00\vｘ",
	}, { // 880
		mask: EncodePercent | EncodeLeftTilde,
		in:   "~φ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00～ｘ",
		out:  "～φ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00～ｘ",
	}, { // 881
		mask: EncodePercent | EncodeLeftTilde,
		in:   "～φ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00～ｘ",
		out:  "‛～φ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00～ｘ",
	}, { // 882
		mask: EncodePercent | EncodeLeftTilde,
		in:   "~φ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00\v～",
		out:  "～φ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00\v～",
	}, { // 883
		mask: EncodePercent | EncodeLeftTilde,
		in:   "～φ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00\v～",
		out:  "‛～φ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00\v～",
	}, { // 884
		mask: EncodePercent | EncodeLeftTilde,
		in:   "\v~-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00\vｘ",
		out:  "\v~-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00\vｘ",
	}, { // 885
		mask: EncodePercent | EncodeLeftTilde,
		in:   "\v～-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00\vｘ",
		out:  "\v～-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00\vｘ",
	}, { // 886
		mask: EncodePercent | EncodeLeftTilde,
		in:   "\v~-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00～ｘ",
		out:  "\v~-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00～ｘ",
	}, { // 887
		mask: EncodePercent | EncodeLeftTilde,
		in:   "\v～-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00～ｘ",
		out:  "\v～-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00～ｘ",
	}, { // 888
		mask: EncodePercent | EncodeLeftTilde,
		in:   "\v~-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00\v～",
		out:  "\v~-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00\v～",
	}, { // 889
		mask: EncodePercent | EncodeLeftTilde,
		in:   "\v～-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00\v～",
		out:  "\v～-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00\v～",
	}, { // 890
		mask: EncodePercent | EncodeLeftTilde,
		in:   "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00~ｘ",
		out:  "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00~ｘ",
	}, { // 891
		mask: EncodePercent | EncodeLeftTilde,
		in:   "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00～ｘ",
		out:  "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00～ｘ",
	}, { // 892
		mask: EncodePercent | EncodeLeftTilde,
		in:   "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00~～",
		out:  "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00~～",
	}, { // 893
		mask: EncodePercent | EncodeLeftTilde,
		in:   "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00～～",
		out:  "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00～～",
	}, { // 894
		mask: EncodePercent | EncodeLeftTilde,
		in:   "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00\v~",
		out:  "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00\v~",
	}, { // 895
		mask: EncodePercent | EncodeLeftTilde,
		in:   "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛％\x11\uff00\v～",
		out:  "\vφ-ｔ␙Ｋω\x02l｜~L9Ｖζξ\vχ\\␌.\x0e＼γ␛‛％\x11\uff00\v～",
	}, { // 896
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "rＰ\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ\\k",
		out:  "rＰ\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ＼k",
	}, { // 897
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~～\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ\\k",
		out:  "～～\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ＼k",
	}, { // 898
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～～\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ\\k",
		out:  "‛～～\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ＼k",
	}, { // 899
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~Ｐ\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ～k",
		out:  "～Ｐ\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ～k",
	}, { // 900
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～Ｐ\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ～k",
		out:  "‛～Ｐ\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ～k",
	}, { // 901
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~Ｐ\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ\\～",
		out:  "～Ｐ\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ＼～",
	}, { // 902
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～Ｐ\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ\\～",
		out:  "‛～Ｐ\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ＼～",
	}, { // 903
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "r~\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ\\k",
		out:  "r~\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ＼k",
	}, { // 904
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "r～\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ\\k",
		out:  "r～\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ＼k",
	}, { // 905
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "r~\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ～k",
		out:  "r~\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ～k",
	}, { // 906
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "r～\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ～k",
		out:  "r～\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ～k",
	}, { // 907
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "r~\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ\\～",
		out:  "r~\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ＼～",
	}, { // 908
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "r～\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ\\～",
		out:  "r～\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ＼～",
	}, { // 909
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "rＰ\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ~k",
		out:  "rＰ\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ~k",
	}, { // 910
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "rＰ\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ～k",
		out:  "rＰ\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ～k",
	}, { // 911
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "rＰ\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ~～",
		out:  "rＰ\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ~～",
	}, { // 912
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "rＰ\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ～～",
		out:  "rＰ\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ～～",
	}, { // 913
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "rＰ\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ\\~",
		out:  "rＰ\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ＼~",
	}, { // 914
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "rＰ\x1d\\ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ\\～",
		out:  "rＰ\x1d＼ｊβσ4␉\x16~v:␋␏\x1cＸ␌␆ζ\a＆\x14σＡ７␎ρ＼～",
	}, { // 915
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1bπ",
		out:  "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1bπ",
	}, { // 916
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "~～ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1bπ",
		out:  "～～ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1bπ",
	}, { // 917
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "～～ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1bπ",
		out:  "‛～～ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1bπ",
	}, { // 918
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "~_ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？～π",
		out:  "～_ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？～π",
	}, { // 919
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "～_ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？～π",
		out:  "‛～_ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？～π",
	}, { // 920
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "~_ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1b～",
		out:  "～_ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1b～",
	}, { // 921
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "～_ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1b～",
		out:  "‛～_ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1b～",
	}, { // 922
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "α~ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1bπ",
		out:  "α~ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1bπ",
	}, { // 923
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "α～ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1bπ",
		out:  "α～ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1bπ",
	}, { // 924
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "α~ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？～π",
		out:  "α~ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？～π",
	}, { // 925
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "α～ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？～π",
		out:  "α～ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？～π",
	}, { // 926
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "α~ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1b～",
		out:  "α~ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1b～",
	}, { // 927
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "α～ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1b～",
		out:  "α～ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1b～",
	}, { // 928
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？~π",
		out:  "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？~π",
	}, { // 929
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？～π",
		out:  "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？～π",
	}, { // 930
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？~～",
		out:  "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？~～",
	}, { // 931
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？～～",
		out:  "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？～～",
	}, { // 932
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1b~",
		out:  "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1b~",
	}, { // 933
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1b～",
		out:  "α_ＧI\x11ξ\x01ς␉␉~Ｙε\\‛␍eD＞！\x1d\x01\uff00␂ιQＦe？\x1b～",
	}, { // 934
		mask: EncodeDel | EncodeLeftTilde,
		in:   "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓␝",
		out:  "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓␝",
	}, { // 935
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~～＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓␝",
		out:  "～～＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓␝",
	}, { // 936
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～～＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓␝",
		out:  "‛～～＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓␝",
	}, { // 937
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ～␝",
		out:  "～％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ～␝",
	}, { // 938
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ～␝",
		out:  "‛～％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ～␝",
	}, { // 939
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓～",
		out:  "～％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓～",
	}, { // 940
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓～",
		out:  "‛～％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓～",
	}, { // 941
		mask: EncodeDel | EncodeLeftTilde,
		in:   "c~＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓␝",
		out:  "c~＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓␝",
	}, { // 942
		mask: EncodeDel | EncodeLeftTilde,
		in:   "c～＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓␝",
		out:  "c～＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓␝",
	}, { // 943
		mask: EncodeDel | EncodeLeftTilde,
		in:   "c~＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ～␝",
		out:  "c~＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ～␝",
	}, { // 944
		mask: EncodeDel | EncodeLeftTilde,
		in:   "c～＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ～␝",
		out:  "c～＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ～␝",
	}, { // 945
		mask: EncodeDel | EncodeLeftTilde,
		in:   "c~＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓～",
		out:  "c~＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓～",
	}, { // 946
		mask: EncodeDel | EncodeLeftTilde,
		in:   "c～＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓～",
		out:  "c～＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓～",
	}, { // 947
		mask: EncodeDel | EncodeLeftTilde,
		in:   "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ~␝",
		out:  "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ~␝",
	}, { // 948
		mask: EncodeDel | EncodeLeftTilde,
		in:   "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ～␝",
		out:  "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ～␝",
	}, { // 949
		mask: EncodeDel | EncodeLeftTilde,
		in:   "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ~～",
		out:  "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ~～",
	}, { // 950
		mask: EncodeDel | EncodeLeftTilde,
		in:   "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ～～",
		out:  "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ～～",
	}, { // 951
		mask: EncodeDel | EncodeLeftTilde,
		in:   "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓~",
		out:  "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓~",
	}, { // 952
		mask: EncodeDel | EncodeLeftTilde,
		in:   "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓～",
		out:  "c％＃>␛＇\x02\x1bｈｈ~/２\x18＜＃$'\vλqε５^πιλπ␓～",
	}, { // 953
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "|jυ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L\fι",
		out:  "|jυ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L␌ι",
	}, { // 954
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~～υ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L\fι",
		out:  "～～υ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L␌ι",
	}, { // 955
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～～υ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L\fι",
		out:  "‛～～υ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L␌ι",
	}, { // 956
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~jυ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L～ι",
		out:  "～jυ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L～ι",
	}, { // 957
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～jυ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L～ι",
		out:  "‛～jυ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L～ι",
	}, { // 958
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~jυ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L\f～",
		out:  "～jυ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L␌～",
	}, { // 959
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～jυ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L\f～",
		out:  "‛～jυ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L␌～",
	}, { // 960
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "|~υ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L\fι",
		out:  "|~υ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L␌ι",
	}, { // 961
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "|～υ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L\fι",
		out:  "|～υ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L␌ι",
	}, { // 962
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "|~υ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L～ι",
		out:  "|~υ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L～ι",
	}, { // 963
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "|～υ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L～ι",
		out:  "|～υ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L～ι",
	}, { // 964
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "|~υ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L\f～",
		out:  "|~υ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L␌～",
	}, { // 965
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "|～υ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L\f～",
		out:  "|～υ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L␌～",
	}, { // 966
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "|jυ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L~ι",
		out:  "|jυ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L~ι",
	}, { // 967
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "|jυ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L～ι",
		out:  "|jυ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L～ι",
	}, { // 968
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "|jυ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L~～",
		out:  "|jυ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L~～",
	}, { // 969
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "|jυ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L～～",
		out:  "|jυ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L～～",
	}, { // 970
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "|jυ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L\f~",
		out:  "|jυ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L␌~",
	}, { // 971
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "|jυ␐␏ςＷ␊\x11Q~＂LjβM９？＞ξξ␘|\x11␓Ｉ<L\f～",
		out:  "|jυ‛␐‛␏ςＷ‛␊␑Q~＂LjβM９？＞ξξ‛␘|␑‛␓Ｉ<L␌～",
	}, { // 972
		mask: EncodeLeftCrLfHtVt,
		in:   "\t",
		out:  "␉",
	}, { // 973
		mask: EncodeLeftCrLfHtVt,
		in:   "\n",
		out:  "␊",
	}, { // 974
		mask: EncodeLeftCrLfHtVt,
		in:   "\v",
		out:  "␋",
	}, { // 975
		mask: EncodeLeftCrLfHtVt,
		in:   "\r",
		out:  "␍",
	}, { // 976
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＝\x0fν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔Mθ",
		out:  "＝\x0fν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔Mθ",
	}, { // 977
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\t␉ν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔Mθ",
		out:  "␉␉ν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔Mθ",
	}, { // 978
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␉␉ν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔Mθ",
		out:  "‛␉␉ν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔Mθ",
	}, { // 979
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\t\x0fν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔␉θ",
		out:  "␉\x0fν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔␉θ",
	}, { // 980
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␉\x0fν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔␉θ",
		out:  "‛␉\x0fν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔␉θ",
	}, { // 981
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\t\x0fν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔M␉",
		out:  "␉\x0fν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔M␉",
	}, { // 982
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␉\x0fν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔M␉",
		out:  "‛␉\x0fν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔M␉",
	}, { // 983
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＝\tν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔Mθ",
		out:  "＝\tν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔Mθ",
	}, { // 984
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＝␉ν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔Mθ",
		out:  "＝␉ν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔Mθ",
	}, { // 985
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＝\tν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔␉θ",
		out:  "＝\tν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔␉θ",
	}, { // 986
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＝␉ν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔␉θ",
		out:  "＝␉ν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔␉θ",
	}, { // 987
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＝\tν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔M␉",
		out:  "＝\tν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔M␉",
	}, { // 988
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＝␉ν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔M␉",
		out:  "＝␉ν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔M␉",
	}, { // 989
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＝\x0fν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔\tθ",
		out:  "＝\x0fν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔\tθ",
	}, { // 990
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＝\x0fν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔␉θ",
		out:  "＝\x0fν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔␉θ",
	}, { // 991
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＝\x0fν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔\t␉",
		out:  "＝\x0fν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔\t␉",
	}, { // 992
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＝\x0fν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔␉␉",
		out:  "＝\x0fν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔␉␉",
	}, { // 993
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＝\x0fν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔M\t",
		out:  "＝\x0fν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔M\t",
	}, { // 994
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＝\x0fν＂＂␊εu＂χ\t\x00τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔M␉",
		out:  "＝\x0fν＂＂␊εu＂χ\t␀τＲT＼μ\rＺ@\x06␅3␝'Ｄ/␔M␉",
	}, { // 995
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο］",
		out:  "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο］",
	}, { // 996
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\n␊\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο］",
		out:  "␊␊\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο］",
	}, { // 997
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␊␊\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο］",
		out:  "‛␊␊\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο］",
	}, { // 998
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\nx\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr␊］",
		out:  "␊x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr␊］",
	}, { // 999
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␊x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr␊］",
		out:  "‛␊x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr␊］",
	}, { // 1000
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\nx\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο␊",
		out:  "␊x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο␊",
	}, { // 1001
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␊x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο␊",
		out:  "‛␊x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο␊",
	}, { // 1002
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "+\n\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο］",
		out:  "+\n\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο］",
	}, { // 1003
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "+␊\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο］",
		out:  "+␊\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο］",
	}, { // 1004
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "+\n\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr␊］",
		out:  "+\n\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr␊］",
	}, { // 1005
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "+␊\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr␊］",
		out:  "+␊\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr␊］",
	}, { // 1006
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "+\n\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο␊",
		out:  "+\n\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο␊",
	}, { // 1007
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "+␊\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο␊",
		out:  "+␊\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο␊",
	}, { // 1008
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr\n］",
		out:  "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr\n］",
	}, { // 1009
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr␊］",
		out:  "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr␊］",
	}, { // 1010
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr\n␊",
		out:  "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr\n␊",
	}, { // 1011
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr␊␊",
		out:  "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\fr␊␊",
	}, { // 1012
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο\n",
		out:  "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο\n",
	}, { // 1013
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο␊",
		out:  "+x\"Ｊ－:ι？ｑ:\nβο．␘Ｆ`\r␁3τ␄\x1e␎＊W\frο␊",
	}, { // 1014
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψAθ",
		out:  "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψAθ",
	}, { // 1015
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\v␋！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψAθ",
		out:  "␋␋！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψAθ",
	}, { // 1016
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␋␋！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψAθ",
		out:  "‛␋␋！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψAθ",
	}, { // 1017
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\v＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ␋θ",
		out:  "␋＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ␋θ",
	}, { // 1018
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␋＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ␋θ",
		out:  "‛␋＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ␋θ",
	}, { // 1019
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\v＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψA␋",
		out:  "␋＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψA␋",
	}, { // 1020
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␋＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψA␋",
		out:  "‛␋＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψA␋",
	}, { // 1021
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＜\v！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψAθ",
		out:  "＜\v！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψAθ",
	}, { // 1022
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＜␋！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψAθ",
		out:  "＜␋！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψAθ",
	}, { // 1023
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＜\v！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ␋θ",
		out:  "＜\v！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ␋θ",
	}, { // 1024
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＜␋！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ␋θ",
		out:  "＜␋！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ␋θ",
	}, { // 1025
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＜\v！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψA␋",
		out:  "＜\v！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψA␋",
	}, { // 1026
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＜␋！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψA␋",
		out:  "＜␋！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψA␋",
	}, { // 1027
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ\vθ",
		out:  "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ\vθ",
	}, { // 1028
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ␋θ",
		out:  "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ␋θ",
	}, { // 1029
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ\v␋",
		out:  "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ\v␋",
	}, { // 1030
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ␋␋",
		out:  "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψ␋␋",
	}, { // 1031
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψA\v",
		out:  "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψA\v",
	}, { // 1032
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψA␋",
		out:  "＜＜！␘％␝\n␉\x1cd\v␄\bh\x12\rνοαｃｙε\x05(ｋｆ%ψA␋",
	}, { // 1033
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａR",
		out:  "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａR",
	}, { // 1034
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\r␍\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａR",
		out:  "␍␍\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａR",
	}, { // 1035
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␍␍\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａR",
		out:  "‛␍␍\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａR",
	}, { // 1036
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\r&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη␍R",
		out:  "␍&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη␍R",
	}, { // 1037
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␍&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη␍R",
		out:  "‛␍&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη␍R",
	}, { // 1038
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\r&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａ␍",
		out:  "␍&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａ␍",
	}, { // 1039
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␍&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａ␍",
		out:  "‛␍&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａ␍",
	}, { // 1040
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "θ\r\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａR",
		out:  "θ\r\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａR",
	}, { // 1041
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "θ␍\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａR",
		out:  "θ␍\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａR",
	}, { // 1042
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "θ\r\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη␍R",
		out:  "θ\r\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη␍R",
	}, { // 1043
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "θ␍\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη␍R",
		out:  "θ␍\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη␍R",
	}, { // 1044
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "θ\r\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａ␍",
		out:  "θ\r\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａ␍",
	}, { // 1045
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "θ␍\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａ␍",
		out:  "θ␍\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａ␍",
	}, { // 1046
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη\rR",
		out:  "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη\rR",
	}, { // 1047
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη␍R",
		out:  "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη␍R",
	}, { // 1048
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη\r␍",
		out:  "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη\r␍",
	}, { // 1049
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη␍␍",
		out:  "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tη␍␍",
	}, { // 1050
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａ\r",
		out:  "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａ\r",
	}, { // 1051
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａ␍",
		out:  "θ&\fα＜\x1c\x11Ｕ\x14␅\rε␃{Dχ#８NζＷ＜＜ｚ＠W\tηａ␍",
	}, { // 1052
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "#，␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ\x1dλ",
		out:  "#，␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ\x1dλ",
	}, { // 1053
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␉␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ\x1dλ",
		out:  "␉␉␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ\x1dλ",
	}, { // 1054
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␉␉␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ\x1dλ",
		out:  "‛␉␉␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ\x1dλ",
	}, { // 1055
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t，␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ␉λ",
		out:  "␉，␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ␉λ",
	}, { // 1056
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␉，␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ␉λ",
		out:  "‛␉，␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ␉λ",
	}, { // 1057
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t，␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ\x1d␉",
		out:  "␉，␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ\x1d␉",
	}, { // 1058
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␉，␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ\x1d␉",
		out:  "‛␉，␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ\x1d␉",
	}, { // 1059
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "#\t␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ\x1dλ",
		out:  "#\t␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ\x1dλ",
	}, { // 1060
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "#␉␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ\x1dλ",
		out:  "#␉␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ\x1dλ",
	}, { // 1061
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "#\t␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ␉λ",
		out:  "#\t␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ␉λ",
	}, { // 1062
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "#␉␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ␉λ",
		out:  "#␉␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ␉λ",
	}, { // 1063
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "#\t␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ\x1d␉",
		out:  "#\t␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ\x1d␉",
	}, { // 1064
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "#␉␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ\x1d␉",
		out:  "#␉␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ\x1d␉",
	}, { // 1065
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "#，␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ\tλ",
		out:  "#，␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ\tλ",
	}, { // 1066
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "#，␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ␉λ",
		out:  "#，␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ␉λ",
	}, { // 1067
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "#，␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ\t␉",
		out:  "#，␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ\t␉",
	}, { // 1068
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "#，␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ␉␉",
		out:  "#，␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ␉␉",
	}, { // 1069
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "#，␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ\x1d\t",
		out:  "#，␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ\x1d\t",
	}, { // 1070
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "#，␍'t␗φｊσａ\tρι␂h\x1b␡'\x00+ｘ\rξ／␞@jＤ\x1d␉",
		out:  "#，␍'t␗φｊσａ\tρι␂h\x1b␡'␀+ｘ\rξ‛／␞@jＤ\x1d␉",
	}, { // 1071
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "$␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ\x10",
		out:  "$‛␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ\x10",
	}, { // 1072
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\n␊\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ\x10",
		out:  "␊␊\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ\x10",
	}, { // 1073
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␊␊\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ\x10",
		out:  "‛␊␊\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ\x10",
	}, { // 1074
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\n␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ␊\x10",
		out:  "␊‛␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ␊\x10",
	}, { // 1075
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␊␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ␊\x10",
		out:  "‛␊‛␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ␊\x10",
	}, { // 1076
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\n␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ␊",
		out:  "␊‛␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ␊",
	}, { // 1077
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␊␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ␊",
		out:  "‛␊‛␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ␊",
	}, { // 1078
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "$\n\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ\x10",
		out:  "$\n\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ\x10",
	}, { // 1079
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "$␊\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ\x10",
		out:  "$␊\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ\x10",
	}, { // 1080
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "$\n\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ␊\x10",
		out:  "$\n\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ␊\x10",
	}, { // 1081
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "$␊\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ␊\x10",
		out:  "$␊\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ␊\x10",
	}, { // 1082
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "$\n\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ␊",
		out:  "$\n\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ␊",
	}, { // 1083
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "$␊\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ␊",
		out:  "$␊\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ␊",
	}, { // 1084
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "$␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ\n\x10",
		out:  "$‛␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ\n\x10",
	}, { // 1085
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "$␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ␊\x10",
		out:  "$‛␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ␊\x10",
	}, { // 1086
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "$␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ\n␊",
		out:  "$‛␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ\n␊",
	}, { // 1087
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "$␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ␊␊",
		out:  "$‛␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔ␊␊",
	}, { // 1088
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "$␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ\n",
		out:  "$‛␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ\n",
	}, { // 1089
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "$␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ␊",
		out:  "$‛␀\x11%␄ο0␍Ｓη\nO\\＾␎０ςeα\x1d;!\x15Ｅμ␁＃Ｔχ␊",
	}, { // 1090
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "．＼-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ\x15D",
		out:  "．＼-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ\x15D",
	}, { // 1091
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\v␋-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ\x15D",
		out:  "␋␋-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ\x15D",
	}, { // 1092
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␋␋-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ\x15D",
		out:  "‛␋␋-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ\x15D",
	}, { // 1093
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\v＼-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ␋D",
		out:  "␋＼-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ␋D",
	}, { // 1094
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␋＼-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ␋D",
		out:  "‛␋＼-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ␋D",
	}, { // 1095
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\v＼-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ\x15␋",
		out:  "␋＼-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ\x15␋",
	}, { // 1096
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␋＼-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ\x15␋",
		out:  "‛␋＼-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ\x15␋",
	}, { // 1097
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "．\v-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ\x15D",
		out:  "．\v-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ\x15D",
	}, { // 1098
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "．␋-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ\x15D",
		out:  "．␋-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ\x15D",
	}, { // 1099
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "．\v-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ␋D",
		out:  "．\v-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ␋D",
	}, { // 1100
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "．␋-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ␋D",
		out:  "．␋-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ␋D",
	}, { // 1101
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "．\v-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ\x15␋",
		out:  "．\v-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ\x15␋",
	}, { // 1102
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "．␋-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ\x15␋",
		out:  "．␋-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ\x15␋",
	}, { // 1103
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "．＼-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ\vD",
		out:  "．＼-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ\vD",
	}, { // 1104
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "．＼-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ␋D",
		out:  "．＼-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ␋D",
	}, { // 1105
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "．＼-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ\v␋",
		out:  "．＼-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ\v␋",
	}, { // 1106
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "．＼-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ␋␋",
		out:  "．＼-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ␋␋",
	}, { // 1107
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "．＼-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ\x15\v",
		out:  "．＼-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ\x15\v",
	}, { // 1108
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "．＼-iHＵ＼\nζ＜\vκ！/␐3ｘ｜π␟οｘ-\x1a`η:μ\x15␋",
		out:  "．＼-iHＵ＼\nζ＜\vκ！／␐3ｘ｜π␟οｘ-\x1a`η:μ\x15␋",
	}, { // 1109
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇Tψψ",
		out:  "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇Tψψ",
	}, { // 1110
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\r␍α－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇Tψψ",
		out:  "␍␍α－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇Tψψ",
	}, { // 1111
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␍␍α－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇Tψψ",
		out:  "‛␍␍α－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇Tψψ",
	}, { // 1112
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\rRα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇T␍ψ",
		out:  "␍Rα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇T␍ψ",
	}, { // 1113
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␍Rα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇T␍ψ",
		out:  "‛␍Rα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇T␍ψ",
	}, { // 1114
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\rRα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇Tψ␍",
		out:  "␍Rα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇Tψ␍",
	}, { // 1115
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␍Rα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇Tψ␍",
		out:  "‛␍Rα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇Tψ␍",
	}, { // 1116
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "Ｕ\rα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇Tψψ",
		out:  "Ｕ\rα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇Tψψ",
	}, { // 1117
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "Ｕ␍α－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇Tψψ",
		out:  "Ｕ␍α－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇Tψψ",
	}, { // 1118
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "Ｕ\rα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇T␍ψ",
		out:  "Ｕ\rα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇T␍ψ",
	}, { // 1119
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "Ｕ␍α－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇T␍ψ",
		out:  "Ｕ␍α－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇T␍ψ",
	}, { // 1120
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "Ｕ\rα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇Tψ␍",
		out:  "Ｕ\rα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇Tψ␍",
	}, { // 1121
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "Ｕ␍α－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇Tψ␍",
		out:  "Ｕ␍α－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇Tψ␍",
	}, { // 1122
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇T\rψ",
		out:  "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇T\rψ",
	}, { // 1123
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇T␍ψ",
		out:  "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇T␍ψ",
	}, { // 1124
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇T\r␍",
		out:  "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇T\r␍",
	}, { // 1125
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇T␍␍",
		out:  "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇T␍␍",
	}, { // 1126
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇Tψ\r",
		out:  "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇Tψ\r",
	}, { // 1127
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］/z％.ＯBιPＬ␏\x10＇Tψ␍",
		out:  "ＵRα－␕\x19ｈτ\x1a<\r＜␚\u007f］／z％.ＯBιPＬ␏\x10＇Tψ␍",
	}, { // 1128
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r＇μ",
		out:  "␍␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r‛＇μ",
	}, { // 1129
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␉8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r＇μ",
		out:  "␉␉8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r‛＇μ",
	}, { // 1130
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␉8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r＇μ",
		out:  "‛␉␉8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r‛＇μ",
	}, { // 1131
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r␉μ",
		out:  "␉␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r␉μ",
	}, { // 1132
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r␉μ",
		out:  "‛␉␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r␉μ",
	}, { // 1133
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r＇␉",
		out:  "␉␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r‛＇␉",
	}, { // 1134
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r＇␉",
		out:  "‛␉␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r‛＇␉",
	}, { // 1135
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r\t8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r＇μ",
		out:  "␍\t8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r‛＇μ",
	}, { // 1136
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␉8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r＇μ",
		out:  "␍␉8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r‛＇μ",
	}, { // 1137
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r\t8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r␉μ",
		out:  "␍\t8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r␉μ",
	}, { // 1138
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␉8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r␉μ",
		out:  "␍␉8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r␉μ",
	}, { // 1139
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r\t8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r＇␉",
		out:  "␍\t8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r‛＇␉",
	}, { // 1140
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␉8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r＇␉",
		out:  "␍␉8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r‛＇␉",
	}, { // 1141
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r\tμ",
		out:  "␍␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r\tμ",
	}, { // 1142
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r␉μ",
		out:  "␍␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r␉μ",
	}, { // 1143
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r\t␉",
		out:  "␍␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r\t␉",
	}, { // 1144
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r␉␉",
		out:  "␍␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r␉␉",
	}, { // 1145
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r＇\t",
		out:  "␍␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r‛＇\t",
	}, { // 1146
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r＇␉",
		out:  "␍␆8\r\x17\x0e：␈␟η\tυ[φα#b␡␂＜＃\x14θ／>８＄\r‛＇␉",
	}, { // 1147
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␁",
		out:  "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␁",
	}, { // 1148
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\n␊SP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␁",
		out:  "␊␊SP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␁",
	}, { // 1149
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␊␊SP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␁",
		out:  "‛␊␊SP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␁",
	}, { // 1150
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\nαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␊␁",
		out:  "␊αSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␊␁",
	}, { // 1151
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␊αSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␊␁",
		out:  "‛␊αSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␊␁",
	}, { // 1152
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\nαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␊",
		out:  "␊αSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␊",
	}, { // 1153
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␊αSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␊",
		out:  "‛␊αSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␊",
	}, { // 1154
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "γ\nSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␁",
		out:  "γ\nSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␁",
	}, { // 1155
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "γ␊SP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␁",
		out:  "γ␊SP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␁",
	}, { // 1156
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "γ\nSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␊␁",
		out:  "γ\nSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␊␁",
	}, { // 1157
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "γ␊SP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␊␁",
		out:  "γ␊SP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␊␁",
	}, { // 1158
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "γ\nSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␊",
		out:  "γ\nSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␊",
	}, { // 1159
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "γ␊SP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␊",
		out:  "γ␊SP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␊",
	}, { // 1160
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_\n␁",
		out:  "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_\n␁",
	}, { // 1161
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␊␁",
		out:  "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␊␁",
	}, { // 1162
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_\n␊",
		out:  "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_\n␊",
	}, { // 1163
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␊␊",
		out:  "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␊␊",
	}, { // 1164
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋\n",
		out:  "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋\n",
	}, { // 1165
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␊",
		out:  "γαSP/␛ξ␞>！\n\rZ|｛\v０ｄ＜ｆε\a\"％ε␖ζ_␋␊",
	}, { // 1166
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*\x1c",
		out:  "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*\x1c",
	}, { // 1167
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\v␋ξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*\x1c",
		out:  "␋␋ξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*\x1c",
	}, { // 1168
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␋␋ξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*\x1c",
		out:  "‛␋␋ξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*\x1c",
	}, { // 1169
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\vςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς␋\x1c",
		out:  "␋ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς␋\x1c",
	}, { // 1170
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␋ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς␋\x1c",
		out:  "‛␋ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς␋\x1c",
	}, { // 1171
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\vςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*␋",
		out:  "␋ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*␋",
	}, { // 1172
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␋ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*␋",
		out:  "‛␋ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*␋",
	}, { // 1173
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＿\vξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*\x1c",
		out:  "＿\vξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*\x1c",
	}, { // 1174
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＿␋ξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*\x1c",
		out:  "＿␋ξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*\x1c",
	}, { // 1175
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＿\vξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς␋\x1c",
		out:  "＿\vξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς␋\x1c",
	}, { // 1176
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＿␋ξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς␋\x1c",
		out:  "＿␋ξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς␋\x1c",
	}, { // 1177
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＿\vξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*␋",
		out:  "＿\vξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*␋",
	}, { // 1178
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＿␋ξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*␋",
		out:  "＿␋ξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*␋",
	}, { // 1179
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς\v\x1c",
		out:  "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς\v\x1c",
	}, { // 1180
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς␋\x1c",
		out:  "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς␋\x1c",
	}, { // 1181
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς\v␋",
		out:  "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς\v␋",
	}, { // 1182
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς␋␋",
		out:  "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς␋␋",
	}, { // 1183
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*\v",
		out:  "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*\v",
	}, { // 1184
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*␋",
		out:  "＿ςξ；OV␁\r$\x04\v␂ｚ\v␘I，\f␅␌ηAＳι７θeς*␋",
	}, { // 1185
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1aC",
		out:  "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1aC",
	}, { // 1186
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␍␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1aC",
		out:  "␍␍␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1aC",
	}, { // 1187
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␍␍␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1aC",
		out:  "‛␍␍␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1aC",
	}, { // 1188
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟␍C",
		out:  "␍ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟␍C",
	}, { // 1189
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␍ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟␍C",
		out:  "‛␍ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟␍C",
	}, { // 1190
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1a␍",
		out:  "␍ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1a␍",
	}, { // 1191
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␍ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1a␍",
		out:  "‛␍ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1a␍",
	}, { // 1192
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＂\r␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1aC",
		out:  "＂\r␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1aC",
	}, { // 1193
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＂␍␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1aC",
		out:  "＂␍␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1aC",
	}, { // 1194
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＂\r␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟␍C",
		out:  "＂\r␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟␍C",
	}, { // 1195
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＂␍␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟␍C",
		out:  "＂␍␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟␍C",
	}, { // 1196
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＂\r␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1a␍",
		out:  "＂\r␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1a␍",
	}, { // 1197
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＂␍␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1a␍",
		out:  "＂␍␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1a␍",
	}, { // 1198
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\rC",
		out:  "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\rC",
	}, { // 1199
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟␍C",
		out:  "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟␍C",
	}, { // 1200
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\r␍",
		out:  "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\r␍",
	}, { // 1201
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟␍␍",
		out:  "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟␍␍",
	}, { // 1202
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1a\r",
		out:  "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1a\r",
	}, { // 1203
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1a␍",
		out:  "＂ ␅｝␗πａGμρ\r\x1dι\x1a`χ\\#␇）r＃[\x0fＹ＄９␟\x1a␍",
	}, { // 1204
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␌",
		out:  "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␌",
	}, { // 1205
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\t␉_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␌",
		out:  "␉␉_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␌",
	}, { // 1206
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␉␉_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␌",
		out:  "‛␉␉_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␌",
	}, { // 1207
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\t\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␉␌",
		out:  "␉\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␉␌",
	}, { // 1208
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␉\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␉␌",
		out:  "‛␉\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␉␌",
	}, { // 1209
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\t\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␉",
		out:  "␉\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␉",
	}, { // 1210
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␉\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␉",
		out:  "‛␉\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␉",
	}, { // 1211
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "5\t_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␌",
		out:  "5\t_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␌",
	}, { // 1212
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "5␉_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␌",
		out:  "5␉_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␌",
	}, { // 1213
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "5\t_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␉␌",
		out:  "5\t_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␉␌",
	}, { // 1214
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "5␉_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␉␌",
		out:  "5␉_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␉␌",
	}, { // 1215
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "5\t_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␉",
		out:  "5\t_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␉",
	}, { // 1216
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "5␉_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␉",
		out:  "5␉_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␉",
	}, { // 1217
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<\t␌",
		out:  "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<\t␌",
	}, { // 1218
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␉␌",
		out:  "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␉␌",
	}, { // 1219
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<\t␉",
		out:  "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<\t␉",
	}, { // 1220
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␉␉",
		out:  "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␉␉",
	}, { // 1221
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎\t",
		out:  "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎\t",
	}, { // 1222
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␉",
		out:  "5\x02_ＱSW＊ξD＄\tＶτβ\x03ψ？ο\n<\x11ｂ＇hθ␈＝<␎␉",
	}, { // 1223
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zkψ",
		out:  "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zkψ",
	}, { // 1224
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\n␊␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zkψ",
		out:  "␊␊␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zkψ",
	}, { // 1225
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␊␊␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zkψ",
		out:  "‛␊␊␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zkψ",
	}, { // 1226
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\n?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z␊ψ",
		out:  "␊?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z␊ψ",
	}, { // 1227
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␊?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z␊ψ",
		out:  "‛␊?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z␊ψ",
	}, { // 1228
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\n?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zk␊",
		out:  "␊?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zk␊",
	}, { // 1229
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␊?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zk␊",
		out:  "‛␊?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zk␊",
	}, { // 1230
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\a\n␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zkψ",
		out:  "\a\n␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zkψ",
	}, { // 1231
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\a␊␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zkψ",
		out:  "\a␊␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zkψ",
	}, { // 1232
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\a\n␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z␊ψ",
		out:  "\a\n␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z␊ψ",
	}, { // 1233
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\a␊␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z␊ψ",
		out:  "\a␊␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z␊ψ",
	}, { // 1234
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\a\n␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zk␊",
		out:  "\a\n␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zk␊",
	}, { // 1235
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\a␊␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zk␊",
		out:  "\a␊␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zk␊",
	}, { // 1236
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z\nψ",
		out:  "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z\nψ",
	}, { // 1237
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z␊ψ",
		out:  "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z␊ψ",
	}, { // 1238
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z\n␊",
		out:  "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z\n␊",
	}, { // 1239
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z␊␊",
		out:  "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Z␊␊",
	}, { // 1240
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zk\n",
		out:  "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zk\n",
	}, { // 1241
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zk␊",
		out:  "\a?␕θμ\x02ＨφＪ␊\n；␈δ\x1b1ρV␌␛Ｚ\x0e<kｄw６Zk␊",
	}, { // 1242
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␐",
		out:  "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␐",
	}, { // 1243
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\v␋^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␐",
		out:  "␋␋^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␐",
	}, { // 1244
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␋␋^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␐",
		out:  "‛␋␋^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␐",
	}, { // 1245
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\v\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２␋␐",
		out:  "␋\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２␋␐",
	}, { // 1246
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␋\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２␋␐",
		out:  "‛␋\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２␋␐",
	}, { // 1247
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\v\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␋",
		out:  "␋\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␋",
	}, { // 1248
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␋\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␋",
		out:  "‛␋\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␋",
	}, { // 1249
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ς\v^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␐",
		out:  "ς\v^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␐",
	}, { // 1250
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ς␋^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␐",
		out:  "ς␋^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␐",
	}, { // 1251
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ς\v^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２␋␐",
		out:  "ς\v^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２␋␐",
	}, { // 1252
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ς␋^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２␋␐",
		out:  "ς␋^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２␋␐",
	}, { // 1253
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ς\v^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␋",
		out:  "ς\v^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␋",
	}, { // 1254
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ς␋^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␋",
		out:  "ς␋^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␋",
	}, { // 1255
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\v␐",
		out:  "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\v␐",
	}, { // 1256
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２␋␐",
		out:  "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２␋␐",
	}, { // 1257
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\v␋",
		out:  "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\v␋",
	}, { // 1258
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２␋␋",
		out:  "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２␋␋",
	}, { // 1259
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\\v",
		out:  "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\\v",
	}, { // 1260
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␋",
		out:  "ς\u007f^\x06␒Tζ\x10ｅ＂\v／␚5＃Ｖ|εT２～*ｘξ\\Sε２\\␋",
	}, { // 1261
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "2\x04＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη\x1b",
		out:  "2\x04＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη\x1b",
	}, { // 1262
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\r␍＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη\x1b",
		out:  "␍␍＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη\x1b",
	}, { // 1263
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␍␍＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη\x1b",
		out:  "‛␍␍＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη\x1b",
	}, { // 1264
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\r\x04＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW␍\x1b",
		out:  "␍\x04＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW␍\x1b",
	}, { // 1265
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␍\x04＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW␍\x1b",
		out:  "‛␍\x04＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW␍\x1b",
	}, { // 1266
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\r\x04＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη␍",
		out:  "␍\x04＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη␍",
	}, { // 1267
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␍\x04＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη␍",
		out:  "‛␍\x04＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη␍",
	}, { // 1268
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "2\r＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη\x1b",
		out:  "2\r＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη\x1b",
	}, { // 1269
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "2␍＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη\x1b",
		out:  "2␍＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη\x1b",
	}, { // 1270
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "2\r＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW␍\x1b",
		out:  "2\r＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW␍\x1b",
	}, { // 1271
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "2␍＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW␍\x1b",
		out:  "2␍＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW␍\x1b",
	}, { // 1272
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "2\r＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη␍",
		out:  "2\r＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη␍",
	}, { // 1273
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "2␍＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη␍",
		out:  "2␍＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη␍",
	}, { // 1274
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "2\x04＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW\r\x1b",
		out:  "2\x04＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW\r\x1b",
	}, { // 1275
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "2\x04＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW␍\x1b",
		out:  "2\x04＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW␍\x1b",
	}, { // 1276
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "2\x04＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW\r␍",
		out:  "2\x04＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW\r␍",
	}, { // 1277
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "2\x04＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW␍␍",
		out:  "2\x04＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσW␍␍",
	}, { // 1278
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "2\x04＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη\r",
		out:  "2\x04＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη\r",
	}, { // 1279
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "2\x04＜`Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη␍",
		out:  "2\x04＜｀Ｕ．ι）\f␊\rf␄\x0eｔ␕ｘοP＂βO＊␗/εσWη␍",
	}, { // 1280
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "｛ωξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+χ",
		out:  "｛ωξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+χ",
	}, { // 1281
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\t␉ξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+χ",
		out:  "␉␉ξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+χ",
	}, { // 1282
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␉␉ξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+χ",
		out:  "‛␉␉ξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+χ",
	}, { // 1283
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\tωξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ␉χ",
		out:  "␉ωξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ␉χ",
	}, { // 1284
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␉ωξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ␉χ",
		out:  "‛␉ωξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ␉χ",
	}, { // 1285
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\tωξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+␉",
		out:  "␉ωξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+␉",
	}, { // 1286
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␉ωξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+␉",
		out:  "‛␉ωξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+␉",
	}, { // 1287
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "｛\tξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+χ",
		out:  "｛\tξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+χ",
	}, { // 1288
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "｛␉ξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+χ",
		out:  "｛␉ξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+χ",
	}, { // 1289
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "｛\tξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ␉χ",
		out:  "｛\tξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ␉χ",
	}, { // 1290
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "｛␉ξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ␉χ",
		out:  "｛␉ξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ␉χ",
	}, { // 1291
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "｛\tξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+␉",
		out:  "｛\tξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+␉",
	}, { // 1292
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "｛␉ξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+␉",
		out:  "｛␉ξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+␉",
	}, { // 1293
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "｛ωξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ\tχ",
		out:  "｛ωξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ\tχ",
	}, { // 1294
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "｛ωξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ␉χ",
		out:  "｛ωξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ␉χ",
	}, { // 1295
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "｛ωξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ\t␉",
		out:  "｛ωξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ\t␉",
	}, { // 1296
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "｛ωξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ␉␉",
		out:  "｛ωξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ␉␉",
	}, { // 1297
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "｛ωξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+\t",
		out:  "｛ωξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+\t",
	}, { // 1298
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "｛ωξTςv`＂\"$\tf␀\"＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+␉",
		out:  "｛ωξTςv`＂\"$\tf‛␀\"‛＞␏Ｇ*␄*␕ｎ\x11Ｖ\nηγＪ+␉",
	}, { // 1299
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ＇",
		out:  "‛＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ＇",
	}, { // 1300
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\n␊\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ＇",
		out:  "␊␊\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ＇",
	}, { // 1301
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␊␊\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ＇",
		out:  "‛␊␊\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ＇",
	}, { // 1302
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\nε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ␊＇",
		out:  "␊ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ␊＇",
	}, { // 1303
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␊ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ␊＇",
		out:  "‛␊ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ␊＇",
	}, { // 1304
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\nε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ␊",
		out:  "␊ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ␊",
	}, { // 1305
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␊ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ␊",
		out:  "‛␊ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ␊",
	}, { // 1306
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞\n\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ＇",
		out:  "‛＞\n\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ＇",
	}, { // 1307
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞␊\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ＇",
		out:  "‛＞␊\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ＇",
	}, { // 1308
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞\n\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ␊＇",
		out:  "‛＞\n\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ␊＇",
	}, { // 1309
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞␊\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ␊＇",
		out:  "‛＞␊\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ␊＇",
	}, { // 1310
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞\n\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ␊",
		out:  "‛＞\n\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ␊",
	}, { // 1311
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞␊\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ␊",
		out:  "‛＞␊\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ␊",
	}, { // 1312
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ\n＇",
		out:  "‛＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ\n＇",
	}, { // 1313
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ␊＇",
		out:  "‛＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ␊＇",
	}, { // 1314
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ\n␊",
		out:  "‛＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ\n␊",
	}, { // 1315
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ␊␊",
		out:  "‛＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|Ｆ␊␊",
	}, { // 1316
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ\n",
		out:  "‛＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ\n",
	}, { // 1317
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ␊",
		out:  "‛＞ε\x03ｑ\a\n＃οＦε\n␙aL␊V\x1e\x1aβＵ\vv:␖ξ｝|ＦＤ␊",
	}, { // 1318
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄\x1d",
		out:  "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄\x1d",
	}, { // 1319
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\v␋|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄\x1d",
		out:  "␋␋|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄\x1d",
	}, { // 1320
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␋␋|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄\x1d",
		out:  "‛␋␋|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄\x1d",
	}, { // 1321
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\vｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␋\x1d",
		out:  "␋ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␋\x1d",
	}, { // 1322
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␋ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␋\x1d",
		out:  "‛␋ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␋\x1d",
	}, { // 1323
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\vｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄␋",
		out:  "␋ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄␋",
	}, { // 1324
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␋ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄␋",
		out:  "‛␋ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄␋",
	}, { // 1325
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␛\v|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄\x1d",
		out:  "␛\v|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄\x1d",
	}, { // 1326
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␛␋|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄\x1d",
		out:  "␛␋|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄\x1d",
	}, { // 1327
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␛\v|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␋\x1d",
		out:  "␛\v|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␋\x1d",
	}, { // 1328
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␛␋|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␋\x1d",
		out:  "␛␋|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␋\x1d",
	}, { // 1329
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␛\v|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄␋",
		out:  "␛\v|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄␋",
	}, { // 1330
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␛␋|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄␋",
		out:  "␛␋|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄␋",
	}, { // 1331
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ\v\x1d",
		out:  "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ\v\x1d",
	}, { // 1332
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␋\x1d",
		out:  "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␋\x1d",
	}, { // 1333
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ\v␋",
		out:  "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ\v␋",
	}, { // 1334
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␋␋",
		out:  "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␋␋",
	}, { // 1335
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄\v",
		out:  "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄\v",
	}, { // 1336
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄␋",
		out:  "␛ｎ|ihτθλ␖\x11\v@＇\rκ␖ＩｈＪ\rｓ␁e；D\x17βφ␄␋",
	}, { // 1337
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞␎．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／α",
		out:  "‛＞␎．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／α",
	}, { // 1338
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\r␍．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／α",
		out:  "␍␍．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／α",
	}, { // 1339
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␍␍．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／α",
		out:  "‛␍␍．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／α",
	}, { // 1340
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\r␎．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ␍α",
		out:  "␍␎．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ␍α",
	}, { // 1341
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␍␎．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ␍α",
		out:  "‛␍␎．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ␍α",
	}, { // 1342
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\r␎．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／␍",
		out:  "␍␎．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／␍",
	}, { // 1343
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␍␎．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／␍",
		out:  "‛␍␎．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／␍",
	}, { // 1344
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞\r．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／α",
		out:  "‛＞\r．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／α",
	}, { // 1345
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞␍．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／α",
		out:  "‛＞␍．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／α",
	}, { // 1346
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞\r．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ␍α",
		out:  "‛＞\r．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ␍α",
	}, { // 1347
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞␍．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ␍α",
		out:  "‛＞␍．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ␍α",
	}, { // 1348
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞\r．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／␍",
		out:  "‛＞\r．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／␍",
	}, { // 1349
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞␍．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／␍",
		out:  "‛＞␍．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／␍",
	}, { // 1350
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞␎．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ\rα",
		out:  "‛＞␎．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ\rα",
	}, { // 1351
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞␎．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ␍α",
		out:  "‛＞␎．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ␍α",
	}, { // 1352
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞␎．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ\r␍",
		out:  "‛＞␎．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ\r␍",
	}, { // 1353
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞␎．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ␍␍",
		out:  "‛＞␎．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ␍␍",
	}, { // 1354
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞␎．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／\r",
		out:  "‛＞␎．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／\r",
	}, { // 1355
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "＞␎．\x17S？v\x00ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／␍",
		out:  "‛＞␎．\x17S？v␀ｇ \r－τ\x02\x1e␋λδ＊\u007f:／Ｋ.ψ\x17uπ／␍",
	}, { // 1356
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1cφU",
		out:  "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1cφU",
	}, { // 1357
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\t␉｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1cφU",
		out:  "␉␉｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1cφU",
	}, { // 1358
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␉␉｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1cφU",
		out:  "‛␉␉｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1cφU",
	}, { // 1359
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\t＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1c␉U",
		out:  "␉＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1c␉U",
	}, { // 1360
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␉＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1c␉U",
		out:  "‛␉＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1c␉U",
	}, { // 1361
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\t＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1cφ␉",
		out:  "␉＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1cφ␉",
	}, { // 1362
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␉＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1cφ␉",
		out:  "‛␉＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1cφ␉",
	}, { // 1363
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␜\t｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1cφU",
		out:  "␜\t｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1cφU",
	}, { // 1364
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␜␉｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1cφU",
		out:  "␜␉｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1cφU",
	}, { // 1365
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␜\t｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1c␉U",
		out:  "␜\t｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1c␉U",
	}, { // 1366
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␜␉｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1c␉U",
		out:  "␜␉｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1c␉U",
	}, { // 1367
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␜\t｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1cφ␉",
		out:  "␜\t｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1cφ␉",
	}, { // 1368
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␜␉｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1cφ␉",
		out:  "␜␉｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1cφ␉",
	}, { // 1369
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1c\tU",
		out:  "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1c\tU",
	}, { // 1370
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1c␉U",
		out:  "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1c␉U",
	}, { // 1371
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1c\t␉",
		out:  "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1c\t␉",
	}, { // 1372
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1c␉␉",
		out:  "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1c␉␉",
	}, { // 1373
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1cφ\t",
		out:  "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1cφ\t",
	}, { // 1374
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／$␞，iτ\x1cφ␉",
		out:  "␜＜｛.？πｊ＞：α\t\x14πEγ\x1b␊/ＭSr／＄␞，iτ\x1cφ␉",
	}, { // 1375
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ＂",
		out:  "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ＂",
	}, { // 1376
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\n␊\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ＂",
		out:  "␊␊\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ＂",
	}, { // 1377
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊␊\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ＂",
		out:  "‛␊␊\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ＂",
	}, { // 1378
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\nρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏␊＂",
		out:  "␊ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏␊＂",
	}, { // 1379
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏␊＂",
		out:  "‛␊ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏␊＂",
	}, { // 1380
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\nρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ␊",
		out:  "␊ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ␊",
	}, { // 1381
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ␊",
		out:  "‛␊ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ␊",
	}, { // 1382
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀\n\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ＂",
		out:  "｀\n\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ＂",
	}, { // 1383
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␊\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ＂",
		out:  "｀␊\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ＂",
	}, { // 1384
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀\n\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏␊＂",
		out:  "｀\n\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏␊＂",
	}, { // 1385
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␊\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏␊＂",
		out:  "｀␊\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏␊＂",
	}, { // 1386
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀\n\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ␊",
		out:  "｀\n\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ␊",
	}, { // 1387
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␊\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ␊",
		out:  "｀␊\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ␊",
	}, { // 1388
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏\n＂",
		out:  "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏\n＂",
	}, { // 1389
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏␊＂",
		out:  "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏␊＂",
	}, { // 1390
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏\n␊",
		out:  "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏\n␊",
	}, { // 1391
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏␊␊",
		out:  "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏␊␊",
	}, { // 1392
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ\n",
		out:  "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ\n",
	}, { // 1393
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ␊",
		out:  "｀ρ\"@hｚηｌ]＂\n␜\x1c%ι4ρ`q＿'／\\δφ\x02␕␏Ｉ␊",
	}, { // 1394
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε$",
		out:  "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε＄",
	}, { // 1395
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\v␋8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε$",
		out:  "␋␋8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε＄",
	}, { // 1396
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␋␋8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε$",
		out:  "‛␋␋8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε＄",
	}, { // 1397
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\v␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν␋$",
		out:  "␋␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν␋＄",
	}, { // 1398
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␋␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν␋$",
		out:  "‛␋␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν␋＄",
	}, { // 1399
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\v␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε␋",
		out:  "␋␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε␋",
	}, { // 1400
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␋␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε␋",
		out:  "‛␋␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε␋",
	}, { // 1401
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀\v8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε$",
		out:  "｀\v8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε＄",
	}, { // 1402
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␋8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε$",
		out:  "｀␋8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε＄",
	}, { // 1403
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀\v8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν␋$",
		out:  "｀\v8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν␋＄",
	}, { // 1404
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␋8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν␋$",
		out:  "｀␋8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν␋＄",
	}, { // 1405
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀\v8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε␋",
		out:  "｀\v8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε␋",
	}, { // 1406
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␋8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε␋",
		out:  "｀␋8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε␋",
	}, { // 1407
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν\v$",
		out:  "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν\v＄",
	}, { // 1408
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν␋$",
		out:  "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν␋＄",
	}, { // 1409
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν\v␋",
		out:  "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν\v␋",
	}, { // 1410
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν␋␋",
		out:  "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%ν␋␋",
	}, { // 1411
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε\v",
		out:  "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε\v",
	}, { // 1412
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε␋",
		out:  "｀␈8\fη\a｀９<(\v`．ξt］:␝␏␞δ＞\tｂ／l%νε␋",
	}, { // 1413
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "＼ς/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a4χ",
		out:  "＼ς/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a4χ",
	}, { // 1414
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\r␍/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a4χ",
		out:  "␍␍/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a4χ",
	}, { // 1415
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␍␍/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a4χ",
		out:  "‛␍␍/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a4χ",
	}, { // 1416
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\rς/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a␍χ",
		out:  "␍ς/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a␍χ",
	}, { // 1417
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␍ς/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a␍χ",
		out:  "‛␍ς/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a␍χ",
	}, { // 1418
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\rς/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a4␍",
		out:  "␍ς/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a4␍",
	}, { // 1419
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␍ς/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a4␍",
		out:  "‛␍ς/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a4␍",
	}, { // 1420
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "＼\r/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a4χ",
		out:  "＼\r/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a4χ",
	}, { // 1421
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "＼␍/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a4χ",
		out:  "＼␍/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a4χ",
	}, { // 1422
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "＼\r/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a␍χ",
		out:  "＼\r/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a␍χ",
	}, { // 1423
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "＼␍/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a␍χ",
		out:  "＼␍/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a␍χ",
	}, { // 1424
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "＼\r/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a4␍",
		out:  "＼\r/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a4␍",
	}, { // 1425
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "＼␍/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a4␍",
		out:  "＼␍/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a4␍",
	}, { // 1426
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "＼ς/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a\rχ",
		out:  "＼ς/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a\rχ",
	}, { // 1427
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "＼ς/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a␍χ",
		out:  "＼ς/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a␍χ",
	}, { // 1428
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "＼ς/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a\r␍",
		out:  "＼ς/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a\r␍",
	}, { // 1429
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "＼ς/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a␍␍",
		out:  "＼ς/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a␍␍",
	}, { // 1430
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "＼ς/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a4\r",
		out:  "＼ς/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a4\r",
	}, { // 1431
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "＼ς/κ$$yO＄２\rＱ＼␙␒＄ν［ωｗgxLδ\x1f！\n\a4␍",
		out:  "＼ς/κ＄＄yO‛＄２\rＱ＼␙␒‛＄ν［ωｗgxLδ\x1f！\n\a4␍",
	}, { // 1432
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "］τ％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝\x1c",
		out:  "］τ％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝\x1c",
	}, { // 1433
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␉％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝\x1c",
		out:  "␉␉％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝\x1c",
	}, { // 1434
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␉％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝\x1c",
		out:  "‛␉␉％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝\x1c",
	}, { // 1435
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\tτ％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m␉\x1c",
		out:  "␉τ％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m␉\x1c",
	}, { // 1436
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␉τ％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m␉\x1c",
		out:  "‛␉τ％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m␉\x1c",
	}, { // 1437
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\tτ％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝␉",
		out:  "␉τ％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝␉",
	}, { // 1438
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␉τ％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝␉",
		out:  "‛␉τ％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝␉",
	}, { // 1439
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "］\t％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝\x1c",
		out:  "］\t％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝\x1c",
	}, { // 1440
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "］␉％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝\x1c",
		out:  "］␉％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝\x1c",
	}, { // 1441
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "］\t％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m␉\x1c",
		out:  "］\t％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m␉\x1c",
	}, { // 1442
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "］␉％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m␉\x1c",
		out:  "］␉％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m␉\x1c",
	}, { // 1443
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "］\t％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝␉",
		out:  "］\t％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝␉",
	}, { // 1444
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "］␉％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝␉",
		out:  "］␉％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝␉",
	}, { // 1445
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "］τ％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m\t\x1c",
		out:  "］τ％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m\t\x1c",
	}, { // 1446
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "］τ％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m␉\x1c",
		out:  "］τ％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m␉\x1c",
	}, { // 1447
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "］τ％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m\t␉",
		out:  "］τ％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m\t␉",
	}, { // 1448
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "］τ％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m␉␉",
		out:  "］τ％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m␉␉",
	}, { // 1449
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "］τ％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝\t",
		out:  "］τ％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝\t",
	}, { // 1450
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "］τ％＿J\x168\r␡θ\t＿␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝␉",
		out:  "］τ％＿J\x168\r␡θ\t＿‛␀λ␜\b}^χｚσ；\u007f\vβ(＇m＝␉",
	}, { // 1451
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σＰ",
		out:  "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σＰ",
	}, { // 1452
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\n␊（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σＰ",
		out:  "␊␊（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σＰ",
	}, { // 1453
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␊␊（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σＰ",
		out:  "‛␊␊（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σＰ",
	}, { // 1454
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\n!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$␊Ｐ",
		out:  "␊!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$␊Ｐ",
	}, { // 1455
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␊!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$␊Ｐ",
		out:  "‛␊!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$␊Ｐ",
	}, { // 1456
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\n!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σ␊",
		out:  "␊!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σ␊",
	}, { // 1457
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␊!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σ␊",
		out:  "‛␊!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σ␊",
	}, { // 1458
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ξ\n（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σＰ",
		out:  "ξ\n（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σＰ",
	}, { // 1459
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ξ␊（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σＰ",
		out:  "ξ␊（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σＰ",
	}, { // 1460
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ξ\n（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$␊Ｐ",
		out:  "ξ\n（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$␊Ｐ",
	}, { // 1461
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ξ␊（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$␊Ｐ",
		out:  "ξ␊（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$␊Ｐ",
	}, { // 1462
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ξ\n（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σ␊",
		out:  "ξ\n（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σ␊",
	}, { // 1463
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ξ␊（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σ␊",
		out:  "ξ␊（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σ␊",
	}, { // 1464
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$\nＰ",
		out:  "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$\nＰ",
	}, { // 1465
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$␊Ｐ",
		out:  "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$␊Ｐ",
	}, { // 1466
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$\n␊",
		out:  "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$\n␊",
	}, { // 1467
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$␊␊",
		out:  "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$␊␊",
	}, { // 1468
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σ\n",
		out:  "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σ\n",
	}, { // 1469
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σ␊",
		out:  "ξ!（'ｙd\x05␌＞␋\n=＜\x11ψ\b8δ^λ␛＠␙␌ｘξ\x0f$σ␊",
	}, { // 1470
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/εο",
		out:  "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/εο",
	}, { // 1471
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\v␋␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/εο",
		out:  "␋␋␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/εο",
	}, { // 1472
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋␋␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/εο",
		out:  "‛␋␋␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/εο",
	}, { // 1473
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\v'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/␋ο",
		out:  "␋'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/␋ο",
	}, { // 1474
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/␋ο",
		out:  "‛␋'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/␋ο",
	}, { // 1475
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\v'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/ε␋",
		out:  "␋'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/ε␋",
	}, { // 1476
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/ε␋",
		out:  "‛␋'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/ε␋",
	}, { // 1477
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␎\v␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/εο",
		out:  "␎\v␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/εο",
	}, { // 1478
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␎␋␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/εο",
		out:  "␎␋␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/εο",
	}, { // 1479
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␎\v␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/␋ο",
		out:  "␎\v␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/␋ο",
	}, { // 1480
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␎␋␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/␋ο",
		out:  "␎␋␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/␋ο",
	}, { // 1481
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␎\v␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/ε␋",
		out:  "␎\v␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/ε␋",
	}, { // 1482
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␎␋␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/ε␋",
		out:  "␎␋␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/ε␋",
	}, { // 1483
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/\vο",
		out:  "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/\vο",
	}, { // 1484
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/␋ο",
		out:  "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/␋ο",
	}, { // 1485
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/\v␋",
		out:  "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/\v␋",
	}, { // 1486
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/␋␋",
		out:  "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/␋␋",
	}, { // 1487
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/ε\v",
		out:  "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/ε\v",
	}, { // 1488
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/ε␋",
		out:  "␎'␎␚\x04jλ*ｕｘ\v＃v%␖\x13τｑ\x14νＭ6u␡\x0eθ␃/ε␋",
	}, { // 1489
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｎ|␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ Ｐ",
		out:  "Ｎ|␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ Ｐ",
	}, { // 1490
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␍␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ Ｐ",
		out:  "␍␍␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ Ｐ",
	}, { // 1491
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␍␍␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ Ｐ",
		out:  "‛␍␍␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ Ｐ",
	}, { // 1492
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r|␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝␍Ｐ",
		out:  "␍|␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝␍Ｐ",
	}, { // 1493
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␍|␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝␍Ｐ",
		out:  "‛␍|␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝␍Ｐ",
	}, { // 1494
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r|␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ ␍",
		out:  "␍|␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ ␍",
	}, { // 1495
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␍|␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ ␍",
		out:  "‛␍|␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ ␍",
	}, { // 1496
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｎ\r␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ Ｐ",
		out:  "Ｎ\r␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ Ｐ",
	}, { // 1497
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｎ␍␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ Ｐ",
		out:  "Ｎ␍␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ Ｐ",
	}, { // 1498
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｎ\r␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝␍Ｐ",
		out:  "Ｎ\r␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝␍Ｐ",
	}, { // 1499
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｎ␍␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝␍Ｐ",
		out:  "Ｎ␍␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝␍Ｐ",
	}, { // 1500
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｎ\r␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ ␍",
		out:  "Ｎ\r␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ ␍",
	}, { // 1501
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｎ␍␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ ␍",
		out:  "Ｎ␍␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ ␍",
	}, { // 1502
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｎ|␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝\rＰ",
		out:  "Ｎ|␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝\rＰ",
	}, { // 1503
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｎ|␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝␍Ｐ",
		out:  "Ｎ|␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝␍Ｐ",
	}, { // 1504
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｎ|␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝\r␍",
		out:  "Ｎ|␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝\r␍",
	}, { // 1505
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｎ|␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝␍␍",
		out:  "Ｎ|␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝␍␍",
	}, { // 1506
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｎ|␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ \r",
		out:  "Ｎ|␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ \r",
	}, { // 1507
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "Ｎ|␘p%％\x18＊\"\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ ␍",
		out:  "Ｎ|␘p%％\x18＊＂\x1c\r!ν-λ；η\x11␔LＯυ␋␘/＊ψ｝ ␍",
	}, { // 1508
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑οｄ",
		out:  "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑οｄ",
	}, { // 1509
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\t␉ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑οｄ",
		out:  "␉␉ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑οｄ",
	}, { // 1510
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␉␉ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑οｄ",
		out:  "‛␉␉ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑οｄ",
	}, { // 1511
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\t％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑␉ｄ",
		out:  "␉％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑␉ｄ",
	}, { // 1512
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␉％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑␉ｄ",
		out:  "‛␉％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑␉ｄ",
	}, { // 1513
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\t％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑ο␉",
		out:  "␉％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑ο␉",
	}, { // 1514
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␉％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑ο␉",
		out:  "‛␉％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑ο␉",
	}, { // 1515
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k\tｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑οｄ",
		out:  "k\tｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑οｄ",
	}, { // 1516
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k␉ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑οｄ",
		out:  "k␉ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑οｄ",
	}, { // 1517
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k\tｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑␉ｄ",
		out:  "k\tｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑␉ｄ",
	}, { // 1518
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k␉ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑␉ｄ",
		out:  "k␉ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑␉ｄ",
	}, { // 1519
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k\tｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑ο␉",
		out:  "k\tｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑ο␉",
	}, { // 1520
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k␉ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑ο␉",
		out:  "k␉ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑ο␉",
	}, { // 1521
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑\tｄ",
		out:  "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑\tｄ",
	}, { // 1522
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑␉ｄ",
		out:  "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑␉ｄ",
	}, { // 1523
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑\t␉",
		out:  "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑\t␉",
	}, { // 1524
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑␉␉",
		out:  "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑␉␉",
	}, { // 1525
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑ο\t",
		out:  "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑ο\t",
	}, { // 1526
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13:␑ο␉",
		out:  "k％ｍＷ\x04fονP｜\tE␑/σ\\!｝>σ？γ／\x17｝\x13：␑ο␉",
	}, { // 1527
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␁\r",
		out:  "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␁\r",
	}, { // 1528
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\n␊ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␁\r",
		out:  "␊␊ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␁\r",
	}, { // 1529
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␊␊ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␁\r",
		out:  "‛␊␊ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␁\r",
	}, { // 1530
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\n\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␊\r",
		out:  "␊\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␊\r",
	}, { // 1531
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␊\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␊\r",
		out:  "‛␊\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␊\r",
	}, { // 1532
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\n\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␁␊",
		out:  "␊\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␁␊",
	}, { // 1533
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␊\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␁␊",
		out:  "‛␊\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␁␊",
	}, { // 1534
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "I\nｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␁\r",
		out:  "I\nｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␁\r",
	}, { // 1535
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "I␊ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␁\r",
		out:  "I␊ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␁\r",
	}, { // 1536
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "I\nｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␊\r",
		out:  "I\nｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␊\r",
	}, { // 1537
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "I␊ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␊\r",
		out:  "I␊ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␊\r",
	}, { // 1538
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "I\nｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␁␊",
		out:  "I\nｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␁␊",
	}, { // 1539
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "I␊ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␁␊",
		out:  "I␊ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␁␊",
	}, { // 1540
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`\n\r",
		out:  "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`\n\r",
	}, { // 1541
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␊\r",
		out:  "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␊\r",
	}, { // 1542
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`\n␊",
		out:  "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`\n␊",
	}, { // 1543
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␊␊",
		out:  "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␊␊",
	}, { // 1544
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␁\n",
		out:  "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␁\n",
	}, { // 1545
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν：\x03g\x18μσ\x13／＼`␁␊",
		out:  "I\x05ｖ4,/Ｃ␈␐ζ\nIａν｛␞εν‛：\x03g\x18μσ\x13／＼`␁␊",
	}, { // 1546
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍλ",
		out:  "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍλ",
	}, { // 1547
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v␋zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍλ",
		out:  "␋␋zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍλ",
	}, { // 1548
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␋␋zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍλ",
		out:  "‛␋␋zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍλ",
	}, { // 1549
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0␋λ",
		out:  "␋<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0␋λ",
	}, { // 1550
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␋<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0␋λ",
		out:  "‛␋<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0␋λ",
	}, { // 1551
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍ␋",
		out:  "␋<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍ␋",
	}, { // 1552
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␋<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍ␋",
		out:  "‛␋<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍ␋",
	}, { // 1553
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "Ｇ\vzεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍλ",
		out:  "Ｇ\vzεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍλ",
	}, { // 1554
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "Ｇ␋zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍλ",
		out:  "Ｇ␋zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍλ",
	}, { // 1555
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "Ｇ\vzεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0␋λ",
		out:  "Ｇ\vzεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0␋λ",
	}, { // 1556
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "Ｇ␋zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0␋λ",
		out:  "Ｇ␋zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0␋λ",
	}, { // 1557
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "Ｇ\vzεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍ␋",
		out:  "Ｇ\vzεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍ␋",
	}, { // 1558
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "Ｇ␋zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍ␋",
		out:  "Ｇ␋zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍ␋",
	}, { // 1559
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0\vλ",
		out:  "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0\vλ",
	}, { // 1560
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0␋λ",
		out:  "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0␋λ",
	}, { // 1561
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0\v␋",
		out:  "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0\v␋",
	}, { // 1562
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0␋␋",
		out:  "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0␋␋",
	}, { // 1563
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍ\v",
		out:  "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍ\v",
	}, { // 1564
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍ␋",
		out:  "Ｇ<zεｘ\a＂␖␈␙\v\r５ \x03｜ME?５␕χοθ␋υ.0Ｍ␋",
	}, { // 1565
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎＨ",
		out:  "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎＨ",
	}, { // 1566
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\r␍␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎＨ",
		out:  "␍␍␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎＨ",
	}, { // 1567
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␍␍␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎＨ",
		out:  "‛␍␍␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎＨ",
	}, { // 1568
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\r\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$␍Ｈ",
		out:  "␍\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$␍Ｈ",
	}, { // 1569
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␍\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$␍Ｈ",
		out:  "‛␍\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$␍Ｈ",
	}, { // 1570
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\r\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎ␍",
		out:  "␍\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎ␍",
	}, { // 1571
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␍\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎ␍",
		out:  "‛␍\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎ␍",
	}, { // 1572
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "v\r␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎＨ",
		out:  "v\r␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎＨ",
	}, { // 1573
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "v␍␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎＨ",
		out:  "v␍␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎＨ",
	}, { // 1574
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "v\r␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$␍Ｈ",
		out:  "v\r␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$␍Ｈ",
	}, { // 1575
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "v␍␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$␍Ｈ",
		out:  "v␍␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$␍Ｈ",
	}, { // 1576
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "v\r␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎ␍",
		out:  "v\r␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎ␍",
	}, { // 1577
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "v␍␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎ␍",
		out:  "v␍␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎ␍",
	}, { // 1578
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$\rＨ",
		out:  "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$\rＨ",
	}, { // 1579
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$␍Ｈ",
		out:  "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$␍Ｈ",
	}, { // 1580
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$\r␍",
		out:  "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$\r␍",
	}, { // 1581
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$␍␍",
		out:  "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$␍␍",
	}, { // 1582
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎ\r",
		out:  "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎ\r",
	}, { // 1583
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎ␍",
		out:  "v\x02␉ａｋJvｙ\x18ρ\rα␙＃／'\x0fzα␜C\x0e＼δκ|ｈ$ｎ␍",
	}, { // 1584
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒ιr",
		out:  ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒ιr",
	}, { // 1585
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\t␉zο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒ιr",
		out:  "␉␉zο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒ιr",
	}, { // 1586
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉␉zο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒ιr",
		out:  "‛␉␉zο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒ιr",
	}, { // 1587
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\tχzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒␉r",
		out:  "␉χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒␉r",
	}, { // 1588
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒␉r",
		out:  "‛␉χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒␉r",
	}, { // 1589
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\tχzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒ι␉",
		out:  "␉χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒ι␉",
	}, { // 1590
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒ι␉",
		out:  "‛␉χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒ι␉",
	}, { // 1591
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   ":\tzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒ιr",
		out:  ":\tzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒ιr",
	}, { // 1592
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   ":␉zο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒ιr",
		out:  ":␉zο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒ιr",
	}, { // 1593
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   ":\tzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒␉r",
		out:  ":\tzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒␉r",
	}, { // 1594
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   ":␉zο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒␉r",
		out:  ":␉zο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒␉r",
	}, { // 1595
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   ":\tzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒ι␉",
		out:  ":\tzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒ι␉",
	}, { // 1596
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   ":␉zο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒ι␉",
		out:  ":␉zο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒ι␉",
	}, { // 1597
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒\tr",
		out:  ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒\tr",
	}, { // 1598
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒␉r",
		out:  ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒␉r",
	}, { // 1599
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒\t␉",
		out:  ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒\t␉",
	}, { // 1600
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒␉␉",
		out:  ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒␉␉",
	}, { // 1601
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒ι\t",
		out:  ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒ι\t",
	}, { // 1602
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a\x00Dqν＇Ｉ\x10␒ι␉",
		out:  ":χzο＝μ␑/｜Ｆ\tδ␚\x1c␊Ｏ=ｔ＿\x1a␀Dqν＇Ｉ\x10␒ι␉",
	}, { // 1603
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
		out:  "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
	}, { // 1604
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\n␊␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
		out:  "␊␊␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
	}, { // 1605
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␊␊␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
		out:  "‛␊␊␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
	}, { // 1606
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\n\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
		out:  "␊\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
	}, { // 1607
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␊\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
		out:  "‛␊\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
	}, { // 1608
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\n\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␊",
		out:  "␊\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␊",
	}, { // 1609
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␊\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␊",
		out:  "‛␊\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␊",
	}, { // 1610
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ｓ\n␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
		out:  "ｓ\n␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
	}, { // 1611
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ｓ␊␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
		out:  "ｓ␊␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
	}, { // 1612
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ｓ\n␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
		out:  "ｓ\n␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
	}, { // 1613
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ｓ␊␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
		out:  "ｓ␊␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
	}, { // 1614
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ｓ\n␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␊",
		out:  "ｓ\n␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␊",
	}, { // 1615
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ｓ␊␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␊",
		out:  "ｓ␊␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␊",
	}, { // 1616
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18\n␔",
		out:  "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18\n␔",
	}, { // 1617
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
		out:  "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␔",
	}, { // 1618
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18\n␊",
		out:  "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18\n␊",
	}, { // 1619
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␊",
		out:  "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␊",
	}, { // 1620
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊\n",
		out:  "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊\n",
	}, { // 1621
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␊",
		out:  "ｓ\v␋pτ＼λρεο\n␐(２3９＠＆\x19{\x1b\vQＺ＇σ\x1d\x18␊␊",
	}, { // 1622
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜\r",
		out:  "‛␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜\r",
	}, { // 1623
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\v␋*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜\r",
		out:  "␋␋*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜\r",
	}, { // 1624
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␋␋*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜\r",
		out:  "‛␋␋*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜\r",
	}, { // 1625
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\v＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η␋\r",
		out:  "␋＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η␋\r",
	}, { // 1626
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␋＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η␋\r",
		out:  "‛␋＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η␋\r",
	}, { // 1627
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\v＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜␋",
		out:  "␋＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜␋",
	}, { // 1628
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␋＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜␋",
		out:  "‛␋＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜␋",
	}, { // 1629
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␀\v*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜\r",
		out:  "‛␀\v*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜\r",
	}, { // 1630
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␀␋*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜\r",
		out:  "‛␀␋*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜\r",
	}, { // 1631
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␀\v*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η␋\r",
		out:  "‛␀\v*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η␋\r",
	}, { // 1632
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␀␋*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η␋\r",
		out:  "‛␀␋*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η␋\r",
	}, { // 1633
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␀\v*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜␋",
		out:  "‛␀\v*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜␋",
	}, { // 1634
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␀␋*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜␋",
		out:  "‛␀␋*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜␋",
	}, { // 1635
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η\v\r",
		out:  "‛␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η\v\r",
	}, { // 1636
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η␋\r",
		out:  "‛␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η␋\r",
	}, { // 1637
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η\v␋",
		out:  "‛␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η\v␋",
	}, { // 1638
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η␋␋",
		out:  "‛␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η␋␋",
	}, { // 1639
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜\v",
		out:  "‛␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜\v",
	}, { // 1640
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜␋",
		out:  "‛␀＿*:\x11νl／9Ｔ\vωg4␏＿ｉ1␍θτ\x19ω`Ｉ\x05␉η＜␋",
	}, { // 1641
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌβ",
		out:  "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌβ",
	}, { // 1642
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\r␍\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌβ",
		out:  "␍␍\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌβ",
	}, { // 1643
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␍␍\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌβ",
		out:  "‛␍␍\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌβ",
	}, { // 1644
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\r\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛␍β",
		out:  "␍\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛␍β",
	}, { // 1645
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␍\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛␍β",
		out:  "‛␍\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛␍β",
	}, { // 1646
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\r\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌ␍",
		out:  "␍\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌ␍",
	}, { // 1647
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␍\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌ␍",
		out:  "‛␍\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌ␍",
	}, { // 1648
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "＾\r\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌβ",
		out:  "＾\r\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌβ",
	}, { // 1649
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "＾␍\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌβ",
		out:  "＾␍\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌβ",
	}, { // 1650
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "＾\r\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛␍β",
		out:  "＾\r\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛␍β",
	}, { // 1651
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "＾␍\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛␍β",
		out:  "＾␍\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛␍β",
	}, { // 1652
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "＾\r\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌ␍",
		out:  "＾\r\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌ␍",
	}, { // 1653
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "＾␍\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌ␍",
		out:  "＾␍\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌ␍",
	}, { // 1654
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛\rβ",
		out:  "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛\rβ",
	}, { // 1655
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛␍β",
		out:  "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛␍β",
	}, { // 1656
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛\r␍",
		out:  "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛\r␍",
	}, { // 1657
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛␍␍",
		out:  "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛␍␍",
	}, { // 1658
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌ\r",
		out:  "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌ\r",
	}, { // 1659
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌ␍",
		out:  "＾\x10\tｚι\nF␏#␟\r%τＰχ\"β␙␃/␝YC\n␑κ)｛Ｌ␍",
	}, { // 1660
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀\x18",
		out:  "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀\x18",
	}, { // 1661
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\t␉\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀\x18",
		out:  "␉␉\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀\x18",
	}, { // 1662
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␉␉\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀\x18",
		out:  "‛␉␉\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀\x18",
	}, { // 1663
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\tL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼␉\x18",
		out:  "␉L\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼␉\x18",
	}, { // 1664
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␉L\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼␉\x18",
		out:  "‛␉L\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼␉\x18",
	}, { // 1665
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\tL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀␉",
		out:  "␉L\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀␉",
	}, { // 1666
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␉L\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀␉",
		out:  "‛␉L\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀␉",
	}, { // 1667
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "Ａ\t\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀\x18",
		out:  "Ａ\t\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀\x18",
	}, { // 1668
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "Ａ␉\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀\x18",
		out:  "Ａ␉\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀\x18",
	}, { // 1669
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "Ａ\t\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼␉\x18",
		out:  "Ａ\t\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼␉\x18",
	}, { // 1670
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "Ａ␉\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼␉\x18",
		out:  "Ａ␉\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼␉\x18",
	}, { // 1671
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "Ａ\t\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀␉",
		out:  "Ａ\t\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀␉",
	}, { // 1672
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "Ａ␉\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀␉",
		out:  "Ａ␉\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀␉",
	}, { // 1673
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼\t\x18",
		out:  "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼\t\x18",
	}, { // 1674
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼␉\x18",
		out:  "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼␉\x18",
	}, { // 1675
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼\t␉",
		out:  "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼\t␉",
	}, { // 1676
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼␉␉",
		out:  "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼␉␉",
	}, { // 1677
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀\t",
		out:  "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀\t",
	}, { // 1678
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀␉",
		out:  "ＡL\x16\x18ｆu␕θ␛R\t\x16\\ω＆Ｎ π␛χιυ］\x19\x02j？＼｀␉",
	}, { // 1679
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡAＵ\x0e",
		out:  "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡAＵ\x0e",
	}, { // 1680
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n␊βφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡAＵ\x0e",
		out:  "␊␊βφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡAＵ\x0e",
	}, { // 1681
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␊␊βφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡAＵ\x0e",
		out:  "‛␊␊βφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡAＵ\x0e",
	}, { // 1682
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\nφβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡA␊\x0e",
		out:  "␊φβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡA␊\x0e",
	}, { // 1683
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␊φβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡA␊\x0e",
		out:  "‛␊φβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡA␊\x0e",
	}, { // 1684
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\nφβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡAＵ␊",
		out:  "␊φβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡAＵ␊",
	}, { // 1685
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␊φβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡAＵ␊",
		out:  "‛␊φβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡAＵ␊",
	}, { // 1686
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＞\nβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡAＵ\x0e",
		out:  "＞\nβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡAＵ\x0e",
	}, { // 1687
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＞␊βφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡAＵ\x0e",
		out:  "＞␊βφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡAＵ\x0e",
	}, { // 1688
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＞\nβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡA␊\x0e",
		out:  "＞\nβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡA␊\x0e",
	}, { // 1689
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＞␊βφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡA␊\x0e",
		out:  "＞␊βφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡA␊\x0e",
	}, { // 1690
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＞\nβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡAＵ␊",
		out:  "＞\nβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡAＵ␊",
	}, { // 1691
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＞␊βφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡAＵ␊",
		out:  "＞␊βφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡAＵ␊",
	}, { // 1692
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡA\n\x0e",
		out:  "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡA\n\x0e",
	}, { // 1693
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡA␊\x0e",
		out:  "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡA␊\x0e",
	}, { // 1694
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡA\n␊",
		out:  "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡA\n␊",
	}, { // 1695
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡA␊␊",
		out:  "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡA␊␊",
	}, { // 1696
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡAＵ\n",
		out:  "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡAＵ\n",
	}, { // 1697
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd\x00T＂\n␙8χοＡAＵ␊",
		out:  "＞φβφ␂ν５＞\x11␁\nｈ::q／ｍd␀T＂\n␙8χοＡAＵ␊",
	}, { // 1698
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
		out:  "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
	}, { // 1699
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\v␋ψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
		out:  "␋␋ψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
	}, { // 1700
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␋␋ψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
		out:  "‛␋␋ψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
	}, { // 1701
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\vχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
		out:  "␋χψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
	}, { // 1702
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␋χψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
		out:  "‛␋χψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
	}, { // 1703
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\vχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋␋",
		out:  "␋χψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋␋",
	}, { // 1704
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␋χψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋␋",
		out:  "‛␋χψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋␋",
	}, { // 1705
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｆ\vψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
		out:  "ｆ\vψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
	}, { // 1706
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｆ␋ψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
		out:  "ｆ␋ψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
	}, { // 1707
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｆ\vψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
		out:  "ｆ\vψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
	}, { // 1708
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｆ␋ψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
		out:  "ｆ␋ψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
	}, { // 1709
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｆ\vψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋␋",
		out:  "ｆ\vψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋␋",
	}, { // 1710
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｆ␋ψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋␋",
		out:  "ｆ␋ψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋␋",
	}, { // 1711
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ\v＼",
		out:  "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ\v＼",
	}, { // 1712
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
		out:  "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋＼",
	}, { // 1713
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ\v␋",
		out:  "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ\v␋",
	}, { // 1714
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋␋",
		out:  "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋␋",
	}, { // 1715
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋\v",
		out:  "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋\v",
	}, { // 1716
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋␋",
		out:  "ｆχψdιWγτ｜/\v＼$＃R␛ｓ\n,=ｋＯ\x10|μ\\>ｏ␋␋",
	}, { // 1717
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ο>\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊ｅ",
		out:  "ο>\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊ｅ",
	}, { // 1718
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\r␍\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊ｅ",
		out:  "␍␍\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊ｅ",
	}, { // 1719
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␍␍\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊ｅ",
		out:  "‛␍␍\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊ｅ",
	}, { // 1720
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\r>\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␍ｅ",
		out:  "␍>\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␍ｅ",
	}, { // 1721
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␍>\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␍ｅ",
		out:  "‛␍>\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␍ｅ",
	}, { // 1722
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\r>\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊␍",
		out:  "␍>\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊␍",
	}, { // 1723
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␍>\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊␍",
		out:  "‛␍>\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊␍",
	}, { // 1724
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ο\r\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊ｅ",
		out:  "ο\r\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊ｅ",
	}, { // 1725
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ο␍\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊ｅ",
		out:  "ο␍\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊ｅ",
	}, { // 1726
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ο\r\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␍ｅ",
		out:  "ο\r\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␍ｅ",
	}, { // 1727
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ο␍\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␍ｅ",
		out:  "ο␍\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␍ｅ",
	}, { // 1728
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ο\r\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊␍",
		out:  "ο\r\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊␍",
	}, { // 1729
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ο␍\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊␍",
		out:  "ο␍\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊␍",
	}, { // 1730
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ο>\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv\rｅ",
		out:  "ο>\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv\rｅ",
	}, { // 1731
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ο>\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␍ｅ",
		out:  "ο>\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␍ｅ",
	}, { // 1732
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ο>\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv\r␍",
		out:  "ο>\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv\r␍",
	}, { // 1733
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ο>\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␍␍",
		out:  "ο>\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␍␍",
	}, { // 1734
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ο>\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊\r",
		out:  "ο>\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊\r",
	}, { // 1735
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ο>\x1dY*ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊␍",
		out:  "ο>\x1dY＊ε\x19␊Ｈω\r＞Ｏ（␗ｉ:\x17，\frυ;␇␒ν\x1bv␊␍",
	}, { // 1736
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c／",
		out:  "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c／",
	}, { // 1737
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\t␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c／",
		out:  "␉␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c／",
	}, { // 1738
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␉␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c／",
		out:  "‛␉␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c／",
	}, { // 1739
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\t␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q␉／",
		out:  "␉␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q␉／",
	}, { // 1740
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␉␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q␉／",
		out:  "‛␉␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q␉／",
	}, { // 1741
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\t␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c␉",
		out:  "␉␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c␉",
	}, { // 1742
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␉␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c␉",
		out:  "‛␉␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c␉",
	}, { // 1743
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "３\t$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c／",
		out:  "３\t$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c／",
	}, { // 1744
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c／",
		out:  "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c／",
	}, { // 1745
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "３\t$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q␉／",
		out:  "３\t$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q␉／",
	}, { // 1746
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q␉／",
		out:  "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q␉／",
	}, { // 1747
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "３\t$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c␉",
		out:  "３\t$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c␉",
	}, { // 1748
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c␉",
		out:  "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c␉",
	}, { // 1749
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\t／",
		out:  "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\t／",
	}, { // 1750
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q␉／",
		out:  "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q␉／",
	}, { // 1751
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\t␉",
		out:  "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\t␉",
	}, { // 1752
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q␉␉",
		out:  "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q␉␉",
	}, { // 1753
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c\t",
		out:  "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c\t",
	}, { // 1754
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c␉",
		out:  "３␉$％␛ινμ␛␋\t\x1dｔδx/Ｃ\x1dρ#Pｋ.ξUx＂q\x1c␉",
	}, { // 1755
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz\x11ｂ",
		out:  "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz\x11ｂ",
	}, { // 1756
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n␊D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz\x11ｂ",
		out:  "␊␊D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz\x11ｂ",
	}, { // 1757
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␊␊D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz\x11ｂ",
		out:  "‛␊␊D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz\x11ｂ",
	}, { // 1758
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz␊ｂ",
		out:  "␊！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz␊ｂ",
	}, { // 1759
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␊！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz␊ｂ",
		out:  "‛␊！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz␊ｂ",
	}, { // 1760
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz\x11␊",
		out:  "␊！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz\x11␊",
	}, { // 1761
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␊！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz\x11␊",
		out:  "‛␊！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz\x11␊",
	}, { // 1762
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ｈ\nD．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz\x11ｂ",
		out:  "ｈ\nD．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz\x11ｂ",
	}, { // 1763
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ｈ␊D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz\x11ｂ",
		out:  "ｈ␊D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz\x11ｂ",
	}, { // 1764
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ｈ\nD．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz␊ｂ",
		out:  "ｈ\nD．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz␊ｂ",
	}, { // 1765
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ｈ␊D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz␊ｂ",
		out:  "ｈ␊D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz␊ｂ",
	}, { // 1766
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ｈ\nD．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz\x11␊",
		out:  "ｈ\nD．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz\x11␊",
	}, { // 1767
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ｈ␊D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz\x11␊",
		out:  "ｈ␊D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz\x11␊",
	}, { // 1768
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz\nｂ",
		out:  "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz\nｂ",
	}, { // 1769
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz␊ｂ",
		out:  "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz␊ｂ",
	}, { // 1770
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz\n␊",
		out:  "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz\n␊",
	}, { // 1771
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz␊␊",
		out:  "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz␊␊",
	}, { // 1772
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz\x11\n",
		out:  "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz\x11\n",
	}, { // 1773
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η\x00$\x05ωz\x11␊",
		out:  "ｈ！D．␖␊\aP２φ\nν,κ␏／\n␏ς␄Ｗ~η␀$\x05ωz\x11␊",
	}, { // 1774
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\nζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0fa",
		out:  "␊ζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0fa",
	}, { // 1775
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\v␋\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0fa",
		out:  "␋␋\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0fa",
	}, { // 1776
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␋␋\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0fa",
		out:  "‛␋␋\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0fa",
	}, { // 1777
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\vζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0␋a",
		out:  "␋ζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0␋a",
	}, { // 1778
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␋ζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0␋a",
		out:  "‛␋ζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0␋a",
	}, { // 1779
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\vζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0f␋",
		out:  "␋ζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0f␋",
	}, { // 1780
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␋ζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0f␋",
		out:  "‛␋ζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0f␋",
	}, { // 1781
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n\v\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0fa",
		out:  "␊\v\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0fa",
	}, { // 1782
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n␋\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0fa",
		out:  "␊␋\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0fa",
	}, { // 1783
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n\v\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0␋a",
		out:  "␊\v\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0␋a",
	}, { // 1784
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n␋\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0␋a",
		out:  "␊␋\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0␋a",
	}, { // 1785
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n\v\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0f␋",
		out:  "␊\v\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0f␋",
	}, { // 1786
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n␋\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0f␋",
		out:  "␊␋\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0f␋",
	}, { // 1787
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\nζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\va",
		out:  "␊ζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\va",
	}, { // 1788
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\nζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0␋a",
		out:  "␊ζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0␋a",
	}, { // 1789
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\nζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\v␋",
		out:  "␊ζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\v␋",
	}, { // 1790
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\nζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0␋␋",
		out:  "␊ζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0␋␋",
	}, { // 1791
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\nζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0f\v",
		out:  "␊ζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0f\v",
	}, { // 1792
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\nζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0f␋",
		out:  "␊ζ\\Ｙp␐ιD＂'\vευ␊3\x02\x12>␞␍ｒ＜ｐ１ζｄｚ0\x0f␋",
	}, { // 1793
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π０",
		out:  "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π０",
	}, { // 1794
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\r␍\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π０",
		out:  "␍␍\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π０",
	}, { // 1795
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␍␍\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π０",
		out:  "‛␍␍\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π０",
	}, { // 1796
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\r\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/␍０",
		out:  "␍\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/␍０",
	}, { // 1797
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␍\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/␍０",
		out:  "‛␍\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/␍０",
	}, { // 1798
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\r\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π␍",
		out:  "␍\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π␍",
	}, { // 1799
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␍\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π␍",
		out:  "‛␍\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π␍",
	}, { // 1800
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␈\r\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π０",
		out:  "␈\r\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π０",
	}, { // 1801
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␈␍\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π０",
		out:  "␈␍\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π０",
	}, { // 1802
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␈\r\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/␍０",
		out:  "␈\r\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/␍０",
	}, { // 1803
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␈␍\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/␍０",
		out:  "␈␍\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/␍０",
	}, { // 1804
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␈\r\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π␍",
		out:  "␈\r\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π␍",
	}, { // 1805
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␈␍\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π␍",
		out:  "␈␍\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π␍",
	}, { // 1806
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/\r０",
		out:  "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/\r０",
	}, { // 1807
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/␍０",
		out:  "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/␍０",
	}, { // 1808
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/\r␍",
		out:  "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/\r␍",
	}, { // 1809
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/␍␍",
		out:  "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/␍␍",
	}, { // 1810
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π\r",
		out:  "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π\r",
	}, { // 1811
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π␍",
		out:  "␈\x0e\x17*ο\x161λφ␈\r#；－␒τ６ ｌ）\"RIu␍␓α/π␍",
	}, { // 1812
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ\x18（",
		out:  "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ\x18（",
	}, { // 1813
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\t␉\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ\x18（",
		out:  "␉␉\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ\x18（",
	}, { // 1814
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␉␉\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ\x18（",
		out:  "‛␉␉\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ\x18（",
	}, { // 1815
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\t\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ␉（",
		out:  "␉\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ␉（",
	}, { // 1816
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␉\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ␉（",
		out:  "‛␉\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ␉（",
	}, { // 1817
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\t\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ\x18␉",
		out:  "␉\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ\x18␉",
	}, { // 1818
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␉\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ\x18␉",
		out:  "‛␉\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ\x18␉",
	}, { // 1819
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω\t\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ\x18（",
		out:  "ω\t\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ\x18（",
	}, { // 1820
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω␉\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ\x18（",
		out:  "ω␉\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ\x18（",
	}, { // 1821
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω\t\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ␉（",
		out:  "ω\t\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ␉（",
	}, { // 1822
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω␉\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ␉（",
		out:  "ω␉\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ␉（",
	}, { // 1823
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω\t\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ\x18␉",
		out:  "ω\t\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ\x18␉",
	}, { // 1824
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω␉\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ\x18␉",
		out:  "ω␉\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ\x18␉",
	}, { // 1825
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ\t（",
		out:  "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ\t（",
	}, { // 1826
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ␉（",
		out:  "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ␉（",
	}, { // 1827
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ\t␉",
		out:  "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ\t␉",
	}, { // 1828
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ␉␉",
		out:  "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ␉␉",
	}, { // 1829
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ\x18\t",
		out:  "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ\x18\t",
	}, { // 1830
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔\x00β（E␞ρJＦ\x18␉",
		out:  "ω\n\x11iG␎｛υF␏\tμ\x02␊ｅθ\b'␡␔␀β（E␞ρJＦ\x18␉",
	}, { // 1831
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ^␟",
		out:  "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ^␟",
	}, { // 1832
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n␊＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ^␟",
		out:  "␊␊＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ^␟",
	}, { // 1833
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␊␊＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ^␟",
		out:  "‛␊␊＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ^␟",
	}, { // 1834
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ␊␟",
		out:  "␊\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ␊␟",
	}, { // 1835
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␊\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ␊␟",
		out:  "‛␊\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ␊␟",
	}, { // 1836
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ^␊",
		out:  "␊\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ^␊",
	}, { // 1837
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␊\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ^␊",
		out:  "‛␊\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ^␊",
	}, { // 1838
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␐\n＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ^␟",
		out:  "␐\n＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ^␟",
	}, { // 1839
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␐␊＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ^␟",
		out:  "␐␊＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ^␟",
	}, { // 1840
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␐\n＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ␊␟",
		out:  "␐\n＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ␊␟",
	}, { // 1841
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␐␊＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ␊␟",
		out:  "␐␊＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ␊␟",
	}, { // 1842
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␐\n＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ^␊",
		out:  "␐\n＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ^␊",
	}, { // 1843
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␐␊＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ^␊",
		out:  "␐␊＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ^␊",
	}, { // 1844
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ\n␟",
		out:  "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ\n␟",
	}, { // 1845
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ␊␟",
		out:  "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ␊␟",
	}, { // 1846
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ\n␊",
		out:  "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ\n␊",
	}, { // 1847
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ␊␊",
		out:  "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ␊␊",
	}, { // 1848
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ^\n",
		out:  "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ^\n",
	}, { // 1849
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀＃ζθＤ^␊",
		out:  "␐\x10＇␇\x12Y\aθ9σ\n\x17γ,＜F\x14[ｌＸ６ε␞｀‛＃ζθＤ^␊",
	}, { // 1850
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄p",
		out:  "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄p",
	}, { // 1851
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\v␋＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄p",
		out:  "␋␋＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄p",
	}, { // 1852
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␋␋＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄p",
		out:  "‛␋␋＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄p",
	}, { // 1853
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\v\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␋p",
		out:  "␋\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␋p",
	}, { // 1854
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␋\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␋p",
		out:  "‛␋\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␋p",
	}, { // 1855
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\v\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄␋",
		out:  "␋\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄␋",
	}, { // 1856
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␋\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄␋",
		out:  "‛␋\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄␋",
	}, { // 1857
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｕ\v＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄p",
		out:  "Ｕ\v＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄p",
	}, { // 1858
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｕ␋＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄p",
		out:  "Ｕ␋＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄p",
	}, { // 1859
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｕ\v＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␋p",
		out:  "Ｕ\v＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␋p",
	}, { // 1860
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｕ␋＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␋p",
		out:  "Ｕ␋＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␋p",
	}, { // 1861
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｕ\v＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄␋",
		out:  "Ｕ\v＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄␋",
	}, { // 1862
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｕ␋＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄␋",
		out:  "Ｕ␋＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄␋",
	}, { // 1863
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ\vp",
		out:  "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ\vp",
	}, { // 1864
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␋p",
		out:  "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␋p",
	}, { // 1865
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ\v␋",
		out:  "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ\v␋",
	}, { // 1866
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␋␋",
		out:  "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␋␋",
	}, { // 1867
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄\v",
		out:  "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄\v",
	}, { // 1868
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄␋",
		out:  "Ｕ\x05＊？５\n␑\x04φ\r\v；/YdT?ｊＴ＿＄＞\\6ττδδ␄␋",
	}, { // 1869
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "，φ␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ~",
		out:  "，φ␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ~",
	}, { // 1870
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\r␍␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ~",
		out:  "␍␍␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ~",
	}, { // 1871
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␍␍␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ~",
		out:  "‛␍␍␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ~",
	}, { // 1872
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\rφ␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ␍~",
		out:  "␍φ␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ␍~",
	}, { // 1873
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␍φ␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ␍~",
		out:  "‛␍φ␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ␍~",
	}, { // 1874
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\rφ␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ␍",
		out:  "␍φ␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ␍",
	}, { // 1875
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␍φ␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ␍",
		out:  "‛␍φ␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ␍",
	}, { // 1876
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "，\r␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ~",
		out:  "，\r␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ~",
	}, { // 1877
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "，␍␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ~",
		out:  "，␍␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ~",
	}, { // 1878
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "，\r␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ␍~",
		out:  "，\r␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ␍~",
	}, { // 1879
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "，␍␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ␍~",
		out:  "，␍␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ␍~",
	}, { // 1880
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "，\r␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ␍",
		out:  "，\r␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ␍",
	}, { // 1881
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "，␍␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ␍",
		out:  "，␍␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ␍",
	}, { // 1882
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "，φ␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ\r~",
		out:  "，φ␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ\r~",
	}, { // 1883
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "，φ␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ␍~",
		out:  "，φ␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ␍~",
	}, { // 1884
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "，φ␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ\r␍",
		out:  "，φ␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ\r␍",
	}, { // 1885
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "，φ␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ␍␍",
		out:  "，φ␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσ␍␍",
	}, { // 1886
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "，φ␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ\r",
		out:  "，φ␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ\r",
	}, { // 1887
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "，φ␈．␡ζ#\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ␍",
		out:  "，φ␈．␡ζ＃\rＵ\x1d\r?l␂>ｚ␂␟\x0e\x16y／WεＰ\x05ｑσχ␍",
	}, { // 1888
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␙",
		out:  "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␙",
	}, { // 1889
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\t␉３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␙",
		out:  "␉␉３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␙",
	}, { // 1890
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␉␉３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␙",
		out:  "‛␉␉３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␙",
	}, { // 1891
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\tψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d␉␙",
		out:  "␉ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d␉␙",
	}, { // 1892
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␉ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d␉␙",
		out:  "‛␉ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d␉␙",
	}, { // 1893
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\tψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␉",
		out:  "␉ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␉",
	}, { // 1894
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␉ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␉",
		out:  "‛␉ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␉",
	}, { // 1895
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "＼\t３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␙",
		out:  "＼\t３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␙",
	}, { // 1896
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "＼␉３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␙",
		out:  "＼␉３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␙",
	}, { // 1897
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "＼\t３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d␉␙",
		out:  "＼\t３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d␉␙",
	}, { // 1898
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "＼␉３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d␉␙",
		out:  "＼␉３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d␉␙",
	}, { // 1899
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "＼\t３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␉",
		out:  "＼\t３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␉",
	}, { // 1900
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "＼␉３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␉",
		out:  "＼␉３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␉",
	}, { // 1901
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\t␙",
		out:  "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\t␙",
	}, { // 1902
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d␉␙",
		out:  "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d␉␙",
	}, { // 1903
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\t␉",
		out:  "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\t␉",
	}, { // 1904
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d␉␉",
		out:  "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d␉␉",
	}, { // 1905
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13\t",
		out:  "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13\t",
	}, { // 1906
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␉",
		out:  "＼ψ３＼A~β3ｉ␆\tA|λ/ｑο\v\x0eＴ４~ｐ␊\x06ψσ\x1d\x13␉",
	}, { // 1907
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "nａ＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼%χ",
		out:  "nａ＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼％χ",
	}, { // 1908
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n␊＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼%χ",
		out:  "␊␊＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼％χ",
	}, { // 1909
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊␊＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼%χ",
		out:  "‛␊␊＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼％χ",
	}, { // 1910
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\nａ＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼␊χ",
		out:  "␊ａ＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼␊χ",
	}, { // 1911
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊ａ＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼␊χ",
		out:  "‛␊ａ＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼␊χ",
	}, { // 1912
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\nａ＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼%␊",
		out:  "␊ａ＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼％␊",
	}, { // 1913
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊ａ＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼%␊",
		out:  "‛␊ａ＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼％␊",
	}, { // 1914
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "n\n＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼%χ",
		out:  "n\n＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼％χ",
	}, { // 1915
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "n␊＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼%χ",
		out:  "n␊＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼％χ",
	}, { // 1916
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "n\n＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼␊χ",
		out:  "n\n＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼␊χ",
	}, { // 1917
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "n␊＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼␊χ",
		out:  "n␊＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼␊χ",
	}, { // 1918
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "n\n＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼%␊",
		out:  "n\n＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼％␊",
	}, { // 1919
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "n␊＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼%␊",
		out:  "n␊＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼％␊",
	}, { // 1920
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "nａ＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼\nχ",
		out:  "nａ＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼\nχ",
	}, { // 1921
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "nａ＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼␊χ",
		out:  "nａ＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼␊χ",
	}, { // 1922
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "nａ＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼\n␊",
		out:  "nａ＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼\n␊",
	}, { // 1923
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "nａ＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼␊␊",
		out:  "nａ＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼␊␊",
	}, { // 1924
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "nａ＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼%\n",
		out:  "nａ＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼％\n",
	}, { // 1925
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "nａ＇{＜ςδ％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞%＼%␊",
		out:  "nａ＇{＜ςδ‛％\t␘\nＢγθＨ'\x17＜κEＨ+7\x05\\＞％＼％␊",
	}, { // 1926
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚\x1b",
		out:  "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚\x1b",
	}, { // 1927
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\v␋Htτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚\x1b",
		out:  "␋␋Htτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚\x1b",
	}, { // 1928
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␋␋Htτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚\x1b",
		out:  "‛␋␋Htτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚\x1b",
	}, { // 1929
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\vωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␋\x1b",
		out:  "␋ωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␋\x1b",
	}, { // 1930
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␋ωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␋\x1b",
		out:  "‛␋ωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␋\x1b",
	}, { // 1931
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\vωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚␋",
		out:  "␋ωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚␋",
	}, { // 1932
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␋ωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚␋",
		out:  "‛␋ωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚␋",
	}, { // 1933
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ζ\vHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚\x1b",
		out:  "ζ\vHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚\x1b",
	}, { // 1934
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ζ␋Htτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚\x1b",
		out:  "ζ␋Htτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚\x1b",
	}, { // 1935
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ζ\vHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␋\x1b",
		out:  "ζ\vHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␋\x1b",
	}, { // 1936
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ζ␋Htτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␋\x1b",
		out:  "ζ␋Htτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␋\x1b",
	}, { // 1937
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ζ\vHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚␋",
		out:  "ζ\vHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚␋",
	}, { // 1938
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ζ␋Htτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚␋",
		out:  "ζ␋Htτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚␋",
	}, { // 1939
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|\v\x1b",
		out:  "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|\v\x1b",
	}, { // 1940
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␋\x1b",
		out:  "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␋\x1b",
	}, { // 1941
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|\v␋",
		out:  "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|\v␋",
	}, { // 1942
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␋␋",
		out:  "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␋␋",
	}, { // 1943
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚\v",
		out:  "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚\v",
	}, { // 1944
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚␋",
		out:  "ζωHtτ␊Ｃｑ／ｚ\vψ＊ν\x03\x10ＰκＴD＃\x13W`e>ｆ|␚␋",
	}, { // 1945
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ\x10",
		out:  "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ\x10",
	}, { // 1946
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\r␍７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ\x10",
		out:  "␍␍７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ\x10",
	}, { // 1947
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␍␍７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ\x10",
		out:  "‛␍␍７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ\x10",
	}, { // 1948
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\rω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍␍\x10",
		out:  "␍ω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍␍\x10",
	}, { // 1949
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␍ω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍␍\x10",
		out:  "‛␍ω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍␍\x10",
	}, { // 1950
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\rω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ␍",
		out:  "␍ω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ␍",
	}, { // 1951
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␍ω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ␍",
		out:  "‛␍ω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ␍",
	}, { // 1952
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "Ｅ\r７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ\x10",
		out:  "Ｅ\r７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ\x10",
	}, { // 1953
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "Ｅ␍７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ\x10",
		out:  "Ｅ␍７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ\x10",
	}, { // 1954
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "Ｅ\r７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍␍\x10",
		out:  "Ｅ\r７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍␍\x10",
	}, { // 1955
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "Ｅ␍７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍␍\x10",
		out:  "Ｅ␍７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍␍\x10",
	}, { // 1956
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "Ｅ\r７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ␍",
		out:  "Ｅ\r７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ␍",
	}, { // 1957
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "Ｅ␍７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ␍",
		out:  "Ｅ␍７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ␍",
	}, { // 1958
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍\r\x10",
		out:  "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍\r\x10",
	}, { // 1959
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍␍\x10",
		out:  "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍␍\x10",
	}, { // 1960
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍\r␍",
		out:  "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍\r␍",
	}, { // 1961
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍␍␍",
		out:  "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍␍␍",
	}, { // 1962
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ\r",
		out:  "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ\r",
	}, { // 1963
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ␍",
		out:  "Ｅω７?ln＼\u007f␊ｚ\r．Vκ␂φz>θ，/.σ\n␗＾,␍φ␍",
	}, { // 1964
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇＝",
		out:  "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇＝",
	}, { // 1965
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\t␉？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇＝",
		out:  "␉␉？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇＝",
	}, { // 1966
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉␉？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇＝",
		out:  "‛␉␉？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇＝",
	}, { // 1967
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\t－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/␉＝",
		out:  "␉－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/␉＝",
	}, { // 1968
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/␉＝",
		out:  "‛␉－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/␉＝",
	}, { // 1969
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\t－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇␉",
		out:  "␉－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇␉",
	}, { // 1970
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇␉",
		out:  "‛␉－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇␉",
	}, { // 1971
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "[\t？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇＝",
		out:  "[\t？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇＝",
	}, { // 1972
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "[␉？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇＝",
		out:  "[␉？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇＝",
	}, { // 1973
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "[\t？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/␉＝",
		out:  "[\t？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/␉＝",
	}, { // 1974
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "[␉？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/␉＝",
		out:  "[␉？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/␉＝",
	}, { // 1975
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "[\t？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇␉",
		out:  "[\t？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇␉",
	}, { // 1976
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "[␉？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇␉",
		out:  "[␉？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇␉",
	}, { // 1977
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/\t＝",
		out:  "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/\t＝",
	}, { // 1978
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/␉＝",
		out:  "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/␉＝",
	}, { // 1979
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/\t␉",
		out:  "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/\t␉",
	}, { // 1980
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/␉␉",
		out:  "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/␉␉",
	}, { // 1981
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇\t",
		out:  "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇\t",
	}, { // 1982
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇␉",
		out:  "[－？␙Z\x1a?ο'␓\t!␙δ5χＥσκ␂Ｇ\x06ο\f␒%i/＇␉",
	}, { // 1983
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐\a",
		out:  "‛␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐\a",
	}, { // 1984
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\n␊．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐\a",
		out:  "␊␊．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐\a",
	}, { // 1985
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊␊．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐\a",
		out:  "‛␊␊．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐\a",
	}, { // 1986
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\ns．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␊\a",
		out:  "␊s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␊\a",
	}, { // 1987
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␊\a",
		out:  "‛␊s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␊\a",
	}, { // 1988
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\ns．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐␊",
		out:  "␊s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐␊",
	}, { // 1989
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐␊",
		out:  "‛␊s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐␊",
	}, { // 1990
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍\n．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐\a",
		out:  "‛␍\n．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐\a",
	}, { // 1991
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍␊．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐\a",
		out:  "‛␍␊．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐\a",
	}, { // 1992
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍\n．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␊\a",
		out:  "‛␍\n．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␊\a",
	}, { // 1993
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍␊．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␊\a",
		out:  "‛␍␊．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␊\a",
	}, { // 1994
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍\n．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐␊",
		out:  "‛␍\n．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐␊",
	}, { // 1995
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍␊．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐␊",
		out:  "‛␍␊．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐␊",
	}, { // 1996
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾\n\a",
		out:  "‛␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾\n\a",
	}, { // 1997
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␊\a",
		out:  "‛␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␊\a",
	}, { // 1998
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾\n␊",
		out:  "‛␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾\n␊",
	}, { // 1999
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␊␊",
		out:  "‛␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␊␊",
	}, { // 2000
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐\n",
		out:  "‛␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐\n",
	}, { // 2001
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐␊",
		out:  "‛␍s．/＊\x05␜~ωｔ\n\x1aςφ1=π\x06／|\x03␄７／υＬθ＾␐␊",
	}, { // 2002
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>ζ",
		out:  "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>ζ",
	}, { // 2003
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\v␋␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>ζ",
		out:  "␋␋␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>ζ",
	}, { // 2004
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␋␋␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>ζ",
		out:  "‛␋␋␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>ζ",
	}, { // 2005
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\v８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t␋ζ",
		out:  "␋８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t␋ζ",
	}, { // 2006
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␋８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t␋ζ",
		out:  "‛␋８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t␋ζ",
	}, { // 2007
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\v８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>␋",
		out:  "␋８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>␋",
	}, { // 2008
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␋８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>␋",
		out:  "‛␋８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>␋",
	}, { // 2009
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＜\v␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>ζ",
		out:  "＜\v␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>ζ",
	}, { // 2010
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＜␋␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>ζ",
		out:  "＜␋␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>ζ",
	}, { // 2011
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＜\v␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t␋ζ",
		out:  "＜\v␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t␋ζ",
	}, { // 2012
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＜␋␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t␋ζ",
		out:  "＜␋␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t␋ζ",
	}, { // 2013
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＜\v␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>␋",
		out:  "＜\v␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>␋",
	}, { // 2014
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＜␋␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>␋",
		out:  "＜␋␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>␋",
	}, { // 2015
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t\vζ",
		out:  "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t\vζ",
	}, { // 2016
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t␋ζ",
		out:  "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t␋ζ",
	}, { // 2017
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t\v␋",
		out:  "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t\v␋",
	}, { // 2018
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t␋␋",
		out:  "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t␋␋",
	}, { // 2019
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>\v",
		out:  "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>\v",
	}, { // 2020
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>␋",
		out:  "＜８␃，{λ／φ␍<\v/\n␎\x0eｈ-ｍ␅／<θｇθ\x1efu\t>␋",
	}, { // 2021
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ4",
		out:  "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ4",
	}, { // 2022
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\r␍␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ4",
		out:  "␍␍␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ4",
	}, { // 2023
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍␍␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ4",
		out:  "‛␍␍␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ4",
	}, { // 2024
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\r␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f␍4",
		out:  "␍␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f␍4",
	}, { // 2025
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f␍4",
		out:  "‛␍␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f␍4",
	}, { // 2026
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\r␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ␍",
		out:  "␍␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ␍",
	}, { // 2027
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ␍",
		out:  "‛␍␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ␍",
	}, { // 2028
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "}\r␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ4",
		out:  "}\r␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ4",
	}, { // 2029
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "}␍␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ4",
		out:  "}␍␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ4",
	}, { // 2030
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "}\r␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f␍4",
		out:  "}\r␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f␍4",
	}, { // 2031
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "}␍␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f␍4",
		out:  "}␍␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f␍4",
	}, { // 2032
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "}\r␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ␍",
		out:  "}\r␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ␍",
	}, { // 2033
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "}␍␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ␍",
		out:  "}␍␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ␍",
	}, { // 2034
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f\r4",
		out:  "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f\r4",
	}, { // 2035
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f␍4",
		out:  "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f␍4",
	}, { // 2036
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f\r␍",
		out:  "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f\r␍",
	}, { // 2037
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f␍␍",
		out:  "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0f␍␍",
	}, { // 2038
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ\r",
		out:  "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ\r",
	}, { // 2039
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ␍",
		out:  "}␊␗πλ\x0f␑␝U\x16\rmσδＡＵR␛\x05η Ｎ\x12λ/７␈\x0fＧ␍",
	}, { // 2040
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "κς␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ:",
		out:  "κς␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ:",
	}, { // 2041
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\t␉␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ:",
		out:  "␉␉␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ:",
	}, { // 2042
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␉␉␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ:",
		out:  "‛␉␉␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ:",
	}, { // 2043
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\tς␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D␉:",
		out:  "␉ς␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D␉:",
	}, { // 2044
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␉ς␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D␉:",
		out:  "‛␉ς␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D␉:",
	}, { // 2045
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\tς␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ␉",
		out:  "␉ς␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ␉",
	}, { // 2046
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␉ς␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ␉",
		out:  "‛␉ς␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ␉",
	}, { // 2047
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "κ\t␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ:",
		out:  "κ\t␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ:",
	}, { // 2048
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "κ␉␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ:",
		out:  "κ␉␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ:",
	}, { // 2049
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "κ\t␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D␉:",
		out:  "κ\t␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D␉:",
	}, { // 2050
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "κ␉␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D␉:",
		out:  "κ␉␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D␉:",
	}, { // 2051
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "κ\t␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ␉",
		out:  "κ\t␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ␉",
	}, { // 2052
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "κ␉␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ␉",
		out:  "κ␉␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ␉",
	}, { // 2053
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "κς␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D\t:",
		out:  "κς␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D\t:",
	}, { // 2054
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "κς␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D␉:",
		out:  "κς␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D␉:",
	}, { // 2055
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "κς␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D\t␉",
		out:  "κς␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D\t␉",
	}, { // 2056
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "κς␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D␉␉",
		out:  "κς␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋D␉␉",
	}, { // 2057
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "κς␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ\t",
		out:  "κς␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ\t",
	}, { // 2058
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "κς␋\x03␘ιλ*\x1cj\t␎␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ␉",
		out:  "κς␋\x03␘ιλ*\x1cj\t␎‛␡［ｑ␓8Ｑp\\/\"σ｀xρ＋DＫ␉",
	}, { // 2059
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙\x04",
		out:  "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙\x04",
	}, { // 2060
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\n␊M\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙\x04",
		out:  "␊␊M\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙\x04",
	}, { // 2061
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␊␊M\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙\x04",
		out:  "‛␊␊M\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙\x04",
	}, { // 2062
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\nｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␊\x04",
		out:  "␊ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␊\x04",
	}, { // 2063
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␊ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␊\x04",
		out:  "‛␊ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␊\x04",
	}, { // 2064
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\nｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙␊",
		out:  "␊ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙␊",
	}, { // 2065
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␊ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙␊",
		out:  "‛␊ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙␊",
	}, { // 2066
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x15\nM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙\x04",
		out:  "\x15\nM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙\x04",
	}, { // 2067
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x15␊M\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙\x04",
		out:  "\x15␊M\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙\x04",
	}, { // 2068
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x15\nM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␊\x04",
		out:  "\x15\nM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␊\x04",
	}, { // 2069
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x15␊M\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␊\x04",
		out:  "\x15␊M\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␊\x04",
	}, { // 2070
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x15\nM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙␊",
		out:  "\x15\nM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙␊",
	}, { // 2071
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x15␊M\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙␊",
		out:  "\x15␊M\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙␊",
	}, { // 2072
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J\n\x04",
		out:  "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J\n\x04",
	}, { // 2073
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␊\x04",
		out:  "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␊\x04",
	}, { // 2074
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J\n␊",
		out:  "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J\n␊",
	}, { // 2075
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␊␊",
		out:  "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␊␊",
	}, { // 2076
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙\n",
		out:  "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙\n",
	}, { // 2077
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙␊",
		out:  "\x15ｑM\vτＯ␑y／/\n\uff00χ0␔ｕσ\\σ␈␋＾Ｍυ\x05λ?J␙␊",
	}, { // 2078
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'ｚ",
		out:  "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'ｚ",
	}, { // 2079
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\v␋３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'ｚ",
		out:  "␋␋３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'ｚ",
	}, { // 2080
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␋␋３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'ｚ",
		out:  "‛␋␋３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'ｚ",
	}, { // 2081
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\vξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ␋ｚ",
		out:  "␋ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ␋ｚ",
	}, { // 2082
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␋ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ␋ｚ",
		out:  "‛␋ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ␋ｚ",
	}, { // 2083
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\vξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'␋",
		out:  "␋ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'␋",
	}, { // 2084
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␋ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'␋",
		out:  "‛␋ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'␋",
	}, { // 2085
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "/\v３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'ｚ",
		out:  "/\v３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'ｚ",
	}, { // 2086
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "/␋３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'ｚ",
		out:  "/␋３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'ｚ",
	}, { // 2087
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "/\v３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ␋ｚ",
		out:  "/\v３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ␋ｚ",
	}, { // 2088
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "/␋３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ␋ｚ",
		out:  "/␋３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ␋ｚ",
	}, { // 2089
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "/\v３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'␋",
		out:  "/\v３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'␋",
	}, { // 2090
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "/␋３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'␋",
		out:  "/␋３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'␋",
	}, { // 2091
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ\vｚ",
		out:  "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ\vｚ",
	}, { // 2092
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ␋ｚ",
		out:  "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ␋ｚ",
	}, { // 2093
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ\v␋",
		out:  "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ\v␋",
	}, { // 2094
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ␋␋",
		out:  "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ␋␋",
	}, { // 2095
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'\v",
		out:  "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'\v",
	}, { // 2096
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'␋",
		out:  "/ξ３lδ\uff00␈\n␋χ\v/＄#π＿ψP／%π*\x12：@：\x14ｈ'␋",
	}, { // 2097
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\x00ο",
		out:  "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␀ο",
	}, { // 2098
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\r␍Ｗ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\x00ο",
		out:  "␍␍Ｗ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␀ο",
	}, { // 2099
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␍␍Ｗ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\x00ο",
		out:  "‛␍␍Ｗ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␀ο",
	}, { // 2100
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\rYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␍ο",
		out:  "␍YＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␍ο",
	}, { // 2101
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␍YＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␍ο",
		out:  "‛␍YＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␍ο",
	}, { // 2102
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\rYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\x00␍",
		out:  "␍YＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␀␍",
	}, { // 2103
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␍YＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\x00␍",
		out:  "‛␍YＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␀␍",
	}, { // 2104
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "λ\rＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\x00ο",
		out:  "λ\rＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␀ο",
	}, { // 2105
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "λ␍Ｗ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\x00ο",
		out:  "λ␍Ｗ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␀ο",
	}, { // 2106
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "λ\rＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␍ο",
		out:  "λ\rＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␍ο",
	}, { // 2107
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "λ␍Ｗ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␍ο",
		out:  "λ␍Ｗ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␍ο",
	}, { // 2108
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "λ\rＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\x00␍",
		out:  "λ\rＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␀␍",
	}, { // 2109
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "λ␍Ｗ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\x00␍",
		out:  "λ␍Ｗ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␀␍",
	}, { // 2110
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\rο",
		out:  "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\rο",
	}, { // 2111
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␍ο",
		out:  "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␍ο",
	}, { // 2112
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\r␍",
		out:  "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\r␍",
	}, { // 2113
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␍␍",
		out:  "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␍␍",
	}, { // 2114
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\x00\r",
		out:  "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␀\r",
	}, { // 2115
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε\x00␍",
		out:  "λYＷ␌＠\x19␍eｐτ\r\x0fA\f｝\x18␒ωfY␁ο\x1f␍B＋␄ε␀␍",
	}, { // 2116
		mask: EncodeRightSpace,
		in:   " ",
		out:  "␠",
	}, { // 2117
		mask: EncodeZero | EncodeRightSpace,
		in:   "τ＇␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙9",
		out:  "τ＇␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙9",
	}, { // 2118
		mask: EncodeZero | EncodeRightSpace,
		in:   " ␠␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙9",
		out:  " ␠␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙9",
	}, { // 2119
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠␠␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙9",
		out:  "␠␠␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙9",
	}, { // 2120
		mask: EncodeZero | EncodeRightSpace,
		in:   " ＇␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␠9",
		out:  " ＇␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␠9",
	}, { // 2121
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠＇␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␠9",
		out:  "␠＇␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␠9",
	}, { // 2122
		mask: EncodeZero | EncodeRightSpace,
		in:   " ＇␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙␠",
		out:  " ＇␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙‛␠",
	}, { // 2123
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠＇␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙␠",
		out:  "␠＇␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙‛␠",
	}, { // 2124
		mask: EncodeZero | EncodeRightSpace,
		in:   "τ ␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙9",
		out:  "τ ␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙9",
	}, { // 2125
		mask: EncodeZero | EncodeRightSpace,
		in:   "τ␠␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙9",
		out:  "τ␠␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙9",
	}, { // 2126
		mask: EncodeZero | EncodeRightSpace,
		in:   "τ ␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␠9",
		out:  "τ ␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␠9",
	}, { // 2127
		mask: EncodeZero | EncodeRightSpace,
		in:   "τ␠␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␠9",
		out:  "τ␠␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␠9",
	}, { // 2128
		mask: EncodeZero | EncodeRightSpace,
		in:   "τ ␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙␠",
		out:  "τ ␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙‛␠",
	}, { // 2129
		mask: EncodeZero | EncodeRightSpace,
		in:   "τ␠␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙␠",
		out:  "τ␠␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙‛␠",
	}, { // 2130
		mask: EncodeZero | EncodeRightSpace,
		in:   "τ＇␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r} 9",
		out:  "τ＇␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r} 9",
	}, { // 2131
		mask: EncodeZero | EncodeRightSpace,
		in:   "τ＇␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␠9",
		out:  "τ＇␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␠9",
	}, { // 2132
		mask: EncodeZero | EncodeRightSpace,
		in:   "τ＇␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r} ␠",
		out:  "τ＇␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r} ‛␠",
	}, { // 2133
		mask: EncodeZero | EncodeRightSpace,
		in:   "τ＇␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␠␠",
		out:  "τ＇␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␠‛␠",
	}, { // 2134
		mask: EncodeZero | EncodeRightSpace,
		in:   "τ＇␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙ ",
		out:  "τ＇␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙␠",
	}, { // 2135
		mask: EncodeZero | EncodeRightSpace,
		in:   "τ＇␁\x0e＆n＋\x02＾β ␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙␠",
		out:  "τ＇␁\x0e＆n＋\x02＾β ‛␀ＧεK\x17␆dς＇αＶ`\tｗε\r}␙‛␠",
	}, { // 2136
		mask: EncodeSlash | EncodeRightSpace,
		in:   "L\r@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ%",
		out:  "L\r@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ%",
	}, { // 2137
		mask: EncodeSlash | EncodeRightSpace,
		in:   " ␠@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ%",
		out:  " ␠@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ%",
	}, { // 2138
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠␠@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ%",
		out:  "␠␠@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ%",
	}, { // 2139
		mask: EncodeSlash | EncodeRightSpace,
		in:   " \r@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=␠%",
		out:  " \r@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=␠%",
	}, { // 2140
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠\r@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=␠%",
		out:  "␠\r@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=␠%",
	}, { // 2141
		mask: EncodeSlash | EncodeRightSpace,
		in:   " \r@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ␠",
		out:  " \r@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ‛␠",
	}, { // 2142
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠\r@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ␠",
		out:  "␠\r@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ‛␠",
	}, { // 2143
		mask: EncodeSlash | EncodeRightSpace,
		in:   "L @／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ%",
		out:  "L @‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ%",
	}, { // 2144
		mask: EncodeSlash | EncodeRightSpace,
		in:   "L␠@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ%",
		out:  "L␠@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ%",
	}, { // 2145
		mask: EncodeSlash | EncodeRightSpace,
		in:   "L @／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=␠%",
		out:  "L @‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=␠%",
	}, { // 2146
		mask: EncodeSlash | EncodeRightSpace,
		in:   "L␠@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=␠%",
		out:  "L␠@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=␠%",
	}, { // 2147
		mask: EncodeSlash | EncodeRightSpace,
		in:   "L @／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ␠",
		out:  "L @‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ‛␠",
	}, { // 2148
		mask: EncodeSlash | EncodeRightSpace,
		in:   "L␠@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ␠",
		out:  "L␠@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ‛␠",
	}, { // 2149
		mask: EncodeSlash | EncodeRightSpace,
		in:   "L\r@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b= %",
		out:  "L\r@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b= %",
	}, { // 2150
		mask: EncodeSlash | EncodeRightSpace,
		in:   "L\r@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=␠%",
		out:  "L\r@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=␠%",
	}, { // 2151
		mask: EncodeSlash | EncodeRightSpace,
		in:   "L\r@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b= ␠",
		out:  "L\r@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b= ‛␠",
	}, { // 2152
		mask: EncodeSlash | EncodeRightSpace,
		in:   "L\r@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=␠␠",
		out:  "L\r@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=␠‛␠",
	}, { // 2153
		mask: EncodeSlash | EncodeRightSpace,
		in:   "L\r@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ ",
		out:  "L\r@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ␠",
	}, { // 2154
		mask: EncodeSlash | EncodeRightSpace,
		in:   "L\r@／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ␠",
		out:  "L\r@‛／Ｘ｜θτｏ␍ ␇\x1bω>␑ψl\"ｒ␕ω␐δ<P\x1b=ｉ‛␠",
	}, { // 2155
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19＇",
		out:  "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19‛＇",
	}, { // 2156
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   " ␠+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19＇",
		out:  " ␠+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19‛＇",
	}, { // 2157
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␠␠+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19＇",
		out:  "␠␠+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19‛＇",
	}, { // 2158
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   " ：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞␠＇",
		out:  " ：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞␠‛＇",
	}, { // 2159
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␠：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞␠＇",
		out:  "␠：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞␠‛＇",
	}, { // 2160
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   " ：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19␠",
		out:  " ：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19‛␠",
	}, { // 2161
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␠：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19␠",
		out:  "␠：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19‛␠",
	}, { // 2162
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␔ +]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19＇",
		out:  "␔ +]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19‛＇",
	}, { // 2163
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␔␠+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19＇",
		out:  "␔␠+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19‛＇",
	}, { // 2164
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␔ +]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞␠＇",
		out:  "␔ +]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞␠‛＇",
	}, { // 2165
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␔␠+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞␠＇",
		out:  "␔␠+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞␠‛＇",
	}, { // 2166
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␔ +]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19␠",
		out:  "␔ +]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19‛␠",
	}, { // 2167
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␔␠+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19␠",
		out:  "␔␠+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19‛␠",
	}, { // 2168
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞ ＇",
		out:  "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞ ‛＇",
	}, { // 2169
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞␠＇",
		out:  "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞␠‛＇",
	}, { // 2170
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞ ␠",
		out:  "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞ ‛␠",
	}, { // 2171
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞␠␠",
		out:  "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞␠‛␠",
	}, { // 2172
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19 ",
		out:  "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19␠",
	}, { // 2173
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19␠",
		out:  "␔：+]｛UＯμ\x18ω ＊\"␍␂＊X\x13ρ\x14ζ|φＢεe ＞\x19‛␠",
	}, { // 2174
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}μ",
		out:  "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}μ",
	}, { // 2175
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   " ␠ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}μ",
		out:  " ␠ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}μ",
	}, { // 2176
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "␠␠ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}μ",
		out:  "␠␠ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}μ",
	}, { // 2177
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   " ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４␠μ",
		out:  " ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４␠μ",
	}, { // 2178
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "␠␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４␠μ",
		out:  "␠␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４␠μ",
	}, { // 2179
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   " ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}␠",
		out:  " ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}‛␠",
	}, { // 2180
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "␠␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}␠",
		out:  "␠␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}‛␠",
	}, { // 2181
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "κ ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}μ",
		out:  "κ ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}μ",
	}, { // 2182
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "κ␠ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}μ",
		out:  "κ␠ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}μ",
	}, { // 2183
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "κ ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４␠μ",
		out:  "κ ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４␠μ",
	}, { // 2184
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "κ␠ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４␠μ",
		out:  "κ␠ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４␠μ",
	}, { // 2185
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "κ ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}␠",
		out:  "κ ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}‛␠",
	}, { // 2186
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "κ␠ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}␠",
		out:  "κ␠ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}‛␠",
	}, { // 2187
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４ μ",
		out:  "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４ μ",
	}, { // 2188
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４␠μ",
		out:  "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４␠μ",
	}, { // 2189
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４ ␠",
		out:  "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４ ‛␠",
	}, { // 2190
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４␠␠",
		out:  "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４␠‛␠",
	}, { // 2191
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４} ",
		out:  "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}␠",
	}, { // 2192
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}␠",
		out:  "κ␒ηｗQ(*␗␛\x06 ３／S\x19０Ｂ\x01A␄＞␈ψ\x0exε\x14４}‛␠",
	}, { // 2193
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "Ｘαζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?／",
		out:  "Ｘαζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?／",
	}, { // 2194
		mask: EncodeLtGt | EncodeRightSpace,
		in:   " ␠ζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?／",
		out:  " ␠ζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?／",
	}, { // 2195
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "␠␠ζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?／",
		out:  "␠␠ζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?／",
	}, { // 2196
		mask: EncodeLtGt | EncodeRightSpace,
		in:   " αζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#␠／",
		out:  " αζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#␠／",
	}, { // 2197
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "␠αζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#␠／",
		out:  "␠αζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#␠／",
	}, { // 2198
		mask: EncodeLtGt | EncodeRightSpace,
		in:   " αζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?␠",
		out:  " αζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?‛␠",
	}, { // 2199
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "␠αζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?␠",
		out:  "␠αζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?‛␠",
	}, { // 2200
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "Ｘ ζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?／",
		out:  "Ｘ ζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?／",
	}, { // 2201
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "Ｘ␠ζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?／",
		out:  "Ｘ␠ζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?／",
	}, { // 2202
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "Ｘ ζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#␠／",
		out:  "Ｘ ζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#␠／",
	}, { // 2203
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "Ｘ␠ζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#␠／",
		out:  "Ｘ␠ζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#␠／",
	}, { // 2204
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "Ｘ ζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?␠",
		out:  "Ｘ ζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?‛␠",
	}, { // 2205
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "Ｘ␠ζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?␠",
		out:  "Ｘ␠ζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?‛␠",
	}, { // 2206
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "Ｘαζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9# ／",
		out:  "Ｘαζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9# ／",
	}, { // 2207
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "Ｘαζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#␠／",
		out:  "Ｘαζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#␠／",
	}, { // 2208
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "Ｘαζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9# ␠",
		out:  "Ｘαζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9# ‛␠",
	}, { // 2209
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "Ｘαζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#␠␠",
		out:  "Ｘαζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#␠‛␠",
	}, { // 2210
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "Ｘαζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#? ",
		out:  "Ｘαζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?␠",
	}, { // 2211
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "Ｘαζm＞＇ψ\\Ｉο ／\x00σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?␠",
		out:  "Ｘαζm‛＞＇ψ\\Ｉο ／␀σ␔／ｔ\x1b:\x15ρ-＠Ｋw．9#?‛␠",
	}, { // 2212
		mask: EncodeDollar | EncodeRightSpace,
		in:   "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␇\x0f",
		out:  "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␇\x0f",
	}, { // 2213
		mask: EncodeDollar | EncodeRightSpace,
		in:   " ␠+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␇\x0f",
		out:  " ␠+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␇\x0f",
	}, { // 2214
		mask: EncodeDollar | EncodeRightSpace,
		in:   "␠␠+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␇\x0f",
		out:  "␠␠+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␇\x0f",
	}, { // 2215
		mask: EncodeDollar | EncodeRightSpace,
		in:   " A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␠\x0f",
		out:  " A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␠\x0f",
	}, { // 2216
		mask: EncodeDollar | EncodeRightSpace,
		in:   "␠A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␠\x0f",
		out:  "␠A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␠\x0f",
	}, { // 2217
		mask: EncodeDollar | EncodeRightSpace,
		in:   " A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␇␠",
		out:  " A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␇‛␠",
	}, { // 2218
		mask: EncodeDollar | EncodeRightSpace,
		in:   "␠A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␇␠",
		out:  "␠A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␇‛␠",
	}, { // 2219
		mask: EncodeDollar | EncodeRightSpace,
		in:   "７ +␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␇\x0f",
		out:  "７ +␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␇\x0f",
	}, { // 2220
		mask: EncodeDollar | EncodeRightSpace,
		in:   "７␠+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␇\x0f",
		out:  "７␠+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␇\x0f",
	}, { // 2221
		mask: EncodeDollar | EncodeRightSpace,
		in:   "７ +␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␠\x0f",
		out:  "７ +␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␠\x0f",
	}, { // 2222
		mask: EncodeDollar | EncodeRightSpace,
		in:   "７␠+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␠\x0f",
		out:  "７␠+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␠\x0f",
	}, { // 2223
		mask: EncodeDollar | EncodeRightSpace,
		in:   "７ +␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␇␠",
		out:  "７ +␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␇‛␠",
	}, { // 2224
		mask: EncodeDollar | EncodeRightSpace,
		in:   "７␠+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␇␠",
		out:  "７␠+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␇‛␠",
	}, { // 2225
		mask: EncodeDollar | EncodeRightSpace,
		in:   "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ \x0f",
		out:  "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ \x0f",
	}, { // 2226
		mask: EncodeDollar | EncodeRightSpace,
		in:   "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␠\x0f",
		out:  "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␠\x0f",
	}, { // 2227
		mask: EncodeDollar | EncodeRightSpace,
		in:   "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ ␠",
		out:  "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ ‛␠",
	}, { // 2228
		mask: EncodeDollar | EncodeRightSpace,
		in:   "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␠␠",
		out:  "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␠‛␠",
	}, { // 2229
		mask: EncodeDollar | EncodeRightSpace,
		in:   "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␇ ",
		out:  "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␇␠",
	}, { // 2230
		mask: EncodeDollar | EncodeRightSpace,
		in:   "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ$κ␇␠",
		out:  "７A+␈␑＼．＜'\x17 \x12δ.ο)ο␙*ＺEμ＃］μｔ＄κ␇‛␠",
	}, { // 2231
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␋",
		out:  "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␋",
	}, { // 2232
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   " ␠␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␋",
		out:  " ␠␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␋",
	}, { // 2233
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␠␠␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␋",
		out:  "␠␠␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␋",
	}, { // 2234
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   " ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ␠␋",
		out:  " ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ␠␋",
	}, { // 2235
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␠ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ␠␋",
		out:  "␠ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ␠␋",
	}, { // 2236
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   " ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␠",
		out:  " ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜‛␠",
	}, { // 2237
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␠ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␠",
		out:  "␠ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜‛␠",
	}, { // 2238
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "\x05 ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␋",
		out:  "\x05 ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␋",
	}, { // 2239
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "\x05␠␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␋",
		out:  "\x05␠␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␋",
	}, { // 2240
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "\x05 ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ␠␋",
		out:  "\x05 ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ␠␋",
	}, { // 2241
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "\x05␠␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ␠␋",
		out:  "\x05␠␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ␠␋",
	}, { // 2242
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "\x05 ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␠",
		out:  "\x05 ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜‛␠",
	}, { // 2243
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "\x05␠␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␠",
		out:  "\x05␠␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜‛␠",
	}, { // 2244
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ ␋",
		out:  "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ ␋",
	}, { // 2245
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ␠␋",
		out:  "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ␠␋",
	}, { // 2246
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ ␠",
		out:  "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ ‛␠",
	}, { // 2247
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ␠␠",
		out:  "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ␠‛␠",
	}, { // 2248
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜ ",
		out:  "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␠",
	}, { // 2249
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜␠",
		out:  "\x05ｅ␘Oi｝&RσＥ \x1f␓|$：␗ν^␓\aν\x19k＾Ｇνυ｜‛␠",
	}, { // 2250
		mask: EncodeColon | EncodeRightSpace,
		in:   "␓ｑ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλχ",
		out:  "␓ｑ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλχ",
	}, { // 2251
		mask: EncodeColon | EncodeRightSpace,
		in:   " ␠␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλχ",
		out:  " ␠␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλχ",
	}, { // 2252
		mask: EncodeColon | EncodeRightSpace,
		in:   "␠␠␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλχ",
		out:  "␠␠␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλχ",
	}, { // 2253
		mask: EncodeColon | EncodeRightSpace,
		in:   " ｑ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b␠χ",
		out:  " ｑ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b␠χ",
	}, { // 2254
		mask: EncodeColon | EncodeRightSpace,
		in:   "␠ｑ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b␠χ",
		out:  "␠ｑ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b␠χ",
	}, { // 2255
		mask: EncodeColon | EncodeRightSpace,
		in:   " ｑ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλ␠",
		out:  " ｑ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλ‛␠",
	}, { // 2256
		mask: EncodeColon | EncodeRightSpace,
		in:   "␠ｑ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλ␠",
		out:  "␠ｑ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλ‛␠",
	}, { // 2257
		mask: EncodeColon | EncodeRightSpace,
		in:   "␓ ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλχ",
		out:  "␓ ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλχ",
	}, { // 2258
		mask: EncodeColon | EncodeRightSpace,
		in:   "␓␠␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλχ",
		out:  "␓␠␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλχ",
	}, { // 2259
		mask: EncodeColon | EncodeRightSpace,
		in:   "␓ ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b␠χ",
		out:  "␓ ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b␠χ",
	}, { // 2260
		mask: EncodeColon | EncodeRightSpace,
		in:   "␓␠␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b␠χ",
		out:  "␓␠␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b␠χ",
	}, { // 2261
		mask: EncodeColon | EncodeRightSpace,
		in:   "␓ ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλ␠",
		out:  "␓ ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλ‛␠",
	}, { // 2262
		mask: EncodeColon | EncodeRightSpace,
		in:   "␓␠␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλ␠",
		out:  "␓␠␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλ‛␠",
	}, { // 2263
		mask: EncodeColon | EncodeRightSpace,
		in:   "␓ｑ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b χ",
		out:  "␓ｑ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b χ",
	}, { // 2264
		mask: EncodeColon | EncodeRightSpace,
		in:   "␓ｑ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b␠χ",
		out:  "␓ｑ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b␠χ",
	}, { // 2265
		mask: EncodeColon | EncodeRightSpace,
		in:   "␓ｑ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b ␠",
		out:  "␓ｑ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b ‛␠",
	}, { // 2266
		mask: EncodeColon | EncodeRightSpace,
		in:   "␓ｑ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b␠␠",
		out:  "␓ｑ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\b␠‛␠",
	}, { // 2267
		mask: EncodeColon | EncodeRightSpace,
		in:   "␓ｑ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλ ",
		out:  "␓ｑ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλ␠",
	}, { // 2268
		mask: EncodeColon | EncodeRightSpace,
		in:   "␓ｑ␏<b\x0fｈ␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλ␠",
		out:  "␓ｑ␏<b\x0fｈ‛␀␎, ｜＃m*θ！ζω4？n␘\x13τ>！\bλ‛␠",
	}, { // 2269
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］ρ：",
		out:  "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］ρ：",
	}, { // 2270
		mask: EncodeQuestion | EncodeRightSpace,
		in:   " ␠p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］ρ：",
		out:  " ␠p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］ρ：",
	}, { // 2271
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "␠␠p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］ρ：",
		out:  "␠␠p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］ρ：",
	}, { // 2272
		mask: EncodeQuestion | EncodeRightSpace,
		in:   " 3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］␠：",
		out:  " 3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］␠：",
	}, { // 2273
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "␠3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］␠：",
		out:  "␠3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］␠：",
	}, { // 2274
		mask: EncodeQuestion | EncodeRightSpace,
		in:   " 3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］ρ␠",
		out:  " 3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］ρ‛␠",
	}, { // 2275
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "␠3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］ρ␠",
		out:  "␠3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］ρ‛␠",
	}, { // 2276
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ξ p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］ρ：",
		out:  "ξ p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］ρ：",
	}, { // 2277
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ξ␠p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］ρ：",
		out:  "ξ␠p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］ρ：",
	}, { // 2278
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ξ p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］␠：",
		out:  "ξ p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］␠：",
	}, { // 2279
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ξ␠p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］␠：",
		out:  "ξ␠p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］␠：",
	}, { // 2280
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ξ p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］ρ␠",
		out:  "ξ p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］ρ‛␠",
	}, { // 2281
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ξ␠p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］ρ␠",
		out:  "ξ␠p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］ρ‛␠",
	}, { // 2282
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］ ：",
		out:  "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］ ：",
	}, { // 2283
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］␠：",
		out:  "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］␠：",
	}, { // 2284
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］ ␠",
		out:  "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］ ‛␠",
	}, { // 2285
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］␠␠",
		out:  "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］␠‛␠",
	}, { // 2286
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］ρ ",
		out:  "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］ρ␠",
	}, { // 2287
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ?＆\x15\\μlψ］ρ␠",
		out:  "ξ3p｝ｃ\n\b\x0eψ／ ：Q(ＥＩ␖\f␍ξ？＆\x15\\μlψ］ρ‛␠",
	}, { // 2288
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "ｈHο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β＊o",
		out:  "ｈHο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β‛＊o",
	}, { // 2289
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   " ␠ο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β＊o",
		out:  " ␠ο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β‛＊o",
	}, { // 2290
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "␠␠ο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β＊o",
		out:  "␠␠ο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β‛＊o",
	}, { // 2291
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   " Hο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β␠o",
		out:  " Hο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β␠o",
	}, { // 2292
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "␠Hο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β␠o",
		out:  "␠Hο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β␠o",
	}, { // 2293
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   " Hο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β＊␠",
		out:  " Hο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β‛＊‛␠",
	}, { // 2294
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "␠Hο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β＊␠",
		out:  "␠Hο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β‛＊‛␠",
	}, { // 2295
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "ｈ ο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β＊o",
		out:  "ｈ ο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β‛＊o",
	}, { // 2296
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "ｈ␠ο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β＊o",
		out:  "ｈ␠ο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β‛＊o",
	}, { // 2297
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "ｈ ο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β␠o",
		out:  "ｈ ο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β␠o",
	}, { // 2298
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "ｈ␠ο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β␠o",
		out:  "ｈ␠ο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β␠o",
	}, { // 2299
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "ｈ ο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β＊␠",
		out:  "ｈ ο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β‛＊‛␠",
	}, { // 2300
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "ｈ␠ο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β＊␠",
		out:  "ｈ␠ο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β‛＊‛␠",
	}, { // 2301
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "ｈHο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β o",
		out:  "ｈHο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β o",
	}, { // 2302
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "ｈHο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β␠o",
		out:  "ｈHο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β␠o",
	}, { // 2303
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "ｈHο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β ␠",
		out:  "ｈHο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β ‛␠",
	}, { // 2304
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "ｈHο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β␠␠",
		out:  "ｈHο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β␠‛␠",
	}, { // 2305
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "ｈHο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β＊ ",
		out:  "ｈHο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β‛＊␠",
	}, { // 2306
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "ｈHο␝|％*eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β＊␠",
		out:  "ｈHο␝|％＊eη\x14 ＃\x01%␇>ρ＿４ξ$γ␂␜␒$０β‛＊‛␠",
	}, { // 2307
		mask: EncodePipe | EncodeRightSpace,
		in:   "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩｒ",
		out:  "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩｒ",
	}, { // 2308
		mask: EncodePipe | EncodeRightSpace,
		in:   " ␠mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩｒ",
		out:  " ␠mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩｒ",
	}, { // 2309
		mask: EncodePipe | EncodeRightSpace,
		in:   "␠␠mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩｒ",
		out:  "␠␠mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩｒ",
	}, { // 2310
		mask: EncodePipe | EncodeRightSpace,
		in:   " οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ␠ｒ",
		out:  " οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ␠ｒ",
	}, { // 2311
		mask: EncodePipe | EncodeRightSpace,
		in:   "␠οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ␠ｒ",
		out:  "␠οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ␠ｒ",
	}, { // 2312
		mask: EncodePipe | EncodeRightSpace,
		in:   " οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩ␠",
		out:  " οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩ‛␠",
	}, { // 2313
		mask: EncodePipe | EncodeRightSpace,
		in:   "␠οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩ␠",
		out:  "␠οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩ‛␠",
	}, { // 2314
		mask: EncodePipe | EncodeRightSpace,
		in:   "@ mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩｒ",
		out:  "@ mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩｒ",
	}, { // 2315
		mask: EncodePipe | EncodeRightSpace,
		in:   "@␠mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩｒ",
		out:  "@␠mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩｒ",
	}, { // 2316
		mask: EncodePipe | EncodeRightSpace,
		in:   "@ mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ␠ｒ",
		out:  "@ mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ␠ｒ",
	}, { // 2317
		mask: EncodePipe | EncodeRightSpace,
		in:   "@␠mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ␠ｒ",
		out:  "@␠mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ␠ｒ",
	}, { // 2318
		mask: EncodePipe | EncodeRightSpace,
		in:   "@ mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩ␠",
		out:  "@ mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩ‛␠",
	}, { // 2319
		mask: EncodePipe | EncodeRightSpace,
		in:   "@␠mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩ␠",
		out:  "@␠mＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩ‛␠",
	}, { // 2320
		mask: EncodePipe | EncodeRightSpace,
		in:   "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ ｒ",
		out:  "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ ｒ",
	}, { // 2321
		mask: EncodePipe | EncodeRightSpace,
		in:   "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ␠ｒ",
		out:  "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ␠ｒ",
	}, { // 2322
		mask: EncodePipe | EncodeRightSpace,
		in:   "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ ␠",
		out:  "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ ‛␠",
	}, { // 2323
		mask: EncodePipe | EncodeRightSpace,
		in:   "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ␠␠",
		out:  "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζ␠‛␠",
	}, { // 2324
		mask: EncodePipe | EncodeRightSpace,
		in:   "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩ ",
		out:  "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩ␠",
	}, { // 2325
		mask: EncodePipe | EncodeRightSpace,
		in:   "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩ␠",
		out:  "@οmＤ.`<␐Y\x14 λπ$８#＿␁␁ｔMα␇\x1d／U␋ζＩ‛␠",
	}, { // 2326
		mask: EncodeHash | EncodeRightSpace,
		in:   "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\bο",
		out:  "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\bο",
	}, { // 2327
		mask: EncodeHash | EncodeRightSpace,
		in:   " ␠ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\bο",
		out:  " ␠ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\bο",
	}, { // 2328
		mask: EncodeHash | EncodeRightSpace,
		in:   "␠␠ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\bο",
		out:  "␠␠ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\bο",
	}, { // 2329
		mask: EncodeHash | EncodeRightSpace,
		in:   " χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％␠ο",
		out:  " χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％␠ο",
	}, { // 2330
		mask: EncodeHash | EncodeRightSpace,
		in:   "␠χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％␠ο",
		out:  "␠χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％␠ο",
	}, { // 2331
		mask: EncodeHash | EncodeRightSpace,
		in:   " χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\b␠",
		out:  " χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\b‛␠",
	}, { // 2332
		mask: EncodeHash | EncodeRightSpace,
		in:   "␠χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\b␠",
		out:  "␠χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\b‛␠",
	}, { // 2333
		mask: EncodeHash | EncodeRightSpace,
		in:   "␆ ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\bο",
		out:  "␆ ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\bο",
	}, { // 2334
		mask: EncodeHash | EncodeRightSpace,
		in:   "␆␠ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\bο",
		out:  "␆␠ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\bο",
	}, { // 2335
		mask: EncodeHash | EncodeRightSpace,
		in:   "␆ ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％␠ο",
		out:  "␆ ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％␠ο",
	}, { // 2336
		mask: EncodeHash | EncodeRightSpace,
		in:   "␆␠ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％␠ο",
		out:  "␆␠ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％␠ο",
	}, { // 2337
		mask: EncodeHash | EncodeRightSpace,
		in:   "␆ ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\b␠",
		out:  "␆ ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\b‛␠",
	}, { // 2338
		mask: EncodeHash | EncodeRightSpace,
		in:   "␆␠ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\b␠",
		out:  "␆␠ｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\b‛␠",
	}, { // 2339
		mask: EncodeHash | EncodeRightSpace,
		in:   "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％ ο",
		out:  "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％ ο",
	}, { // 2340
		mask: EncodeHash | EncodeRightSpace,
		in:   "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％␠ο",
		out:  "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％␠ο",
	}, { // 2341
		mask: EncodeHash | EncodeRightSpace,
		in:   "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％ ␠",
		out:  "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％ ‛␠",
	}, { // 2342
		mask: EncodeHash | EncodeRightSpace,
		in:   "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％␠␠",
		out:  "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％␠‛␠",
	}, { // 2343
		mask: EncodeHash | EncodeRightSpace,
		in:   "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\b ",
		out:  "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\b␠",
	}, { // 2344
		mask: EncodeHash | EncodeRightSpace,
		in:   "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\b␠",
		out:  "␆χｘβ＊！F\x02＇＜ ν\x16\x12␏～ｕXMＭ*oνf：\u007f\x11％\b‛␠",
	}, { // 2345
		mask: EncodePercent | EncodeRightSpace,
		in:   "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡T",
		out:  "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡T",
	}, { // 2346
		mask: EncodePercent | EncodeRightSpace,
		in:   " ␠μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡T",
		out:  " ␠μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡T",
	}, { // 2347
		mask: EncodePercent | EncodeRightSpace,
		in:   "␠␠μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡T",
		out:  "␠␠μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡T",
	}, { // 2348
		mask: EncodePercent | EncodeRightSpace,
		in:   " ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␠T",
		out:  " ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␠T",
	}, { // 2349
		mask: EncodePercent | EncodeRightSpace,
		in:   "␠␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␠T",
		out:  "␠␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␠T",
	}, { // 2350
		mask: EncodePercent | EncodeRightSpace,
		in:   " ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡␠",
		out:  " ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡‛␠",
	}, { // 2351
		mask: EncodePercent | EncodeRightSpace,
		in:   "␠␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡␠",
		out:  "␠␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡‛␠",
	}, { // 2352
		mask: EncodePercent | EncodeRightSpace,
		in:   "λ μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡T",
		out:  "λ μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡T",
	}, { // 2353
		mask: EncodePercent | EncodeRightSpace,
		in:   "λ␠μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡T",
		out:  "λ␠μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡T",
	}, { // 2354
		mask: EncodePercent | EncodeRightSpace,
		in:   "λ μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␠T",
		out:  "λ μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␠T",
	}, { // 2355
		mask: EncodePercent | EncodeRightSpace,
		in:   "λ␠μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␠T",
		out:  "λ␠μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␠T",
	}, { // 2356
		mask: EncodePercent | EncodeRightSpace,
		in:   "λ μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡␠",
		out:  "λ μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡‛␠",
	}, { // 2357
		mask: EncodePercent | EncodeRightSpace,
		in:   "λ␠μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡␠",
		out:  "λ␠μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡‛␠",
	}, { // 2358
		mask: EncodePercent | EncodeRightSpace,
		in:   "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ T",
		out:  "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ T",
	}, { // 2359
		mask: EncodePercent | EncodeRightSpace,
		in:   "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␠T",
		out:  "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␠T",
	}, { // 2360
		mask: EncodePercent | EncodeRightSpace,
		in:   "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ ␠",
		out:  "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ ‛␠",
	}, { // 2361
		mask: EncodePercent | EncodeRightSpace,
		in:   "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␠␠",
		out:  "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␠‛␠",
	}, { // 2362
		mask: EncodePercent | EncodeRightSpace,
		in:   "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡ ",
		out:  "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡␠",
	}, { // 2363
		mask: EncodePercent | EncodeRightSpace,
		in:   "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡␠",
		out:  "λ␅μ=\x1cａ6#ρ& ␌␍／+ψ\x05*αｒｎ｜\x10，\x1f␈\x18ｅ␡‛␠",
	}, { // 2364
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "ι\x10O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚N",
		out:  "ι\x10O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚N",
	}, { // 2365
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " ␠O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚N",
		out:  " ␠O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚N",
	}, { // 2366
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠␠O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚N",
		out:  "␠␠O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚N",
	}, { // 2367
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " \x10O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␠N",
		out:  " \x10O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␠N",
	}, { // 2368
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠\x10O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␠N",
		out:  "␠\x10O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␠N",
	}, { // 2369
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " \x10O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚␠",
		out:  " \x10O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚‛␠",
	}, { // 2370
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠\x10O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚␠",
		out:  "␠\x10O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚‛␠",
	}, { // 2371
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "ι O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚N",
		out:  "ι O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚N",
	}, { // 2372
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "ι␠O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚N",
		out:  "ι␠O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚N",
	}, { // 2373
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "ι O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␠N",
		out:  "ι O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␠N",
	}, { // 2374
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "ι␠O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␠N",
		out:  "ι␠O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␠N",
	}, { // 2375
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "ι O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚␠",
		out:  "ι O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚‛␠",
	}, { // 2376
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "ι␠O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚␠",
		out:  "ι␠O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚‛␠",
	}, { // 2377
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "ι\x10O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω N",
		out:  "ι\x10O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω N",
	}, { // 2378
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "ι\x10O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␠N",
		out:  "ι\x10O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␠N",
	}, { // 2379
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "ι\x10O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω ␠",
		out:  "ι\x10O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω ‛␠",
	}, { // 2380
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "ι\x10O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␠␠",
		out:  "ι\x10O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␠‛␠",
	}, { // 2381
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "ι\x10O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚ ",
		out:  "ι\x10O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚␠",
	}, { // 2382
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "ι\x10O␋αfｇH\\␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚␠",
		out:  "ι\x10O␋αfｇH＼␊ Pζφｏ␒␒＇\x1e＃\x11π，＂\x11:１ω␚‛␠",
	}, { // 2383
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｃ␛λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␋",
		out:  "ｃ␛λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␋",
	}, { // 2384
		mask: EncodeCrLf | EncodeRightSpace,
		in:   " ␠λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␋",
		out:  " ␠λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␋",
	}, { // 2385
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␠␠λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␋",
		out:  "␠␠λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␋",
	}, { // 2386
		mask: EncodeCrLf | EncodeRightSpace,
		in:   " ␛λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο␠␋",
		out:  " ␛λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο␠␋",
	}, { // 2387
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␠␛λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο␠␋",
		out:  "␠␛λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο␠␋",
	}, { // 2388
		mask: EncodeCrLf | EncodeRightSpace,
		in:   " ␛λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␠",
		out:  " ␛λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd‛␠",
	}, { // 2389
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␠␛λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␠",
		out:  "␠␛λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd‛␠",
	}, { // 2390
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｃ λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␋",
		out:  "ｃ λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␋",
	}, { // 2391
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｃ␠λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␋",
		out:  "ｃ␠λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␋",
	}, { // 2392
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｃ λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο␠␋",
		out:  "ｃ λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο␠␋",
	}, { // 2393
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｃ␠λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο␠␋",
		out:  "ｃ␠λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο␠␋",
	}, { // 2394
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｃ λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␠",
		out:  "ｃ λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd‛␠",
	}, { // 2395
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｃ␠λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␠",
		out:  "ｃ␠λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd‛␠",
	}, { // 2396
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｃ␛λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο ␋",
		out:  "ｃ␛λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο ␋",
	}, { // 2397
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｃ␛λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο␠␋",
		out:  "ｃ␛λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο␠␋",
	}, { // 2398
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｃ␛λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο ␠",
		out:  "ｃ␛λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο ‛␠",
	}, { // 2399
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｃ␛λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο␠␠",
		out:  "ｃ␛λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06ο␠‛␠",
	}, { // 2400
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｃ␛λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd ",
		out:  "ｃ␛λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␠",
	}, { // 2401
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｃ␛λ＞\bＧ＆ξ␛／ ␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd␠",
		out:  "ｃ␛λ＞\bＧ＆ξ␛／ ‛␊\b'|\x13\x17␞YλE｝δ\x03４p\x06οd‛␠",
	}, { // 2402
		mask: EncodeDel | EncodeRightSpace,
		in:   "sC？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυν",
		out:  "sC？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυν",
	}, { // 2403
		mask: EncodeDel | EncodeRightSpace,
		in:   " ␠？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυν",
		out:  " ␠？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυν",
	}, { // 2404
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠␠？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυν",
		out:  "␠␠？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυν",
	}, { // 2405
		mask: EncodeDel | EncodeRightSpace,
		in:   " C？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ␠ν",
		out:  " C？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ␠ν",
	}, { // 2406
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠C？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ␠ν",
		out:  "␠C？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ␠ν",
	}, { // 2407
		mask: EncodeDel | EncodeRightSpace,
		in:   " C？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυ␠",
		out:  " C？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυ‛␠",
	}, { // 2408
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠C？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυ␠",
		out:  "␠C？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυ‛␠",
	}, { // 2409
		mask: EncodeDel | EncodeRightSpace,
		in:   "s ？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυν",
		out:  "s ？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυν",
	}, { // 2410
		mask: EncodeDel | EncodeRightSpace,
		in:   "s␠？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυν",
		out:  "s␠？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυν",
	}, { // 2411
		mask: EncodeDel | EncodeRightSpace,
		in:   "s ？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ␠ν",
		out:  "s ？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ␠ν",
	}, { // 2412
		mask: EncodeDel | EncodeRightSpace,
		in:   "s␠？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ␠ν",
		out:  "s␠？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ␠ν",
	}, { // 2413
		mask: EncodeDel | EncodeRightSpace,
		in:   "s ？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυ␠",
		out:  "s ？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυ‛␠",
	}, { // 2414
		mask: EncodeDel | EncodeRightSpace,
		in:   "s␠？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυ␠",
		out:  "s␠？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυ‛␠",
	}, { // 2415
		mask: EncodeDel | EncodeRightSpace,
		in:   "sC？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ ν",
		out:  "sC？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ ν",
	}, { // 2416
		mask: EncodeDel | EncodeRightSpace,
		in:   "sC？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ␠ν",
		out:  "sC？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ␠ν",
	}, { // 2417
		mask: EncodeDel | EncodeRightSpace,
		in:   "sC？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ ␠",
		out:  "sC？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ ‛␠",
	}, { // 2418
		mask: EncodeDel | EncodeRightSpace,
		in:   "sC？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ␠␠",
		out:  "sC？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψ␠‛␠",
	}, { // 2419
		mask: EncodeDel | EncodeRightSpace,
		in:   "sC？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυ ",
		out:  "sC？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυ␠",
	}, { // 2420
		mask: EncodeDel | EncodeRightSpace,
		in:   "sC？\u007f\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυ␠",
		out:  "sC？␡\x06／＄＊|␃ ＋\x11）\x1a\fγx＇+\uff00＼εβ\rA␃ψυ‛␠",
	}, { // 2421
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\\`π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α１O",
		out:  "\\`π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α１O",
	}, { // 2422
		mask: EncodeCtl | EncodeRightSpace,
		in:   " ␠π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α１O",
		out:  " ␠π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α１O",
	}, { // 2423
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠␠π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α１O",
		out:  "␠␠π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α１O",
	}, { // 2424
		mask: EncodeCtl | EncodeRightSpace,
		in:   " `π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α␠O",
		out:  " `π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α␠O",
	}, { // 2425
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠`π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α␠O",
		out:  "␠`π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α␠O",
	}, { // 2426
		mask: EncodeCtl | EncodeRightSpace,
		in:   " `π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α１␠",
		out:  " `π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α１‛␠",
	}, { // 2427
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠`π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α１␠",
		out:  "␠`π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α１‛␠",
	}, { // 2428
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\\ π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α１O",
		out:  "\\ π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α１O",
	}, { // 2429
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\\␠π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α１O",
		out:  "\\␠π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α１O",
	}, { // 2430
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\\ π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α␠O",
		out:  "\\ π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α␠O",
	}, { // 2431
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\\␠π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α␠O",
		out:  "\\␠π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α␠O",
	}, { // 2432
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\\ π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α１␠",
		out:  "\\ π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α１‛␠",
	}, { // 2433
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\\␠π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α１␠",
		out:  "\\␠π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α１‛␠",
	}, { // 2434
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\\`π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α O",
		out:  "\\`π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α O",
	}, { // 2435
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\\`π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α␠O",
		out:  "\\`π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α␠O",
	}, { // 2436
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\\`π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α ␠",
		out:  "\\`π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α ‛␠",
	}, { // 2437
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\\`π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α␠␠",
		out:  "\\`π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α␠‛␠",
	}, { // 2438
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\\`π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α１ ",
		out:  "\\`π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α１␠",
	}, { // 2439
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\\`π＃～＊\x1fOＪγ εlｖ／\r\x17U\"ｇ,σς\x19｀Ｗ␌α１␠",
		out:  "\\`π＃～＊␟OＪγ εlｖ／␍␗U\"ｇ,σς␙｀Ｗ‛␌α１‛␠",
	}, { // 2440
		mask: EncodeRightPeriod,
		in:   ".",
		out:  "．",
	}, { // 2441
		mask: EncodeZero | EncodeRightPeriod,
		in:   "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε␓B",
		out:  "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε␓B",
	}, { // 2442
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".．κｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε␓B",
		out:  ".．κｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε␓B",
	}, { // 2443
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．．κｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε␓B",
		out:  "．．κｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε␓B",
	}, { // 2444
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".jκｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε．B",
		out:  ".jκｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε．B",
	}, { // 2445
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．jκｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε．B",
		out:  "．jκｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε．B",
	}, { // 2446
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".jκｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε␓．",
		out:  ".jκｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε␓‛．",
	}, { // 2447
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．jκｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε␓．",
		out:  "．jκｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε␓‛．",
	}, { // 2448
		mask: EncodeZero | EncodeRightPeriod,
		in:   "ｎ.κｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε␓B",
		out:  "ｎ.κｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε␓B",
	}, { // 2449
		mask: EncodeZero | EncodeRightPeriod,
		in:   "ｎ．κｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε␓B",
		out:  "ｎ．κｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε␓B",
	}, { // 2450
		mask: EncodeZero | EncodeRightPeriod,
		in:   "ｎ.κｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε．B",
		out:  "ｎ.κｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε．B",
	}, { // 2451
		mask: EncodeZero | EncodeRightPeriod,
		in:   "ｎ．κｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε．B",
		out:  "ｎ．κｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε．B",
	}, { // 2452
		mask: EncodeZero | EncodeRightPeriod,
		in:   "ｎ.κｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε␓．",
		out:  "ｎ.κｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε␓‛．",
	}, { // 2453
		mask: EncodeZero | EncodeRightPeriod,
		in:   "ｎ．κｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε␓．",
		out:  "ｎ．κｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε␓‛．",
	}, { // 2454
		mask: EncodeZero | EncodeRightPeriod,
		in:   "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε.B",
		out:  "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε.B",
	}, { // 2455
		mask: EncodeZero | EncodeRightPeriod,
		in:   "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε．B",
		out:  "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε．B",
	}, { // 2456
		mask: EncodeZero | EncodeRightPeriod,
		in:   "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε.．",
		out:  "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε.‛．",
	}, { // 2457
		mask: EncodeZero | EncodeRightPeriod,
		in:   "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε．．",
		out:  "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε．‛．",
	}, { // 2458
		mask: EncodeZero | EncodeRightPeriod,
		in:   "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε␓.",
		out:  "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε␓．",
	}, { // 2459
		mask: EncodeZero | EncodeRightPeriod,
		in:   "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ\x00／5␞␛%（␞?ιε␓．",
		out:  "ｎjκｘψ\x02␌Ｙ{\n.\x16，R.βρ␀／5␞␛%（␞?ιε␓‛．",
	}, { // 2460
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：＞",
		out:  "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：＞",
	}, { // 2461
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".．％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：＞",
		out:  ".．％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：＞",
	}, { // 2462
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．．％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：＞",
		out:  "．．％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：＞",
	}, { // 2463
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f．＞",
		out:  ".＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f．＞",
	}, { // 2464
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f．＞",
		out:  "．＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f．＞",
	}, { // 2465
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：．",
		out:  ".＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：‛．",
	}, { // 2466
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：．",
		out:  "．＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：‛．",
	}, { // 2467
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␛.％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：＞",
		out:  "␛.％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：＞",
	}, { // 2468
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␛．％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：＞",
		out:  "␛．％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：＞",
	}, { // 2469
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␛.％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f．＞",
		out:  "␛.％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f．＞",
	}, { // 2470
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␛．％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f．＞",
		out:  "␛．％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f．＞",
	}, { // 2471
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␛.％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：．",
		out:  "␛.％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：‛．",
	}, { // 2472
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␛．％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：．",
		out:  "␛．％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：‛．",
	}, { // 2473
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f.＞",
		out:  "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f.＞",
	}, { // 2474
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f．＞",
		out:  "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f．＞",
	}, { // 2475
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f.．",
		out:  "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f.‛．",
	}, { // 2476
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f．．",
		out:  "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f．‛．",
	}, { // 2477
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：.",
		out:  "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：．",
	}, { // 2478
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：．",
		out:  "␛＊％χ\x16'ＫU␗L.ω｀ςr␏ｎ)\x16\\φ\r？ζ［J\v\f：‛．",
	}, { // 2479
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ－",
		out:  "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ－",
	}, { // 2480
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   ".．L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ－",
		out:  ".．L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ－",
	}, { // 2481
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "．．L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ－",
		out:  "．．L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ－",
	}, { // 2482
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   ".␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ．－",
		out:  ".␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ．－",
	}, { // 2483
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "．␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ．－",
		out:  "．␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ．－",
	}, { // 2484
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   ".␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ．",
		out:  ".␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ‛．",
	}, { // 2485
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "．␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ．",
		out:  "．␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ‛．",
	}, { // 2486
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "l.L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ－",
		out:  "l.L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ－",
	}, { // 2487
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "l．L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ－",
		out:  "l．L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ－",
	}, { // 2488
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "l.L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ．－",
		out:  "l.L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ．－",
	}, { // 2489
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "l．L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ．－",
		out:  "l．L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ．－",
	}, { // 2490
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "l.L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ．",
		out:  "l.L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ‛．",
	}, { // 2491
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "l．L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ．",
		out:  "l．L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ‛．",
	}, { // 2492
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ.－",
		out:  "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ.－",
	}, { // 2493
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ．－",
		out:  "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ．－",
	}, { // 2494
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ.．",
		out:  "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ.‛．",
	}, { // 2495
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ．．",
		out:  "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδ．‛．",
	}, { // 2496
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ.",
		out:  "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ．",
	}, { // 2497
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ．",
		out:  "l␌L␟ο!\x1b＼|＜.χαＴP\x1c＞\"␗$ζ％＋Ｉ\x1d\x1aaδλ‛．",
	}, { // 2498
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "i｜`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃g０",
		out:  "i｜｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃g０",
	}, { // 2499
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   ".．`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃g０",
		out:  ".．｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃g０",
	}, { // 2500
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "．．`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃g０",
		out:  "．．｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃g０",
	}, { // 2501
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   ".｜`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃．０",
		out:  ".｜｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃．０",
	}, { // 2502
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "．｜`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃．０",
		out:  "．｜｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃．０",
	}, { // 2503
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   ".｜`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃g．",
		out:  ".｜｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃g‛．",
	}, { // 2504
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "．｜`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃g．",
		out:  "．｜｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃g‛．",
	}, { // 2505
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "i.`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃g０",
		out:  "i.｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃g０",
	}, { // 2506
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "i．`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃g０",
		out:  "i．｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃g０",
	}, { // 2507
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "i.`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃．０",
		out:  "i.｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃．０",
	}, { // 2508
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "i．`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃．０",
		out:  "i．｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃．０",
	}, { // 2509
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "i.`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃g．",
		out:  "i.｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃g‛．",
	}, { // 2510
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "i．`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃g．",
		out:  "i．｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃g‛．",
	}, { // 2511
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "i｜`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃.０",
		out:  "i｜｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃.０",
	}, { // 2512
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "i｜`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃．０",
		out:  "i｜｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃．０",
	}, { // 2513
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "i｜`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃.．",
		out:  "i｜｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃.‛．",
	}, { // 2514
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "i｜`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃．．",
		out:  "i｜｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃．‛．",
	}, { // 2515
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "i｜`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃g.",
		out:  "i｜｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃g．",
	}, { // 2516
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "i｜`νφ<fς\x1a:.NRθκ\vγＵL）\x10␀␈ＭＣ＜␋＃g．",
		out:  "i｜｀νφ<fς\x1a:.NRθκ\vγＵL）\x10‛␀␈ＭＣ＜␋＃g‛．",
	}, { // 2517
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃␓",
		out:  "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃␓",
	}, { // 2518
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   ".．θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃␓",
		out:  ".．θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃␓",
	}, { // 2519
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "．．θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃␓",
		out:  "．．θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃␓",
	}, { // 2520
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   ".9θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P．␓",
		out:  ".9θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P．␓",
	}, { // 2521
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "．9θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P．␓",
		out:  "．9θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P．␓",
	}, { // 2522
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   ".9θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃．",
		out:  ".9θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃‛．",
	}, { // 2523
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "．9θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃．",
		out:  "．9θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃‛．",
	}, { // 2524
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "\x04.θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃␓",
		out:  "\x04.θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃␓",
	}, { // 2525
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "\x04．θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃␓",
		out:  "\x04．θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃␓",
	}, { // 2526
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "\x04.θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P．␓",
		out:  "\x04.θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P．␓",
	}, { // 2527
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "\x04．θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P．␓",
		out:  "\x04．θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P．␓",
	}, { // 2528
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "\x04.θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃．",
		out:  "\x04.θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃‛．",
	}, { // 2529
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "\x04．θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃．",
		out:  "\x04．θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃‛．",
	}, { // 2530
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P.␓",
		out:  "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P.␓",
	}, { // 2531
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P．␓",
		out:  "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P．␓",
	}, { // 2532
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P.．",
		out:  "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P.‛．",
	}, { // 2533
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P．．",
		out:  "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P．‛．",
	}, { // 2534
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃.",
		out:  "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃．",
	}, { // 2535
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃．",
		out:  "\x049θνOＥψＷο\x1e.*7＠␍␆ο␗=\x01ｗｒ␂|^σ/P␃‛．",
	}, { // 2536
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ＇",
		out:  "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ＇",
	}, { // 2537
		mask: EncodeDollar | EncodeRightPeriod,
		in:   ".．␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ＇",
		out:  ".．␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ＇",
	}, { // 2538
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "．．␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ＇",
		out:  "．．␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ＇",
	}, { // 2539
		mask: EncodeDollar | EncodeRightPeriod,
		in:   ".␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14．＇",
		out:  ".␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14．＇",
	}, { // 2540
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "．␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14．＇",
		out:  "．␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14．＇",
	}, { // 2541
		mask: EncodeDollar | EncodeRightPeriod,
		in:   ".␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ．",
		out:  ".␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ‛．",
	}, { // 2542
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "．␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ．",
		out:  "．␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ‛．",
	}, { // 2543
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "p.␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ＇",
		out:  "p.␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ＇",
	}, { // 2544
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "p．␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ＇",
		out:  "p．␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ＇",
	}, { // 2545
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "p.␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14．＇",
		out:  "p.␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14．＇",
	}, { // 2546
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "p．␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14．＇",
		out:  "p．␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14．＇",
	}, { // 2547
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "p.␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ．",
		out:  "p.␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ‛．",
	}, { // 2548
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "p．␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ．",
		out:  "p．␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ‛．",
	}, { // 2549
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14.＇",
		out:  "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14.＇",
	}, { // 2550
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14．＇",
		out:  "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14．＇",
	}, { // 2551
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14.．",
		out:  "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14.‛．",
	}, { // 2552
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14．．",
		out:  "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14．‛．",
	}, { // 2553
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ.",
		out:  "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ．",
	}, { // 2554
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ．",
		out:  "p␌␁ρψ%Ｖ\x1a\x0fθ.?\x03␞ＪL*－Kｊ␏e␙ψοjλ\x14ｂ‛．",
	}, { // 2555
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．Ａｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\␄␊",
		out:  "．Ａｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\␄␊",
	}, { // 2556
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   ".．ｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\␄␊",
		out:  ".．ｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\␄␊",
	}, { // 2557
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．．ｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\␄␊",
		out:  "．．ｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\␄␊",
	}, { // 2558
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   ".Ａｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\．␊",
		out:  ".Ａｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\．␊",
	}, { // 2559
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．Ａｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\．␊",
		out:  "．Ａｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\．␊",
	}, { // 2560
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   ".Ａｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\␄．",
		out:  ".Ａｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\␄‛．",
	}, { // 2561
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．Ａｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\␄．",
		out:  "．Ａｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\␄‛．",
	}, { // 2562
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．.ｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\␄␊",
		out:  "．.ｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\␄␊",
	}, { // 2563
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．．ｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\␄␊",
		out:  "．．ｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\␄␊",
	}, { // 2564
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．.ｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\．␊",
		out:  "．.ｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\．␊",
	}, { // 2565
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．．ｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\．␊",
		out:  "．．ｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\．␊",
	}, { // 2566
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．.ｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\␄．",
		out:  "．.ｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\␄‛．",
	}, { // 2567
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．．ｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\␄．",
		out:  "．．ｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\␄‛．",
	}, { // 2568
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．Ａｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\.␊",
		out:  "．Ａｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\.␊",
	}, { // 2569
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．Ａｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\．␊",
		out:  "．Ａｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\．␊",
	}, { // 2570
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．Ａｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\.．",
		out:  "．Ａｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\.‛．",
	}, { // 2571
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．Ａｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\．．",
		out:  "．Ａｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\．‛．",
	}, { // 2572
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．Ａｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\␄.",
		out:  "．Ａｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\␄．",
	}, { // 2573
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．Ａｂ｀Ｚβｘ␋_:.οιη?\x00tV>*␖ι\b_␘(φ\\␄．",
		out:  "．Ａｂ｀Ｚβｘ␋_:.οιη?␀tV>*␖ι\b_␘(φ\\␄‛．",
	}, { // 2574
		mask: EncodeColon | EncodeRightPeriod,
		in:   "zρψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05␛",
		out:  "zρψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05␛",
	}, { // 2575
		mask: EncodeColon | EncodeRightPeriod,
		in:   ".．ψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05␛",
		out:  ".．ψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05␛",
	}, { // 2576
		mask: EncodeColon | EncodeRightPeriod,
		in:   "．．ψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05␛",
		out:  "．．ψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05␛",
	}, { // 2577
		mask: EncodeColon | EncodeRightPeriod,
		in:   ".ρψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ．␛",
		out:  ".ρψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ．␛",
	}, { // 2578
		mask: EncodeColon | EncodeRightPeriod,
		in:   "．ρψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ．␛",
		out:  "．ρψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ．␛",
	}, { // 2579
		mask: EncodeColon | EncodeRightPeriod,
		in:   ".ρψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05．",
		out:  ".ρψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05‛．",
	}, { // 2580
		mask: EncodeColon | EncodeRightPeriod,
		in:   "．ρψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05．",
		out:  "．ρψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05‛．",
	}, { // 2581
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z.ψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05␛",
		out:  "z.ψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05␛",
	}, { // 2582
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z．ψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05␛",
		out:  "z．ψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05␛",
	}, { // 2583
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z.ψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ．␛",
		out:  "z.ψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ．␛",
	}, { // 2584
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z．ψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ．␛",
		out:  "z．ψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ．␛",
	}, { // 2585
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z.ψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05．",
		out:  "z.ψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05‛．",
	}, { // 2586
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z．ψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05．",
		out:  "z．ψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05‛．",
	}, { // 2587
		mask: EncodeColon | EncodeRightPeriod,
		in:   "zρψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ.␛",
		out:  "zρψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ.␛",
	}, { // 2588
		mask: EncodeColon | EncodeRightPeriod,
		in:   "zρψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ．␛",
		out:  "zρψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ．␛",
	}, { // 2589
		mask: EncodeColon | EncodeRightPeriod,
		in:   "zρψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ.．",
		out:  "zρψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ.‛．",
	}, { // 2590
		mask: EncodeColon | EncodeRightPeriod,
		in:   "zρψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ．．",
		out:  "zρψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ．‛．",
	}, { // 2591
		mask: EncodeColon | EncodeRightPeriod,
		in:   "zρψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05.",
		out:  "zρψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05．",
	}, { // 2592
		mask: EncodeColon | EncodeRightPeriod,
		in:   "zρψｕσＥ\r\x00\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05．",
		out:  "zρψｕσＥ\r␀\uff00,.␍κ｀Sg|＂<,`\x1e］␛ψ０＼δ\x05‛．",
	}, { // 2593
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜εS",
		out:  "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜εS",
	}, { // 2594
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   ".．␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜εS",
		out:  ".．␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜εS",
	}, { // 2595
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "．．␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜εS",
		out:  "．．␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜εS",
	}, { // 2596
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   ".ｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜．S",
		out:  ".ｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜．S",
	}, { // 2597
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "．ｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜．S",
		out:  "．ｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜．S",
	}, { // 2598
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   ".ｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜ε．",
		out:  ".ｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜ε‛．",
	}, { // 2599
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "．ｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜ε．",
		out:  "．ｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜ε‛．",
	}, { // 2600
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\a.␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜εS",
		out:  "\a.␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜εS",
	}, { // 2601
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\a．␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜εS",
		out:  "\a．␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜εS",
	}, { // 2602
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\a.␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜．S",
		out:  "\a.␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜．S",
	}, { // 2603
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\a．␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜．S",
		out:  "\a．␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜．S",
	}, { // 2604
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\a.␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜ε．",
		out:  "\a.␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜ε‛．",
	}, { // 2605
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\a．␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜ε．",
		out:  "\a．␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜ε‛．",
	}, { // 2606
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜.S",
		out:  "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜.S",
	}, { // 2607
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜．S",
		out:  "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜．S",
	}, { // 2608
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜.．",
		out:  "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜.‛．",
	}, { // 2609
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜．．",
		out:  "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜．‛．",
	}, { // 2610
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜ε.",
		out:  "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜ε．",
	}, { // 2611
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓？$／９２＜ε．",
		out:  "\aｆ␚υ\x1aξｏ:;υ.ρ（e\bφ＼␊z\x17_␓‛？$／９２＜ε‛．",
	}, { // 2612
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟␙",
		out:  "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟␙",
	}, { // 2613
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   ".．\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟␙",
		out:  ".．\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟␙",
	}, { // 2614
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "．．\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟␙",
		out:  "．．\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟␙",
	}, { // 2615
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   ".␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|．␙",
		out:  ".␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|．␙",
	}, { // 2616
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "．␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|．␙",
		out:  "．␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|．␙",
	}, { // 2617
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   ".␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟．",
		out:  ".␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟‛．",
	}, { // 2618
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "．␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟．",
		out:  "．␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟‛．",
	}, { // 2619
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "(.\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟␙",
		out:  "(.\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟␙",
	}, { // 2620
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "(．\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟␙",
		out:  "(．\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟␙",
	}, { // 2621
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "(.\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|．␙",
		out:  "(.\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|．␙",
	}, { // 2622
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "(．\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|．␙",
		out:  "(．\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|．␙",
	}, { // 2623
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "(.\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟．",
		out:  "(.\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟‛．",
	}, { // 2624
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "(．\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟．",
		out:  "(．\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟‛．",
	}, { // 2625
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|.␙",
		out:  "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|.␙",
	}, { // 2626
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|．␙",
		out:  "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|．␙",
	}, { // 2627
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|.．",
		out:  "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|.‛．",
	}, { // 2628
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|．．",
		out:  "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|．‛．",
	}, { // 2629
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟.",
		out:  "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟．",
	}, { // 2630
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟．",
		out:  "(␔\x0eφ\x03ηψ>u␛.＞υ ｈ，y%ο\x144ο4ｂＢｘ␙|␟‛．",
	}, { // 2631
		mask: EncodePipe | EncodeRightPeriod,
		in:   "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε>",
		out:  "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε>",
	}, { // 2632
		mask: EncodePipe | EncodeRightPeriod,
		in:   ".．υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε>",
		out:  ".．υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε>",
	}, { // 2633
		mask: EncodePipe | EncodeRightPeriod,
		in:   "．．υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε>",
		out:  "．．υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε>",
	}, { // 2634
		mask: EncodePipe | EncodeRightPeriod,
		in:   ".␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐．>",
		out:  ".␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐．>",
	}, { // 2635
		mask: EncodePipe | EncodeRightPeriod,
		in:   "．␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐．>",
		out:  "．␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐．>",
	}, { // 2636
		mask: EncodePipe | EncodeRightPeriod,
		in:   ".␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε．",
		out:  ".␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε‛．",
	}, { // 2637
		mask: EncodePipe | EncodeRightPeriod,
		in:   "．␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε．",
		out:  "．␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε‛．",
	}, { // 2638
		mask: EncodePipe | EncodeRightPeriod,
		in:   "B.υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε>",
		out:  "B.υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε>",
	}, { // 2639
		mask: EncodePipe | EncodeRightPeriod,
		in:   "B．υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε>",
		out:  "B．υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε>",
	}, { // 2640
		mask: EncodePipe | EncodeRightPeriod,
		in:   "B.υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐．>",
		out:  "B.υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐．>",
	}, { // 2641
		mask: EncodePipe | EncodeRightPeriod,
		in:   "B．υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐．>",
		out:  "B．υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐．>",
	}, { // 2642
		mask: EncodePipe | EncodeRightPeriod,
		in:   "B.υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε．",
		out:  "B.υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε‛．",
	}, { // 2643
		mask: EncodePipe | EncodeRightPeriod,
		in:   "B．υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε．",
		out:  "B．υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε‛．",
	}, { // 2644
		mask: EncodePipe | EncodeRightPeriod,
		in:   "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐.>",
		out:  "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐.>",
	}, { // 2645
		mask: EncodePipe | EncodeRightPeriod,
		in:   "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐．>",
		out:  "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐．>",
	}, { // 2646
		mask: EncodePipe | EncodeRightPeriod,
		in:   "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐.．",
		out:  "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐.‛．",
	}, { // 2647
		mask: EncodePipe | EncodeRightPeriod,
		in:   "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐．．",
		out:  "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐．‛．",
	}, { // 2648
		mask: EncodePipe | EncodeRightPeriod,
		in:   "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε.",
		out:  "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε．",
	}, { // 2649
		mask: EncodePipe | EncodeRightPeriod,
		in:   "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε．",
		out:  "B␊υη␄ωｙ！ω8.lN␝I_ｚ`\t｀χ\x1f\x1c\n＃␁ｏ␐ε‛．",
	}, { // 2650
		mask: EncodeHash | EncodeRightPeriod,
		in:   "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02␎",
		out:  "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02␎",
	}, { // 2651
		mask: EncodeHash | EncodeRightPeriod,
		in:   ".．\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02␎",
		out:  ".．\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02␎",
	}, { // 2652
		mask: EncodeHash | EncodeRightPeriod,
		in:   "．．\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02␎",
		out:  "．．\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02␎",
	}, { // 2653
		mask: EncodeHash | EncodeRightPeriod,
		in:   ".γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12．␎",
		out:  ".γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12．␎",
	}, { // 2654
		mask: EncodeHash | EncodeRightPeriod,
		in:   "．γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12．␎",
		out:  "．γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12．␎",
	}, { // 2655
		mask: EncodeHash | EncodeRightPeriod,
		in:   ".γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02．",
		out:  ".γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02‛．",
	}, { // 2656
		mask: EncodeHash | EncodeRightPeriod,
		in:   "．γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02．",
		out:  "．γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02‛．",
	}, { // 2657
		mask: EncodeHash | EncodeRightPeriod,
		in:   "%.\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02␎",
		out:  "%.\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02␎",
	}, { // 2658
		mask: EncodeHash | EncodeRightPeriod,
		in:   "%．\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02␎",
		out:  "%．\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02␎",
	}, { // 2659
		mask: EncodeHash | EncodeRightPeriod,
		in:   "%.\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12．␎",
		out:  "%.\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12．␎",
	}, { // 2660
		mask: EncodeHash | EncodeRightPeriod,
		in:   "%．\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12．␎",
		out:  "%．\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12．␎",
	}, { // 2661
		mask: EncodeHash | EncodeRightPeriod,
		in:   "%.\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02．",
		out:  "%.\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02‛．",
	}, { // 2662
		mask: EncodeHash | EncodeRightPeriod,
		in:   "%．\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02．",
		out:  "%．\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02‛．",
	}, { // 2663
		mask: EncodeHash | EncodeRightPeriod,
		in:   "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12.␎",
		out:  "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12.␎",
	}, { // 2664
		mask: EncodeHash | EncodeRightPeriod,
		in:   "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12．␎",
		out:  "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12．␎",
	}, { // 2665
		mask: EncodeHash | EncodeRightPeriod,
		in:   "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12.．",
		out:  "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12.‛．",
	}, { // 2666
		mask: EncodeHash | EncodeRightPeriod,
		in:   "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12．．",
		out:  "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12．‛．",
	}, { // 2667
		mask: EncodeHash | EncodeRightPeriod,
		in:   "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02.",
		out:  "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02．",
	}, { // 2668
		mask: EncodeHash | EncodeRightPeriod,
		in:   "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02．",
		out:  "%γ\uff00＄γψ␍_\x04ο.␈dυβ<Ｔ|\tｇｌE７\b+［％\x12\x02‛．",
	}, { // 2669
		mask: EncodePercent | EncodeRightPeriod,
		in:   "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18η",
		out:  "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18η",
	}, { // 2670
		mask: EncodePercent | EncodeRightPeriod,
		in:   ".．␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18η",
		out:  ".．␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18η",
	}, { // 2671
		mask: EncodePercent | EncodeRightPeriod,
		in:   "．．␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18η",
		out:  "．．␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18η",
	}, { // 2672
		mask: EncodePercent | EncodeRightPeriod,
		in:   ".６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π．η",
		out:  ".６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π．η",
	}, { // 2673
		mask: EncodePercent | EncodeRightPeriod,
		in:   "．６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π．η",
		out:  "．６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π．η",
	}, { // 2674
		mask: EncodePercent | EncodeRightPeriod,
		in:   ".６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18．",
		out:  ".６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18‛．",
	}, { // 2675
		mask: EncodePercent | EncodeRightPeriod,
		in:   "．６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18．",
		out:  "．６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18‛．",
	}, { // 2676
		mask: EncodePercent | EncodeRightPeriod,
		in:   "\a.␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18η",
		out:  "\a.␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18η",
	}, { // 2677
		mask: EncodePercent | EncodeRightPeriod,
		in:   "\a．␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18η",
		out:  "\a．␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18η",
	}, { // 2678
		mask: EncodePercent | EncodeRightPeriod,
		in:   "\a.␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π．η",
		out:  "\a.␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π．η",
	}, { // 2679
		mask: EncodePercent | EncodeRightPeriod,
		in:   "\a．␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π．η",
		out:  "\a．␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π．η",
	}, { // 2680
		mask: EncodePercent | EncodeRightPeriod,
		in:   "\a.␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18．",
		out:  "\a.␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18‛．",
	}, { // 2681
		mask: EncodePercent | EncodeRightPeriod,
		in:   "\a．␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18．",
		out:  "\a．␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18‛．",
	}, { // 2682
		mask: EncodePercent | EncodeRightPeriod,
		in:   "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π.η",
		out:  "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π.η",
	}, { // 2683
		mask: EncodePercent | EncodeRightPeriod,
		in:   "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π．η",
		out:  "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π．η",
	}, { // 2684
		mask: EncodePercent | EncodeRightPeriod,
		in:   "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π.．",
		out:  "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π.‛．",
	}, { // 2685
		mask: EncodePercent | EncodeRightPeriod,
		in:   "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π．．",
		out:  "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π．‛．",
	}, { // 2686
		mask: EncodePercent | EncodeRightPeriod,
		in:   "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18.",
		out:  "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18．",
	}, { // 2687
		mask: EncodePercent | EncodeRightPeriod,
		in:   "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18．",
		out:  "\a６␉μXAζ８］>.-ｃ＃／\x13␜＼π^(φ/ｚ\x1e＇7π\x18‛．",
	}, { // 2688
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？ｏ５",
		out:  "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？ｏ５",
	}, { // 2689
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   ".．｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？ｏ５",
		out:  ".．｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？ｏ５",
	}, { // 2690
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．．｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？ｏ５",
		out:  "．．｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？ｏ５",
	}, { // 2691
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   ".)｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？．５",
		out:  ".)｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？．５",
	}, { // 2692
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．)｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？．５",
		out:  "．)｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？．５",
	}, { // 2693
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   ".)｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？ｏ．",
		out:  ".)｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？ｏ‛．",
	}, { // 2694
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．)｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？ｏ．",
		out:  "．)｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？ｏ‛．",
	}, { // 2695
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "\x1e.｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？ｏ５",
		out:  "\x1e.｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？ｏ５",
	}, { // 2696
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "\x1e．｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？ｏ５",
		out:  "\x1e．｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？ｏ５",
	}, { // 2697
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "\x1e.｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？．５",
		out:  "\x1e.｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？．５",
	}, { // 2698
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "\x1e．｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？．５",
		out:  "\x1e．｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？．５",
	}, { // 2699
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "\x1e.｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？ｏ．",
		out:  "\x1e.｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？ｏ‛．",
	}, { // 2700
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "\x1e．｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？ｏ．",
		out:  "\x1e．｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？ｏ‛．",
	}, { // 2701
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？.５",
		out:  "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？.５",
	}, { // 2702
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？．５",
		out:  "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？．５",
	}, { // 2703
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？.．",
		out:  "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？.‛．",
	}, { // 2704
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？．．",
		out:  "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？．‛．",
	}, { // 2705
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？ｏ.",
		out:  "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？ｏ．",
	}, { // 2706
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t\\＄ωｉςx#*λZＨ＼？ｏ．",
		out:  "\x1e)｜*␔\f\aμ␉Ｇ.␖τe\t＼＄ωｉςx#*λZＨ‛＼？ｏ‛．",
	}, { // 2707
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "Ｏ␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇\f",
		out:  "Ｏ‛␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇\f",
	}, { // 2708
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   ".．βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇\f",
		out:  ".．βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇\f",
	}, { // 2709
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "．．βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇\f",
		out:  "．．βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇\f",
	}, { // 2710
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   ".␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'．\f",
		out:  ".‛␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'．\f",
	}, { // 2711
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "．␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'．\f",
		out:  "．‛␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'．\f",
	}, { // 2712
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   ".␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇．",
		out:  ".‛␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇‛．",
	}, { // 2713
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "．␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇．",
		out:  "．‛␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇‛．",
	}, { // 2714
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "Ｏ.βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇\f",
		out:  "Ｏ.βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇\f",
	}, { // 2715
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "Ｏ．βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇\f",
		out:  "Ｏ．βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇\f",
	}, { // 2716
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "Ｏ.βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'．\f",
		out:  "Ｏ.βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'．\f",
	}, { // 2717
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "Ｏ．βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'．\f",
		out:  "Ｏ．βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'．\f",
	}, { // 2718
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "Ｏ.βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇．",
		out:  "Ｏ.βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇‛．",
	}, { // 2719
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "Ｏ．βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇．",
		out:  "Ｏ．βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇‛．",
	}, { // 2720
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "Ｏ␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'.\f",
		out:  "Ｏ‛␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'.\f",
	}, { // 2721
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "Ｏ␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'．\f",
		out:  "Ｏ‛␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'．\f",
	}, { // 2722
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "Ｏ␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'.．",
		out:  "Ｏ‛␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'.‛．",
	}, { // 2723
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "Ｏ␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'．．",
		out:  "Ｏ‛␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'．‛．",
	}, { // 2724
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "Ｏ␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇.",
		out:  "Ｏ‛␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇．",
	}, { // 2725
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "Ｏ␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇．",
		out:  "Ｏ‛␍βνd\uff00θ\x1bMζ.␉␃Ｆ/\x16 ␚\u007fνP＞β９5]␐'＇‛．",
	}, { // 2726
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σｚＥ",
		out:  "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σｚＥ",
	}, { // 2727
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".．γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σｚＥ",
		out:  ".．γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σｚＥ",
	}, { // 2728
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．．γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σｚＥ",
		out:  "．．γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σｚＥ",
	}, { // 2729
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σ．Ｅ",
		out:  ".\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σ．Ｅ",
	}, { // 2730
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σ．Ｅ",
		out:  "．\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σ．Ｅ",
	}, { // 2731
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σｚ．",
		out:  ".\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σｚ‛．",
	}, { // 2732
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σｚ．",
		out:  "．\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σｚ‛．",
	}, { // 2733
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x12.γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σｚＥ",
		out:  "\x12.γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σｚＥ",
	}, { // 2734
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x12．γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σｚＥ",
		out:  "\x12．γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σｚＥ",
	}, { // 2735
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x12.γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σ．Ｅ",
		out:  "\x12.γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σ．Ｅ",
	}, { // 2736
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x12．γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σ．Ｅ",
		out:  "\x12．γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σ．Ｅ",
	}, { // 2737
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x12.γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σｚ．",
		out:  "\x12.γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σｚ‛．",
	}, { // 2738
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x12．γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σｚ．",
		out:  "\x12．γ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σｚ‛．",
	}, { // 2739
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σ.Ｅ",
		out:  "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σ.Ｅ",
	}, { // 2740
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σ．Ｅ",
		out:  "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σ．Ｅ",
	}, { // 2741
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σ.．",
		out:  "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σ.‛．",
	}, { // 2742
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σ．．",
		out:  "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σ．‛．",
	}, { // 2743
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σｚ.",
		out:  "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σｚ．",
	}, { // 2744
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘\u007f␜␎σｚ．",
		out:  "\x12\nγ[εν\"\x1d［␖.i：He\x1d\"ηγ␚－Ｏｊ␘␡␜␎σｚ‛．",
	}, { // 2745
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "＂ο␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα:b",
		out:  "＂ο‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα:b",
	}, { // 2746
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".．␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα:b",
		out:  ".．‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα:b",
	}, { // 2747
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．．␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα:b",
		out:  "．．‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα:b",
	}, { // 2748
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".ο␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα．b",
		out:  ".ο‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα．b",
	}, { // 2749
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．ο␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα．b",
		out:  "．ο‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα．b",
	}, { // 2750
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".ο␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα:．",
		out:  ".ο‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα:‛．",
	}, { // 2751
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．ο␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα:．",
		out:  "．ο‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα:‛．",
	}, { // 2752
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "＂.␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα:b",
		out:  "＂.‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα:b",
	}, { // 2753
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "＂．␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα:b",
		out:  "＂．‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα:b",
	}, { // 2754
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "＂.␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα．b",
		out:  "＂.‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα．b",
	}, { // 2755
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "＂．␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα．b",
		out:  "＂．‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα．b",
	}, { // 2756
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "＂.␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα:．",
		out:  "＂.‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα:‛．",
	}, { // 2757
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "＂．␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα:．",
		out:  "＂．‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα:‛．",
	}, { // 2758
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "＂ο␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα.b",
		out:  "＂ο‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα.b",
	}, { // 2759
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "＂ο␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα．b",
		out:  "＂ο‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα．b",
	}, { // 2760
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "＂ο␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα.．",
		out:  "＂ο‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα.‛．",
	}, { // 2761
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "＂ο␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα．．",
		out:  "＂ο‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα．‛．",
	}, { // 2762
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "＂ο␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα:.",
		out:  "＂ο‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα:．",
	}, { // 2763
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "＂ο␓␉\x02␕cy；：.`Ｇει:κ␊\uff004/ＷN$ａζlα:．",
		out:  "＂ο‛␓‛␉␂‛␕cy；：.`Ｇει:κ‛␊\uff004/ＷN$ａζlα:‛．",
	}, { // 2764
		mask: EncodeRightCrLfHtVt,
		in:   "\t",
		out:  "␉",
	}, { // 2765
		mask: EncodeRightCrLfHtVt,
		in:   "\n",
		out:  "␊",
	}, { // 2766
		mask: EncodeRightCrLfHtVt,
		in:   "\v",
		out:  "␋",
	}, { // 2767
		mask: EncodeRightCrLfHtVt,
		in:   "\r",
		out:  "␍",
	}, { // 2768
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "[｀τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐\":",
		out:  "[｀τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐\":",
	}, { // 2769
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\t␉τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐\":",
		out:  "\t␉τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐\":",
	}, { // 2770
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␉␉τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐\":",
		out:  "␉␉τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐\":",
	}, { // 2771
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\t｀τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐␉:",
		out:  "\t｀τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐␉:",
	}, { // 2772
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␉｀τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐␉:",
		out:  "␉｀τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐␉:",
	}, { // 2773
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\t｀τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐\"␉",
		out:  "\t｀τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐\"‛␉",
	}, { // 2774
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␉｀τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐\"␉",
		out:  "␉｀τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐\"‛␉",
	}, { // 2775
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "[\tτｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐\":",
		out:  "[\tτｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐\":",
	}, { // 2776
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "[␉τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐\":",
		out:  "[␉τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐\":",
	}, { // 2777
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "[\tτｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐␉:",
		out:  "[\tτｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐␉:",
	}, { // 2778
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "[␉τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐␉:",
		out:  "[␉τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐␉:",
	}, { // 2779
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "[\tτｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐\"␉",
		out:  "[\tτｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐\"‛␉",
	}, { // 2780
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "[␉τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐\"␉",
		out:  "[␉τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐\"‛␉",
	}, { // 2781
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "[｀τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐\t:",
		out:  "[｀τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐\t:",
	}, { // 2782
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "[｀τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐␉:",
		out:  "[｀τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐␉:",
	}, { // 2783
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "[｀τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐\t␉",
		out:  "[｀τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐\t‛␉",
	}, { // 2784
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "[｀τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐␉␉",
		out:  "[｀τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐␉‛␉",
	}, { // 2785
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "[｀τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐\"\t",
		out:  "[｀τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐\"␉",
	}, { // 2786
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "[｀τｔ＿␊υ\\\x12␊\t␈\"χ\x00η\r２@γ｜r␅s<λ１␐\"␉",
		out:  "[｀τｔ＿␊υ\\\x12␊\t␈\"χ␀η\r２@γ｜r␅s<λ１␐\"‛␉",
	}, { // 2787
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1cρ",
		out:  "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1cρ",
	}, { // 2788
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n␊ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1cρ",
		out:  "\n␊ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1cρ",
	}, { // 2789
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␊␊ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1cρ",
		out:  "␊␊ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1cρ",
	}, { // 2790
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB␊ρ",
		out:  "\n>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB␊ρ",
	}, { // 2791
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␊>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB␊ρ",
		out:  "␊>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB␊ρ",
	}, { // 2792
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1c␊",
		out:  "\n>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1c‛␊",
	}, { // 2793
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␊>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1c␊",
		out:  "␊>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1c‛␊",
	}, { // 2794
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Ｏ\nζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1cρ",
		out:  "Ｏ\nζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1cρ",
	}, { // 2795
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Ｏ␊ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1cρ",
		out:  "Ｏ␊ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1cρ",
	}, { // 2796
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Ｏ\nζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB␊ρ",
		out:  "Ｏ\nζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB␊ρ",
	}, { // 2797
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Ｏ␊ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB␊ρ",
		out:  "Ｏ␊ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB␊ρ",
	}, { // 2798
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Ｏ\nζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1c␊",
		out:  "Ｏ\nζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1c‛␊",
	}, { // 2799
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Ｏ␊ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1c␊",
		out:  "Ｏ␊ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1c‛␊",
	}, { // 2800
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\nρ",
		out:  "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\nρ",
	}, { // 2801
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB␊ρ",
		out:  "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB␊ρ",
	}, { // 2802
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\n␊",
		out:  "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\n‛␊",
	}, { // 2803
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB␊␊",
		out:  "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB␊‛␊",
	}, { // 2804
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1c\n",
		out:  "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1c␊",
	}, { // 2805
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1c␊",
		out:  "Ｏ>ζ\u007f.M␃␉＞／\nβ|４#ａC\x1b␞␖xφ＆τ\nｄτB\x1c‛␊",
	}, { // 2806
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ-",
		out:  "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ-",
	}, { // 2807
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\v␋\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ-",
		out:  "\v␋\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ-",
	}, { // 2808
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␋␋\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ-",
		out:  "␋␋\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ-",
	}, { // 2809
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\v？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#␋-",
		out:  "\v？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#␋-",
	}, { // 2810
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␋？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#␋-",
		out:  "␋？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#␋-",
	}, { // 2811
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\v？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ␋",
		out:  "\v？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ‛␋",
	}, { // 2812
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␋？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ␋",
		out:  "␋？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ‛␋",
	}, { // 2813
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r\v\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ-",
		out:  "\r\v\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ-",
	}, { // 2814
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r␋\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ-",
		out:  "\r␋\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ-",
	}, { // 2815
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r\v\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#␋-",
		out:  "\r\v\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#␋-",
	}, { // 2816
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r␋\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#␋-",
		out:  "\r␋\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#␋-",
	}, { // 2817
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r\v\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ␋",
		out:  "\r\v\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ‛␋",
	}, { // 2818
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r␋\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ␋",
		out:  "\r␋\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ‛␋",
	}, { // 2819
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#\v-",
		out:  "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#\v-",
	}, { // 2820
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#␋-",
		out:  "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#␋-",
	}, { // 2821
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#\v␋",
		out:  "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#\v‛␋",
	}, { // 2822
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#␋␋",
		out:  "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#␋‛␋",
	}, { // 2823
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ\v",
		out:  "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ␋",
	}, { // 2824
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ␋",
		out:  "\r？\x1f\b＆␂ο␄＾␍\v␕\x18ωｘξeυ␜G，8τ\x1dk9＄#ρ‛␋",
	}, { // 2825
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ4",
		out:  "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ4",
	}, { // 2826
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r␍＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ4",
		out:  "\r␍＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ4",
	}, { // 2827
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␍␍＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ4",
		out:  "␍␍＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ4",
	}, { // 2828
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\rη＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01␍4",
		out:  "\rη＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01␍4",
	}, { // 2829
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␍η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01␍4",
		out:  "␍η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01␍4",
	}, { // 2830
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\rη＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ␍",
		out:  "\rη＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ‛␍",
	}, { // 2831
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␍η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ␍",
		out:  "␍η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ‛␍",
	}, { // 2832
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␈\r＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ4",
		out:  "␈\r＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ4",
	}, { // 2833
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␈␍＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ4",
		out:  "␈␍＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ4",
	}, { // 2834
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␈\r＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01␍4",
		out:  "␈\r＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01␍4",
	}, { // 2835
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␈␍＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01␍4",
		out:  "␈␍＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01␍4",
	}, { // 2836
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␈\r＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ␍",
		out:  "␈\r＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ‛␍",
	}, { // 2837
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␈␍＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ␍",
		out:  "␈␍＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ‛␍",
	}, { // 2838
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01\r4",
		out:  "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01\r4",
	}, { // 2839
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01␍4",
		out:  "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01␍4",
	}, { // 2840
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01\r␍",
		out:  "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01\r‛␍",
	}, { // 2841
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01␍␍",
		out:  "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01␍‛␍",
	}, { // 2842
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ\r",
		out:  "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ␍",
	}, { // 2843
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ␍",
		out:  "␈η＜７ψ@␍␇␓$\r?＞δ<\x031$６ｒφ\x17\v␊ｓ\x0e＂\x01γ‛␍",
	}, { // 2844
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   ".Ｓε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθD",
		out:  ".Ｓε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθD",
	}, { // 2845
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\t␉ε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθD",
		out:  "\t␉ε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθD",
	}, { // 2846
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␉␉ε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθD",
		out:  "␉␉ε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθD",
	}, { // 2847
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\tＳε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE␉D",
		out:  "\tＳε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE␉D",
	}, { // 2848
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␉Ｓε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE␉D",
		out:  "␉Ｓε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE␉D",
	}, { // 2849
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\tＳε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθ␉",
		out:  "\tＳε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθ‛␉",
	}, { // 2850
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␉Ｓε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθ␉",
		out:  "␉Ｓε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθ‛␉",
	}, { // 2851
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   ".\tε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθD",
		out:  ".\tε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθD",
	}, { // 2852
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   ".␉ε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθD",
		out:  ".␉ε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθD",
	}, { // 2853
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   ".\tε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE␉D",
		out:  ".\tε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE␉D",
	}, { // 2854
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   ".␉ε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE␉D",
		out:  ".␉ε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE␉D",
	}, { // 2855
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   ".\tε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθ␉",
		out:  ".\tε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθ‛␉",
	}, { // 2856
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   ".␉ε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθ␉",
		out:  ".␉ε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθ‛␉",
	}, { // 2857
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   ".Ｓε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE\tD",
		out:  ".Ｓε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE\tD",
	}, { // 2858
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   ".Ｓε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE␉D",
		out:  ".Ｓε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE␉D",
	}, { // 2859
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   ".Ｓε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE\t␉",
		out:  ".Ｓε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE\t‛␉",
	}, { // 2860
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   ".Ｓε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE␉␉",
		out:  ".Ｓε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χE␉‛␉",
	}, { // 2861
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   ".Ｓε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθ\t",
		out:  ".Ｓε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθ␉",
	}, { // 2862
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   ".Ｓε\x14ｍ／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθ␉",
		out:  ".Ｓε\x14ｍ‛／?χ\t␋\tλ|␃ｒE\a␂？␡hｅγ\x01␆＇χEθ‛␉",
	}, { // 2863
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ\f",
		out:  "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ\f",
	}, { // 2864
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\n␊(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ\f",
		out:  "\n␊(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ\f",
	}, { // 2865
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␊␊(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ\f",
		out:  "␊␊(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ\f",
	}, { // 2866
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\nｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n␊\f",
		out:  "\nｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n␊\f",
	}, { // 2867
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␊ｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n␊\f",
		out:  "␊ｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n␊\f",
	}, { // 2868
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\nｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ␊",
		out:  "\nｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ‛␊",
	}, { // 2869
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␊ｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ␊",
		out:  "␊ｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ‛␊",
	}, { // 2870
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "λ\n(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ\f",
		out:  "λ\n(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ\f",
	}, { // 2871
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "λ␊(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ\f",
		out:  "λ␊(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ\f",
	}, { // 2872
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "λ\n(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n␊\f",
		out:  "λ\n(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n␊\f",
	}, { // 2873
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "λ␊(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n␊\f",
		out:  "λ␊(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n␊\f",
	}, { // 2874
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "λ\n(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ␊",
		out:  "λ\n(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ‛␊",
	}, { // 2875
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "λ␊(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ␊",
		out:  "λ␊(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ‛␊",
	}, { // 2876
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n\n\f",
		out:  "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n\n\f",
	}, { // 2877
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n␊\f",
		out:  "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n␊\f",
	}, { // 2878
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n\n␊",
		out:  "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n\n‛␊",
	}, { // 2879
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n␊␊",
		out:  "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\n␊‛␊",
	}, { // 2880
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ\n",
		out:  "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ␊",
	}, { // 2881
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ␊",
		out:  "λｂ(␒ｐτ\x1a$\x06\x19\n@πYｊ：κ␙+\x1eε␑e␊␐ｕ，\nＮ‛␊",
	}, { // 2882
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9λ",
		out:  "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9λ",
	}, { // 2883
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\v␋μηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9λ",
		out:  "\v␋μηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9λ",
	}, { // 2884
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␋␋μηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9λ",
		out:  "␋␋μηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9λ",
	}, { // 2885
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\vεμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛␋λ",
		out:  "\vεμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛␋λ",
	}, { // 2886
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␋εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛␋λ",
		out:  "␋εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛␋λ",
	}, { // 2887
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\vεμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9␋",
		out:  "\vεμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9‛␋",
	}, { // 2888
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␋εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9␋",
		out:  "␋εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9‛␋",
	}, { // 2889
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\x06\vμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9λ",
		out:  "\x06\vμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9λ",
	}, { // 2890
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\x06␋μηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9λ",
		out:  "\x06␋μηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9λ",
	}, { // 2891
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\x06\vμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛␋λ",
		out:  "\x06\vμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛␋λ",
	}, { // 2892
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\x06␋μηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛␋λ",
		out:  "\x06␋μηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛␋λ",
	}, { // 2893
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\x06\vμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9␋",
		out:  "\x06\vμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9‛␋",
	}, { // 2894
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\x06␋μηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9␋",
		out:  "\x06␋μηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9‛␋",
	}, { // 2895
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛\vλ",
		out:  "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛\vλ",
	}, { // 2896
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛␋λ",
		out:  "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛␋λ",
	}, { // 2897
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛\v␋",
		out:  "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛\v‛␋",
	}, { // 2898
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛␋␋",
		out:  "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛␋‛␋",
	}, { // 2899
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9\v",
		out:  "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9␋",
	}, { // 2900
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9␋",
		out:  "\x06εμηω\x05ｏ］}Ｄ\v\x1b\"Z\b*␘␉αｍ␈9ｎ␂␎；f␛9‛␋",
	}, { // 2901
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχρ",
		out:  "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχρ",
	}, { // 2902
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\r␍α␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχρ",
		out:  "\r␍α␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχρ",
	}, { // 2903
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␍␍α␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχρ",
		out:  "␍␍α␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχρ",
	}, { // 2904
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\rMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ␍ρ",
		out:  "\rMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ␍ρ",
	}, { // 2905
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␍Mα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ␍ρ",
		out:  "␍Mα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ␍ρ",
	}, { // 2906
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\rMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχ␍",
		out:  "\rMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχ‛␍",
	}, { // 2907
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␍Mα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχ␍",
		out:  "␍Mα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχ‛␍",
	}, { // 2908
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\f\rα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχρ",
		out:  "\f\rα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχρ",
	}, { // 2909
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\f␍α␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχρ",
		out:  "\f␍α␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχρ",
	}, { // 2910
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\f\rα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ␍ρ",
		out:  "\f\rα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ␍ρ",
	}, { // 2911
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\f␍α␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ␍ρ",
		out:  "\f␍α␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ␍ρ",
	}, { // 2912
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\f\rα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχ␍",
		out:  "\f\rα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχ‛␍",
	}, { // 2913
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\f␍α␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχ␍",
		out:  "\f␍α␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχ‛␍",
	}, { // 2914
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ\rρ",
		out:  "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ\rρ",
	}, { // 2915
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ␍ρ",
		out:  "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ␍ρ",
	}, { // 2916
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ\r␍",
		out:  "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ\r‛␍",
	}, { // 2917
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ␍␍",
		out:  "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅ␍‛␍",
	}, { // 2918
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχ\r",
		out:  "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχ␍",
	}, { // 2919
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχ␍",
		out:  "\fMα␉␓␇␁ＬＷv\rςｃ\x19]␒\x1dφ\x13\\ω␘\tN\aＡ:Ｅχ‛␍",
	}, { // 2920
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t＃",
		out:  "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t＃",
	}, { // 2921
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\t␉␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t＃",
		out:  "\t␉␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t＃",
	}, { // 2922
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␉␉␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t＃",
		out:  "␉␉␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t＃",
	}, { // 2923
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\tu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾␉＃",
		out:  "\tu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾␉＃",
	}, { // 2924
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␉u␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾␉＃",
		out:  "␉u␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾␉＃",
	}, { // 2925
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\tu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t␉",
		out:  "\tu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t‛␉",
	}, { // 2926
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␉u␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t␉",
		out:  "␉u␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t‛␉",
	}, { // 2927
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "c\t␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t＃",
		out:  "c\t␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t＃",
	}, { // 2928
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "c␉␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t＃",
		out:  "c␉␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t＃",
	}, { // 2929
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "c\t␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾␉＃",
		out:  "c\t␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾␉＃",
	}, { // 2930
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "c␉␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾␉＃",
		out:  "c␉␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾␉＃",
	}, { // 2931
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "c\t␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t␉",
		out:  "c\t␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t‛␉",
	}, { // 2932
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "c␉␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t␉",
		out:  "c␉␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t‛␉",
	}, { // 2933
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t＃",
		out:  "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t＃",
	}, { // 2934
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾␉＃",
		out:  "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾␉＃",
	}, { // 2935
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t␉",
		out:  "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t‛␉",
	}, { // 2936
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾␉␉",
		out:  "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾␉‛␉",
	}, { // 2937
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t\t",
		out:  "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t␉",
	}, { // 2938
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t␉",
		out:  "cu␂\x1d␆␋␑αφ\a\tδ\x02ψ:τTｉＲ␉ｖ(0ｒε0\x1b＾\t‛␉",
	}, { // 2939
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ＼",
		out:  "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ＼",
	}, { // 2940
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\n␊φ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ＼",
		out:  "\n␊φ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ＼",
	}, { // 2941
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␊␊φ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ＼",
		out:  "␊␊φ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ＼",
	}, { // 2942
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\nρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒␊＼",
		out:  "\nρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒␊＼",
	}, { // 2943
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␊ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒␊＼",
		out:  "␊ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒␊＼",
	}, { // 2944
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\nρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ␊",
		out:  "\nρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ‛␊",
	}, { // 2945
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␊ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ␊",
		out:  "␊ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ‛␊",
	}, { // 2946
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "２\nφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ＼",
		out:  "２\nφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ＼",
	}, { // 2947
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "２␊φ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ＼",
		out:  "２␊φ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ＼",
	}, { // 2948
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "２\nφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒␊＼",
		out:  "２\nφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒␊＼",
	}, { // 2949
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "２␊φ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒␊＼",
		out:  "２␊φ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒␊＼",
	}, { // 2950
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "２\nφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ␊",
		out:  "２\nφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ‛␊",
	}, { // 2951
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "２␊φ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ␊",
		out:  "２␊φ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ‛␊",
	}, { // 2952
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒\n＼",
		out:  "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒\n＼",
	}, { // 2953
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒␊＼",
		out:  "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒␊＼",
	}, { // 2954
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒\n␊",
		out:  "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒\n‛␊",
	}, { // 2955
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒␊␊",
		out:  "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒␊‛␊",
	}, { // 2956
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ\n",
		out:  "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ␊",
	}, { // 2957
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ␊",
		out:  "２ρφ␇4μj\bψ／\nｗ\rκ␔\uff00␏\t\x1bP(\x02o␛ｈ\x18!␒ξ‛␊",
	}, { // 2958
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３η",
		out:  "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３η",
	}, { // 2959
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\v␋|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３η",
		out:  "\v␋|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３η",
	}, { // 2960
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␋␋|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３η",
		out:  "␋␋|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３η",
	}, { // 2961
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\vＣ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06␋η",
		out:  "\vＣ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06␋η",
	}, { // 2962
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␋Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06␋η",
		out:  "␋Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06␋η",
	}, { // 2963
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\vＣ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３␋",
		out:  "\vＣ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３‛␋",
	}, { // 2964
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␋Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３␋",
		out:  "␋Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３‛␋",
	}, { // 2965
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "５\v|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３η",
		out:  "５\v|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３η",
	}, { // 2966
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "５␋|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３η",
		out:  "５␋|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３η",
	}, { // 2967
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "５\v|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06␋η",
		out:  "５\v|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06␋η",
	}, { // 2968
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "５␋|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06␋η",
		out:  "５␋|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06␋η",
	}, { // 2969
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "５\v|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３␋",
		out:  "５\v|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３‛␋",
	}, { // 2970
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "５␋|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３␋",
		out:  "５␋|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３‛␋",
	}, { // 2971
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06\vη",
		out:  "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06\vη",
	}, { // 2972
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06␋η",
		out:  "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06␋η",
	}, { // 2973
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06\v␋",
		out:  "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06\v‛␋",
	}, { // 2974
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06␋␋",
		out:  "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06␋‛␋",
	}, { // 2975
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３\v",
		out:  "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３␋",
	}, { // 2976
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３␋",
		out:  "５Ｃ|ςδ\\␗␛␆/\v\x15ο␑Ｏ\x0e␍r/5␊＝sε［δD\x06３‛␋",
	}, { // 2977
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␏Ｂ（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋ε",
		out:  "␏Ｂ（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋ε",
	}, { // 2978
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\r␍（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋ε",
		out:  "\r␍（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋ε",
	}, { // 2979
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␍␍（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋ε",
		out:  "␍␍（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋ε",
	}, { // 2980
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\rＢ（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␍ε",
		out:  "\rＢ（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␍ε",
	}, { // 2981
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␍Ｂ（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␍ε",
		out:  "␍Ｂ（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␍ε",
	}, { // 2982
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\rＢ（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋␍",
		out:  "\rＢ（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋‛␍",
	}, { // 2983
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␍Ｂ（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋␍",
		out:  "␍Ｂ（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋‛␍",
	}, { // 2984
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␏\r（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋ε",
		out:  "␏\r（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋ε",
	}, { // 2985
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␏␍（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋ε",
		out:  "␏␍（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋ε",
	}, { // 2986
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␏\r（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␍ε",
		out:  "␏\r（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␍ε",
	}, { // 2987
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␏␍（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␍ε",
		out:  "␏␍（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␍ε",
	}, { // 2988
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␏\r（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋␍",
		out:  "␏\r（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋‛␍",
	}, { // 2989
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␏␍（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋␍",
		out:  "␏␍（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋‛␍",
	}, { // 2990
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␏Ｂ（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT\rε",
		out:  "␏Ｂ（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT\rε",
	}, { // 2991
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␏Ｂ（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␍ε",
		out:  "␏Ｂ（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␍ε",
	}, { // 2992
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␏Ｂ（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT\r␍",
		out:  "␏Ｂ（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT\r‛␍",
	}, { // 2993
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␏Ｂ（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␍␍",
		out:  "␏Ｂ（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␍‛␍",
	}, { // 2994
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␏Ｂ（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋\r",
		out:  "␏Ｂ（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋␍",
	}, { // 2995
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␏Ｂ（ψ％␏\fc'c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋␍",
		out:  "␏Ｂ（ψ％␏\fc＇c\rh␍πｚ\a\x17cη␚\\＾\f␋αγｈT␋‛␍",
	}, { // 2996
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␁",
		out:  "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␁",
	}, { // 2997
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\t␉%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␁",
		out:  "\t␉%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␁",
	}, { // 2998
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␉␉%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␁",
		out:  "␉␉%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␁",
	}, { // 2999
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\t％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␉␁",
		out:  "\t％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␉␁",
	}, { // 3000
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␉％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␉␁",
		out:  "␉％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␉␁",
	}, { // 3001
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\t％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␉",
		out:  "\t％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔‛␉",
	}, { // 3002
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␉％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␉",
		out:  "␉％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔‛␉",
	}, { // 3003
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "+\t%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␁",
		out:  "+\t%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␁",
	}, { // 3004
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "+␉%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␁",
		out:  "+␉%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␁",
	}, { // 3005
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "+\t%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␉␁",
		out:  "+\t%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␉␁",
	}, { // 3006
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "+␉%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␉␁",
		out:  "+␉%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␉␁",
	}, { // 3007
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "+\t%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␉",
		out:  "+\t%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔‛␉",
	}, { // 3008
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "+␉%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␉",
		out:  "+␉%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔‛␉",
	}, { // 3009
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz\t␁",
		out:  "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz\t␁",
	}, { // 3010
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␉␁",
		out:  "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␉␁",
	}, { // 3011
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz\t␉",
		out:  "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz\t‛␉",
	}, { // 3012
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␉␉",
		out:  "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␉‛␉",
	}, { // 3013
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔\t",
		out:  "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␉",
	}, { // 3014
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔␉",
		out:  "+％%Ｎθd'σ｜ｓ\tζ\x1f\x1c4\uff00\x16␁zυw＿βζ␈␍Ｊz␔‛␉",
	}, { // 3015
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]\t",
		out:  "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]␉",
	}, { // 3016
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\n␊}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]\t",
		out:  "\n␊}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]␉",
	}, { // 3017
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␊␊}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]\t",
		out:  "␊␊}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]␉",
	}, { // 3018
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\nμ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|␊\t",
		out:  "\nμ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|␊␉",
	}, { // 3019
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␊μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|␊\t",
		out:  "␊μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|␊␉",
	}, { // 3020
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\nμ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]␊",
		out:  "\nμ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]‛␊",
	}, { // 3021
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␊μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]␊",
		out:  "␊μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]‛␊",
	}, { // 3022
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "~\n}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]\t",
		out:  "~\n}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]␉",
	}, { // 3023
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "~␊}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]\t",
		out:  "~␊}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]␉",
	}, { // 3024
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "~\n}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|␊\t",
		out:  "~\n}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|␊␉",
	}, { // 3025
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "~␊}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|␊\t",
		out:  "~␊}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|␊␉",
	}, { // 3026
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "~\n}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]␊",
		out:  "~\n}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]‛␊",
	}, { // 3027
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "~␊}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]␊",
		out:  "~␊}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]‛␊",
	}, { // 3028
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|\n\t",
		out:  "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|\n␉",
	}, { // 3029
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|␊\t",
		out:  "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|␊␉",
	}, { // 3030
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|\n␊",
		out:  "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|\n‛␊",
	}, { // 3031
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|␊␊",
		out:  "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|␊‛␊",
	}, { // 3032
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]\n",
		out:  "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]␊",
	}, { // 3033
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]␊",
		out:  "~μ}u␍ｍλ␓＞／\n８\n>\x19␇\bＬ␘６IＱμσσδ｛|]‛␊",
	}, { // 3034
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O␊",
		out:  "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O‛␊",
	}, { // 3035
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\v␋\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O␊",
		out:  "\v␋\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O‛␊",
	}, { // 3036
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␋␋\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O␊",
		out:  "␋␋\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O‛␊",
	}, { // 3037
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\v\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉␋␊",
		out:  "\v\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉␋‛␊",
	}, { // 3038
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␋\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉␋␊",
		out:  "␋\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉␋‛␊",
	}, { // 3039
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\v\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O␋",
		out:  "\v\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O‛␋",
	}, { // 3040
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␋\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O␋",
		out:  "␋\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O‛␋",
	}, { // 3041
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "k\v\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O␊",
		out:  "k\v\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O‛␊",
	}, { // 3042
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "k␋\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O␊",
		out:  "k␋\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O‛␊",
	}, { // 3043
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "k\v\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉␋␊",
		out:  "k\v\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉␋‛␊",
	}, { // 3044
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "k␋\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉␋␊",
		out:  "k␋\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉␋‛␊",
	}, { // 3045
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "k\v\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O␋",
		out:  "k\v\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O‛␋",
	}, { // 3046
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "k␋\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O␋",
		out:  "k␋\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O‛␋",
	}, { // 3047
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉\v␊",
		out:  "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉\v‛␊",
	}, { // 3048
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉␋␊",
		out:  "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉␋‛␊",
	}, { // 3049
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉\v␋",
		out:  "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉\v‛␋",
	}, { // 3050
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉␋␋",
		out:  "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉␋‛␋",
	}, { // 3051
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O\v",
		out:  "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O␋",
	}, { // 3052
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O␋",
		out:  "k\n\nＩd\vομμ␂\v\x1fｒ␝r␑ｃＯλ\x05υ／＼ψ\x14S3␉O‛␋",
	}, { // 3053
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε；）",
		out:  "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε；）",
	}, { // 3054
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\r␍\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε；）",
		out:  "\r␍\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε；）",
	}, { // 3055
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␍␍\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε；）",
		out:  "␍␍\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε；）",
	}, { // 3056
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\rC\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε␍）",
		out:  "\rC\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε␍）",
	}, { // 3057
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␍C\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε␍）",
		out:  "␍C\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε␍）",
	}, { // 3058
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\rC\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε；␍",
		out:  "\rC\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε；‛␍",
	}, { // 3059
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␍C\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε；␍",
		out:  "␍C\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε；‛␍",
	}, { // 3060
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "q\r\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε；）",
		out:  "q\r\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε；）",
	}, { // 3061
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "q␍\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε；）",
		out:  "q␍\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε；）",
	}, { // 3062
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "q\r\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε␍）",
		out:  "q\r\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε␍）",
	}, { // 3063
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "q␍\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε␍）",
		out:  "q␍\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε␍）",
	}, { // 3064
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "q\r\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε；␍",
		out:  "q\r\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε；‛␍",
	}, { // 3065
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "q␍\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε；␍",
		out:  "q␍\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε；‛␍",
	}, { // 3066
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε\r）",
		out:  "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε\r）",
	}, { // 3067
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε␍）",
		out:  "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε␍）",
	}, { // 3068
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε\r␍",
		out:  "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε\r‛␍",
	}, { // 3069
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε␍␍",
		out:  "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε␍‛␍",
	}, { // 3070
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε；\r",
		out:  "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε；␍",
	}, { // 3071
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e`σｆG␝．:φ\x1e\x19␋ε；␍",
		out:  "qC\\？｝\ve＜fＱ\r：＇ζρ\x1e｀σｆG␝．:φ\x1e\x19␋ε；‛␍",
	}, { // 3072
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗υF",
		out:  "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗υF",
	}, { // 3073
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\t␉l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗υF",
		out:  "\t␉l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗υF",
	}, { // 3074
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␉␉l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗υF",
		out:  "␉␉l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗υF",
	}, { // 3075
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\t␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗␉F",
		out:  "\t␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗␉F",
	}, { // 3076
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␉␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗␉F",
		out:  "␉␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗␉F",
	}, { // 3077
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\t␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗υ␉",
		out:  "\t␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗υ‛␉",
	}, { // 3078
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␉␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗υ␉",
		out:  "␉␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗υ‛␉",
	}, { // 3079
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\"\tl/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗υF",
		out:  "\"\tl/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗υF",
	}, { // 3080
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\"␉l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗υF",
		out:  "\"␉l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗υF",
	}, { // 3081
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\"\tl/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗␉F",
		out:  "\"\tl/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗␉F",
	}, { // 3082
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\"␉l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗␉F",
		out:  "\"␉l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗␉F",
	}, { // 3083
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\"\tl/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗υ␉",
		out:  "\"\tl/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗υ‛␉",
	}, { // 3084
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\"␉l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗υ␉",
		out:  "\"␉l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗υ‛␉",
	}, { // 3085
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗\tF",
		out:  "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗\tF",
	}, { // 3086
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗␉F",
		out:  "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗␉F",
	}, { // 3087
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗\t␉",
		out:  "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗\t‛␉",
	}, { // 3088
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗␉␉",
		out:  "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗␉‛␉",
	}, { // 3089
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗υ\t",
		out:  "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗υ␉",
	}, { // 3090
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a\x00，$ｗ␗υ␉",
		out:  "\"␌l/Ｍφ／␄＿β\t␅V\x1d$?*μ５␑ψω\a␀，$ｗ␗υ‛␉",
	}, { // 3091
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␂",
		out:  "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␂",
	}, { // 3092
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\n␊Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␂",
		out:  "\n␊Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␂",
	}, { // 3093
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␊␊Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␂",
		out:  "␊␊Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␂",
	}, { // 3094
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\n\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b␊␂",
		out:  "\n\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b␊␂",
	}, { // 3095
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␊\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b␊␂",
		out:  "␊\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b␊␂",
	}, { // 3096
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\n\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␊",
		out:  "\n\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC‛␊",
	}, { // 3097
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␊\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␊",
		out:  "␊\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC‛␊",
	}, { // 3098
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x03\nＴλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␂",
		out:  "\x03\nＴλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␂",
	}, { // 3099
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x03␊Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␂",
		out:  "\x03␊Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␂",
	}, { // 3100
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x03\nＴλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b␊␂",
		out:  "\x03\nＴλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b␊␂",
	}, { // 3101
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x03␊Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b␊␂",
		out:  "\x03␊Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b␊␂",
	}, { // 3102
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x03\nＴλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␊",
		out:  "\x03\nＴλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC‛␊",
	}, { // 3103
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x03␊Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␊",
		out:  "\x03␊Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC‛␊",
	}, { // 3104
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b\n␂",
		out:  "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b\n␂",
	}, { // 3105
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b␊␂",
		out:  "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b␊␂",
	}, { // 3106
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b\n␊",
		out:  "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b\n‛␊",
	}, { // 3107
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b␊␊",
		out:  "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\b␊‛␊",
	}, { // 3108
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC\n",
		out:  "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␊",
	}, { // 3109
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC␊",
		out:  "\x03\x04Ｔλｏτ：υ\x06φ\nE}␈Ｍ$Ｙ␗\r［_␑ｅη`\\｜\bC‛␊",
	}, { // 3110
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␗７",
		out:  "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␗７",
	}, { // 3111
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\v␋ｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␗７",
		out:  "\v␋ｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␗７",
	}, { // 3112
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␋␋ｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␗７",
		out:  "␋␋ｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␗７",
	}, { // 3113
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\vＯｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␋７",
		out:  "\vＯｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␋７",
	}, { // 3114
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␋Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␋７",
		out:  "␋Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␋７",
	}, { // 3115
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\vＯｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␗␋",
		out:  "\vＯｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␗‛␋",
	}, { // 3116
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␋Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␗␋",
		out:  "␋Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␗‛␋",
	}, { // 3117
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␈\vｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␗７",
		out:  "␈\vｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␗７",
	}, { // 3118
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␈␋ｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␗７",
		out:  "␈␋ｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␗７",
	}, { // 3119
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␈\vｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␋７",
		out:  "␈\vｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␋７",
	}, { // 3120
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␈␋ｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␋７",
		out:  "␈␋ｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␋７",
	}, { // 3121
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␈\vｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␗␋",
		out:  "␈\vｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␗‛␋",
	}, { // 3122
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␈␋ｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␗␋",
		out:  "␈␋ｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␗‛␋",
	}, { // 3123
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>\v７",
		out:  "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞\v７",
	}, { // 3124
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␋７",
		out:  "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␋７",
	}, { // 3125
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>\v␋",
		out:  "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞\v‛␋",
	}, { // 3126
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␋␋",
		out:  "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␋‛␋",
	}, { // 3127
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␗\v",
		out:  "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␗␋",
	}, { // 3128
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;＞χ>␗␋",
		out:  "␈Ｏｋ｀7χ␘jD\x05\vυzπt\r\x0fο＊＄\aＩ/Ｉ;‛＞χ＞␗‛␋",
	}, { // 3129
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02[",
		out:  "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02[",
	}, { // 3130
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\r␍Ｌ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02[",
		out:  "\r␍Ｌ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02[",
	}, { // 3131
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␍␍Ｌ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02[",
		out:  "␍␍Ｌ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02[",
	}, { // 3132
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\rωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊␍[",
		out:  "\rωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊␍[",
	}, { // 3133
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␍ωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊␍[",
		out:  "␍ωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊␍[",
	}, { // 3134
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\rωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02␍",
		out:  "\rωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02‛␍",
	}, { // 3135
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␍ωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02␍",
		out:  "␍ωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02‛␍",
	}, { // 3136
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "m\rＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02[",
		out:  "m\rＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02[",
	}, { // 3137
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "m␍Ｌ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02[",
		out:  "m␍Ｌ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02[",
	}, { // 3138
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "m\rＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊␍[",
		out:  "m\rＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊␍[",
	}, { // 3139
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "m␍Ｌ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊␍[",
		out:  "m␍Ｌ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊␍[",
	}, { // 3140
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "m\rＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02␍",
		out:  "m\rＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02‛␍",
	}, { // 3141
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "m␍Ｌ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02␍",
		out:  "m␍Ｌ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02‛␍",
	}, { // 3142
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\r[",
		out:  "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\r[",
	}, { // 3143
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊␍[",
		out:  "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊␍[",
	}, { // 3144
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\r␍",
		out:  "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\r‛␍",
	}, { // 3145
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊␍␍",
		out:  "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊␍‛␍",
	}, { // 3146
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02\r",
		out:  "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02␍",
	}, { // 3147
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02␍",
		out:  "mωＬ\t＾␝｛？:␈\r␎ηD␎%λ*２3ε␡δ\uff00\x18k\n＊\x02‛␍",
	}, { // 3148
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␖",
		out:  "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␖",
	}, { // 3149
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t␉χYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␖",
		out:  "\t␉χYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␖",
	}, { // 3150
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␉␉χYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␖",
		out:  "␉␉χYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␖",
	}, { // 3151
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ␉␖",
		out:  "\t\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ␉␖",
	}, { // 3152
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␉\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ␉␖",
		out:  "␉\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ␉␖",
	}, { // 3153
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␉",
		out:  "\t\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13‛␉",
	}, { // 3154
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␉\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␉",
		out:  "␉\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13‛␉",
	}, { // 3155
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚\tχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␖",
		out:  "␚\tχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␖",
	}, { // 3156
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚␉χYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␖",
		out:  "␚␉χYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␖",
	}, { // 3157
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚\tχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ␉␖",
		out:  "␚\tχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ␉␖",
	}, { // 3158
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚␉χYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ␉␖",
		out:  "␚␉χYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ␉␖",
	}, { // 3159
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚\tχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␉",
		out:  "␚\tχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13‛␉",
	}, { // 3160
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚␉χYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␉",
		out:  "␚␉χYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13‛␉",
	}, { // 3161
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\t␖",
		out:  "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\t␖",
	}, { // 3162
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ␉␖",
		out:  "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ␉␖",
	}, { // 3163
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\t␉",
		out:  "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\t‛␉",
	}, { // 3164
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ␉␉",
		out:  "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ␉‛␉",
	}, { // 3165
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13\t",
		out:  "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␉",
	}, { // 3166
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13␉",
		out:  "␚\fχYL␔\f\x14%>\tγCＤｋ＊γρsζ１␈ςｏ␁\x03kＤ\x13‛␉",
	}, { // 3167
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ\x1e",
		out:  "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ\x1e",
	}, { // 3168
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n␊'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ\x1e",
		out:  "\n␊'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ\x1e",
	}, { // 3169
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␊␊'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ\x1e",
		out:  "␊␊'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ\x1e",
	}, { // 3170
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N␊\x1e",
		out:  "\n\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N␊\x1e",
	}, { // 3171
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␊\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N␊\x1e",
		out:  "␊\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N␊\x1e",
	}, { // 3172
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ␊",
		out:  "\n\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ‛␊",
	}, { // 3173
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␊\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ␊",
		out:  "␊\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ‛␊",
	}, { // 3174
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "2\n'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ\x1e",
		out:  "2\n'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ\x1e",
	}, { // 3175
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "2␊'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ\x1e",
		out:  "2␊'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ\x1e",
	}, { // 3176
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "2\n'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N␊\x1e",
		out:  "2\n'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N␊\x1e",
	}, { // 3177
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "2␊'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N␊\x1e",
		out:  "2␊'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N␊\x1e",
	}, { // 3178
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "2\n'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ␊",
		out:  "2\n'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ‛␊",
	}, { // 3179
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "2␊'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ␊",
		out:  "2␊'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ‛␊",
	}, { // 3180
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N\n\x1e",
		out:  "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N\n\x1e",
	}, { // 3181
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N␊\x1e",
		out:  "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N␊\x1e",
	}, { // 3182
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N\n␊",
		out:  "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N\n‛␊",
	}, { // 3183
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N␊␊",
		out:  "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝N␊‛␊",
	}, { // 3184
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ\n",
		out:  "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ␊",
	}, { // 3185
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ␊",
		out:  "2\x1c'｀ςTaφn\x1a\n？／ενＩ＂％|ψ＊␡\n\nεｇ␝Nｆ‛␊",
	}, { // 3186
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rxＫ",
		out:  "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rxＫ",
	}, { // 3187
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\v␋ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rxＫ",
		out:  "\v␋ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rxＫ",
	}, { // 3188
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␋␋ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rxＫ",
		out:  "␋␋ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rxＫ",
	}, { // 3189
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\v␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r␋Ｋ",
		out:  "\v␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r␋Ｋ",
	}, { // 3190
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␋␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r␋Ｋ",
		out:  "␋␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r␋Ｋ",
	}, { // 3191
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\v␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rx␋",
		out:  "\v␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rx‛␋",
	}, { // 3192
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␋␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rx␋",
		out:  "␋␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rx‛␋",
	}, { // 3193
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ａ\vＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rxＫ",
		out:  "ａ\vＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rxＫ",
	}, { // 3194
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ａ␋ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rxＫ",
		out:  "ａ␋ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rxＫ",
	}, { // 3195
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ａ\vＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r␋Ｋ",
		out:  "ａ\vＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r␋Ｋ",
	}, { // 3196
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ａ␋ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r␋Ｋ",
		out:  "ａ␋ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r␋Ｋ",
	}, { // 3197
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ａ\vＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rx␋",
		out:  "ａ\vＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rx‛␋",
	}, { // 3198
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ａ␋ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rx␋",
		out:  "ａ␋ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rx‛␋",
	}, { // 3199
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r\vＫ",
		out:  "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r\vＫ",
	}, { // 3200
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r␋Ｋ",
		out:  "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r␋Ｋ",
	}, { // 3201
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r\v␋",
		out:  "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r\v‛␋",
	}, { // 3202
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r␋␋",
		out:  "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\r␋‛␋",
	}, { // 3203
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rx\v",
		out:  "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rx␋",
	}, { // 3204
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rx␋",
		out:  "ａ␑ＯθI\v␗\x1a␆７\v\rφＷ␟␓␓,2ιεｌν\x1dpψ\x01\rx‛␋",
	}, { // 3205
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκι",
		out:  "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκι",
	}, { // 3206
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\r␍ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκι",
		out:  "\r␍ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκι",
	}, { // 3207
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␍␍ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκι",
		out:  "␍␍ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκι",
	}, { // 3208
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\r(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx␍ι",
		out:  "\r(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx␍ι",
	}, { // 3209
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␍(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx␍ι",
		out:  "␍(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx␍ι",
	}, { // 3210
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\r(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκ␍",
		out:  "\r(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκ‛␍",
	}, { // 3211
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␍(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκ␍",
		out:  "␍(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκ‛␍",
	}, { // 3212
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｊ\rｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκι",
		out:  "Ｊ\rｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκι",
	}, { // 3213
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｊ␍ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκι",
		out:  "Ｊ␍ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκι",
	}, { // 3214
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｊ\rｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx␍ι",
		out:  "Ｊ\rｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx␍ι",
	}, { // 3215
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｊ␍ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx␍ι",
		out:  "Ｊ␍ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx␍ι",
	}, { // 3216
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｊ\rｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκ␍",
		out:  "Ｊ\rｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκ‛␍",
	}, { // 3217
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｊ␍ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκ␍",
		out:  "Ｊ␍ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκ‛␍",
	}, { // 3218
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx\rι",
		out:  "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx\rι",
	}, { // 3219
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx␍ι",
		out:  "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx␍ι",
	}, { // 3220
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx\r␍",
		out:  "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx\r‛␍",
	}, { // 3221
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx␍␍",
		out:  "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλx␍‛␍",
	}, { // 3222
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκ\r",
		out:  "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκ␍",
	}, { // 3223
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκ␍",
		out:  "Ｊ(ｚ\tａW\x11Ｂ␈\x1e\rδ␏␟Ｚ５␍'␑eτ\x1fπ#\v\x1eλxκ‛␍",
	}, { // 3224
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0χ",
		out:  "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0χ",
	}, { // 3225
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\t␉ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0χ",
		out:  "\t␉ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0χ",
	}, { // 3226
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉␉ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0χ",
		out:  "␉␉ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0χ",
	}, { // 3227
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\t|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾␉χ",
		out:  "\t|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾␉χ",
	}, { // 3228
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾␉χ",
		out:  "␉|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾␉χ",
	}, { // 3229
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\t|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0␉",
		out:  "\t|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0‛␉",
	}, { // 3230
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0␉",
		out:  "␉|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0‛␉",
	}, { // 3231
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "δ\tψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0χ",
		out:  "δ\tψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0χ",
	}, { // 3232
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "δ␉ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0χ",
		out:  "δ␉ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0χ",
	}, { // 3233
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "δ\tψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾␉χ",
		out:  "δ\tψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾␉χ",
	}, { // 3234
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "δ␉ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾␉χ",
		out:  "δ␉ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾␉χ",
	}, { // 3235
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "δ\tψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0␉",
		out:  "δ\tψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0‛␉",
	}, { // 3236
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "δ␉ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0␉",
		out:  "δ␉ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0‛␉",
	}, { // 3237
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾\tχ",
		out:  "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾\tχ",
	}, { // 3238
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾␉χ",
		out:  "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾␉χ",
	}, { // 3239
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾\t␉",
		out:  "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾\t‛␉",
	}, { // 3240
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾␉␉",
		out:  "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾␉‛␉",
	}, { // 3241
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0\t",
		out:  "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0␉",
	}, { // 3242
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0␉",
		out:  "δ|ψ＄␟６ωｌｏＹ\tK␏/ｇ`3>ε␁␊\x10␏fAη\x19＾0‛␉",
	}, { // 3243
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfvα",
		out:  "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfvα",
	}, { // 3244
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\n␊\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfvα",
		out:  "\n␊\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfvα",
	}, { // 3245
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␊␊\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfvα",
		out:  "␊␊\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfvα",
	}, { // 3246
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\nN\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf␊α",
		out:  "\nN\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf␊α",
	}, { // 3247
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␊N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf␊α",
		out:  "␊N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf␊α",
	}, { // 3248
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\nN\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfv␊",
		out:  "\nN\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfv‛␊",
	}, { // 3249
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␊N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfv␊",
		out:  "␊N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfv‛␊",
	}, { // 3250
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␈\n\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfvα",
		out:  "␈\n\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfvα",
	}, { // 3251
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␈␊\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfvα",
		out:  "␈␊\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfvα",
	}, { // 3252
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␈\n\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf␊α",
		out:  "␈\n\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf␊α",
	}, { // 3253
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␈␊\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf␊α",
		out:  "␈␊\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf␊α",
	}, { // 3254
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␈\n\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfv␊",
		out:  "␈\n\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfv‛␊",
	}, { // 3255
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␈␊\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfv␊",
		out:  "␈␊\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfv‛␊",
	}, { // 3256
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf\nα",
		out:  "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf\nα",
	}, { // 3257
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf␊α",
		out:  "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf␊α",
	}, { // 3258
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf\n␊",
		out:  "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf\n‛␊",
	}, { // 3259
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf␊␊",
		out:  "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌf␊‛␊",
	}, { // 3260
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfv\n",
		out:  "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfv␊",
	}, { // 3261
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfv␊",
		out:  "␈N\nλＢ␈␐MＥ␊\n\x04＊（\x11\v@χ\x04νｋ!χ\fν｀Ｌfv‛␊",
	}, { // 3262
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␚[",
		out:  "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␚[",
	}, { // 3263
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\v␋－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␚[",
		out:  "\v␋－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␚[",
	}, { // 3264
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␋␋－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␚[",
		out:  "␋␋－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␚[",
	}, { // 3265
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\v\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␋[",
		out:  "\v\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␋[",
	}, { // 3266
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␋\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␋[",
		out:  "␋\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␋[",
	}, { // 3267
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\v\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␚␋",
		out:  "\v\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␚‛␋",
	}, { // 3268
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␋\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␚␋",
		out:  "␋\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␚‛␋",
	}, { // 3269
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "μ\v－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␚[",
		out:  "μ\v－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␚[",
	}, { // 3270
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "μ␋－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␚[",
		out:  "μ␋－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␚[",
	}, { // 3271
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "μ\v－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␋[",
		out:  "μ\v－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␋[",
	}, { // 3272
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "μ␋－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␋[",
		out:  "μ␋－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␋[",
	}, { // 3273
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "μ\v－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␚␋",
		out:  "μ\v－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␚‛␋",
	}, { // 3274
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "μ␋－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␚␋",
		out:  "μ␋－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␚‛␋",
	}, { // 3275
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω\v[",
		out:  "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω\v[",
	}, { // 3276
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␋[",
		out:  "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␋[",
	}, { // 3277
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω\v␋",
		out:  "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω\v‛␋",
	}, { // 3278
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␋␋",
		out:  "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␋‛␋",
	}, { // 3279
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␚\v",
		out:  "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␚␋",
	}, { // 3280
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝\"ω｝␖ω␚␋",
		out:  "μ\n－＼ο␂δg\x0fｎ\vＯ０␑*p\x03*Ｉ:|`␝＂ω｝␖ω␚‛␋",
	}, { // 3281
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU\x06␒",
		out:  "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU\x06␒",
	}, { // 3282
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\r␍＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU\x06␒",
		out:  "\r␍＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU\x06␒",
	}, { // 3283
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␍␍＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU\x06␒",
		out:  "␍␍＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU\x06␒",
	}, { // 3284
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\rt＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU␍␒",
		out:  "\rt＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU␍␒",
	}, { // 3285
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␍t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU␍␒",
		out:  "␍t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU␍␒",
	}, { // 3286
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\rt＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU\x06␍",
		out:  "\rt＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU\x06‛␍",
	}, { // 3287
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␍t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU\x06␍",
		out:  "␍t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU\x06‛␍",
	}, { // 3288
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\x10\r＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU\x06␒",
		out:  "\x10\r＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU\x06␒",
	}, { // 3289
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\x10␍＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU\x06␒",
		out:  "\x10␍＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU\x06␒",
	}, { // 3290
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\x10\r＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU␍␒",
		out:  "\x10\r＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU␍␒",
	}, { // 3291
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\x10␍＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU␍␒",
		out:  "\x10␍＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU␍␒",
	}, { // 3292
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\x10\r＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU\x06␍",
		out:  "\x10\r＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU\x06‛␍",
	}, { // 3293
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\x10␍＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU\x06␍",
		out:  "\x10␍＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU\x06‛␍",
	}, { // 3294
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU\r␒",
		out:  "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU\r␒",
	}, { // 3295
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU␍␒",
		out:  "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU␍␒",
	}, { // 3296
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU\r␍",
		out:  "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU\r‛␍",
	}, { // 3297
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU␍␍",
		out:  "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU␍‛␍",
	}, { // 3298
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU\x06\r",
		out:  "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU\x06␍",
	}, { // 3299
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ␀\x18：ＲφU\x06␍",
		out:  "\x10t＞\\：ｚN\v？ｘ\rβwe␉＄?δｎγωσ‛␀\x18：ＲφU\x06‛␍",
	}, { // 3300
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!\x12",
		out:  "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!\x12",
	}, { // 3301
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\t␉{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!\x12",
		out:  "\t␉{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!\x12",
	}, { // 3302
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉␉{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!\x12",
		out:  "␉␉{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!\x12",
	}, { // 3303
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\t\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞␉\x12",
		out:  "\t\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞␉\x12",
	}, { // 3304
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞␉\x12",
		out:  "␉\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞␉\x12",
	}, { // 3305
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\t\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!␉",
		out:  "\t\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!‛␉",
	}, { // 3306
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!␉",
		out:  "␉\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!‛␉",
	}, { // 3307
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!\x12",
		out:  "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!\x12",
	}, { // 3308
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ｚ␉{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!\x12",
		out:  "ｚ␉{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!\x12",
	}, { // 3309
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞␉\x12",
		out:  "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞␉\x12",
	}, { // 3310
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ｚ␉{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞␉\x12",
		out:  "ｚ␉{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞␉\x12",
	}, { // 3311
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!␉",
		out:  "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!‛␉",
	}, { // 3312
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ｚ␉{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!␉",
		out:  "ｚ␉{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!‛␉",
	}, { // 3313
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞\t\x12",
		out:  "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞\t\x12",
	}, { // 3314
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞␉\x12",
		out:  "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞␉\x12",
	}, { // 3315
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞\t␉",
		out:  "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞\t‛␉",
	}, { // 3316
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞␉␉",
		out:  "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞␉‛␉",
	}, { // 3317
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!\t",
		out:  "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!␉",
	}, { // 3318
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!␉",
		out:  "ｚ\t{＋dｏ＄νψy\t＄ξ\x11\x0eＤ?\x1f？θl？υς＜8␃␞!‛␉",
	}, { // 3319
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~γ",
		out:  "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~γ",
	}, { // 3320
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\n␊＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~γ",
		out:  "\n␊＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~γ",
	}, { // 3321
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␊␊＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~γ",
		out:  "␊␊＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~γ",
	}, { // 3322
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\nw＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ␊γ",
		out:  "\nw＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ␊γ",
	}, { // 3323
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␊w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ␊γ",
		out:  "␊w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ␊γ",
	}, { // 3324
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\nw＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~␊",
		out:  "\nw＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~‛␊",
	}, { // 3325
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␊w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~␊",
		out:  "␊w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~‛␊",
	}, { // 3326
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "<\n＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~γ",
		out:  "<\n＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~γ",
	}, { // 3327
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "<␊＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~γ",
		out:  "<␊＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~γ",
	}, { // 3328
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "<\n＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ␊γ",
		out:  "<\n＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ␊γ",
	}, { // 3329
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "<␊＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ␊γ",
		out:  "<␊＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ␊γ",
	}, { // 3330
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "<\n＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~␊",
		out:  "<\n＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~‛␊",
	}, { // 3331
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "<␊＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~␊",
		out:  "<␊＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~‛␊",
	}, { // 3332
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ\nγ",
		out:  "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ\nγ",
	}, { // 3333
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ␊γ",
		out:  "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ␊γ",
	}, { // 3334
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ\n␊",
		out:  "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ\n‛␊",
	}, { // 3335
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ␊␊",
		out:  "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ␊‛␊",
	}, { // 3336
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~\n",
		out:  "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~␊",
	}, { // 3337
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~␊",
		out:  "<w＃＼\vＫ␝*３＄\nδ｛β-／␄ｎττ\x11c\x12\x1ew／θｙ~‛␊",
	}, { // 3338
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％ρς",
		out:  "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％ρς",
	}, { // 3339
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\v␋＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％ρς",
		out:  "\v␋＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％ρς",
	}, { // 3340
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␋␋＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％ρς",
		out:  "␋␋＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％ρς",
	}, { // 3341
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\vＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％␋ς",
		out:  "\vＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％␋ς",
	}, { // 3342
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␋Ｒ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％␋ς",
		out:  "␋Ｒ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％␋ς",
	}, { // 3343
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\vＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％ρ␋",
		out:  "\vＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％ρ‛␋",
	}, { // 3344
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␋Ｒ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％ρ␋",
		out:  "␋Ｒ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％ρ‛␋",
	}, { // 3345
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ο\v＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％ρς",
		out:  "ο\v＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％ρς",
	}, { // 3346
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ο␋＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％ρς",
		out:  "ο␋＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％ρς",
	}, { // 3347
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ο\v＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％␋ς",
		out:  "ο\v＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％␋ς",
	}, { // 3348
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ο␋＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％␋ς",
		out:  "ο␋＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％␋ς",
	}, { // 3349
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ο\v＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％ρ␋",
		out:  "ο\v＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％ρ‛␋",
	}, { // 3350
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ο␋＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％ρ␋",
		out:  "ο␋＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％ρ‛␋",
	}, { // 3351
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％\vς",
		out:  "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％\vς",
	}, { // 3352
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％␋ς",
		out:  "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％␋ς",
	}, { // 3353
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％\v␋",
		out:  "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％\v‛␋",
	}, { // 3354
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％␋␋",
		out:  "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％␋‛␋",
	}, { // 3355
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％ρ\v",
		out:  "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％ρ␋",
	}, { // 3356
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ:\x0e␑␁ａｑηL％ρ␋",
		out:  "οＲ＄A|x\n\\６μ\v＾␍κｑ\n=\x1cZ：\x0e␑␁ａｑηL％ρ‛␋",
	}, { // 3357
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05Q",
		out:  "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05Q",
	}, { // 3358
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\r␍／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05Q",
		out:  "\r␍／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05Q",
	}, { // 3359
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␍␍／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05Q",
		out:  "␍␍／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05Q",
	}, { // 3360
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\rτ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b␍Q",
		out:  "\rτ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b␍Q",
	}, { // 3361
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␍τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b␍Q",
		out:  "␍τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b␍Q",
	}, { // 3362
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\rτ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05␍",
		out:  "\rτ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05‛␍",
	}, { // 3363
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␍τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05␍",
		out:  "␍τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05‛␍",
	}, { // 3364
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉\r／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05Q",
		out:  "␉\r／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05Q",
	}, { // 3365
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉␍／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05Q",
		out:  "␉␍／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05Q",
	}, { // 3366
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉\r／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b␍Q",
		out:  "␉\r／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b␍Q",
	}, { // 3367
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉␍／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b␍Q",
		out:  "␉␍／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b␍Q",
	}, { // 3368
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉\r／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05␍",
		out:  "␉\r／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05‛␍",
	}, { // 3369
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉␍／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05␍",
		out:  "␉␍／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05‛␍",
	}, { // 3370
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\rQ",
		out:  "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\rQ",
	}, { // 3371
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b␍Q",
		out:  "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b␍Q",
	}, { // 3372
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\r␍",
		out:  "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\r‛␍",
	}, { // 3373
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b␍␍",
		out:  "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b␍‛␍",
	}, { // 3374
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05\r",
		out:  "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05␍",
	}, { // 3375
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05␍",
		out:  "␉τ／m\r～␍λ\x17m\rδπ'*μλ｛}．Ｑ␟1Ｘ*ｗ␞\x1b\x05‛␍",
	}, { // 3376
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊ρ",
		out:  "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊ρ",
	}, { // 3377
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\t␉\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊ρ",
		out:  "\t␉\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊ρ",
	}, { // 3378
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␉␉\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊ρ",
		out:  "␉␉\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊ρ",
	}, { // 3379
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\tK\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ␉ρ",
		out:  "\tK\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ␉ρ",
	}, { // 3380
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␉K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ␉ρ",
		out:  "␉K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ␉ρ",
	}, { // 3381
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\tK\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊␉",
		out:  "\tK\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊‛␉",
	}, { // 3382
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␉K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊␉",
		out:  "␉K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊‛␉",
	}, { // 3383
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "[\t\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊ρ",
		out:  "[\t\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊ρ",
	}, { // 3384
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "[␉\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊ρ",
		out:  "[␉\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊ρ",
	}, { // 3385
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "[\t\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ␉ρ",
		out:  "[\t\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ␉ρ",
	}, { // 3386
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "[␉\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ␉ρ",
		out:  "[␉\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ␉ρ",
	}, { // 3387
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "[\t\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊␉",
		out:  "[\t\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊‛␉",
	}, { // 3388
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "[␉\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊␉",
		out:  "[␉\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊‛␉",
	}, { // 3389
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ\tρ",
		out:  "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ\tρ",
	}, { // 3390
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ␉ρ",
		out:  "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ␉ρ",
	}, { // 3391
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ\t␉",
		out:  "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ\t‛␉",
	}, { // 3392
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ␉␉",
		out:  "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ␉‛␉",
	}, { // 3393
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊\t",
		out:  "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊␉",
	}, { // 3394
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊␉",
		out:  "[K\bβ␛␗\x10\x04␗｜\toQφ`ｅ␃τ\x0eζmＪ＼\x10␅Ｍ%Ｕ＊‛␉",
	}, { // 3395
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：6",
		out:  "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：6",
	}, { // 3396
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\n␊τ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：6",
		out:  "\n␊τ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：6",
	}, { // 3397
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␊␊τ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：6",
		out:  "␊␊τ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：6",
	}, { // 3398
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\nξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀␊6",
		out:  "\nξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀␊6",
	}, { // 3399
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␊ξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀␊6",
		out:  "␊ξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀␊6",
	}, { // 3400
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\nξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：␊",
		out:  "\nξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：‛␊",
	}, { // 3401
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␊ξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：␊",
		out:  "␊ξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：‛␊",
	}, { // 3402
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "Ｋ\nτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：6",
		out:  "Ｋ\nτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：6",
	}, { // 3403
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "Ｋ␊τ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：6",
		out:  "Ｋ␊τ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：6",
	}, { // 3404
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "Ｋ\nτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀␊6",
		out:  "Ｋ\nτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀␊6",
	}, { // 3405
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "Ｋ␊τ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀␊6",
		out:  "Ｋ␊τ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀␊6",
	}, { // 3406
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "Ｋ\nτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：␊",
		out:  "Ｋ\nτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：‛␊",
	}, { // 3407
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "Ｋ␊τ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：␊",
		out:  "Ｋ␊τ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：‛␊",
	}, { // 3408
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀\n6",
		out:  "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀\n6",
	}, { // 3409
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀␊6",
		out:  "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀␊6",
	}, { // 3410
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀\n␊",
		out:  "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀\n‛␊",
	}, { // 3411
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀␊␊",
		out:  "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀␊‛␊",
	}, { // 3412
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：\n",
		out:  "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：␊",
	}, { // 3413
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：␊",
		out:  "Ｋξτ\"\rγ\b９\x17a\nRμδυ␟ｆ＿#`\x10cｏ␈␅z␎｀：‛␊",
	}, { // 3414
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k／",
		out:  "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k／",
	}, { // 3415
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\v␋［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k／",
		out:  "\v␋［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k／",
	}, { // 3416
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␋␋［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k／",
		out:  "␋␋［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k／",
	}, { // 3417
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\vv［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,␋／",
		out:  "\vv［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,␋／",
	}, { // 3418
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␋v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,␋／",
		out:  "␋v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,␋／",
	}, { // 3419
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\vv［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k␋",
		out:  "\vv［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k‛␋",
	}, { // 3420
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␋v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k␋",
		out:  "␋v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k‛␋",
	}, { // 3421
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␔\v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k／",
		out:  "␔\v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k／",
	}, { // 3422
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␔␋［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k／",
		out:  "␔␋［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k／",
	}, { // 3423
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␔\v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,␋／",
		out:  "␔\v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,␋／",
	}, { // 3424
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␔␋［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,␋／",
		out:  "␔␋［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,␋／",
	}, { // 3425
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␔\v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k␋",
		out:  "␔\v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k‛␋",
	}, { // 3426
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␔␋［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k␋",
		out:  "␔␋［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k‛␋",
	}, { // 3427
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,\v／",
		out:  "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,\v／",
	}, { // 3428
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,␋／",
		out:  "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,␋／",
	}, { // 3429
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,\v␋",
		out:  "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,\v‛␋",
	}, { // 3430
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,␋␋",
		out:  "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,␋‛␋",
	}, { // 3431
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k\v",
		out:  "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k␋",
	}, { // 3432
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k␋",
		out:  "␔v［６κυ\b\x05 O\v'σ\x1aυｍτ␔ζK␃＄～７\x1d\\␡,k‛␋",
	}, { // 3433
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄ｍ",
		out:  "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄ｍ",
	}, { // 3434
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␍\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄ｍ",
		out:  "\r␍\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄ｍ",
	}, { // 3435
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␍␍\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄ｍ",
		out:  "␍␍\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄ｍ",
	}, { // 3436
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ␍ｍ",
		out:  "\r}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ␍ｍ",
	}, { // 3437
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␍}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ␍ｍ",
		out:  "␍}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ␍ｍ",
	}, { // 3438
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄␍",
		out:  "\r}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄‛␍",
	}, { // 3439
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␍}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄␍",
		out:  "␍}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄‛␍",
	}, { // 3440
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ξ\r\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄ｍ",
		out:  "ξ\r\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄ｍ",
	}, { // 3441
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ξ␍\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄ｍ",
		out:  "ξ␍\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄ｍ",
	}, { // 3442
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ξ\r\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ␍ｍ",
		out:  "ξ\r\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ␍ｍ",
	}, { // 3443
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ξ␍\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ␍ｍ",
		out:  "ξ␍\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ␍ｍ",
	}, { // 3444
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ξ\r\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄␍",
		out:  "ξ\r\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄‛␍",
	}, { // 3445
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ξ␍\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄␍",
		out:  "ξ␍\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄‛␍",
	}, { // 3446
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ\rｍ",
		out:  "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ\rｍ",
	}, { // 3447
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ␍ｍ",
		out:  "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ␍ｍ",
	}, { // 3448
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ\r␍",
		out:  "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ\r‛␍",
	}, { // 3449
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ␍␍",
		out:  "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ␍‛␍",
	}, { // 3450
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄\r",
		out:  "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄␍",
	}, { // 3451
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄␍",
		out:  "ξ}\x16ｕ\x14＼␇Rπ>\rεκ｀Ｈ－P␕_␞)\u007f\"␅\fＷ#υ＄‛␍",
	}, { // 3452
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ｜",
		out:  "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ｜",
	}, { // 3453
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\t␉␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ｜",
		out:  "\t␉␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ｜",
	}, { // 3454
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␉␉␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ｜",
		out:  "␉␉␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ｜",
	}, { // 3455
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\tz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15␉｜",
		out:  "\tz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15␉｜",
	}, { // 3456
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␉z␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15␉｜",
		out:  "␉z␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15␉｜",
	}, { // 3457
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\tz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ␉",
		out:  "\tz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ‛␉",
	}, { // 3458
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␉z␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ␉",
		out:  "␉z␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ‛␉",
	}, { // 3459
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "m\t␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ｜",
		out:  "m\t␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ｜",
	}, { // 3460
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "m␉␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ｜",
		out:  "m␉␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ｜",
	}, { // 3461
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "m\t␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15␉｜",
		out:  "m\t␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15␉｜",
	}, { // 3462
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "m␉␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15␉｜",
		out:  "m␉␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15␉｜",
	}, { // 3463
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "m\t␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ␉",
		out:  "m\t␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ‛␉",
	}, { // 3464
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "m␉␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ␉",
		out:  "m␉␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ‛␉",
	}, { // 3465
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15\t｜",
		out:  "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15\t｜",
	}, { // 3466
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15␉｜",
		out:  "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15␉｜",
	}, { // 3467
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15\t␉",
		out:  "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15\t‛␉",
	}, { // 3468
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15␉␉",
		out:  "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15␉‛␉",
	}, { // 3469
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ\t",
		out:  "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ␉",
	}, { // 3470
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ␉",
		out:  "mz␏\nν␜λβ＂9\tＢ/Ｋ,5n\x02ｍ␜ｆ?σσ\x13␙␜\x15ｕ‛␉",
	}, { // 3471
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇α6",
		out:  "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇α6",
	}, { // 3472
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\n␊\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇α6",
		out:  "\n␊\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇α6",
	}, { // 3473
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␊␊\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇α6",
		out:  "␊␊\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇α6",
	}, { // 3474
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\n[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇␊6",
		out:  "\n[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇␊6",
	}, { // 3475
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␊[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇␊6",
		out:  "␊[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇␊6",
	}, { // 3476
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\n[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇α␊",
		out:  "\n[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇α‛␊",
	}, { // 3477
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␊[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇α␊",
		out:  "␊[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇α‛␊",
	}, { // 3478
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "τ\n\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇α6",
		out:  "τ\n\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇α6",
	}, { // 3479
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "τ␊\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇α6",
		out:  "τ␊\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇α6",
	}, { // 3480
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "τ\n\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇␊6",
		out:  "τ\n\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇␊6",
	}, { // 3481
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "τ␊\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇␊6",
		out:  "τ␊\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇␊6",
	}, { // 3482
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "τ\n\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇α␊",
		out:  "τ\n\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇α‛␊",
	}, { // 3483
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "τ␊\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇α␊",
		out:  "τ␊\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇α‛␊",
	}, { // 3484
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇\n6",
		out:  "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇\n6",
	}, { // 3485
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇␊6",
		out:  "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇␊6",
	}, { // 3486
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇\n␊",
		out:  "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇\n‛␊",
	}, { // 3487
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇␊␊",
		out:  "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇␊‛␊",
	}, { // 3488
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇α\n",
		out:  "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇α␊",
	}, { // 3489
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ*＊θQ＄␇α␊",
		out:  "τ[\x1a\x06｝ς␁／`\x03\nξ6０O␁#Ｘ%␂νａ＊‛＊θQ＄␇α‛␊",
	}, { // 3490
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N\v＜",
		out:  "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N\v＜",
	}, { // 3491
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\v␋␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N\v＜",
		out:  "\v␋␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N\v＜",
	}, { // 3492
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␋␋␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N\v＜",
		out:  "␋␋␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N\v＜",
	}, { // 3493
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\vｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N␋＜",
		out:  "\vｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N␋＜",
	}, { // 3494
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␋ｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N␋＜",
		out:  "␋ｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N␋＜",
	}, { // 3495
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\vｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N\v␋",
		out:  "\vｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N\v‛␋",
	}, { // 3496
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␋ｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N\v␋",
		out:  "␋ｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N\v‛␋",
	}, { // 3497
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｒ\v␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N\v＜",
		out:  "ｒ\v␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N\v＜",
	}, { // 3498
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｒ␋␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N\v＜",
		out:  "ｒ␋␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N\v＜",
	}, { // 3499
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｒ\v␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N␋＜",
		out:  "ｒ\v␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N␋＜",
	}, { // 3500
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｒ␋␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N␋＜",
		out:  "ｒ␋␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N␋＜",
	}, { // 3501
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｒ\v␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N\v␋",
		out:  "ｒ\v␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N\v‛␋",
	}, { // 3502
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｒ␋␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N\v␋",
		out:  "ｒ␋␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N\v‛␋",
	}, { // 3503
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N\v＜",
		out:  "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N\v＜",
	}, { // 3504
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N␋＜",
		out:  "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N␋＜",
	}, { // 3505
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N\v␋",
		out:  "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N\v‛␋",
	}, { // 3506
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N␋␋",
		out:  "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N␋‛␋",
	}, { // 3507
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N\v\v",
		out:  "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N\v␋",
	}, { // 3508
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈\x00６K␙β?N\v␋",
		out:  "ｒｕ␖\x05\x04N＄υδ\n\vｙτJG\"␔ι８β␈␀６K␙β?N\v‛␋",
	}, { // 3509
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "＝6ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ\x1a",
		out:  "＝6ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ\x1a",
	}, { // 3510
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\r␍ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ\x1a",
		out:  "\r␍ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ\x1a",
	}, { // 3511
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␍␍ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ\x1a",
		out:  "␍␍ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ\x1a",
	}, { // 3512
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\r6ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ␍\x1a",
		out:  "\r6ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ␍\x1a",
	}, { // 3513
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␍6ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ␍\x1a",
		out:  "␍6ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ␍\x1a",
	}, { // 3514
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\r6ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ␍",
		out:  "\r6ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ‛␍",
	}, { // 3515
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␍6ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ␍",
		out:  "␍6ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ‛␍",
	}, { // 3516
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "＝\rｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ\x1a",
		out:  "＝\rｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ\x1a",
	}, { // 3517
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "＝␍ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ\x1a",
		out:  "＝␍ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ\x1a",
	}, { // 3518
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "＝\rｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ␍\x1a",
		out:  "＝\rｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ␍\x1a",
	}, { // 3519
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "＝␍ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ␍\x1a",
		out:  "＝␍ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ␍\x1a",
	}, { // 3520
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "＝\rｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ␍",
		out:  "＝\rｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ‛␍",
	}, { // 3521
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "＝␍ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ␍",
		out:  "＝␍ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ‛␍",
	}, { // 3522
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "＝6ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ\r\x1a",
		out:  "＝6ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ\r\x1a",
	}, { // 3523
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "＝6ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ␍\x1a",
		out:  "＝6ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ␍\x1a",
	}, { // 3524
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "＝6ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ\r␍",
		out:  "＝6ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ\r‛␍",
	}, { // 3525
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "＝6ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ␍␍",
		out:  "＝6ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂ␍‛␍",
	}, { // 3526
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "＝6ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ\r",
		out:  "＝6ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ␍",
	}, { // 3527
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "＝6ｗ２␇\x1fc␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ␍",
		out:  "＝6ｗ２␇\x1fc‛␀(<\r\x15s\rκι^／ς＠｀π\x04１τκ｀ｂJ‛␍",
	}, { // 3528
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "γ␄ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\rＧ＠",
		out:  "γ␄ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\rＧ＠",
	}, { // 3529
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\t␉ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\rＧ＠",
		out:  "\t␉ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\rＧ＠",
	}, { // 3530
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␉␉ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\rＧ＠",
		out:  "␉␉ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\rＧ＠",
	}, { // 3531
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\t␄ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\r␉＠",
		out:  "\t␄ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\r␉＠",
	}, { // 3532
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␉␄ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\r␉＠",
		out:  "␉␄ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\r␉＠",
	}, { // 3533
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\t␄ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\rＧ␉",
		out:  "\t␄ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\rＧ‛␉",
	}, { // 3534
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␉␄ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\rＧ␉",
		out:  "␉␄ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\rＧ‛␉",
	}, { // 3535
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "γ\tｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\rＧ＠",
		out:  "γ\tｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\rＧ＠",
	}, { // 3536
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "γ␉ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\rＧ＠",
		out:  "γ␉ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\rＧ＠",
	}, { // 3537
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "γ\tｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\r␉＠",
		out:  "γ\tｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\r␉＠",
	}, { // 3538
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "γ␉ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\r␉＠",
		out:  "γ␉ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\r␉＠",
	}, { // 3539
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "γ\tｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\rＧ␉",
		out:  "γ\tｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\rＧ‛␉",
	}, { // 3540
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "γ␉ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\rＧ␉",
		out:  "γ␉ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\rＧ‛␉",
	}, { // 3541
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "γ␄ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\r\t＠",
		out:  "γ␄ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\r\t＠",
	}, { // 3542
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "γ␄ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\r␉＠",
		out:  "γ␄ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\r␉＠",
	}, { // 3543
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "γ␄ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\r\t␉",
		out:  "γ␄ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\r\t‛␉",
	}, { // 3544
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "γ␄ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\r␉␉",
		out:  "γ␄ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\r␉‛␉",
	}, { // 3545
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "γ␄ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\rＧ\t",
		out:  "γ␄ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\rＧ␉",
	}, { // 3546
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "γ␄ｖξ\x1eA\x14τ␍|\tβ\x17ｔ\x0fπ␊%;１ν\x00＜rｎ␝␒\rＧ␉",
		out:  "γ␄ｖξ\x1eA\x14τ␍｜\tβ\x17ｔ\x0fπ␊%;１ν␀＜rｎ␝␒\rＧ‛␉",
	}, { // 3547
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␝",
		out:  "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␝",
	}, { // 3548
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\n␊D␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␝",
		out:  "\n␊D␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␝",
	}, { // 3549
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␊␊D␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␝",
		out:  "␊␊D␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␝",
	}, { // 3550
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\nφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈␊␝",
		out:  "\nφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈␊␝",
	}, { // 3551
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␊φD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈␊␝",
		out:  "␊φD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈␊␝",
	}, { // 3552
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\nφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␊",
		out:  "\nφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a‛␊",
	}, { // 3553
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␊φD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␊",
		out:  "␊φD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a‛␊",
	}, { // 3554
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "τ\nD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␝",
		out:  "τ\nD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␝",
	}, { // 3555
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "τ␊D␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␝",
		out:  "τ␊D␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␝",
	}, { // 3556
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "τ\nD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈␊␝",
		out:  "τ\nD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈␊␝",
	}, { // 3557
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "τ␊D␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈␊␝",
		out:  "τ␊D␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈␊␝",
	}, { // 3558
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "τ\nD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␊",
		out:  "τ\nD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a‛␊",
	}, { // 3559
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "τ␊D␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␊",
		out:  "τ␊D␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a‛␊",
	}, { // 3560
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\n␝",
		out:  "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\n␝",
	}, { // 3561
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈␊␝",
		out:  "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈␊␝",
	}, { // 3562
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\n␊",
		out:  "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\n‛␊",
	}, { // 3563
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈␊␊",
		out:  "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈␊‛␊",
	}, { // 3564
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a\n",
		out:  "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␊",
	}, { // 3565
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a␊",
		out:  "τφD␁\x01␋G\\\x05Ｏ\n##ｓ\x05tＲ␆ψσφ\nδ␡ｎiｕ␈\a‛␊",
	}, { // 3566
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$6Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12＜",
		out:  "$6Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12＜",
	}, { // 3567
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\v␋Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12＜",
		out:  "\v␋Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12＜",
	}, { // 3568
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␋␋Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12＜",
		out:  "␋␋Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12＜",
	}, { // 3569
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\v6Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞␋＜",
		out:  "\v6Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞␋＜",
	}, { // 3570
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␋6Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞␋＜",
		out:  "␋6Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞␋＜",
	}, { // 3571
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\v6Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12␋",
		out:  "\v6Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12‛␋",
	}, { // 3572
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␋6Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12␋",
		out:  "␋6Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12‛␋",
	}, { // 3573
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$\vＶςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12＜",
		out:  "$\vＶςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12＜",
	}, { // 3574
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$␋Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12＜",
		out:  "$␋Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12＜",
	}, { // 3575
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$\vＶςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞␋＜",
		out:  "$\vＶςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞␋＜",
	}, { // 3576
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$␋Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞␋＜",
		out:  "$␋Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞␋＜",
	}, { // 3577
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$\vＶςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12␋",
		out:  "$\vＶςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12‛␋",
	}, { // 3578
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$␋Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12␋",
		out:  "$␋Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12‛␋",
	}, { // 3579
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$6Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\v＜",
		out:  "$6Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\v＜",
	}, { // 3580
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$6Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞␋＜",
		out:  "$6Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞␋＜",
	}, { // 3581
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$6Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\v␋",
		out:  "$6Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\v‛␋",
	}, { // 3582
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$6Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞␋␋",
		out:  "$6Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞␋‛␋",
	}, { // 3583
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$6Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12\v",
		out:  "$6Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12␋",
	}, { // 3584
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$6Ｖςν\x0e\x10x｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12␋",
		out:  "$6Ｖςν\x0e\x10x‛｜/\vδσＳ=Ｊβ\x11␑␋␑τ␟；~Ｄ{＞\x12‛␋",
	}, { // 3585
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␒",
		out:  "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␒",
	}, { // 3586
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\r␍␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␒",
		out:  "\r␍␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␒",
	}, { // 3587
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␍␍␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␒",
		out:  "␍␍␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␒",
	}, { // 3588
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\rJ␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa␍␒",
		out:  "\rJ␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa␍␒",
	}, { // 3589
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␍J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa␍␒",
		out:  "␍J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa␍␒",
	}, { // 3590
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\rJ␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␍",
		out:  "\rJ␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!‛␍",
	}, { // 3591
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␍J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␍",
		out:  "␍J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!‛␍",
	}, { // 3592
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\x04\r␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␒",
		out:  "\x04\r␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␒",
	}, { // 3593
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\x04␍␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␒",
		out:  "\x04␍␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␒",
	}, { // 3594
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\x04\r␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa␍␒",
		out:  "\x04\r␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa␍␒",
	}, { // 3595
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\x04␍␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa␍␒",
		out:  "\x04␍␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa␍␒",
	}, { // 3596
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\x04\r␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␍",
		out:  "\x04\r␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!‛␍",
	}, { // 3597
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\x04␍␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␍",
		out:  "\x04␍␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!‛␍",
	}, { // 3598
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa\r␒",
		out:  "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa\r␒",
	}, { // 3599
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa␍␒",
		out:  "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa␍␒",
	}, { // 3600
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa\r␍",
		out:  "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa\r‛␍",
	}, { // 3601
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa␍␍",
		out:  "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa␍‛␍",
	}, { // 3602
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!\r",
		out:  "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␍",
	}, { // 3603
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!␍",
		out:  "\x04J␚ψτ＜␞Ｉｅｊ\r(Dｙ\x02/Ｌ\x1b\x1f:９x␒ακκμa!‛␍",
	}, { // 3604
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒ＢtＨ",
		out:  "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒ＢtＨ",
	}, { // 3605
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\t␉1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒ＢtＨ",
		out:  "\t␉1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒ＢtＨ",
	}, { // 3606
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␉␉1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒ＢtＨ",
		out:  "␉␉1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒ＢtＨ",
	}, { // 3607
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\t\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ␉Ｈ",
		out:  "\t\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ␉Ｈ",
	}, { // 3608
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␉\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ␉Ｈ",
		out:  "␉\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ␉Ｈ",
	}, { // 3609
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\t\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂt␉",
		out:  "\t\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂt‛␉",
	}, { // 3610
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␉\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂt␉",
		out:  "␉\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂt‛␉",
	}, { // 3611
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␗\t1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒ＢtＨ",
		out:  "␗\t1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒ＢtＨ",
	}, { // 3612
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␗␉1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒ＢtＨ",
		out:  "␗␉1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒ＢtＨ",
	}, { // 3613
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␗\t1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ␉Ｈ",
		out:  "␗\t1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ␉Ｈ",
	}, { // 3614
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␗␉1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ␉Ｈ",
		out:  "␗␉1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ␉Ｈ",
	}, { // 3615
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␗\t1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂt␉",
		out:  "␗\t1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂt‛␉",
	}, { // 3616
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␗␉1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂt␉",
		out:  "␗␉1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂt‛␉",
	}, { // 3617
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ\tＨ",
		out:  "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ\tＨ",
	}, { // 3618
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ␉Ｈ",
		out:  "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ␉Ｈ",
	}, { // 3619
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ\t␉",
		out:  "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ\t‛␉",
	}, { // 3620
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ␉␉",
		out:  "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂ␉‛␉",
	}, { // 3621
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂt\t",
		out:  "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂt␉",
	}, { // 3622
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂt␉",
		out:  "␗\b1＊3␆－υ\x1c＝\tＥf`ηN\a＾␏ν\x14␔βοUι␒Ｂt‛␉",
	}, { // 3623
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "G$Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）ι",
		out:  "G$Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）ι",
	}, { // 3624
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\n␊Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）ι",
		out:  "\n␊Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）ι",
	}, { // 3625
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␊␊Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）ι",
		out:  "␊␊Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）ι",
	}, { // 3626
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\n$Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD␊ι",
		out:  "\n$Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD␊ι",
	}, { // 3627
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␊$Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD␊ι",
		out:  "␊$Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD␊ι",
	}, { // 3628
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\n$Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）␊",
		out:  "\n$Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）‛␊",
	}, { // 3629
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␊$Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）␊",
		out:  "␊$Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）‛␊",
	}, { // 3630
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "G\nＢ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）ι",
		out:  "G\nＢ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）ι",
	}, { // 3631
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "G␊Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）ι",
		out:  "G␊Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）ι",
	}, { // 3632
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "G\nＢ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD␊ι",
		out:  "G\nＢ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD␊ι",
	}, { // 3633
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "G␊Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD␊ι",
		out:  "G␊Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD␊ι",
	}, { // 3634
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "G\nＢ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）␊",
		out:  "G\nＢ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）‛␊",
	}, { // 3635
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "G␊Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）␊",
		out:  "G␊Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）‛␊",
	}, { // 3636
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "G$Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD\nι",
		out:  "G$Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD\nι",
	}, { // 3637
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "G$Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD␊ι",
		out:  "G$Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD␊ι",
	}, { // 3638
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "G$Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD\n␊",
		out:  "G$Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD\n‛␊",
	}, { // 3639
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "G$Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD␊␊",
		out:  "G$Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD␊‛␊",
	}, { // 3640
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "G$Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）\n",
		out:  "G$Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）␊",
	}, { // 3641
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "G$Ｂ\x19ｚ＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）␊",
		out:  "G$Ｂ\x19ｚ‛＃l－/|\n␝yψ＠ζπＩ\x1f␋：／μξ＼\f\nD）‛␊",
	}, { // 3642
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜＞",
		out:  "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜＞",
	}, { // 3643
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\v␋\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜＞",
		out:  "\v␋\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜＞",
	}, { // 3644
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␋␋\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜＞",
		out:  "␋␋\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜＞",
	}, { // 3645
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\v＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\␋＞",
		out:  "\v＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\␋＞",
	}, { // 3646
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␋＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\␋＞",
		out:  "␋＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\␋＞",
	}, { // 3647
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\v＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜␋",
		out:  "\v＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜‛␋",
	}, { // 3648
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␋＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜␋",
		out:  "␋＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜‛␋",
	}, { // 3649
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "A\v\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜＞",
		out:  "A\v\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜＞",
	}, { // 3650
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "A␋\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜＞",
		out:  "A␋\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜＞",
	}, { // 3651
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "A\v\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\␋＞",
		out:  "A\v\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\␋＞",
	}, { // 3652
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "A␋\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\␋＞",
		out:  "A␋\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\␋＞",
	}, { // 3653
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "A\v\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜␋",
		out:  "A\v\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜‛␋",
	}, { // 3654
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "A␋\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜␋",
		out:  "A␋\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜‛␋",
	}, { // 3655
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\\v＞",
		out:  "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\\v＞",
	}, { // 3656
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\␋＞",
		out:  "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\␋＞",
	}, { // 3657
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\\v␋",
		out:  "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\\v‛␋",
	}, { // 3658
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\␋␋",
		out:  "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\␋‛␋",
	}, { // 3659
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜\v",
		out:  "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜␋",
	}, { // 3660
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜␋",
		out:  "A＇\x1a$9␈Ｉｚρ１\vγ＜`Ｇfｙς\x1e\x16φ\x12μν␌2␍\\｜‛␋",
	}, { // 3661
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ6＝",
		out:  "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ6＝",
	}, { // 3662
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\r␍Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ6＝",
		out:  "\r␍Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ6＝",
	}, { // 3663
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␍␍Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ6＝",
		out:  "␍␍Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ6＝",
	}, { // 3664
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\r$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ␍＝",
		out:  "\r$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ␍＝",
	}, { // 3665
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␍$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ␍＝",
		out:  "␍$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ␍＝",
	}, { // 3666
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\r$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ6␍",
		out:  "\r$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ6‛␍",
	}, { // 3667
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␍$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ6␍",
		out:  "␍$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ6‛␍",
	}, { // 3668
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x02\rＹ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ6＝",
		out:  "\x02\rＹ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ6＝",
	}, { // 3669
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x02␍Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ6＝",
		out:  "\x02␍Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ6＝",
	}, { // 3670
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x02\rＹ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ␍＝",
		out:  "\x02\rＹ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ␍＝",
	}, { // 3671
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x02␍Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ␍＝",
		out:  "\x02␍Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ␍＝",
	}, { // 3672
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x02\rＹ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ6␍",
		out:  "\x02\rＹ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ6‛␍",
	}, { // 3673
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x02␍Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ6␍",
		out:  "\x02␍Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ6‛␍",
	}, { // 3674
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ\r＝",
		out:  "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ\r＝",
	}, { // 3675
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ␍＝",
		out:  "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ␍＝",
	}, { // 3676
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ\r␍",
		out:  "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ\r‛␍",
	}, { // 3677
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ␍␍",
		out:  "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ␍‛␍",
	}, { // 3678
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ6\r",
		out:  "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ6␍",
	}, { // 3679
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ␀␍6M␕\x16／␗Ｖｌ6␍",
		out:  "\x02$Ｙ：ν\x02\x10␁(λ\r\f３χ\x18μφβ‛␀␍6M␕\x16／␗Ｖｌ6‛␍",
	}, { // 3680
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "σ(x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β＄q",
		out:  "σ(x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β＄q",
	}, { // 3681
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\t␉x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β＄q",
		out:  "\t␉x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β＄q",
	}, { // 3682
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␉␉x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β＄q",
		out:  "␉␉x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β＄q",
	}, { // 3683
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\t(x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β␉q",
		out:  "\t(x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β␉q",
	}, { // 3684
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␉(x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β␉q",
		out:  "␉(x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β␉q",
	}, { // 3685
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\t(x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β＄␉",
		out:  "\t(x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β＄‛␉",
	}, { // 3686
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␉(x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β＄␉",
		out:  "␉(x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β＄‛␉",
	}, { // 3687
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "σ\tx＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β＄q",
		out:  "σ\tx＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β＄q",
	}, { // 3688
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "σ␉x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β＄q",
		out:  "σ␉x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β＄q",
	}, { // 3689
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "σ\tx＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β␉q",
		out:  "σ\tx＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β␉q",
	}, { // 3690
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "σ␉x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β␉q",
		out:  "σ␉x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β␉q",
	}, { // 3691
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "σ\tx＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β＄␉",
		out:  "σ\tx＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β＄‛␉",
	}, { // 3692
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "σ␉x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β＄␉",
		out:  "σ␉x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β＄‛␉",
	}, { // 3693
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "σ(x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β\tq",
		out:  "σ(x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β\tq",
	}, { // 3694
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "σ(x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β␉q",
		out:  "σ(x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β␉q",
	}, { // 3695
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "σ(x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β\t␉",
		out:  "σ(x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β\t‛␉",
	}, { // 3696
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "σ(x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β␉␉",
		out:  "σ(x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β␉‛␉",
	}, { // 3697
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "σ(x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β＄\t",
		out:  "σ(x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β＄␉",
	}, { // 3698
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "σ(x＼λ％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄%␝␐\x18β＄␉",
		out:  "σ(x＼λ‛％\\ν+ｘ\tgＧ␎ｕ\x13\x06\"｀μ\b＜＄％␝␐\x18β＄‛␉",
	}, { // 3699
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
		out:  "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
	}, { // 3700
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\n␊\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
		out:  "\n␊\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
	}, { // 3701
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊␊\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
		out:  "␊␊\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
	}, { // 3702
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\n\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
		out:  "\n\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
	}, { // 3703
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
		out:  "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
	}, { // 3704
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\n\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊␊",
		out:  "\n\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊‛␊",
	}, { // 3705
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊␊",
		out:  "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊‛␊",
	}, { // 3706
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\n\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
		out:  "␊\n\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
	}, { // 3707
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊␊\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
		out:  "␊␊\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
	}, { // 3708
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\n\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
		out:  "␊\n\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
	}, { // 3709
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊␊\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
		out:  "␊␊\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
	}, { // 3710
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\n\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊␊",
		out:  "␊\n\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊‛␊",
	}, { // 3711
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊␊\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊␊",
		out:  "␊␊\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊‛␊",
	}, { // 3712
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v\nς",
		out:  "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v\nς",
	}, { // 3713
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
		out:  "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊ς",
	}, { // 3714
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v\n␊",
		out:  "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v\n‛␊",
	}, { // 3715
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊␊",
		out:  "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊‛␊",
	}, { // 3716
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊\n",
		out:  "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊␊",
	}, { // 3717
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊␊",
		out:  "␊\x01\x1aI\aＧｆκＱ＊\n＋Ｐ＄\x14ο+|2～SW␋ρεμ'\v␊‛␊",
	}, { // 3718
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈Ｒ",
		out:  "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈Ｒ",
	}, { // 3719
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\v␋Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈Ｒ",
		out:  "\v␋Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈Ｒ",
	}, { // 3720
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␋␋Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈Ｒ",
		out:  "␋␋Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈Ｒ",
	}, { // 3721
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\v，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␋Ｒ",
		out:  "\v，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␋Ｒ",
	}, { // 3722
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␋，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␋Ｒ",
		out:  "␋，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␋Ｒ",
	}, { // 3723
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\v，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈␋",
		out:  "\v，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈‛␋",
	}, { // 3724
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␋，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈␋",
		out:  "␋，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈‛␋",
	}, { // 3725
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "Ｆ\vＡ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈Ｒ",
		out:  "Ｆ\vＡ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈Ｒ",
	}, { // 3726
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "Ｆ␋Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈Ｒ",
		out:  "Ｆ␋Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈Ｒ",
	}, { // 3727
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "Ｆ\vＡ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␋Ｒ",
		out:  "Ｆ\vＡ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␋Ｒ",
	}, { // 3728
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "Ｆ␋Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␋Ｒ",
		out:  "Ｆ␋Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␋Ｒ",
	}, { // 3729
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "Ｆ\vＡ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈␋",
		out:  "Ｆ\vＡ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈‛␋",
	}, { // 3730
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "Ｆ␋Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈␋",
		out:  "Ｆ␋Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈‛␋",
	}, { // 3731
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f\vＲ",
		out:  "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f\vＲ",
	}, { // 3732
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␋Ｒ",
		out:  "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␋Ｒ",
	}, { // 3733
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f\v␋",
		out:  "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f\v‛␋",
	}, { // 3734
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␋␋",
		out:  "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␋‛␋",
	}, { // 3735
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈\v",
		out:  "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈␋",
	}, { // 3736
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈␋",
		out:  "Ｆ，Ａ␑␝␉κ/μg\vμυ␊\u007f\x1fβ$)cς␒|\nPｐ\"\f␈‛␋",
	}, { // 3737
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５\x17",
		out:  "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５\x17",
	}, { // 3738
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\r␍\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５\x17",
		out:  "\r␍\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５\x17",
	}, { // 3739
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␍␍\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５\x17",
		out:  "␍␍\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５\x17",
	}, { // 3740
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\rτ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜␍\x17",
		out:  "\rτ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜␍\x17",
	}, { // 3741
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␍τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜␍\x17",
		out:  "␍τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜␍\x17",
	}, { // 3742
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\rτ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５␍",
		out:  "\rτ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５‛␍",
	}, { // 3743
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␍τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５␍",
		out:  "␍τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５‛␍",
	}, { // 3744
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␓\r\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５\x17",
		out:  "␓\r\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５\x17",
	}, { // 3745
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␓␍\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５\x17",
		out:  "␓␍\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５\x17",
	}, { // 3746
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␓\r\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜␍\x17",
		out:  "␓\r\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜␍\x17",
	}, { // 3747
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␓␍\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜␍\x17",
		out:  "␓␍\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜␍\x17",
	}, { // 3748
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␓\r\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５␍",
		out:  "␓\r\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５‛␍",
	}, { // 3749
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␓␍\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５␍",
		out:  "␓␍\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５‛␍",
	}, { // 3750
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜\r\x17",
		out:  "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜\r\x17",
	}, { // 3751
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜␍\x17",
		out:  "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜␍\x17",
	}, { // 3752
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜\r␍",
		out:  "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜\r‛␍",
	}, { // 3753
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜␍␍",
		out:  "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜␍‛␍",
	}, { // 3754
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５\r",
		out:  "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５␍",
	}, { // 3755
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５␍",
		out:  "␓τ\nω␇}␄｀4\v\r\"Ｇ␟θ␏τ␄aζ＾Kｄ\x04\x16ς!｜５‛␍",
	}, { // 3756
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15A",
		out:  "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15A",
	}, { // 3757
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\t␉\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15A",
		out:  "\t␉\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15A",
	}, { // 3758
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␉␉\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15A",
		out:  "␉␉\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15A",
	}, { // 3759
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\tτ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉␉A",
		out:  "\tτ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉␉A",
	}, { // 3760
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␉τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉␉A",
		out:  "␉τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉␉A",
	}, { // 3761
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\tτ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15␉",
		out:  "\tτ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15‛␉",
	}, { // 3762
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␉τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15␉",
		out:  "␉τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15‛␉",
	}, { // 3763
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␌\t\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15A",
		out:  "␌\t\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15A",
	}, { // 3764
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␌␉\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15A",
		out:  "␌␉\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15A",
	}, { // 3765
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␌\t\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉␉A",
		out:  "␌\t\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉␉A",
	}, { // 3766
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␌␉\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉␉A",
		out:  "␌␉\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉␉A",
	}, { // 3767
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␌\t\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15␉",
		out:  "␌\t\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15‛␉",
	}, { // 3768
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␌␉\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15␉",
		out:  "␌␉\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15‛␉",
	}, { // 3769
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\tA",
		out:  "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\tA",
	}, { // 3770
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉␉A",
		out:  "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉␉A",
	}, { // 3771
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\t␉",
		out:  "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\t‛␉",
	}, { // 3772
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉␉␉",
		out:  "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉␉‛␉",
	}, { // 3773
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15\t",
		out:  "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15␉",
	}, { // 3774
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15␉",
		out:  "␌τ\x02Sν％η＇\x03?\t␆ξj：ＫT|␆/ξｏ／φ␜Z?␉\x15‛␉",
	}, { // 3775
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ\x1f",
		out:  "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ\x1f",
	}, { // 3776
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\n␊\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ\x1f",
		out:  "\n␊\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ\x1f",
	}, { // 3777
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␊␊\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ\x1f",
		out:  "␊␊\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ\x1f",
	}, { // 3778
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\nb\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S␊\x1f",
		out:  "\nb\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S␊\x1f",
	}, { // 3779
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␊b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S␊\x1f",
		out:  "␊b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S␊\x1f",
	}, { // 3780
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\nb\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ␊",
		out:  "\nb\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ‛␊",
	}, { // 3781
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␊b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ␊",
		out:  "␊b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ‛␊",
	}, { // 3782
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|\n\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ\x1f",
		out:  "|\n\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ\x1f",
	}, { // 3783
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␊\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ\x1f",
		out:  "|␊\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ\x1f",
	}, { // 3784
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|\n\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S␊\x1f",
		out:  "|\n\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S␊\x1f",
	}, { // 3785
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␊\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S␊\x1f",
		out:  "|␊\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S␊\x1f",
	}, { // 3786
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|\n\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ␊",
		out:  "|\n\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ‛␊",
	}, { // 3787
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␊\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ␊",
		out:  "|␊\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ‛␊",
	}, { // 3788
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S\n\x1f",
		out:  "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S\n\x1f",
	}, { // 3789
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S␊\x1f",
		out:  "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S␊\x1f",
	}, { // 3790
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S\n␊",
		out:  "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S\n‛␊",
	}, { // 3791
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S␊␊",
		out:  "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀S␊‛␊",
	}, { // 3792
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ\n",
		out:  "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ␊",
	}, { // 3793
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ␊",
		out:  "|b\x02υ␛8＇λ９γ\n＝ψ␂α\"：χ！␓\a%bｑ：:｀SＧ‛␊",
	}, { // 3794
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4ω␇",
		out:  "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4ω␇",
	}, { // 3795
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\v␋χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4ω␇",
		out:  "\v␋χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4ω␇",
	}, { // 3796
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␋␋χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4ω␇",
		out:  "␋␋χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4ω␇",
	}, { // 3797
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\v␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4␋␇",
		out:  "\v␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4␋␇",
	}, { // 3798
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␋␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4␋␇",
		out:  "␋␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4␋␇",
	}, { // 3799
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\v␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4ω␋",
		out:  "\v␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4ω‛␋",
	}, { // 3800
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␋␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4ω␋",
		out:  "␋␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4ω‛␋",
	}, { // 3801
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|\vχw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4ω␇",
		out:  "|\vχw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4ω␇",
	}, { // 3802
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␋χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4ω␇",
		out:  "|␋χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4ω␇",
	}, { // 3803
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|\vχw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4␋␇",
		out:  "|\vχw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4␋␇",
	}, { // 3804
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␋χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4␋␇",
		out:  "|␋χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4␋␇",
	}, { // 3805
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|\vχw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4ω␋",
		out:  "|\vχw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4ω‛␋",
	}, { // 3806
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␋χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4ω␋",
		out:  "|␋χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4ω‛␋",
	}, { // 3807
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4\v␇",
		out:  "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4\v␇",
	}, { // 3808
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4␋␇",
		out:  "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4␋␇",
	}, { // 3809
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4\v␋",
		out:  "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4\v‛␋",
	}, { // 3810
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4␋␋",
		out:  "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4␋‛␋",
	}, { // 3811
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4ω\v",
		out:  "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4ω␋",
	}, { // 3812
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ\x00␊\x05\x15\x12␛？)4ω␋",
		out:  "|␞χw＄ｖ␙:Ｃκ\v［κξsτＸbｊ␀␊\x05\x15\x12␛？)4ω‛␋",
	}, { // 3813
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "π＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␚",
		out:  "π‛＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␚",
	}, { // 3814
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r␍\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␚",
		out:  "\r␍\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␚",
	}, { // 3815
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␍␍\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␚",
		out:  "␍␍\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␚",
	}, { // 3816
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ␍␚",
		out:  "\r‛＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ␍␚",
	}, { // 3817
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␍＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ␍␚",
		out:  "␍‛＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ␍␚",
	}, { // 3818
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␍",
		out:  "\r‛＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇‛␍",
	}, { // 3819
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␍＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␍",
		out:  "␍‛＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇‛␍",
	}, { // 3820
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "π\r\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␚",
		out:  "π\r\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␚",
	}, { // 3821
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "π␍\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␚",
		out:  "π␍\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␚",
	}, { // 3822
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "π\r\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ␍␚",
		out:  "π\r\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ␍␚",
	}, { // 3823
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "π␍\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ␍␚",
		out:  "π␍\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ␍␚",
	}, { // 3824
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "π\r\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␍",
		out:  "π\r\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇‛␍",
	}, { // 3825
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "π␍\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␍",
		out:  "π␍\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇‛␍",
	}, { // 3826
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "π＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ\r␚",
		out:  "π‛＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ\r␚",
	}, { // 3827
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "π＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ␍␚",
		out:  "π‛＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ␍␚",
	}, { // 3828
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "π＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ\r␍",
		out:  "π‛＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ\r‛␍",
	}, { // 3829
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "π＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ␍␍",
		out:  "π‛＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ␍‛␍",
	}, { // 3830
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "π＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇\r",
		out:  "π‛＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␍",
	}, { // 3831
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "π＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇␍",
		out:  "π‛＼\"{\x18８Sτ[a\rπＰ\x04ｔ␋Ｙψ\x03d＃ｙ\x1c／\t8？θ＇‛␍",
	}, { // 3832
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$ς",
		out:  "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$ς",
	}, { // 3833
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\t␉λ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$ς",
		out:  "\t␉λ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$ς",
	}, { // 3834
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␉λ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$ς",
		out:  "␉␉λ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$ς",
	}, { // 3835
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\tDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9␉ς",
		out:  "\tDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9␉ς",
	}, { // 3836
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉Dλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9␉ς",
		out:  "␉Dλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9␉ς",
	}, { // 3837
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\tDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$␉",
		out:  "\tDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$‛␉",
	}, { // 3838
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉Dλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$␉",
		out:  "␉Dλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$‛␉",
	}, { // 3839
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\x0f\tλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$ς",
		out:  "\x0f\tλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$ς",
	}, { // 3840
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\x0f␉λ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$ς",
		out:  "\x0f␉λ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$ς",
	}, { // 3841
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\x0f\tλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9␉ς",
		out:  "\x0f\tλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9␉ς",
	}, { // 3842
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\x0f␉λ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9␉ς",
		out:  "\x0f␉λ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9␉ς",
	}, { // 3843
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\x0f\tλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$␉",
		out:  "\x0f\tλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$‛␉",
	}, { // 3844
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\x0f␉λ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$␉",
		out:  "\x0f␉λ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$‛␉",
	}, { // 3845
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9\tς",
		out:  "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9\tς",
	}, { // 3846
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9␉ς",
		out:  "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9␉ς",
	}, { // 3847
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9\t␉",
		out:  "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9\t‛␉",
	}, { // 3848
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9␉␉",
		out:  "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9␉‛␉",
	}, { // 3849
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$\t",
		out:  "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$␉",
	}, { // 3850
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$␉",
		out:  "\x0fDλ\x11␘δψ␈ςS\tN＊ＬｇＴ`＂I␅ο\tu␟＞～Ｈ9$‛␉",
	}, { // 3851
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λιρ",
		out:  "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λιρ",
	}, { // 3852
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\n␊δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λιρ",
		out:  "\n␊δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λιρ",
	}, { // 3853
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␊␊δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λιρ",
		out:  "␊␊δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λιρ",
	}, { // 3854
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\n＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ␊ρ",
		out:  "\n＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ␊ρ",
	}, { // 3855
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␊＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ␊ρ",
		out:  "␊＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ␊ρ",
	}, { // 3856
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\n＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λι␊",
		out:  "\n＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λι‛␊",
	}, { // 3857
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␊＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λι␊",
		out:  "␊＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λι‛␊",
	}, { // 3858
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "?\nδ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λιρ",
		out:  "?\nδ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λιρ",
	}, { // 3859
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "?␊δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λιρ",
		out:  "?␊δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λιρ",
	}, { // 3860
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "?\nδ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ␊ρ",
		out:  "?\nδ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ␊ρ",
	}, { // 3861
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "?␊δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ␊ρ",
		out:  "?␊δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ␊ρ",
	}, { // 3862
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "?\nδ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λι␊",
		out:  "?\nδ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λι‛␊",
	}, { // 3863
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "?␊δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λι␊",
		out:  "?␊δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λι‛␊",
	}, { // 3864
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ\nρ",
		out:  "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ\nρ",
	}, { // 3865
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ␊ρ",
		out:  "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ␊ρ",
	}, { // 3866
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ\n␊",
		out:  "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ\n‛␊",
	}, { // 3867
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ␊␊",
		out:  "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λ␊‛␊",
	}, { // 3868
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λι\n",
		out:  "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λι␊",
	}, { // 3869
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λι␊",
		out:  "?＞δ␗␇\x16<\x13Ｍ4\n\x064：␚τ␉ｄ\uff00q？Cχ\x1f!ｍ!λι‛␊",
	}, { // 3870
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ＼",
		out:  "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ＼",
	}, { // 3871
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\v␋／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ＼",
		out:  "\v␋／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ＼",
	}, { // 3872
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␋␋／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ＼",
		out:  "␋␋／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ＼",
	}, { // 3873
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\v＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω␋＼",
		out:  "\v＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω␋＼",
	}, { // 3874
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␋＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω␋＼",
		out:  "␋＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω␋＼",
	}, { // 3875
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\v＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ␋",
		out:  "\v＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ‛␋",
	}, { // 3876
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␋＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ␋",
		out:  "␋＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ‛␋",
	}, { // 3877
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Ｘ\v／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ＼",
		out:  "Ｘ\v／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ＼",
	}, { // 3878
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Ｘ␋／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ＼",
		out:  "Ｘ␋／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ＼",
	}, { // 3879
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Ｘ\v／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω␋＼",
		out:  "Ｘ\v／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω␋＼",
	}, { // 3880
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Ｘ␋／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω␋＼",
		out:  "Ｘ␋／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω␋＼",
	}, { // 3881
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Ｘ\v／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ␋",
		out:  "Ｘ\v／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ‛␋",
	}, { // 3882
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Ｘ␋／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ␋",
		out:  "Ｘ␋／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ‛␋",
	}, { // 3883
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω\v＼",
		out:  "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω\v＼",
	}, { // 3884
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω␋＼",
		out:  "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω␋＼",
	}, { // 3885
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω\v␋",
		out:  "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω\v‛␋",
	}, { // 3886
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω␋␋",
		out:  "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ω␋‛␋",
	}, { // 3887
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ\v",
		out:  "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ␋",
	}, { // 3888
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ␋",
		out:  "Ｘ＂／｛.␏＊１＜{\v\x10\x1eM\x05ζ*ηB>ｉ？θ＠\x0fα1ωβ‛␋",
	}, { // 3889
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP&",
		out:  "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP&",
	}, { // 3890
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\r␍\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP&",
		out:  "\r␍\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP&",
	}, { // 3891
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍␍\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP&",
		out:  "␍␍\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP&",
	}, { // 3892
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\r␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ␍&",
		out:  "\r␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ␍&",
	}, { // 3893
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ␍&",
		out:  "␍␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ␍&",
	}, { // 3894
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\r␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP␍",
		out:  "\r␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP‛␍",
	}, { // 3895
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP␍",
		out:  "␍␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP‛␍",
	}, { // 3896
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "κ\r\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP&",
		out:  "κ\r\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP&",
	}, { // 3897
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "κ␍\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP&",
		out:  "κ␍\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP&",
	}, { // 3898
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "κ\r\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ␍&",
		out:  "κ\r\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ␍&",
	}, { // 3899
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "κ␍\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ␍&",
		out:  "κ␍\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ␍&",
	}, { // 3900
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "κ\r\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP␍",
		out:  "κ\r\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP‛␍",
	}, { // 3901
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "κ␍\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP␍",
		out:  "κ␍\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP‛␍",
	}, { // 3902
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ\r&",
		out:  "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ\r&",
	}, { // 3903
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ␍&",
		out:  "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ␍&",
	}, { // 3904
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ\r␍",
		out:  "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ\r‛␍",
	}, { // 3905
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ␍␍",
		out:  "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖ␍‛␍",
	}, { // 3906
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP\r",
		out:  "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP␍",
	}, { // 3907
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP␍",
		out:  "κ␇\x02υδτ#＞|\x1e\rDｒ/␙ｓ\"ο\x1d＿␂\x17＊␗υ：zｖP‛␍",
	}, { // 3908
		mask: EncodeLeftSpace,
		in:   "  ",
		out:  "␠ ",
	}, { // 3909
		mask: EncodeLeftPeriod,
		in:   "..",
		out:  "．.",
	}, { // 3910
		mask: EncodeLeftTilde,
		in:   "~~",
		out:  "～~",
	}, { // 3911
		mask: EncodeRightSpace,
		in:   "  ",
		out:  " ␠",
	}, { // 3912
		mask: EncodeRightPeriod,
		in:   "..",
		out:  ".．",
	}, { // 3913
		mask: EncodeLeftSpace | EncodeRightPeriod,
		in:   " .",
		out:  "␠．",
	}, { // 3914
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   " ",
		out:  "␠",
	}, { // 3915
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   "  ",
		out:  "␠␠",
	}, { // 3916
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   "   ",
		out:  "␠ ␠",
	}, { // 3917
		mask: EncodeLeftPeriod | EncodeRightPeriod,
		in:   "...",
		out:  "．.．",
	}, { // %!d(MISSING)
		mask: EncodeRightPeriod | EncodeRightSpace,
		in:   "a. ",
		out:  "a.␠",
	}, { // %!d(MISSING)
		mask: EncodeRightPeriod | EncodeRightSpace,
		in:   "a .",
		out:  "a ．",
	},
}

var testCasesDoubleEdge = []testCase{
	{ // 0
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .\x1aδＶδ␐δ:γ２␞␐␎:ｃＶθ`φ［g\x14\b４#:␡.␍",
		out:  "␠.\x1aδＶδ␐δ:γ２␞␐␎:ｃＶθ`φ［g\x14\b４#:␡.␍",
	}, { // 1
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.\x1aδＶδ␐δ:γ２␞␐␎:ｃＶθ`φ［g\x14\b４#:␡.␍",
		out:  "‛␠.\x1aδＶδ␐δ:γ２␞␐␎:ｃＶθ`φ［g\x14\b４#:␡.␍",
	}, { // 2
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "~.\x1aδＶδ␐δ:γ２␞␐␎:ｃＶθ`φ［g\x14\b４#:␡. ",
		out:  "~.\x1aδＶδ␐δ:γ２␞␐␎:ｃＶθ`φ［g\x14\b４#:␡. ",
	}, { // 3
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "~.\x1aδＶδ␐δ:γ２␞␐␎:ｃＶθ`φ［g\x14\b４#:␡.␠",
		out:  "~.\x1aδＶδ␐δ:γ２␞␐␎:ｃＶθ`φ［g\x14\b４#:␡.␠",
	}, { // 4
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .］>d5．？κ␄s／＂Ｐτ␓Ｘ;ω@r\x1bＹσ\x14\x10＠␁.ζ",
		out:  "␠.］>d5．？κ␄s‛／＂Ｐτ␓Ｘ;ω@r\x1bＹσ\x14\x10＠␁.ζ",
	}, { // 5
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.］>d5．？κ␄s／＂Ｐτ␓Ｘ;ω@r\x1bＹσ\x14\x10＠␁.ζ",
		out:  "‛␠.］>d5．？κ␄s‛／＂Ｐτ␓Ｘ;ω@r\x1bＹσ\x14\x10＠␁.ζ",
	}, { // 6
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x1f.］>d5．？κ␄s／＂Ｐτ␓Ｘ;ω@r\x1bＹσ\x14\x10＠␁. ",
		out:  "\x1f.］>d5．？κ␄s‛／＂Ｐτ␓Ｘ;ω@r\x1bＹσ\x14\x10＠␁. ",
	}, { // 7
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x1f.］>d5．？κ␄s／＂Ｐτ␓Ｘ;ω@r\x1bＹσ\x14\x10＠␁.␠",
		out:  "\x1f.］>d5．？κ␄s‛／＂Ｐτ␓Ｘ;ω@r\x1bＹσ\x14\x10＠␁.␠",
	}, { // 8
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .\u007fi＄␁.␐χ\x17|\x15＼ξ５␆αＰvεｙς`ｇZ\x0f\x1f␍.＠",
		out:  "␠.\u007fi＄␁.␐χ\x17|\x15＼ξ５␆αＰvεｙς`ｇZ\x0f\x1f␍.＠",
	}, { // 9
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.\u007fi＄␁.␐χ\x17|\x15＼ξ５␆αＰvεｙς`ｇZ\x0f\x1f␍.＠",
		out:  "‛␠.\u007fi＄␁.␐χ\x17|\x15＼ξ５␆αＰvεｙς`ｇZ\x0f\x1f␍.＠",
	}, { // 10
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ο.\u007fi＄␁.␐χ\x17|\x15＼ξ５␆αＰvεｙς`ｇZ\x0f\x1f␍. ",
		out:  "ο.\u007fi＄␁.␐χ\x17|\x15＼ξ５␆αＰvεｙς`ｇZ\x0f\x1f␍. ",
	}, { // 11
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ο.\u007fi＄␁.␐χ\x17|\x15＼ξ５␆αＰvεｙς`ｇZ\x0f\x1f␍.␠",
		out:  "ο.\u007fi＄␁.␐χ\x17|\x15＼ξ５␆αＰvεｙς`ｇZ\x0f\x1f␍.␠",
	}, { // 12
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␈３'．ｙ␔0？␊~\x02ςχρ？ι\x12:␟γ/C*A\x02ι.T",
		out:  "␠.␈３'．ｙ␔0？␊~\x02ςχρ？ι\x12:␟γ/C*A\x02ι.T",
	}, { // 13
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␈３'．ｙ␔0？␊~\x02ςχρ？ι\x12:␟γ/C*A\x02ι.T",
		out:  "‛␠.␈３'．ｙ␔0？␊~\x02ςχρ？ι\x12:␟γ/C*A\x02ι.T",
	}, { // 14
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "＞.␈３'．ｙ␔0？␊~\x02ςχρ？ι\x12:␟γ/C*A\x02ι. ",
		out:  "＞.␈３'．ｙ␔0？␊~\x02ςχρ？ι\x12:␟γ/C*A\x02ι. ",
	}, { // 15
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "＞.␈３'．ｙ␔0？␊~\x02ςχρ？ι\x12:␟γ/C*A\x02ι.␠",
		out:  "＞.␈３'．ｙ␔0？␊~\x02ςχρ？ι\x12:␟γ/C*A\x02ι.␠",
	}, { // 16
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␙Ｊ／：＞｀?␇*zＱ'|φ␖＿ψα)σαｎG'｛G.\f",
		out:  "␠.␙Ｊ／：‛＞｀?␇*zＱ'|φ␖＿ψα)σαｎG'｛G.\f",
	}, { // 17
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␙Ｊ／：＞｀?␇*zＱ'|φ␖＿ψα)σαｎG'｛G.\f",
		out:  "‛␠.␙Ｊ／：‛＞｀?␇*zＱ'|φ␖＿ψα)σαｎG'｛G.\f",
	}, { // 18
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ψ.␙Ｊ／：＞｀?␇*zＱ'|φ␖＿ψα)σαｎG'｛G. ",
		out:  "ψ.␙Ｊ／：‛＞｀?␇*zＱ'|φ␖＿ψα)σαｎG'｛G. ",
	}, { // 19
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ψ.␙Ｊ／：＞｀?␇*zＱ'|φ␖＿ψα)σαｎG'｛G.␠",
		out:  "ψ.␙Ｊ／：‛＞｀?␇*zＱ'|φ␖＿ψα)σαｎG'｛G.␠",
	}, { // 20
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .｜\x1e\x03␏＋}:｜７＊␟\x05～λφα，vnζκz'\x01＾l.␀",
		out:  "␠.｜\x1e\x03␏＋}:｜７＊␟\x05～λφα，vnζκz'\x01＾l.‛␀",
	}, { // 21
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.｜\x1e\x03␏＋}:｜７＊␟\x05～λφα，vnζκz'\x01＾l.␀",
		out:  "‛␠.｜\x1e\x03␏＋}:｜７＊␟\x05～λφα，vnζκz'\x01＾l.‛␀",
	}, { // 22
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "t.｜\x1e\x03␏＋}:｜７＊␟\x05～λφα，vnζκz'\x01＾l. ",
		out:  "t.｜\x1e\x03␏＋}:｜７＊␟\x05～λφα，vnζκz'\x01＾l. ",
	}, { // 23
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "t.｜\x1e\x03␏＋}:｜７＊␟\x05～λφα，vnζκz'\x01＾l.␠",
		out:  "t.｜\x1e\x03␏＋}:｜７＊␟\x05～λφα，vnζκz'\x01＾l.␠",
	}, { // 24
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .γ／／＄xTＰυ＊s\\M｜\r３Dφ：?␋Ｚ\v\x1dυ＃β.\x11",
		out:  "␠.γ／／＄xTＰυ＊s\\M｜\r３Dφ：?␋Ｚ\v\x1dυ＃β.\x11",
	}, { // 25
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.γ／／＄xTＰυ＊s\\M｜\r３Dφ：?␋Ｚ\v\x1dυ＃β.\x11",
		out:  "‛␠.γ／／＄xTＰυ＊s\\M｜\r３Dφ：?␋Ｚ\v\x1dυ＃β.\x11",
	}, { // 26
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ι.γ／／＄xTＰυ＊s\\M｜\r３Dφ：?␋Ｚ\v\x1dυ＃β. ",
		out:  "ι.γ／／＄xTＰυ＊s\\M｜\r３Dφ：?␋Ｚ\v\x1dυ＃β. ",
	}, { // 27
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ι.γ／／＄xTＰυ＊s\\M｜\r３Dφ：?␋Ｚ\v\x1dυ＃β.␠",
		out:  "ι.γ／／＄xTＰυ＊s\\M｜\r３Dφ：?␋Ｚ\v\x1dυ＃β.␠",
	}, { // 28
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␓␛\x13ｃ\x1a␏\r|iC＃␎λλ＼\x1b␙~＃αω4＝φοn.Ｘ",
		out:  "␠.␓␛\x13ｃ\x1a␏\r|iC＃␎λλ＼\x1b␙~＃αω4＝φοn.Ｘ",
	}, { // 29
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␓␛\x13ｃ\x1a␏\r|iC＃␎λλ＼\x1b␙~＃αω4＝φοn.Ｘ",
		out:  "‛␠.␓␛\x13ｃ\x1a␏\r|iC＃␎λλ＼\x1b␙~＃αω4＝φοn.Ｘ",
	}, { // 30
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "].␓␛\x13ｃ\x1a␏\r|iC＃␎λλ＼\x1b␙~＃αω4＝φοn. ",
		out:  "].␓␛\x13ｃ\x1a␏\r|iC＃␎λλ＼\x1b␙~＃αω4＝φοn. ",
	}, { // 31
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "].␓␛\x13ｃ\x1a␏\r|iC＃␎λλ＼\x1b␙~＃αω4＝φοn.␠",
		out:  "].␓␛\x13ｃ\x1a␏\r|iC＃␎λλ＼\x1b␙~＃αω4＝φοn.␠",
	}, { // 32
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " ./Gｘ␄␒\x14ω?J(␌！w␓\x05\x00ιｅ␁ψηＲωδ＼\x11.ｆ",
		out:  "␠./Gｘ␄␒\x14ω？J(␌！w␓\x05␀ιｅ␁ψηＲωδ＼\x11.ｆ",
	}, { // 33
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠./Gｘ␄␒\x14ω?J(␌！w␓\x05\x00ιｅ␁ψηＲωδ＼\x11.ｆ",
		out:  "‛␠./Gｘ␄␒\x14ω？J(␌！w␓\x05␀ιｅ␁ψηＲωδ＼\x11.ｆ",
	}, { // 34
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "（./Gｘ␄␒\x14ω?J(␌！w␓\x05\x00ιｅ␁ψηＲωδ＼\x11. ",
		out:  "（./Gｘ␄␒\x14ω？J(␌！w␓\x05␀ιｅ␁ψηＲωδ＼\x11. ",
	}, { // 35
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "（./Gｘ␄␒\x14ω?J(␌！w␓\x05\x00ιｅ␁ψηＲωδ＼\x11.␠",
		out:  "（./Gｘ␄␒\x14ω？J(␌！w␓\x05␀ιｅ␁ψηＲωδ＼\x11.␠",
	}, { // 36
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .５｜QδζJ\u007f;$ν%␗ＣＭ\x0e␉\x00ξ：␡ιｅ*τ＊\n.}",
		out:  "␠.５｜QδζJ\u007f;$ν%␗ＣＭ\x0e␉␀ξ：␡ιｅ＊τ‛＊\n.}",
	}, { // 37
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.５｜QδζJ\u007f;$ν%␗ＣＭ\x0e␉\x00ξ：␡ιｅ*τ＊\n.}",
		out:  "‛␠.５｜QδζJ\u007f;$ν%␗ＣＭ\x0e␉␀ξ：␡ιｅ＊τ‛＊\n.}",
	}, { // 38
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␝.５｜QδζJ\u007f;$ν%␗ＣＭ\x0e␉\x00ξ：␡ιｅ*τ＊\n. ",
		out:  "␝.５｜QδζJ\u007f;$ν%␗ＣＭ\x0e␉␀ξ：␡ιｅ＊τ‛＊\n. ",
	}, { // 39
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␝.５｜QδζJ\u007f;$ν%␗ＣＭ\x0e␉\x00ξ：␡ιｅ*τ＊\n.␠",
		out:  "␝.５｜QδζJ\u007f;$ν%␗ＣＭ\x0e␉␀ξ：␡ιｅ＊τ‛＊\n.␠",
	}, { // 40
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .５%E＝Cv\rＮδςη%␍\x17＝＂\x01\nν＂/ε(ω Ｑ.␍",
		out:  "␠.５%E＝Cv\rＮδςη%␍\x17＝＂\x01\nν＂/ε(ω Ｑ.␍",
	}, { // 41
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.５%E＝Cv\rＮδςη%␍\x17＝＂\x01\nν＂/ε(ω Ｑ.␍",
		out:  "‛␠.５%E＝Cv\rＮδςη%␍\x17＝＂\x01\nν＂/ε(ω Ｑ.␍",
	}, { // 42
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "＿.５%E＝Cv\rＮδςη%␍\x17＝＂\x01\nν＂/ε(ω Ｑ. ",
		out:  "＿.５%E＝Cv\rＮδςη%␍\x17＝＂\x01\nν＂/ε(ω Ｑ. ",
	}, { // 43
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "＿.５%E＝Cv\rＮδςη%␍\x17＝＂\x01\nν＂/ε(ω Ｑ.␠",
		out:  "＿.５%E＝Cv\rＮδςη%␍\x17＝＂\x01\nν＂/ε(ω Ｑ.␠",
	}, { // 44
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .β?α＂=\x18υ\x1d\x03ｅV␍ι＇(ＢeY０／Ｅψ％\x17Ｑ\\.ι",
		out:  "␠.β?α＂=\x18υ\x1d\x03ｅV␍ι＇(ＢeY０／Ｅψ％\x17Ｑ\\.ι",
	}, { // 45
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.β?α＂=\x18υ\x1d\x03ｅV␍ι＇(ＢeY０／Ｅψ％\x17Ｑ\\.ι",
		out:  "‛␠.β?α＂=\x18υ\x1d\x03ｅV␍ι＇(ＢeY０／Ｅψ％\x17Ｑ\\.ι",
	}, { // 46
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␟.β?α＂=\x18υ\x1d\x03ｅV␍ι＇(ＢeY０／Ｅψ％\x17Ｑ\\. ",
		out:  "␟.β?α＂=\x18υ\x1d\x03ｅV␍ι＇(ＢeY０／Ｅψ％\x17Ｑ\\. ",
	}, { // 47
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␟.β?α＂=\x18υ\x1d\x03ｅV␍ι＇(ＢeY０／Ｅψ％\x17Ｑ\\.␠",
		out:  "␟.β?α＂=\x18υ\x1d\x03ｅV␍ι＇(ＢeY０／Ｅψ％\x17Ｑ\\.␠",
	}, { // 48
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .\x1e｛μο｀２＊`ｔ␗＆&\x12Yυ'β␘␅Ｗ*αy_α＇.V",
		out:  "␠.\x1e｛μο｀２＊`ｔ␗＆&\x12Yυ'β␘␅Ｗ*αy_α＇.V",
	}, { // 49
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.\x1e｛μο｀２＊`ｔ␗＆&\x12Yυ'β␘␅Ｗ*αy_α＇.V",
		out:  "‛␠.\x1e｛μο｀２＊`ｔ␗＆&\x12Yυ'β␘␅Ｗ*αy_α＇.V",
	}, { // 50
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x13.\x1e｛μο｀２＊`ｔ␗＆&\x12Yυ'β␘␅Ｗ*αy_α＇. ",
		out:  "\x13.\x1e｛μο｀２＊`ｔ␗＆&\x12Yυ'β␘␅Ｗ*αy_α＇. ",
	}, { // 51
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x13.\x1e｛μο｀２＊`ｔ␗＆&\x12Yυ'β␘␅Ｗ*αy_α＇.␠",
		out:  "\x13.\x1e｛μο｀２＊`ｔ␗＆&\x12Yυ'β␘␅Ｗ*αy_α＇.␠",
	}, { // 52
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .:χ（νU'?=ｍμＨ\n\x11␟ｔｏ9β＞：␝^π\x10＋ς.␇",
		out:  "␠.:χ（νU'?=ｍμＨ\n\x11␟ｔｏ9β＞：␝^π\x10＋ς.␇",
	}, { // 53
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.:χ（νU'?=ｍμＨ\n\x11␟ｔｏ9β＞：␝^π\x10＋ς.␇",
		out:  "‛␠.:χ（νU'?=ｍμＨ\n\x11␟ｔｏ9β＞：␝^π\x10＋ς.␇",
	}, { // 54
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x1a.:χ（νU'?=ｍμＨ\n\x11␟ｔｏ9β＞：␝^π\x10＋ς. ",
		out:  "\x1a.:χ（νU'?=ｍμＨ\n\x11␟ｔｏ9β＞：␝^π\x10＋ς. ",
	}, { // 55
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x1a.:χ（νU'?=ｍμＨ\n\x11␟ｔｏ9β＞：␝^π\x10＋ς.␠",
		out:  "\x1a.:χ（νU'?=ｍμＨ\n\x11␟ｔｏ9β＞：␝^π\x10＋ς.␠",
	}, { // 56
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " ./\x14φｕ␔␘hSｋＺχ␉␕ｍ\"ο␏＇\x04ρｔc\x17κ\uff00R.\u007f",
		out:  "␠./\x14φｕ␔␘hSｋＺχ␉␕ｍ\"ο␏＇\x04ρｔc\x17κ\uff00R.\u007f",
	}, { // 57
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠./\x14φｕ␔␘hSｋＺχ␉␕ｍ\"ο␏＇\x04ρｔc\x17κ\uff00R.\u007f",
		out:  "‛␠./\x14φｕ␔␘hSｋＺχ␉␕ｍ\"ο␏＇\x04ρｔc\x17κ\uff00R.\u007f",
	}, { // 58
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "k./\x14φｕ␔␘hSｋＺχ␉␕ｍ\"ο␏＇\x04ρｔc\x17κ\uff00R. ",
		out:  "k./\x14φｕ␔␘hSｋＺχ␉␕ｍ\"ο␏＇\x04ρｔc\x17κ\uff00R. ",
	}, { // 59
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "k./\x14φｕ␔␘hSｋＺχ␉␕ｍ\"ο␏＇\x04ρｔc\x17κ\uff00R.␠",
		out:  "k./\x14φｕ␔␘hSｋＺχ␉␕ｍ\"ο␏＇\x04ρｔc\x17κ\uff00R.␠",
	}, { // 60
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .\a\aσ＞＼Ｙｌθ␞l\r\x0f\x05φςL＝<Ｙo4ｃ＂νσ~.␓",
		out:  "␠.\a\aσ＞＼Ｙｌθ␞l\r\x0f\x05φςL＝<Ｙo4ｃ＂νσ~.␓",
	}, { // 61
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.\a\aσ＞＼Ｙｌθ␞l\r\x0f\x05φςL＝<Ｙo4ｃ＂νσ~.␓",
		out:  "‛␠.\a\aσ＞＼Ｙｌθ␞l\r\x0f\x05φςL＝<Ｙo4ｃ＂νσ~.␓",
	}, { // 62
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "．.\a\aσ＞＼Ｙｌθ␞l\r\x0f\x05φςL＝<Ｙo4ｃ＂νσ~. ",
		out:  "‛．.\a\aσ＞＼Ｙｌθ␞l\r\x0f\x05φςL＝<Ｙo4ｃ＂νσ~. ",
	}, { // 63
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "．.\a\aσ＞＼Ｙｌθ␞l\r\x0f\x05φςL＝<Ｙo4ｃ＂νσ~.␠",
		out:  "‛．.\a\aσ＞＼Ｙｌθ␞l\r\x0f\x05φςL＝<Ｙo4ｃ＂νσ~.␠",
	}, { // 64
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␔\fςυC\x15μ\x13\aＤ␟｜␖］ςPｇI\x10\x06␐oα／＃%.υ",
		out:  "␠.‛␔␌ςυC␕μ␓␇Ｄ‛␟｜‛␖］ςPｇI␐␆‛␐oα／＃%.υ",
	}, { // 65
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␔\fςυC\x15μ\x13\aＤ␟｜␖］ςPｇI\x10\x06␐oα／＃%.υ",
		out:  "‛␠.‛␔␌ςυC␕μ␓␇Ｄ‛␟｜‛␖］ςPｇI␐␆‛␐oα／＃%.υ",
	}, { // 66
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "F.␔\fςυC\x15μ\x13\aＤ␟｜␖］ςPｇI\x10\x06␐oα／＃%. ",
		out:  "F.‛␔␌ςυC␕μ␓␇Ｄ‛␟｜‛␖］ςPｇI␐␆‛␐oα／＃%. ",
	}, { // 67
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "F.␔\fςυC\x15μ\x13\aＤ␟｜␖］ςPｇI\x10\x06␐oα／＃%.␠",
		out:  "F.‛␔␌ςυC␕μ␓␇Ｄ‛␟｜‛␖］ςPｇI␐␆‛␐oα／＃%.␠",
	}, { // 68
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~j\f\x1c＼｀C＄ββ4（␑M8κ＄ｓς`␕｀ω\"$>２~χ",
		out:  "␠~j\f\x1c＼｀C＄ββ4（␑M8κ＄ｓς`␕｀ω\"$>２~χ",
	}, { // 69
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~j\f\x1c＼｀C＄ββ4（␑M8κ＄ｓς`␕｀ω\"$>２~χ",
		out:  "‛␠~j\f\x1c＼｀C＄ββ4（␑M8κ＄ｓς`␕｀ω\"$>２~χ",
	}, { // 70
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   "（~j\f\x1c＼｀C＄ββ4（␑M8κ＄ｓς`␕｀ω\"$>２~ ",
		out:  "（~j\f\x1c＼｀C＄ββ4（␑M8κ＄ｓς`␕｀ω\"$>２~ ",
	}, { // 71
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   "（~j\f\x1c＼｀C＄ββ4（␑M8κ＄ｓς`␕｀ω\"$>２~␠",
		out:  "（~j\f\x1c＼｀C＄ββ4（␑M8κ＄ｓς`␕｀ω\"$>２~␠",
	}, { // 72
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~\x00Ｄ&\vω␂␊Fｚω␉Wｓηα\x17/ｙλ␟［＄E␞ξＣ~/",
		out:  "␠~␀Ｄ&\vω␂␊Fｚω␉Wｓηα\x17／ｙλ␟［＄E␞ξＣ~／",
	}, { // 73
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~\x00Ｄ&\vω␂␊Fｚω␉Wｓηα\x17/ｙλ␟［＄E␞ξＣ~/",
		out:  "‛␠~␀Ｄ&\vω␂␊Fｚω␉Wｓηα\x17／ｙλ␟［＄E␞ξＣ~／",
	}, { // 74
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "R~\x00Ｄ&\vω␂␊Fｚω␉Wｓηα\x17/ｙλ␟［＄E␞ξＣ~ ",
		out:  "R~␀Ｄ&\vω␂␊Fｚω␉Wｓηα\x17／ｙλ␟［＄E␞ξＣ~ ",
	}, { // 75
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "R~\x00Ｄ&\vω␂␊Fｚω␉Wｓηα\x17/ｙλ␟［＄E␞ξＣ~␠",
		out:  "R~␀Ｄ&\vω␂␊Fｚω␉Wｓηα\x17／ｙλ␟［＄E␞ξＣ~␠",
	}, { // 76
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~βa'Ｘξ␊Ｖ\x18Z\x11β␊␚Ｔς\\m\x13JＴ]␎\x04g１！~ζ",
		out:  "␠~βa＇Ｘξ␊Ｖ\x18Z\x11β␊␚Ｔς\\m\x13JＴ]␎\x04g１！~ζ",
	}, { // 77
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~βa'Ｘξ␊Ｖ\x18Z\x11β␊␚Ｔς\\m\x13JＴ]␎\x04g１！~ζ",
		out:  "‛␠~βa＇Ｘξ␊Ｖ\x18Z\x11β␊␚Ｔς\\m\x13JＴ]␎\x04g１！~ζ",
	}, { // 78
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ν~βa'Ｘξ␊Ｖ\x18Z\x11β␊␚Ｔς\\m\x13JＴ]␎\x04g１！~ ",
		out:  "ν~βa＇Ｘξ␊Ｖ\x18Z\x11β␊␚Ｔς\\m\x13JＴ]␎\x04g１！~ ",
	}, { // 79
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ν~βa'Ｘξ␊Ｖ\x18Z\x11β␊␚Ｔς\\m\x13JＴ]␎\x04g１！~␠",
		out:  "ν~βa＇Ｘξ␊Ｖ\x18Z\x11β␊␚Ｔς\\m\x13JＴ]␎\x04g１！~␠",
	}, { // 80
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ξμ#ｚδ＠iG!＜：␖\x0f>ηz␇␂\u007f\v\v\aζＳλ␎~｛",
		out:  "␠~ξμ#ｚδ＠iG!＜：␖\x0f>ηz␇␂\u007f\v\v\aζＳλ␎~｛",
	}, { // 81
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ξμ#ｚδ＠iG!＜：␖\x0f>ηz␇␂\u007f\v\v\aζＳλ␎~｛",
		out:  "‛␠~ξμ#ｚδ＠iG!＜：␖\x0f>ηz␇␂\u007f\v\v\aζＳλ␎~｛",
	}, { // 82
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｎ~ξμ#ｚδ＠iG!＜：␖\x0f>ηz␇␂\u007f\v\v\aζＳλ␎~ ",
		out:  "ｎ~ξμ#ｚδ＠iG!＜：␖\x0f>ηz␇␂\u007f\v\v\aζＳλ␎~ ",
	}, { // 83
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｎ~ξμ#ｚδ＠iG!＜：␖\x0f>ηz␇␂\u007f\v\v\aζＳλ␎~␠",
		out:  "ｎ~ξμ#ｚδ＠iG!＜：␖\x0f>ηz␇␂\u007f\v\v\aζＳλ␎~␠",
	}, { // 84
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~\bςｌ>τεκＮ:｀Sυ％,2ｏｖ\x01Ｈ\x00[␞｀␊ι␀~\x12",
		out:  "␠~\bςｌ＞τεκＮ:｀Sυ％,2ｏｖ\x01Ｈ␀[␞｀␊ι‛␀~\x12",
	}, { // 85
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~\bςｌ>τεκＮ:｀Sυ％,2ｏｖ\x01Ｈ\x00[␞｀␊ι␀~\x12",
		out:  "‛␠~\bςｌ＞τεκＮ:｀Sυ％,2ｏｖ\x01Ｈ␀[␞｀␊ι‛␀~\x12",
	}, { // 86
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\x0e~\bςｌ>τεκＮ:｀Sυ％,2ｏｖ\x01Ｈ\x00[␞｀␊ι␀~ ",
		out:  "\x0e~\bςｌ＞τεκＮ:｀Sυ％,2ｏｖ\x01Ｈ␀[␞｀␊ι‛␀~ ",
	}, { // 87
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\x0e~\bςｌ>τεκＮ:｀Sυ％,2ｏｖ\x01Ｈ\x00[␞｀␊ι␀~␠",
		out:  "\x0e~\bςｌ＞τεκＮ:｀Sυ％,2ｏｖ\x01Ｈ␀[␞｀␊ι‛␀~␠",
	}, { // 88
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~\x19␘％＼|λ\bσＭ！ξ８\x13APLＫ\x01$␒Ｚς\x1dχ@：~η",
		out:  "␠~\x19␘％＼|λ\bσＭ！ξ８\x13APLＫ\x01＄␒Ｚς\x1dχ@：~η",
	}, { // 89
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~\x19␘％＼|λ\bσＭ！ξ８\x13APLＫ\x01$␒Ｚς\x1dχ@：~η",
		out:  "‛␠~\x19␘％＼|λ\bσＭ！ξ８\x13APLＫ\x01＄␒Ｚς\x1dχ@：~η",
	}, { // 90
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   "％~\x19␘％＼|λ\bσＭ！ξ８\x13APLＫ\x01$␒Ｚς\x1dχ@：~ ",
		out:  "％~\x19␘％＼|λ\bσＭ！ξ８\x13APLＫ\x01＄␒Ｚς\x1dχ@：~ ",
	}, { // 91
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   "％~\x19␘％＼|λ\bσＭ！ξ８\x13APLＫ\x01$␒Ｚς\x1dχ@：~␠",
		out:  "％~\x19␘％＼|λ\bσＭ！ξ８\x13APLＫ\x01＄␒Ｚς\x1dχ@：~␠",
	}, { // 92
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ψ␌＃ισｄν␜J\x1c␜Qｄπβ\x15％␈␝$Ｃat\x03\x16=~（",
		out:  "␠~ψ␌＃ισｄν␜J\x1c␜Qｄπβ\x15％␈␝$Ｃat\x03\x16=~（",
	}, { // 93
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ψ␌＃ισｄν␜J\x1c␜Qｄπβ\x15％␈␝$Ｃat\x03\x16=~（",
		out:  "‛␠~ψ␌＃ισｄν␜J\x1c␜Qｄπβ\x15％␈␝$Ｃat\x03\x16=~（",
	}, { // 94
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "W~ψ␌＃ισｄν␜J\x1c␜Qｄπβ\x15％␈␝$Ｃat\x03\x16=~ ",
		out:  "W~ψ␌＃ισｄν␜J\x1c␜Qｄπβ\x15％␈␝$Ｃat\x03\x16=~ ",
	}, { // 95
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "W~ψ␌＃ισｄν␜J\x1c␜Qｄπβ\x15％␈␝$Ｃat\x03\x16=~␠",
		out:  "W~ψ␌＃ισｄν␜J\x1c␜Qｄπβ\x15％␈␝$Ｃat\x03\x16=~␠",
	}, { // 96
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~θ<κ＄Ｄ␒\r％１θ␌]\x15␌ｔoｅσ$+I\n1␅iλ~η",
		out:  "␠~θ<κ＄Ｄ␒\r％１θ␌]\x15␌ｔoｅσ$+I\n1␅iλ~η",
	}, { // 97
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~θ<κ＄Ｄ␒\r％１θ␌]\x15␌ｔoｅσ$+I\n1␅iλ~η",
		out:  "‛␠~θ<κ＄Ｄ␒\r％１θ␌]\x15␌ｔoｅσ$+I\n1␅iλ~η",
	}, { // 98
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｃ~θ<κ＄Ｄ␒\r％１θ␌]\x15␌ｔoｅσ$+I\n1␅iλ~ ",
		out:  "ｃ~θ<κ＄Ｄ␒\r％１θ␌]\x15␌ｔoｅσ$+I\n1␅iλ~ ",
	}, { // 99
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｃ~θ<κ＄Ｄ␒\r％１θ␌]\x15␌ｔoｅσ$+I\n1␅iλ~␠",
		out:  "ｃ~θ<κ＄Ｄ␒\r％１θ␌]\x15␌ｔoｅσ$+I\n1␅iλ~␠",
	}, { // 100
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~v␒３W␇7T␇$\x0f␈\x11πV］ｅ\"␓CρＩτ\u007fεε\x1a~\uff00",
		out:  "␠~v␒３W␇7T␇$\x0f␈\x11πV］ｅ\"␓CρＩτ\u007fεε\x1a~\uff00",
	}, { // 101
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~v␒３W␇7T␇$\x0f␈\x11πV］ｅ\"␓CρＩτ\u007fεε\x1a~\uff00",
		out:  "‛␠~v␒３W␇7T␇$\x0f␈\x11πV］ｅ\"␓CρＩτ\u007fεε\x1a~\uff00",
	}, { // 102
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␘~v␒３W␇7T␇$\x0f␈\x11πV］ｅ\"␓CρＩτ\u007fεε\x1a~ ",
		out:  "␘~v␒３W␇7T␇$\x0f␈\x11πV］ｅ\"␓CρＩτ\u007fεε\x1a~ ",
	}, { // 103
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␘~v␒３W␇7T␇$\x0f␈\x11πV］ｅ\"␓CρＩτ\u007fεε\x1a~␠",
		out:  "␘~v␒３W␇7T␇$\x0f␈\x11πV］ｅ\"␓CρＩτ\u007fεε\x1a~␠",
	}, { // 104
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~\vｍθ␍`␖':υ～\x19\x10ｂ<αｊρF：␜\v␐oｘθ␐~l",
		out:  "␠~\vｍθ␍`␖':υ～\x19\x10ｂ<αｊρF：␜\v␐oｘθ␐~l",
	}, { // 105
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~\vｍθ␍`␖':υ～\x19\x10ｂ<αｊρF：␜\v␐oｘθ␐~l",
		out:  "‛␠~\vｍθ␍`␖':υ～\x19\x10ｂ<αｊρF：␜\v␐oｘθ␐~l",
	}, { // 106
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   "*~\vｍθ␍`␖':υ～\x19\x10ｂ<αｊρF：␜\v␐oｘθ␐~ ",
		out:  "＊~\vｍθ␍`␖':υ～\x19\x10ｂ<αｊρF：␜\v␐oｘθ␐~ ",
	}, { // 107
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   "*~\vｍθ␍`␖':υ～\x19\x10ｂ<αｊρF：␜\v␐oｘθ␐~␠",
		out:  "＊~\vｍθ␍`␖':υ～\x19\x10ｂ<αｊρF：␜\v␐oｘθ␐~␠",
	}, { // 108
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~：βＱ\x1d\x0e／l␐ｇν>␎Ｐ`４␙␀（}s>\b＞/θξ~σ",
		out:  "␠~：βＱ\x1d\x0e／l␐ｇν>␎Ｐ`４␙‛␀（}s>\b＞/θξ~σ",
	}, { // 109
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~：βＱ\x1d\x0e／l␐ｇν>␎Ｐ`４␙␀（}s>\b＞/θξ~σ",
		out:  "‛␠~：βＱ\x1d\x0e／l␐ｇν>␎Ｐ`４␙‛␀（}s>\b＞/θξ~σ",
	}, { // 110
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   "τ~：βＱ\x1d\x0e／l␐ｇν>␎Ｐ`４␙␀（}s>\b＞/θξ~ ",
		out:  "τ~：βＱ\x1d\x0e／l␐ｇν>␎Ｐ`４␙‛␀（}s>\b＞/θξ~ ",
	}, { // 111
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   "τ~：βＱ\x1d\x0e／l␐ｇν>␎Ｐ`４␙␀（}s>\b＞/θξ~␠",
		out:  "τ~：βＱ\x1d\x0e／l␐ｇν>␎Ｐ`４␙‛␀（}s>\b＞/θξ~␠",
	}, { // 112
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~φT␈\r\x00\x14ｖσｇ␅sμv␂3␊␎＊uθφｆ\\\x01\rY~μ",
		out:  "␠~φT␈\r␀\x14ｖσｇ␅sμv␂3␊␎＊uθφｆ\\\x01\rY~μ",
	}, { // 113
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~φT␈\r\x00\x14ｖσｇ␅sμv␂3␊␎＊uθφｆ\\\x01\rY~μ",
		out:  "‛␠~φT␈\r␀\x14ｖσｇ␅sμv␂3␊␎＊uθφｆ\\\x01\rY~μ",
	}, { // 114
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｎ~φT␈\r\x00\x14ｖσｇ␅sμv␂3␊␎＊uθφｆ\\\x01\rY~ ",
		out:  "Ｎ~φT␈\r␀\x14ｖσｇ␅sμv␂3␊␎＊uθφｆ\\\x01\rY~ ",
	}, { // 115
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｎ~φT␈\r\x00\x14ｖσｇ␅sμv␂3␊␎＊uθφｆ\\\x01\rY~␠",
		out:  "Ｎ~φT␈\r␀\x14ｖσｇ␅sμv␂3␊␎＊uθφｆ\\\x01\rY~␠",
	}, { // 116
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~␜<ｉμ␟Ｚ）｜0Y\n␕p：H␂γ\x024\a*ρ＇\rφψ~（",
		out:  "␠~␜<ｉμ␟Ｚ）｜0Y\n␕p：H␂γ\x024\a*ρ＇\rφψ~（",
	}, { // 117
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~␜<ｉμ␟Ｚ）｜0Y\n␕p：H␂γ\x024\a*ρ＇\rφψ~（",
		out:  "‛␠~␜<ｉμ␟Ｚ）｜0Y\n␕p：H␂γ\x024\a*ρ＇\rφψ~（",
	}, { // 118
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   "#~␜<ｉμ␟Ｚ）｜0Y\n␕p：H␂γ\x024\a*ρ＇\rφψ~ ",
		out:  "#~␜<ｉμ␟Ｚ）｜0Y\n␕p：H␂γ\x024\a*ρ＇\rφψ~ ",
	}, { // 119
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   "#~␜<ｉμ␟Ｚ）｜0Y\n␕p：H␂γ\x024\a*ρ＇\rφψ~␠",
		out:  "#~␜<ｉμ␟Ｚ）｜0Y\n␕p：H␂γ\x024\a*ρ＇\rφψ~␠",
	}, { // 120
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~␆ｈρν\x1aτ3＼\\＼y\x14６φ␒␚$␉&>m`\x1e4）␝~υ",
		out:  "␠~␆ｈρν\x1aτ3‛＼＼‛＼y\x14６φ␒␚$␉&>m`\x1e4）␝~υ",
	}, { // 121
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~␆ｈρν\x1aτ3＼\\＼y\x14６φ␒␚$␉&>m`\x1e4）␝~υ",
		out:  "‛␠~␆ｈρν\x1aτ3‛＼＼‛＼y\x14６φ␒␚$␉&>m`\x1e4）␝~υ",
	}, { // 122
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "β~␆ｈρν\x1aτ3＼\\＼y\x14６φ␒␚$␉&>m`\x1e4）␝~ ",
		out:  "β~␆ｈρν\x1aτ3‛＼＼‛＼y\x14６φ␒␚$␉&>m`\x1e4）␝~ ",
	}, { // 123
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "β~␆ｈρν\x1aτ3＼\\＼y\x14６φ␒␚$␉&>m`\x1e4）␝~␠",
		out:  "β~␆ｈρν\x1aτ3‛＼＼‛＼y\x14６φ␒␚$␉&>m`\x1e4）␝~␠",
	}, { // 124
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ασ/\x1f\r<␓>Ｍ$;\u007f␋ο＄ξ␡ｏ>＠=ο？Q␃#~ｖ",
		out:  "␠~ασ/\x1f␍<␓>Ｍ$;\u007f␋ο＄ξ␡ｏ>＠=ο？Q␃#~ｖ",
	}, { // 125
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ασ/\x1f\r<␓>Ｍ$;\u007f␋ο＄ξ␡ｏ>＠=ο？Q␃#~ｖ",
		out:  "‛␠~ασ/\x1f␍<␓>Ｍ$;\u007f␋ο＄ξ␡ｏ>＠=ο？Q␃#~ｖ",
	}, { // 126
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｄ~ασ/\x1f\r<␓>Ｍ$;\u007f␋ο＄ξ␡ｏ>＠=ο？Q␃#~ ",
		out:  "ｄ~ασ/\x1f␍<␓>Ｍ$;\u007f␋ο＄ξ␡ｏ>＠=ο？Q␃#~ ",
	}, { // 127
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｄ~ασ/\x1f\r<␓>Ｍ$;\u007f␋ο＄ξ␡ｏ>＠=ο？Q␃#~␠",
		out:  "ｄ~ασ/\x1f␍<␓>Ｍ$;\u007f␋ο＄ξ␡ｏ>＠=ο？Q␃#~␠",
	}, { // 128
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ψp␁␑j␜&Ｅ\x13ν\"]ＴμγＤ\x01｀υ\x12\x1bY␉\x03＿6~＃",
		out:  "␠~ψp␁␑j␜&Ｅ\x13ν\"]ＴμγＤ\x01｀υ\x12\x1bY␉\x03＿6~＃",
	}, { // 129
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ψp␁␑j␜&Ｅ\x13ν\"]ＴμγＤ\x01｀υ\x12\x1bY␉\x03＿6~＃",
		out:  "‛␠~ψp␁␑j␜&Ｅ\x13ν\"]ＴμγＤ\x01｀υ\x12\x1bY␉\x03＿6~＃",
	}, { // 130
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   "υ~ψp␁␑j␜&Ｅ\x13ν\"]ＴμγＤ\x01｀υ\x12\x1bY␉\x03＿6~ ",
		out:  "υ~ψp␁␑j␜&Ｅ\x13ν\"]ＴμγＤ\x01｀υ\x12\x1bY␉\x03＿6~ ",
	}, { // 131
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   "υ~ψp␁␑j␜&Ｅ\x13ν\"]ＴμγＤ\x01｀υ\x12\x1bY␉\x03＿6~␠",
		out:  "υ~ψp␁␑j␜&Ｅ\x13ν\"]ＴμγＤ\x01｀υ\x12\x1bY␉\x03＿6~␠",
	}, { // 132
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~Ｇ␕ｅ_Ｌσｕ\x16m␕\x17ρπ␜w?Ｔ\x05&␜δ｜［οZO~\x19",
		out:  "␠~Ｇ‛␕ｅ_Ｌσｕ␖m‛␕␗ρπ‛␜w?Ｔ␅&‛␜δ｜［οZO~␙",
	}, { // 133
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~Ｇ␕ｅ_Ｌσｕ\x16m␕\x17ρπ␜w?Ｔ\x05&␜δ｜［οZO~\x19",
		out:  "‛␠~Ｇ‛␕ｅ_Ｌσｕ␖m‛␕␗ρπ‛␜w?Ｔ␅&‛␜δ｜［οZO~␙",
	}, { // 134
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   "δ~Ｇ␕ｅ_Ｌσｕ\x16m␕\x17ρπ␜w?Ｔ\x05&␜δ｜［οZO~ ",
		out:  "δ~Ｇ‛␕ｅ_Ｌσｕ␖m‛␕␗ρπ‛␜w?Ｔ␅&‛␜δ｜［οZO~ ",
	}, { // 135
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   "δ~Ｇ␕ｅ_Ｌσｕ\x16m␕\x17ρπ␜w?Ｔ\x05&␜δ｜［οZO~␠",
		out:  "δ~Ｇ‛␕ｅ_Ｌσｕ␖m‛␕␗ρπ‛␜w?Ｔ␅&‛␜δ｜［οZO~␠",
	}, { // 136
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\tD",
		out:  "␠\tρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\tD",
	}, { // 137
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\tD",
		out:  "‛␠\tρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\tD",
	}, { // 138
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\nD",
		out:  "␠\nρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\nD",
	}, { // 139
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\nD",
		out:  "‛␠\nρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\nD",
	}, { // 140
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\vD",
		out:  "␠\vρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\vD",
	}, { // 141
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\vD",
		out:  "‛␠\vρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\vD",
	}, { // 142
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\rD",
		out:  "␠\rρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\rD",
	}, { // 143
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\rD",
		out:  "‛␠\rρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\rD",
	}, { // 144
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｓ\tρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\t ",
		out:  "Ｓ\tρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\t ",
	}, { // 145
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｓ\tρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\t␠",
		out:  "Ｓ\tρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\t␠",
	}, { // 146
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｓ\nρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\n ",
		out:  "Ｓ\nρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\n ",
	}, { // 147
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｓ\nρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\n␠",
		out:  "Ｓ\nρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\n␠",
	}, { // 148
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｓ\vρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\v ",
		out:  "Ｓ\vρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\v ",
	}, { // 149
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｓ\vρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\v␠",
		out:  "Ｓ\vρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\v␠",
	}, { // 150
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｓ\rρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\r ",
		out:  "Ｓ\rρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\r ",
	}, { // 151
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｓ\rρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄␀\x14qａ␓\r␠",
		out:  "Ｓ\rρ␉␔\x17Ｂ%c\x05ω％σ/\aｏρν；Sσ\x1b＄‛␀\x14qａ␓\r␠",
	}, { // 152
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\t␡",
		out:  "␠\t！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\t␡",
	}, { // 153
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\t␡",
		out:  "‛␠\t！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\t␡",
	}, { // 154
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\n␡",
		out:  "␠\n！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\n␡",
	}, { // 155
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\n␡",
		out:  "‛␠\n！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\n␡",
	}, { // 156
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\v␡",
		out:  "␠\v！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\v␡",
	}, { // 157
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\v␡",
		out:  "‛␠\v！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\v␡",
	}, { // 158
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\r␡",
		out:  "␠\r！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\r␡",
	}, { // 159
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\r␡",
		out:  "‛␠\r！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\r␡",
	}, { // 160
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\t！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\t ",
		out:  "‛␍\t！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\t ",
	}, { // 161
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\t！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\t␠",
		out:  "‛␍\t！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\t␠",
	}, { // 162
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\n！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\n ",
		out:  "‛␍\n！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\n ",
	}, { // 163
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\n！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\n␠",
		out:  "‛␍\n！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\n␠",
	}, { // 164
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\v！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\v ",
		out:  "‛␍\v！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\v ",
	}, { // 165
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\v！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\v␠",
		out:  "‛␍\v！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\v␠",
	}, { // 166
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\r！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\r ",
		out:  "‛␍\r！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\r ",
	}, { // 167
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␍\r！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\r␠",
		out:  "‛␍\r！ςπ\"ｇｊο\x05␎?；\x02υ3\x03ςn␖Ｘ␝Ｎ\f\x0eN5χ\r␠",
	}, { // 168
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\t␟",
		out:  "␠\tξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\t␟",
	}, { // 169
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\t␟",
		out:  "‛␠\tξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\t␟",
	}, { // 170
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\n␟",
		out:  "␠\nξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\n␟",
	}, { // 171
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\n␟",
		out:  "‛␠\nξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\n␟",
	}, { // 172
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\v␟",
		out:  "␠\vξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\v␟",
	}, { // 173
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\v␟",
		out:  "‛␠\vξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\v␟",
	}, { // 174
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\r␟",
		out:  "␠\rξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\r␟",
	}, { // 175
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\r␟",
		out:  "‛␠\rξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\r␟",
	}, { // 176
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "e\tξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\t ",
		out:  "e\tξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\t ",
	}, { // 177
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "e\tξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\t␠",
		out:  "e\tξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\t␠",
	}, { // 178
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "e\nξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\n ",
		out:  "e\nξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\n ",
	}, { // 179
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "e\nξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\n␠",
		out:  "e\nξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\n␠",
	}, { // 180
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "e\vξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\v ",
		out:  "e\vξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\v ",
	}, { // 181
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "e\vξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\v␠",
		out:  "e\vξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\v␠",
	}, { // 182
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "e\rξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\r ",
		out:  "e\rξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\r ",
	}, { // 183
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "e\rξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\r␠",
		out:  "e\rξ＞\a？δυ＿\x0f?Ｘ＂ｒ＄*δy#␆a\"υι:ｔ>␖\r␠",
	}, { // 184
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\tｍ",
		out:  "␠\t％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\tｍ",
	}, { // 185
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\tｍ",
		out:  "‛␠\t％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\tｍ",
	}, { // 186
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\nｍ",
		out:  "␠\n％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\nｍ",
	}, { // 187
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\nｍ",
		out:  "‛␠\n％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\nｍ",
	}, { // 188
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\vｍ",
		out:  "␠\v％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\vｍ",
	}, { // 189
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\vｍ",
		out:  "‛␠\v％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\vｍ",
	}, { // 190
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\rｍ",
		out:  "␠\r％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\rｍ",
	}, { // 191
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\rｍ",
		out:  "‛␠\r％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\rｍ",
	}, { // 192
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ａ\t％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\t ",
		out:  "ａ\t％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\t ",
	}, { // 193
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ａ\t％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\t␠",
		out:  "ａ\t％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\t␠",
	}, { // 194
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ａ\n％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\n ",
		out:  "ａ\n％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\n ",
	}, { // 195
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ａ\n％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\n␠",
		out:  "ａ\n％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\n␠",
	}, { // 196
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ａ\v％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\v ",
		out:  "ａ\v％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\v ",
	}, { // 197
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ａ\v％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\v␠",
		out:  "ａ\v％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\v␠",
	}, { // 198
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ａ\r％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\r ",
		out:  "ａ\r％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\r ",
	}, { // 199
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ａ\r％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\r␠",
		out:  "ａ\r％γ\x1a␙␇U|ＭSｚ／\"I\x14\x05␚#\x1aφδ／v␆σ\x1bρ\r␠",
	}, { // 200
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\tψ",
		out:  "␠\tｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\tψ",
	}, { // 201
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\tψ",
		out:  "‛␠\tｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\tψ",
	}, { // 202
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\nψ",
		out:  "␠\nｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\nψ",
	}, { // 203
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\nψ",
		out:  "‛␠\nｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\nψ",
	}, { // 204
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\vψ",
		out:  "␠\vｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\vψ",
	}, { // 205
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\vψ",
		out:  "‛␠\vｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\vψ",
	}, { // 206
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\rψ",
		out:  "␠\rｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\rψ",
	}, { // 207
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\rψ",
		out:  "‛␠\rｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\rψ",
	}, { // 208
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\tｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\t ",
		out:  "λ\tｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\t ",
	}, { // 209
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\tｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\t␠",
		out:  "λ\tｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\t␠",
	}, { // 210
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\nｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\n ",
		out:  "λ\nｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\n ",
	}, { // 211
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\nｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\n␠",
		out:  "λ\nｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\n␠",
	}, { // 212
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\vｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\v ",
		out:  "λ\vｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\v ",
	}, { // 213
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\vｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\v␠",
		out:  "λ\vｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\v␠",
	}, { // 214
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\rｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\r ",
		out:  "λ\rｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\r ",
	}, { // 215
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "λ\rｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\r␠",
		out:  "λ\rｚｈ␎+\rＮ␏\x1b？ν8ξ３%␑/dＰa\x05γ}␜ｉ｜y\r␠",
	}, { // 216
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\tψ",
		out:  "␠\t\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\tψ",
	}, { // 217
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\tψ",
		out:  "‛␠\t\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\tψ",
	}, { // 218
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\nψ",
		out:  "␠\n\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\nψ",
	}, { // 219
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\nψ",
		out:  "‛␠\n\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\nψ",
	}, { // 220
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\vψ",
		out:  "␠\v\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\vψ",
	}, { // 221
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\vψ",
		out:  "‛␠\v\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\vψ",
	}, { // 222
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\rψ",
		out:  "␠\r\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\rψ",
	}, { // 223
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\rψ",
		out:  "‛␠\r\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\rψ",
	}, { // 224
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "z\t\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\t ",
		out:  "z\t\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\t ",
	}, { // 225
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "z\t\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\t␠",
		out:  "z\t\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\t␠",
	}, { // 226
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "z\n\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\n ",
		out:  "z\n\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\n ",
	}, { // 227
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "z\n\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\n␠",
		out:  "z\n\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\n␠",
	}, { // 228
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "z\v\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\v ",
		out:  "z\v\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\v ",
	}, { // 229
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "z\v\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\v␠",
		out:  "z\v\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\v␠",
	}, { // 230
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "z\r\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\r ",
		out:  "z\r\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\r ",
	}, { // 231
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "z\r\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\r␠",
		out:  "z\r\x06ｏι\x18κ[␊＋M␝␔\f\x1fθ\x1f␔θ␅ｚqLu\x18␡ｂμ\r␠",
	}, { // 232
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\t␚",
		out:  "␠\t\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\t␚",
	}, { // 233
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\t␚",
		out:  "‛␠\t\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\t␚",
	}, { // 234
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\n␚",
		out:  "␠\n\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\n␚",
	}, { // 235
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\n␚",
		out:  "‛␠\n\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\n␚",
	}, { // 236
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\v␚",
		out:  "␠\v\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\v␚",
	}, { // 237
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\v␚",
		out:  "‛␠\v\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\v␚",
	}, { // 238
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\r␚",
		out:  "␠\r\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\r␚",
	}, { // 239
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\r␚",
		out:  "‛␠\r\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\r␚",
	}, { // 240
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x13\t\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\t ",
		out:  "\x13\t\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\t ",
	}, { // 241
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x13\t\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\t␠",
		out:  "\x13\t\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\t␠",
	}, { // 242
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x13\n\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\n ",
		out:  "\x13\n\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\n ",
	}, { // 243
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x13\n\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\n␠",
		out:  "\x13\n\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\n␠",
	}, { // 244
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x13\v\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\v ",
		out:  "\x13\v\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\v ",
	}, { // 245
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x13\v\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\v␠",
		out:  "\x13\v\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\v␠",
	}, { // 246
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x13\r\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\r ",
		out:  "\x13\r\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\r ",
	}, { // 247
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x13\r\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\r␠",
		out:  "\x13\r\x02YχE␅Sα\x02ｚπ｀\x15␚ζ<：hｄｋ3\f％γＡ␙␆\r␠",
	}, { // 248
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\tδ",
		out:  "␠\t／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\tδ",
	}, { // 249
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\tδ",
		out:  "‛␠\t／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\tδ",
	}, { // 250
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\nδ",
		out:  "␠\n／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\nδ",
	}, { // 251
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\nδ",
		out:  "‛␠\n／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\nδ",
	}, { // 252
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\vδ",
		out:  "␠\v／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\vδ",
	}, { // 253
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\vδ",
		out:  "‛␠\v／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\vδ",
	}, { // 254
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\rδ",
		out:  "␠\r／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\rδ",
	}, { // 255
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\rδ",
		out:  "‛␠\r／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\rδ",
	}, { // 256
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\n\t／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\t ",
		out:  "␊\t／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\t ",
	}, { // 257
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\n\t／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\t␠",
		out:  "␊\t／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\t␠",
	}, { // 258
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\n\n／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\n ",
		out:  "␊\n／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\n ",
	}, { // 259
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\n\n／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\n␠",
		out:  "␊\n／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\n␠",
	}, { // 260
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\n\v／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\v ",
		out:  "␊\v／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\v ",
	}, { // 261
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\n\v／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\v␠",
		out:  "␊\v／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\v␠",
	}, { // 262
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\n\r／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\r ",
		out:  "␊\r／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\r ",
	}, { // 263
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\n\r／Ｒ␊ε␘λδ:ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\r␠",
		out:  "␊\r／Ｒ␊ε␘λδ：ε␁YＤ－｜C%\x159θ\x15Ｍ␔?KQ␃\r␠",
	}, { // 264
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\t'",
		out:  "␠\t␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\t'",
	}, { // 265
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\t'",
		out:  "‛␠\t␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\t'",
	}, { // 266
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\n'",
		out:  "␠\n␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\n'",
	}, { // 267
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\n'",
		out:  "‛␠\n␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\n'",
	}, { // 268
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\v'",
		out:  "␠\v␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\v'",
	}, { // 269
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\v'",
		out:  "‛␠\v␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\v'",
	}, { // 270
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\r'",
		out:  "␠\r␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\r'",
	}, { // 271
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\r'",
		out:  "‛␠\r␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\r'",
	}, { // 272
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\t␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\t ",
		out:  "\x16\t␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\t ",
	}, { // 273
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\t␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\t␠",
		out:  "\x16\t␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\t␠",
	}, { // 274
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\n␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\n ",
		out:  "\x16\n␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\n ",
	}, { // 275
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\n␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\n␠",
		out:  "\x16\n␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\n␠",
	}, { // 276
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\v␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\v ",
		out:  "\x16\v␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\v ",
	}, { // 277
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\v␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\v␠",
		out:  "\x16\v␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\v␠",
	}, { // 278
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\r␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\r ",
		out:  "\x16\r␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\r ",
	}, { // 279
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\r␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\r␠",
		out:  "\x16\r␗Ｑekη）\x17τ\x19＂Xχ\x01Ｃi｜\nｆ＜ροO␍＄ｄ_\r␠",
	}, { // 280
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\t\x19",
		out:  "␠\tσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\t\x19",
	}, { // 281
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\t\x19",
		out:  "‛␠\tσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\t\x19",
	}, { // 282
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\n\x19",
		out:  "␠\nσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\n\x19",
	}, { // 283
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\n\x19",
		out:  "‛␠\nσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\n\x19",
	}, { // 284
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\v\x19",
		out:  "␠\vσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\v\x19",
	}, { // 285
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\v\x19",
		out:  "‛␠\vσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\v\x19",
	}, { // 286
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\r\x19",
		out:  "␠\rσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\r\x19",
	}, { // 287
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\r\x19",
		out:  "‛␠\rσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\r\x19",
	}, { // 288
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｚ\tσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\t ",
		out:  "Ｚ\tσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\t ",
	}, { // 289
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｚ\tσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\t␠",
		out:  "Ｚ\tσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\t␠",
	}, { // 290
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｚ\nσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\n ",
		out:  "Ｚ\nσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\n ",
	}, { // 291
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｚ\nσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\n␠",
		out:  "Ｚ\nσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\n␠",
	}, { // 292
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｚ\vσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\v ",
		out:  "Ｚ\vσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\v ",
	}, { // 293
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｚ\vσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\v␠",
		out:  "Ｚ\vσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\v␠",
	}, { // 294
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｚ\rσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\r ",
		out:  "Ｚ\rσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\r ",
	}, { // 295
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｚ\rσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\r␠",
		out:  "Ｚ\rσ␘\x0e９／＃τ]\"%θ\x16Ｋσkκ\x0fZk）␗ｑ␡␄ι\a\r␠",
	}, { // 296
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\t$",
		out:  "␠\t;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\t$",
	}, { // 297
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\t$",
		out:  "‛␠\t;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\t$",
	}, { // 298
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\n$",
		out:  "␠\n;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\n$",
	}, { // 299
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\n$",
		out:  "‛␠\n;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\n$",
	}, { // 300
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\v$",
		out:  "␠\v;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\v$",
	}, { // 301
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\v$",
		out:  "‛␠\v;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\v$",
	}, { // 302
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\r$",
		out:  "␠\r;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\r$",
	}, { // 303
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\r$",
		out:  "‛␠\r;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\r$",
	}, { // 304
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｈ\t;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\t ",
		out:  "Ｈ\t;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\t ",
	}, { // 305
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｈ\t;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\t␠",
		out:  "Ｈ\t;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\t␠",
	}, { // 306
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｈ\n;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\n ",
		out:  "Ｈ\n;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\n ",
	}, { // 307
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｈ\n;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\n␠",
		out:  "Ｈ\n;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\n␠",
	}, { // 308
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｈ\v;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\v ",
		out:  "Ｈ\v;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\v ",
	}, { // 309
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｈ\v;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\v␠",
		out:  "Ｈ\v;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\v␠",
	}, { // 310
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｈ\r;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\r ",
		out:  "Ｈ\r;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\r ",
	}, { // 311
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｈ\r;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\r␠",
		out:  "Ｈ\r;\x1cｖG＃\x16Ｌ#cθ%｀:ντ％１λ>τυ␈\x19#ｍ␒\r␠",
	}, { // 312
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\tτ",
		out:  "␠\tν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\tτ",
	}, { // 313
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\tτ",
		out:  "‛␠\tν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\tτ",
	}, { // 314
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\nτ",
		out:  "␠\nν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\nτ",
	}, { // 315
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\nτ",
		out:  "‛␠\nν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\nτ",
	}, { // 316
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\vτ",
		out:  "␠\vν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\vτ",
	}, { // 317
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\vτ",
		out:  "‛␠\vν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\vτ",
	}, { // 318
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\rτ",
		out:  "␠\rν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\rτ",
	}, { // 319
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\rτ",
		out:  "‛␠\rν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\rτ",
	}, { // 320
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1c\tν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\t ",
		out:  "\x1c\tν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\t ",
	}, { // 321
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1c\tν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\t␠",
		out:  "\x1c\tν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\t␠",
	}, { // 322
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1c\nν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\n ",
		out:  "\x1c\nν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\n ",
	}, { // 323
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1c\nν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\n␠",
		out:  "\x1c\nν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\n␠",
	}, { // 324
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1c\vν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\v ",
		out:  "\x1c\vν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\v ",
	}, { // 325
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1c\vν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\v␠",
		out:  "\x1c\vν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\v␠",
	}, { // 326
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1c\rν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\r ",
		out:  "\x1c\rν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\r ",
	}, { // 327
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1c\rν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\r␠",
		out:  "\x1c\rν\x17P＊␋␅\x18%(Ｒπ\x04５␌SＺ\x04\nνιe［ａ＋ζ␍\r␠",
	}, { // 328
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\t|",
		out:  "␠\t␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\t|",
	}, { // 329
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\t|",
		out:  "‛␠\t␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\t|",
	}, { // 330
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\n|",
		out:  "␠\n␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\n|",
	}, { // 331
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\n|",
		out:  "‛␠\n␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\n|",
	}, { // 332
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\v|",
		out:  "␠\v␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\v|",
	}, { // 333
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\v|",
		out:  "‛␠\v␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\v|",
	}, { // 334
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\r|",
		out:  "␠\r␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\r|",
	}, { // 335
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\r|",
		out:  "‛␠\r␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\r|",
	}, { // 336
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＿\t␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\t ",
		out:  "＿\t␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\t ",
	}, { // 337
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＿\t␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\t␠",
		out:  "＿\t␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\t␠",
	}, { // 338
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＿\n␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\n ",
		out:  "＿\n␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\n ",
	}, { // 339
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＿\n␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\n␠",
		out:  "＿\n␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\n␠",
	}, { // 340
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＿\v␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\v ",
		out:  "＿\v␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\v ",
	}, { // 341
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＿\v␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\v␠",
		out:  "＿\v␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\v␠",
	}, { // 342
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＿\r␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\r ",
		out:  "＿\r␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\r ",
	}, { // 343
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＿\r␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\r␠",
		out:  "＿\r␛]φι␇Ｏ\x14Ｃ\x1dι，\x16!\rＩr＃wPη\x05\fγＨ？␟\r␠",
	}, { // 344
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\tυ",
		out:  "␠\t（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\tυ",
	}, { // 345
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\tυ",
		out:  "‛␠\t（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\tυ",
	}, { // 346
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\nυ",
		out:  "␠\n（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\nυ",
	}, { // 347
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\nυ",
		out:  "‛␠\n（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\nυ",
	}, { // 348
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\vυ",
		out:  "␠\v（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\vυ",
	}, { // 349
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\vυ",
		out:  "‛␠\v（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\vυ",
	}, { // 350
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\rυ",
		out:  "␠\r（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\rυ",
	}, { // 351
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\rυ",
		out:  "‛␠\r（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\rυ",
	}, { // 352
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "f\t（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\t ",
		out:  "f\t（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\t ",
	}, { // 353
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "f\t（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\t␠",
		out:  "f\t（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\t␠",
	}, { // 354
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "f\n（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\n ",
		out:  "f\n（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\n ",
	}, { // 355
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "f\n（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\n␠",
		out:  "f\n（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\n␠",
	}, { // 356
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "f\v（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\v ",
		out:  "f\v（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\v ",
	}, { // 357
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "f\v（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\v␠",
		out:  "f\v（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\v␠",
	}, { // 358
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "f\r（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\r ",
		out:  "f\r（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\r ",
	}, { // 359
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "f\r（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\r␠",
		out:  "f\r（␓＞μ\x18Ｐ\x13σ␇\n？／%ｅ}\by␍|ψ＋=\rκρl\r␠",
	}, { // 360
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\t1",
		out:  "␠\t％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\t1",
	}, { // 361
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\t1",
		out:  "‛␠\t％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\t1",
	}, { // 362
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\n1",
		out:  "␠\n％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\n1",
	}, { // 363
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\n1",
		out:  "‛␠\n％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\n1",
	}, { // 364
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\v1",
		out:  "␠\v％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\v1",
	}, { // 365
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\v1",
		out:  "‛␠\v％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\v1",
	}, { // 366
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\r1",
		out:  "␠\r％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\r1",
	}, { // 367
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\r1",
		out:  "‛␠\r％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\r1",
	}, { // 368
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   ":\t％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\t ",
		out:  ":\t％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\t ",
	}, { // 369
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   ":\t％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\t␠",
		out:  ":\t％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\t␠",
	}, { // 370
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   ":\n％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\n ",
		out:  ":\n％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\n ",
	}, { // 371
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   ":\n％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\n␠",
		out:  ":\n％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\n␠",
	}, { // 372
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   ":\v％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\v ",
		out:  ":\v％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\v ",
	}, { // 373
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   ":\v％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\v␠",
		out:  ":\v％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\v␠",
	}, { // 374
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   ":\r％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\r ",
		out:  ":\r％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\r ",
	}, { // 375
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   ":\r％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\r␠",
		out:  ":\r％χ␇［ｎ\x02ςD］\x1bh?ξ\x17τω\tｕ␈%␚ｂ＇␛β=\r␠",
	}, { // 376
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ␀%κｕ(ｍ\x16＃－β<χ>＇\f␘Ｋι（＊＜\x04：σwy σ",
		out:  "␠ ‛␀%κｕ(ｍ\x16＃－β<χ>＇\f␘Ｋι（＊＜\x04：σwy σ",
	}, { // 377
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ␀%κｕ(ｍ\x16＃－β<χ>＇\f␘Ｋι（＊＜\x04：σwy σ",
		out:  "‛␠ ‛␀%κｕ(ｍ\x16＃－β<χ>＇\f␘Ｋι（＊＜\x04：σwy σ",
	}, { // 378
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x16 ␀%κｕ(ｍ\x16＃－β<χ>＇\f␘Ｋι（＊＜\x04：σwy  ",
		out:  "\x16 ‛␀%κｕ(ｍ\x16＃－β<χ>＇\f␘Ｋι（＊＜\x04：σwy ␠",
	}, { // 379
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x16 ␀%κｕ(ｍ\x16＃－β<χ>＇\f␘Ｋι（＊＜\x04：σwy ␠",
		out:  "\x16 ‛␀%κｕ(ｍ\x16＃－β<χ>＇\f␘Ｋι（＊＜\x04：σwy ‛␠",
	}, { // 380
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "  Jσｃ|＜7zｃ>π␎＊ς␊ωaρ\vｃ␊＞!］\a！δ ｒ",
		out:  "␠ Jσｃ|＜7zｃ>π␎＊ς␊ωaρ\vｃ␊＞!］\a！δ ｒ",
	}, { // 381
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ Jσｃ|＜7zｃ>π␎＊ς␊ωaρ\vｃ␊＞!］\a！δ ｒ",
		out:  "‛␠ Jσｃ|＜7zｃ>π␎＊ς␊ωaρ\vｃ␊＞!］\a！δ ｒ",
	}, { // 382
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "\r Jσｃ|＜7zｃ>π␎＊ς␊ωaρ\vｃ␊＞!］\a！δ  ",
		out:  "\r Jσｃ|＜7zｃ>π␎＊ς␊ωaρ\vｃ␊＞!］\a！δ ␠",
	}, { // 383
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "\r Jσｃ|＜7zｃ>π␎＊ς␊ωaρ\vｃ␊＞!］\a！δ ␠",
		out:  "\r Jσｃ|＜7zｃ>π␎＊ς␊ωaρ\vｃ␊＞!］\a！δ ‛␠",
	}, { // 384
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "  \x00ω␟=／\nＭ␀＇␗λＲψρ１ ω\x12k#\x19；＊C\rυ R",
		out:  "␠ ␀ω␟=／\nＭ‛␀‛＇␗λＲψρ１ ω\x12k#\x19；＊C\rυ R",
	}, { // 385
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ \x00ω␟=／\nＭ␀＇␗λＲψρ１ ω\x12k#\x19；＊C\rυ R",
		out:  "‛␠ ␀ω␟=／\nＭ‛␀‛＇␗λＲψρ１ ω\x12k#\x19；＊C\rυ R",
	}, { // 386
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␛ \x00ω␟=／\nＭ␀＇␗λＲψρ１ ω\x12k#\x19；＊C\rυ  ",
		out:  "␛ ␀ω␟=／\nＭ‛␀‛＇␗λＲψρ１ ω\x12k#\x19；＊C\rυ ␠",
	}, { // 387
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␛ \x00ω␟=／\nＭ␀＇␗λＲψρ１ ω\x12k#\x19；＊C\rυ ␠",
		out:  "␛ ␀ω␟=／\nＭ‛␀‛＇␗λＲψρ１ ω\x12k#\x19；＊C\rυ ‛␠",
	}, { // 388
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ο％οψ\x16νS\v␁Ｔ␘`ｂTｑ␗F_＇>\tＳ［␈\x11\b &",
		out:  "␠ ο％οψ\x16νS\v␁Ｔ␘｀ｂTｑ␗F_＇>\tＳ［␈\x11\b &",
	}, { // 389
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ο％οψ\x16νS\v␁Ｔ␘`ｂTｑ␗F_＇>\tＳ［␈\x11\b &",
		out:  "‛␠ ο％οψ\x16νS\v␁Ｔ␘｀ｂTｑ␗F_＇>\tＳ［␈\x11\b &",
	}, { // 390
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "｜ ο％οψ\x16νS\v␁Ｔ␘`ｂTｑ␗F_＇>\tＳ［␈\x11\b  ",
		out:  "｜ ο％οψ\x16νS\v␁Ｔ␘｀ｂTｑ␗F_＇>\tＳ［␈\x11\b ␠",
	}, { // 391
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "｜ ο％οψ\x16νS\v␁Ｔ␘`ｂTｑ␗F_＇>\tＳ［␈\x11\b ␠",
		out:  "｜ ο％οψ\x16νS\v␁Ｔ␘｀ｂTｑ␗F_＇>\tＳ［␈\x11\b ‛␠",
	}, { // 392
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "  Ｑ+\x17βθ\x11␐Ｅ␊\u007f－τ／Ｏωa？␛θ+0\x03ψe[： Ｘ",
		out:  "␠ Ｑ+\x17βθ\x11␐Ｅ␊\u007f－τ／Ｏωa？␛θ+0\x03ψe[： Ｘ",
	}, { // 393
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ Ｑ+\x17βθ\x11␐Ｅ␊\u007f－τ／Ｏωa？␛θ+0\x03ψe[： Ｘ",
		out:  "‛␠ Ｑ+\x17βθ\x11␐Ｅ␊\u007f－τ／Ｏωa？␛θ+0\x03ψe[： Ｘ",
	}, { // 394
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "\b Ｑ+\x17βθ\x11␐Ｅ␊\u007f－τ／Ｏωa？␛θ+0\x03ψe[：  ",
		out:  "\b Ｑ+\x17βθ\x11␐Ｅ␊\u007f－τ／Ｏωa？␛θ+0\x03ψe[： ␠",
	}, { // 395
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "\b Ｑ+\x17βθ\x11␐Ｅ␊\u007f－τ／Ｏωa？␛θ+0\x03ψe[： ␠",
		out:  "\b Ｑ+\x17βθ\x11␐Ｅ␊\u007f－τ／Ｏωa？␛θ+0\x03ψe[： ‛␠",
	}, { // 396
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "  \x03AXγδ␊\x01ι｛\x19３γ｜bＳ％φ]r）'\v\r␔␆［ \v",
		out:  "␠ \x03AXγδ␊\x01ι｛\x19３γ｜bＳ％φ]r）'\v\r␔␆［ \v",
	}, { // 397
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ \x03AXγδ␊\x01ι｛\x19３γ｜bＳ％φ]r）'\v\r␔␆［ \v",
		out:  "‛␠ \x03AXγδ␊\x01ι｛\x19３γ｜bＳ％φ]r）'\v\r␔␆［ \v",
	}, { // 398
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "＂ \x03AXγδ␊\x01ι｛\x19３γ｜bＳ％φ]r）'\v\r␔␆［  ",
		out:  "＂ \x03AXγδ␊\x01ι｛\x19３γ｜bＳ％φ]r）'\v\r␔␆［ ␠",
	}, { // 399
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "＂ \x03AXγδ␊\x01ι｛\x19３γ｜bＳ％φ]r）'\v\r␔␆［ ␠",
		out:  "＂ \x03AXγδ␊\x01ι｛\x19３γ｜bＳ％φ]r）'\v\r␔␆［ ‛␠",
	}, { // 400
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "  \x16！\x1e=\uff00ε␁％Ｙτ＝1␄ο｜␀8ρ\rα'υ>\x1bK＇ \v",
		out:  "␠ \x16！\x1e=\uff00ε␁％Ｙτ＝1␄ο｜‛␀8ρ\rα'υ>\x1bK＇ \v",
	}, { // 401
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ \x16！\x1e=\uff00ε␁％Ｙτ＝1␄ο｜␀8ρ\rα'υ>\x1bK＇ \v",
		out:  "‛␠ \x16！\x1e=\uff00ε␁％Ｙτ＝1␄ο｜‛␀8ρ\rα'υ>\x1bK＇ \v",
	}, { // 402
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "Ｕ \x16！\x1e=\uff00ε␁％Ｙτ＝1␄ο｜␀8ρ\rα'υ>\x1bK＇  ",
		out:  "Ｕ \x16！\x1e=\uff00ε␁％Ｙτ＝1␄ο｜‛␀8ρ\rα'υ>\x1bK＇ ␠",
	}, { // 403
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "Ｕ \x16！\x1e=\uff00ε␁％Ｙτ＝1␄ο｜␀8ρ\rα'υ>\x1bK＇ ␠",
		out:  "Ｕ \x16！\x1e=\uff00ε␁％Ｙτ＝1␄ο｜‛␀8ρ\rα'υ>\x1bK＇ ‛␠",
	}, { // 404
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "  \x1f\b\\υ\x06η␎＂＾_οrｄσ␑␆ι\x156ξＵh\x1b／:［ ｘ",
		out:  "␠ \x1f\b\\υ\x06η␎＂＾_οrｄσ␑␆ι\x156ξＵh\x1b／：［ ｘ",
	}, { // 405
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ \x1f\b\\υ\x06η␎＂＾_οrｄσ␑␆ι\x156ξＵh\x1b／:［ ｘ",
		out:  "‛␠ \x1f\b\\υ\x06η␎＂＾_οrｄσ␑␆ι\x156ξＵh\x1b／：［ ｘ",
	}, { // 406
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x03 \x1f\b\\υ\x06η␎＂＾_οrｄσ␑␆ι\x156ξＵh\x1b／:［  ",
		out:  "\x03 \x1f\b\\υ\x06η␎＂＾_οrｄσ␑␆ι\x156ξＵh\x1b／：［ ␠",
	}, { // 407
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x03 \x1f\b\\υ\x06η␎＂＾_οrｄσ␑␆ι\x156ξＵh\x1b／:［ ␠",
		out:  "\x03 \x1f\b\\υ\x06η␎＂＾_οrｄσ␑␆ι\x156ξＵh\x1b／：［ ‛␠",
	}, { // 408
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ␗＠Kκ␛｀g\x01]ο\x0e＝\x12o \x1fμ?␖ｏ\x01βςDｓ␝ μ",
		out:  "␠ ␗＠Kκ␛｀g\x01]ο\x0e＝\x12o \x1fμ？␖ｏ\x01βςDｓ␝ μ",
	}, { // 409
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ␗＠Kκ␛｀g\x01]ο\x0e＝\x12o \x1fμ?␖ｏ\x01βςDｓ␝ μ",
		out:  "‛␠ ␗＠Kκ␛｀g\x01]ο\x0e＝\x12o \x1fμ？␖ｏ\x01βςDｓ␝ μ",
	}, { // 410
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "␒ ␗＠Kκ␛｀g\x01]ο\x0e＝\x12o \x1fμ?␖ｏ\x01βςDｓ␝  ",
		out:  "␒ ␗＠Kκ␛｀g\x01]ο\x0e＝\x12o \x1fμ？␖ｏ\x01βςDｓ␝ ␠",
	}, { // 411
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "␒ ␗＠Kκ␛｀g\x01]ο\x0e＝\x12o \x1fμ?␖ｏ\x01βςDｓ␝ ␠",
		out:  "␒ ␗＠Kκ␛｀g\x01]ο\x0e＝\x12o \x1fμ？␖ｏ\x01βςDｓ␝ ‛␠",
	}, { // 412
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ␄$\x16ρ␐ςAμτ\fＩｅξＧ<Ｓ\x00␊~\a\x1d5AＤ｀ｔ S",
		out:  "␠ ␄$\x16ρ␐ςAμτ\fＩｅξＧ<Ｓ␀␊~\a\x1d5AＤ｀ｔ S",
	}, { // 413
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ␄$\x16ρ␐ςAμτ\fＩｅξＧ<Ｓ\x00␊~\a\x1d5AＤ｀ｔ S",
		out:  "‛␠ ␄$\x16ρ␐ςAμτ\fＩｅξＧ<Ｓ␀␊~\a\x1d5AＤ｀ｔ S",
	}, { // 414
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "ε ␄$\x16ρ␐ςAμτ\fＩｅξＧ<Ｓ\x00␊~\a\x1d5AＤ｀ｔ  ",
		out:  "ε ␄$\x16ρ␐ςAμτ\fＩｅξＧ<Ｓ␀␊~\a\x1d5AＤ｀ｔ ␠",
	}, { // 415
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "ε ␄$\x16ρ␐ςAμτ\fＩｅξＧ<Ｓ\x00␊~\a\x1d5AＤ｀ｔ ␠",
		out:  "ε ␄$\x16ρ␐ςAμτ\fＩｅξＧ<Ｓ␀␊~\a\x1d5AＤ｀ｔ ‛␠",
	}, { // 416
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "  b\r␔λ*M␜#3０<τff\nＴςＥ｜`␆␂η［ｊ␎ ＋",
		out:  "␠ b\r␔λ*M␜#3０<τff\nＴςＥ‛｜`␆␂η［ｊ␎ ＋",
	}, { // 417
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ b\r␔λ*M␜#3０<τff\nＴςＥ｜`␆␂η［ｊ␎ ＋",
		out:  "‛␠ b\r␔λ*M␜#3０<τff\nＴςＥ‛｜`␆␂η［ｊ␎ ＋",
	}, { // 418
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x1c b\r␔λ*M␜#3０<τff\nＴςＥ｜`␆␂η［ｊ␎  ",
		out:  "\x1c b\r␔λ*M␜#3０<τff\nＴςＥ‛｜`␆␂η［ｊ␎ ␠",
	}, { // 419
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x1c b\r␔λ*M␜#3０<τff\nＴςＥ｜`␆␂η［ｊ␎ ␠",
		out:  "\x1c b\r␔λ*M␜#3０<τff\nＴςＥ‛｜`␆␂η［ｊ␎ ‛␠",
	}, { // 420
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ␙FＣ'\u007fｏf\"ωＬＧνTz`＞␓ｐ␈τοζ␑υQ\x18 \x1e",
		out:  "␠ ␙FＣ'\u007fｏf\"ωＬＧνTz`＞␓ｐ␈τοζ␑υQ\x18 \x1e",
	}, { // 421
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ␙FＣ'\u007fｏf\"ωＬＧνTz`＞␓ｐ␈τοζ␑υQ\x18 \x1e",
		out:  "‛␠ ␙FＣ'\u007fｏf\"ωＬＧνTz`＞␓ｐ␈τοζ␑υQ\x18 \x1e",
	}, { // 422
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "| ␙FＣ'\u007fｏf\"ωＬＧνTz`＞␓ｐ␈τοζ␑υQ\x18  ",
		out:  "| ␙FＣ'\u007fｏf\"ωＬＧνTz`＞␓ｐ␈τοζ␑υQ\x18 ␠",
	}, { // 423
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "| ␙FＣ'\u007fｏf\"ωＬＧνTz`＞␓ｐ␈τοζ␑υQ\x18 ␠",
		out:  "| ␙FＣ'\u007fｏf\"ωＬＧνTz`＞␓ｐ␈τοζ␑υQ\x18 ‛␠",
	}, { // 424
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ␗Ｎ＼\"D␎L\x15RK\vι␐β＾％/\x1dργ␋␘ x＝＾ \x0e",
		out:  "␠ ␗Ｎ＼\"D␎L\x15RK\vι␐β＾‛％/\x1dργ␋␘ x＝＾ \x0e",
	}, { // 425
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ␗Ｎ＼\"D␎L\x15RK\vι␐β＾％/\x1dργ␋␘ x＝＾ \x0e",
		out:  "‛␠ ␗Ｎ＼\"D␎L\x15RK\vι␐β＾‛％/\x1dργ␋␘ x＝＾ \x0e",
	}, { // 426
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "ο ␗Ｎ＼\"D␎L\x15RK\vι␐β＾％/\x1dργ␋␘ x＝＾  ",
		out:  "ο ␗Ｎ＼\"D␎L\x15RK\vι␐β＾‛％/\x1dργ␋␘ x＝＾ ␠",
	}, { // 427
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "ο ␗Ｎ＼\"D␎L\x15RK\vι␐β＾％/\x1dργ␋␘ x＝＾ ␠",
		out:  "ο ␗Ｎ＼\"D␎L\x15RK\vι␐β＾‛％/\x1dργ␋␘ x＝＾ ‛␠",
	}, { // 428
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ξｎ␕\x06␇)＼ιο␕＼\x1f＂αμＤH\x1b\x14Ｃ\x115ωＵ|' c",
		out:  "␠ ξｎ␕\x06␇)‛＼ιο␕‛＼\x1f＂αμＤH\x1b\x14Ｃ\x115ωＵ|' c",
	}, { // 429
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ξｎ␕\x06␇)＼ιο␕＼\x1f＂αμＤH\x1b\x14Ｃ\x115ωＵ|' c",
		out:  "‛␠ ξｎ␕\x06␇)‛＼ιο␕‛＼\x1f＂αμＤH\x1b\x14Ｃ\x115ωＵ|' c",
	}, { // 430
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "｛ ξｎ␕\x06␇)＼ιο␕＼\x1f＂αμＤH\x1b\x14Ｃ\x115ωＵ|'  ",
		out:  "｛ ξｎ␕\x06␇)‛＼ιο␕‛＼\x1f＂αμＤH\x1b\x14Ｃ\x115ωＵ|' ␠",
	}, { // 431
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "｛ ξｎ␕\x06␇)＼ιο␕＼\x1f＂αμＤH\x1b\x14Ｃ\x115ωＵ|' ␠",
		out:  "｛ ξｎ␕\x06␇)‛＼ιο␕‛＼\x1f＂αμＤH\x1b\x14Ｃ\x115ωＵ|' ‛␠",
	}, { // 432
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ␐）γ$\x1d１ｄ\x12ν|␉ηｄ5ξς＞）~:␔\x04＂~＠␅ K",
		out:  "␠ ␐）γ$\x1d１ｄ\x12ν|␉ηｄ5ξς＞）~:␔\x04＂~＠␅ K",
	}, { // 433
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ␐）γ$\x1d１ｄ\x12ν|␉ηｄ5ξς＞）~:␔\x04＂~＠␅ K",
		out:  "‛␠ ␐）γ$\x1d１ｄ\x12ν|␉ηｄ5ξς＞）~:␔\x04＂~＠␅ K",
	}, { // 434
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "ν ␐）γ$\x1d１ｄ\x12ν|␉ηｄ5ξς＞）~:␔\x04＂~＠␅  ",
		out:  "ν ␐）γ$\x1d１ｄ\x12ν|␉ηｄ5ξς＞）~:␔\x04＂~＠␅ ␠",
	}, { // 435
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "ν ␐）γ$\x1d１ｄ\x12ν|␉ηｄ5ξς＞）~:␔\x04＂~＠␅ ␠",
		out:  "ν ␐）γ$\x1d１ｄ\x12ν|␉ηｄ5ξς＞）~:␔\x04＂~＠␅ ‛␠",
	}, { // 436
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ｏＺ/\x01\"＠＼ｚξ%9Ｐφ\r＼Ｚr␛␙ρ\x04σ*uσ\v ␏",
		out:  "␠ ｏＺ/\x01\"＠＼ｚξ%9Ｐφ\r＼Ｚr␛␙ρ\x04σ*uσ\v ␏",
	}, { // 437
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ｏＺ/\x01\"＠＼ｚξ%9Ｐφ\r＼Ｚr␛␙ρ\x04σ*uσ\v ␏",
		out:  "‛␠ ｏＺ/\x01\"＠＼ｚξ%9Ｐφ\r＼Ｚr␛␙ρ\x04σ*uσ\v ␏",
	}, { // 438
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "␞ ｏＺ/\x01\"＠＼ｚξ%9Ｐφ\r＼Ｚr␛␙ρ\x04σ*uσ\v  ",
		out:  "␞ ｏＺ/\x01\"＠＼ｚξ%9Ｐφ\r＼Ｚr␛␙ρ\x04σ*uσ\v ␠",
	}, { // 439
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "␞ ｏＺ/\x01\"＠＼ｚξ%9Ｐφ\r＼Ｚr␛␙ρ\x04σ*uσ\v ␠",
		out:  "␞ ｏＺ/\x01\"＠＼ｚξ%9Ｐφ\r＼Ｚr␛␙ρ\x04σ*uσ\v ‛␠",
	}, { // 440
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "  d\n\"θ␎kξμξ４?Ｎζ ／０\x06ｗｅ␊␙j~＄\fZ \r",
		out:  "␠ d␊\"θ‛␎kξμξ４?Ｎζ ／０␆ｗｅ‛␊‛␙j~＄␌Z ␍",
	}, { // 441
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ d\n\"θ␎kξμξ４?Ｎζ ／０\x06ｗｅ␊␙j~＄\fZ \r",
		out:  "‛␠ d␊\"θ‛␎kξμξ４?Ｎζ ／０␆ｗｅ‛␊‛␙j~＄␌Z ␍",
	}, { // 442
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "： d\n\"θ␎kξμξ４?Ｎζ ／０\x06ｗｅ␊␙j~＄\fZ  ",
		out:  "： d␊\"θ‛␎kξμξ４?Ｎζ ／０␆ｗｅ‛␊‛␙j~＄␌Z ␠",
	}, { // 443
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "： d\n\"θ␎kξμξ４?Ｎζ ／０\x06ｗｅ␊␙j~＄\fZ ␠",
		out:  "： d␊\"θ‛␎kξμξ４?Ｎζ ／０␆ｗｅ‛␊‛␙j~＄␌Z ‛␠",
	}, { // 444
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .\x1a（\x12␜ζ｀ς＞3␉ν]＞'ｉτβ\a＃<8ｄ\"ａ８\v.␃",
		out:  "␠.\x1a（\x12␜ζ｀ς＞3␉ν]＞'ｉτβ\a＃<8ｄ\"ａ８\v.␃",
	}, { // 445
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.\x1a（\x12␜ζ｀ς＞3␉ν]＞'ｉτβ\a＃<8ｄ\"ａ８\v.␃",
		out:  "‛␠.\x1a（\x12␜ζ｀ς＞3␉ν]＞'ｉτβ\a＃<8ｄ\"ａ８\v.␃",
	}, { // 446
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ε.\x1a（\x12␜ζ｀ς＞3␉ν]＞'ｉτβ\a＃<8ｄ\"ａ８\v. ",
		out:  "ε.\x1a（\x12␜ζ｀ς＞3␉ν]＞'ｉτβ\a＃<8ｄ\"ａ８\v. ",
	}, { // 447
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ε.\x1a（\x12␜ζ｀ς＞3␉ν]＞'ｉτβ\a＃<8ｄ\"ａ８\v.␠",
		out:  "ε.\x1a（\x12␜ζ｀ς＞3␉ν]＞'ｉτβ\a＃<8ｄ\"ａ８\v.␠",
	}, { // 448
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .ｗ␈τ\x19Qａρ\x17(?␊１␘r\x01θ\x1cＲ␔ο＾␉σδyZ.\n",
		out:  "␠.ｗ␈τ\x19Qａρ\x17(?␊１␘r\x01θ\x1cＲ␔ο＾␉σδyZ.\n",
	}, { // 449
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.ｗ␈τ\x19Qａρ\x17(?␊１␘r\x01θ\x1cＲ␔ο＾␉σδyZ.\n",
		out:  "‛␠.ｗ␈τ\x19Qａρ\x17(?␊１␘r\x01θ\x1cＲ␔ο＾␉σδyZ.\n",
	}, { // 450
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\x1e.ｗ␈τ\x19Qａρ\x17(?␊１␘r\x01θ\x1cＲ␔ο＾␉σδyZ. ",
		out:  "\x1e.ｗ␈τ\x19Qａρ\x17(?␊１␘r\x01θ\x1cＲ␔ο＾␉σδyZ. ",
	}, { // 451
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\x1e.ｗ␈τ\x19Qａρ\x17(?␊１␘r\x01θ\x1cＲ␔ο＾␉σδyZ.␠",
		out:  "\x1e.ｗ␈τ\x19Qａρ\x17(?␊１␘r\x01θ\x1cＲ␔ο＾␉σδyZ.␠",
	}, { // 452
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .Ｌ：t␏␇εχ␈＆］\x18\x11UηＲ＝\x1eφ＇\x161δ！\x04e,.ι",
		out:  "␠.Ｌ：t␏␇εχ␈＆］\x18\x11UηＲ＝\x1eφ‛＇\x161δ！\x04e,.ι",
	}, { // 453
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.Ｌ：t␏␇εχ␈＆］\x18\x11UηＲ＝\x1eφ＇\x161δ！\x04e,.ι",
		out:  "‛␠.Ｌ：t␏␇εχ␈＆］\x18\x11UηＲ＝\x1eφ‛＇\x161δ！\x04e,.ι",
	}, { // 454
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "$.Ｌ：t␏␇εχ␈＆］\x18\x11UηＲ＝\x1eφ＇\x161δ！\x04e,. ",
		out:  "$.Ｌ：t␏␇εχ␈＆］\x18\x11UηＲ＝\x1eφ‛＇\x161δ！\x04e,. ",
	}, { // 455
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "$.Ｌ：t␏␇εχ␈＆］\x18\x11UηＲ＝\x1eφ＇\x161δ！\x04e,.␠",
		out:  "$.Ｌ：t␏␇εχ␈＆］\x18\x11UηＲ＝\x1eφ‛＇\x161δ！\x04e,.␠",
	}, { // 456
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .\x17pψ＼#ηεｃＶ\x14␂\fπj＜Ｂ－δ／`q?␚␑\aτ.%",
		out:  "␠.\x17pψ＼#ηεｃＶ\x14␂\fπj＜Ｂ－δ／｀q?␚␑\aτ.%",
	}, { // 457
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.\x17pψ＼#ηεｃＶ\x14␂\fπj＜Ｂ－δ／`q?␚␑\aτ.%",
		out:  "‛␠.\x17pψ＼#ηεｃＶ\x14␂\fπj＜Ｂ－δ／｀q?␚␑\aτ.%",
	}, { // 458
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ｌ.\x17pψ＼#ηεｃＶ\x14␂\fπj＜Ｂ－δ／`q?␚␑\aτ. ",
		out:  "ｌ.\x17pψ＼#ηεｃＶ\x14␂\fπj＜Ｂ－δ／｀q?␚␑\aτ. ",
	}, { // 459
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ｌ.\x17pψ＼#ηεｃＶ\x14␂\fπj＜Ｂ－δ／`q?␚␑\aτ.␠",
		out:  "ｌ.\x17pψ＼#ηεｃＶ\x14␂\fπj＜Ｂ－δ／｀q?␚␑\aτ.␠",
	}, { // 460
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .ＤＮ␄Ｑυ`Nm？\x12κ-\x03j５|ｖψ；σ␔␡\n␏␍φ./",
		out:  "␠.ＤＮ␄Ｑυ`Nm？\x12κ-\x03j５|ｖψ；σ␔␡\n␏␍φ./",
	}, { // 461
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.ＤＮ␄Ｑυ`Nm？\x12κ-\x03j５|ｖψ；σ␔␡\n␏␍φ./",
		out:  "‛␠.ＤＮ␄Ｑυ`Nm？\x12κ-\x03j５|ｖψ；σ␔␡\n␏␍φ./",
	}, { // 462
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   "γ.ＤＮ␄Ｑυ`Nm？\x12κ-\x03j５|ｖψ；σ␔␡\n␏␍φ. ",
		out:  "γ.ＤＮ␄Ｑυ`Nm？\x12κ-\x03j５|ｖψ；σ␔␡\n␏␍φ. ",
	}, { // 463
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   "γ.ＤＮ␄Ｑυ`Nm？\x12κ-\x03j５|ｖψ；σ␔␡\n␏␍φ.␠",
		out:  "γ.ＤＮ␄Ｑυ`Nm？\x12κ-\x03j５|ｖψ；σ␔␡\n␏␍φ.␠",
	}, { // 464
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .＋βδ␈｀\x02Xτ*ιp`\x19␉＾ｅ%p\x11｜␊p␜η＂ω.？",
		out:  "␠.＋βδ␈｀\x02Xτ*ιp`\x19␉＾ｅ%p\x11｜␊p␜η＂ω.？",
	}, { // 465
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.＋βδ␈｀\x02Xτ*ιp`\x19␉＾ｅ%p\x11｜␊p␜η＂ω.？",
		out:  "‛␠.＋βδ␈｀\x02Xτ*ιp`\x19␉＾ｅ%p\x11｜␊p␜η＂ω.？",
	}, { // 466
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   "%.＋βδ␈｀\x02Xτ*ιp`\x19␉＾ｅ%p\x11｜␊p␜η＂ω. ",
		out:  "%.＋βδ␈｀\x02Xτ*ιp`\x19␉＾ｅ%p\x11｜␊p␜η＂ω. ",
	}, { // 467
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   "%.＋βδ␈｀\x02Xτ*ιp`\x19␉＾ｅ%p\x11｜␊p␜η＂ω.␠",
		out:  "%.＋βδ␈｀\x02Xτ*ιp`\x19␉＾ｅ%p\x11｜␊p␜η＂ω.␠",
	}, { // 468
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .!］λＭ{α\x1cFＨ␍｜>＿|π␃␙␙\\．ψη␕；eL.:",
		out:  "␠.!］λＭ{α\x1cFＨ␍｜>＿|π␃␙␙\\．ψη␕；eL.:",
	}, { // 469
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.!］λＭ{α\x1cFＨ␍｜>＿|π␃␙␙\\．ψη␕；eL.:",
		out:  "‛␠.!］λＭ{α\x1cFＨ␍｜>＿|π␃␙␙\\．ψη␕；eL.:",
	}, { // 470
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\\.!］λＭ{α\x1cFＨ␍｜>＿|π␃␙␙\\．ψη␕；eL. ",
		out:  "\\.!］λＭ{α\x1cFＨ␍｜>＿|π␃␙␙\\．ψη␕；eL. ",
	}, { // 471
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\\.!］λＭ{α\x1cFＨ␍｜>＿|π␃␙␙\\．ψη␕；eL.␠",
		out:  "\\.!］λＭ{α\x1cFＨ␍｜>＿|π␃␙␙\\．ψη␕；eL.␠",
	}, { // 472
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .<␝ｑ\x1dτν'E>γz/␄ｃ／'␏＿｀ｏ4η５␚αρ.%",
		out:  "␠.<␝ｑ\x1dτν'E>γz/␄ｃ／'␏＿｀ｏ4η５␚αρ.%",
	}, { // 473
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.<␝ｑ\x1dτν'E>γz/␄ｃ／'␏＿｀ｏ4η５␚αρ.%",
		out:  "‛␠.<␝ｑ\x1dτν'E>γz/␄ｃ／'␏＿｀ｏ4η５␚αρ.%",
	}, { // 474
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "`.<␝ｑ\x1dτν'E>γz/␄ｃ／'␏＿｀ｏ4η５␚αρ. ",
		out:  "`.<␝ｑ\x1dτν'E>γz/␄ｃ／'␏＿｀ｏ4η５␚αρ. ",
	}, { // 475
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "`.<␝ｑ\x1dτν'E>γz/␄ｃ／'␏＿｀ｏ4η５␚αρ.␠",
		out:  "`.<␝ｑ\x1dτν'E>γz/␄ｃ／'␏＿｀ｏ4η５␚αρ.␠",
	}, { // 476
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .，ξβ{＾λh％，\"␈q＂．Pχ％ｖ\"\x18\x19？β,\x06\r.ι",
		out:  "␠.，ξβ{＾λh％，\"␈q＂．Pχ％ｖ\"\x18\x19‛？β,\x06\r.ι",
	}, { // 477
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.，ξβ{＾λh％，\"␈q＂．Pχ％ｖ\"\x18\x19？β,\x06\r.ι",
		out:  "‛␠.，ξβ{＾λh％，\"␈q＂．Pχ％ｖ\"\x18\x19‛？β,\x06\r.ι",
	}, { // 478
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   "x.，ξβ{＾λh％，\"␈q＂．Pχ％ｖ\"\x18\x19？β,\x06\r. ",
		out:  "x.，ξβ{＾λh％，\"␈q＂．Pχ％ｖ\"\x18\x19‛？β,\x06\r. ",
	}, { // 479
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   "x.，ξβ{＾λh％，\"␈q＂．Pχ％ｖ\"\x18\x19？β,\x06\r.␠",
		out:  "x.，ξβ{＾λh％，\"␈q＂．Pχ％ｖ\"\x18\x19‛？β,\x06\r.␠",
	}, { // 480
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .]ωε>␇Xｚτ\x01β␕＼␝α？／＜Ｖ\x05＋u\b｀\x0eo␐.\x03",
		out:  "␠.]ωε>␇Xｚτ\x01β␕＼␝α？／＜Ｖ\x05＋u\b｀\x0eo␐.\x03",
	}, { // 481
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.]ωε>␇Xｚτ\x01β␕＼␝α？／＜Ｖ\x05＋u\b｀\x0eo␐.\x03",
		out:  "‛␠.]ωε>␇Xｚτ\x01β␕＼␝α？／＜Ｖ\x05＋u\b｀\x0eo␐.\x03",
	}, { // 482
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   ").]ωε>␇Xｚτ\x01β␕＼␝α？／＜Ｖ\x05＋u\b｀\x0eo␐. ",
		out:  ").]ωε>␇Xｚτ\x01β␕＼␝α？／＜Ｖ\x05＋u\b｀\x0eo␐. ",
	}, { // 483
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   ").]ωε>␇Xｚτ\x01β␕＼␝α？／＜Ｖ\x05＋u\b｀\x0eo␐.␠",
		out:  ").]ωε>␇Xｚτ\x01β␕＼␝α？／＜Ｖ\x05＋u\b｀\x0eo␐.␠",
	}, { // 484
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .\x04␔ｗqμ（ε２ω～＞β^／\x1dZ␍／␈λ#\x1c%ｓ\\\v.␖",
		out:  "␠.\x04␔ｗqμ（ε２ω～＞β^／\x1dZ␍／␈λ#\x1c%ｓ\\\v.␖",
	}, { // 485
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.\x04␔ｗqμ（ε２ω～＞β^／\x1dZ␍／␈λ#\x1c%ｓ\\\v.␖",
		out:  "‛␠.\x04␔ｗqμ（ε２ω～＞β^／\x1dZ␍／␈λ#\x1c%ｓ\\\v.␖",
	}, { // 486
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   "θ.\x04␔ｗqμ（ε２ω～＞β^／\x1dZ␍／␈λ#\x1c%ｓ\\\v. ",
		out:  "θ.\x04␔ｗqμ（ε２ω～＞β^／\x1dZ␍／␈λ#\x1c%ｓ\\\v. ",
	}, { // 487
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   "θ.\x04␔ｗqμ（ε２ω～＞β^／\x1dZ␍／␈λ#\x1c%ｓ\\\v.␠",
		out:  "θ.\x04␔ｗqμ（ε２ω～＞β^／\x1dZ␍／␈λ#\x1c%ｓ\\\v.␠",
	}, { // 488
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .Ｇ\x11ｊ␚εＤψｒ|␅ρι／.(＃/\a\x15␀｛ψ`␕ι$./",
		out:  "␠.Ｇ\x11ｊ␚εＤψｒ|␅ρι／.(‛＃/\a\x15‛␀｛ψ`␕ι$./",
	}, { // 489
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.Ｇ\x11ｊ␚εＤψｒ|␅ρι／.(＃/\a\x15␀｛ψ`␕ι$./",
		out:  "‛␠.Ｇ\x11ｊ␚εＤψｒ|␅ρι／.(‛＃/\a\x15‛␀｛ψ`␕ι$./",
	}, { // 490
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "#.Ｇ\x11ｊ␚εＤψｒ|␅ρι／.(＃/\a\x15␀｛ψ`␕ι$. ",
		out:  "＃.Ｇ\x11ｊ␚εＤψｒ|␅ρι／.(‛＃/\a\x15‛␀｛ψ`␕ι$. ",
	}, { // 491
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "#.Ｇ\x11ｊ␚εＤψｒ|␅ρι／.(＃/\a\x15␀｛ψ`␕ι$.␠",
		out:  "＃.Ｇ\x11ｊ␚εＤψｒ|␅ρι／.(‛＃/\a\x15‛␀｛ψ`␕ι$.␠",
	}, { // 492
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .Dt`ｘ＾ο?＊μ␀χ␋οU\x14\x03＜\x1beλｇ␐ν␉#％.Ｗ",
		out:  "␠.Dt`ｘ＾ο?＊μ‛␀χ␋οU\x14\x03＜\x1beλｇ␐ν␉#‛％.Ｗ",
	}, { // 493
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.Dt`ｘ＾ο?＊μ␀χ␋οU\x14\x03＜\x1beλｇ␐ν␉#％.Ｗ",
		out:  "‛␠.Dt`ｘ＾ο?＊μ‛␀χ␋οU\x14\x03＜\x1beλｇ␐ν␉#‛％.Ｗ",
	}, { // 494
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\n.Dt`ｘ＾ο?＊μ␀χ␋οU\x14\x03＜\x1beλｇ␐ν␉#％. ",
		out:  "\n.Dt`ｘ＾ο?＊μ‛␀χ␋οU\x14\x03＜\x1beλｇ␐ν␉#‛％. ",
	}, { // 495
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\n.Dt`ｘ＾ο?＊μ␀χ␋οU\x14\x03＜\x1beλｇ␐ν␉#％.␠",
		out:  "\n.Dt`ｘ＾ο?＊μ‛␀χ␋οU\x14\x03＜\x1beλｇ␐ν␉#‛％.␠",
	}, { // 496
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .\nη.ρY９␛ψ/ρ.␛`␜␉␙␍ｔμ\r５\x13:LjＡ.σ",
		out:  "␠.\nη.ρY９␛ψ/ρ.␛`␜␉␙␍ｔμ\r５\x13:LjＡ.σ",
	}, { // 497
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.\nη.ρY９␛ψ/ρ.␛`␜␉␙␍ｔμ\r５\x13:LjＡ.σ",
		out:  "‛␠.\nη.ρY９␛ψ/ρ.␛`␜␉␙␍ｔμ\r５\x13:LjＡ.σ",
	}, { // 498
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "＃.\nη.ρY９␛ψ/ρ.␛`␜␉␙␍ｔμ\r５\x13:LjＡ. ",
		out:  "＃.\nη.ρY９␛ψ/ρ.␛`␜␉␙␍ｔμ\r５\x13:LjＡ. ",
	}, { // 499
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "＃.\nη.ρY９␛ψ/ρ.␛`␜␉␙␍ｔμ\r５\x13:LjＡ.␠",
		out:  "＃.\nη.ρY９␛ψ/ρ.␛`␜␉␙␍ｔμ\r５\x13:LjＡ.␠",
	}, { // 500
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .ει4ｃ＼υ␝ｏS＼φβ\b>\x14λｉ～'\x17i＃\x00:ｋ|.␅",
		out:  "␠.ει4ｃ＼υ␝ｏS＼φβ\b>\x14λｉ～'\x17i＃␀:ｋ|.␅",
	}, { // 501
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.ει4ｃ＼υ␝ｏS＼φβ\b>\x14λｉ～'\x17i＃\x00:ｋ|.␅",
		out:  "‛␠.ει4ｃ＼υ␝ｏS＼φβ\b>\x14λｉ～'\x17i＃␀:ｋ|.␅",
	}, { // 502
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␕.ει4ｃ＼υ␝ｏS＼φβ\b>\x14λｉ～'\x17i＃\x00:ｋ|. ",
		out:  "␕.ει4ｃ＼υ␝ｏS＼φβ\b>\x14λｉ～'\x17i＃␀:ｋ|. ",
	}, { // 503
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␕.ει4ｃ＼υ␝ｏS＼φβ\b>\x14λｉ～'\x17i＃\x00:ｋ|.␠",
		out:  "␕.ει4ｃ＼υ␝ｏS＼φβ\b>\x14λｉ～'\x17i＃␀:ｋ|.␠",
	}, { // 504
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .\x1aE␋␓␓␌:\r＜η\x1d\x19,υ\bｑＤρｒＳ␆ςeοθ7.Q",
		out:  "␠.\x1aE␋␓␓␌:\r＜η\x1d\x19,υ\bｑＤρｒＳ␆ςeοθ7.Q",
	}, { // 505
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.\x1aE␋␓␓␌:\r＜η\x1d\x19,υ\bｑＤρｒＳ␆ςeοθ7.Q",
		out:  "‛␠.\x1aE␋␓␓␌:\r＜η\x1d\x19,υ\bｑＤρｒＳ␆ςeοθ7.Q",
	}, { // 506
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ｓ.\x1aE␋␓␓␌:\r＜η\x1d\x19,υ\bｑＤρｒＳ␆ςeοθ7. ",
		out:  "ｓ.\x1aE␋␓␓␌:\r＜η\x1d\x19,υ\bｑＤρｒＳ␆ςeοθ7. ",
	}, { // 507
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ｓ.\x1aE␋␓␓␌:\r＜η\x1d\x19,υ\bｑＤρｒＳ␆ςeοθ7.␠",
		out:  "ｓ.\x1aE␋␓␓␌:\r＜η\x1d\x19,υ\bｑＤρｒＳ␆ςeοθ7.␠",
	}, { // 508
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .␊Ｈ９␂Ｋ｜\x138\x19ζυ␊νＤ＄\x1e\u007f＞2θＦ\x01a2\x1fρ.`",
		out:  "␠.‛␊Ｈ９‛␂Ｋ｜␓8␙ζυ‛␊νＤ＄␞\u007f＞2θＦ␁a2␟ρ.`",
	}, { // 509
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.␊Ｈ９␂Ｋ｜\x138\x19ζυ␊νＤ＄\x1e\u007f＞2θＦ\x01a2\x1fρ.`",
		out:  "‛␠.‛␊Ｈ９‛␂Ｋ｜␓8␙ζυ‛␊νＤ＄␞\u007f＞2θＦ␁a2␟ρ.`",
	}, { // 510
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   "κ.␊Ｈ９␂Ｋ｜\x138\x19ζυ␊νＤ＄\x1e\u007f＞2θＦ\x01a2\x1fρ. ",
		out:  "κ.‛␊Ｈ９‛␂Ｋ｜␓8␙ζυ‛␊νＤ＄␞\u007f＞2θＦ␁a2␟ρ. ",
	}, { // 511
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   "κ.␊Ｈ９␂Ｋ｜\x138\x19ζυ␊νＤ＄\x1e\u007f＞2θＦ\x01a2\x1fρ.␠",
		out:  "κ.‛␊Ｈ９‛␂Ｋ｜␓8␙ζυ‛␊νＤ＄␞\u007f＞2θＦ␁a2␟ρ.␠",
	}, { // 512
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\t\x02",
		out:  "␠\tο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\t\x02",
	}, { // 513
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\t\x02",
		out:  "‛␠\tο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\t\x02",
	}, { // 514
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\n\x02",
		out:  "␠\nο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\n\x02",
	}, { // 515
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\n\x02",
		out:  "‛␠\nο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\n\x02",
	}, { // 516
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\v\x02",
		out:  "␠\vο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\v\x02",
	}, { // 517
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\v\x02",
		out:  "‛␠\vο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\v\x02",
	}, { // 518
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\r\x02",
		out:  "␠\rο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\r\x02",
	}, { // 519
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\r\x02",
		out:  "‛␠\rο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\r\x02",
	}, { // 520
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "（\tο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\t ",
		out:  "（\tο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\t ",
	}, { // 521
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "（\tο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\t␠",
		out:  "（\tο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\t␠",
	}, { // 522
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "（\nο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\n ",
		out:  "（\nο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\n ",
	}, { // 523
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "（\nο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\n␠",
		out:  "（\nο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\n␠",
	}, { // 524
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "（\vο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\v ",
		out:  "（\vο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\v ",
	}, { // 525
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "（\vο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\v␠",
		out:  "（\vο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\v␠",
	}, { // 526
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "（\rο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\r ",
		out:  "（\rο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\r ",
	}, { // 527
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "（\rο@\x01ωｚ␀\x1aＡωM\a␀8ζ␊7␈！␁．\rZπ7␎\v\r␠",
		out:  "（\rο@\x01ωｚ‛␀\x1aＡωM\a‛␀8ζ␊7␈！␁．\rZπ7␎\v\r␠",
	}, { // 528
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\tα",
		out:  "␠\tj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\tα",
	}, { // 529
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\tα",
		out:  "‛␠\tj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\tα",
	}, { // 530
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\nα",
		out:  "␠\nj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\nα",
	}, { // 531
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\nα",
		out:  "‛␠\nj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\nα",
	}, { // 532
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\vα",
		out:  "␠\vj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\vα",
	}, { // 533
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\vα",
		out:  "‛␠\vj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\vα",
	}, { // 534
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\rα",
		out:  "␠\rj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\rα",
	}, { // 535
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\rα",
		out:  "‛␠\rj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\rα",
	}, { // 536
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\tj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\t ",
		out:  "␡\tj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\t ",
	}, { // 537
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\tj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\t␠",
		out:  "␡\tj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\t␠",
	}, { // 538
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\nj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\n ",
		out:  "␡\nj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\n ",
	}, { // 539
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\nj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\n␠",
		out:  "␡\nj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\n␠",
	}, { // 540
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\vj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\v ",
		out:  "␡\vj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\v ",
	}, { // 541
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\vj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\v␠",
		out:  "␡\vj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\v␠",
	}, { // 542
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\rj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\r ",
		out:  "␡\rj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\r ",
	}, { // 543
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\rj4Ｌ＇＇ＫL/?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\r␠",
		out:  "␡\rj4Ｌ＇＇ＫL／?μ\rｘ:μ␄ψ␃\x03>Ｊ\x19＂ν}？υ\r␠",
	}, { // 544
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\tE",
		out:  "␠\t７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\tE",
	}, { // 545
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\tE",
		out:  "‛␠\t７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\tE",
	}, { // 546
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\nE",
		out:  "␠\n７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\nE",
	}, { // 547
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\nE",
		out:  "‛␠\n７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\nE",
	}, { // 548
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\vE",
		out:  "␠\v７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\vE",
	}, { // 549
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\vE",
		out:  "‛␠\v７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\vE",
	}, { // 550
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\rE",
		out:  "␠\r７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\rE",
	}, { // 551
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\rE",
		out:  "‛␠\r７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\rE",
	}, { // 552
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0f\t７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\t ",
		out:  "\x0f\t７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\t ",
	}, { // 553
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0f\t７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\t␠",
		out:  "\x0f\t７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\t␠",
	}, { // 554
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0f\n７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\n ",
		out:  "\x0f\n７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\n ",
	}, { // 555
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0f\n７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\n␠",
		out:  "\x0f\n７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\n␠",
	}, { // 556
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0f\v７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\v ",
		out:  "\x0f\v７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\v ",
	}, { // 557
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0f\v７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\v␠",
		out:  "\x0f\v７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\v␠",
	}, { // 558
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0f\r７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\r ",
		out:  "\x0f\r７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\r ",
	}, { // 559
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0f\r７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\r␠",
		out:  "\x0f\r７Ｊ\x02\uff00~χ␛（？＊δ［␟\x03ε\x05%]␙\x14ςιＫ｜&ε\r␠",
	}, { // 560
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\t3",
		out:  "␠\t\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\t3",
	}, { // 561
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\t3",
		out:  "‛␠\t\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\t3",
	}, { // 562
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\n3",
		out:  "␠\n\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\n3",
	}, { // 563
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\n3",
		out:  "‛␠\n\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\n3",
	}, { // 564
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\v3",
		out:  "␠\v\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\v3",
	}, { // 565
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\v3",
		out:  "‛␠\v\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\v3",
	}, { // 566
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\r3",
		out:  "␠\r\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\r3",
	}, { // 567
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\r3",
		out:  "‛␠\r\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\r3",
	}, { // 568
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␀\t\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\t ",
		out:  "‛␀\t\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\t ",
	}, { // 569
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␀\t\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\t␠",
		out:  "‛␀\t\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\t␠",
	}, { // 570
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␀\n\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\n ",
		out:  "‛␀\n\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\n ",
	}, { // 571
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␀\n\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\n␠",
		out:  "‛␀\n\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\n␠",
	}, { // 572
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␀\v\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\v ",
		out:  "‛␀\v\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\v ",
	}, { // 573
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␀\v\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\v␠",
		out:  "‛␀\v\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\v␠",
	}, { // 574
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␀\r\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\r ",
		out:  "‛␀\r\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\r ",
	}, { // 575
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␀\r\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\r␠",
		out:  "‛␀\r\"＿ρk␍γ］Cｏ\x12␛␑\x0e␍\tL$η\"ο/\t＄ο＊６\r␠",
	}, { // 576
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\tλ",
		out:  "␠\tαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\tλ",
	}, { // 577
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\tλ",
		out:  "‛␠\tαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\tλ",
	}, { // 578
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\nλ",
		out:  "␠\nαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\nλ",
	}, { // 579
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\nλ",
		out:  "‛␠\nαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\nλ",
	}, { // 580
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\vλ",
		out:  "␠\vαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\vλ",
	}, { // 581
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\vλ",
		out:  "‛␠\vαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\vλ",
	}, { // 582
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\rλ",
		out:  "␠\rαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\rλ",
	}, { // 583
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\rλ",
		out:  "‛␠\rαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\rλ",
	}, { // 584
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｔ\tαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\t ",
		out:  "ｔ\tαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\t ",
	}, { // 585
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｔ\tαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\t␠",
		out:  "ｔ\tαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\t␠",
	}, { // 586
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｔ\nαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\n ",
		out:  "ｔ\nαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\n ",
	}, { // 587
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｔ\nαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\n␠",
		out:  "ｔ\nαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\n␠",
	}, { // 588
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｔ\vαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\v ",
		out:  "ｔ\vαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\v ",
	}, { // 589
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｔ\vαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\v␠",
		out:  "ｔ\vαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\v␠",
	}, { // 590
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｔ\rαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\r ",
		out:  "ｔ\rαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\r ",
	}, { // 591
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｔ\rαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\r␠",
		out:  "ｔ\rαＯ|\\＼RB␆｀`\x1b*ιωuｚ␓\n\x01\x18␍\u007f␕Ｋ８␘\r␠",
	}, { // 592
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\t＄",
		out:  "␠\tπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\t‛＄",
	}, { // 593
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\t＄",
		out:  "‛␠\tπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\t‛＄",
	}, { // 594
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\n＄",
		out:  "␠\nπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\n‛＄",
	}, { // 595
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\n＄",
		out:  "‛␠\nπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\n‛＄",
	}, { // 596
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\v＄",
		out:  "␠\vπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\v‛＄",
	}, { // 597
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\v＄",
		out:  "‛␠\vπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\v‛＄",
	}, { // 598
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\r＄",
		out:  "␠\rπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\r‛＄",
	}, { // 599
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\r＄",
		out:  "‛␠\rπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\r‛＄",
	}, { // 600
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\tπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\t ",
		out:  "␚\tπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\t ",
	}, { // 601
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\tπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\t␠",
		out:  "␚\tπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\t␠",
	}, { // 602
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\nπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\n ",
		out:  "␚\nπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\n ",
	}, { // 603
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\nπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\n␠",
		out:  "␚\nπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\n␠",
	}, { // 604
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\vπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\v ",
		out:  "␚\vπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\v ",
	}, { // 605
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\vπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\v␠",
		out:  "␚\vπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\v␠",
	}, { // 606
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\rπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\r ",
		out:  "␚\rπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\r ",
	}, { // 607
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\rπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\r␠",
		out:  "␚\rπ<q\x01？＜π９＊|λ'ｔ\n＠M＼␍π；5＞vφ2φ\r␠",
	}, { // 608
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\t'",
		out:  "␠\tＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\t'",
	}, { // 609
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\t'",
		out:  "‛␠\tＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\t'",
	}, { // 610
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\n'",
		out:  "␠\nＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\n'",
	}, { // 611
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\n'",
		out:  "‛␠\nＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\n'",
	}, { // 612
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\v'",
		out:  "␠\vＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\v'",
	}, { // 613
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\v'",
		out:  "‛␠\vＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\v'",
	}, { // 614
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\r'",
		out:  "␠\rＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\r'",
	}, { // 615
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\r'",
		out:  "‛␠\rＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\r'",
	}, { // 616
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\tＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\t ",
		out:  "q\tＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\t ",
	}, { // 617
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\tＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\t␠",
		out:  "q\tＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\t␠",
	}, { // 618
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\nＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\n ",
		out:  "q\nＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\n ",
	}, { // 619
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\nＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\n␠",
		out:  "q\nＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\n␠",
	}, { // 620
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\vＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\v ",
		out:  "q\vＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\v ",
	}, { // 621
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\vＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\v␠",
		out:  "q\vＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\v␠",
	}, { // 622
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\rＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\r ",
		out:  "q\rＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\r ",
	}, { // 623
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\rＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?␀P␟δα＼␅／\r␠",
		out:  "q\rＶ␍Ｚ\x11{τυY～:\x03χeCＮｏ`?‛␀P␟δα＼␅／\r␠",
	}, { // 624
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\tε",
		out:  "␠\tζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\tε",
	}, { // 625
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\tε",
		out:  "‛␠\tζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\tε",
	}, { // 626
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\nε",
		out:  "␠\nζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\nε",
	}, { // 627
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\nε",
		out:  "‛␠\nζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\nε",
	}, { // 628
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\vε",
		out:  "␠\vζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\vε",
	}, { // 629
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\vε",
		out:  "‛␠\vζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\vε",
	}, { // 630
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\rε",
		out:  "␠\rζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\rε",
	}, { // 631
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\rε",
		out:  "‛␠\rζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\rε",
	}, { // 632
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\tζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\t ",
		out:  "␚\tζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\t ",
	}, { // 633
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\tζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\t␠",
		out:  "␚\tζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\t␠",
	}, { // 634
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\nζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\n ",
		out:  "␚\nζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\n ",
	}, { // 635
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\nζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\n␠",
		out:  "␚\nζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\n␠",
	}, { // 636
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\vζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\v ",
		out:  "␚\vζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\v ",
	}, { // 637
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\vζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\v␠",
		out:  "␚\vζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\v␠",
	}, { // 638
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\rζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\r ",
		out:  "␚\rζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\r ",
	}, { // 639
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␚\rζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\r␠",
		out:  "␚\rζγ＇␡φ␂\x1c%v＼-AχＺＣ\x11n｜３１φ␍jｂ\x05#\r␠",
	}, { // 640
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\tω",
		out:  "␠\t\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\tω",
	}, { // 641
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\tω",
		out:  "‛␠\t\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\tω",
	}, { // 642
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\nω",
		out:  "␠\n\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\nω",
	}, { // 643
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\nω",
		out:  "‛␠\n\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\nω",
	}, { // 644
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\vω",
		out:  "␠\v\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\vω",
	}, { // 645
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\vω",
		out:  "‛␠\v\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\vω",
	}, { // 646
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\rω",
		out:  "␠\r\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\rω",
	}, { // 647
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\rω",
		out:  "‛␠\r\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\rω",
	}, { // 648
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "f\t\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\t ",
		out:  "f\t\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\t ",
	}, { // 649
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "f\t\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\t␠",
		out:  "f\t\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\t␠",
	}, { // 650
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "f\n\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\n ",
		out:  "f\n\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\n ",
	}, { // 651
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "f\n\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\n␠",
		out:  "f\n\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\n␠",
	}, { // 652
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "f\v\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\v ",
		out:  "f\v\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\v ",
	}, { // 653
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "f\v\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\v␠",
		out:  "f\v\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\v␠",
	}, { // 654
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "f\r\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\r ",
		out:  "f\r\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\r ",
	}, { // 655
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "f\r\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\r␠",
		out:  "f\r\\χ＊k\v`i␔␞\rξqＺ␍９\vμ␍\nＩ｀γｓ\vπ␝\r␠",
	}, { // 656
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\t＃",
		out:  "␠\t\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\t＃",
	}, { // 657
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\t＃",
		out:  "‛␠\t\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\t＃",
	}, { // 658
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\n＃",
		out:  "␠\n\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\n＃",
	}, { // 659
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\n＃",
		out:  "‛␠\n\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\n＃",
	}, { // 660
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\v＃",
		out:  "␠\v\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\v＃",
	}, { // 661
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\v＃",
		out:  "‛␠\v\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\v＃",
	}, { // 662
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\r＃",
		out:  "␠\r\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\r＃",
	}, { // 663
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\r＃",
		out:  "‛␠\r\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\r＃",
	}, { // 664
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\t\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\t ",
		out:  "␡\t\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\t ",
	}, { // 665
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\t\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\t␠",
		out:  "␡\t\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\t␠",
	}, { // 666
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\n\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\n ",
		out:  "␡\n\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\n ",
	}, { // 667
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\n\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\n␠",
		out:  "␡\n\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\n␠",
	}, { // 668
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\v\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\v ",
		out:  "␡\v\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\v ",
	}, { // 669
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\v\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\v␠",
		out:  "␡\v\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\v␠",
	}, { // 670
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\r\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\r ",
		out:  "␡\r\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\r ",
	}, { // 671
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␡\r\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\r␠",
		out:  "␡\r\x1a{δ4\x10ＮＴq\x15＄␏＄μ＜$ｓα\x0eφｒα＂;K\x10ο\r␠",
	}, { // 672
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\t＄",
		out:  "␠\tψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\t＄",
	}, { // 673
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\t＄",
		out:  "‛␠\tψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\t＄",
	}, { // 674
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\n＄",
		out:  "␠\nψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\n＄",
	}, { // 675
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\n＄",
		out:  "‛␠\nψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\n＄",
	}, { // 676
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\v＄",
		out:  "␠\vψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\v＄",
	}, { // 677
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\v＄",
		out:  "‛␠\vψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\v＄",
	}, { // 678
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\r＄",
		out:  "␠\rψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\r＄",
	}, { // 679
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\r＄",
		out:  "‛␠\rψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\r＄",
	}, { // 680
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\tψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\t ",
		out:  "q\tψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\t ",
	}, { // 681
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\tψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\t␠",
		out:  "q\tψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\t␠",
	}, { // 682
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\nψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\n ",
		out:  "q\nψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\n ",
	}, { // 683
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\nψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\n␠",
		out:  "q\nψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\n␠",
	}, { // 684
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\vψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\v ",
		out:  "q\vψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\v ",
	}, { // 685
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\vψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\v␠",
		out:  "q\vψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\v␠",
	}, { // 686
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\rψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\r ",
		out:  "q\rψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\r ",
	}, { // 687
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\rψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\r␠",
		out:  "q\rψ＜$␑\x10$ｕ\"␛φψ\r\x10Ａ／␌］␏BνP␑ｚ(υ\x11\r␠",
	}, { // 688
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\t７",
		out:  "␠\t8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\t７",
	}, { // 689
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\t７",
		out:  "‛␠\t8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\t７",
	}, { // 690
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\n７",
		out:  "␠\n8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\n７",
	}, { // 691
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\n７",
		out:  "‛␠\n8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\n７",
	}, { // 692
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\v７",
		out:  "␠\v8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\v７",
	}, { // 693
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\v７",
		out:  "‛␠\v8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\v７",
	}, { // 694
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\r７",
		out:  "␠\r8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\r７",
	}, { // 695
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\r７",
		out:  "‛␠\r8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\r７",
	}, { // 696
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "m\t8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\t ",
		out:  "m\t8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\t ",
	}, { // 697
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "m\t8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\t␠",
		out:  "m\t8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\t␠",
	}, { // 698
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "m\n8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\n ",
		out:  "m\n8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\n ",
	}, { // 699
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "m\n8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\n␠",
		out:  "m\n8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\n␠",
	}, { // 700
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "m\v8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\v ",
		out:  "m\v8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\v ",
	}, { // 701
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "m\v8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\v␠",
		out:  "m\v8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\v␠",
	}, { // 702
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "m\r8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\r ",
		out:  "m\r8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\r ",
	}, { // 703
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "m\r8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\r␠",
		out:  "m\r8τＢZ\x12？␅ζ\x12ｌ\x01Ｈψ?␃\x1f4␍ν｀κqＬyＣ\x12\r␠",
	}, { // 704
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\tm",
		out:  "␠\t3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\tm",
	}, { // 705
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\tm",
		out:  "‛␠\t3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\tm",
	}, { // 706
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\nm",
		out:  "␠\n3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\nm",
	}, { // 707
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\nm",
		out:  "‛␠\n3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\nm",
	}, { // 708
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\vm",
		out:  "␠\v3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\vm",
	}, { // 709
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\vm",
		out:  "‛␠\v3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\vm",
	}, { // 710
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\rm",
		out:  "␠\r3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\rm",
	}, { // 711
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\rm",
		out:  "‛␠\r3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\rm",
	}, { // 712
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\t3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\t ",
		out:  "␘\t3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\t ",
	}, { // 713
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\t3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\t␠",
		out:  "␘\t3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\t␠",
	}, { // 714
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\n3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\n ",
		out:  "␘\n3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\n ",
	}, { // 715
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\n3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\n␠",
		out:  "␘\n3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\n␠",
	}, { // 716
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\v3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\v ",
		out:  "␘\v3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\v ",
	}, { // 717
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\v3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\v␠",
		out:  "␘\v3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\v␠",
	}, { // 718
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\r3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\r ",
		out:  "␘\r3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\r ",
	}, { // 719
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␘\r3ο\x0eωfι＇\x12ｔω\npm１＞ｖ％Ｇ\\ＬＤ␄\x0fθσ<\r␠",
		out:  "␘\r3ο\x0eωfι＇\x12ｔω\npm１＞ｖ‛％Ｇ\\ＬＤ␄\x0fθσ<\r␠",
	}, { // 720
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \ts␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\tν",
		out:  "␠\ts␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\tν",
	}, { // 721
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\ts␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\tν",
		out:  "‛␠\ts␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\tν",
	}, { // 722
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \ns␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\nν",
		out:  "␠\ns␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\nν",
	}, { // 723
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\ns␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\nν",
		out:  "‛␠\ns␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\nν",
	}, { // 724
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\vν",
		out:  "␠\vs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\vν",
	}, { // 725
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\vν",
		out:  "‛␠\vs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\vν",
	}, { // 726
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\rν",
		out:  "␠\rs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\rν",
	}, { // 727
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\rν",
		out:  "‛␠\rs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\rν",
	}, { // 728
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\ts␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\t ",
		out:  "\a\ts␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\t ",
	}, { // 729
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\ts␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\t␠",
		out:  "\a\ts␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\t␠",
	}, { // 730
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\ns␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\n ",
		out:  "\a\ns␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\n ",
	}, { // 731
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\ns␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\n␠",
		out:  "\a\ns␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\n␠",
	}, { // 732
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\vs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\v ",
		out:  "\a\vs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\v ",
	}, { // 733
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\vs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\v␠",
		out:  "\a\vs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\v␠",
	}, { // 734
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\rs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\r ",
		out:  "\a\rs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\r ",
	}, { // 735
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\rs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\r␠",
		out:  "\a\rs␋？\x01\bL７␗ｎ6＜θＫ＞ξT\x05Ｌ／=␔\x15χε-*\r␠",
	}, { // 736
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\tκ",
		out:  "␠\tP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\tκ",
	}, { // 737
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\tκ",
		out:  "‛␠\tP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\tκ",
	}, { // 738
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\nκ",
		out:  "␠\nP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\nκ",
	}, { // 739
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\nκ",
		out:  "‛␠\nP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\nκ",
	}, { // 740
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\vκ",
		out:  "␠\vP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\vκ",
	}, { // 741
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\vκ",
		out:  "‛␠\vP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\vκ",
	}, { // 742
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\rκ",
		out:  "␠\rP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\rκ",
	}, { // 743
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\rκ",
		out:  "‛␠\rP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\rκ",
	}, { // 744
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "#\tP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\t ",
		out:  "#\tP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\t ",
	}, { // 745
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "#\tP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\t␠",
		out:  "#\tP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\t␠",
	}, { // 746
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "#\nP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\n ",
		out:  "#\nP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\n ",
	}, { // 747
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "#\nP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\n␠",
		out:  "#\nP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\n␠",
	}, { // 748
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "#\vP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\v ",
		out:  "#\vP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\v ",
	}, { // 749
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "#\vP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\v␠",
		out:  "#\vP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\v␠",
	}, { // 750
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "#\rP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\r ",
		out:  "#\rP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\r ",
	}, { // 751
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "#\rP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\r␠",
		out:  "#\rP}\x0f␖＂｛κs｛ｍ,ｊ\\１\x1e^α，␋␏:ζχθ\x0f␘\r␠",
	}, { // 752
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". βD０η\x1aｉｚγX{%␛９\"\r␅:␉LβＥ\x1f\"Ｏ␇ς g",
		out:  "． βD０η\x1aｉｚγX{%␛９\"\r␅:␉LβＥ\x1f\"Ｏ␇ς g",
	}, { // 753
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． βD０η\x1aｉｚγX{%␛９\"\r␅:␉LβＥ\x1f\"Ｏ␇ς g",
		out:  "‛． βD０η\x1aｉｚγX{%␛９\"\r␅:␉LβＥ\x1f\"Ｏ␇ς g",
	}, { // 754
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␄ βD０η\x1aｉｚγX{%␛９\"\r␅:␉LβＥ\x1f\"Ｏ␇ς .",
		out:  "␄ βD０η\x1aｉｚγX{%␛９\"\r␅:␉LβＥ\x1f\"Ｏ␇ς .",
	}, { // 755
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␄ βD０η\x1aｉｚγX{%␛９\"\r␅:␉LβＥ\x1f\"Ｏ␇ς ．",
		out:  "␄ βD０η\x1aｉｚγX{%␛９\"\r␅:␉LβＥ\x1f\"Ｏ␇ς ．",
	}, { // 756
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ：Ｙ\x11κ␒＜HＭο9ｄ␗χ␊O/S／μｄπ\n MＴζ \u007f",
		out:  "． ：Ｙ\x11κ␒＜HＭο9ｄ␗χ␊O／S‛／μｄπ\n MＴζ \u007f",
	}, { // 757
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ：Ｙ\x11κ␒＜HＭο9ｄ␗χ␊O/S／μｄπ\n MＴζ \u007f",
		out:  "‛． ：Ｙ\x11κ␒＜HＭο9ｄ␗χ␊O／S‛／μｄπ\n MＴζ \u007f",
	}, { // 758
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␇ ：Ｙ\x11κ␒＜HＭο9ｄ␗χ␊O/S／μｄπ\n MＴζ .",
		out:  "␇ ：Ｙ\x11κ␒＜HＭο9ｄ␗χ␊O／S‛／μｄπ\n MＴζ .",
	}, { // 759
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␇ ：Ｙ\x11κ␒＜HＭο9ｄ␗χ␊O/S／μｄπ\n MＴζ ．",
		out:  "␇ ：Ｙ\x11κ␒＜HＭο9ｄ␗χ␊O／S‛／μｄπ\n MＴζ ．",
	}, { // 760
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". <８ψ\x0eＴηｌν␟\vnｋｚ`M（|\nδ\x06␊␝κu␟␙ :",
		out:  "． <８ψ\x0eＴηｌν␟\vnｋｚ`M（|\nδ\x06␊␝κu␟␙ :",
	}, { // 761
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． <８ψ\x0eＴηｌν␟\vnｋｚ`M（|\nδ\x06␊␝κu␟␙ :",
		out:  "‛． <８ψ\x0eＴηｌν␟\vnｋｚ`M（|\nδ\x06␊␝κu␟␙ :",
	}, { // 762
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "H <８ψ\x0eＴηｌν␟\vnｋｚ`M（|\nδ\x06␊␝κu␟␙ .",
		out:  "H <８ψ\x0eＴηｌν␟\vnｋｚ`M（|\nδ\x06␊␝κu␟␙ .",
	}, { // 763
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "H <８ψ\x0eＴηｌν␟\vnｋｚ`M（|\nδ\x06␊␝κu␟␙ ．",
		out:  "H <８ψ\x0eＴηｌν␟\vnｋｚ`M（|\nδ\x06␊␝κu␟␙ ．",
	}, { // 764
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". αο\\：␌Ｈ($\x17[:N␍ｄ␅９＜␝\v}>␋λζ＝θ ρ",
		out:  "． αο\\：␌Ｈ($\x17[:N␍ｄ␅９＜␝\v}>␋λζ＝θ ρ",
	}, { // 765
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． αο\\：␌Ｈ($\x17[:N␍ｄ␅９＜␝\v}>␋λζ＝θ ρ",
		out:  "‛． αο\\：␌Ｈ($\x17[:N␍ｄ␅９＜␝\v}>␋λζ＝θ ρ",
	}, { // 766
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "N αο\\：␌Ｈ($\x17[:N␍ｄ␅９＜␝\v}>␋λζ＝θ .",
		out:  "N αο\\：␌Ｈ($\x17[:N␍ｄ␅９＜␝\v}>␋λζ＝θ .",
	}, { // 767
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "N αο\\：␌Ｈ($\x17[:N␍ｄ␅９＜␝\v}>␋λζ＝θ ．",
		out:  "N αο\\：␌Ｈ($\x17[:N␍ｄ␅９＜␝\v}>␋λζ＝θ ．",
	}, { // 768
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ＊－\x13＜U＿{␒Ｉ＞\x05\x10\x0fω9υλｖ␊；\a␛^?ξν μ",
		out:  "． ＊－\x13‛＜U＿{␒Ｉ‛＞\x05\x10\x0fω9υλｖ␊；\a␛^?ξν μ",
	}, { // 769
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ＊－\x13＜U＿{␒Ｉ＞\x05\x10\x0fω9υλｖ␊；\a␛^?ξν μ",
		out:  "‛． ＊－\x13‛＜U＿{␒Ｉ‛＞\x05\x10\x0fω9υλｖ␊；\a␛^?ξν μ",
	}, { // 770
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␂ ＊－\x13＜U＿{␒Ｉ＞\x05\x10\x0fω9υλｖ␊；\a␛^?ξν .",
		out:  "␂ ＊－\x13‛＜U＿{␒Ｉ‛＞\x05\x10\x0fω9υλｖ␊；\a␛^?ξν .",
	}, { // 771
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␂ ＊－\x13＜U＿{␒Ｉ＞\x05\x10\x0fω9υλｖ␊；\a␛^?ξν ．",
		out:  "␂ ＊－\x13‛＜U＿{␒Ｉ‛＞\x05\x10\x0fω9υλｖ␊；\a␛^?ξν ．",
	}, { // 772
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ｈ＾␝Qγj2\x02＇σj'＞\x18␓~ＳＧ\nι\x10υｔ\x1cο␄ ␟",
		out:  "． ｈ＾␝Qγj2\x02＇σj'＞\x18␓~ＳＧ\nι\x10υｔ\x1cο␄ ␟",
	}, { // 773
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ｈ＾␝Qγj2\x02＇σj'＞\x18␓~ＳＧ\nι\x10υｔ\x1cο␄ ␟",
		out:  "‛． ｈ＾␝Qγj2\x02＇σj'＞\x18␓~ＳＧ\nι\x10υｔ\x1cο␄ ␟",
	}, { // 774
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "/ ｈ＾␝Qγj2\x02＇σj'＞\x18␓~ＳＧ\nι\x10υｔ\x1cο␄ .",
		out:  "/ ｈ＾␝Qγj2\x02＇σj'＞\x18␓~ＳＧ\nι\x10υｔ\x1cο␄ .",
	}, { // 775
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "/ ｈ＾␝Qγj2\x02＇σj'＞\x18␓~ＳＧ\nι\x10υｔ\x1cο␄ ．",
		out:  "/ ｈ＾␝Qγj2\x02＇σj'＞\x18␓~ＳＧ\nι\x10υｔ\x1cο␄ ．",
	}, { // 776
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ＼θω\x1cλ：\"KRｘ7$\x1eα␎｛sK｀βSβ␊］ｅ\x03 #",
		out:  "． ＼θω\x1cλ：＂KRｘ7$\x1eα␎｛sK｀βSβ␊］ｅ\x03 #",
	}, { // 777
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ＼θω\x1cλ：\"KRｘ7$\x1eα␎｛sK｀βSβ␊］ｅ\x03 #",
		out:  "‛． ＼θω\x1cλ：＂KRｘ7$\x1eα␎｛sK｀βSβ␊］ｅ\x03 #",
	}, { // 778
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␍ ＼θω\x1cλ：\"KRｘ7$\x1eα␎｛sK｀βSβ␊］ｅ\x03 .",
		out:  "␍ ＼θω\x1cλ：＂KRｘ7$\x1eα␎｛sK｀βSβ␊］ｅ\x03 .",
	}, { // 779
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␍ ＼θω\x1cλ：\"KRｘ7$\x1eα␎｛sK｀βSβ␊］ｅ\x03 ．",
		out:  "␍ ＼θω\x1cλ：＂KRｘ7$\x1eα␎｛sK｀βSβ␊］ｅ\x03 ．",
	}, { // 780
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ισ␎υＧ＜␓E\x12E）ζU％Ｒ␁\n<Ｖ\x05?r␕η\x13\\ ν",
		out:  "． ισ␎υＧ＜␓E\x12E）ζU％Ｒ␁\n<Ｖ\x05?r␕η\x13\\ ν",
	}, { // 781
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ισ␎υＧ＜␓E\x12E）ζU％Ｒ␁\n<Ｖ\x05?r␕η\x13\\ ν",
		out:  "‛． ισ␎υＧ＜␓E\x12E）ζU％Ｒ␁\n<Ｖ\x05?r␕η\x13\\ ν",
	}, { // 782
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "Ｇ ισ␎υＧ＜␓E\x12E）ζU％Ｒ␁\n<Ｖ\x05?r␕η\x13\\ .",
		out:  "Ｇ ισ␎υＧ＜␓E\x12E）ζU％Ｒ␁\n<Ｖ\x05?r␕η\x13\\ .",
	}, { // 783
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "Ｇ ισ␎υＧ＜␓E\x12E）ζU％Ｒ␁\n<Ｖ\x05?r␕η\x13\\ ．",
		out:  "Ｇ ισ␎υＧ＜␓E\x12E）ζU％Ｒ␁\n<Ｖ\x05?r␕η\x13\\ ．",
	}, { // 784
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ε␂\x18LGπT？％␍.\x0e␍εＨ\b␐-\x15φ＠PＣρ，> ｜",
		out:  "． ε␂\x18LGπT‛？％␍.\x0e␍εＨ\b␐-\x15φ＠PＣρ，> ｜",
	}, { // 785
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ε␂\x18LGπT？％␍.\x0e␍εＨ\b␐-\x15φ＠PＣρ，> ｜",
		out:  "‛． ε␂\x18LGπT‛？％␍.\x0e␍εＨ\b␐-\x15φ＠PＣρ，> ｜",
	}, { // 786
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "Ｈ ε␂\x18LGπT？％␍.\x0e␍εＨ\b␐-\x15φ＠PＣρ，> .",
		out:  "Ｈ ε␂\x18LGπT‛？％␍.\x0e␍εＨ\b␐-\x15φ＠PＣρ，> .",
	}, { // 787
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "Ｈ ε␂\x18LGπT？％␍.\x0e␍εＨ\b␐-\x15φ＠PＣρ，> ．",
		out:  "Ｈ ε␂\x18LGπT‛？％␍.\x0e␍εＨ\b␐-\x15φ＠PＣρ，> ．",
	}, { // 788
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ＼␍␎μＹν␕ａ<vξ<␓E/\u007f｛Ｌ;γEο\x1bρx< ６",
		out:  "． ＼␍␎μＹν␕ａ<vξ<␓E/\u007f｛Ｌ;γEο\x1bρx< ６",
	}, { // 789
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ＼␍␎μＹν␕ａ<vξ<␓E/\u007f｛Ｌ;γEο\x1bρx< ６",
		out:  "‛． ＼␍␎μＹν␕ａ<vξ<␓E/\u007f｛Ｌ;γEο\x1bρx< ６",
	}, { // 790
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "0 ＼␍␎μＹν␕ａ<vξ<␓E/\u007f｛Ｌ;γEο\x1bρx< .",
		out:  "0 ＼␍␎μＹν␕ａ<vξ<␓E/\u007f｛Ｌ;γEο\x1bρx< .",
	}, { // 791
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "0 ＼␍␎μＹν␕ａ<vξ<␓E/\u007f｛Ｌ;γEο\x1bρx< ．",
		out:  "0 ＼␍␎μＹν␕ａ<vξ<␓E/\u007f｛Ｌ;γEο\x1bρx< ．",
	}, { // 792
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ν＞＋８␔|％\r␌]：`＝#4\fψχβιLk␙ＥＥ8 ．",
		out:  "． ν＞＋８␔｜％\r␌]：`＝#4\fψχβιLk␙ＥＥ8 ．",
	}, { // 793
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ν＞＋８␔|％\r␌]：`＝#4\fψχβιLk␙ＥＥ8 ．",
		out:  "‛． ν＞＋８␔｜％\r␌]：`＝#4\fψχβιLk␙ＥＥ8 ．",
	}, { // 794
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "φ ν＞＋８␔|％\r␌]：`＝#4\fψχβιLk␙ＥＥ8 .",
		out:  "φ ν＞＋８␔｜％\r␌]：`＝#4\fψχβιLk␙ＥＥ8 .",
	}, { // 795
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "φ ν＞＋８␔|％\r␌]：`＝#4\fψχβιLk␙ＥＥ8 ．",
		out:  "φ ν＞＋８␔｜％\r␌]：`＝#4\fψχβιLk␙ＥＥ8 ．",
	}, { // 796
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␀|４␐Ｌ\x1d_:γ&φ␊α)β␘ρ␟\x11|␙\x02｝｛\\（ ＠",
		out:  "． ‛␀|４␐Ｌ\x1d_:γ&φ␊α)β␘ρ␟\x11|␙\x02｝｛\\（ ＠",
	}, { // 797
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␀|４␐Ｌ\x1d_:γ&φ␊α)β␘ρ␟\x11|␙\x02｝｛\\（ ＠",
		out:  "‛． ‛␀|４␐Ｌ\x1d_:γ&φ␊α)β␘ρ␟\x11|␙\x02｝｛\\（ ＠",
	}, { // 798
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "T ␀|４␐Ｌ\x1d_:γ&φ␊α)β␘ρ␟\x11|␙\x02｝｛\\（ .",
		out:  "T ‛␀|４␐Ｌ\x1d_:γ&φ␊α)β␘ρ␟\x11|␙\x02｝｛\\（ .",
	}, { // 799
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "T ␀|４␐Ｌ\x1d_:γ&φ␊α)β␘ρ␟\x11|␙\x02｝｛\\（ ．",
		out:  "T ‛␀|４␐Ｌ\x1d_:γ&φ␊α)β␘ρ␟\x11|␙\x02｝｛\\（ ．",
	}, { // 800
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␋I>２6\x00\x13χ＼６＞κ９␅λ$\nωＱξ％v␑#β/ ？",
		out:  "． ␋I>２6␀\x13χ＼６＞κ９␅λ$\nωＱξ‛％v␑#β/ ？",
	}, { // 801
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␋I>２6\x00\x13χ＼６＞κ９␅λ$\nωＱξ％v␑#β/ ？",
		out:  "‛． ␋I>２6␀\x13χ＼６＞κ９␅λ$\nωＱξ‛％v␑#β/ ？",
	}, { // 802
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\x1c ␋I>２6\x00\x13χ＼６＞κ９␅λ$\nωＱξ％v␑#β/ .",
		out:  "\x1c ␋I>２6␀\x13χ＼６＞κ９␅λ$\nωＱξ‛％v␑#β/ .",
	}, { // 803
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\x1c ␋I>２6\x00\x13χ＼６＞κ９␅λ$\nωＱξ％v␑#β/ ．",
		out:  "\x1c ␋I>２6␀\x13χ＼６＞κ９␅λ$\nωＱξ‛％v␑#β/ ．",
	}, { // 804
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ＠＂\x11\x02␑λＰ␉＃*ι\f\x05ξ\a2ｉＥυdS～＃β;4 \x01",
		out:  "． ＠＂\x11\x02␑λＰ␉＃*ι\f\x05ξ\a2ｉＥυdS～＃β;4 \x01",
	}, { // 805
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ＠＂\x11\x02␑λＰ␉＃*ι\f\x05ξ\a2ｉＥυdS～＃β;4 \x01",
		out:  "‛． ＠＂\x11\x02␑λＰ␉＃*ι\f\x05ξ\a2ｉＥυdS～＃β;4 \x01",
	}, { // 806
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "π ＠＂\x11\x02␑λＰ␉＃*ι\f\x05ξ\a2ｉＥυdS～＃β;4 .",
		out:  "π ＠＂\x11\x02␑λＰ␉＃*ι\f\x05ξ\a2ｉＥυdS～＃β;4 .",
	}, { // 807
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "π ＠＂\x11\x02␑λＰ␉＃*ι\f\x05ξ\a2ｉＥυdS～＃β;4 ．",
		out:  "π ＠＂\x11\x02␑λＰ␉＃*ι\f\x05ξ\a2ｉＥυdS～＃β;4 ．",
	}, { // 808
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". l␐\u007f␎\x02\x1b\x14␃η␟␅\x11ιη0ＢｌＣ␂ο9h+ｋπζ ｂ",
		out:  "． l␐\u007f␎\x02\x1b\x14␃η␟␅\x11ιη0ＢｌＣ␂ο9h+ｋπζ ｂ",
	}, { // 809
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． l␐\u007f␎\x02\x1b\x14␃η␟␅\x11ιη0ＢｌＣ␂ο9h+ｋπζ ｂ",
		out:  "‛． l␐\u007f␎\x02\x1b\x14␃η␟␅\x11ιη0ＢｌＣ␂ο9h+ｋπζ ｂ",
	}, { // 810
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "g l␐\u007f␎\x02\x1b\x14␃η␟␅\x11ιη0ＢｌＣ␂ο9h+ｋπζ .",
		out:  "g l␐\u007f␎\x02\x1b\x14␃η␟␅\x11ιη0ＢｌＣ␂ο9h+ｋπζ .",
	}, { // 811
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "g l␐\u007f␎\x02\x1b\x14␃η␟␅\x11ιη0ＢｌＣ␂ο9h+ｋπζ ．",
		out:  "g l␐\u007f␎\x02\x1b\x14␃η␟␅\x11ιη0ＢｌＣ␂ο9h+ｋπζ ．",
	}, { // 812
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". \x1bξｓ\x134ｓ␛n\n␅Ｊ:)␗βξ：$３8ｗ␓␛\x19#φ ν",
		out:  "． \x1bξｓ\x134ｓ␛n\n␅Ｊ:)␗βξ：$３8ｗ␓␛\x19#φ ν",
	}, { // 813
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． \x1bξｓ\x134ｓ␛n\n␅Ｊ:)␗βξ：$３8ｗ␓␛\x19#φ ν",
		out:  "‛． \x1bξｓ\x134ｓ␛n\n␅Ｊ:)␗βξ：$３8ｗ␓␛\x19#φ ν",
	}, { // 814
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "π \x1bξｓ\x134ｓ␛n\n␅Ｊ:)␗βξ：$３8ｗ␓␛\x19#φ .",
		out:  "π \x1bξｓ\x134ｓ␛n\n␅Ｊ:)␗βξ：$３8ｗ␓␛\x19#φ .",
	}, { // 815
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "π \x1bξｓ\x134ｓ␛n\n␅Ｊ:)␗βξ：$３8ｗ␓␛\x19#φ ．",
		out:  "π \x1bξｓ\x134ｓ␛n\n␅Ｊ:)␗βξ：$３8ｗ␓␛\x19#φ ．",
	}, { // 816
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ｒo４δ␙?␊|＼\x1cχ**Qω␋␛␎γ0~3ζ＜ψ\" ３",
		out:  "． ｒo４δ‛␙?‛␊|＼␜χ**Qω‛␋‛␛‛␎γ0~3ζ＜ψ\" ３",
	}, { // 817
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ｒo４δ␙?␊|＼\x1cχ**Qω␋␛␎γ0~3ζ＜ψ\" ３",
		out:  "‛． ｒo４δ‛␙?‛␊|＼␜χ**Qω‛␋‛␛‛␎γ0~3ζ＜ψ\" ３",
	}, { // 818
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "３ ｒo４δ␙?␊|＼\x1cχ**Qω␋␛␎γ0~3ζ＜ψ\" .",
		out:  "３ ｒo４δ‛␙?‛␊|＼␜χ**Qω‛␋‛␛‛␎γ0~3ζ＜ψ\" .",
	}, { // 819
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "３ ｒo４δ␙?␊|＼\x1cχ**Qω␋␛␎γ0~3ζ＜ψ\" ．",
		out:  "３ ｒo４δ‛␙?‛␊|＼␜χ**Qω‛␋‛␛‛␎γ0~3ζ＜ψ\" ．",
	}, { // 820
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~|i/χμ␂Oρ\x1aU␋υC:␘Ｙ：ｖ？\x0flν：φＫ２~/",
		out:  "．~|i/χμ␂Oρ\x1aU␋υC:␘Ｙ：ｖ？\x0flν：φＫ２~/",
	}, { // 821
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~|i/χμ␂Oρ\x1aU␋υC:␘Ｙ：ｖ？\x0flν：φＫ２~/",
		out:  "‛．~|i/χμ␂Oρ\x1aU␋υC:␘Ｙ：ｖ？\x0flν：φＫ２~/",
	}, { // 822
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␅~|i/χμ␂Oρ\x1aU␋υC:␘Ｙ：ｖ？\x0flν：φＫ２~.",
		out:  "␅~|i/χμ␂Oρ\x1aU␋υC:␘Ｙ：ｖ？\x0flν：φＫ２~.",
	}, { // 823
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␅~|i/χμ␂Oρ\x1aU␋υC:␘Ｙ：ｖ？\x0flν：φＫ２~．",
		out:  "␅~|i/χμ␂Oρ\x1aU␋υC:␘Ｙ：ｖ？\x0flν：φＫ２~．",
	}, { // 824
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~`Ｓ＇␕Ｉ｜␛３Xχkπ#\b\x10ｂ␈\vπθ␁wγ`\x0f␛~D",
		out:  "．~`Ｓ＇␕Ｉ｜␛３Xχkπ#\b\x10ｂ␈\vπθ␁wγ`\x0f␛~D",
	}, { // 825
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~`Ｓ＇␕Ｉ｜␛３Xχkπ#\b\x10ｂ␈\vπθ␁wγ`\x0f␛~D",
		out:  "‛．~`Ｓ＇␕Ｉ｜␛３Xχkπ#\b\x10ｂ␈\vπθ␁wγ`\x0f␛~D",
	}, { // 826
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ν~`Ｓ＇␕Ｉ｜␛３Xχkπ#\b\x10ｂ␈\vπθ␁wγ`\x0f␛~.",
		out:  "ν~`Ｓ＇␕Ｉ｜␛３Xχkπ#\b\x10ｂ␈\vπθ␁wγ`\x0f␛~.",
	}, { // 827
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ν~`Ｓ＇␕Ｉ｜␛３Xχkπ#\b\x10ｂ␈\vπθ␁wγ`\x0f␛~．",
		out:  "ν~`Ｓ＇␕Ｉ｜␛３Xχkπ#\b\x10ｂ␈\vπθ␁wγ`\x0f␛~．",
	}, { // 828
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~␄λ7］ｘ\n:\a ε９ＸＫ\x00\x06␜／?ιZθＹ\x17\nm␞~ω",
		out:  "．~␄λ7］ｘ\n:\a ε９ＸＫ␀\x06␜／?ιZθＹ\x17\nm␞~ω",
	}, { // 829
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~␄λ7］ｘ\n:\a ε９ＸＫ\x00\x06␜／?ιZθＹ\x17\nm␞~ω",
		out:  "‛．~␄λ7］ｘ\n:\a ε９ＸＫ␀\x06␜／?ιZθＹ\x17\nm␞~ω",
	}, { // 830
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "η~␄λ7］ｘ\n:\a ε９ＸＫ\x00\x06␜／?ιZθＹ\x17\nm␞~.",
		out:  "η~␄λ7］ｘ\n:\a ε９ＸＫ␀\x06␜／?ιZθＹ\x17\nm␞~.",
	}, { // 831
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "η~␄λ7］ｘ\n:\a ε９ＸＫ\x00\x06␜／?ιZθＹ\x17\nm␞~．",
		out:  "η~␄λ7］ｘ\n:\a ε９ＸＫ␀\x06␜／?ιZθＹ\x17\nm␞~．",
	}, { // 832
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~Ｆ␐４bFδ／\vω２φ'$＊ｉζ␞\x04ｄ\x1dＶπ\x01\f＄m~γ",
		out:  "．~Ｆ␐４bFδ／\vω２φ'$＊ｉζ␞\x04ｄ\x1dＶπ\x01\f＄m~γ",
	}, { // 833
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~Ｆ␐４bFδ／\vω２φ'$＊ｉζ␞\x04ｄ\x1dＶπ\x01\f＄m~γ",
		out:  "‛．~Ｆ␐４bFδ／\vω２φ'$＊ｉζ␞\x04ｄ\x1dＶπ\x01\f＄m~γ",
	}, { // 834
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␒~Ｆ␐４bFδ／\vω２φ'$＊ｉζ␞\x04ｄ\x1dＶπ\x01\f＄m~.",
		out:  "␒~Ｆ␐４bFδ／\vω２φ'$＊ｉζ␞\x04ｄ\x1dＶπ\x01\f＄m~.",
	}, { // 835
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␒~Ｆ␐４bFδ／\vω２φ'$＊ｉζ␞\x04ｄ\x1dＶπ\x01\f＄m~．",
		out:  "␒~Ｆ␐４bFδ／\vω２φ'$＊ｉζ␞\x04ｄ\x1dＶπ\x01\f＄m~．",
	}, { // 836
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~ε␝5κ\x15τ<τ\x11␝|z\b\r^[\x06ｇｏ］␍κ␅ｊ␐\x15~Ｎ",
		out:  "．~ε␝5κ\x15τ＜τ\x11␝|z\b\r^[\x06ｇｏ］␍κ␅ｊ␐\x15~Ｎ",
	}, { // 837
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~ε␝5κ\x15τ<τ\x11␝|z\b\r^[\x06ｇｏ］␍κ␅ｊ␐\x15~Ｎ",
		out:  "‛．~ε␝5κ\x15τ＜τ\x11␝|z\b\r^[\x06ｇｏ］␍κ␅ｊ␐\x15~Ｎ",
	}, { // 838
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ζ~ε␝5κ\x15τ<τ\x11␝|z\b\r^[\x06ｇｏ］␍κ␅ｊ␐\x15~.",
		out:  "ζ~ε␝5κ\x15τ＜τ\x11␝|z\b\r^[\x06ｇｏ］␍κ␅ｊ␐\x15~.",
	}, { // 839
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ζ~ε␝5κ\x15τ<τ\x11␝|z\b\r^[\x06ｇｏ］␍κ␅ｊ␐\x15~．",
		out:  "ζ~ε␝5κ\x15τ＜τ\x11␝|z\b\r^[\x06ｇｏ］␍κ␅ｊ␐\x15~．",
	}, { // 840
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~ο\x1dｕｘ␗～Ｅ(␒σ>|␜ηαT>␞3␋８\nＷ\x18εW~ζ",
		out:  "．~ο\x1dｕｘ␗～Ｅ(␒σ>|␜ηαT>␞3␋８\nＷ\x18εW~ζ",
	}, { // 841
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~ο\x1dｕｘ␗～Ｅ(␒σ>|␜ηαT>␞3␋８\nＷ\x18εW~ζ",
		out:  "‛．~ο\x1dｕｘ␗～Ｅ(␒σ>|␜ηαT>␞3␋８\nＷ\x18εW~ζ",
	}, { // 842
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "'~ο\x1dｕｘ␗～Ｅ(␒σ>|␜ηαT>␞3␋８\nＷ\x18εW~.",
		out:  "'~ο\x1dｕｘ␗～Ｅ(␒σ>|␜ηαT>␞3␋８\nＷ\x18εW~.",
	}, { // 843
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "'~ο\x1dｕｘ␗～Ｅ(␒σ>|␜ηαT>␞3␋８\nＷ\x18εW~．",
		out:  "'~ο\x1dｕｘ␗～Ｅ(␒σ>|␜ηαT>␞3␋８\nＷ\x18εW~．",
	}, { // 844
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~3/＞＝＼＼μy－Dｚ␡＂Fκ\n=\nμ\\ｄπ｜␜ψ\n~\b",
		out:  "．~3/＞＝＼＼μy－Dｚ␡‛＂Fκ\n=\nμ\\ｄπ｜␜ψ\n~\b",
	}, { // 845
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~3/＞＝＼＼μy－Dｚ␡＂Fκ\n=\nμ\\ｄπ｜␜ψ\n~\b",
		out:  "‛．~3/＞＝＼＼μy－Dｚ␡‛＂Fκ\n=\nμ\\ｄπ｜␜ψ\n~\b",
	}, { // 846
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␚~3/＞＝＼＼μy－Dｚ␡＂Fκ\n=\nμ\\ｄπ｜␜ψ\n~.",
		out:  "␚~3/＞＝＼＼μy－Dｚ␡‛＂Fκ\n=\nμ\\ｄπ｜␜ψ\n~.",
	}, { // 847
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␚~3/＞＝＼＼μy－Dｚ␡＂Fκ\n=\nμ\\ｄπ｜␜ψ\n~．",
		out:  "␚~3/＞＝＼＼μy－Dｚ␡‛＂Fκ\n=\nμ\\ｄπ｜␜ψ\n~．",
	}, { // 848
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~ζ\x1dＰζ␍ｙＸb␗＜λο１－^D^:␊＠]\x11\v#<e~υ",
		out:  "．~ζ\x1dＰζ␍ｙＸb␗＜λο１－^D^：␊＠]\x11\v#<e~υ",
	}, { // 849
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~ζ\x1dＰζ␍ｙＸb␗＜λο１－^D^:␊＠]\x11\v#<e~υ",
		out:  "‛．~ζ\x1dＰζ␍ｙＸb␗＜λο１－^D^：␊＠]\x11\v#<e~υ",
	}, { // 850
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␔~ζ\x1dＰζ␍ｙＸb␗＜λο１－^D^:␊＠]\x11\v#<e~.",
		out:  "␔~ζ\x1dＰζ␍ｙＸb␗＜λο１－^D^：␊＠]\x11\v#<e~.",
	}, { // 851
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␔~ζ\x1dＰζ␍ｙＸb␗＜λο１－^D^:␊＠]\x11\v#<e~．",
		out:  "␔~ζ\x1dＰζ␍ｙＸb␗＜λο１－^D^：␊＠]\x11\v#<e~．",
	}, { // 852
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~Sω?␍\x01＃,Ｈ␛\tｔｏλ␒\x1eAWτνＩ\x1cσ#$␄Ｉ~＋",
		out:  "．~Sω？␍\x01＃,Ｈ␛\tｔｏλ␒\x1eAWτνＩ\x1cσ#$␄Ｉ~＋",
	}, { // 853
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~Sω?␍\x01＃,Ｈ␛\tｔｏλ␒\x1eAWτνＩ\x1cσ#$␄Ｉ~＋",
		out:  "‛．~Sω？␍\x01＃,Ｈ␛\tｔｏλ␒\x1eAWτνＩ\x1cσ#$␄Ｉ~＋",
	}, { // 854
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ν~Sω?␍\x01＃,Ｈ␛\tｔｏλ␒\x1eAWτνＩ\x1cσ#$␄Ｉ~.",
		out:  "ν~Sω？␍\x01＃,Ｈ␛\tｔｏλ␒\x1eAWτνＩ\x1cσ#$␄Ｉ~.",
	}, { // 855
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ν~Sω?␍\x01＃,Ｈ␛\tｔｏλ␒\x1eAWτνＩ\x1cσ#$␄Ｉ~．",
		out:  "ν~Sω？␍\x01＃,Ｈ␛\tｔｏλ␒\x1eAWτνＩ\x1cσ#$␄Ｉ~．",
	}, { // 856
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~％cFτ␏␜４$［␒υFναＴφK：\x1f\"＃Ｗ<\x1cＤ；~\x17",
		out:  "．~％cFτ␏␜４$［␒υFναＴφK：\x1f\"＃Ｗ<\x1cＤ；~\x17",
	}, { // 857
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~％cFτ␏␜４$［␒υFναＴφK：\x1f\"＃Ｗ<\x1cＤ；~\x17",
		out:  "‛．~％cFτ␏␜４$［␒υFναＴφK：\x1f\"＃Ｗ<\x1cＤ；~\x17",
	}, { // 858
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "<~％cFτ␏␜４$［␒υFναＴφK：\x1f\"＃Ｗ<\x1cＤ；~.",
		out:  "<~％cFτ␏␜４$［␒υFναＴφK：\x1f\"＃Ｗ<\x1cＤ；~.",
	}, { // 859
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "<~％cFτ␏␜４$［␒υFναＴφK：\x1f\"＃Ｗ<\x1cＤ；~．",
		out:  "<~％cFτ␏␜４$［␒υFναＴφK：\x1f\"＃Ｗ<\x1cＤ；~．",
	}, { // 860
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~e\x19ｃＴｇ␈␍ＦＰP$^βR␃:α␄ι:μ\b␍%＃ο~ν",
		out:  "．~e\x19ｃＴｇ␈␍ＦＰP$^βR␃:α␄ι:μ\b␍%＃ο~ν",
	}, { // 861
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~e\x19ｃＴｇ␈␍ＦＰP$^βR␃:α␄ι:μ\b␍%＃ο~ν",
		out:  "‛．~e\x19ｃＴｇ␈␍ＦＰP$^βR␃:α␄ι:μ\b␍%＃ο~ν",
	}, { // 862
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~e\x19ｃＴｇ␈␍ＦＰP$^βR␃:α␄ι:μ\b␍%＃ο~.",
		out:  "‛．~e\x19ｃＴｇ␈␍ＦＰP$^βR␃:α␄ι:μ\b␍%＃ο~.",
	}, { // 863
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~e\x19ｃＴｇ␈␍ＦＰP$^βR␃:α␄ι:μ\b␍%＃ο~．",
		out:  "‛．~e\x19ｃＴｇ␈␍ＦＰP$^βR␃:α␄ι:μ\b␍%＃ο~．",
	}, { // 864
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~CｕＥ９εη$\x13βοｒ\x10␓\x1fａ＄6␆/\x13％κ／iｇD~η",
		out:  "．~CｕＥ９εη$\x13βοｒ\x10␓\x1fａ＄6␆/\x13％κ／iｇD~η",
	}, { // 865
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~CｕＥ９εη$\x13βοｒ\x10␓\x1fａ＄6␆/\x13％κ／iｇD~η",
		out:  "‛．~CｕＥ９εη$\x13βοｒ\x10␓\x1fａ＄6␆/\x13％κ／iｇD~η",
	}, { // 866
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "9~CｕＥ９εη$\x13βοｒ\x10␓\x1fａ＄6␆/\x13％κ／iｇD~.",
		out:  "9~CｕＥ９εη$\x13βοｒ\x10␓\x1fａ＄6␆/\x13％κ／iｇD~.",
	}, { // 867
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "9~CｕＥ９εη$\x13βοｒ\x10␓\x1fａ＄6␆/\x13％κ／iｇD~．",
		out:  "9~CｕＥ９εη$\x13βοｒ\x10␓\x1fａ＄6␆/\x13％κ／iｇD~．",
	}, { // 868
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~θ␊μ｀ενn#＜\v\u007f＂ｇς/␏！\u007fｅZπS}\x1a`␜~／",
		out:  "．~θ␊μ｀ενn#＜\v\u007f＂ｇς/␏！\u007fｅZπS}\x1a`␜~／",
	}, { // 869
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~θ␊μ｀ενn#＜\v\u007f＂ｇς/␏！\u007fｅZπS}\x1a`␜~／",
		out:  "‛．~θ␊μ｀ενn#＜\v\u007f＂ｇς/␏！\u007fｅZπS}\x1a`␜~／",
	}, { // 870
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\n~θ␊μ｀ενn#＜\v\u007f＂ｇς/␏！\u007fｅZπS}\x1a`␜~.",
		out:  "\n~θ␊μ｀ενn#＜\v\u007f＂ｇς/␏！\u007fｅZπS}\x1a`␜~.",
	}, { // 871
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\n~θ␊μ｀ενn#＜\v\u007f＂ｇς/␏！\u007fｅZπS}\x1a`␜~．",
		out:  "\n~θ␊μ｀ενn#＜\v\u007f＂ｇς/␏！\u007fｅZπS}\x1a`␜~．",
	}, { // 872
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~ＸC␋(\x1c␁δ／δ␗\v＊\x04/πα＄7\t␝κυ!#\x13／~a",
		out:  "．~ＸC␋(\x1c␁δ／δ␗\v＊\x04/πα＄7\t␝κυ!#\x13／~a",
	}, { // 873
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~ＸC␋(\x1c␁δ／δ␗\v＊\x04/πα＄7\t␝κυ!#\x13／~a",
		out:  "‛．~ＸC␋(\x1c␁δ／δ␗\v＊\x04/πα＄7\t␝κυ!#\x13／~a",
	}, { // 874
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "｝~ＸC␋(\x1c␁δ／δ␗\v＊\x04/πα＄7\t␝κυ!#\x13／~.",
		out:  "｝~ＸC␋(\x1c␁δ／δ␗\v＊\x04/πα＄7\t␝κυ!#\x13／~.",
	}, { // 875
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "｝~ＸC␋(\x1c␁δ／δ␗\v＊\x04/πα＄7\t␝κυ!#\x13／~．",
		out:  "｝~ＸC␋(\x1c␁δ／δ␗\v＊\x04/πα＄7\t␝κυ!#\x13／~．",
	}, { // 876
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~Ｗσ␉｜\x00␞\x02ω＇ο␓αＬ␇？j\bq\x1d\\βs｀\x19,8~γ",
		out:  "．~Ｗσ␉｜␀␞\x02ω＇ο␓αＬ␇？j\bq\x1d\\βs｀\x19,8~γ",
	}, { // 877
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~Ｗσ␉｜\x00␞\x02ω＇ο␓αＬ␇？j\bq\x1d\\βs｀\x19,8~γ",
		out:  "‛．~Ｗσ␉｜␀␞\x02ω＇ο␓αＬ␇？j\bq\x1d\\βs｀\x19,8~γ",
	}, { // 878
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "｝~Ｗσ␉｜\x00␞\x02ω＇ο␓αＬ␇？j\bq\x1d\\βs｀\x19,8~.",
		out:  "｝~Ｗσ␉｜␀␞\x02ω＇ο␓αＬ␇？j\bq\x1d\\βs｀\x19,8~.",
	}, { // 879
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "｝~Ｗσ␉｜\x00␞\x02ω＇ο␓αＬ␇？j\bq\x1d\\βs｀\x19,8~．",
		out:  "｝~Ｗσ␉｜␀␞\x02ω＇ο␓αＬ␇？j\bq\x1d\\βs｀\x19,8~．",
	}, { // 880
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~ｄ\x1c｜ξ\x06ν｀U|７H９␡５␎\u007fφ'~βλ#ε＿\x101~␍",
		out:  "．~ｄ\x1c｜ξ\x06ν｀U|７H９‛␡５␎␡φ'~βλ#ε＿\x101~␍",
	}, { // 881
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~ｄ\x1c｜ξ\x06ν｀U|７H９␡５␎\u007fφ'~βλ#ε＿\x101~␍",
		out:  "‛．~ｄ\x1c｜ξ\x06ν｀U|７H９‛␡５␎␡φ'~βλ#ε＿\x101~␍",
	}, { // 882
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␝~ｄ\x1c｜ξ\x06ν｀U|７H９␡５␎\u007fφ'~βλ#ε＿\x101~.",
		out:  "␝~ｄ\x1c｜ξ\x06ν｀U|７H９‛␡５␎␡φ'~βλ#ε＿\x101~.",
	}, { // 883
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␝~ｄ\x1c｜ξ\x06ν｀U|７H９␡５␎\u007fφ'~βλ#ε＿\x101~．",
		out:  "␝~ｄ\x1c｜ξ\x06ν｀U|７H９‛␡５␎␡φ'~βλ#ε＿\x101~．",
	}, { // 884
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~O＄}π␞ｈｅ␏>＂\n(ς\aμ␌：uμｓι␊\x04ω＆␇~@",
		out:  "．~O＄}π‛␞ｈｅ‛␏>＂␊(ς␇μ‛␌：uμｓι‛␊␄ω＆‛␇~@",
	}, { // 885
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~O＄}π␞ｈｅ␏>＂\n(ς\aμ␌：uμｓι␊\x04ω＆␇~@",
		out:  "‛．~O＄}π‛␞ｈｅ‛␏>＂␊(ς␇μ‛␌：uμｓι‛␊␄ω＆‛␇~@",
	}, { // 886
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\x1f~O＄}π␞ｈｅ␏>＂\n(ς\aμ␌：uμｓι␊\x04ω＆␇~.",
		out:  "␟~O＄}π‛␞ｈｅ‛␏>＂␊(ς␇μ‛␌：uμｓι‛␊␄ω＆‛␇~.",
	}, { // 887
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\x1f~O＄}π␞ｈｅ␏>＂\n(ς\aμ␌：uμｓι␊\x04ω＆␇~．",
		out:  "␟~O＄}π‛␞ｈｅ‛␏>＂␊(ς␇μ‛␌：uμｓι‛␊␄ω＆‛␇~．",
	}, { // 888
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\t＼",
		out:  "．\t\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\t＼",
	}, { // 889
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\t＼",
		out:  "‛．\t\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\t＼",
	}, { // 890
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\n＼",
		out:  "．\n\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\n＼",
	}, { // 891
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\n＼",
		out:  "‛．\n\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\n＼",
	}, { // 892
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\v＼",
		out:  "．\v\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\v＼",
	}, { // 893
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\v＼",
		out:  "‛．\v\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\v＼",
	}, { // 894
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\r＼",
		out:  "．\r\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\r＼",
	}, { // 895
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\r＼",
		out:  "‛．\r\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\r＼",
	}, { // 896
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "？\t\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\t.",
		out:  "？\t\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\t.",
	}, { // 897
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "？\t\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\t．",
		out:  "？\t\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\t．",
	}, { // 898
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "？\n\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\n.",
		out:  "？\n\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\n.",
	}, { // 899
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "？\n\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\n．",
		out:  "？\n\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\n．",
	}, { // 900
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "？\v\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\v.",
		out:  "？\v\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\v.",
	}, { // 901
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "？\v\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\v．",
		out:  "？\v\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\v．",
	}, { // 902
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "？\r\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\r.",
		out:  "？\r\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\r.",
	}, { // 903
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "？\r\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\r．",
		out:  "？\r\x1a\x175ηＰf-\x1aς␂␈＞＊\ai\x03μ]\neδ␁μＰ／␚\r．",
	}, { // 904
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\t\u007f",
		out:  "．\t#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\t\u007f",
	}, { // 905
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\t\u007f",
		out:  "‛．\t#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\t\u007f",
	}, { // 906
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\n\u007f",
		out:  "．\n#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\n\u007f",
	}, { // 907
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\n\u007f",
		out:  "‛．\n#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\n\u007f",
	}, { // 908
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\v\u007f",
		out:  "．\v#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\v\u007f",
	}, { // 909
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\v\u007f",
		out:  "‛．\v#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\v\u007f",
	}, { // 910
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\r\u007f",
		out:  "．\r#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\r\u007f",
	}, { // 911
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\r\u007f",
		out:  "‛．\r#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\r\u007f",
	}, { // 912
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␘\t#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\t.",
		out:  "␘\t#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\t.",
	}, { // 913
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␘\t#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\t．",
		out:  "␘\t#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\t．",
	}, { // 914
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␘\n#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\n.",
		out:  "␘\n#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\n.",
	}, { // 915
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␘\n#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\n．",
		out:  "␘\n#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\n．",
	}, { // 916
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␘\v#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\v.",
		out:  "␘\v#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\v.",
	}, { // 917
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␘\v#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\v．",
		out:  "␘\v#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\v．",
	}, { // 918
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␘\r#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\r.",
		out:  "␘\r#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\r.",
	}, { // 919
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␘\r#＿␅␙６'iＷ＂'ηξZU／\x18`ε~\x02ιｘξ4Ｋ：\r．",
		out:  "␘\r#＿␅␙６'iＷ＂'ηξZU‛／\x18`ε~\x02ιｘξ4Ｋ：\r．",
	}, { // 920
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\t␕",
		out:  "．\tζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\t␕",
	}, { // 921
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\t␕",
		out:  "‛．\tζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\t␕",
	}, { // 922
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\n␕",
		out:  "．\nζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\n␕",
	}, { // 923
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\n␕",
		out:  "‛．\nζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\n␕",
	}, { // 924
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\v␕",
		out:  "．\vζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\v␕",
	}, { // 925
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\v␕",
		out:  "‛．\vζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\v␕",
	}, { // 926
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\r␕",
		out:  "．\rζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\r␕",
	}, { // 927
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\r␕",
		out:  "‛．\rζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\r␕",
	}, { // 928
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\tζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\t.",
		out:  "\b\tζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\t.",
	}, { // 929
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\tζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\t．",
		out:  "\b\tζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\t．",
	}, { // 930
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\nζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\n.",
		out:  "\b\nζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\n.",
	}, { // 931
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\nζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\n．",
		out:  "\b\nζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\n．",
	}, { // 932
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\vζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\v.",
		out:  "\b\vζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\v.",
	}, { // 933
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\vζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\v．",
		out:  "\b\vζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\v．",
	}, { // 934
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\rζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\r.",
		out:  "\b\rζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\r.",
	}, { // 935
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\rζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２\x00␑␟＊：μ\r．",
		out:  "\b\rζHH␇φP%\x10&\x03（Ｓ␘/YqρＴξ２␀␑␟＊：μ\r．",
	}, { // 936
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\t␊",
		out:  "．\t［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\t␊",
	}, { // 937
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\t␊",
		out:  "‛．\t［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\t␊",
	}, { // 938
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\n␊",
		out:  "．\n［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\n␊",
	}, { // 939
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\n␊",
		out:  "‛．\n［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\n␊",
	}, { // 940
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\v␊",
		out:  "．\v［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\v␊",
	}, { // 941
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\v␊",
		out:  "‛．\v［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\v␊",
	}, { // 942
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\r␊",
		out:  "．\r［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\r␊",
	}, { // 943
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\r␊",
		out:  "‛．\r［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\r␊",
	}, { // 944
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "J\t［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\t.",
		out:  "J\t［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\t.",
	}, { // 945
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "J\t［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\t．",
		out:  "J\t［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\t．",
	}, { // 946
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "J\n［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\n.",
		out:  "J\n［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\n.",
	}, { // 947
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "J\n［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\n．",
		out:  "J\n［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\n．",
	}, { // 948
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "J\v［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\v.",
		out:  "J\v［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\v.",
	}, { // 949
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "J\v［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\v．",
		out:  "J\v［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\v．",
	}, { // 950
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "J\r［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\r.",
		out:  "J\r［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\r.",
	}, { // 951
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "J\r［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\r．",
		out:  "J\r［φ\n'＿Ｓ／γθ\bν\bφ\x1e3Ｖ％UＤ␃m␅φF\x0f|\r．",
	}, { // 952
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\t\x04",
		out:  "．\t\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\t\x04",
	}, { // 953
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\t\x04",
		out:  "‛．\t\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\t\x04",
	}, { // 954
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\n\x04",
		out:  "．\n\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\n\x04",
	}, { // 955
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\n\x04",
		out:  "‛．\n\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\n\x04",
	}, { // 956
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\v\x04",
		out:  "．\v\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\v\x04",
	}, { // 957
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\v\x04",
		out:  "‛．\v\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\v\x04",
	}, { // 958
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\r\x04",
		out:  "．\r\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\r\x04",
	}, { // 959
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\r\x04",
		out:  "‛．\r\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\r\x04",
	}, { // 960
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ｐ\t\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\t.",
		out:  "ｐ\t\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\t.",
	}, { // 961
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ｐ\t\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\t．",
		out:  "ｐ\t\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\t．",
	}, { // 962
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ｐ\n\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\n.",
		out:  "ｐ\n\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\n.",
	}, { // 963
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ｐ\n\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\n．",
		out:  "ｐ\n\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\n．",
	}, { // 964
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ｐ\v\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\v.",
		out:  "ｐ\v\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\v.",
	}, { // 965
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ｐ\v\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\v．",
		out:  "ｐ\v\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\v．",
	}, { // 966
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ｐ\r\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\r.",
		out:  "ｐ\r\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\r.",
	}, { // 967
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ｐ\r\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\r．",
		out:  "ｐ\r\x03␒＼Ｙ｀Ｊπ{Ｋ/W␘πηθ␇βJ\nyuφX␍␉/\r．",
	}, { // 968
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\t␜",
		out:  "．\tγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\t␜",
	}, { // 969
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\t␜",
		out:  "‛．\tγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\t␜",
	}, { // 970
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\n␜",
		out:  "．\nγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\n␜",
	}, { // 971
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\n␜",
		out:  "‛．\nγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\n␜",
	}, { // 972
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\v␜",
		out:  "．\vγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\v␜",
	}, { // 973
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\v␜",
		out:  "‛．\vγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\v␜",
	}, { // 974
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\r␜",
		out:  "．\rγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\r␜",
	}, { // 975
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\r␜",
		out:  "‛．\rγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\r␜",
	}, { // 976
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＆\tγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\t.",
		out:  "＆\tγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\t.",
	}, { // 977
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＆\tγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\t．",
		out:  "＆\tγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\t．",
	}, { // 978
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＆\nγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\n.",
		out:  "＆\nγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\n.",
	}, { // 979
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＆\nγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\n．",
		out:  "＆\nγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\n．",
	}, { // 980
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＆\vγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\v.",
		out:  "＆\vγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\v.",
	}, { // 981
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＆\vγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\v．",
		out:  "＆\vγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\v．",
	}, { // 982
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＆\rγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\r.",
		out:  "＆\rγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\r.",
	}, { // 983
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＆\rγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\r．",
		out:  "＆\rγ\x13γ\tｑ|Z％δσ␋ＯτB<＝ψ/x*␊%␆␎`\x18\r．",
	}, { // 984
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\t␍",
		out:  "．\tＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\t␍",
	}, { // 985
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\t␍",
		out:  "‛．\tＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\t␍",
	}, { // 986
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\n␍",
		out:  "．\nＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\n␍",
	}, { // 987
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\n␍",
		out:  "‛．\nＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\n␍",
	}, { // 988
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\v␍",
		out:  "．\vＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\v␍",
	}, { // 989
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\v␍",
		out:  "‛．\vＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\v␍",
	}, { // 990
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\r␍",
		out:  "．\rＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\r␍",
	}, { // 991
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\r␍",
		out:  "‛．\rＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\r␍",
	}, { // 992
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "π\tＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\t.",
		out:  "π\tＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\t.",
	}, { // 993
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "π\tＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\t．",
		out:  "π\tＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\t．",
	}, { // 994
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "π\nＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\n.",
		out:  "π\nＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\n.",
	}, { // 995
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "π\nＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\n．",
		out:  "π\nＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\n．",
	}, { // 996
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "π\vＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\v.",
		out:  "π\vＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\v.",
	}, { // 997
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "π\vＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\v．",
		out:  "π\vＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\v．",
	}, { // 998
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "π\rＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\r.",
		out:  "π\rＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\r.",
	}, { // 999
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "π\rＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15\"L\r\x02πｆ<ω\r．",
		out:  "π\rＴ９ｇn}ξｕ\r＃␝ζ（κYN␍␁\x15＂L\r\x02πｆ<ω\r．",
	}, { // 1000
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\tπ",
		out:  "．\tρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\tπ",
	}, { // 1001
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\tπ",
		out:  "‛．\tρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\tπ",
	}, { // 1002
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\nπ",
		out:  "．\nρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\nπ",
	}, { // 1003
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\nπ",
		out:  "‛．\nρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\nπ",
	}, { // 1004
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\vπ",
		out:  "．\vρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\vπ",
	}, { // 1005
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\vπ",
		out:  "‛．\vρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\vπ",
	}, { // 1006
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\rπ",
		out:  "．\rρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\rπ",
	}, { // 1007
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\rπ",
		out:  "‛．\rρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\rπ",
	}, { // 1008
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\tρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\t.",
		out:  ">\tρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\t.",
	}, { // 1009
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\tρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\t．",
		out:  ">\tρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\t．",
	}, { // 1010
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\nρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\n.",
		out:  ">\nρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\n.",
	}, { // 1011
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\nρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\n．",
		out:  ">\nρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\n．",
	}, { // 1012
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\vρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\v.",
		out:  ">\vρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\v.",
	}, { // 1013
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\vρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\v．",
		out:  ">\vρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\v．",
	}, { // 1014
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\rρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\r.",
		out:  ">\rρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\r.",
	}, { // 1015
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\rρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ:eF:\r．",
		out:  ">\rρNχＲｃU␉\x0e>Ｑ\x1dθ␅cＦＡ\x0f＝␊＞φζ：eF：\r．",
	}, { // 1016
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\t|",
		out:  "．\tＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\t|",
	}, { // 1017
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\t|",
		out:  "‛．\tＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\t|",
	}, { // 1018
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\n|",
		out:  "．\nＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\n|",
	}, { // 1019
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\n|",
		out:  "‛．\nＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\n|",
	}, { // 1020
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\v|",
		out:  "．\vＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\v|",
	}, { // 1021
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\v|",
		out:  "‛．\vＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\v|",
	}, { // 1022
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\r|",
		out:  "．\rＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\r|",
	}, { // 1023
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\r|",
		out:  "‛．\rＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\r|",
	}, { // 1024
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␕\tＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\t.",
		out:  "␕\tＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\t.",
	}, { // 1025
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␕\tＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\t．",
		out:  "␕\tＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\t．",
	}, { // 1026
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␕\nＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\n.",
		out:  "␕\nＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\n.",
	}, { // 1027
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␕\nＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\n．",
		out:  "␕\nＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\n．",
	}, { // 1028
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␕\vＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\v.",
		out:  "␕\vＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\v.",
	}, { // 1029
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␕\vＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\v．",
		out:  "␕\vＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\v．",
	}, { // 1030
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␕\rＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\r.",
		out:  "␕\rＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\r.",
	}, { // 1031
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␕\rＶＰ\x1b\rς／E５Z␚\x1e；␌ως␀π=eｒ␋Ｌ\x18λφ#\r．",
		out:  "␕\rＶＰ\x1b\rς／E５Z␚\x1e；␌ως‛␀π=eｒ␋Ｌ\x18λφ#\r．",
	}, { // 1032
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\tα",
		out:  "．\tＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\tα",
	}, { // 1033
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\tα",
		out:  "‛．\tＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\tα",
	}, { // 1034
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\nα",
		out:  "．\nＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\nα",
	}, { // 1035
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\nα",
		out:  "‛．\nＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\nα",
	}, { // 1036
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\vα",
		out:  "．\vＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\vα",
	}, { // 1037
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\vα",
		out:  "‛．\vＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\vα",
	}, { // 1038
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\rα",
		out:  "．\rＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\rα",
	}, { // 1039
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\rα",
		out:  "‛．\rＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\rα",
	}, { // 1040
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\tＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\t.",
		out:  "?\tＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\t.",
	}, { // 1041
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\tＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\t．",
		out:  "?\tＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\t．",
	}, { // 1042
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\nＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\n.",
		out:  "?\nＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\n.",
	}, { // 1043
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\nＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\n．",
		out:  "?\nＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\n．",
	}, { // 1044
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\vＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\v.",
		out:  "?\vＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\v.",
	}, { // 1045
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\vＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\v．",
		out:  "?\vＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\v．",
	}, { // 1046
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\rＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\r.",
		out:  "?\rＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\r.",
	}, { // 1047
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "?\rＣ␜\x00＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\r．",
		out:  "?\rＣ␜␀＃'Kθtｂκυ_␡␚\\?ｈe\x06Ｗ２φς＂？<\r．",
	}, { // 1048
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\t\n",
		out:  "．\tｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\t\n",
	}, { // 1049
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\t\n",
		out:  "‛．\tｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\t\n",
	}, { // 1050
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\n\n",
		out:  "．\nｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\n\n",
	}, { // 1051
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\n\n",
		out:  "‛．\nｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\n\n",
	}, { // 1052
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\v\n",
		out:  "．\vｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\v\n",
	}, { // 1053
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\v\n",
		out:  "‛．\vｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\v\n",
	}, { // 1054
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\r\n",
		out:  "．\rｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\r\n",
	}, { // 1055
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\r\n",
		out:  "‛．\rｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\r\n",
	}, { // 1056
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\tｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\t.",
		out:  "ζ\tｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\t.",
	}, { // 1057
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\tｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\t．",
		out:  "ζ\tｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\t．",
	}, { // 1058
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\nｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\n.",
		out:  "ζ\nｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\n.",
	}, { // 1059
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\nｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\n．",
		out:  "ζ\nｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\n．",
	}, { // 1060
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\vｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\v.",
		out:  "ζ\vｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\v.",
	}, { // 1061
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\vｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\v．",
		out:  "ζ\vｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\v．",
	}, { // 1062
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\rｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\r.",
		out:  "ζ\rｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\r.",
	}, { // 1063
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ζ\rｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c|\x15γ\x1eｏ＞δ\r．",
		out:  "ζ\rｋ＃ζkL＋υ␘！ζ＄:＊\x1aaｏＹ\x12c｜\x15γ\x1eｏ＞δ\r．",
	}, { // 1064
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\tγ",
		out:  "．\t\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\tγ",
	}, { // 1065
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\tγ",
		out:  "‛．\t\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\tγ",
	}, { // 1066
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\nγ",
		out:  "．\n\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\nγ",
	}, { // 1067
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\nγ",
		out:  "‛．\n\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\nγ",
	}, { // 1068
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\vγ",
		out:  "．\v\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\vγ",
	}, { // 1069
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\vγ",
		out:  "‛．\v\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\vγ",
	}, { // 1070
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\rγ",
		out:  "．\r\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\rγ",
	}, { // 1071
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\rγ",
		out:  "‛．\r\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\rγ",
	}, { // 1072
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "％\t\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\t.",
		out:  "％\t\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\t.",
	}, { // 1073
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "％\t\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\t．",
		out:  "％\t\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\t．",
	}, { // 1074
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "％\n\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\n.",
		out:  "％\n\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\n.",
	}, { // 1075
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "％\n\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\n．",
		out:  "％\n\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\n．",
	}, { // 1076
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "％\v\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\v.",
		out:  "％\v\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\v.",
	}, { // 1077
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "％\v\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\v．",
		out:  "％\v\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\v．",
	}, { // 1078
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "％\r\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\r.",
		out:  "％\r\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\r.",
	}, { // 1079
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "％\r\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\r．",
		out:  "％\r\b\uff00␍␈FDς\aｕυζｏ｀.␗␆\x12>/kθ␐4ｗ＂ι\r．",
	}, { // 1080
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\tψ",
		out:  "．\t＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\tψ",
	}, { // 1081
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\tψ",
		out:  "‛．\t＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\tψ",
	}, { // 1082
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\nψ",
		out:  "．\n＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\nψ",
	}, { // 1083
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\nψ",
		out:  "‛．\n＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\nψ",
	}, { // 1084
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\vψ",
		out:  "．\v＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\vψ",
	}, { // 1085
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\vψ",
		out:  "‛．\v＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\vψ",
	}, { // 1086
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\rψ",
		out:  "．\r＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\rψ",
	}, { // 1087
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\rψ",
		out:  "‛．\r＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\rψ",
	}, { // 1088
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｓ\t＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\t.",
		out:  "Ｓ\t＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\t.",
	}, { // 1089
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｓ\t＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\t．",
		out:  "Ｓ\t＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\t．",
	}, { // 1090
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｓ\n＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\n.",
		out:  "Ｓ\n＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\n.",
	}, { // 1091
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｓ\n＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\n．",
		out:  "Ｓ\n＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\n．",
	}, { // 1092
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｓ\v＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\v.",
		out:  "Ｓ\v＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\v.",
	}, { // 1093
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｓ\v＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\v．",
		out:  "Ｓ\v＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\v．",
	}, { // 1094
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｓ\r＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\r.",
		out:  "Ｓ\r＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\r.",
	}, { // 1095
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｓ\r＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\r．",
		out:  "Ｓ\r＊␘ζsＺ＾J\x1cηlnｘω\x14\r\x06␒／２ο:␚F␟θ\x1f\r．",
	}, { // 1096
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\t\x06",
		out:  "．\t'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\t\x06",
	}, { // 1097
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\t\x06",
		out:  "‛．\t'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\t\x06",
	}, { // 1098
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\n\x06",
		out:  "．\n'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\n\x06",
	}, { // 1099
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\n\x06",
		out:  "‛．\n'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\n\x06",
	}, { // 1100
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\v\x06",
		out:  "．\v'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\v\x06",
	}, { // 1101
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\v\x06",
		out:  "‛．\v'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\v\x06",
	}, { // 1102
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\r\x06",
		out:  "．\r'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\r\x06",
	}, { // 1103
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\r\x06",
		out:  "‛．\r'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\r\x06",
	}, { // 1104
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "f\t'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\t.",
		out:  "f\t'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\t.",
	}, { // 1105
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "f\t'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\t．",
		out:  "f\t'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\t．",
	}, { // 1106
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "f\n'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\n.",
		out:  "f\n'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\n.",
	}, { // 1107
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "f\n'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\n．",
		out:  "f\n'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\n．",
	}, { // 1108
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "f\v'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\v.",
		out:  "f\v'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\v.",
	}, { // 1109
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "f\v'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\v．",
		out:  "f\v'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\v．",
	}, { // 1110
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "f\r'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\r.",
		out:  "f\r'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\r.",
	}, { // 1111
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "f\r'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\r．",
		out:  "f\r'}\x14ω：％ο␏ｓＣ\f␄#\x18aα＇β３d\x15Ｖ'ι␙␚\r．",
	}, { // 1112
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\t>",
		out:  "．\t4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\t>",
	}, { // 1113
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\t>",
		out:  "‛．\t4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\t>",
	}, { // 1114
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\n>",
		out:  "．\n4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\n>",
	}, { // 1115
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\n>",
		out:  "‛．\n4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\n>",
	}, { // 1116
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\v>",
		out:  "．\v4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\v>",
	}, { // 1117
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\v>",
		out:  "‛．\v4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\v>",
	}, { // 1118
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\r>",
		out:  "．\r4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\r>",
	}, { // 1119
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\r>",
		out:  "‛．\r4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\r>",
	}, { // 1120
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "|\t4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\t.",
		out:  "|\t4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\t.",
	}, { // 1121
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "|\t4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\t．",
		out:  "|\t4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\t．",
	}, { // 1122
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "|\n4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\n.",
		out:  "|\n4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\n.",
	}, { // 1123
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "|\n4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\n．",
		out:  "|\n4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\n．",
	}, { // 1124
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "|\v4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\v.",
		out:  "|\v4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\v.",
	}, { // 1125
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "|\v4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\v．",
		out:  "|\v4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\v．",
	}, { // 1126
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "|\r4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\r.",
		out:  "|\r4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\r.",
	}, { // 1127
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "|\r4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\r．",
		out:  "|\r4␅ＰＲ？W␄\x1c＊ο＼␔ψ<␝：φωnＲ\\οκs`|\r．",
	}, { // 1128
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ｏ\x13\x12ω&６?ＥＲοL\x1aι␕.σtχ␝Ａ␞␍９：3\" x",
		out:  "． ｏ\x13\x12ω&６?ＥＲοL\x1aι␕.σtχ␝Ａ␞␍９：3\" x",
	}, { // 1129
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ｏ\x13\x12ω&６?ＥＲοL\x1aι␕.σtχ␝Ａ␞␍９：3\" x",
		out:  "‛． ｏ\x13\x12ω&６?ＥＲοL\x1aι␕.σtχ␝Ａ␞␍９：3\" x",
	}, { // 1130
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   "η ｏ\x13\x12ω&６?ＥＲοL\x1aι␕.σtχ␝Ａ␞␍９：3\" .",
		out:  "η ｏ\x13\x12ω&６?ＥＲοL\x1aι␕.σtχ␝Ａ␞␍９：3\" .",
	}, { // 1131
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   "η ｏ\x13\x12ω&６?ＥＲοL\x1aι␕.σtχ␝Ａ␞␍９：3\" ．",
		out:  "η ｏ\x13\x12ω&６?ＥＲοL\x1aι␕.σtχ␝Ａ␞␍９：3\" ．",
	}, { // 1132
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". \bＲχ＜␛␝Ｑ]＿␎␂\"ψ>／NＫ\nＡα\"φｏ\x11>ι |",
		out:  "． \bＲχ＜␛␝Ｑ]＿␎␂\"ψ>‛／NＫ\nＡα\"φｏ\x11>ι |",
	}, { // 1133
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． \bＲχ＜␛␝Ｑ]＿␎␂\"ψ>／NＫ\nＡα\"φｏ\x11>ι |",
		out:  "‛． \bＲχ＜␛␝Ｑ]＿␎␂\"ψ>‛／NＫ\nＡα\"φｏ\x11>ι |",
	}, { // 1134
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x0f \bＲχ＜␛␝Ｑ]＿␎␂\"ψ>／NＫ\nＡα\"φｏ\x11>ι .",
		out:  "\x0f \bＲχ＜␛␝Ｑ]＿␎␂\"ψ>‛／NＫ\nＡα\"φｏ\x11>ι .",
	}, { // 1135
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x0f \bＲχ＜␛␝Ｑ]＿␎␂\"ψ>／NＫ\nＡα\"φｏ\x11>ι ．",
		out:  "\x0f \bＲχ＜␛␝Ｑ]＿␎␂\"ψ>‛／NＫ\nＡα\"φｏ\x11>ι ．",
	}, { // 1136
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". π␊ς{\x10␉ｉοθ␆ｎC＋ψ\x1a７␉ｍ\x16\x02␖2\u007f8ι␊ R",
		out:  "． π␊ς{\x10␉ｉοθ␆ｎC＋ψ\x1a７␉ｍ\x16\x02␖2\u007f8ι␊ R",
	}, { // 1137
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． π␊ς{\x10␉ｉοθ␆ｎC＋ψ\x1a７␉ｍ\x16\x02␖2\u007f8ι␊ R",
		out:  "‛． π␊ς{\x10␉ｉοθ␆ｎC＋ψ\x1a７␉ｍ\x16\x02␖2\u007f8ι␊ R",
	}, { // 1138
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "$ π␊ς{\x10␉ｉοθ␆ｎC＋ψ\x1a７␉ｍ\x16\x02␖2\u007f8ι␊ .",
		out:  "$ π␊ς{\x10␉ｉοθ␆ｎC＋ψ\x1a７␉ｍ\x16\x02␖2\u007f8ι␊ .",
	}, { // 1139
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "$ π␊ς{\x10␉ｉοθ␆ｎC＋ψ\x1a７␉ｍ\x16\x02␖2\u007f8ι␊ ．",
		out:  "$ π␊ς{\x10␉ｉοθ␆ｎC＋ψ\x1a７␉ｍ\x16\x02␖2\u007f8ι␊ ．",
	}, { // 1140
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ␐␂Ｖ＃\x14:μA＠＞␞q\x16'ｆι\x04?１\x17\x1fＭβGιq ␡",
		out:  "． ␐␂Ｖ＃\x14:μA＠＞␞q\x16'ｆι\x04?１\x17\x1fＭβGιq ␡",
	}, { // 1141
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ␐␂Ｖ＃\x14:μA＠＞␞q\x16'ｆι\x04?１\x17\x1fＭβGιq ␡",
		out:  "‛． ␐␂Ｖ＃\x14:μA＠＞␞q\x16'ｆι\x04?１\x17\x1fＭβGιq ␡",
	}, { // 1142
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␄ ␐␂Ｖ＃\x14:μA＠＞␞q\x16'ｆι\x04?１\x17\x1fＭβGιq .",
		out:  "␄ ␐␂Ｖ＃\x14:μA＠＞␞q\x16'ｆι\x04?１\x17\x1fＭβGιq .",
	}, { // 1143
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␄ ␐␂Ｖ＃\x14:μA＠＞␞q\x16'ｆι\x04?１\x17\x1fＭβGιq ．",
		out:  "␄ ␐␂Ｖ＃\x14:μA＠＞␞q\x16'ｆι\x04?１\x17\x1fＭβGιq ．",
	}, { // 1144
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". （Ｈ\x04␀θｘ\x10\x1b4＼\x1eＲ：␃Y３Qq％␂_ζ？θ\x01ς \x19",
		out:  "． （Ｈ\x04‛␀θｘ\x10\x1b4＼\x1eＲ：␃Y３Qq％␂_ζ？θ\x01ς \x19",
	}, { // 1145
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． （Ｈ\x04␀θｘ\x10\x1b4＼\x1eＲ：␃Y３Qq％␂_ζ？θ\x01ς \x19",
		out:  "‛． （Ｈ\x04‛␀θｘ\x10\x1b4＼\x1eＲ：␃Y３Qq％␂_ζ？θ\x01ς \x19",
	}, { // 1146
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   "θ （Ｈ\x04␀θｘ\x10\x1b4＼\x1eＲ：␃Y３Qq％␂_ζ？θ\x01ς .",
		out:  "θ （Ｈ\x04‛␀θｘ\x10\x1b4＼\x1eＲ：␃Y３Qq％␂_ζ？θ\x01ς .",
	}, { // 1147
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   "θ （Ｈ\x04␀θｘ\x10\x1b4＼\x1eＲ：␃Y３Qq％␂_ζ？θ\x01ς ．",
		out:  "θ （Ｈ\x04‛␀θｘ\x10\x1b4＼\x1eＲ：␃Y３Qq％␂_ζ？θ\x01ς ．",
	}, { // 1148
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ␑␛␛Ｂ，Ｓξ8\x15λο␏Rr＂dVＡιhＹ\f\x00πＲ\x05 \b",
		out:  "． ␑␛␛Ｂ，Ｓξ8\x15λο␏Rr＂dVＡιhＹ\f␀πＲ\x05 \b",
	}, { // 1149
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ␑␛␛Ｂ，Ｓξ8\x15λο␏Rr＂dVＡιhＹ\f\x00πＲ\x05 \b",
		out:  "‛． ␑␛␛Ｂ，Ｓξ8\x15λο␏Rr＂dVＡιhＹ\f␀πＲ\x05 \b",
	}, { // 1150
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␁ ␑␛␛Ｂ，Ｓξ8\x15λο␏Rr＂dVＡιhＹ\f\x00πＲ\x05 .",
		out:  "␁ ␑␛␛Ｂ，Ｓξ8\x15λο␏Rr＂dVＡιhＹ\f␀πＲ\x05 .",
	}, { // 1151
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␁ ␑␛␛Ｂ，Ｓξ8\x15λο␏Rr＂dVＡιhＹ\f\x00πＲ\x05 ．",
		out:  "␁ ␑␛␛Ｂ，Ｓξ8\x15λο␏Rr＂dVＡιhＹ\f␀πＲ\x05 ．",
	}, { // 1152
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". Ｙ\x05χＷ＝L␂*＃␟,/χ＠\x0e@\rσNθ␇2Pα｜ξ \x15",
		out:  "． Ｙ\x05χＷ＝L␂*＃␟,/χ＠\x0e@\rσNθ␇2Pα｜ξ \x15",
	}, { // 1153
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． Ｙ\x05χＷ＝L␂*＃␟,/χ＠\x0e@\rσNθ␇2Pα｜ξ \x15",
		out:  "‛． Ｙ\x05χＷ＝L␂*＃␟,/χ＠\x0e@\rσNθ␇2Pα｜ξ \x15",
	}, { // 1154
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "｝ Ｙ\x05χＷ＝L␂*＃␟,/χ＠\x0e@\rσNθ␇2Pα｜ξ .",
		out:  "｝ Ｙ\x05χＷ＝L␂*＃␟,/χ＠\x0e@\rσNθ␇2Pα｜ξ .",
	}, { // 1155
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "｝ Ｙ\x05χＷ＝L␂*＃␟,/χ＠\x0e@\rσNθ␇2Pα｜ξ ．",
		out:  "｝ Ｙ\x05χＷ＝L␂*＃␟,/χ＠\x0e@\rσNθ␇2Pα｜ξ ．",
	}, { // 1156
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". \vVｌｊｏ\x15δ␆．kb＼ρπ␋\x180μ＜０δ．\u007f␅αE ＊",
		out:  "． \vVｌｊｏ\x15δ␆．kb＼ρπ␋\x180μ＜０δ．\u007f␅αE ＊",
	}, { // 1157
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． \vVｌｊｏ\x15δ␆．kb＼ρπ␋\x180μ＜０δ．\u007f␅αE ＊",
		out:  "‛． \vVｌｊｏ\x15δ␆．kb＼ρπ␋\x180μ＜０δ．\u007f␅αE ＊",
	}, { // 1158
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightSpace,
		in:   "% \vVｌｊｏ\x15δ␆．kb＼ρπ␋\x180μ＜０δ．\u007f␅αE .",
		out:  "% \vVｌｊｏ\x15δ␆．kb＼ρπ␋\x180μ＜０δ．\u007f␅αE .",
	}, { // 1159
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightSpace,
		in:   "% \vVｌｊｏ\x15δ␆．kb＼ρπ␋\x180μ＜０δ．\u007f␅αE ．",
		out:  "% \vVｌｊｏ\x15δ␆．kb＼ρπ␋\x180μ＜０δ．\u007f␅αE ．",
	}, { // 1160
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". @６Ｚ#\\κχυｎC␡\x17｀βcχ５\x05*Ｇ␄␕ν␙␊␡ D",
		out:  "． @６Ｚ#\\κχυｎC␡\x17｀βcχ５\x05*Ｇ␄␕ν␙␊␡ D",
	}, { // 1161
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． @６Ｚ#\\κχυｎC␡\x17｀βcχ５\x05*Ｇ␄␕ν␙␊␡ D",
		out:  "‛． @６Ｚ#\\κχυｎC␡\x17｀βcχ５\x05*Ｇ␄␕ν␙␊␡ D",
	}, { // 1162
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightSpace,
		in:   ": @６Ｚ#\\κχυｎC␡\x17｀βcχ５\x05*Ｇ␄␕ν␙␊␡ .",
		out:  ": @６Ｚ#\\κχυｎC␡\x17｀βcχ５\x05*Ｇ␄␕ν␙␊␡ .",
	}, { // 1163
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightSpace,
		in:   ": @６Ｚ#\\κχυｎC␡\x17｀βcχ５\x05*Ｇ␄␕ν␙␊␡ ．",
		out:  ": @６Ｚ#\\κχυｎC␡\x17｀βcχ５\x05*Ｇ␄␕ν␙␊␡ ．",
	}, { // 1164
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". Ｗγ\r\x1dｘ｝#Ｆ␇＼␐\x16α␀τφ－Ppq\x15kττ\"I ␆",
		out:  "． Ｗγ\r\x1dｘ｝#Ｆ␇＼␐\x16α‛␀τφ－Ppq\x15kττ\"I ␆",
	}, { // 1165
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． Ｗγ\r\x1dｘ｝#Ｆ␇＼␐\x16α␀τφ－Ppq\x15kττ\"I ␆",
		out:  "‛． Ｗγ\r\x1dｘ｝#Ｆ␇＼␐\x16α‛␀τφ－Ppq\x15kττ\"I ␆",
	}, { // 1166
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x05 Ｗγ\r\x1dｘ｝#Ｆ␇＼␐\x16α␀τφ－Ppq\x15kττ\"I .",
		out:  "\x05 Ｗγ\r\x1dｘ｝#Ｆ␇＼␐\x16α‛␀τφ－Ppq\x15kττ\"I .",
	}, { // 1167
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x05 Ｗγ\r\x1dｘ｝#Ｆ␇＼␐\x16α␀τφ－Ppq\x15kττ\"I ．",
		out:  "\x05 Ｗγ\r\x1dｘ｝#Ｆ␇＼␐\x16α‛␀τφ－Ppq\x15kττ\"I ．",
	}, { // 1168
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". θ＜3␊+\t␊+５Ｃ\x0f?ｓIｘ%φνς＜\x05hｗ\x1aο* υ",
		out:  "． θ＜3␊+\t␊+５Ｃ\x0f?ｓIｘ%φνς＜\x05hｗ\x1aο* υ",
	}, { // 1169
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． θ＜3␊+\t␊+５Ｃ\x0f?ｓIｘ%φνς＜\x05hｗ\x1aο* υ",
		out:  "‛． θ＜3␊+\t␊+５Ｃ\x0f?ｓIｘ%φνς＜\x05hｗ\x1aο* υ",
	}, { // 1170
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightSpace,
		in:   "２ θ＜3␊+\t␊+５Ｃ\x0f?ｓIｘ%φνς＜\x05hｗ\x1aο* .",
		out:  "２ θ＜3␊+\t␊+５Ｃ\x0f?ｓIｘ%φνς＜\x05hｗ\x1aο* .",
	}, { // 1171
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightSpace,
		in:   "２ θ＜3␊+\t␊+５Ｃ\x0f?ｓIｘ%φνς＜\x05hｗ\x1aο* ．",
		out:  "２ θ＜3␊+\t␊+５Ｃ\x0f?ｓIｘ%φνς＜\x05hｗ\x1aο* ．",
	}, { // 1172
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". 3Ｅ␜δ4?)＜\x0fυ｜␝␋\x14δ｀-｛ｉPν\x16>ｆ␁$ λ",
		out:  "． 3Ｅ␜δ4?)＜\x0fυ｜␝␋\x14δ｀-｛ｉPν\x16>ｆ␁$ λ",
	}, { // 1173
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． 3Ｅ␜δ4?)＜\x0fυ｜␝␋\x14δ｀-｛ｉPν\x16>ｆ␁$ λ",
		out:  "‛． 3Ｅ␜δ4?)＜\x0fυ｜␝␋\x14δ｀-｛ｉPν\x16>ｆ␁$ λ",
	}, { // 1174
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␁ 3Ｅ␜δ4?)＜\x0fυ｜␝␋\x14δ｀-｛ｉPν\x16>ｆ␁$ .",
		out:  "␁ 3Ｅ␜δ4?)＜\x0fυ｜␝␋\x14δ｀-｛ｉPν\x16>ｆ␁$ .",
	}, { // 1175
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␁ 3Ｅ␜δ4?)＜\x0fυ｜␝␋\x14δ｀-｛ｉPν\x16>ｆ␁$ ．",
		out:  "␁ 3Ｅ␜δ4?)＜\x0fυ｜␝␋\x14δ｀-｛ｉPν\x16>ｆ␁$ ．",
	}, { // 1176
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ␆？＃i<（#βο＊2ξ＇\x10ζ␜/!␕＊␁L\x12@＿τ \x04",
		out:  "． ␆？＃i<（#βο＊2ξ＇\x10ζ␜/!␕＊␁L\x12@＿τ \x04",
	}, { // 1177
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ␆？＃i<（#βο＊2ξ＇\x10ζ␜/!␕＊␁L\x12@＿τ \x04",
		out:  "‛． ␆？＃i<（#βο＊2ξ＇\x10ζ␜/!␕＊␁L\x12@＿τ \x04",
	}, { // 1178
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ｘ ␆？＃i<（#βο＊2ξ＇\x10ζ␜/!␕＊␁L\x12@＿τ .",
		out:  "ｘ ␆？＃i<（#βο＊2ξ＇\x10ζ␜/!␕＊␁L\x12@＿τ .",
	}, { // 1179
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ｘ ␆？＃i<（#βο＊2ξ＇\x10ζ␜/!␕＊␁L\x12@＿τ ．",
		out:  "ｘ ␆？＃i<（#βο＊2ξ＇\x10ζ␜/!␕＊␁L\x12@＿τ ．",
	}, { // 1180
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ?Wｘｚ|=πι\x0fｆ\"4␊Ｊ＝ψ\x1d＞\u007f␉\"Q／οfε ␏",
		out:  "． ?Wｘｚ|=πι\x0fｆ\"4␊Ｊ＝ψ\x1d＞\u007f␉\"Q／οfε ␏",
	}, { // 1181
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ?Wｘｚ|=πι\x0fｆ\"4␊Ｊ＝ψ\x1d＞\u007f␉\"Q／οfε ␏",
		out:  "‛． ?Wｘｚ|=πι\x0fｆ\"4␊Ｊ＝ψ\x1d＞\u007f␉\"Q／οfε ␏",
	}, { // 1182
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ζ ?Wｘｚ|=πι\x0fｆ\"4␊Ｊ＝ψ\x1d＞\u007f␉\"Q／οfε .",
		out:  "ζ ?Wｘｚ|=πι\x0fｆ\"4␊Ｊ＝ψ\x1d＞\u007f␉\"Q／οfε .",
	}, { // 1183
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ζ ?Wｘｚ|=πι\x0fｆ\"4␊Ｊ＝ψ\x1d＞\u007f␉\"Q／οfε ．",
		out:  "ζ ?Wｘｚ|=πι\x0fｆ\"4␊Ｊ＝ψ\x1d＞\u007f␉\"Q／οfε ．",
	}, { // 1184
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". θ＆Ｓ<*εvJ\x01␇␜０>^ｌπ\n＞␜０％\aπξ:p Ｉ",
		out:  "． θ＆Ｓ<*εvJ\x01␇␜０>^ｌπ␊＞␜０％\aπξ:p Ｉ",
	}, { // 1185
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． θ＆Ｓ<*εvJ\x01␇␜０>^ｌπ\n＞␜０％\aπξ:p Ｉ",
		out:  "‛． θ＆Ｓ<*εvJ\x01␇␜０>^ｌπ␊＞␜０％\aπξ:p Ｉ",
	}, { // 1186
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␍ θ＆Ｓ<*εvJ\x01␇␜０>^ｌπ\n＞␜０％\aπξ:p .",
		out:  "‛␍ θ＆Ｓ<*εvJ\x01␇␜０>^ｌπ␊＞␜０％\aπξ:p .",
	}, { // 1187
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␍ θ＆Ｓ<*εvJ\x01␇␜０>^ｌπ\n＞␜０％\aπξ:p ．",
		out:  "‛␍ θ＆Ｓ<*εvJ\x01␇␜０>^ｌπ␊＞␜０％\aπξ:p ．",
	}, { // 1188
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". \x15\x12w␒^：＋６τ\x0f|＊␛τ␁\t␁V\x0e%＼ｃｂhεn ι",
		out:  "． \x15\x12w␒^：＋６τ\x0f|＊␛τ␁\t␁V\x0e%＼ｃｂhεn ι",
	}, { // 1189
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． \x15\x12w␒^：＋６τ\x0f|＊␛τ␁\t␁V\x0e%＼ｃｂhεn ι",
		out:  "‛． \x15\x12w␒^：＋６τ\x0f|＊␛τ␁\t␁V\x0e%＼ｃｂhεn ι",
	}, { // 1190
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightSpace,
		in:   "Ｑ \x15\x12w␒^：＋６τ\x0f|＊␛τ␁\t␁V\x0e%＼ｃｂhεn .",
		out:  "Ｑ \x15\x12w␒^：＋６τ\x0f|＊␛τ␁\t␁V\x0e%＼ｃｂhεn .",
	}, { // 1191
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightSpace,
		in:   "Ｑ \x15\x12w␒^：＋６τ\x0f|＊␛τ␁\t␁V\x0e%＼ｃｂhεn ．",
		out:  "Ｑ \x15\x12w␒^：＋６τ\x0f|＊␛τ␁\t␁V\x0e%＼ｃｂhεn ．",
	}, { // 1192
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ␐\t｜γｙ␁ξ\x19-＜ｗ:δχ␛Ｒυ?␊γ6\"\"\x14｜@ ]",
		out:  "． ‛␐␉｜γｙ‛␁ξ␙-＜ｗ:δχ‛␛Ｒυ?‛␊γ6\"\"␔｜@ ]",
	}, { // 1193
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ␐\t｜γｙ␁ξ\x19-＜ｗ:δχ␛Ｒυ?␊γ6\"\"\x14｜@ ]",
		out:  "‛． ‛␐␉｜γｙ‛␁ξ␙-＜ｗ:δχ‛␛Ｒυ?‛␊γ6\"\"␔｜@ ]",
	}, { // 1194
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightSpace,
		in:   "５ ␐\t｜γｙ␁ξ\x19-＜ｗ:δχ␛Ｒυ?␊γ6\"\"\x14｜@ .",
		out:  "５ ‛␐␉｜γｙ‛␁ξ␙-＜ｗ:δχ‛␛Ｒυ?‛␊γ6\"\"␔｜@ .",
	}, { // 1195
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightSpace,
		in:   "５ ␐\t｜γｙ␁ξ\x19-＜ｗ:δχ␛Ｒυ?␊γ6\"\"\x14｜@ ．",
		out:  "５ ‛␐␉｜γｙ‛␁ξ␙-＜ｗ:δχ‛␛Ｒυ?‛␊γ6\"\"␔｜@ ．",
	}, { // 1196
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..β／#\x1c␘1␐９Ｂ9９γ␀σς#/ι␀\b\a／␌εＴ\x1a.h",
		out:  "．.β／#\x1c␘1␐９Ｂ9９γ‛␀σς#/ι‛␀\b\a／␌εＴ\x1a.h",
	}, { // 1197
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.β／#\x1c␘1␐９Ｂ9９γ␀σς#/ι␀\b\a／␌εＴ\x1a.h",
		out:  "‛．.β／#\x1c␘1␐９Ｂ9９γ‛␀σς#/ι‛␀\b\a／␌εＴ\x1a.h",
	}, { // 1198
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "q.β／#\x1c␘1␐９Ｂ9９γ␀σς#/ι␀\b\a／␌εＴ\x1a..",
		out:  "q.β／#\x1c␘1␐９Ｂ9９γ‛␀σς#/ι‛␀\b\a／␌εＴ\x1a.．",
	}, { // 1199
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "q.β／#\x1c␘1␐９Ｂ9９γ␀σς#/ι␀\b\a／␌εＴ\x1a.．",
		out:  "q.β／#\x1c␘1␐９Ｂ9９γ‛␀σς#/ι‛␀\b\a／␌εＴ\x1a.‛．",
	}, { // 1200
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..o｀\x17␕\"ψν\r;<＂Ｋ？ι％Ｅ＠\x03\u007f␍␕K$％Vλ.K",
		out:  "．.o｀\x17␕\"ψν\r;<＂Ｋ？ι％Ｅ＠\x03\u007f␍␕K$％Vλ.K",
	}, { // 1201
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.o｀\x17␕\"ψν\r;<＂Ｋ？ι％Ｅ＠\x03\u007f␍␕K$％Vλ.K",
		out:  "‛．.o｀\x17␕\"ψν\r;<＂Ｋ？ι％Ｅ＠\x03\u007f␍␕K$％Vλ.K",
	}, { // 1202
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "μ.o｀\x17␕\"ψν\r;<＂Ｋ？ι％Ｅ＠\x03\u007f␍␕K$％Vλ..",
		out:  "μ.o｀\x17␕\"ψν\r;<＂Ｋ？ι％Ｅ＠\x03\u007f␍␕K$％Vλ.．",
	}, { // 1203
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "μ.o｀\x17␕\"ψν\r;<＂Ｋ？ι％Ｅ＠\x03\u007f␍␕K$％Vλ.．",
		out:  "μ.o｀\x17␕\"ψν\r;<＂Ｋ？ι％Ｅ＠\x03\u007f␍␕K$％Vλ.‛．",
	}, { // 1204
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..υz4\x16？␕:␑>Kς>＄\\b２\x1d<␇６＇␞πς␝+.γ",
		out:  "．.υz4\x16？␕:␑>Kς>＄\\b２\x1d<␇６‛＇␞πς␝+.γ",
	}, { // 1205
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.υz4\x16？␕:␑>Kς>＄\\b２\x1d<␇６＇␞πς␝+.γ",
		out:  "‛．.υz4\x16？␕:␑>Kς>＄\\b２\x1d<␇６‛＇␞πς␝+.γ",
	}, { // 1206
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "Ｐ.υz4\x16？␕:␑>Kς>＄\\b２\x1d<␇６＇␞πς␝+..",
		out:  "Ｐ.υz4\x16？␕:␑>Kς>＄\\b２\x1d<␇６‛＇␞πς␝+.．",
	}, { // 1207
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "Ｐ.υz4\x16？␕:␑>Kς>＄\\b２\x1d<␇６＇␞πς␝+.．",
		out:  "Ｐ.υz4\x16？␕:␑>Kς>＄\\b２\x1d<␇６‛＇␞πς␝+.‛．",
	}, { // 1208
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..］&␊\x1c␈ξ\f\"｛:␑＄ａ\n:Ｗξφθι::iτ␄␓.3",
		out:  "．.］&␊\x1c␈ξ\f\"｛:␑＄ａ\n:Ｗξφθι::iτ␄␓.3",
	}, { // 1209
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.］&␊\x1c␈ξ\f\"｛:␑＄ａ\n:Ｗξφθι::iτ␄␓.3",
		out:  "‛．.］&␊\x1c␈ξ\f\"｛:␑＄ａ\n:Ｗξφθι::iτ␄␓.3",
	}, { // 1210
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "\x13.］&␊\x1c␈ξ\f\"｛:␑＄ａ\n:Ｗξφθι::iτ␄␓..",
		out:  "\x13.］&␊\x1c␈ξ\f\"｛:␑＄ａ\n:Ｗξφθι::iτ␄␓.．",
	}, { // 1211
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "\x13.］&␊\x1c␈ξ\f\"｛:␑＄ａ\n:Ｗξφθι::iτ␄␓.．",
		out:  "\x13.］&␊\x1c␈ξ\f\"｛:␑＄ａ\n:Ｗξφθι::iτ␄␓.‛．",
	}, { // 1212
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..｜|\x03␘γLX！π\x0e␗πｋ:＜［/＜／oCυζｂ␈*.L",
		out:  "．.｜|\x03␘γLX！π\x0e␗πｋ:‛＜［/‛＜／oCυζｂ␈*.L",
	}, { // 1213
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.｜|\x03␘γLX！π\x0e␗πｋ:＜［/＜／oCυζｂ␈*.L",
		out:  "‛．.｜|\x03␘γLX！π\x0e␗πｋ:‛＜［/‛＜／oCυζｂ␈*.L",
	}, { // 1214
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "］.｜|\x03␘γLX！π\x0e␗πｋ:＜［/＜／oCυζｂ␈*..",
		out:  "］.｜|\x03␘γLX！π\x0e␗πｋ:‛＜［/‛＜／oCυζｂ␈*.．",
	}, { // 1215
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "］.｜|\x03␘γLX！π\x0e␗πｋ:＜［/＜／oCυζｂ␈*.．",
		out:  "］.｜|\x03␘γLX！π\x0e␗πｋ:‛＜［/‛＜／oCυζｂ␈*.‛．",
	}, { // 1216
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..＠\x10B␎（＂δζV/ι␈o␊z\\\x1e；\\\x04ηＴ:φａn.␂",
		out:  "．.＠\x10B␎（＂δζV/ι␈o␊z\\\x1e；\\\x04ηＴ:φａn.␂",
	}, { // 1217
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.＠\x10B␎（＂δζV/ι␈o␊z\\\x1e；\\\x04ηＴ:φａn.␂",
		out:  "‛．.＠\x10B␎（＂δζV/ι␈o␊z\\\x1e；\\\x04ηＴ:φａn.␂",
	}, { // 1218
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␔.＠\x10B␎（＂δζV/ι␈o␊z\\\x1e；\\\x04ηＴ:φａn..",
		out:  "␔.＠\x10B␎（＂δζV/ι␈o␊z\\\x1e；\\\x04ηＴ:φａn.．",
	}, { // 1219
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␔.＠\x10B␎（＂δζV/ι␈o␊z\\\x1e；\\\x04ηＴ:φａn.．",
		out:  "␔.＠\x10B␎（＂δζV/ι␈o␊z\\\x1e；\\\x04ηＴ:φａn.‛．",
	}, { // 1220
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..\a｝ρ␏␚０␏ｓυu\bＮ␄μf\r\x1d*ηdＢ\x1cBγ␞ω.␍",
		out:  "．.\a｝ρ␏␚０␏ｓυu\bＮ␄μf\r\x1d*ηdＢ\x1cBγ␞ω.␍",
	}, { // 1221
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.\a｝ρ␏␚０␏ｓυu\bＮ␄μf\r\x1d*ηdＢ\x1cBγ␞ω.␍",
		out:  "‛．.\a｝ρ␏␚０␏ｓυu\bＮ␄μf\r\x1d*ηdＢ\x1cBγ␞ω.␍",
	}, { // 1222
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "_.\a｝ρ␏␚０␏ｓυu\bＮ␄μf\r\x1d*ηdＢ\x1cBγ␞ω..",
		out:  "_.\a｝ρ␏␚０␏ｓυu\bＮ␄μf\r\x1d*ηdＢ\x1cBγ␞ω.．",
	}, { // 1223
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "_.\a｝ρ␏␚０␏ｓυu\bＮ␄μf\r\x1d*ηdＢ\x1cBγ␞ω.．",
		out:  "_.\a｝ρ␏␚０␏ｓυu\bＮ␄μf\r\x1d*ηdＢ\x1cBγ␞ω.‛．",
	}, { // 1224
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..␔ｖＺCξ?ｓ\r\x10αｘｐ\x14v\bg＞φ␍@δ\x1b␋Ｂ\f＄.γ",
		out:  "．.␔ｖＺCξ?ｓ\r\x10αｘｐ\x14v\bg＞φ␍@δ\x1b␋Ｂ\f＄.γ",
	}, { // 1225
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.␔ｖＺCξ?ｓ\r\x10αｘｐ\x14v\bg＞φ␍@δ\x1b␋Ｂ\f＄.γ",
		out:  "‛．.␔ｖＺCξ?ｓ\r\x10αｘｐ\x14v\bg＞φ␍@δ\x1b␋Ｂ\f＄.γ",
	}, { // 1226
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ζ.␔ｖＺCξ?ｓ\r\x10αｘｐ\x14v\bg＞φ␍@δ\x1b␋Ｂ\f＄..",
		out:  "ζ.␔ｖＺCξ?ｓ\r\x10αｘｐ\x14v\bg＞φ␍@δ\x1b␋Ｂ\f＄.．",
	}, { // 1227
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ζ.␔ｖＺCξ?ｓ\r\x10αｘｐ\x14v\bg＞φ␍@δ\x1b␋Ｂ\f＄.．",
		out:  "ζ.␔ｖＺCξ?ｓ\r\x10αｘｐ\x14v\bg＞φ␍@δ\x1b␋Ｂ\f＄.‛．",
	}, { // 1228
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..␔μｓr\x16␛JWαＣF＇\x06４\x10χ＊4\x14\x134␋\x1a␐ζＬ.ｅ",
		out:  "．.␔μｓr\x16␛JWαＣF＇\x06４\x10χ＊4\x14\x134␋\x1a␐ζＬ.ｅ",
	}, { // 1229
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.␔μｓr\x16␛JWαＣF＇\x06４\x10χ＊4\x14\x134␋\x1a␐ζＬ.ｅ",
		out:  "‛．.␔μｓr\x16␛JWαＣF＇\x06４\x10χ＊4\x14\x134␋\x1a␐ζＬ.ｅ",
	}, { // 1230
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "｜.␔μｓr\x16␛JWαＣF＇\x06４\x10χ＊4\x14\x134␋\x1a␐ζＬ..",
		out:  "｜.␔μｓr\x16␛JWαＣF＇\x06４\x10χ＊4\x14\x134␋\x1a␐ζＬ.．",
	}, { // 1231
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "｜.␔μｓr\x16␛JWαＣF＇\x06４\x10χ＊4\x14\x134␋\x1a␐ζＬ.．",
		out:  "｜.␔μｓr\x16␛JWαＣF＇\x06４\x10χ＊4\x14\x134␋\x1a␐ζＬ.‛．",
	}, { // 1232
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..σ␗μαBι(␋E␓\v\"４9ｈＴ！Ａ␌οＥ&␀\x13␊\x19.\x04",
		out:  "．.σ␗μαBι(␋E␓\v\"４9ｈＴ！Ａ␌οＥ&‛␀\x13␊\x19.\x04",
	}, { // 1233
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.σ␗μαBι(␋E␓\v\"４9ｈＴ！Ａ␌οＥ&␀\x13␊\x19.\x04",
		out:  "‛．.σ␗μαBι(␋E␓\v\"４9ｈＴ！Ａ␌οＥ&‛␀\x13␊\x19.\x04",
	}, { // 1234
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "δ.σ␗μαBι(␋E␓\v\"４9ｈＴ！Ａ␌οＥ&␀\x13␊\x19..",
		out:  "δ.σ␗μαBι(␋E␓\v\"４9ｈＴ！Ａ␌οＥ&‛␀\x13␊\x19.．",
	}, { // 1235
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "δ.σ␗μαBι(␋E␓\v\"４9ｈＴ！Ａ␌οＥ&␀\x13␊\x19.．",
		out:  "δ.σ␗μαBι(␋E␓\v\"４9ｈＴ！Ａ␌οＥ&‛␀\x13␊\x19.‛．",
	}, { // 1236
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..γ／α␒#Ｇ\x1a\\'V*␃νH｜\x02Ｏ]␖ｒαεH＃\x00Ｃ.ｚ",
		out:  "．.γ／α␒#Ｇ\x1a\\'V*␃νH‛｜\x02Ｏ]␖ｒαεH＃␀Ｃ.ｚ",
	}, { // 1237
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.γ／α␒#Ｇ\x1a\\'V*␃νH｜\x02Ｏ]␖ｒαεH＃\x00Ｃ.ｚ",
		out:  "‛．.γ／α␒#Ｇ\x1a\\'V*␃νH‛｜\x02Ｏ]␖ｒαεH＃␀Ｃ.ｚ",
	}, { // 1238
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "０.γ／α␒#Ｇ\x1a\\'V*␃νH｜\x02Ｏ]␖ｒαεH＃\x00Ｃ..",
		out:  "０.γ／α␒#Ｇ\x1a\\'V*␃νH‛｜\x02Ｏ]␖ｒαεH＃␀Ｃ.．",
	}, { // 1239
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "０.γ／α␒#Ｇ\x1a\\'V*␃νH｜\x02Ｏ]␖ｒαεH＃\x00Ｃ.．",
		out:  "０.γ／α␒#Ｇ\x1a\\'V*␃νH‛｜\x02Ｏ]␖ｒαεH＃␀Ｃ.‛．",
	}, { // 1240
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..x\x19１*ＭHα$L\x1aη␄π␁\x13␌Ｖ\"{Ｖ\x17％κ２θπ.ｏ",
		out:  "．.x\x19１*ＭHα$L\x1aη␄π␁\x13␌Ｖ\"{Ｖ\x17％κ２θπ.ｏ",
	}, { // 1241
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.x\x19１*ＭHα$L\x1aη␄π␁\x13␌Ｖ\"{Ｖ\x17％κ２θπ.ｏ",
		out:  "‛．.x\x19１*ＭHα$L\x1aη␄π␁\x13␌Ｖ\"{Ｖ\x17％κ２θπ.ｏ",
	}, { // 1242
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "：.x\x19１*ＭHα$L\x1aη␄π␁\x13␌Ｖ\"{Ｖ\x17％κ２θπ..",
		out:  "：.x\x19１*ＭHα$L\x1aη␄π␁\x13␌Ｖ\"{Ｖ\x17％κ２θπ.．",
	}, { // 1243
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "：.x\x19１*ＭHα$L\x1aη␄π␁\x13␌Ｖ\"{Ｖ\x17％κ２θπ.．",
		out:  "：.x\x19１*ＭHα$L\x1aη␄π␁\x13␌Ｖ\"{Ｖ\x17％κ２θπ.‛．",
	}, { // 1244
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..\x1e|`\n␑ｇ␀κχ＞␑␛[εｖ6MB\x19Yθ／␀－\x01\v.θ",
		out:  "．.\x1e|`\n␑ｇ‛␀κχ＞␑␛[εｖ6MB\x19Yθ／‛␀－\x01\v.θ",
	}, { // 1245
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.\x1e|`\n␑ｇ␀κχ＞␑␛[εｖ6MB\x19Yθ／␀－\x01\v.θ",
		out:  "‛．.\x1e|`\n␑ｇ‛␀κχ＞␑␛[εｖ6MB\x19Yθ／‛␀－\x01\v.θ",
	}, { // 1246
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "Ｘ.\x1e|`\n␑ｇ␀κχ＞␑␛[εｖ6MB\x19Yθ／␀－\x01\v..",
		out:  "Ｘ.\x1e|`\n␑ｇ‛␀κχ＞␑␛[εｖ6MB\x19Yθ／‛␀－\x01\v.．",
	}, { // 1247
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "Ｘ.\x1e|`\n␑ｇ␀κχ＞␑␛[εｖ6MB\x19Yθ／␀－\x01\v.．",
		out:  "Ｘ.\x1e|`\n␑ｇ‛␀κχ＞␑␛[εｖ6MB\x19Yθ／‛␀－\x01\v.‛．",
	}, { // 1248
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..πrａ％6V\x1e␋\x13␊␍ｌ␔ς４$\x1a？ψxιF\x04＾＠？.ζ",
		out:  "．.πrａ％6V\x1e␋\x13␊␍ｌ␔ς４$\x1a？ψxιF\x04＾＠？.ζ",
	}, { // 1249
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.πrａ％6V\x1e␋\x13␊␍ｌ␔ς４$\x1a？ψxιF\x04＾＠？.ζ",
		out:  "‛．.πrａ％6V\x1e␋\x13␊␍ｌ␔ς４$\x1a？ψxιF\x04＾＠？.ζ",
	}, { // 1250
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ε.πrａ％6V\x1e␋\x13␊␍ｌ␔ς４$\x1a？ψxιF\x04＾＠？..",
		out:  "ε.πrａ％6V\x1e␋\x13␊␍ｌ␔ς４$\x1a？ψxιF\x04＾＠？.．",
	}, { // 1251
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ε.πrａ％6V\x1e␋\x13␊␍ｌ␔ς４$\x1a？ψxιF\x04＾＠？.．",
		out:  "ε.πrａ％6V\x1e␋\x13␊␍ｌ␔ς４$\x1a？ψxιF\x04＾＠？.‛．",
	}, { // 1252
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..yςＷ．εφＵ\x17＇xＷ＄\bχ>\x15\"ｔ/\n?R␑β＄V.η",
		out:  "．.yςＷ．εφＵ\x17＇xＷ＄\bχ>\x15\"ｔ/␊?R␑β＄V.η",
	}, { // 1253
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.yςＷ．εφＵ\x17＇xＷ＄\bχ>\x15\"ｔ/\n?R␑β＄V.η",
		out:  "‛．.yςＷ．εφＵ\x17＇xＷ＄\bχ>\x15\"ｔ/␊?R␑β＄V.η",
	}, { // 1254
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␝.yςＷ．εφＵ\x17＇xＷ＄\bχ>\x15\"ｔ/\n?R␑β＄V..",
		out:  "␝.yςＷ．εφＵ\x17＇xＷ＄\bχ>\x15\"ｔ/␊?R␑β＄V.．",
	}, { // 1255
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␝.yςＷ．εφＵ\x17＇xＷ＄\bχ>\x15\"ｔ/\n?R␑β＄V.．",
		out:  "␝.yςＷ．εφＵ\x17＇xＷ＄\bχ>\x15\"ｔ/␊?R␑β＄V.‛．",
	}, { // 1256
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..␀α｜␌1Ｐ\x0e？ｋ␃␝\x17ξτ\x10ν@:d\x04ｎ＋ψ\n'＾.&",
		out:  "．.‛␀α｜␌1Ｐ\x0e？ｋ␃␝\x17ξτ\x10ν@:d\x04ｎ＋ψ\n'＾.&",
	}, { // 1257
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.␀α｜␌1Ｐ\x0e？ｋ␃␝\x17ξτ\x10ν@:d\x04ｎ＋ψ\n'＾.&",
		out:  "‛．.‛␀α｜␌1Ｐ\x0e？ｋ␃␝\x17ξτ\x10ν@:d\x04ｎ＋ψ\n'＾.&",
	}, { // 1258
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␛.␀α｜␌1Ｐ\x0e？ｋ␃␝\x17ξτ\x10ν@:d\x04ｎ＋ψ\n'＾..",
		out:  "␛.‛␀α｜␌1Ｐ\x0e？ｋ␃␝\x17ξτ\x10ν@:d\x04ｎ＋ψ\n'＾.．",
	}, { // 1259
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␛.␀α｜␌1Ｐ\x0e？ｋ␃␝\x17ξτ\x10ν@:d\x04ｎ＋ψ\n'＾.．",
		out:  "␛.‛␀α｜␌1Ｐ\x0e？ｋ␃␝\x17ξτ\x10ν@:d\x04ｎ＋ψ\n'＾.‛．",
	}, { // 1260
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..ξ␊\nｂk＜ｕ\x12=␈）Q＃\x05l％\"％#}␇η\x05␎τδ.θ",
		out:  "．.ξ‛␊␊ｂk＜ｕ␒=‛␈）Q＃␅l％\"％#}‛␇η␅‛␎τδ.θ",
	}, { // 1261
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.ξ␊\nｂk＜ｕ\x12=␈）Q＃\x05l％\"％#}␇η\x05␎τδ.θ",
		out:  "‛．.ξ‛␊␊ｂk＜ｕ␒=‛␈）Q＃␅l％\"％#}‛␇η␅‛␎τδ.θ",
	}, { // 1262
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ｐ.ξ␊\nｂk＜ｕ\x12=␈）Q＃\x05l％\"％#}␇η\x05␎τδ..",
		out:  "ｐ.ξ‛␊␊ｂk＜ｕ␒=‛␈）Q＃␅l％\"％#}‛␇η␅‛␎τδ.．",
	}, { // 1263
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ｐ.ξ␊\nｂk＜ｕ\x12=␈）Q＃\x05l％\"％#}␇η\x05␎τδ.．",
		out:  "ｐ.ξ‛␊␊ｂk＜ｕ␒=‛␈）Q＃␅l％\"％#}‛␇η␅‛␎τδ.‛．",
	}, { // 1264
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\tS",
		out:  "．\t\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\tS",
	}, { // 1265
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\tS",
		out:  "‛．\t\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\tS",
	}, { // 1266
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\nS",
		out:  "．\n\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\nS",
	}, { // 1267
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\nS",
		out:  "‛．\n\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\nS",
	}, { // 1268
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\vS",
		out:  "．\v\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\vS",
	}, { // 1269
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\vS",
		out:  "‛．\v\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\vS",
	}, { // 1270
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\rS",
		out:  "．\r\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\rS",
	}, { // 1271
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\rS",
		out:  "‛．\r\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\rS",
	}, { // 1272
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "R\t\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\t.",
		out:  "R\t\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\t.",
	}, { // 1273
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "R\t\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\t．",
		out:  "R\t\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\t．",
	}, { // 1274
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "R\n\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\n.",
		out:  "R\n\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\n.",
	}, { // 1275
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "R\n\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\n．",
		out:  "R\n\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\n．",
	}, { // 1276
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "R\v\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\v.",
		out:  "R\v\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\v.",
	}, { // 1277
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "R\v\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\v．",
		out:  "R\v\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\v．",
	}, { // 1278
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "R\r\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\r.",
		out:  "R\r\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\r.",
	}, { // 1279
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "R\r\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\r．",
		out:  "R\r\rｍ␟ｕ４\x1dν\x15ο６3υi␑\x03␇!\x11＞ξχδ7＇ｇ＠\r．",
	}, { // 1280
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\tυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\t~",
		out:  "．\tυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\t~",
	}, { // 1281
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\tυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\t~",
		out:  "‛．\tυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\t~",
	}, { // 1282
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\n~",
		out:  "．\nυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\n~",
	}, { // 1283
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\n~",
		out:  "‛．\nυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\n~",
	}, { // 1284
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\v~",
		out:  "．\vυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\v~",
	}, { // 1285
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\v~",
		out:  "‛．\vυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\v~",
	}, { // 1286
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\r~",
		out:  "．\rυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\r~",
	}, { // 1287
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\r~",
		out:  "‛．\rυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\r~",
	}, { // 1288
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ａ\tυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\t.",
		out:  "Ａ\tυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\t.",
	}, { // 1289
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ａ\tυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\t．",
		out:  "Ａ\tυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\t．",
	}, { // 1290
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ａ\nυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\n.",
		out:  "Ａ\nυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\n.",
	}, { // 1291
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ａ\nυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\n．",
		out:  "Ａ\nυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\n．",
	}, { // 1292
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ａ\vυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\v.",
		out:  "Ａ\vυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\v.",
	}, { // 1293
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ａ\vυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\v．",
		out:  "Ａ\vυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\v．",
	}, { // 1294
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ａ\rυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\r.",
		out:  "Ａ\rυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\r.",
	}, { // 1295
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ａ\rυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\r．",
		out:  "Ａ\rυς！αχ|｜＊＃Z#\x1c\x04Ｉ＂Ｗζ\r\x11E]＂O\x19ｄι\r．",
	}, { // 1296
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\tV",
		out:  "．\t；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\tV",
	}, { // 1297
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\tV",
		out:  "‛．\t；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\tV",
	}, { // 1298
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\nV",
		out:  "．\n；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\nV",
	}, { // 1299
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\nV",
		out:  "‛．\n；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\nV",
	}, { // 1300
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\vV",
		out:  "．\v；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\vV",
	}, { // 1301
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\vV",
		out:  "‛．\v；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\vV",
	}, { // 1302
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\rV",
		out:  "．\r；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\rV",
	}, { // 1303
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\rV",
		out:  "‛．\r；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\rV",
	}, { // 1304
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "E\t；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\t.",
		out:  "E\t；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\t.",
	}, { // 1305
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "E\t；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\t．",
		out:  "E\t；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\t．",
	}, { // 1306
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "E\n；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\n.",
		out:  "E\n；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\n.",
	}, { // 1307
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "E\n；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\n．",
		out:  "E\n；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\n．",
	}, { // 1308
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "E\v；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\v.",
		out:  "E\v；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\v.",
	}, { // 1309
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "E\v；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\v．",
		out:  "E\v；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\v．",
	}, { // 1310
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "E\r；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\r.",
		out:  "E\r；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\r.",
	}, { // 1311
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "E\r；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\r．",
		out:  "E\r；ς；<υ;＂\r␊␓\x05νyμ␈\uff00␄uι\x0f\x1dＣｒσ％R\r．",
	}, { // 1312
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\tYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\tｗ",
		out:  "．\tYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\tｗ",
	}, { // 1313
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\tYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\tｗ",
		out:  "‛．\tYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\tｗ",
	}, { // 1314
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\nｗ",
		out:  "．\nYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\nｗ",
	}, { // 1315
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\nｗ",
		out:  "‛．\nYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\nｗ",
	}, { // 1316
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\vｗ",
		out:  "．\vYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\vｗ",
	}, { // 1317
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\vｗ",
		out:  "‛．\vYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\vｗ",
	}, { // 1318
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\rｗ",
		out:  "．\rYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\rｗ",
	}, { // 1319
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\rｗ",
		out:  "‛．\rYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\rｗ",
	}, { // 1320
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "／\tYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\t.",
		out:  "／\tYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\t.",
	}, { // 1321
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "／\tYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\t．",
		out:  "／\tYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\t．",
	}, { // 1322
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "／\nYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\n.",
		out:  "／\nYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\n.",
	}, { // 1323
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "／\nYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\n．",
		out:  "／\nYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\n．",
	}, { // 1324
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "／\vYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\v.",
		out:  "／\vYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\v.",
	}, { // 1325
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "／\vYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\v．",
		out:  "／\vYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\v．",
	}, { // 1326
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "／\rYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\r.",
		out:  "／\rYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\r.",
	}, { // 1327
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "／\rYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\r．",
		out:  "／\rYοβ＇\\%？＼\x16)\"␍␝β␍\x17\x13η|π␚;β５\x12\x01\r．",
	}, { // 1328
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\tv",
		out:  "．\t*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\tv",
	}, { // 1329
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\tv",
		out:  "‛．\t*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\tv",
	}, { // 1330
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\nv",
		out:  "．\n*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\nv",
	}, { // 1331
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\nv",
		out:  "‛．\n*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\nv",
	}, { // 1332
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\vv",
		out:  "．\v*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\vv",
	}, { // 1333
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\vv",
		out:  "‛．\v*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\vv",
	}, { // 1334
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\rv",
		out:  "．\r*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\rv",
	}, { // 1335
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\rv",
		out:  "‛．\r*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\rv",
	}, { // 1336
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\t*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\t.",
		out:  "γ\t*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\t.",
	}, { // 1337
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\t*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\t．",
		out:  "γ\t*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\t．",
	}, { // 1338
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\n*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\n.",
		out:  "γ\n*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\n.",
	}, { // 1339
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\n*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\n．",
		out:  "γ\n*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\n．",
	}, { // 1340
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\v*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\v.",
		out:  "γ\v*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\v.",
	}, { // 1341
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\v*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\v．",
		out:  "γ\v*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\v．",
	}, { // 1342
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\r*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\r.",
		out:  "γ\r*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\r.",
	}, { // 1343
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "γ\r*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\r．",
		out:  "γ\r*\x1f\aｊ␒\u007f｀␈Ｘ␃ο`@？ＷＣqζξＧR}␊␖:ξ\r．",
	}, { // 1344
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\tz",
		out:  "．\t@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\tz",
	}, { // 1345
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\tz",
		out:  "‛．\t@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\tz",
	}, { // 1346
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\nz",
		out:  "．\n@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\nz",
	}, { // 1347
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\nz",
		out:  "‛．\n@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\nz",
	}, { // 1348
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\vz",
		out:  "．\v@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\vz",
	}, { // 1349
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\vz",
		out:  "‛．\v@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\vz",
	}, { // 1350
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\rz",
		out:  "．\r@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\rz",
	}, { // 1351
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\rz",
		out:  "‛．\r@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\rz",
	}, { // 1352
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ρ\t@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\t.",
		out:  "ρ\t@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\t.",
	}, { // 1353
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ρ\t@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\t．",
		out:  "ρ\t@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\t．",
	}, { // 1354
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ρ\n@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\n.",
		out:  "ρ\n@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\n.",
	}, { // 1355
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ρ\n@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\n．",
		out:  "ρ\n@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\n．",
	}, { // 1356
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ρ\v@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\v.",
		out:  "ρ\v@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\v.",
	}, { // 1357
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ρ\v@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\v．",
		out:  "ρ\v@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\v．",
	}, { // 1358
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ρ\r@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\r.",
		out:  "ρ\r@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\r.",
	}, { // 1359
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ρ\r@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&␀\vｊ\x03＃＾\x1c\r．",
		out:  "ρ\r@\\␉␘！χ\fη ι｝２ιλI｜␁\x1b&‛␀\vｊ\x03＃＾\x1c\r．",
	}, { // 1360
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\t\x1e",
		out:  "．\t\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\t\x1e",
	}, { // 1361
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\t\x1e",
		out:  "‛．\t\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\t\x1e",
	}, { // 1362
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\n\x1e",
		out:  "．\n\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\n\x1e",
	}, { // 1363
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\n\x1e",
		out:  "‛．\n\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\n\x1e",
	}, { // 1364
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\v\x1e",
		out:  "．\v\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\v\x1e",
	}, { // 1365
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\v\x1e",
		out:  "‛．\v\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\v\x1e",
	}, { // 1366
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\r\x1e",
		out:  "．\r\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\r\x1e",
	}, { // 1367
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\r\x1e",
		out:  "‛．\r\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\r\x1e",
	}, { // 1368
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␎\t\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\t.",
		out:  "␎\t\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\t.",
	}, { // 1369
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␎\t\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\t．",
		out:  "␎\t\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\t．",
	}, { // 1370
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␎\n\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\n.",
		out:  "␎\n\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\n.",
	}, { // 1371
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␎\n\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\n．",
		out:  "␎\n\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\n．",
	}, { // 1372
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␎\v\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\v.",
		out:  "␎\v\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\v.",
	}, { // 1373
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␎\v\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\v．",
		out:  "␎\v\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\v．",
	}, { // 1374
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␎\r\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\r.",
		out:  "␎\r\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\r.",
	}, { // 1375
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␎\r\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\r．",
		out:  "␎\r\x01ｕ␝=Y␊!␏ｈ8γθ␊␆８φ.?/τ！｀~＋ατ\r．",
	}, { // 1376
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\t\r",
		out:  "．\t␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\t␍",
	}, { // 1377
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\t\r",
		out:  "‛．\t␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\t␍",
	}, { // 1378
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\n\r",
		out:  "．\n␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\n␍",
	}, { // 1379
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\n\r",
		out:  "‛．\n␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\n␍",
	}, { // 1380
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\v\r",
		out:  "．\v␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\v␍",
	}, { // 1381
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\v\r",
		out:  "‛．\v␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\v␍",
	}, { // 1382
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\r\r",
		out:  "．\r␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\r␍",
	}, { // 1383
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\r\r",
		out:  "‛．\r␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\r␍",
	}, { // 1384
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "υ\t␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\t.",
		out:  "υ\t␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\t.",
	}, { // 1385
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "υ\t␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\t．",
		out:  "υ\t␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\t．",
	}, { // 1386
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "υ\n␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\n.",
		out:  "υ\n␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\n.",
	}, { // 1387
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "υ\n␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\n．",
		out:  "υ\n␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\n．",
	}, { // 1388
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "υ\v␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\v.",
		out:  "υ\v␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\v.",
	}, { // 1389
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "υ\v␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\v．",
		out:  "υ\v␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\v．",
	}, { // 1390
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "υ\r␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\r.",
		out:  "υ\r␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\r.",
	}, { // 1391
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "υ\r␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\r．",
		out:  "υ\r␔+\u007fχr{Ｏο\n␔＄Ｕο/\x15\u007f~Ｍ1ｅ␔κ|ψ＊␘\r．",
	}, { // 1392
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\tKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\t␔",
		out:  "．\tKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\t␔",
	}, { // 1393
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\tKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\t␔",
		out:  "‛．\tKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\t␔",
	}, { // 1394
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\n␔",
		out:  "．\nKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\n␔",
	}, { // 1395
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\n␔",
		out:  "‛．\nKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\n␔",
	}, { // 1396
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\v␔",
		out:  "．\vKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\v␔",
	}, { // 1397
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\v␔",
		out:  "‛．\vKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\v␔",
	}, { // 1398
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\r␔",
		out:  "．\rKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\r␔",
	}, { // 1399
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\r␔",
		out:  "‛．\rKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\r␔",
	}, { // 1400
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\tKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\t.",
		out:  "ξ\tKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\t.",
	}, { // 1401
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\tKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\t．",
		out:  "ξ\tKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\t．",
	}, { // 1402
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\nKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\n.",
		out:  "ξ\nKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\n.",
	}, { // 1403
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\nKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\n．",
		out:  "ξ\nKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\n．",
	}, { // 1404
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\vKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\v.",
		out:  "ξ\vKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\v.",
	}, { // 1405
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\vKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\v．",
		out:  "ξ\vKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\v．",
	}, { // 1406
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\rKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\r.",
		out:  "ξ\rKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\r.",
	}, { // 1407
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\rKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\r．",
		out:  "ξ\rKδ＇pσF␔mｓ\rγ\n>％#ο/＞＇\x01'ψ␌ｍＫ\\\r．",
	}, { // 1408
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\tι",
		out:  "．\t＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\tι",
	}, { // 1409
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\tι",
		out:  "‛．\t＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\tι",
	}, { // 1410
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\nι",
		out:  "．\n＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\nι",
	}, { // 1411
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\nι",
		out:  "‛．\n＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\nι",
	}, { // 1412
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\vι",
		out:  "．\v＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\vι",
	}, { // 1413
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\vι",
		out:  "‛．\v＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\vι",
	}, { // 1414
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\rι",
		out:  "．\r＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\rι",
	}, { // 1415
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\rι",
		out:  "‛．\r＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\rι",
	}, { // 1416
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\t＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\t.",
		out:  "ξ\t＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\t.",
	}, { // 1417
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\t＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\t．",
		out:  "ξ\t＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\t．",
	}, { // 1418
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\n＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\n.",
		out:  "ξ\n＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\n.",
	}, { // 1419
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\n＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\n．",
		out:  "ξ\n＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\n．",
	}, { // 1420
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\v＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\v.",
		out:  "ξ\v＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\v.",
	}, { // 1421
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\v＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\v．",
		out:  "ξ\v＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\v．",
	}, { // 1422
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\r＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\r.",
		out:  "ξ\r＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\r.",
	}, { // 1423
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ξ\r＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\r．",
		out:  "ξ\r＞\x05␐Ｑ}(＾pｙζ？␇：ｎＪ~>\x0f\bψz］␑β`τ\r．",
	}, { // 1424
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\tφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\t?",
		out:  "．\tφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\t?",
	}, { // 1425
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\tφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\t?",
		out:  "‛．\tφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\t?",
	}, { // 1426
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\n?",
		out:  "．\nφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\n?",
	}, { // 1427
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\n?",
		out:  "‛．\nφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\n?",
	}, { // 1428
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\v?",
		out:  "．\vφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\v?",
	}, { // 1429
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\v?",
		out:  "‛．\vφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\v?",
	}, { // 1430
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\r?",
		out:  "．\rφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\r?",
	}, { // 1431
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\r?",
		out:  "‛．\rφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\r?",
	}, { // 1432
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "％\tφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\t.",
		out:  "％\tφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\t.",
	}, { // 1433
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "％\tφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\t．",
		out:  "％\tφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\t．",
	}, { // 1434
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "％\nφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\n.",
		out:  "％\nφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\n.",
	}, { // 1435
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "％\nφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\n．",
		out:  "％\nφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\n．",
	}, { // 1436
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "％\vφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\v.",
		out:  "％\vφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\v.",
	}, { // 1437
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "％\vφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\v．",
		out:  "％\vφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\v．",
	}, { // 1438
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "％\rφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\r.",
		out:  "％\rφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\r.",
	}, { // 1439
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "％\rφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\r．",
		out:  "％\rφ␛{␔θ+\x12ας\x18／\vＦD＊\x11γｚ␎Ｔxωｈ␑＝y\r．",
	}, { // 1440
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\tＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\tA",
		out:  "．\tＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\tA",
	}, { // 1441
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\tＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\tA",
		out:  "‛．\tＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\tA",
	}, { // 1442
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\nA",
		out:  "．\nＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\nA",
	}, { // 1443
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\nA",
		out:  "‛．\nＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\nA",
	}, { // 1444
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\vA",
		out:  "．\vＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\vA",
	}, { // 1445
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\vA",
		out:  "‛．\vＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\vA",
	}, { // 1446
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\rA",
		out:  "．\rＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\rA",
	}, { // 1447
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\rA",
		out:  "‛．\rＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\rA",
	}, { // 1448
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｄ\tＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\t.",
		out:  "ｄ\tＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\t.",
	}, { // 1449
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｄ\tＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\t．",
		out:  "ｄ\tＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\t．",
	}, { // 1450
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｄ\nＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\n.",
		out:  "ｄ\nＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\n.",
	}, { // 1451
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｄ\nＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\n．",
		out:  "ｄ\nＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\n．",
	}, { // 1452
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｄ\vＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\v.",
		out:  "ｄ\vＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\v.",
	}, { // 1453
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｄ\vＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\v．",
		out:  "ｄ\vＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\v．",
	}, { // 1454
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｄ\rＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\r.",
		out:  "ｄ\rＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\r.",
	}, { // 1455
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｄ\rＸβ/＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\r．",
		out:  "ｄ\rＸβ/‛＃␇~␊␊Q\x1bσＰ6Ｂλ␡μm|G\bς－\x12\nο\r．",
	}, { // 1456
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\tκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\tφ",
		out:  "．\tκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\tφ",
	}, { // 1457
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\tκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\tφ",
		out:  "‛．\tκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\tφ",
	}, { // 1458
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\nφ",
		out:  "．\nκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\nφ",
	}, { // 1459
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\nφ",
		out:  "‛．\nκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\nφ",
	}, { // 1460
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\vφ",
		out:  "．\vκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\vφ",
	}, { // 1461
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\vφ",
		out:  "‛．\vκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\vφ",
	}, { // 1462
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\rφ",
		out:  "．\rκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\rφ",
	}, { // 1463
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\rφ",
		out:  "‛．\rκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\rφ",
	}, { // 1464
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␟\tκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\t.",
		out:  "␟\tκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\t.",
	}, { // 1465
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␟\tκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\t．",
		out:  "␟\tκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\t．",
	}, { // 1466
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␟\nκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\n.",
		out:  "␟\nκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\n.",
	}, { // 1467
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␟\nκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\n．",
		out:  "␟\nκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\n．",
	}, { // 1468
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␟\vκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\v.",
		out:  "␟\vκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\v.",
	}, { // 1469
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␟\vκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\v．",
		out:  "␟\vκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\v．",
	}, { // 1470
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␟\rκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\r.",
		out:  "␟\rκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\r.",
	}, { // 1471
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "␟\rκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃%␏$\x16+＼\r．",
		out:  "␟\rκ#φｓe\x11９ρ␟␜Ｐ＞＾#τσ\n;*＃％␏$\x16+＼\r．",
	}, { // 1472
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\t␟",
		out:  "．\t␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\t␟",
	}, { // 1473
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\t␟",
		out:  "‛．\t␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\t␟",
	}, { // 1474
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\n␟",
		out:  "．\n␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\n␟",
	}, { // 1475
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\n␟",
		out:  "‛．\n␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\n␟",
	}, { // 1476
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\v␟",
		out:  "．\v␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\v␟",
	}, { // 1477
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\v␟",
		out:  "‛．\v␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\v␟",
	}, { // 1478
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\r␟",
		out:  "．\r␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\r␟",
	}, { // 1479
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\r␟",
		out:  "‛．\r␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\r␟",
	}, { // 1480
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x15\t␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\t.",
		out:  "\x15\t␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\t.",
	}, { // 1481
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x15\t␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\t．",
		out:  "\x15\t␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\t．",
	}, { // 1482
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x15\n␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\n.",
		out:  "\x15\n␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\n.",
	}, { // 1483
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x15\n␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\n．",
		out:  "\x15\n␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\n．",
	}, { // 1484
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x15\v␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\v.",
		out:  "\x15\v␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\v.",
	}, { // 1485
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x15\v␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\v．",
		out:  "\x15\v␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\v．",
	}, { // 1486
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x15\r␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\r.",
		out:  "\x15\r␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\r.",
	}, { // 1487
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "\x15\r␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\r．",
		out:  "\x15\r␆ｔｈ0π␡\x04Z\x0f<;\x17R␓Ｘς４εβ␕\x1c␅＾ι]＞\r．",
	}, { // 1488
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\tπ",
		out:  "．\t＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\tπ",
	}, { // 1489
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\tπ",
		out:  "‛．\t＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\tπ",
	}, { // 1490
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\nπ",
		out:  "．\n＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\nπ",
	}, { // 1491
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\nπ",
		out:  "‛．\n＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\nπ",
	}, { // 1492
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\vπ",
		out:  "．\v＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\vπ",
	}, { // 1493
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\vπ",
		out:  "‛．\v＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\vπ",
	}, { // 1494
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\rπ",
		out:  "．\r＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\rπ",
	}, { // 1495
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\rπ",
		out:  "‛．\r＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\rπ",
	}, { // 1496
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ν\t＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\t.",
		out:  "ν\t＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\t.",
	}, { // 1497
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ν\t＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\t．",
		out:  "ν\t＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\t．",
	}, { // 1498
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ν\n＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\n.",
		out:  "ν\n＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\n.",
	}, { // 1499
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ν\n＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\n．",
		out:  "ν\n＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\n．",
	}, { // 1500
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ν\v＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\v.",
		out:  "ν\v＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\v.",
	}, { // 1501
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ν\v＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\v．",
		out:  "ν\v＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\v．",
	}, { // 1502
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ν\r＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\r.",
		out:  "ν\r＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\r.",
	}, { // 1503
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ν\r＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\r．",
		out:  "ν\r＃\x15／λd＃,gEγＨι\x1eYＷ\f'Ｔ\x16q␕Ｌｍ␌π\"\r．",
	}, { // 1504
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ Ｂλ␈ｌω＇ζＰζ<␐R\x19κ,$\x19＊␂\n>'dＳ\tω ｜",
		out:  "～ Ｂλ␈ｌω＇ζＰζ<␐R\x19κ,$\x19＊␂\n>'dＳ\tω ｜",
	}, { // 1505
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ Ｂλ␈ｌω＇ζＰζ<␐R\x19κ,$\x19＊␂\n>'dＳ\tω ｜",
		out:  "‛～ Ｂλ␈ｌω＇ζＰζ<␐R\x19κ,$\x19＊␂\n>'dＳ\tω ｜",
	}, { // 1506
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftSpace,
		in:   "␡ Ｂλ␈ｌω＇ζＰζ<␐R\x19κ,$\x19＊␂\n>'dＳ\tω ~",
		out:  "␡ Ｂλ␈ｌω＇ζＰζ<␐R\x19κ,$\x19＊␂\n>'dＳ\tω ~",
	}, { // 1507
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftSpace,
		in:   "␡ Ｂλ␈ｌω＇ζＰζ<␐R\x19κ,$\x19＊␂\n>'dＳ\tω ～",
		out:  "␡ Ｂλ␈ｌω＇ζＰζ<␐R\x19κ,$\x19＊␂\n>'dＳ\tω ～",
	}, { // 1508
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ W␞ε α\a\x10＼\rK7␒＇γ；％T４\x1eωμ␘␁ｊ\a␆ ｓ",
		out:  "～ W␞ε α\a\x10＼\rK7␒＇γ；％T４\x1eωμ␘␁ｊ\a␆ ｓ",
	}, { // 1509
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ W␞ε α\a\x10＼\rK7␒＇γ；％T４\x1eωμ␘␁ｊ\a␆ ｓ",
		out:  "‛～ W␞ε α\a\x10＼\rK7␒＇γ；％T４\x1eωμ␘␁ｊ\a␆ ｓ",
	}, { // 1510
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "8 W␞ε α\a\x10＼\rK7␒＇γ；％T４\x1eωμ␘␁ｊ\a␆ ~",
		out:  "8 W␞ε α\a\x10＼\rK7␒＇γ；％T４\x1eωμ␘␁ｊ\a␆ ~",
	}, { // 1511
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "8 W␞ε α\a\x10＼\rK7␒＇γ；％T４\x1eωμ␘␁ｊ\a␆ ～",
		out:  "8 W␞ε α\a\x10＼\rK7␒＇γ；％T４\x1eωμ␘␁ｊ\a␆ ～",
	}, { // 1512
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ π\x0f\x19＄'\x1d␐＂ω␐{/－BμM␊␓＃'␎`ν_ρＹ ␡",
		out:  "～ π\x0f\x19＄＇\x1d␐＂ω␐{/－BμM␊␓＃＇␎`ν_ρＹ ␡",
	}, { // 1513
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ π\x0f\x19＄'\x1d␐＂ω␐{/－BμM␊␓＃'␎`ν_ρＹ ␡",
		out:  "‛～ π\x0f\x19＄＇\x1d␐＂ω␐{/－BμM␊␓＃＇␎`ν_ρＹ ␡",
	}, { // 1514
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ε π\x0f\x19＄'\x1d␐＂ω␐{/－BμM␊␓＃'␎`ν_ρＹ ~",
		out:  "ε π\x0f\x19＄＇\x1d␐＂ω␐{/－BμM␊␓＃＇␎`ν_ρＹ ~",
	}, { // 1515
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ε π\x0f\x19＄'\x1d␐＂ω␐{/－BμM␊␓＃'␎`ν_ρＹ ～",
		out:  "ε π\x0f\x19＄＇\x1d␐＂ω␐{/－BμM␊␓＃＇␎`ν_ρＹ ～",
	}, { // 1516
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ η`\x11｀␟δ␔＼␞／λ\x10\"φ２1Ｕ)ｖHh\x1dR␅\x04θ \x0e",
		out:  "～ η｀\x11‛｀␟δ␔＼␞／λ\x10\"φ２1Ｕ)ｖHh\x1dR␅\x04θ \x0e",
	}, { // 1517
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ η`\x11｀␟δ␔＼␞／λ\x10\"φ２1Ｕ)ｖHh\x1dR␅\x04θ \x0e",
		out:  "‛～ η｀\x11‛｀␟δ␔＼␞／λ\x10\"φ２1Ｕ)ｖHh\x1dR␅\x04θ \x0e",
	}, { // 1518
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "α η`\x11｀␟δ␔＼␞／λ\x10\"φ２1Ｕ)ｖHh\x1dR␅\x04θ ~",
		out:  "α η｀\x11‛｀␟δ␔＼␞／λ\x10\"φ２1Ｕ)ｖHh\x1dR␅\x04θ ~",
	}, { // 1519
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "α η`\x11｀␟δ␔＼␞／λ\x10\"φ２1Ｕ)ｖHh\x1dR␅\x04θ ～",
		out:  "α η｀\x11‛｀␟δ␔＼␞／λ\x10\"φ２1Ｕ)ｖHh\x1dR␅\x04θ ～",
	}, { // 1520
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ ␇；λ␛`Q␌Ｎψ８Ｙ\x1eoｐ|')\x1fγχ␟Ｘ4ξ␃\x05 ␘",
		out:  "～ ␇；λ␛`Q␌Ｎψ８Ｙ\x1eoｐ|')\x1fγχ␟Ｘ4ξ␃\x05 ␘",
	}, { // 1521
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ ␇；λ␛`Q␌Ｎψ８Ｙ\x1eoｐ|')\x1fγχ␟Ｘ4ξ␃\x05 ␘",
		out:  "‛～ ␇；λ␛`Q␌Ｎψ８Ｙ\x1eoｐ|')\x1fγχ␟Ｘ4ξ␃\x05 ␘",
	}, { // 1522
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftSpace,
		in:   "> ␇；λ␛`Q␌Ｎψ８Ｙ\x1eoｐ|')\x1fγχ␟Ｘ4ξ␃\x05 ~",
		out:  "＞ ␇；λ␛`Q␌Ｎψ８Ｙ\x1eoｐ|')\x1fγχ␟Ｘ4ξ␃\x05 ~",
	}, { // 1523
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftSpace,
		in:   "> ␇；λ␛`Q␌Ｎψ８Ｙ\x1eoｐ|')\x1fγχ␟Ｘ4ξ␃\x05 ～",
		out:  "＞ ␇；λ␛`Q␌Ｎψ８Ｙ\x1eoｐ|')\x1fγχ␟Ｘ4ξ␃\x05 ～",
	}, { // 1524
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ πU0Ｗ\u007f␚S␒ｒ2３ξ＇␟］ο6\x1b\x15φ\uff00ι\x12␔␋τ \n",
		out:  "～ πU0Ｗ\u007f␚S␒ｒ2３ξ＇␟］ο6\x1b\x15φ\uff00ι\x12␔␋τ \n",
	}, { // 1525
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ πU0Ｗ\u007f␚S␒ｒ2３ξ＇␟］ο6\x1b\x15φ\uff00ι\x12␔␋τ \n",
		out:  "‛～ πU0Ｗ\u007f␚S␒ｒ2３ξ＇␟］ο6\x1b\x15φ\uff00ι\x12␔␋τ \n",
	}, { // 1526
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftSpace,
		in:   "\x13 πU0Ｗ\u007f␚S␒ｒ2３ξ＇␟］ο6\x1b\x15φ\uff00ι\x12␔␋τ ~",
		out:  "\x13 πU0Ｗ\u007f␚S␒ｒ2３ξ＇␟］ο6\x1b\x15φ\uff00ι\x12␔␋τ ~",
	}, { // 1527
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftSpace,
		in:   "\x13 πU0Ｗ\u007f␚S␒ｒ2３ξ＇␟］ο6\x1b\x15φ\uff00ι\x12␔␋τ ～",
		out:  "\x13 πU0Ｗ\u007f␚S␒ｒ2３ξ＇␟］ο6\x1b\x15φ\uff00ι\x12␔␋τ ～",
	}, { // 1528
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ :?＞\x01~~Ａ␊\x04π␌RN＇ς␑ｎ\x10\x18ｓμθＵρ＃Ｆ Y",
		out:  "～ :?＞\x01~~Ａ␊\x04π␌RN＇ς␑ｎ\x10\x18ｓμθＵρ＃Ｆ Y",
	}, { // 1529
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ :?＞\x01~~Ａ␊\x04π␌RN＇ς␑ｎ\x10\x18ｓμθＵρ＃Ｆ Y",
		out:  "‛～ :?＞\x01~~Ａ␊\x04π␌RN＇ς␑ｎ\x10\x18ｓμθＵρ＃Ｆ Y",
	}, { // 1530
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "｜ :?＞\x01~~Ａ␊\x04π␌RN＇ς␑ｎ\x10\x18ｓμθＵρ＃Ｆ ~",
		out:  "｜ :?＞\x01~~Ａ␊\x04π␌RN＇ς␑ｎ\x10\x18ｓμθＵρ＃Ｆ ~",
	}, { // 1531
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftSpace,
		in:   "｜ :?＞\x01~~Ａ␊\x04π␌RN＇ς␑ｎ\x10\x18ｓμθＵρ＃Ｆ ～",
		out:  "｜ :?＞\x01~~Ａ␊\x04π␌RN＇ς␑ｎ\x10\x18ｓμθＵρ＃Ｆ ～",
	}, { // 1532
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ ς＇\"ββmｒπＳ␅\x0f'␀␝\x1cμ␛\a)␖ｉa＜ｑl\b M",
		out:  "～ ς＇\"ββmｒπＳ␅\x0f'‛␀␝\x1cμ␛\a)␖ｉa＜ｑl\b M",
	}, { // 1533
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ ς＇\"ββmｒπＳ␅\x0f'␀␝\x1cμ␛\a)␖ｉa＜ｑl\b M",
		out:  "‛～ ς＇\"ββmｒπＳ␅\x0f'‛␀␝\x1cμ␛\a)␖ｉa＜ｑl\b M",
	}, { // 1534
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftSpace,
		in:   "o ς＇\"ββmｒπＳ␅\x0f'␀␝\x1cμ␛\a)␖ｉa＜ｑl\b ~",
		out:  "o ς＇\"ββmｒπＳ␅\x0f'‛␀␝\x1cμ␛\a)␖ｉa＜ｑl\b ~",
	}, { // 1535
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftSpace,
		in:   "o ς＇\"ββmｒπＳ␅\x0f'␀␝\x1cμ␛\a)␖ｉa＜ｑl\b ～",
		out:  "o ς＇\"ββmｒπＳ␅\x0f'‛␀␝\x1cμ␛\a)␖ｉa＜ｑl\b ～",
	}, { // 1536
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ \x13/1?ο␞＃αη１`@／\x03λ＜;$␚%␍ＡξＯ\"＾ λ",
		out:  "～ \x13/1？ο␞＃αη１`@／\x03λ＜;$␚%␍ＡξＯ\"＾ λ",
	}, { // 1537
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ \x13/1?ο␞＃αη１`@／\x03λ＜;$␚%␍ＡξＯ\"＾ λ",
		out:  "‛～ \x13/1？ο␞＃αη１`@／\x03λ＜;$␚%␍ＡξＯ\"＾ λ",
	}, { // 1538
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftSpace,
		in:   "＃ \x13/1?ο␞＃αη１`@／\x03λ＜;$␚%␍ＡξＯ\"＾ ~",
		out:  "＃ \x13/1？ο␞＃αη１`@／\x03λ＜;$␚%␍ＡξＯ\"＾ ~",
	}, { // 1539
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftSpace,
		in:   "＃ \x13/1?ο␞＃αη１`@／\x03λ＜;$␚%␍ＡξＯ\"＾ ～",
		out:  "＃ \x13/1？ο␞＃αη１`@／\x03λ＜;$␚%␍ＡξＯ\"＾ ～",
	}, { // 1540
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ 'ζ７Ｈ/＝ω \v＞ｔ␍λ␖=ε\x0e\x0e\x14␄υα\nf\x00ｎ ／",
		out:  "～ 'ζ７Ｈ/＝ω \v＞ｔ␍λ␖=ε\x0e\x0e\x14␄υα\nf␀ｎ ／",
	}, { // 1541
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ 'ζ７Ｈ/＝ω \v＞ｔ␍λ␖=ε\x0e\x0e\x14␄υα\nf\x00ｎ ／",
		out:  "‛～ 'ζ７Ｈ/＝ω \v＞ｔ␍λ␖=ε\x0e\x0e\x14␄υα\nf␀ｎ ／",
	}, { // 1542
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftSpace,
		in:   "s 'ζ７Ｈ/＝ω \v＞ｔ␍λ␖=ε\x0e\x0e\x14␄υα\nf\x00ｎ ~",
		out:  "s 'ζ７Ｈ/＝ω \v＞ｔ␍λ␖=ε\x0e\x0e\x14␄υα\nf␀ｎ ~",
	}, { // 1543
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftSpace,
		in:   "s 'ζ７Ｈ/＝ω \v＞ｔ␍λ␖=ε\x0e\x0e\x14␄υα\nf\x00ｎ ～",
		out:  "s 'ζ７Ｈ/＝ω \v＞ｔ␍λ␖=ε\x0e\x0e\x14␄υα\nf␀ｎ ～",
	}, { // 1544
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ \x1b\x1aβ~\rzφ｜θpς）␓␝\x11*␌＄Ｔ｜δSν\x1e␂\x06 Ｌ",
		out:  "～ \x1b\x1aβ~\rzφ‛｜θpς）␓␝\x11*␌＄Ｔ‛｜δSν\x1e␂\x06 Ｌ",
	}, { // 1545
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ \x1b\x1aβ~\rzφ｜θpς）␓␝\x11*␌＄Ｔ｜δSν\x1e␂\x06 Ｌ",
		out:  "‛～ \x1b\x1aβ~\rzφ‛｜θpς）␓␝\x11*␌＄Ｔ‛｜δSν\x1e␂\x06 Ｌ",
	}, { // 1546
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftSpace,
		in:   "＄ \x1b\x1aβ~\rzφ｜θpς）␓␝\x11*␌＄Ｔ｜δSν\x1e␂\x06 ~",
		out:  "＄ \x1b\x1aβ~\rzφ‛｜θpς）␓␝\x11*␌＄Ｔ‛｜δSν\x1e␂\x06 ~",
	}, { // 1547
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftSpace,
		in:   "＄ \x1b\x1aβ~\rzφ｜θpς）␓␝\x11*␌＄Ｔ｜δSν\x1e␂\x06 ～",
		out:  "＄ \x1b\x1aβ~\rzφ‛｜θpς）␓␝\x11*␌＄Ｔ‛｜δSν\x1e␂\x06 ～",
	}, { // 1548
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ ［l｝>τβ\x18ＦＯu␖$Wζ^␐\u007fω\x14\\％，E＜␄８ \x1b",
		out:  "～ ［l｝>τβ\x18ＦＯu␖$Wζ^␐\u007fω\x14\\％，E＜␄８ \x1b",
	}, { // 1549
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ ［l｝>τβ\x18ＦＯu␖$Wζ^␐\u007fω\x14\\％，E＜␄８ \x1b",
		out:  "‛～ ［l｝>τβ\x18ＦＯu␖$Wζ^␐\u007fω\x14\\％，E＜␄８ \x1b",
	}, { // 1550
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ψ ［l｝>τβ\x18ＦＯu␖$Wζ^␐\u007fω\x14\\％，E＜␄８ ~",
		out:  "ψ ［l｝>τβ\x18ＦＯu␖$Wζ^␐\u007fω\x14\\％，E＜␄８ ~",
	}, { // 1551
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ψ ［l｝>τβ\x18ＦＯu␖$Wζ^␐\u007fω\x14\\％，E＜␄８ ～",
		out:  "ψ ［l｝>τβ\x18ＦＯu␖$Wζ^␐\u007fω\x14\\％，E＜␄８ ～",
	}, { // 1552
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ ／/ｅＵＭ5ο\x16c$␜$j｀ζ{ｈλ\x02ξ␐κ８ｄj％ ψ",
		out:  "～ ／/ｅＵＭ5ο\x16c$␜$j｀ζ{ｈλ\x02ξ␐κ８ｄj‛％ ψ",
	}, { // 1553
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ ／/ｅＵＭ5ο\x16c$␜$j｀ζ{ｈλ\x02ξ␐κ８ｄj％ ψ",
		out:  "‛～ ／/ｅＵＭ5ο\x16c$␜$j｀ζ{ｈλ\x02ξ␐κ８ｄj‛％ ψ",
	}, { // 1554
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftSpace,
		in:   "␒ ／/ｅＵＭ5ο\x16c$␜$j｀ζ{ｈλ\x02ξ␐κ８ｄj％ ~",
		out:  "␒ ／/ｅＵＭ5ο\x16c$␜$j｀ζ{ｈλ\x02ξ␐κ８ｄj‛％ ~",
	}, { // 1555
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftSpace,
		in:   "␒ ／/ｅＵＭ5ο\x16c$␜$j｀ζ{ｈλ\x02ξ␐κ８ｄj％ ～",
		out:  "␒ ／/ｅＵＭ5ο\x16c$␜$j｀ζ{ｈλ\x02ξ␐κ８ｄj‛％ ～",
	}, { // 1556
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ Ｙ｝\x1e\rσ␔μＡ\"Aυ４＄␁mｊNη\x0f\f{␃＃\x1fσ$ Ｇ",
		out:  "～ Ｙ｝\x1e\rσ␔μＡ\"Aυ４＄␁mｊNη\x0f\f{␃＃\x1fσ$ Ｇ",
	}, { // 1557
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ Ｙ｝\x1e\rσ␔μＡ\"Aυ４＄␁mｊNη\x0f\f{␃＃\x1fσ$ Ｇ",
		out:  "‛～ Ｙ｝\x1e\rσ␔μＡ\"Aυ４＄␁mｊNη\x0f\f{␃＃\x1fσ$ Ｇ",
	}, { // 1558
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ω Ｙ｝\x1e\rσ␔μＡ\"Aυ４＄␁mｊNη\x0f\f{␃＃\x1fσ$ ~",
		out:  "ω Ｙ｝\x1e\rσ␔μＡ\"Aυ４＄␁mｊNη\x0f\f{␃＃\x1fσ$ ~",
	}, { // 1559
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ω Ｙ｝\x1e\rσ␔μＡ\"Aυ４＄␁mｊNη\x0f\f{␃＃\x1fσ$ ～",
		out:  "ω Ｙ｝\x1e\rσ␔μＡ\"Aυ４＄␁mｊNη\x0f\f{␃＃\x1fσ$ ～",
	}, { // 1560
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ ／＼μ*\u007f%Q／Ｙ|＄＄M␁Ｊｔκ\x06␅ξｔM\x04λ\v' ４",
		out:  "～ ／＼μ*\u007f%Q／Ｙ|＄＄M␁Ｊｔκ\x06␅ξｔM\x04λ\v' ４",
	}, { // 1561
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ ／＼μ*\u007f%Q／Ｙ|＄＄M␁Ｊｔκ\x06␅ξｔM\x04λ\v' ４",
		out:  "‛～ ／＼μ*\u007f%Q／Ｙ|＄＄M␁Ｊｔκ\x06␅ξｔM\x04λ\v' ４",
	}, { // 1562
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ψ ／＼μ*\u007f%Q／Ｙ|＄＄M␁Ｊｔκ\x06␅ξｔM\x04λ\v' ~",
		out:  "ψ ／＼μ*\u007f%Q／Ｙ|＄＄M␁Ｊｔκ\x06␅ξｔM\x04λ\v' ~",
	}, { // 1563
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ψ ／＼μ*\u007f%Q／Ｙ|＄＄M␁Ｊｔκ\x06␅ξｔM\x04λ\v' ～",
		out:  "ψ ／＼μ*\u007f%Q／Ｙ|＄＄M␁Ｊｔκ\x06␅ξｔM\x04λ\v' ～",
	}, { // 1564
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ K␍␐\rU１U␍Ｅ␀\x1aＹ\n\x00ωｎ\x06kδ＃ｂＡ␙ε\x13ω ι",
		out:  "～ K␍␐\rU１U␍Ｅ‛␀\x1aＹ\n␀ωｎ\x06kδ＃ｂＡ␙ε\x13ω ι",
	}, { // 1565
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ K␍␐\rU１U␍Ｅ␀\x1aＹ\n\x00ωｎ\x06kδ＃ｂＡ␙ε\x13ω ι",
		out:  "‛～ K␍␐\rU１U␍Ｅ‛␀\x1aＹ\n␀ωｎ\x06kδ＃ｂＡ␙ε\x13ω ι",
	}, { // 1566
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftSpace,
		in:   "^ K␍␐\rU１U␍Ｅ␀\x1aＹ\n\x00ωｎ\x06kδ＃ｂＡ␙ε\x13ω ~",
		out:  "^ K␍␐\rU１U␍Ｅ‛␀\x1aＹ\n␀ωｎ\x06kδ＃ｂＡ␙ε\x13ω ~",
	}, { // 1567
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftSpace,
		in:   "^ K␍␐\rU１U␍Ｅ␀\x1aＹ\n\x00ωｎ\x06kδ＃ｂＡ␙ε\x13ω ～",
		out:  "^ K␍␐\rU１U␍Ｅ‛␀\x1aＹ\n␀ωｎ\x06kδ＃ｂＡ␙ε\x13ω ～",
	}, { // 1568
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftSpace,
		in:   "~ :φＲ\x11\x11CｔＫ␀Ｑs；ξα␎p␄\r␓X＊α\v \x11K τ",
		out:  "～ :φＲ␑␑CｔＫ‛␀Ｑs；ξα‛␎p‛␄␍‛␓X＊α␋ ␑K τ",
	}, { // 1569
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftSpace,
		in:   "～ :φＲ\x11\x11CｔＫ␀Ｑs；ξα␎p␄\r␓X＊α\v \x11K τ",
		out:  "‛～ :φＲ␑␑CｔＫ‛␀Ｑs；ξα‛␎p‛␄␍‛␓X＊α␋ ␑K τ",
	}, { // 1570
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ｉ :φＲ\x11\x11CｔＫ␀Ｑs；ξα␎p␄\r␓X＊α\v \x11K ~",
		out:  "ｉ :φＲ␑␑CｔＫ‛␀Ｑs；ξα‛␎p‛␄␍‛␓X＊α␋ ␑K ~",
	}, { // 1571
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftSpace,
		in:   "ｉ :φＲ\x11\x11CｔＫ␀Ｑs；ξα␎p␄\r␓X＊α\v \x11K ～",
		out:  "ｉ :φＲ␑␑CｔＫ‛␀Ｑs；ξα‛␎p‛␄␍‛␓X＊α␋ ␑K ～",
	}, { // 1572
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.\r．E｝\r＇βyＶｙφ\f␀＂\x03;\x1eξ␂ｎ␆[c＂\x19ζ.␊",
		out:  "～.\r．E｝\r＇βyＶｙφ\f‛␀＂\x03;\x1eξ␂ｎ␆[c＂\x19ζ.␊",
	}, { // 1573
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.\r．E｝\r＇βyＶｙφ\f␀＂\x03;\x1eξ␂ｎ␆[c＂\x19ζ.␊",
		out:  "‛～.\r．E｝\r＇βyＶｙφ\f‛␀＂\x03;\x1eξ␂ｎ␆[c＂\x19ζ.␊",
	}, { // 1574
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "4.\r．E｝\r＇βyＶｙφ\f␀＂\x03;\x1eξ␂ｎ␆[c＂\x19ζ.~",
		out:  "4.\r．E｝\r＇βyＶｙφ\f‛␀＂\x03;\x1eξ␂ｎ␆[c＂\x19ζ.~",
	}, { // 1575
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "4.\r．E｝\r＇βyＶｙφ\f␀＂\x03;\x1eξ␂ｎ␆[c＂\x19ζ.～",
		out:  "4.\r．E｝\r＇βyＶｙφ\f‛␀＂\x03;\x1eξ␂ｎ␆[c＂\x19ζ.～",
	}, { // 1576
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.Ａκ␄\x16：Z0ωωτ＇：＝oθ\x00＼␘R\b\boｍ＃Ｄψ.L",
		out:  "～.Ａκ␄\x16：Z0ωωτ＇：＝oθ␀＼␘R\b\boｍ＃Ｄψ.L",
	}, { // 1577
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.Ａκ␄\x16：Z0ωωτ＇：＝oθ\x00＼␘R\b\boｍ＃Ｄψ.L",
		out:  "‛～.Ａκ␄\x16：Z0ωωτ＇：＝oθ␀＼␘R\b\boｍ＃Ｄψ.L",
	}, { // 1578
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "␋.Ａκ␄\x16：Z0ωωτ＇：＝oθ\x00＼␘R\b\boｍ＃Ｄψ.~",
		out:  "␋.Ａκ␄\x16：Z0ωωτ＇：＝oθ␀＼␘R\b\boｍ＃Ｄψ.~",
	}, { // 1579
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "␋.Ａκ␄\x16：Z0ωωτ＇：＝oθ\x00＼␘R\b\boｍ＃Ｄψ.～",
		out:  "␋.Ａκ␄\x16：Z0ωωτ＇：＝oθ␀＼␘R\b\boｍ＃Ｄψ.～",
	}, { // 1580
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.␖｜G：＄＝␝（␀|Ｆ\x1c2]ζζ\x05σ/␍\x1a２φ2Ｆς.4",
		out:  "～.␖｜G：＄＝␝（‛␀|Ｆ\x1c2]ζζ\x05σ/␍\x1a２φ2Ｆς.4",
	}, { // 1581
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.␖｜G：＄＝␝（␀|Ｆ\x1c2]ζζ\x05σ/␍\x1a２φ2Ｆς.4",
		out:  "‛～.␖｜G：＄＝␝（‛␀|Ｆ\x1c2]ζζ\x05σ/␍\x1a２φ2Ｆς.4",
	}, { // 1582
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "φ.␖｜G：＄＝␝（␀|Ｆ\x1c2]ζζ\x05σ/␍\x1a２φ2Ｆς.~",
		out:  "φ.␖｜G：＄＝␝（‛␀|Ｆ\x1c2]ζζ\x05σ/␍\x1a２φ2Ｆς.~",
	}, { // 1583
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "φ.␖｜G：＄＝␝（␀|Ｆ\x1c2]ζζ\x05σ/␍\x1a２φ2Ｆς.～",
		out:  "φ.␖｜G：＄＝␝（‛␀|Ｆ\x1c2]ζζ\x05σ/␍\x1a２φ2Ｆς.～",
	}, { // 1584
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~./o␈［ς\u007f％\x1c｀οＺ\x0e6{␛π｜π\u007fιjｐ＞？\v\x0f.ｋ",
		out:  "～./o␈［ς\u007f％\x1c‛｀οＺ\x0e6{␛π｜π\u007fιjｐ＞？\v\x0f.ｋ",
	}, { // 1585
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～./o␈［ς\u007f％\x1c｀οＺ\x0e6{␛π｜π\u007fιjｐ＞？\v\x0f.ｋ",
		out:  "‛～./o␈［ς\u007f％\x1c‛｀οＺ\x0e6{␛π｜π\u007fιjｐ＞？\v\x0f.ｋ",
	}, { // 1586
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "␖./o␈［ς\u007f％\x1c｀οＺ\x0e6{␛π｜π\u007fιjｐ＞？\v\x0f.~",
		out:  "␖./o␈［ς\u007f％\x1c‛｀οＺ\x0e6{␛π｜π\u007fιjｐ＞？\v\x0f.~",
	}, { // 1587
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "␖./o␈［ς\u007f％\x1c｀οＺ\x0e6{␛π｜π\u007fιjｐ＞？\v\x0f.～",
		out:  "␖./o␈［ς\u007f％\x1c‛｀οＺ\x0e6{␛π｜π\u007fιjｐ＞？\v\x0f.～",
	}, { // 1588
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.＃＞\x10ο\x06？␗D2ｒ\x1b9:%θＶπｉ\x1d｝φ␃U}Ｇζ.δ",
		out:  "～.＃‛＞\x10ο\x06？␗D2ｒ\x1b9:%θＶπｉ\x1d｝φ␃U}Ｇζ.δ",
	}, { // 1589
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.＃＞\x10ο\x06？␗D2ｒ\x1b9:%θＶπｉ\x1d｝φ␃U}Ｇζ.δ",
		out:  "‛～.＃‛＞\x10ο\x06？␗D2ｒ\x1b9:%θＶπｉ\x1d｝φ␃U}Ｇζ.δ",
	}, { // 1590
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "V.＃＞\x10ο\x06？␗D2ｒ\x1b9:%θＶπｉ\x1d｝φ␃U}Ｇζ.~",
		out:  "V.＃‛＞\x10ο\x06？␗D2ｒ\x1b9:%θＶπｉ\x1d｝φ␃U}Ｇζ.~",
	}, { // 1591
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "V.＃＞\x10ο\x06？␗D2ｒ\x1b9:%θＶπｉ\x1d｝φ␃U}Ｇζ.～",
		out:  "V.＃‛＞\x10ο\x06？␗D2ｒ\x1b9:%θＶπｉ\x1d｝φ␃U}Ｇζ.～",
	}, { // 1592
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.␊δ}␒?<ι\x1eη␖$ｏ␗ｃxｒｚ/ρψ\x15Ｑd＜｀#.␍",
		out:  "～.␊δ}␒?<ι\x1eη␖＄ｏ␗ｃxｒｚ/ρψ\x15Ｑd＜｀#.␍",
	}, { // 1593
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.␊δ}␒?<ι\x1eη␖$ｏ␗ｃxｒｚ/ρψ\x15Ｑd＜｀#.␍",
		out:  "‛～.␊δ}␒?<ι\x1eη␖＄ｏ␗ｃxｒｚ/ρψ\x15Ｑd＜｀#.␍",
	}, { // 1594
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "υ.␊δ}␒?<ι\x1eη␖$ｏ␗ｃxｒｚ/ρψ\x15Ｑd＜｀#.~",
		out:  "υ.␊δ}␒?<ι\x1eη␖＄ｏ␗ｃxｒｚ/ρψ\x15Ｑd＜｀#.~",
	}, { // 1595
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "υ.␊δ}␒?<ι\x1eη␖$ｏ␗ｃxｒｚ/ρψ\x15Ｑd＜｀#.～",
		out:  "υ.␊δ}␒?<ι\x1eη␖＄ｏ␗ｃxｒｚ/ρψ\x15Ｑd＜｀#.～",
	}, { // 1596
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.ω␡．α\x01y\x110：＃ξ/Ｆ`λ␚ｔd␛＄\x10ＣM=Ｏs.ν",
		out:  "～.ω␡．α\x01y\x110：＃ξ/Ｆ`λ␚ｔd␛＄\x10ＣM=Ｏs.ν",
	}, { // 1597
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.ω␡．α\x01y\x110：＃ξ/Ｆ`λ␚ｔd␛＄\x10ＣM=Ｏs.ν",
		out:  "‛～.ω␡．α\x01y\x110：＃ξ/Ｆ`λ␚ｔd␛＄\x10ＣM=Ｏs.ν",
	}, { // 1598
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "υ.ω␡．α\x01y\x110：＃ξ/Ｆ`λ␚ｔd␛＄\x10ＣM=Ｏs.~",
		out:  "υ.ω␡．α\x01y\x110：＃ξ/Ｆ`λ␚ｔd␛＄\x10ＣM=Ｏs.~",
	}, { // 1599
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "υ.ω␡．α\x01y\x110：＃ξ/Ｆ`λ␚ｔd␛＄\x10ＣM=Ｏs.～",
		out:  "υ.ω␡．α\x01y\x110：＃ξ/Ｆ`λ␚ｔd␛＄\x10ＣM=Ｏs.～",
	}, { // 1600
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~./αων\r-δ␚␆ｉ）\n/ｊιIO＼\x00␜μ\x17/＝％\f.␚",
		out:  "～./αων\r-δ␚␆ｉ）\n/ｊιIO＼␀␜μ\x17/＝％\f.␚",
	}, { // 1601
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～./αων\r-δ␚␆ｉ）\n/ｊιIO＼\x00␜μ\x17/＝％\f.␚",
		out:  "‛～./αων\r-δ␚␆ｉ）\n/ｊιIO＼␀␜μ\x17/＝％\f.␚",
	}, { // 1602
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "ｒ./αων\r-δ␚␆ｉ）\n/ｊιIO＼\x00␜μ\x17/＝％\f.~",
		out:  "ｒ./αων\r-δ␚␆ｉ）\n/ｊιIO＼␀␜μ\x17/＝％\f.~",
	}, { // 1603
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "ｒ./αων\r-δ␚␆ｉ）\n/ｊιIO＼\x00␜μ\x17/＝％\f.～",
		out:  "ｒ./αων\r-δ␚␆ｉ）\n/ｊιIO＼␀␜μ\x17/＝％\f.～",
	}, { // 1604
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.␟\x14７\x1e\x14θ'］␊＊λB␊Ｎｌ:␖，\nτ＿$\x19Aωο.ξ",
		out:  "～.␟\x14７\x1e\x14θ'］␊＊λB␊Ｎｌ:␖，\nτ＿$\x19Aωο.ξ",
	}, { // 1605
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.␟\x14７\x1e\x14θ'］␊＊λB␊Ｎｌ:␖，\nτ＿$\x19Aωο.ξ",
		out:  "‛～.␟\x14７\x1e\x14θ'］␊＊λB␊Ｎｌ:␖，\nτ＿$\x19Aωο.ξ",
	}, { // 1606
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "T.␟\x14７\x1e\x14θ'］␊＊λB␊Ｎｌ:␖，\nτ＿$\x19Aωο.~",
		out:  "T.␟\x14７\x1e\x14θ'］␊＊λB␊Ｎｌ:␖，\nτ＿$\x19Aωο.~",
	}, { // 1607
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "T.␟\x14７\x1e\x14θ'］␊＊λB␊Ｎｌ:␖，\nτ＿$\x19Aωο.～",
		out:  "T.␟\x14７\x1e\x14θ'］␊＊λB␊Ｎｌ:␖，\nτ＿$\x19Aωο.～",
	}, { // 1608
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.␗h\x1b\x1aＧｚ＠νγｋπ␂：v$#ＡZfυμb；␓␞λ.␀",
		out:  "～.␗h\x1b\x1aＧｚ＠νγｋπ␂：v$#ＡZfυμb；␓␞λ.‛␀",
	}, { // 1609
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.␗h\x1b\x1aＧｚ＠νγｋπ␂：v$#ＡZfυμb；␓␞λ.␀",
		out:  "‛～.␗h\x1b\x1aＧｚ＠νγｋπ␂：v$#ＡZfυμb；␓␞λ.‛␀",
	}, { // 1610
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "`.␗h\x1b\x1aＧｚ＠νγｋπ␂：v$#ＡZfυμb；␓␞λ.~",
		out:  "`.␗h\x1b\x1aＧｚ＠νγｋπ␂：v$#ＡZfυμb；␓␞λ.~",
	}, { // 1611
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "`.␗h\x1b\x1aＧｚ＠νγｋπ␂：v$#ＡZfυμb；␓␞λ.～",
		out:  "`.␗h\x1b\x1aＧｚ＠νγｋπ␂：v$#ＡZfυμb；␓␞λ.～",
	}, { // 1612
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.`␘Ｓ␘５7σ＇v#\\?ο＼κοｉ7ｎ`␞９＊\x14\x15u.$",
		out:  "～.`␘Ｓ␘５7σ＇v#\\?ο＼κοｉ7ｎ`␞９＊\x14\x15u.$",
	}, { // 1613
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.`␘Ｓ␘５7σ＇v#\\?ο＼κοｉ7ｎ`␞９＊\x14\x15u.$",
		out:  "‛～.`␘Ｓ␘５7σ＇v#\\?ο＼κοｉ7ｎ`␞９＊\x14\x15u.$",
	}, { // 1614
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "Ｐ.`␘Ｓ␘５7σ＇v#\\?ο＼κοｉ7ｎ`␞９＊\x14\x15u.~",
		out:  "Ｐ.`␘Ｓ␘５7σ＇v#\\?ο＼κοｉ7ｎ`␞９＊\x14\x15u.~",
	}, { // 1615
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "Ｐ.`␘Ｓ␘５7σ＇v#\\?ο＼κοｉ7ｎ`␞９＊\x14\x15u.～",
		out:  "Ｐ.`␘Ｓ␘５7σ＇v#\\?ο＼κοｉ7ｎ`␞９＊\x14\x15u.～",
	}, { // 1616
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.UαN\x03%P)\x1a\x06βζ＋％πκ\r␈θO６（␕｜`９␄.Ｍ",
		out:  "～.UαN\x03%P)\x1a\x06βζ＋％πκ\r␈θO６（␕｜`９␄.Ｍ",
	}, { // 1617
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.UαN\x03%P)\x1a\x06βζ＋％πκ\r␈θO６（␕｜`９␄.Ｍ",
		out:  "‛～.UαN\x03%P)\x1a\x06βζ＋％πκ\r␈θO６（␕｜`９␄.Ｍ",
	}, { // 1618
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\x18.UαN\x03%P)\x1a\x06βζ＋％πκ\r␈θO６（␕｜`９␄.~",
		out:  "\x18.UαN\x03%P)\x1a\x06βζ＋％πκ\r␈θO６（␕｜`９␄.~",
	}, { // 1619
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\x18.UαN\x03%P)\x1a\x06βζ＋％πκ\r␈θO６（␕｜`９␄.～",
		out:  "\x18.UαN\x03%P)\x1a\x06βζ＋％πκ\r␈θO６（␕｜`９␄.～",
	}, { // 1620
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.？＂/ｙ\x12␈␔/Ｃλ\x0eS？ψ？O␒φλ０eQ５３|ξ.\x13",
		out:  "～.？＂/ｙ\x12␈␔/Ｃλ\x0eS？ψ？O␒φλ０eQ５３|ξ.\x13",
	}, { // 1621
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.？＂/ｙ\x12␈␔/Ｃλ\x0eS？ψ？O␒φλ０eQ５３|ξ.\x13",
		out:  "‛～.？＂/ｙ\x12␈␔/Ｃλ\x0eS？ψ？O␒φλ０eQ５３|ξ.\x13",
	}, { // 1622
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\x0f.？＂/ｙ\x12␈␔/Ｃλ\x0eS？ψ？O␒φλ０eQ５３|ξ.~",
		out:  "\x0f.？＂/ｙ\x12␈␔/Ｃλ\x0eS？ψ？O␒φλ０eQ５３|ξ.~",
	}, { // 1623
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\x0f.？＂/ｙ\x12␈␔/Ｃλ\x0eS？ψ？O␒φλ０eQ５３|ξ.～",
		out:  "\x0f.？＂/ｙ\x12␈␔/Ｃλ\x0eS？ψ？O␒φλ０eQ５３|ξ.～",
	}, { // 1624
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.＼\x00␊'ρＳ\\an）␇*\uff00λ\x115␃␆[＃\n４σψε+.＇",
		out:  "～.‛＼␀␊'ρＳ＼an）␇*\uff00λ\x115␃␆[＃\n４σψε+.＇",
	}, { // 1625
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.＼\x00␊'ρＳ\\an）␇*\uff00λ\x115␃␆[＃\n４σψε+.＇",
		out:  "‛～.‛＼␀␊'ρＳ＼an）␇*\uff00λ\x115␃␆[＃\n４σψε+.＇",
	}, { // 1626
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "ｍ.＼\x00␊'ρＳ\\an）␇*\uff00λ\x115␃␆[＃\n４σψε+.~",
		out:  "ｍ.‛＼␀␊'ρＳ＼an）␇*\uff00λ\x115␃␆[＃\n４σψε+.~",
	}, { // 1627
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "ｍ.＼\x00␊'ρＳ\\an）␇*\uff00λ\x115␃␆[＃\n４σψε+.～",
		out:  "ｍ.‛＼␀␊'ρＳ＼an）␇*\uff00λ\x115␃␆[＃\n４σψε+.～",
	}, { // 1628
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.␚η#Ｑ\x0f␋*]%Ａ#\"␊ζ␊：p＃3\x16.θμ␛ｊζ.η",
		out:  "～.␚η#Ｑ\x0f␋*]%Ａ#\"‛␊ζ‛␊：p＃3\x16.θμ␛ｊζ.η",
	}, { // 1629
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.␚η#Ｑ\x0f␋*]%Ａ#\"␊ζ␊：p＃3\x16.θμ␛ｊζ.η",
		out:  "‛～.␚η#Ｑ\x0f␋*]%Ａ#\"‛␊ζ‛␊：p＃3\x16.θμ␛ｊζ.η",
	}, { // 1630
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\x19.␚η#Ｑ\x0f␋*]%Ａ#\"␊ζ␊：p＃3\x16.θμ␛ｊζ.~",
		out:  "\x19.␚η#Ｑ\x0f␋*]%Ａ#\"‛␊ζ‛␊：p＃3\x16.θμ␛ｊζ.~",
	}, { // 1631
		mask: EncodeCrLf | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "\x19.␚η#Ｑ\x0f␋*]%Ａ#\"␊ζ␊：p＃3\x16.θμ␛ｊζ.～",
		out:  "\x19.␚η#Ｑ\x0f␋*]%Ａ#\"‛␊ζ‛␊：p＃3\x16.θμ␛ｊζ.～",
	}, { // 1632
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.６０τσ ␎]+\x1c\nＡ:\a＊｀Ｄχ␒0η\x06RιOς，.\x15",
		out:  "～.６０τσ ␎]+\x1c\nＡ:\a＊｀Ｄχ␒0η\x06RιOς，.\x15",
	}, { // 1633
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.６０τσ ␎]+\x1c\nＡ:\a＊｀Ｄχ␒0η\x06RιOς，.\x15",
		out:  "‛～.６０τσ ␎]+\x1c\nＡ:\a＊｀Ｄχ␒0η\x06RιOς，.\x15",
	}, { // 1634
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "␐.６０τσ ␎]+\x1c\nＡ:\a＊｀Ｄχ␒0η\x06RιOς，.~",
		out:  "␐.６０τσ ␎]+\x1c\nＡ:\a＊｀Ｄχ␒0η\x06RιOς，.~",
	}, { // 1635
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "␐.６０τσ ␎]+\x1c\nＡ:\a＊｀Ｄχ␒0η\x06RιOς，.～",
		out:  "␐.６０τσ ␎]+\x1c\nＡ:\a＊｀Ｄχ␒0η\x06RιOς，.～",
	}, { // 1636
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "~.ε<O␕\x04θH＝\n'␍␍<␟τ\bT␔φ␌τξ}ＭJｚ.ｍ",
		out:  "～.ε<O‛␕␄θH＝␊'‛␍‛␍<‛␟τ␈T‛␔φ‛␌τξ}ＭJｚ.ｍ",
	}, { // 1637
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "～.ε<O␕\x04θH＝\n'␍␍<␟τ\bT␔φ␌τξ}ＭJｚ.ｍ",
		out:  "‛～.ε<O‛␕␄θH＝␊'‛␍‛␍<‛␟τ␈T‛␔φ‛␌τξ}ＭJｚ.ｍ",
	}, { // 1638
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "｛.ε<O␕\x04θH＝\n'␍␍<␟τ\bT␔φ␌τξ}ＭJｚ.~",
		out:  "｛.ε<O‛␕␄θH＝␊'‛␍‛␍<‛␟τ␈T‛␔φ‛␌τξ}ＭJｚ.~",
	}, { // 1639
		mask: EncodeCtl | EncodeLeftTilde | EncodeLeftPeriod,
		in:   "｛.ε<O␕\x04θH＝\n'␍␍<␟τ\bT␔φ␌τξ}ＭJｚ.～",
		out:  "｛.ε<O‛␕␄θH＝␊'‛␍‛␍<‛␟τ␈T‛␔φ‛␌τξ}ＭJｚ.～",
	}, { // 1640
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\t\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\tφ",
		out:  "～\t\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\tφ",
	}, { // 1641
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\t\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\tφ",
		out:  "‛～\t\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\tφ",
	}, { // 1642
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\n\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\nφ",
		out:  "～\n\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\nφ",
	}, { // 1643
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\n\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\nφ",
		out:  "‛～\n\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\nφ",
	}, { // 1644
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\v\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\vφ",
		out:  "～\v\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\vφ",
	}, { // 1645
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\v\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\vφ",
		out:  "‛～\v\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\vφ",
	}, { // 1646
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\r\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\rφ",
		out:  "～\r\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\rφ",
	}, { // 1647
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\r\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\rφ",
		out:  "‛～\r\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\rφ",
	}, { // 1648
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\t\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\t~",
		out:  "\\\t\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\t~",
	}, { // 1649
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\t\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\t～",
		out:  "\\\t\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\t～",
	}, { // 1650
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\n\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\n~",
		out:  "\\\n\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\n~",
	}, { // 1651
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\n\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\n～",
		out:  "\\\n\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\n～",
	}, { // 1652
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\v\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\v~",
		out:  "\\\v\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\v~",
	}, { // 1653
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\v\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\v～",
		out:  "\\\v\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\v～",
	}, { // 1654
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\r\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\r~",
		out:  "\\\r\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\r~",
	}, { // 1655
		mask: EncodeZero | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\r\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\r～",
		out:  "\\\r\x1bh\f\uff00\x02ｆζ␉＞ＴT␔ελχ␞Ｌ／\n\x13ＶS9␓Yκ\r～",
	}, { // 1656
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\tβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\tε",
		out:  "～\tβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\tε",
	}, { // 1657
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\tβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\tε",
		out:  "‛～\tβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\tε",
	}, { // 1658
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\nβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\nε",
		out:  "～\nβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\nε",
	}, { // 1659
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\nβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\nε",
		out:  "‛～\nβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\nε",
	}, { // 1660
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\vβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\vε",
		out:  "～\vβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\vε",
	}, { // 1661
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\vβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\vε",
		out:  "‛～\vβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\vε",
	}, { // 1662
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\rβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\rε",
		out:  "～\rβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\rε",
	}, { // 1663
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\rβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\rε",
		out:  "‛～\rβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\rε",
	}, { // 1664
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x06\tβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\t~",
		out:  "\x06\tβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\t~",
	}, { // 1665
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x06\tβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\t～",
		out:  "\x06\tβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\t～",
	}, { // 1666
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x06\nβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\n~",
		out:  "\x06\nβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\n~",
	}, { // 1667
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x06\nβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\n～",
		out:  "\x06\nβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\n～",
	}, { // 1668
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x06\vβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\v~",
		out:  "\x06\vβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\v~",
	}, { // 1669
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x06\vβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\v～",
		out:  "\x06\vβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\v～",
	}, { // 1670
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x06\rβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\r~",
		out:  "\x06\rβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\r~",
	}, { // 1671
		mask: EncodeSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x06\rβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\r～",
		out:  "\x06\rβz％ｉ\a\b＂＂ν␇1ρ\x0e6\x1fβ'␃K␔\x10'｀␑］␚\r～",
	}, { // 1672
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\t|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\t␟",
		out:  "～\t|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\t␟",
	}, { // 1673
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\t|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\t␟",
		out:  "‛～\t|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\t␟",
	}, { // 1674
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\n|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\n␟",
		out:  "～\n|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\n␟",
	}, { // 1675
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\n|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\n␟",
		out:  "‛～\n|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\n␟",
	}, { // 1676
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\v|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\v␟",
		out:  "～\v|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\v␟",
	}, { // 1677
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\v|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\v␟",
		out:  "‛～\v|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\v␟",
	}, { // 1678
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\r|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\r␟",
		out:  "～\r|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\r␟",
	}, { // 1679
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\r|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\r␟",
		out:  "‛～\r|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\r␟",
	}, { // 1680
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "$\t|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\t~",
		out:  "$\t|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\t~",
	}, { // 1681
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "$\t|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\t～",
		out:  "$\t|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\t～",
	}, { // 1682
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "$\n|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\n~",
		out:  "$\n|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\n~",
	}, { // 1683
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "$\n|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\n～",
		out:  "$\n|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\n～",
	}, { // 1684
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "$\v|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\v~",
		out:  "$\v|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\v~",
	}, { // 1685
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "$\v|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\v～",
		out:  "$\v|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\v～",
	}, { // 1686
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "$\r|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\r~",
		out:  "$\r|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\r~",
	}, { // 1687
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "$\r|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜'\x15σｆ|␞χες␝｝\r～",
		out:  "$\r|Ｙp␝ρ／\x1c)β\x1ff␊\x0e␊＜＇\x15σｆ|␞χες␝｝\r～",
	}, { // 1688
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\t％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\t␄",
		out:  "～\t％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\t␄",
	}, { // 1689
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\t％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\t␄",
		out:  "‛～\t％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\t␄",
	}, { // 1690
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\n％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\n␄",
		out:  "～\n％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\n␄",
	}, { // 1691
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\n％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\n␄",
		out:  "‛～\n％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\n␄",
	}, { // 1692
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\v％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\v␄",
		out:  "～\v％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\v␄",
	}, { // 1693
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\v％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\v␄",
		out:  "‛～\v％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\v␄",
	}, { // 1694
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\r％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\r␄",
		out:  "～\r％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\r␄",
	}, { // 1695
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\r％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\r␄",
		out:  "‛～\r％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\r␄",
	}, { // 1696
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\t％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\t~",
		out:  "\\\t％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\t~",
	}, { // 1697
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\t％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\t～",
		out:  "\\\t％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\t～",
	}, { // 1698
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\n％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\n~",
		out:  "\\\n％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\n~",
	}, { // 1699
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\n％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\n～",
		out:  "\\\n％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\n～",
	}, { // 1700
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\v％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\v~",
		out:  "\\\v％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\v~",
	}, { // 1701
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\v％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\v～",
		out:  "\\\v％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\v～",
	}, { // 1702
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\r％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\r~",
		out:  "\\\r％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\r~",
	}, { // 1703
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\\\r％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\r～",
		out:  "\\\r％7σ␂\x12．ω␒σ\x0fｅ␇ｚm＼α\x03Ｄtφ\x16zo␂ςｊ\r～",
	}, { // 1704
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\t\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\t\x1a",
		out:  "～\t\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\t\x1a",
	}, { // 1705
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\t\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\t\x1a",
		out:  "‛～\t\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\t\x1a",
	}, { // 1706
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\n\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\n\x1a",
		out:  "～\n\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\n\x1a",
	}, { // 1707
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\n\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\n\x1a",
		out:  "‛～\n\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\n\x1a",
	}, { // 1708
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\v\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\v\x1a",
		out:  "～\v\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\v\x1a",
	}, { // 1709
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\v\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\v\x1a",
		out:  "‛～\v\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\v\x1a",
	}, { // 1710
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\r\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\r\x1a",
		out:  "～\r\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\r\x1a",
	}, { // 1711
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\r\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\r\x1a",
		out:  "‛～\r\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\r\x1a",
	}, { // 1712
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "６\t\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\t~",
		out:  "６\t\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\t~",
	}, { // 1713
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "６\t\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\t～",
		out:  "６\t\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\t～",
	}, { // 1714
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "６\n\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\n~",
		out:  "６\n\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\n~",
	}, { // 1715
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "６\n\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\n～",
		out:  "６\n\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\n～",
	}, { // 1716
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "６\v\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\v~",
		out:  "６\v\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\v~",
	}, { // 1717
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "６\v\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\v～",
		out:  "６\v\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\v～",
	}, { // 1718
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "６\r\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\r~",
		out:  "６\r\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\r~",
	}, { // 1719
		mask: EncodeLtGt | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "６\r\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\r～",
		out:  "６\r\"，＼εｔ／ωυ\x1ay\x12\x1a␎~λ|τ␖ｊbｔ／｀\x11μ)\r～",
	}, { // 1720
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\tλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\tz",
		out:  "～\tλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\tz",
	}, { // 1721
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\tλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\tz",
		out:  "‛～\tλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\tz",
	}, { // 1722
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\nλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\nz",
		out:  "～\nλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\nz",
	}, { // 1723
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\nλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\nz",
		out:  "‛～\nλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\nz",
	}, { // 1724
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\vλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\vz",
		out:  "～\vλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\vz",
	}, { // 1725
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\vλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\vz",
		out:  "‛～\vλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\vz",
	}, { // 1726
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\rλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\rz",
		out:  "～\rλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\rz",
	}, { // 1727
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\rλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\rz",
		out:  "‛～\rλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\rz",
	}, { // 1728
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␍\tλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\t~",
		out:  "‛␍\tλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\t~",
	}, { // 1729
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␍\tλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\t～",
		out:  "‛␍\tλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\t～",
	}, { // 1730
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␍\nλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\n~",
		out:  "‛␍\nλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\n~",
	}, { // 1731
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␍\nλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\n～",
		out:  "‛␍\nλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\n～",
	}, { // 1732
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␍\vλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\v~",
		out:  "‛␍\vλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\v~",
	}, { // 1733
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␍\vλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\v～",
		out:  "‛␍\vλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\v～",
	}, { // 1734
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␍\rλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\r~",
		out:  "‛␍\rλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\r~",
	}, { // 1735
		mask: EncodeDollar | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␍\rλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\r～",
		out:  "‛␍\rλφ＜h␈pμ*ｏ␟\b`>6~！＇\x13Ｓ～θ\x01ι␚ａ）\r～",
	}, { // 1736
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\t@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\t␉",
		out:  "～\t@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\t␉",
	}, { // 1737
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\t@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\t␉",
		out:  "‛～\t@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\t␉",
	}, { // 1738
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\n@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\n␉",
		out:  "～\n@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\n␉",
	}, { // 1739
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\n@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\n␉",
		out:  "‛～\n@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\n␉",
	}, { // 1740
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\v@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\v␉",
		out:  "～\v@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\v␉",
	}, { // 1741
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\v@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\v␉",
		out:  "‛～\v@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\v␉",
	}, { // 1742
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\r@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\r␉",
		out:  "～\r@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\r␉",
	}, { // 1743
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\r@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\r␉",
		out:  "‛～\r@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\r␉",
	}, { // 1744
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "σ\t@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\t~",
		out:  "σ\t@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\t~",
	}, { // 1745
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "σ\t@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\t～",
		out:  "σ\t@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\t～",
	}, { // 1746
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "σ\n@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\n~",
		out:  "σ\n@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\n~",
	}, { // 1747
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "σ\n@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\n～",
		out:  "σ\n@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\n～",
	}, { // 1748
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "σ\v@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\v~",
		out:  "σ\v@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\v~",
	}, { // 1749
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "σ\v@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\v～",
		out:  "σ\v@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\v～",
	}, { // 1750
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "σ\r@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\r~",
		out:  "σ\r@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\r~",
	}, { // 1751
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "σ\r@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\r～",
		out:  "σ\r@\tψ␛χｈχ.Ｚ^／Y`＄l␍$\x15ＨＸ［σＶ\tε␑\r～",
	}, { // 1752
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\t9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\t４",
		out:  "～\t9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\t４",
	}, { // 1753
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\t9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\t４",
		out:  "‛～\t9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\t４",
	}, { // 1754
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\n9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\n４",
		out:  "～\n9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\n４",
	}, { // 1755
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\n9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\n４",
		out:  "‛～\n9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\n４",
	}, { // 1756
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\v9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\v４",
		out:  "～\v9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\v４",
	}, { // 1757
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\v9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\v４",
		out:  "‛～\v9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\v４",
	}, { // 1758
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\r9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\r４",
		out:  "～\r9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\r４",
	}, { // 1759
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\r9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\r４",
		out:  "‛～\r9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\r４",
	}, { // 1760
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␎\t9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\t~",
		out:  "␎\t9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\t~",
	}, { // 1761
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␎\t9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\t～",
		out:  "␎\t9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\t～",
	}, { // 1762
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␎\n9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\n~",
		out:  "␎\n9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\n~",
	}, { // 1763
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␎\n9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\n～",
		out:  "␎\n9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\n～",
	}, { // 1764
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␎\v9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\v~",
		out:  "␎\v9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\v~",
	}, { // 1765
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␎\v9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\v～",
		out:  "␎\v9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\v～",
	}, { // 1766
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␎\r9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\r~",
		out:  "␎\r9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\r~",
	}, { // 1767
		mask: EncodeColon | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "␎\r9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\r～",
		out:  "␎\r9\x03q␙\x11β(φβ␍ω␊␛\x13ο\fｃ>m２5ｗ\x06␁ｅ;\r～",
	}, { // 1768
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\t\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\th",
		out:  "～\t\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\th",
	}, { // 1769
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\t\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\th",
		out:  "‛～\t\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\th",
	}, { // 1770
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\n\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\nh",
		out:  "～\n\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\nh",
	}, { // 1771
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\n\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\nh",
		out:  "‛～\n\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\nh",
	}, { // 1772
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\v\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\vh",
		out:  "～\v\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\vh",
	}, { // 1773
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\v\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\vh",
		out:  "‛～\v\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\vh",
	}, { // 1774
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\r\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\rh",
		out:  "～\r\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\rh",
	}, { // 1775
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\r\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\rh",
		out:  "‛～\r\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\rh",
	}, { // 1776
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "ｚ\t\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\t~",
		out:  "ｚ\t\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\t~",
	}, { // 1777
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "ｚ\t\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\t～",
		out:  "ｚ\t\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\t～",
	}, { // 1778
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "ｚ\n\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\n~",
		out:  "ｚ\n\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\n~",
	}, { // 1779
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "ｚ\n\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\n～",
		out:  "ｚ\n\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\n～",
	}, { // 1780
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "ｚ\v\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\v~",
		out:  "ｚ\v\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\v~",
	}, { // 1781
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "ｚ\v\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\v～",
		out:  "ｚ\v\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\v～",
	}, { // 1782
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "ｚ\r\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\r~",
		out:  "ｚ\r\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\r~",
	}, { // 1783
		mask: EncodeQuestion | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "ｚ\r\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\r～",
		out:  "ｚ\r\x15$\x17ｑ！χsδ\t＊α0␘␍␙ｐκ０|ρη`n｛\b␄\r～",
	}, { // 1784
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\tξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\t␊",
		out:  "～\tξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\t␊",
	}, { // 1785
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\tξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\t␊",
		out:  "‛～\tξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\t␊",
	}, { // 1786
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\nξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\n␊",
		out:  "～\nξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\n␊",
	}, { // 1787
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\nξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\n␊",
		out:  "‛～\nξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\n␊",
	}, { // 1788
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\vξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\v␊",
		out:  "～\vξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\v␊",
	}, { // 1789
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\vξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\v␊",
		out:  "‛～\vξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\v␊",
	}, { // 1790
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\rξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\r␊",
		out:  "～\rξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\r␊",
	}, { // 1791
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\rξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\r␊",
		out:  "‛～\rξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\r␊",
	}, { // 1792
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "*\tξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\t~",
		out:  "＊\tξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\t~",
	}, { // 1793
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "*\tξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\t～",
		out:  "＊\tξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\t～",
	}, { // 1794
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "*\nξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\n~",
		out:  "＊\nξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\n~",
	}, { // 1795
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "*\nξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\n～",
		out:  "＊\nξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\n～",
	}, { // 1796
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "*\vξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\v~",
		out:  "＊\vξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\v~",
	}, { // 1797
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "*\vξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\v～",
		out:  "＊\vξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\v～",
	}, { // 1798
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "*\rξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\r~",
		out:  "＊\rξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\r~",
	}, { // 1799
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "*\rξb１ｚ\x1e/␏＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\r～",
		out:  "＊\rξb１ｚ\x1e/␏‛＊'␇@ｌr␆Ｓ;s＼\fτκγ%Ｆμ1\r～",
	}, { // 1800
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\t9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\tβ",
		out:  "～\t9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\tβ",
	}, { // 1801
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\t9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\tβ",
		out:  "‛～\t9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\tβ",
	}, { // 1802
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\n9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\nβ",
		out:  "～\n9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\nβ",
	}, { // 1803
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\n9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\nβ",
		out:  "‛～\n9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\nβ",
	}, { // 1804
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\v9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\vβ",
		out:  "～\v9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\vβ",
	}, { // 1805
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\v9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\vβ",
		out:  "‛～\v9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\vβ",
	}, { // 1806
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\r9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\rβ",
		out:  "～\r9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\rβ",
	}, { // 1807
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\r9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\rβ",
		out:  "‛～\r9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\rβ",
	}, { // 1808
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "β\t9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\t~",
		out:  "β\t9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\t~",
	}, { // 1809
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "β\t9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\t～",
		out:  "β\t9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\t～",
	}, { // 1810
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "β\n9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\n~",
		out:  "β\n9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\n~",
	}, { // 1811
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "β\n9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\n～",
		out:  "β\n9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\n～",
	}, { // 1812
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "β\v9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\v~",
		out:  "β\v9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\v~",
	}, { // 1813
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "β\v9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\v～",
		out:  "β\v9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\v～",
	}, { // 1814
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "β\r9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\r~",
		out:  "β\r9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\r~",
	}, { // 1815
		mask: EncodePipe | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "β\r9ε/Ｇ|\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\r～",
		out:  "β\r9ε/Ｇ｜\"\t＜␗μ＊eｒ．ｏ ␞^␛VＲη:y␈'\r～",
	}, { // 1816
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\t／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\t＆",
		out:  "～\t／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\t＆",
	}, { // 1817
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\t／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\t＆",
		out:  "‛～\t／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\t＆",
	}, { // 1818
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\n／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\n＆",
		out:  "～\n／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\n＆",
	}, { // 1819
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\n／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\n＆",
		out:  "‛～\n／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\n＆",
	}, { // 1820
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\v／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\v＆",
		out:  "～\v／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\v＆",
	}, { // 1821
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\v／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\v＆",
		out:  "‛～\v／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\v＆",
	}, { // 1822
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\r／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\r＆",
		out:  "～\r／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\r＆",
	}, { // 1823
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\r／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\r＆",
		out:  "‛～\r／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\r＆",
	}, { // 1824
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x1c\t／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\t~",
		out:  "\x1c\t／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\t~",
	}, { // 1825
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x1c\t／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\t～",
		out:  "\x1c\t／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\t～",
	}, { // 1826
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x1c\n／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\n~",
		out:  "\x1c\n／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\n~",
	}, { // 1827
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x1c\n／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\n～",
		out:  "\x1c\n／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\n～",
	}, { // 1828
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x1c\v／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\v~",
		out:  "\x1c\v／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\v~",
	}, { // 1829
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x1c\v／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\v～",
		out:  "\x1c\v／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\v～",
	}, { // 1830
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x1c\r／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\r~",
		out:  "\x1c\r／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\r~",
	}, { // 1831
		mask: EncodeHash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x1c\r／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\r～",
		out:  "\x1c\r／σ\\\"ψｈ\x02␕\v6Iςｓｙａ＜：␁λ\u007f1２εθA\"\r～",
	}, { // 1832
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\t␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\tO",
		out:  "～\t␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\tO",
	}, { // 1833
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\t␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\tO",
		out:  "‛～\t␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\tO",
	}, { // 1834
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\n␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\nO",
		out:  "～\n␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\nO",
	}, { // 1835
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\n␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\nO",
		out:  "‛～\n␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\nO",
	}, { // 1836
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\v␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\vO",
		out:  "～\v␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\vO",
	}, { // 1837
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\v␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\vO",
		out:  "‛～\v␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\vO",
	}, { // 1838
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\r␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\rO",
		out:  "～\r␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\rO",
	}, { // 1839
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\r␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\rO",
		out:  "‛～\r␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\rO",
	}, { // 1840
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "｜\t␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\t~",
		out:  "｜\t␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\t~",
	}, { // 1841
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "｜\t␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\t～",
		out:  "｜\t␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\t～",
	}, { // 1842
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "｜\n␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\n~",
		out:  "｜\n␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\n~",
	}, { // 1843
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "｜\n␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\n～",
		out:  "｜\n␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\n～",
	}, { // 1844
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "｜\v␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\v~",
		out:  "｜\v␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\v~",
	}, { // 1845
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "｜\v␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\v～",
		out:  "｜\v␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\v～",
	}, { // 1846
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "｜\r␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\r~",
		out:  "｜\r␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\r~",
	}, { // 1847
		mask: EncodePercent | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "｜\r␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\r～",
		out:  "｜\r␈θ<|ωκｚ\b=8␁␖=wπωｋ$ＩＱ｀＇g\bω\x12\r～",
	}, { // 1848
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\t %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\t＂",
		out:  "～\t %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\t＂",
	}, { // 1849
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\t %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\t＂",
		out:  "‛～\t %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\t＂",
	}, { // 1850
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\n %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\n＂",
		out:  "～\n %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\n＂",
	}, { // 1851
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\n %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\n＂",
		out:  "‛～\n %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\n＂",
	}, { // 1852
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\v %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\v＂",
		out:  "～\v %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\v＂",
	}, { // 1853
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\v %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\v＂",
		out:  "‛～\v %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\v＂",
	}, { // 1854
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\r %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\r＂",
		out:  "～\r %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\r＂",
	}, { // 1855
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\r %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\r＂",
		out:  "‛～\r %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\r＂",
	}, { // 1856
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "h\t %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\t~",
		out:  "h\t %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\t~",
	}, { // 1857
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "h\t %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\t～",
		out:  "h\t %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\t～",
	}, { // 1858
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "h\n %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\n~",
		out:  "h\n %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\n~",
	}, { // 1859
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "h\n %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\n～",
		out:  "h\n %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\n～",
	}, { // 1860
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "h\v %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\v~",
		out:  "h\v %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\v~",
	}, { // 1861
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "h\v %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\v～",
		out:  "h\v %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\v～",
	}, { // 1862
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "h\r %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\r~",
		out:  "h\r %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\r~",
	}, { // 1863
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "h\r %１@Ｅ\x11`␘␖６␕\x00␊αjερο␌４\"\f\uff00#ψμ\r～",
		out:  "h\r %１@Ｅ\x11`␘␖６␕␀␊αjερο␌４\"\f\uff00#ψμ\r～",
	}, { // 1864
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\tＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\tj",
		out:  "～\tＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\tj",
	}, { // 1865
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\tＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\tj",
		out:  "‛～\tＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\tj",
	}, { // 1866
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\nＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\nj",
		out:  "～\nＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\nj",
	}, { // 1867
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\nＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\nj",
		out:  "‛～\nＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\nj",
	}, { // 1868
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\vＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\vj",
		out:  "～\vＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\vj",
	}, { // 1869
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\vＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\vj",
		out:  "‛～\vＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\vj",
	}, { // 1870
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "~\rＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\rj",
		out:  "～\rＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\rj",
	}, { // 1871
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "～\rＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\rj",
		out:  "‛～\rＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\rj",
	}, { // 1872
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x02\tＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\t~",
		out:  "\x02\tＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\t~",
	}, { // 1873
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x02\tＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\t～",
		out:  "\x02\tＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\t～",
	}, { // 1874
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x02\nＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\n~",
		out:  "\x02\nＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\n~",
	}, { // 1875
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x02\nＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\n～",
		out:  "\x02\nＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\n～",
	}, { // 1876
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x02\vＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\v~",
		out:  "\x02\vＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\v~",
	}, { // 1877
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x02\vＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\v～",
		out:  "\x02\vＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\v～",
	}, { // 1878
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x02\rＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\r~",
		out:  "\x02\rＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\r~",
	}, { // 1879
		mask: EncodeDel | EncodeLeftTilde | EncodeLeftCrLfHtVt,
		in:   "\x02\rＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<\u007f5'ρ\r｀＊␒\r\r～",
		out:  "\x02\rＴχｑ␖＝Ｃχhτm␒ｅ\x16％ηθ<␡5'ρ\r｀＊␒\r\r～",
	}, { // 1880
		mask: EncodeZero | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ ＳＴ9εB8␗Ｇ\x05␟\x11?i␜τλ␛\nｏ\x19n\x0e＼ζ\x13β ␘",
		out:  "～ ＳＴ9εB8␗Ｇ\x05␟\x11?i␜τλ␛\nｏ\x19n\x0e＼ζ\x13β ␘",
	}, { // 1881
		mask: EncodeZero | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ ＳＴ9εB8␗Ｇ\x05␟\x11?i␜τλ␛\nｏ\x19n\x0e＼ζ\x13β ␘",
		out:  "‛～ ＳＴ9εB8␗Ｇ\x05␟\x11?i␜τλ␛\nｏ\x19n\x0e＼ζ\x13β ␘",
	}, { // 1882
		mask: EncodeZero | EncodeLeftTilde | EncodeRightSpace,
		in:   "ｕ ＳＴ9εB8␗Ｇ\x05␟\x11?i␜τλ␛\nｏ\x19n\x0e＼ζ\x13β ~",
		out:  "ｕ ＳＴ9εB8␗Ｇ\x05␟\x11?i␜τλ␛\nｏ\x19n\x0e＼ζ\x13β ~",
	}, { // 1883
		mask: EncodeZero | EncodeLeftTilde | EncodeRightSpace,
		in:   "ｕ ＳＴ9εB8␗Ｇ\x05␟\x11?i␜τλ␛\nｏ\x19n\x0e＼ζ\x13β ～",
		out:  "ｕ ＳＴ9εB8␗Ｇ\x05␟\x11?i␜τλ␛\nｏ\x19n\x0e＼ζ\x13β ～",
	}, { // 1884
		mask: EncodeSlash | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ ｃκ｜＇\x0fθa␡\x01q｜０Ｅg|\x0f９μＦχ\x12\x13␁␍ζS T",
		out:  "～ ｃκ｜＇\x0fθa␡\x01q｜０Ｅg|\x0f９μＦχ\x12\x13␁␍ζS T",
	}, { // 1885
		mask: EncodeSlash | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ ｃκ｜＇\x0fθa␡\x01q｜０Ｅg|\x0f９μＦχ\x12\x13␁␍ζS T",
		out:  "‛～ ｃκ｜＇\x0fθa␡\x01q｜０Ｅg|\x0f９μＦχ\x12\x13␁␍ζS T",
	}, { // 1886
		mask: EncodeSlash | EncodeLeftTilde | EncodeRightSpace,
		in:   "␞ ｃκ｜＇\x0fθa␡\x01q｜０Ｅg|\x0f９μＦχ\x12\x13␁␍ζS ~",
		out:  "␞ ｃκ｜＇\x0fθa␡\x01q｜０Ｅg|\x0f９μＦχ\x12\x13␁␍ζS ~",
	}, { // 1887
		mask: EncodeSlash | EncodeLeftTilde | EncodeRightSpace,
		in:   "␞ ｃκ｜＇\x0fθa␡\x01q｜０Ｅg|\x0f９μＦχ\x12\x13␁␍ζS ～",
		out:  "␞ ｃκ｜＇\x0fθa␡\x01q｜０Ｅg|\x0f９μＦχ\x12\x13␁␍ζS ～",
	}, { // 1888
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ νλＯe＃\x15\x1cｕς␘|O＞\x1fο［␐\x04μ４^<＜｀␅Ｉ '",
		out:  "～ νλＯe＃\x15\x1cｕς␘|O＞\x1fο［␐\x04μ４^<＜｀␅Ｉ ＇",
	}, { // 1889
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ νλＯe＃\x15\x1cｕς␘|O＞\x1fο［␐\x04μ４^<＜｀␅Ｉ '",
		out:  "‛～ νλＯe＃\x15\x1cｕς␘|O＞\x1fο［␐\x04μ４^<＜｀␅Ｉ ＇",
	}, { // 1890
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeRightSpace,
		in:   "D νλＯe＃\x15\x1cｕς␘|O＞\x1fο［␐\x04μ４^<＜｀␅Ｉ ~",
		out:  "D νλＯe＃\x15\x1cｕς␘|O＞\x1fο［␐\x04μ４^<＜｀␅Ｉ ~",
	}, { // 1891
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeRightSpace,
		in:   "D νλＯe＃\x15\x1cｕς␘|O＞\x1fο［␐\x04μ４^<＜｀␅Ｉ ～",
		out:  "D νλＯe＃\x15\x1cｕς␘|O＞\x1fο［␐\x04μ４^<＜｀␅Ｉ ～",
	}, { // 1892
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ \x15＇＞＼}\x05＊␎6Ｅ␍Ｇ／Wη␙ςπrｗ\x13%\x01υ\x10κ ε",
		out:  "～ \x15＇＞＼}\x05＊␎6Ｅ␍Ｇ／Wη␙ςπrｗ\x13%\x01υ\x10κ ε",
	}, { // 1893
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ \x15＇＞＼}\x05＊␎6Ｅ␍Ｇ／Wη␙ςπrｗ\x13%\x01υ\x10κ ε",
		out:  "‛～ \x15＇＞＼}\x05＊␎6Ｅ␍Ｇ／Wη␙ςπrｗ\x13%\x01υ\x10κ ε",
	}, { // 1894
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeRightSpace,
		in:   "! \x15＇＞＼}\x05＊␎6Ｅ␍Ｇ／Wη␙ςπrｗ\x13%\x01υ\x10κ ~",
		out:  "! \x15＇＞＼}\x05＊␎6Ｅ␍Ｇ／Wη␙ςπrｗ\x13%\x01υ\x10κ ~",
	}, { // 1895
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeRightSpace,
		in:   "! \x15＇＞＼}\x05＊␎6Ｅ␍Ｇ／Wη␙ςπrｗ\x13%\x01υ\x10κ ～",
		out:  "! \x15＇＞＼}\x05＊␎6Ｅ␍Ｇ／Wη␙ςπrｗ\x13%\x01υ\x10κ ～",
	}, { // 1896
		mask: EncodeLtGt | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ C`！\fν␑ｄs␗Ｏ)␕｀/Ｈ\b＠^␡κωτ*␍d< ｜",
		out:  "～ C`！\fν␑ｄs␗Ｏ)␕｀/Ｈ\b＠^␡κωτ*␍d＜ ｜",
	}, { // 1897
		mask: EncodeLtGt | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ C`！\fν␑ｄs␗Ｏ)␕｀/Ｈ\b＠^␡κωτ*␍d< ｜",
		out:  "‛～ C`！\fν␑ｄs␗Ｏ)␕｀/Ｈ\b＠^␡κωτ*␍d＜ ｜",
	}, { // 1898
		mask: EncodeLtGt | EncodeLeftTilde | EncodeRightSpace,
		in:   "ζ C`！\fν␑ｄs␗Ｏ)␕｀/Ｈ\b＠^␡κωτ*␍d< ~",
		out:  "ζ C`！\fν␑ｄs␗Ｏ)␕｀/Ｈ\b＠^␡κωτ*␍d＜ ~",
	}, { // 1899
		mask: EncodeLtGt | EncodeLeftTilde | EncodeRightSpace,
		in:   "ζ C`！\fν␑ｄs␗Ｏ)␕｀/Ｈ\b＠^␡κωτ*␍d< ～",
		out:  "ζ C`！\fν␑ｄs␗Ｏ)␕｀/Ｈ\b＠^␡κωτ*␍d＜ ～",
	}, { // 1900
		mask: EncodeDollar | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ ＂Kτ>#␃␘NπεＲ?νν␌ｘL\x06Ｓφ(：Jｎ\v\x05 A",
		out:  "～ ＂Kτ>#␃␘NπεＲ?νν␌ｘL\x06Ｓφ(：Jｎ\v\x05 A",
	}, { // 1901
		mask: EncodeDollar | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ ＂Kτ>#␃␘NπεＲ?νν␌ｘL\x06Ｓφ(：Jｎ\v\x05 A",
		out:  "‛～ ＂Kτ>#␃␘NπεＲ?νν␌ｘL\x06Ｓφ(：Jｎ\v\x05 A",
	}, { // 1902
		mask: EncodeDollar | EncodeLeftTilde | EncodeRightSpace,
		in:   "Ｇ ＂Kτ>#␃␘NπεＲ?νν␌ｘL\x06Ｓφ(：Jｎ\v\x05 ~",
		out:  "Ｇ ＂Kτ>#␃␘NπεＲ?νν␌ｘL\x06Ｓφ(：Jｎ\v\x05 ~",
	}, { // 1903
		mask: EncodeDollar | EncodeLeftTilde | EncodeRightSpace,
		in:   "Ｇ ＂Kτ>#␃␘NπεＲ?νν␌ｘL\x06Ｓφ(：Jｎ\v\x05 ～",
		out:  "Ｇ ＂Kτ>#␃␘NπεＲ?νν␌ｘL\x06Ｓφ(：Jｎ\v\x05 ～",
	}, { // 1904
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ υ０ ｜\x02␐ψω)\t4ｌ␟V\x00π␘οL$␌τｃ\x14␞\r Ｃ",
		out:  "～ υ０ ｜\x02␐ψω)\t4ｌ␟V␀π␘οL$␌τｃ\x14␞\r Ｃ",
	}, { // 1905
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ υ０ ｜\x02␐ψω)\t4ｌ␟V\x00π␘οL$␌τｃ\x14␞\r Ｃ",
		out:  "‛～ υ０ ｜\x02␐ψω)\t4ｌ␟V␀π␘οL$␌τｃ\x14␞\r Ｃ",
	}, { // 1906
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeRightSpace,
		in:   "L υ０ ｜\x02␐ψω)\t4ｌ␟V\x00π␘οL$␌τｃ\x14␞\r ~",
		out:  "L υ０ ｜\x02␐ψω)\t4ｌ␟V␀π␘οL$␌τｃ\x14␞\r ~",
	}, { // 1907
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeRightSpace,
		in:   "L υ０ ｜\x02␐ψω)\t4ｌ␟V\x00π␘οL$␌τｃ\x14␞\r ～",
		out:  "L υ０ ｜\x02␐ψω)\t4ｌ␟V␀π␘οL$␌τｃ\x14␞\r ～",
	}, { // 1908
		mask: EncodeColon | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ Ｏt\x0e␓rＦＨmκ␕\x1a－ＬＤκφ\x1cγ␕␀＇P\x12\ta␇ φ",
		out:  "～ Ｏt\x0e␓rＦＨmκ␕\x1a－ＬＤκφ\x1cγ␕‛␀＇P\x12\ta␇ φ",
	}, { // 1909
		mask: EncodeColon | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ Ｏt\x0e␓rＦＨmκ␕\x1a－ＬＤκφ\x1cγ␕␀＇P\x12\ta␇ φ",
		out:  "‛～ Ｏt\x0e␓rＦＨmκ␕\x1a－ＬＤκφ\x1cγ␕‛␀＇P\x12\ta␇ φ",
	}, { // 1910
		mask: EncodeColon | EncodeLeftTilde | EncodeRightSpace,
		in:   "φ Ｏt\x0e␓rＦＨmκ␕\x1a－ＬＤκφ\x1cγ␕␀＇P\x12\ta␇ ~",
		out:  "φ Ｏt\x0e␓rＦＨmκ␕\x1a－ＬＤκφ\x1cγ␕‛␀＇P\x12\ta␇ ~",
	}, { // 1911
		mask: EncodeColon | EncodeLeftTilde | EncodeRightSpace,
		in:   "φ Ｏt\x0e␓rＦＨmκ␕\x1a－ＬＤκφ\x1cγ␕␀＇P\x12\ta␇ ～",
		out:  "φ Ｏt\x0e␓rＦＨmκ␕\x1a－ＬＤκφ\x1cγ␕‛␀＇P\x12\ta␇ ～",
	}, { // 1912
		mask: EncodeQuestion | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ λ／）8ρ；␝?`ξ\x15z}\x03θ\r］θ2ω␁␊ＺＷ＊  ｀",
		out:  "～ λ／）8ρ；␝？`ξ\x15z}\x03θ\r］θ2ω␁␊ＺＷ＊  ｀",
	}, { // 1913
		mask: EncodeQuestion | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ λ／）8ρ；␝?`ξ\x15z}\x03θ\r］θ2ω␁␊ＺＷ＊  ｀",
		out:  "‛～ λ／）8ρ；␝？`ξ\x15z}\x03θ\r］θ2ω␁␊ＺＷ＊  ｀",
	}, { // 1914
		mask: EncodeQuestion | EncodeLeftTilde | EncodeRightSpace,
		in:   "\a λ／）8ρ；␝?`ξ\x15z}\x03θ\r］θ2ω␁␊ＺＷ＊  ~",
		out:  "\a λ／）8ρ；␝？`ξ\x15z}\x03θ\r］θ2ω␁␊ＺＷ＊  ~",
	}, { // 1915
		mask: EncodeQuestion | EncodeLeftTilde | EncodeRightSpace,
		in:   "\a λ／）8ρ；␝?`ξ\x15z}\x03θ\r］θ2ω␁␊ＺＷ＊  ～",
		out:  "\a λ／）8ρ；␝？`ξ\x15z}\x03θ\r］θ2ω␁␊ＺＷ＊  ～",
	}, { // 1916
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ ｓ＄\ru\x02πχｉ␔π)λ＂χc＿␋\\｜>\x04ｖ0|&␚ ␎",
		out:  "～ ｓ＄\ru\x02πχｉ␔π)λ＂χc＿␋\\｜>\x04ｖ0|&␚ ␎",
	}, { // 1917
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ ｓ＄\ru\x02πχｉ␔π)λ＂χc＿␋\\｜>\x04ｖ0|&␚ ␎",
		out:  "‛～ ｓ＄\ru\x02πχｉ␔π)λ＂χc＿␋\\｜>\x04ｖ0|&␚ ␎",
	}, { // 1918
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeRightSpace,
		in:   "χ ｓ＄\ru\x02πχｉ␔π)λ＂χc＿␋\\｜>\x04ｖ0|&␚ ~",
		out:  "χ ｓ＄\ru\x02πχｉ␔π)λ＂χc＿␋\\｜>\x04ｖ0|&␚ ~",
	}, { // 1919
		mask: EncodeAsterisk | EncodeLeftTilde | EncodeRightSpace,
		in:   "χ ｓ＄\ru\x02πχｉ␔π)λ＂χc＿␋\\｜>\x04ｖ0|&␚ ～",
		out:  "χ ｓ＄\ru\x02πχｉ␔π)λ＂χc＿␋\\｜>\x04ｖ0|&␚ ～",
	}, { // 1920
		mask: EncodePipe | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ ε\x03\"$ｊ␜m␐Ａθ/\x00％ω\x11Ｎ␕ι：\x19φX＂␟C＋ ␛",
		out:  "～ ε\x03\"$ｊ␜m␐Ａθ/␀％ω\x11Ｎ␕ι：\x19φX＂␟C＋ ␛",
	}, { // 1921
		mask: EncodePipe | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ ε\x03\"$ｊ␜m␐Ａθ/\x00％ω\x11Ｎ␕ι：\x19φX＂␟C＋ ␛",
		out:  "‛～ ε\x03\"$ｊ␜m␐Ａθ/␀％ω\x11Ｎ␕ι：\x19φX＂␟C＋ ␛",
	}, { // 1922
		mask: EncodePipe | EncodeLeftTilde | EncodeRightSpace,
		in:   "χ ε\x03\"$ｊ␜m␐Ａθ/\x00％ω\x11Ｎ␕ι：\x19φX＂␟C＋ ~",
		out:  "χ ε\x03\"$ｊ␜m␐Ａθ/␀％ω\x11Ｎ␕ι：\x19φX＂␟C＋ ~",
	}, { // 1923
		mask: EncodePipe | EncodeLeftTilde | EncodeRightSpace,
		in:   "χ ε\x03\"$ｊ␜m␐Ａθ/\x00％ω\x11Ｎ␕ι：\x19φX＂␟C＋ ～",
		out:  "χ ε\x03\"$ｊ␜m␐Ａθ/␀％ω\x11Ｎ␕ι：\x19φX＂␟C＋ ～",
	}, { // 1924
		mask: EncodeHash | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ \x0ff＂σ\x1c＃\x10！␈χγ\v␓Hς␕␒␆Ｑ）\"G\x065）． v",
		out:  "～ \x0ff＂σ\x1c‛＃\x10！␈χγ\v␓Hς␕␒␆Ｑ）\"G\x065）． v",
	}, { // 1925
		mask: EncodeHash | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ \x0ff＂σ\x1c＃\x10！␈χγ\v␓Hς␕␒␆Ｑ）\"G\x065）． v",
		out:  "‛～ \x0ff＂σ\x1c‛＃\x10！␈χγ\v␓Hς␕␒␆Ｑ）\"G\x065）． v",
	}, { // 1926
		mask: EncodeHash | EncodeLeftTilde | EncodeRightSpace,
		in:   "% \x0ff＂σ\x1c＃\x10！␈χγ\v␓Hς␕␒␆Ｑ）\"G\x065）． ~",
		out:  "% \x0ff＂σ\x1c‛＃\x10！␈χγ\v␓Hς␕␒␆Ｑ）\"G\x065）． ~",
	}, { // 1927
		mask: EncodeHash | EncodeLeftTilde | EncodeRightSpace,
		in:   "% \x0ff＂σ\x1c＃\x10！␈χγ\v␓Hς␕␒␆Ｑ）\"G\x065）． ～",
		out:  "% \x0ff＂σ\x1c‛＃\x10！␈χγ\v␓Hς␕␒␆Ｑ）\"G\x065）． ～",
	}, { // 1928
		mask: EncodePercent | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ μ␊?Ｉ'oQ\n␛θ\x1a␊Ｘεθ#f9ｈ＜＂\uff00ψ/4\x00 ＃",
		out:  "～ μ␊?Ｉ'oQ\n␛θ\x1a␊Ｘεθ#f9ｈ＜＂\uff00ψ/4␀ ＃",
	}, { // 1929
		mask: EncodePercent | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ μ␊?Ｉ'oQ\n␛θ\x1a␊Ｘεθ#f9ｈ＜＂\uff00ψ/4\x00 ＃",
		out:  "‛～ μ␊?Ｉ'oQ\n␛θ\x1a␊Ｘεθ#f9ｈ＜＂\uff00ψ/4␀ ＃",
	}, { // 1930
		mask: EncodePercent | EncodeLeftTilde | EncodeRightSpace,
		in:   "Ｂ μ␊?Ｉ'oQ\n␛θ\x1a␊Ｘεθ#f9ｈ＜＂\uff00ψ/4\x00 ~",
		out:  "Ｂ μ␊?Ｉ'oQ\n␛θ\x1a␊Ｘεθ#f9ｈ＜＂\uff00ψ/4␀ ~",
	}, { // 1931
		mask: EncodePercent | EncodeLeftTilde | EncodeRightSpace,
		in:   "Ｂ μ␊?Ｉ'oQ\n␛θ\x1a␊Ｘεθ#f9ｈ＜＂\uff00ψ/4\x00 ～",
		out:  "Ｂ μ␊?Ｉ'oQ\n␛θ\x1a␊Ｘεθ#f9ｈ＜＂\uff00ψ/4␀ ～",
	}, { // 1932
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ X]␒Ｊ7０␏：L%π\x15␊ｍｊB`ν␍＞rζｃ９|θ γ",
		out:  "～ X]␒Ｊ7０␏：L%π\x15␊ｍｊB`ν␍＞rζｃ９|θ γ",
	}, { // 1933
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ X]␒Ｊ7０␏：L%π\x15␊ｍｊB`ν␍＞rζｃ９|θ γ",
		out:  "‛～ X]␒Ｊ7０␏：L%π\x15␊ｍｊB`ν␍＞rζｃ９|θ γ",
	}, { // 1934
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeRightSpace,
		in:   "\r X]␒Ｊ7０␏：L%π\x15␊ｍｊB`ν␍＞rζｃ９|θ ~",
		out:  "\r X]␒Ｊ7０␏：L%π\x15␊ｍｊB`ν␍＞rζｃ９|θ ~",
	}, { // 1935
		mask: EncodeBackSlash | EncodeLeftTilde | EncodeRightSpace,
		in:   "\r X]␒Ｊ7０␏：L%π\x15␊ｍｊB`ν␍＞rζｃ９|θ ～",
		out:  "\r X]␒Ｊ7０␏：L%π\x15␊ｍｊB`ν␍＞rζｃ９|θ ～",
	}, { // 1936
		mask: EncodeCrLf | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ ρ␞ω｜␐J＜$ｄgｋ␖ＮoειC:θ\x11＼<<μS\\ E",
		out:  "～ ρ␞ω｜␐J＜$ｄgｋ␖ＮoειC:θ\x11＼<<μS\\ E",
	}, { // 1937
		mask: EncodeCrLf | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ ρ␞ω｜␐J＜$ｄgｋ␖ＮoειC:θ\x11＼<<μS\\ E",
		out:  "‛～ ρ␞ω｜␐J＜$ｄgｋ␖ＮoειC:θ\x11＼<<μS\\ E",
	}, { // 1938
		mask: EncodeCrLf | EncodeLeftTilde | EncodeRightSpace,
		in:   "＿ ρ␞ω｜␐J＜$ｄgｋ␖ＮoειC:θ\x11＼<<μS\\ ~",
		out:  "＿ ρ␞ω｜␐J＜$ｄgｋ␖ＮoειC:θ\x11＼<<μS\\ ~",
	}, { // 1939
		mask: EncodeCrLf | EncodeLeftTilde | EncodeRightSpace,
		in:   "＿ ρ␞ω｜␐J＜$ｄgｋ␖ＮoειC:θ\x11＼<<μS\\ ～",
		out:  "＿ ρ␞ω｜␐J＜$ｄgｋ␖ＮoειC:θ\x11＼<<μS\\ ～",
	}, { // 1940
		mask: EncodeDel | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ >＂ｒαθ\x11θ'?#＄\x14＼}ρ\u007f$２>ｊ␒α␍3＄： ␓",
		out:  "～ >＂ｒαθ\x11θ'?#＄\x14＼}ρ␡$２>ｊ␒α␍3＄： ␓",
	}, { // 1941
		mask: EncodeDel | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ >＂ｒαθ\x11θ'?#＄\x14＼}ρ\u007f$２>ｊ␒α␍3＄： ␓",
		out:  "‛～ >＂ｒαθ\x11θ'?#＄\x14＼}ρ␡$２>ｊ␒α␍3＄： ␓",
	}, { // 1942
		mask: EncodeDel | EncodeLeftTilde | EncodeRightSpace,
		in:   "L >＂ｒαθ\x11θ'?#＄\x14＼}ρ\u007f$２>ｊ␒α␍3＄： ~",
		out:  "L >＂ｒαθ\x11θ'?#＄\x14＼}ρ␡$２>ｊ␒α␍3＄： ~",
	}, { // 1943
		mask: EncodeDel | EncodeLeftTilde | EncodeRightSpace,
		in:   "L >＂ｒαθ\x11θ'?#＄\x14＼}ρ\u007f$２>ｊ␒α␍3＄： ～",
		out:  "L >＂ｒαθ\x11θ'?#＄\x14＼}ρ␡$２>ｊ␒α␍3＄： ～",
	}, { // 1944
		mask: EncodeCtl | EncodeLeftTilde | EncodeRightSpace,
		in:   "~ Jkθ␉?\x0f＞\x16I\r+｀\rμ｀υψκ[／Ｋ\x13λＤＮT ｋ",
		out:  "～ Jkθ‛␉?␏＞␖I␍+｀␍μ｀υψκ[／Ｋ␓λＤＮT ｋ",
	}, { // 1945
		mask: EncodeCtl | EncodeLeftTilde | EncodeRightSpace,
		in:   "～ Jkθ␉?\x0f＞\x16I\r+｀\rμ｀υψκ[／Ｋ\x13λＤＮT ｋ",
		out:  "‛～ Jkθ‛␉?␏＞␖I␍+｀␍μ｀υψκ[／Ｋ␓λＤＮT ｋ",
	}, { // 1946
		mask: EncodeCtl | EncodeLeftTilde | EncodeRightSpace,
		in:   "␊ Jkθ␉?\x0f＞\x16I\r+｀\rμ｀υψκ[／Ｋ\x13λＤＮT ~",
		out:  "‛␊ Jkθ‛␉?␏＞␖I␍+｀␍μ｀υψκ[／Ｋ␓λＤＮT ~",
	}, { // 1947
		mask: EncodeCtl | EncodeLeftTilde | EncodeRightSpace,
		in:   "␊ Jkθ␉?\x0f＞\x16I\r+｀\rμ｀υψκ[／Ｋ\x13λＤＮT ～",
		out:  "‛␊ Jkθ‛␉?␏＞␖I␍+｀␍μ｀υψκ[／Ｋ␓λＤＮT ～",
	}, { // 1948
		mask: EncodeZero | EncodeLeftTilde | EncodeRightPeriod,
		in:   "~.\n\x1a*␊\x12ρ␇＾＜\x103\x10ζ␊\\６０＊>␊δ1θαＭ␅.3",
		out:  "～.\n\x1a*␊\x12ρ␇＾＜\x103\x10ζ␊\\６０＊>␊δ1θαＭ␅.3",
	}, { // 1949
		mask: EncodeZero | EncodeLeftTilde | EncodeRightPeriod,
		in:   "～.\n\x1a*␊\x12ρ␇＾＜\x103\x10ζ␊\\６０＊>␊δ1θαＭ␅.3",
		out:  "‛～.\n\x1a*␊\x12ρ␇＾＜\x103\x10ζ␊\\６０＊>␊δ1θαＭ␅.3",
	}, { // 1950
		mask: EncodeZero | EncodeLeftTilde | EncodeRightPeriod,
		in:   "P.\n\x1a*␊\x12ρ␇＾＜\x103\x10ζ␊\\６０＊>␊δ1θαＭ␅.~",
		out:  "P.\n\x1a*␊\x12ρ␇＾＜\x103\x10ζ␊\\６０＊>␊δ1θαＭ␅.~",
	}, { // 1951
		mask: EncodeZero | EncodeLeftTilde | EncodeRightPeriod,
		in:   "P.\n\x1a*␊\x12ρ␇＾＜\x103\x10ζ␊\\６０＊>␊δ1θαＭ␅.～",
		out:  "P.\n\x1a*␊\x12ρ␇＾＜\x103\x10ζ␊\\６０＊>␊δ1θαＭ␅.～",
	}, { // 1952
		mask: EncodeSlash | EncodeLeftTilde | EncodeRightPeriod,
		in:   "~.\x19:θT／J＜；&N（ω>＂\"εξｌ␀βm８\x0f＃␆X.θ",
		out:  "～.\x19:θT‛／J＜；&N（ω>＂\"εξｌ‛␀βm８\x0f＃␆X.θ",
	}, { // 1953
		mask: EncodeSlash | EncodeLeftTilde | EncodeRightPeriod,
		in:   "～.\x19:θT／J＜；&N（ω>＂\"εξｌ␀βm８\x0f＃␆X.θ",
		out:  "‛～.\x19:θT‛／J＜；&N（ω>＂\"εξｌ‛␀βm８\x0f＃␆X.θ",
	}, { // 1954
		mask: EncodeSlash | EncodeLeftTilde | EncodeRightPeriod,
		in:   "\n.\x19:θT／J＜；&N（ω>＂\"εξｌ␀βm８\x0f＃␆X.~",
		out:  "\n.\x19:θT‛／J＜；&N（ω>＂\"εξｌ‛␀βm８\x0f＃␆X.~",
	}, { // 1955
		mask: EncodeSlash | EncodeLeftTilde | EncodeRightPeriod,
		in:   "\n.\x19:θT／J＜；&N（ω>＂\"εξｌ␀βm８\x0f＃␆X.～",
		out:  "\n.\x19:θT‛／J＜；&N（ω>＂\"εξｌ‛␀βm８\x0f＃␆X.～",
	}, { // 1956
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeRightPeriod,
		in:   "~.\f␂\u007f\x01＜＇6$=α|ｐ，+γ?α␆␃ζ\x19？α3＇Ｒ.η",
		out:  "～.\f␂\u007f\x01＜‛＇6$=α|ｐ，+γ?α␆␃ζ\x19？α3‛＇Ｒ.η",
	}, { // 1957
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeRightPeriod,
		in:   "～.\f␂\u007f\x01＜＇6$=α|ｐ，+γ?α␆␃ζ\x19？α3＇Ｒ.η",
		out:  "‛～.\f␂\u007f\x01＜‛＇6$=α|ｐ，+γ?α␆␃ζ\x19？α3‛＇Ｒ.η",
	}, { // 1958
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeRightPeriod,
		in:   "Ｋ.\f␂\u007f\x01＜＇6$=α|ｐ，+γ?α␆␃ζ\x19？α3＇Ｒ.~",
		out:  "Ｋ.\f␂\u007f\x01＜‛＇6$=α|ｐ，+γ?α␆␃ζ\x19？α3‛＇Ｒ.~",
	}, { // 1959
		mask: EncodeSingleQuote | EncodeLeftTilde | EncodeRightPeriod,
		in:   "Ｋ.\f␂\u007f\x01＜＇6$=α|ｐ，+γ?α␆␃ζ\x19？α3＇Ｒ.～",
		out:  "Ｋ.\f␂\u007f\x01＜‛＇6$=α|ｐ，+γ?α␆␃ζ\x19？α3‛＇Ｒ.～",
	}, { // 1960
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeRightPeriod,
		in:   "~.Ｎ6\x14␡aA＄ｚθ［Vχ\x1d｜\\ｙνq\a␚ν｛Jψ\x12ε.\x01",
		out:  "～.Ｎ6\x14␡aA＄ｚθ［Vχ\x1d｜\\ｙνq\a␚ν｛Jψ\x12ε.\x01",
	}, { // 1961
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeRightPeriod,
		in:   "～.Ｎ6\x14␡aA＄ｚθ［Vχ\x1d｜\\ｙνq\a␚ν｛Jψ\x12ε.\x01",
		out:  "‛～.Ｎ6\x14␡aA＄ｚθ［Vχ\x1d｜\\ｙνq\a␚ν｛Jψ\x12ε.\x01",
	}, { // 1962
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeRightPeriod,
		in:   "␍.Ｎ6\x14␡aA＄ｚθ［Vχ\x1d｜\\ｙνq\a␚ν｛Jψ\x12ε.~",
		out:  "␍.Ｎ6\x14␡aA＄ｚθ［Vχ\x1d｜\\ｙνq\a␚ν｛Jψ\x12ε.~",
	}, { // 1963
		mask: EncodeBackQuote | EncodeLeftTilde | EncodeRightPeriod,
		in:   "␍.Ｎ6\x14␡aA＄ｚθ［Vχ\x1d｜\\ｙνq\a␚ν｛Jψ\x12ε.～",
		out:  "␍.Ｎ6\x14␡aA＄ｚθ［Vχ\x1d｜\\ｙνq\a␚ν｛Jψ\x12ε.～",
	}, { // 1964
		mask: EncodeLtGt | EncodeLeftTilde | EncodeRightPeriod,
		in:   "~.\x1dχ␀\x19␕ι％ιｈ\x1b␕\\＆？\x1b＼.ｌνO｝％δT␟`.@",
		out:  "～.\x1dχ‛␀\x19␕ι％ιｈ\x1b␕\\＆？\x1b＼.ｌνO｝％δT␟`.@",
	}, { // 1965
		mask: EncodeLtGt | EncodeLeftTilde | EncodeRightPeriod,
		in:   "～.\x1dχ␀\x19␕ι％ιｈ\x1b␕\\＆？\x1b＼.ｌνO｝％δT␟`.@",
		out:  "‛～.\x1dχ‛␀\x19␕ι％ιｈ\x1b␕\\＆？\x1b＼.ｌνO｝％δT␟`.@",
	}, { // 1966
		mask: EncodeLtGt | EncodeLeftTilde | EncodeRightPeriod,
		in:   "ο.\x1dχ␀\x19␕ι％ιｈ\x1b␕\\＆？\x1b＼.ｌνO｝％δT␟`.~",
		out:  "ο.\x1dχ‛␀\x19␕ι％ιｈ\x1b␕\\＆？\x1b＼.ｌνO｝％δT␟`.~",
	}, { // 1967
		mask: EncodeLtGt | EncodeLeftTilde | EncodeRightPeriod,
		in:   "ο.\x1dχ␀\x19␕ι％ιｈ\x1b␕\\＆？\x1b＼.ｌνO｝％δT␟`.～",
		out:  "ο.\x1dχ‛␀\x19␕ι％ιｈ\x1b␕\\＆？\x1b＼.ｌνO｝％δT␟`.～",
	}, { // 1968
		mask: EncodeDollar | EncodeLeftTilde | EncodeRightPeriod,
		in:   "~.｝␓\x15\x15␌Ｘ\n＊\x16\x02／\"４＄υδ*␁Z(ｏｌασ(ι.λ",
		out:  "～.｝␓\x15\x15␌Ｘ\n＊\x16\x02／\"４‛＄υδ*␁Z(ｏｌασ(ι.λ",
	}, { // 1969
		mask: EncodeDollar | EncodeLeftTilde | EncodeRightPeriod,
		in:   "～.｝␓\x15\x15␌Ｘ\n＊\x16\x02／\"４＄υδ*␁Z(ｏｌασ(ι.λ",
		out:  "‛～.｝␓\x15\x15␌Ｘ\n＊\x16\x02／\"４‛＄υδ*␁Z(ｏｌασ(ι.λ",
	}, { // 1970
		mask: EncodeDollar | EncodeLeftTilde | EncodeRightPeriod,
		in:   "␄.｝␓\x15\x15␌Ｘ\n＊\x16\x02／\"４＄υδ*␁Z(ｏｌασ(ι.~",
		out:  "␄.｝␓\x15\x15␌Ｘ\n＊\x16\x02／\"４‛＄υδ*␁Z(ｏｌασ(ι.~",
	}, { // 1971
		mask: EncodeDollar | EncodeLeftTilde | EncodeRightPeriod,
		in:   "␄.｝␓\x15\x15␌Ｘ\n＊\x16\x02／\"４＄υδ*␁Z(ｏｌασ(ι.～",
		out:  "␄.｝␓\x15\x15␌Ｘ\n＊\x16\x02／\"４‛＄υδ*␁Z(ｏｌασ(ι.～",
	}, { // 1972
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeRightPeriod,
		in:   "~._δ＃\x19␡\x06ζ␊Dεｖ｜０iｍε>４8λ\x19\\L＄｀>./",
		out:  "～._δ＃\x19␡\x06ζ␊Dεｖ｜０iｍε>４8λ\x19\\L＄｀>./",
	}, { // 1973
		mask: EncodeDoubleQuote | EncodeLeftTilde | EncodeRightPeriod,
		in:   "～._δ＃\x19␡\x06ζ␊Dεｖ｜０iｍε>４8λ\x19\\L＄｀>./",
		out:  "‛～._δ＃\x19␡\x06ζ␊Dεｖ｜０iｍε>４8λ\x19\\L＄｀>./",
	}, { // 1974
		mask: