// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DisplayControl.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.display {
  public class DisplayControl_2_0_0 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("display.DisplayControl:2.0.0", null);

    public DisplayControl_2_0_0(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public DisplayControl_2_0_0(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new DisplayControl_2_0_0 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new DisplayControl_2_0_0(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int SUCCESS = 0;

    public const int ERR_INVALID_VALUE = 1;

    public class Info : ICloneable {
      public object Clone() {
        Info copy = new Info();
        copy.fwAppVersion = this.fwAppVersion;
        copy.fwBootVersion = this.fwBootVersion;
        copy.orientation = this.orientation;
        copy.width = this.width;
        copy.height = this.height;
        copy.versionAvailable = this.versionAvailable;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["fwAppVersion"] = this.fwAppVersion;
        json["fwBootVersion"] = this.fwBootVersion;
        json["orientation"] = this.orientation;
        json["width"] = this.width;
        json["height"] = this.height;
        json["versionAvailable"] = this.versionAvailable;
        return json;
      }

      public static Info Decode(LightJson.JsonObject json, Agent agent) {
        Info inst = new Info();
        inst.fwAppVersion = (int)json["fwAppVersion"];
        inst.fwBootVersion = (int)json["fwBootVersion"];
        inst.orientation = (int)json["orientation"];
        inst.width = (int)json["width"];
        inst.height = (int)json["height"];
        inst.versionAvailable = (bool)json["versionAvailable"];
        return inst;
      }

      public int fwAppVersion = 0;
      public int fwBootVersion = 0;
      public int orientation = 0;
      public int width = 0;
      public int height = 0;
      public bool versionAvailable = false;
    }

    public class DefaultViewItem : ICloneable {
      public object Clone() {
        DefaultViewItem copy = new DefaultViewItem();
        copy.id = this.id;
        copy.description = this.description;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["id"] = this.id;
        json["description"] = this.description;
        return json;
      }

      public static DefaultViewItem Decode(LightJson.JsonObject json, Agent agent) {
        DefaultViewItem inst = new DefaultViewItem();
        inst.id = (string)json["id"];
        inst.description = (string)json["description"];
        return inst;
      }

      public string id = "";
      public string description = "";
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.defaultView = this.defaultView;
        copy.backlightTimeout = this.backlightTimeout;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["defaultView"] = this.defaultView;
        json["backlightTimeout"] = this.backlightTimeout;
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.defaultView = (string)json["defaultView"];
        inst.backlightTimeout = (int)json["backlightTimeout"];
        return inst;
      }

      public string defaultView = "";
      public int backlightTimeout = 0;
    }

    public class SettingsChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("display.DisplayControl_2_0_0.SettingsChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.display.DisplayControl_2_0_0.Settings newSettings = new Com.Raritan.Idl.display.DisplayControl_2_0_0.Settings();
    }

    public class GetAvailableDefaultViewsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.display.DisplayControl_2_0_0.DefaultViewItem> _ret_;
    }

    public GetAvailableDefaultViewsResult getAvailableDefaultViews() {
      JsonObject _parameters = null;
      var _result = RpcCall("getAvailableDefaultViews", _parameters);
      var _ret = new GetAvailableDefaultViewsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.display.DisplayControl_2_0_0.DefaultViewItem>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.display.DisplayControl_2_0_0.DefaultViewItem.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getAvailableDefaultViews(AsyncRpcResponse<GetAvailableDefaultViewsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAvailableDefaultViews(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAvailableDefaultViews(AsyncRpcResponse<GetAvailableDefaultViewsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getAvailableDefaultViews", _parameters,
        _result => {
          try {
            var _ret = new GetAvailableDefaultViewsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.display.DisplayControl_2_0_0.DefaultViewItem>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.display.DisplayControl_2_0_0.DefaultViewItem.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.display.DisplayControl_2_0_0.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.display.DisplayControl_2_0_0.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.display.DisplayControl_2_0_0.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.display.DisplayControl_2_0_0.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.display.DisplayControl_2_0_0.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.display.DisplayControl_2_0_0.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetInfoResult {
      public Com.Raritan.Idl.display.DisplayControl_2_0_0.Info _ret_;
    }

    public GetInfoResult getInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInfo", _parameters);
      var _ret = new GetInfoResult();
      _ret._ret_ = Com.Raritan.Idl.display.DisplayControl_2_0_0.Info.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInfo", _parameters,
        _result => {
          try {
            var _ret = new GetInfoResult();
            _ret._ret_ = Com.Raritan.Idl.display.DisplayControl_2_0_0.Info.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ShowSmileyResult {
    }

    public ShowSmileyResult showSmiley(bool on, bool happy, string msg) {
      var _parameters = new LightJson.JsonObject();
      _parameters["on"] = on;
      _parameters["happy"] = happy;
      _parameters["msg"] = msg;

      var _result = RpcCall("showSmiley", _parameters);
      var _ret = new ShowSmileyResult();
      return _ret;
    }

    public AsyncRequest showSmiley(bool on, bool happy, string msg, AsyncRpcResponse<ShowSmileyResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return showSmiley(on, happy, msg, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest showSmiley(bool on, bool happy, string msg, AsyncRpcResponse<ShowSmileyResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["on"] = on;
        _parameters["happy"] = happy;
        _parameters["msg"] = msg;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("showSmiley", _parameters,
        _result => {
          try {
            var _ret = new ShowSmileyResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
