// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from CascadeManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.cascading {
  public class CascadeManager_2_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager:2.0.1", null);

    public CascadeManager_2_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public CascadeManager_2_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new CascadeManager_2_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new CascadeManager_2_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int NO_ERROR = 0;

    public const int ERR_INVALID_PARAM = 1;

    public const int ERR_UNSUPPORTED_ON_PRIMARY_UNIT = 2;

    public const int ERR_UNSUPPORTED_ON_LINK_UNIT = 3;

    public const int ERR_LINK_ID_IN_USE = 4;

    public const int ERR_HOST_IN_USE = 5;

    public const int ERR_LINK_UNIT_UNREACHABLE = 6;

    public const int ERR_LINK_UNIT_ACCESS_DENIED = 7;

    public const int ERR_LINK_UNIT_REFUSED = 8;

    public const int ERR_UNIT_BUSY = 9;

    public const int ERR_NOT_SUPPORTED = 10;

    public const int ERR_PASSWORD_CHANGE_REQUIRED = 11;

    public const int ERR_PASSWORD_POLICY = 12;

    public const int ERR_LINK_UNIT_COMM_FAILED = 13;

    public const int ERR_LINK_UNIT_NOT_SUPPORTED = 14;

    public const int ERR_FIRMWARE_VERSION_MISMATCH = 15;

    public class PrimaryUnitSettings : ICloneable {
      public object Clone() {
        PrimaryUnitSettings copy = new PrimaryUnitSettings();
        copy.caCertChain = this.caCertChain;
        copy.allowOffTimeRangeCerts = this.allowOffTimeRangeCerts;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["caCertChain"] = this.caCertChain;
        json["allowOffTimeRangeCerts"] = this.allowOffTimeRangeCerts;
        return json;
      }

      public static PrimaryUnitSettings Decode(LightJson.JsonObject json, Agent agent) {
        PrimaryUnitSettings inst = new PrimaryUnitSettings();
        inst.caCertChain = (string)json["caCertChain"];
        inst.allowOffTimeRangeCerts = (bool)json["allowOffTimeRangeCerts"];
        return inst;
      }

      public string caCertChain = "";
      public bool allowOffTimeRangeCerts = false;
    }

    public enum Role {
      STANDALONE,
      PRIMARY_UNIT,
      LINK_UNIT,
    }

    public enum LinkUnitType {
      NETWORK,
      SECURE_SERIAL,
    }

    public enum LinkUnitStatus {
      UNKNOWN,
      OK,
      UNREACHABLE,
      ACCESS_DENIED,
      FIRMWARE_UPDATE,
      FIRMWARE_MISMATCH,
      PENDING,
    }

    public class LinkUnit : ICloneable {
      public object Clone() {
        LinkUnit copy = new LinkUnit();
        copy.type = this.type;
        copy.host = this.host;
        copy.status = this.status;
        copy.fwVersion = this.fwVersion;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["type"] = (int)this.type;
        json["host"] = this.host;
        json["status"] = (int)this.status;
        json["fwVersion"] = this.fwVersion;
        return json;
      }

      public static LinkUnit Decode(LightJson.JsonObject json, Agent agent) {
        LinkUnit inst = new LinkUnit();
        inst.type = (Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType)(int)json["type"];
        inst.host = (string)json["host"];
        inst.status = (Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitStatus)(int)json["status"];
        inst.fwVersion = (string)json["fwVersion"];
        return inst;
      }

      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType type = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType.NETWORK;
      public string host = "";
      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitStatus status = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitStatus.UNKNOWN;
      public string fwVersion = "";
    }

    public class Status : ICloneable {
      public object Clone() {
        Status copy = new Status();
        copy.role = this.role;
        copy.primaryUnit = this.primaryUnit;
        copy.linkUnits = this.linkUnits;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["role"] = (int)this.role;
        json["primaryUnit"] = this.primaryUnit;
        json["linkUnits"] = new JsonArray(this.linkUnits.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value.Encode())
        })));
        return json;
      }

      public static Status Decode(LightJson.JsonObject json, Agent agent) {
        Status inst = new Status();
        inst.role = (Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Role)(int)json["role"];
        inst.primaryUnit = (string)json["primaryUnit"];
        inst.linkUnits = DictionaryHelper.Create(json["linkUnits"].AsJsonArray.Select(
          _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnit>(_value["key"], Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnit.Decode(_value["value"], agent))));
        return inst;
      }

      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Role role = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Role.STANDALONE;
      public string primaryUnit = "";
      public System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnit> linkUnits = new System.Collections.Generic.Dictionary<int, Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnit>();
    }

    public class LinkPortStatus : ICloneable {
      public object Clone() {
        LinkPortStatus copy = new LinkPortStatus();
        copy.isSupported = this.isSupported;
        copy.isLinkDetected = this.isLinkDetected;
        copy.isLinkingConfirmationNeeded = this.isLinkingConfirmationNeeded;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["isSupported"] = this.isSupported;
        json["isLinkDetected"] = this.isLinkDetected;
        json["isLinkingConfirmationNeeded"] = this.isLinkingConfirmationNeeded;
        return json;
      }

      public static LinkPortStatus Decode(LightJson.JsonObject json, Agent agent) {
        LinkPortStatus inst = new LinkPortStatus();
        inst.isSupported = (bool)json["isSupported"];
        inst.isLinkDetected = (bool)json["isLinkDetected"];
        inst.isLinkingConfirmationNeeded = (bool)json["isLinkingConfirmationNeeded"];
        return inst;
      }

      public bool isSupported = false;
      public bool isLinkDetected = false;
      public bool isLinkingConfirmationNeeded = false;
    }

    public class RoleChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager_2_0_1.RoleChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Role oldRole = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Role.STANDALONE;
      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Role newRole = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Role.STANDALONE;
      public string primaryUnit = "";
    }

    public class LinkUnitAddedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager_2_0_1.LinkUnitAddedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int linkId = 0;
      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType type = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType.NETWORK;
      public string host = "";
    }

    public class LinkUnitReleasedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager_2_0_1.LinkUnitReleasedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int linkId = 0;
      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType type = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType.NETWORK;
      public string host = "";
    }

    public class LinkUnitStatusChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager_2_0_1.LinkUnitStatusChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public int linkId = 0;
      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType type = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType.NETWORK;
      public string host = "";
      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitStatus oldStatus = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitStatus.UNKNOWN;
      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitStatus newStatus = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitStatus.UNKNOWN;
    }

    public class LinkPortStatusChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager_2_0_1.LinkPortStatusChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkPortStatus oldStatus = new Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkPortStatus();
      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkPortStatus newStatus = new Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkPortStatus();
    }

    public class GetPrimaryUnitSettingsResult {
      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.PrimaryUnitSettings _ret_;
    }

    public GetPrimaryUnitSettingsResult getPrimaryUnitSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getPrimaryUnitSettings", _parameters);
      var _ret = new GetPrimaryUnitSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.PrimaryUnitSettings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getPrimaryUnitSettings(AsyncRpcResponse<GetPrimaryUnitSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getPrimaryUnitSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getPrimaryUnitSettings(AsyncRpcResponse<GetPrimaryUnitSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getPrimaryUnitSettings", _parameters,
        _result => {
          try {
            var _ret = new GetPrimaryUnitSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.PrimaryUnitSettings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetPrimaryUnitSettingsResult {
      public int _ret_;
    }

    public SetPrimaryUnitSettingsResult setPrimaryUnitSettings(Com.Raritan.Idl.cascading.CascadeManager_2_0_1.PrimaryUnitSettings primaryUnitSettings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["primaryUnitSettings"] = primaryUnitSettings.Encode();

      var _result = RpcCall("setPrimaryUnitSettings", _parameters);
      var _ret = new SetPrimaryUnitSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setPrimaryUnitSettings(Com.Raritan.Idl.cascading.CascadeManager_2_0_1.PrimaryUnitSettings primaryUnitSettings, AsyncRpcResponse<SetPrimaryUnitSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setPrimaryUnitSettings(primaryUnitSettings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setPrimaryUnitSettings(Com.Raritan.Idl.cascading.CascadeManager_2_0_1.PrimaryUnitSettings primaryUnitSettings, AsyncRpcResponse<SetPrimaryUnitSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["primaryUnitSettings"] = primaryUnitSettings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setPrimaryUnitSettings", _parameters,
        _result => {
          try {
            var _ret = new SetPrimaryUnitSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetStatusResult {
      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Status _ret_;
    }

    public GetStatusResult getStatus() {
      JsonObject _parameters = null;
      var _result = RpcCall("getStatus", _parameters);
      var _ret = new GetStatusResult();
      _ret._ret_ = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Status.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getStatus(AsyncRpcResponse<GetStatusResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getStatus(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getStatus(AsyncRpcResponse<GetStatusResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getStatus", _parameters,
        _result => {
          try {
            var _ret = new GetStatusResult();
            _ret._ret_ = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Status.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetLinkPortStatusResult {
      public Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkPortStatus _ret_;
    }

    public GetLinkPortStatusResult getLinkPortStatus() {
      JsonObject _parameters = null;
      var _result = RpcCall("getLinkPortStatus", _parameters);
      var _ret = new GetLinkPortStatusResult();
      _ret._ret_ = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkPortStatus.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getLinkPortStatus(AsyncRpcResponse<GetLinkPortStatusResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getLinkPortStatus(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getLinkPortStatus(AsyncRpcResponse<GetLinkPortStatusResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getLinkPortStatus", _parameters,
        _result => {
          try {
            var _ret = new GetLinkPortStatusResult();
            _ret._ret_ = Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkPortStatus.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class AddLinkUnitResult {
      public int _ret_;
    }

    public AddLinkUnitResult addLinkUnit(int linkId, string host, string login, string password, string newPassword) {
      var _parameters = new LightJson.JsonObject();
      _parameters["linkId"] = linkId;
      _parameters["host"] = host;
      _parameters["login"] = login;
      _parameters["password"] = password;
      _parameters["newPassword"] = newPassword;

      var _result = RpcCall("addLinkUnit", _parameters);
      var _ret = new AddLinkUnitResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest addLinkUnit(int linkId, string host, string login, string password, string newPassword, AsyncRpcResponse<AddLinkUnitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addLinkUnit(linkId, host, login, password, newPassword, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addLinkUnit(int linkId, string host, string login, string password, string newPassword, AsyncRpcResponse<AddLinkUnitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["linkId"] = linkId;
        _parameters["host"] = host;
        _parameters["login"] = login;
        _parameters["password"] = password;
        _parameters["newPassword"] = newPassword;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addLinkUnit", _parameters,
        _result => {
          try {
            var _ret = new AddLinkUnitResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ReleaseLinkUnitResult {
      public int _ret_;
    }

    public ReleaseLinkUnitResult releaseLinkUnit(int linkId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["linkId"] = linkId;

      var _result = RpcCall("releaseLinkUnit", _parameters);
      var _ret = new ReleaseLinkUnitResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest releaseLinkUnit(int linkId, AsyncRpcResponse<ReleaseLinkUnitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return releaseLinkUnit(linkId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest releaseLinkUnit(int linkId, AsyncRpcResponse<ReleaseLinkUnitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["linkId"] = linkId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("releaseLinkUnit", _parameters,
        _result => {
          try {
            var _ret = new ReleaseLinkUnitResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class RequestLinkResult {
      public int _ret_;
    }

    public RequestLinkResult requestLink(string token) {
      var _parameters = new LightJson.JsonObject();
      _parameters["token"] = token;

      var _result = RpcCall("requestLink", _parameters);
      var _ret = new RequestLinkResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest requestLink(string token, AsyncRpcResponse<RequestLinkResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return requestLink(token, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest requestLink(string token, AsyncRpcResponse<RequestLinkResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["token"] = token;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("requestLink", _parameters,
        _result => {
          try {
            var _ret = new RequestLinkResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class FinalizeLinkResult {
    }

    public FinalizeLinkResult finalizeLink(string token) {
      var _parameters = new LightJson.JsonObject();
      _parameters["token"] = token;

      var _result = RpcCall("finalizeLink", _parameters);
      var _ret = new FinalizeLinkResult();
      return _ret;
    }

    public AsyncRequest finalizeLink(string token, AsyncRpcResponse<FinalizeLinkResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return finalizeLink(token, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest finalizeLink(string token, AsyncRpcResponse<FinalizeLinkResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["token"] = token;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("finalizeLink", _parameters,
        _result => {
          try {
            var _ret = new FinalizeLinkResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class UnlinkResult {
    }

    public UnlinkResult unlink() {
      JsonObject _parameters = null;
      var _result = RpcCall("unlink", _parameters);
      var _ret = new UnlinkResult();
      return _ret;
    }

    public AsyncRequest unlink(AsyncRpcResponse<UnlinkResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return unlink(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest unlink(AsyncRpcResponse<UnlinkResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("unlink", _parameters,
        _result => {
          try {
            var _ret = new UnlinkResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSupportedRolesResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Role> _ret_;
    }

    public GetSupportedRolesResult getSupportedRoles() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSupportedRoles", _parameters);
      var _ret = new GetSupportedRolesResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Role>(_result["_ret_"].AsJsonArray.Select(
        _value => (Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Role)(int)_value));
      return _ret;
    }

    public AsyncRequest getSupportedRoles(AsyncRpcResponse<GetSupportedRolesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSupportedRoles(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSupportedRoles(AsyncRpcResponse<GetSupportedRolesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSupportedRoles", _parameters,
        _result => {
          try {
            var _ret = new GetSupportedRolesResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Role>(_result["_ret_"].AsJsonArray.Select(
              _value => (Com.Raritan.Idl.cascading.CascadeManager_2_0_1.Role)(int)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSupportedLinkUnitTypesResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType> _ret_;
    }

    public GetSupportedLinkUnitTypesResult getSupportedLinkUnitTypes() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSupportedLinkUnitTypes", _parameters);
      var _ret = new GetSupportedLinkUnitTypesResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType>(_result["_ret_"].AsJsonArray.Select(
        _value => (Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType)(int)_value));
      return _ret;
    }

    public AsyncRequest getSupportedLinkUnitTypes(AsyncRpcResponse<GetSupportedLinkUnitTypesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSupportedLinkUnitTypes(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSupportedLinkUnitTypes(AsyncRpcResponse<GetSupportedLinkUnitTypesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSupportedLinkUnitTypes", _parameters,
        _result => {
          try {
            var _ret = new GetSupportedLinkUnitTypesResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType>(_result["_ret_"].AsJsonArray.Select(
              _value => (Com.Raritan.Idl.cascading.CascadeManager_2_0_1.LinkUnitType)(int)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class AddCascadeLinkUnitResult {
      public int _ret_;
    }

    public AddCascadeLinkUnitResult addCascadeLinkUnit(int linkId, int nodeIndex, string login, string password, bool positionDependent) {
      var _parameters = new LightJson.JsonObject();
      _parameters["linkId"] = linkId;
      _parameters["nodeIndex"] = nodeIndex;
      _parameters["login"] = login;
      _parameters["password"] = password;
      _parameters["positionDependent"] = positionDependent;

      var _result = RpcCall("addCascadeLinkUnit", _parameters);
      var _ret = new AddCascadeLinkUnitResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest addCascadeLinkUnit(int linkId, int nodeIndex, string login, string password, bool positionDependent, AsyncRpcResponse<AddCascadeLinkUnitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addCascadeLinkUnit(linkId, nodeIndex, login, password, positionDependent, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addCascadeLinkUnit(int linkId, int nodeIndex, string login, string password, bool positionDependent, AsyncRpcResponse<AddCascadeLinkUnitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["linkId"] = linkId;
        _parameters["nodeIndex"] = nodeIndex;
        _parameters["login"] = login;
        _parameters["password"] = password;
        _parameters["positionDependent"] = positionDependent;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addCascadeLinkUnit", _parameters,
        _result => {
          try {
            var _ret = new AddCascadeLinkUnitResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class AddLinkPortLinkUnitResult {
      public int _ret_;
    }

    public AddLinkPortLinkUnitResult addLinkPortLinkUnit() {
      JsonObject _parameters = null;
      var _result = RpcCall("addLinkPortLinkUnit", _parameters);
      var _ret = new AddLinkPortLinkUnitResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest addLinkPortLinkUnit(AsyncRpcResponse<AddLinkPortLinkUnitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addLinkPortLinkUnit(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addLinkPortLinkUnit(AsyncRpcResponse<AddLinkPortLinkUnitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("addLinkPortLinkUnit", _parameters,
        _result => {
          try {
            var _ret = new AddLinkPortLinkUnitResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class AddSecureSerialLinkUnitResult {
      public int _ret_;
    }

    public AddSecureSerialLinkUnitResult addSecureSerialLinkUnit(int linkId, string installKey) {
      var _parameters = new LightJson.JsonObject();
      _parameters["linkId"] = linkId;
      _parameters["installKey"] = installKey;

      var _result = RpcCall("addSecureSerialLinkUnit", _parameters);
      var _ret = new AddSecureSerialLinkUnitResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest addSecureSerialLinkUnit(int linkId, string installKey, AsyncRpcResponse<AddSecureSerialLinkUnitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addSecureSerialLinkUnit(linkId, installKey, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addSecureSerialLinkUnit(int linkId, string installKey, AsyncRpcResponse<AddSecureSerialLinkUnitResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["linkId"] = linkId;
        _parameters["installKey"] = installKey;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addSecureSerialLinkUnit", _parameters,
        _result => {
          try {
            var _ret = new AddSecureSerialLinkUnitResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
