// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from AssetStripLogger.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.assetmgrmodel {
  public class AssetStripLogger_1_0_4 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStripLogger:1.0.4", null);

    public AssetStripLogger_1_0_4(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public AssetStripLogger_1_0_4(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new AssetStripLogger_1_0_4 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new AssetStripLogger_1_0_4(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int NO_ERROR = 0;

    public const int ERR_INVALID_PARAM = 1;

    public class Info : ICloneable {
      public object Clone() {
        Info copy = new Info();
        copy.capacity = this.capacity;
        copy.oldestRecord = this.oldestRecord;
        copy.newestRecord = this.newestRecord;
        copy.totalEventCount = this.totalEventCount;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["capacity"] = this.capacity;
        json["oldestRecord"] = this.oldestRecord;
        json["newestRecord"] = this.newestRecord;
        json["totalEventCount"] = this.totalEventCount;
        return json;
      }

      public static Info Decode(LightJson.JsonObject json, Agent agent) {
        Info inst = new Info();
        inst.capacity = (int)json["capacity"];
        inst.oldestRecord = (int)json["oldestRecord"];
        inst.newestRecord = (int)json["newestRecord"];
        inst.totalEventCount = (int)json["totalEventCount"];
        return inst;
      }

      public int capacity = 0;
      public int oldestRecord = 0;
      public int newestRecord = 0;
      public int totalEventCount = 0;
    }

    public enum RecordType {
      EMPTY,
      ASSET_TAG_CONNECTED,
      ASSET_TAG_DISCONNECTED,
      ASSET_STRIP_STATE_CHANGED,
    }

    public class Record : ICloneable {
      public object Clone() {
        Record copy = new Record();
        copy.timestamp = this.timestamp;
        copy.type = this.type;
        copy.assetStripNumber = this.assetStripNumber;
        copy.rackUnitNumber = this.rackUnitNumber;
        copy.rackUnitPosition = this.rackUnitPosition;
        copy.slotNumber = this.slotNumber;
        copy.tagId = this.tagId;
        copy.parentBladeId = this.parentBladeId;
        copy.state = this.state;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["timestamp"] = (this.timestamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["type"] = (int)this.type;
        json["assetStripNumber"] = this.assetStripNumber;
        json["rackUnitNumber"] = this.rackUnitNumber;
        json["rackUnitPosition"] = this.rackUnitPosition;
        json["slotNumber"] = this.slotNumber;
        json["tagId"] = this.tagId;
        json["parentBladeId"] = this.parentBladeId;
        json["state"] = (int)this.state;
        return json;
      }

      public static Record Decode(LightJson.JsonObject json, Agent agent) {
        Record inst = new Record();
        inst.timestamp = new System.DateTime(json["timestamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.type = (Com.Raritan.Idl.assetmgrmodel.AssetStripLogger_1_0_4.RecordType)(int)json["type"];
        inst.assetStripNumber = (int)json["assetStripNumber"];
        inst.rackUnitNumber = (int)json["rackUnitNumber"];
        inst.rackUnitPosition = (int)json["rackUnitPosition"];
        inst.slotNumber = (int)json["slotNumber"];
        inst.tagId = (string)json["tagId"];
        inst.parentBladeId = (string)json["parentBladeId"];
        inst.state = (Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_3.State)(int)json["state"];
        return inst;
      }

      public System.DateTime timestamp = new System.DateTime(0);
      public Com.Raritan.Idl.assetmgrmodel.AssetStripLogger_1_0_4.RecordType type = Com.Raritan.Idl.assetmgrmodel.AssetStripLogger_1_0_4.RecordType.EMPTY;
      public int assetStripNumber = 0;
      public int rackUnitNumber = 0;
      public int rackUnitPosition = 0;
      public int slotNumber = 0;
      public string tagId = "";
      public string parentBladeId = "";
      public Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_3.State state = Com.Raritan.Idl.assetmgrmodel.AssetStrip_2_0_3.State.DISCONNECTED;
    }

    public class GetInfoResult {
      public Com.Raritan.Idl.assetmgrmodel.AssetStripLogger_1_0_4.Info _ret_;
    }

    public GetInfoResult getInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInfo", _parameters);
      var _ret = new GetInfoResult();
      _ret._ret_ = Com.Raritan.Idl.assetmgrmodel.AssetStripLogger_1_0_4.Info.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInfo", _parameters,
        _result => {
          try {
            var _ret = new GetInfoResult();
            _ret._ret_ = Com.Raritan.Idl.assetmgrmodel.AssetStripLogger_1_0_4.Info.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetRecordsResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.assetmgrmodel.AssetStripLogger_1_0_4.Record> records;
    }

    public GetRecordsResult getRecords(int id, int count) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;
      _parameters["count"] = count;

      var _result = RpcCall("getRecords", _parameters);
      var _ret = new GetRecordsResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.records = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStripLogger_1_0_4.Record>(_result["records"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.assetmgrmodel.AssetStripLogger_1_0_4.Record.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getRecords(int id, int count, AsyncRpcResponse<GetRecordsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getRecords(id, count, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getRecords(int id, int count, AsyncRpcResponse<GetRecordsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
        _parameters["count"] = count;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getRecords", _parameters,
        _result => {
          try {
            var _ret = new GetRecordsResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.records = new System.Collections.Generic.List<Com.Raritan.Idl.assetmgrmodel.AssetStripLogger_1_0_4.Record>(_result["records"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.assetmgrmodel.AssetStripLogger_1_0_4.Record.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
