# Announce: Rakudo Perl 6 compiler, Release 2016.07.1

On behalf of the Rakudo development team, I'm announcing an
out-of-schedule release of the Rakudo Perl 6 compiler.
Rakudo is an implementation of Perl 6 on the Moar Virtual Machine[^1].

This release is a point release in addition to the regular, monthly
releases. Rakudo 2016.07 (note: no .1) was discovered to have issues with
make DESTDIR[^3], which creates a problem for packagers. As this month
will also see the next Rakudo Star[^2] release, based on the latest Rakudo,
the development team decided it was worth it to make a point release
fixing the packaging issues.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

Other changes since the 2016.07 release are also included in this point release:

New in 2016.07.1:
 + Fixes:
   + `make DESTDIR` now correctly finds CompUnit::Repository::Staging
   + .polymod with a lazy list no longer loses mods if the list runs out
   + Output from Test.pm6's diag() is no longer lost in non-verbose prove output
     when called at the start of the test file or during TODO tests
   + Bitwise operators that return int/Int no longer fail with candidate error
     when given a native int argument
 + Additions:
   + Improved error message when IO::Path.new is given incorrect arguments
   + Improved error message when .polymod is given a zero as divisor
 + Efficiency:
   + Str.samecase is now 5x faster
   + Str.indices is 10% faster
   + Str.rindex is 30% faster
   + Str.index is 30% faster

The following people contributed to this release:

Zoffix Znet, Stefan Seifert, Elizabeth Mattijsen, Christian Bartolomäus

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

The next release of Rakudo (#102), is tentatively scheduled for 2016-08-20.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

[^3]: See https://rt.perl.org/Ticket/Display.html?id=128652

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility.
