# Announce: Rakudo Perl 6 compiler, Release #115 (2017.09)

On behalf of the Rakudo development team, I’m very happy to announce the
September 2017 release of Rakudo Perl 6 #115. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo.

Upcoming releases in 2017 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2017.09:
 + Fixes:
    + Fixed NativeCall signature check for unsupported native types [4077842c]
    + Fixed .made called on a Match on which .make was never called [5db5b1db]
    + Fixed flattening of a typed hash [6cec6b72]
    + Fixed iterator on pairs with Mu's [a5014fd0]
    + Fixed Supply.batch with non-int elems and elems == 1 [98f9fffe][7d1ece80]
    + Improved error message on nameless postfix `.::` [5969f21e]
    + Fixed ::("GLOBAL") [1f6a782c]
    + Refined merging of one() junctions [79604a88]
    + Fixed error message with leaking variable name in FailGoal [ed4f6cc9]
    + Implemented missing Instant.Instant [51709e01]
    + Fixed thread safety issues with signal introspection [1f411693]
    + Fixed thread safety issues in the `signal` sub [13b6a33c]
    + Fixed thread safety of "foo{$x}bar" [59454b03]
    + Made Bool.enums consistent with Enumeration.enums [e7a58806]
    + Fixed doubled path issue in IO::Notification.watch-path [2362dfd6]
    + Disabled interactive REPL for non-TTY input [b6a60236]
    + Fix ignoremark and casechange operations of graphemes which begin with
        Unicode Prepend characters [7f526c1e]
    + Suppress line number in X::Package::Stubbed [edac1d68][7ba9b7cd]
    + Fixed race condition in Channel awaiter [b30ac08a]
    + Fixed NYI compilation of NativeCall sigs with optional params [1818de98]
    + Fixed missing deconts in nqp::eqaddr() tests [880b33e2]
    + Fixed Enumeration:D === Enumeration:D [8d938461]
    + Fixed non-blocking await when holding locks [f26d1e24]
    + Fixed non-blocking await-all to respect Slip [a137c0de]
 + Additions:
    + Added support for Str operations with Junctions [753c9a5e][7cd153f4]
        [95a70ca3][0b19baf0][d2f31bb7][e18291e2][8b5d283c]
    + Added support for Unicode 10 [64dd94c2]
    + Added complete Unicode Collation Algorithm implementation [9b42484a]
        [5f335065][ec18efa0]
    + .collate/coll/unicmp operators are no longer experimental
        (Note: $*COLLATION dynamic variable is still experimental) [5f335065]
    + Added Thread.is-initial-thread method [59a2056a]
    + Added output buffering for non-TTYs [44680029][4b02b8aa]
    + Made temp and let on a Failure throw it [80a3255b]
    + Made sure that open files are properly closed on exit [3c9cfdba]
        [97853564][347da8e5][dd8d0d89]
    + Implement pred() and succ() for the Enumeration role [2645a1e9]
        [8d442a52][8df53f34][43e41ec6][55aa7f28][f925c648][69dae1f3][2ad51a0f]
    + Added isa method to SubsetHOW [0704cd97]
 + Build system:
    + Made t/harness* use 6 TEST_JOBS by default [8019c15b]
    + Added --ignore-errors option to Configure.pl [0bc1c877][1da075f9]
    + Fixed `make test` without `make install` first [fb0b3eb5]
    + Made Configure.pl refuse to work without ExtUtils::Command [3f4a9ffa]
    + Fixed non-installed gdb/valgrind runners [4e3f0fca]
 + Efficiency:
    + Knuth-Morris-Pratt string search has been implemented for string
        indexing operations (needles between 2 and 8192 in length) [593fa5f8]
    + 1.5-2x speedup of most string operations involving strands [5ebbc5ba]
    + 2.5x speedup for eq() for comparing two flat strings (1.7-2x for others)
    + 9x speedup when indexing with a needle one grapheme in length [8a215876]
    + Made `Any ~ Str` and `Str ~ Any` about 25% faster [815faa35]
    + Made index and eqat operations 2x faster [5ebbc5ba]
    + Made all(@a), none(@a), one(@a) about 9x faster [51c3d86c]
    + Various improvements to BUILDPLAN and BUILDALLPLAN [7da0c215][0ca5ffa4]
        [760530a5][80e069a4][2574f883][b706b843][963b28d1][532f7092]
    + Made object creation 25% faster in some cases [62fd5093]
 + Internal:
    + Simplified setting up auto-threading [8a0f6ac1]
    + Streamlined Junction .defined, .Bool, .ACCEPTS [e8137b45]
    + Added --no-merge option to t/harness5 to pass through STDERR [4af1d95c]
        [84b40cf5]
    + Various improvements to INTERPOLATE [215a5fa7][ea57cbec][c6aacafd]
        [47439e69][4c25df74][fc632cd8]
    + Some minor cleanup on R:I.FirstNThenSinkAll [9dbc3c50]
    + Fixed --ll-exception to give full thread backtrace [0877278e]
    + Various heap analyzer API changes [bfee5a1e]
    + Streamlined exit / END phaser handling [1adacc72]
    + Made junction optimizer only look at candidates [4de858a5]
    + Assortment of low-level improvements [cbce6721][8a215876]
        [9b42484a][a4ce97ca]


The following people contributed to this release:

Elizabeth Mattijsen, Aleks-Daniel Jakimenko-Aleksejev, Pawel Murias,
Will "Coke" Coleda, Samantha McVey, Jonathan Worthington, Moritz Lenz,
Steve Mynott, Wenzel P. P. Peppmeyer, Nick Logan, Daniel Green, Zak B. Elep,
Stefan Seifert, Philippe Bruhat (BooK), Timo Paulssen, Altai-man,
Christian Bartolomäus, Cuong Manh Le, Brian S. Julin, Claudio Ramirez,
Juan Julián Merelo Guervós, Christopher Bottoms, rafaelschipiura,
Lance Wicks, Jeremy Studer, Adrian White, David Warring, Leon Timmermans,
andreoss, Andrew Ruder, Douglas L. Schrag, Peter Stuifzand, John Harrison,
Salve J. Nilsen, Zoffix Znet

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#116), is tentatively scheduled for 2017-10-21.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
