% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{zelig_qi_to_df}
\alias{zelig_qi_to_df}
\title{Extract simulated quantities of interest from a zelig object}
\source{
For a discussion of tidy data see
\url{https://www.jstatsoft.org/article/view/v059i10}.
}
\usage{
zelig_qi_to_df(obj)
}
\arguments{
\item{obj}{a zelig object with simulated quantities of interest}
}
\description{
Extract simulated quantities of interest from a zelig object
}
\details{
A simulated quantities of interest in a tidy data formatted
\code{data.frame}. This can be useful for creating custom plots.

Each row contains a simulated value and each column contains:
\itemize{
\item \code{setx_value} whether the simulations are from the base \code{x} \code{setx} or the
contrasting \code{x1} for finding first differences.
\item The fitted values specified in \code{setx} including a \code{by} column if
\code{by} was used in the \code{\link{zelig}} call.
\item \code{expected_value}
\item \code{predicted_value}
}

For multinomial reponse models, a separate column is given for the expected
probability of each outcome in the form \verb{expected_*}. Additionally, there
a is column of the predicted outcomes (\code{predicted_value}).
}
\examples{
#### QIs without first difference or range, from covariates fitted at
## central tendencies
z.1 <- zelig(Petal.Width ~ Petal.Length + Species, data = iris,
             model = "ls")
z.1 <- setx(z.1)
z.1 <- sim(z.1)
head(zelig_qi_to_df(z.1))

#### QIs for first differences
z.2 <- zelig(Petal.Width ~ Petal.Length + Species, data = iris,
             model = "ls")
z.2a <- setx(z.2, Petal.Length = 2)
z.2b <- setx(z.2, Petal.Length = 4.4)
z.2 <- sim(z.2, x = z.2a, x1 = z.2a)
head(zelig_qi_to_df(z.2))

#### QIs for first differences, estimated by Species
z.3 <- zelig(Petal.Width ~ Petal.Length, by = "Species", data = iris,
             model = "ls")
z.3a <- setx(z.3, Petal.Length = 2)
z.3b <- setx(z.3, Petal.Length = 4.4)
z.3 <- sim(z.3, x = z.3a, x1 = z.3a)
head(zelig_qi_to_df(z.3))

#### QIs for a range of fitted values
z.4 <- zelig(Petal.Width ~ Petal.Length + Species, data = iris,
             model = "ls")
z.4 <- setx(z.4, Petal.Length = 2:4)
z.4 <- sim(z.4)
head(zelig_qi_to_df(z.4))

#### QIs for a range of fitted values, estimated by Species
z.5 <- zelig(Petal.Width ~ Petal.Length, by = "Species", data = iris,
            model = "ls")
z.5 <- setx(z.5, Petal.Length = 2:4)
z.5 <- sim(z.5)
head(zelig_qi_to_df(z.5))

#### QIs for two ranges of fitted values
z.6 <- zelig(Petal.Width ~ Petal.Length + Species, data = iris,
            model = "ls")
z.6a <- setx(z.6, Petal.Length = 2:4, Species = "setosa")
z.6b <- setx(z.6, Petal.Length = 2:4, Species = "virginica")
z.6 <- sim(z.6, x = z.6a, x1 = z.6b)

head(zelig_qi_to_df(z.6))

}
\seealso{
\code{\link{qi_slimmer}}
}
\author{
Christopher Gandrud
}
