% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.r
\name{wald.test}
\alias{wald.test}
\title{Makes wald test}
\usage{
wald.test(
  object = NULL,
  coef = NULL,
  Sigma = NULL,
  vcov = NULL,
  contrast,
  coef.null = NULL,
  null = NULL,
  print.coef = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{object}{timereg object}

\item{coef}{estimates from some model}

\item{Sigma}{variance of estimates}

\item{vcov}{same as Sigma but more standard in other functions}

\item{contrast}{contrast matrix for testing}

\item{coef.null}{which indeces to test to 0}

\item{null}{mean of null, 0 by default}

\item{print.coef}{print the coefficients of the linear combinations.}

\item{alpha}{significance level for CI for linear combinations of
coefficients.}
}
\description{
Makes wald test, either by contrast matrix or testing components to 0. Can
also specify the regression coefficients and the variance matrix.  Also
makes confidence intervals of the defined contrasts.  Reads coefficientes
and variances from timereg and coxph objects.
}
\examples{

data(sTRACE)
# Fits Cox model 
out<-cox.aalen(Surv(time,status==9)~prop(age)+prop(sex)+
prop(vf)+prop(chf)+prop(diabetes),data=sTRACE,n.sim=0)

wald.test(out,coef.null=c(1,2,3))
### test age=sex   vf=chf
wald.test(out,contrast=rbind(c(1,-1,0,0,0),c(0,0,1,-1,0)))

### now same with direct specifation of estimates and variance
wald.test(coef=out$gamma,Sigma=out$var.gamma,coef.null=c(1,2,3))
wald.test(coef=out$gamma,Sigma=out$robvar.gamma,coef.null=c(1,2,3))
### test age=sex   vf=chf
wald.test(coef=out$gamma,Sigma=out$var.gamma,
	  contrast=rbind(c(1,-1,0,0,0),c(0,0,1,-1,0)))

}
\author{
Thomas Scheike
}
\keyword{survival}
