% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fov.R, R/molecules.R
\name{aggregate}
\alias{aggregate}
\alias{aggregate.FOV}
\alias{aggregate.Molecules}
\title{Aggregate Molecules into an Expression Matrix}
\usage{
\method{aggregate}{FOV}(x, by = NULL, set = NULL, drop = TRUE, ...)

\method{aggregate}{Molecules}(x, by, drop = TRUE, ...)
}
\arguments{
\item{x}{An object with spatially-resolved molecule information}

\item{by}{Name of a
\code{\link[SeuratObject:Segmentation-class]{Segmentation}} within
\code{object} or a
\code{\link[SeuratObject:Segmentation-class]{Segmentation}} object}

\item{set}{Name of molecule set to aggregate}

\item{drop}{Drop molecules not present in a segmentation; if \code{FALSE},
adds a column called \dQuote{\code{boundless}} consisting of molecule counts
not in a segmentation}

\item{...}{Arguments passed to other methods}
}
\value{
An expression matrix
}
\description{
Aggregate Molecules into an Expression Matrix
}
\section{Progress Updates with \pkg{progressr}}{

This function uses
\href{https://cran.r-project.org/package=progressr}{\pkg{progressr}} to
render status updates and progress bars. To enable progress updates, wrap
the function call in \code{\link[progressr]{with_progress}} or run
\code{\link[progressr:handlers]{handlers(global = TRUE)}} before running
this function. For more details about \pkg{progressr}, please read
\href{https://progressr.futureverse.org/articles/progressr-intro.html}{\code{vignette("progressr-intro")}}
}

\section{Parallelization with \pkg{future}}{

This function uses
\href{https://cran.r-project.org/package=future}{\pkg{future}} to enable
parallelization. Parallelization strategies can be set using
\code{\link[future]{plan}}. Common plans include \dQuote{\code{sequential}}
for non-parallelized processing or \dQuote{\code{multisession}} for parallel
evaluation using multiple \R sessions; for other plans, see the
\dQuote{Implemented evaluation strategies} section of
\code{\link[future:plan]{?future::plan}}. For a more thorough introduction
to \pkg{future}, see
\href{https://future.futureverse.org/articles/future-1-overview.html}{\code{vignette("future-1-overview")}}
}

\concept{future}
\keyword{internal}
