% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{html_encoding_guess}
\alias{html_encoding_guess}
\alias{guess_encoding}
\title{Guess faulty character encoding}
\usage{
html_encoding_guess(x)
}
\arguments{
\item{x}{A character vector.}
}
\description{
\code{html_encoding_guess()} helps you handle web pages that declare an incorrect
encoding. Use \code{html_encoding_guess()} to generate a list of possible
encodings, then try each out by using \code{encoding} argument of \code{read_html()}.
\code{html_encoding_guess()} replaces the deprecated \code{guess_encoding()}.
}
\examples{
# A file with bad encoding included in the package
path <- system.file("html-ex", "bad-encoding.html", package = "rvest")
x <- read_html(path)
x \%>\% html_elements("p") \%>\% html_text()

html_encoding_guess(x)
# Two valid encodings, only one of which is correct
read_html(path, encoding = "ISO-8859-1") \%>\% html_elements("p") \%>\% html_text()
read_html(path, encoding = "ISO-8859-2") \%>\% html_elements("p") \%>\% html_text()
}
