% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_sp_citation.R
\name{rl_sp_citation}
\alias{rl_sp_citation}
\alias{rl_sp_citation_}
\title{Get citations by taxon name, IUCN id, and region}
\usage{
rl_sp_citation(
  name = NULL,
  id = NULL,
  region = NULL,
  key = NULL,
  parse = TRUE,
  ...
)

rl_sp_citation_(name = NULL, id = NULL, region = NULL, key = NULL, ...)
}
\arguments{
\item{name}{(character) A taxonomic name}

\item{id}{(character) An IUCN identifier}

\item{region}{(character) A region name, see \code{\link{rl_regions}} for
acceptable region identifiers (use the entries in the \code{identifier}
column)}

\item{key}{A IUCN API token. See \code{\link{rl_use_iucn}}.}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\value{
A list, with the data in the \code{result} slot, unless using
a function with a trailing underscore, in which case json as character
string is returned.
}
\description{
Get citations by taxon name, IUCN id, and region
}
\examples{
\dontrun{
rl_sp_citation('Balaena mysticetus')
rl_sp_citation('Balaena mysticetus', region = 'europe')
rl_sp_citation(id = 12392)

rl_sp_citation(id = 2467, region = 'europe')
rl_sp_citation(id = 2467, region = 'europe', parse = FALSE)
rl_sp_citation_(id = 2467, region = 'europe')
}
}
\references{
API docs at \url{http://apiv3.iucnredlist.org/api/v3/docs}
}
