% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_occ_country.R, R/rl_search.R
\name{rl_occ_country_}
\alias{rl_occ_country_}
\alias{rl_search}
\alias{rl_search_}
\title{Search by taxon name, IUCN id, and region}
\usage{
rl_occ_country_(name = NULL, id = NULL, region = NULL, key = NULL, ...)

rl_search(name = NULL, id = NULL, region = NULL, key = NULL,
  parse = TRUE, ...)

rl_search_(name = NULL, id = NULL, region = NULL, key = NULL, ...)
}
\arguments{
\item{name}{(character) A taxonomic name}

\item{id}{(character) An IUCN identifier}

\item{region}{(character) A region name, see \code{\link{rl_regions}} for
acceptable region identifiers (use the entries in the \code{identifier}
column)}

\item{key}{A IUCN API token. See
\url{http://apiv3.iucnredlist.org/api/v3/token} to get a token}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}
}
\value{
A list, with the data in the \code{result} slot, unless using
a function with a trailing underscore, in which case json as character
string is returned.
}
\description{
Search by taxon name, IUCN id, and region
}
\examples{
\dontrun{
rl_search('Fratercula arctica')
rl_search('Fratercula arctica', region = 'europe')
rl_search(id = 12392)
rl_search(id = 22694927, region = 'europe')

rl_search('Fratercula arctica', parse = FALSE)
rl_search_('Fratercula arctica')
rl_search_('Fratercula arctica', region = 'europe')
}
}
\references{
API docs at \url{http://apiv3.iucnredlist.org/api/v3/docs}
}
