% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_analysis_base.R
\name{getConditionalRejectionProbabilities}
\alias{getConditionalRejectionProbabilities}
\title{Get Conditional Rejection Probabilities}
\usage{
getConditionalRejectionProbabilities(stageResults, ...)
}
\arguments{
\item{stageResults}{The results at given stage, obtained from \code{\link[=getStageResults]{getStageResults()}}.}

\item{...}{Further (optional) arguments to be passed:
\describe{
\item{\code{iterations}}{Iterations for simulating the conditional
rejection probabilities for Fisher's combination test.
For checking purposes, it can be estimated via simulation with
specified \code{iterations}.}
\item{\code{seed}}{Seed for simulating the conditional rejection probabilities
for Fisher's combination test. See above, default is a random seed.}
}}
}
\value{
Returns a \code{\link[base]{numeric}} vector of length \code{kMax} or in case of multi-arm stage results
a \code{\link[base]{matrix}} (each column represents a stage, each row a comparison)
containing the conditional rejection probabilities.
}
\description{
Calculates the conditional rejection probabilities (CRP) for given test results.
}
\details{
The conditional rejection probability is the probability, under H0, to reject H0
in one of the subsequent (remaining) stages.
The probability is calculated using the specified design. For testing rates and the
survival design, the normal approximation is used, i.e., it is calculated with the
use of the prototype case testing a mean for normally distributed data with known variance.

The conditional rejection probabilities are provided up to the specified stage.

For Fisher's combination test, you can check the validity of the CRP calculation via simulation.
}
\examples{
\dontrun{
# Calculate CRP for a Fisher's combination test design with
# two remaining stages and check the results by simulation.
design <- getDesignFisher(
    kMax = 4, alpha = 0.01,
    informationRates = c(0.1, 0.3, 0.8, 1)
)
data <- getDataset(n = c(40, 40), events = c(20, 22))
sr <- getStageResults(design, data, thetaH0 = 0.4)
getConditionalRejectionProbabilities(sr)
getConditionalRejectionProbabilities(sr,
    simulateCRP = TRUE,
    seed = 12345, iterations = 10000
)
}

}
\seealso{
Other analysis functions: 
\code{\link{getAnalysisResults}()},
\code{\link{getClosedCombinationTestResults}()},
\code{\link{getClosedConditionalDunnettTestResults}()},
\code{\link{getConditionalPower}()},
\code{\link{getFinalConfidenceInterval}()},
\code{\link{getFinalPValue}()},
\code{\link{getRepeatedConfidenceIntervals}()},
\code{\link{getRepeatedPValues}()},
\code{\link{getStageResults}()},
\code{\link{getTestActions}()}
}
\concept{analysis functions}
