% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_block_objects.R
\name{table_stylenames}
\alias{table_stylenames}
\title{Paragraph styles for columns}
\usage{
table_stylenames(stylenames = list())
}
\arguments{
\item{stylenames}{a named character vector, names are column names, values are
paragraph styles associated with each column. If a column is not
specified, default value 'Normal' is used.
Another form is as a named list, the list names are the styles
and the contents are column names to be formatted with the
corresponding style.}
}
\description{
The function defines the paragraph styles for columns.
}
\examples{
library(officer)

stylenames <- c(
  vs = "centered", am = "centered",
  gear = "centered", carb = "centered"
)

doc_1 <- read_docx()
doc_1 <- body_add_table(doc_1,
  value = mtcars, style = "table_template",
  stylenames = table_stylenames(stylenames = stylenames)
)

print(doc_1, target = tempfile(fileext = ".docx"))


stylenames <- list(
  "centered" = c("vs", "am", "gear", "carb")
)

doc_2 <- read_docx()
doc_2 <- body_add_table(doc_2,
  value = mtcars, style = "table_template",
  stylenames = table_stylenames(stylenames = stylenames)
)

print(doc_2, target = tempfile(fileext = ".docx"))
}
\seealso{
Other functions for table definition: 
\code{\link{prop_table}()},
\code{\link{table_colwidths}()},
\code{\link{table_conditional_formatting}()},
\code{\link{table_layout}()},
\code{\link{table_width}()}
}
\concept{functions for table definition}
