% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.R
\name{tune}
\alias{tune}
\title{Mark arguments for tuning}
\usage{
tune(id = "")
}
\arguments{
\item{id}{A single character value that can be used to differentiate
parameters that are used in multiple places but have the same name, or if
the user wants to add a note to the specified parameter.}
}
\value{
A call object that echos the user's input.
}
\description{
\code{tune()} is an argument placeholder to be used with the recipes, parsnip, and
tune packages. It marks recipes step and parsnip model arguments for tuning.
}
\examples{
\dontshow{if (rlang::is_installed(c("recipes"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tune()
tune("your name here")

# In practice, `tune()` is used alongside recipes or parsnip to mark
# specific arguments for tuning
library(recipes)

recipe(mpg ~ ., data = mtcars) \%>\%
  step_normalize(all_numeric_predictors()) \%>\%
  step_pca(all_numeric_predictors, num_comp = tune())
\dontshow{\}) # examplesIf}
}
\seealso{
\code{tune::tune_grid()}, \code{tune::tune_bayes()}
}
