% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{autoplot.acf}
\alias{autoplot.acf}
\alias{ggAcf}
\alias{ggPacf}
\alias{ggCcf}
\alias{autoplot.mpacf}
\alias{ggtaperedacf}
\alias{ggtaperedpacf}
\title{ggplot (Partial) Autocorrelation and Cross-Correlation Function Estimation
and Plotting}
\usage{
\method{autoplot}{acf}(object, ci = 0.95, ...)

ggAcf(
  x,
  lag.max = NULL,
  type = c("correlation", "covariance", "partial"),
  plot = TRUE,
  na.action = na.contiguous,
  demean = TRUE,
  ...
)

ggPacf(
  x,
  lag.max = NULL,
  plot = TRUE,
  na.action = na.contiguous,
  demean = TRUE,
  ...
)

ggCcf(
  x,
  y,
  lag.max = NULL,
  type = c("correlation", "covariance"),
  plot = TRUE,
  na.action = na.contiguous,
  ...
)

\method{autoplot}{mpacf}(object, ...)

ggtaperedacf(
  x,
  lag.max = NULL,
  type = c("correlation", "partial"),
  plot = TRUE,
  calc.ci = TRUE,
  level = 95,
  nsim = 100,
  ...
)

ggtaperedpacf(x, ...)
}
\arguments{
\item{object}{Object of class \dQuote{\code{acf}}.}

\item{ci}{coverage probability for confidence interval. Plotting of the
confidence interval is suppressed if ci is zero or negative.}

\item{...}{Other plotting parameters to affect the plot.}

\item{x}{a univariate or multivariate (not Ccf) numeric time series object
or a numeric vector or matrix.}

\item{lag.max}{maximum lag at which to calculate the acf.}

\item{type}{character string giving the type of acf to be computed. Allowed
values are "\code{correlation}" (the default), \dQuote{\code{covariance}} or
\dQuote{\code{partial}}.}

\item{plot}{logical. If \code{TRUE} (the default) the resulting ACF, PACF or
CCF is plotted.}

\item{na.action}{function to handle missing values. Default is
\code{\link[stats]{na.contiguous}}.  Useful alternatives are
\code{\link[stats]{na.pass}} and \code{\link{na.interp}}.}

\item{demean}{Should covariances be about the sample means?}

\item{y}{a univariate numeric time series object or a numeric vector.}

\item{calc.ci}{If \code{TRUE}, confidence intervals for the ACF/PACF
estimates are calculated.}

\item{level}{Percentage level used for the confidence intervals.}

\item{nsim}{The number of bootstrap samples used in estimating the
confidence intervals.}
}
\value{
A ggplot object.
}
\description{
Produces a ggplot object of their equivalent Acf, Pacf, Ccf, taperedacf and
taperedpacf functions.
}
\details{
If \code{autoplot} is given an \code{acf} or \code{mpacf} object, then an
appropriate ggplot object will be created.

ggtaperedpacf
}
\examples{

library(ggplot2)
ggAcf(wineind)
wineind \%>\% Acf(plot=FALSE) \%>\% autoplot
\dontrun{
wineind \%>\% taperedacf(plot=FALSE) \%>\% autoplot
ggtaperedacf(wineind)
ggtaperedpacf(wineind)}
ggCcf(mdeaths, fdeaths)

}
\seealso{
\code{\link[stats]{plot.acf}}, \code{\link{Acf}},
\code{\link[stats]{acf}}, \code{\link{taperedacf}}
}
\author{
Mitchell O'Hara-Wild
}
