% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{tabs_as_spaces}
\alias{tabs_as_spaces}
\title{Replace Tabs With Spaces}
\usage{
tabs_as_spaces(x, tab.stops = getOption("fansi.tab.stops"),
  warn = getOption("fansi.warn"), ctl = "all")
}
\arguments{
\item{x}{character vector or object coercible to character; any tabs therein
will be replaced.}

\item{tab.stops}{integer(1:n) indicating position of tab stops to use
when converting tabs to spaces.  If there are more tabs in a line than
defined tab stops the last tab stop is re-used.  For the purposes of
applying tab stops, each input line is considered a line and the character
count begins from the beginning of the input line.}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \link{fansi}).}

\item{ctl}{character, which \emph{Control Sequences} should be treated
specially. See the "_ctl vs. _sgr" section for details.
\itemize{
\item "nl": newlines.
\item "c0": all other "C0" control characters (i.e. 0x01-0x1f, 0x7F), except
for newlines and the actual ESC (0x1B) character.
\item "sgr": ANSI CSI SGR sequences.
\item "csi": all non-SGR ANSI CSI sequences.
\item "esc": all other escape sequences.
\item "all": all of the above, except when used in combination with any of the
above, in which case it means "all but".
}}
}
\value{
character, \code{x} with tabs replaced by spaces, with elements
possibly converted to UTF-8.
}
\description{
Finds horizontal tab characters (0x09) in a string and replaces them with the
spaces that produce the same horizontal offset.
}
\details{
Since we do not know of a reliable cross platform means of detecting tab
stops you will need to provide them yourself if you are using anything
outside of the standard tab stop every 8 characters that is the default.
}
\note{
Non-ASCII strings are converted to and returned in UTF-8 encoding.  The
\code{ctl} parameter only affects which \emph{Control Sequences} are considered zero
width.  Tabs will always be converted to spaces, irrespective of the \code{ctl}
setting.
}
\examples{
string <- '1\\t12\\t123\\t1234\\t12345678'
tabs_as_spaces(string)
writeLines(
  c(
    '-------|-------|-------|-------|-------|',
    tabs_as_spaces(string)
) )
writeLines(
  c(
    '-|--|--|--|--|--|--|--|--|--|--|',
    tabs_as_spaces(string, tab.stops=c(2, 3))
) )
writeLines(
  c(
    '-|--|-------|-------|-------|',
    tabs_as_spaces(string, tab.stops=c(2, 3, 8))
) )
}
\seealso{
\link{fansi} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results.
}
