% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-weekday.R
\name{year-month-weekday-arithmetic}
\alias{year-month-weekday-arithmetic}
\alias{add_years.clock_year_month_weekday}
\alias{add_quarters.clock_year_month_weekday}
\alias{add_months.clock_year_month_weekday}
\title{Arithmetic: year-month-weekday}
\usage{
\method{add_years}{clock_year_month_weekday}(x, n, ...)

\method{add_quarters}{clock_year_month_weekday}(x, n, ...)

\method{add_months}{clock_year_month_weekday}(x, n, ...)
}
\arguments{
\item{x}{\verb{[clock_year_month_weekday]}

A year-month-weekday vector.}

\item{n}{\verb{[integer / clock_duration]}

An integer vector to be converted to a duration, or a duration
corresponding to the arithmetic function being used. This corresponds
to the number of duration units to add. \code{n} may be negative to subtract
units of duration.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{x} after performing the arithmetic.
}
\description{
These are year-month-weekday methods for the
\link[=clock-arithmetic]{arithmetic generics}.
\itemize{
\item \code{add_years()}
\item \code{add_quarters()}
\item \code{add_months()}
}

Notably, \emph{you cannot add days to a year-month-weekday}. For day-based
arithmetic, first convert to a time point with \code{\link[=as_naive_time]{as_naive_time()}} or
\code{\link[=as_sys_time]{as_sys_time()}}.
}
\details{
Adding a single quarter with \code{add_quarters()} is equivalent to adding
3 months.

\code{x} and \code{n} are recycled against each other using
\link[vctrs:vector_recycling_rules]{tidyverse recycling rules}.
}
\examples{
# 2nd Friday in January, 2019
x <- year_month_weekday(2019, 1, clock_weekdays$friday, 2)
x

add_months(x, 1:5)

# These don't necessarily correspond to the same day of the month
as_year_month_day(add_months(x, 1:5))
}
