% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clock-codes.R
\docType{data}
\name{clock-codes}
\alias{clock-codes}
\alias{clock_months}
\alias{clock_weekdays}
\alias{clock_iso_weekdays}
\title{Integer codes}
\format{
\itemize{
\item \code{clock_months}: An environment containing month codes.
}

\itemize{
\item \code{clock_weekdays}: An environment containing weekday codes.
}

\itemize{
\item \code{clock_iso_weekdays}: An environment containing ISO weekday codes.
}
}
\usage{
clock_months

clock_weekdays

clock_iso_weekdays
}
\description{
Objects with useful mappings from month names and weekday names
to integer codes.
\subsection{Month codes (\code{clock_months})}{
\itemize{
\item \code{january == 1}
\item \code{february == 2}
\item \code{march == 3}
\item \code{april == 4}
\item \code{may == 5}
\item \code{june == 6}
\item \code{july == 7}
\item \code{august == 8}
\item \code{september == 9}
\item \code{october == 10}
\item \code{november == 11}
\item \code{december == 12}
}
}

\subsection{Weekday codes (\code{clock_weekdays})}{
\itemize{
\item \code{sunday == 1}
\item \code{monday == 2}
\item \code{tuesday == 3}
\item \code{wednesday == 4}
\item \code{thursday == 5}
\item \code{friday == 6}
\item \code{saturday == 7}
}
}

\subsection{ISO weekday codes (\code{clock_iso_weekdays})}{
\itemize{
\item \code{monday == 1}
\item \code{tuesday == 2}
\item \code{wednesday == 3}
\item \code{thursday == 4}
\item \code{friday == 5}
\item \code{saturday == 6}
\item \code{sunday == 7}
}
}
}
\examples{
weekday(clock_weekdays$wednesday)

year_month_weekday(2019, clock_months$april, clock_weekdays$monday, 1:4)

year_week_day(2020, 52, start = clock_weekdays$monday)

iso_year_week_day(2020, 52, clock_iso_weekdays$thursday)
}
\keyword{datasets}
