% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstanarm_tidiers.R
\name{rstanarm_tidiers}
\alias{rstanarm_tidiers}
\alias{tidy.stanreg}
\alias{glance.stanreg}
\title{Tidying methods for an rstanarm model}
\usage{
\method{tidy}{stanreg}(x, parameters = "non-varying", intervals = FALSE,
  prob = 0.9, ...)

\method{glance}{stanreg}(x, looic = FALSE, ...)
}
\arguments{
\item{x}{Fitted model object from the \pkg{rstanarm} package. See 
\code{\link[rstanarm]{stanreg-objects}}.}

\item{parameters}{One or more of \code{"non-varying"}, \code{"varying"}, 
\code{"hierarchical"}, \code{"auxiliary"} (can be abbreviated). See the
Value section for details.}

\item{intervals}{If \code{TRUE} columns for the lower and upper bounds of the
\code{100*prob}\% posterior uncertainty intervals are included. See 
\code{\link[rstanarm]{posterior_interval}} for details.}

\item{prob}{See \code{\link[rstanarm]{posterior_interval}}.}

\item{...}{For \code{glance}, if \code{looic=TRUE}, optional arguments to 
\code{\link[rstanarm]{loo.stanreg}}.}

\item{looic}{Should the LOO Information Criterion (and related info) be
included? See \code{\link[rstanarm]{loo.stanreg}} for details. Note: for
models fit to very large datasets this can be a slow computation.}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

When \code{parameters="non-varying"} (the default), \code{tidy.stanreg} returns
one row for each coefficient, with three columns:
\item{term}{The name of the corresponding term in the model.}
\item{estimate}{A point estimate of the coefficient (posterior median).}
\item{std.error}{A standard error for the point estimate based on
\code{\link[stats]{mad}}. See the \emph{Uncertainty estimates} section in 
\code{\link[rstanarm]{print.stanreg}} for more details.}

For models with group-specific parameters (e.g., models fit with 
\code{\link[rstanarm]{stan_glmer}}), setting \code{parameters="varying"} 
selects the group-level parameters instead of the non-varying regression 
coefficients. Addtional columns are added indicating the \code{level} and 
\code{group}. Specifying \code{parameters="hierarchical"} selects the 
standard deviations and (for certain models) correlations of the group-level 
parameters.

Setting \code{parameters="auxiliary"} will select parameters other than those
included by the other options. The particular parameters depend on which 
\pkg{rstanarm} modeling function was used to fit the model. For example, for 
models fit using \code{\link[rstanarm]{stan_glm.nb}} the overdispersion 
parameter is included if \code{parameters="aux"}, for 
\code{\link[rstanarm]{stan_lm}} the auxiliary parameters include the residual
SD, R^2, and log(fit_ratio), etc.

If \code{intervals=TRUE}, columns for the \code{lower} and \code{upper} 
values of the posterior intervals computed with 
\code{\link[rstanarm]{posterior_interval}} are also included.

\code{glance} returns one row with the columns
  \item{algorithm}{The algorithm used to fit the model.}
  \item{pss}{The posterior sample size (except for models fit using 
  optimization).}
  \item{nobs}{The number of observations used to fit the model.}
  \item{sigma}{The square root of the estimated residual variance, if
  applicable. If not applicable (e.g., for binomial GLMs), \code{sigma} will
  be given the value \code{1} in the returned object.}
  
  If \code{looic=TRUE}, then the following additional columns are also
  included:
  \item{looic}{The LOO Information Criterion.}
  \item{elpd_loo}{The expected log predictive density (\code{elpd_loo = -2 *
  looic}).}
  \item{p_loo}{The effective number of parameters.}
}
\description{
These methods tidy the estimates from \code{\link[rstanarm]{stanreg-objects}}
(fitted model objects from the \pkg{rstanarm} package) into a summary.
}
\examples{

\dontrun{
fit <- stan_glmer(mpg ~ wt + (1|cyl) + (1+wt|gear), data = mtcars, 
                  iter = 300, chains = 2)
# non-varying ("population") parameters
tidy(fit, intervals = TRUE, prob = 0.5)

# hierarchical sd & correlation parameters
tidy(fit, parameters = "hierarchical")

# group-specific deviations from "population" parameters
tidy(fit, parameters = "varying")

# glance method
glance(fit)
glance(fit, looic = TRUE, cores = 1)
}
 
}
\seealso{
\code{\link[rstanarm]{summary.stanreg}}
}
