% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivreg_tidiers.R
\name{ivreg_tidiers}
\alias{ivreg_tidiers}
\alias{tidy.ivreg}
\alias{augment.ivreg}
\alias{glance.ivreg}
\title{Tidiers for ivreg models}
\usage{
\method{tidy}{ivreg}(x, conf.int = FALSE, conf.level = 0.95,
  exponentiate = FALSE, ...)

\method{augment}{ivreg}(x, data = as.data.frame(stats::model.frame(x)),
  newdata, ...)

\method{glance}{ivreg}(x, diagnostics = FALSE, ...)
}
\arguments{
\item{x}{An "ivreg" object}

\item{conf.int}{Whether to include a confidence interval}

\item{conf.level}{Confidence level of the interval, used only if
\code{conf.int=TRUE}}

\item{exponentiate}{Whether to exponentiate the coefficient estimates
and confidence intervals}

\item{...}{extra arguments, not used}

\item{data}{Original dataset}

\item{newdata}{New data to make predictions from (optional)}

\item{diagnostics}{Logical. Return results of diagnostic tests.}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy.ivreg} returns a data frame with one row per
coefficient, of the same form as \code{\link{tidy.lm}}.

\code{augment} returns a data frame with one row for each
initial observation, adding the columns:
  \item{.fitted}{predicted (fitted) values}
and if \code{newdata} is \code{NULL}:
  \item{.resid}{residuals}

\code{glance} returns a one-row data frame with columns
  \item{r.squared}{The percent of variance explained by the model}
  \item{adj.r.squared}{r.squared adjusted based on the degrees of freedom}
  \item{statistic}{Wald test statistic}
  \item{p.value}{p-value from the Wald test}
  \item{df}{Degrees of freedom used by the coefficients}
  \item{sigma}{The square root of the estimated residual variance}
  \item{df.residual}{residual degrees of freedom}
If \code{diagnostics} is \code{TRUE}, \code{glance} also returns:
  \item{p.value.Sargan}{P value of Sargan test}
  \item{p.value.Wu.Hausman}{P value of Wu-Hausman test}
  \item{p.value.weakinst}{P value of weak instruments test}
}
\description{
Tidiers for ivreg models
}
\examples{

if (require("AER", quietly = TRUE)) {
    data("CigarettesSW", package = "AER")
    CigarettesSW$rprice <- with(CigarettesSW, price/cpi)
    CigarettesSW$rincome <- with(CigarettesSW, income/population/cpi)
    CigarettesSW$tdiff <- with(CigarettesSW, (taxs - tax)/cpi)
    ivr <- ivreg(log(packs) ~ log(rprice) + log(rincome) | log(rincome) + tdiff + I(tax/cpi),
          data = CigarettesSW, subset = year == "1995")
    
    summary(ivr)
    
    tidy(ivr)
    tidy(ivr, conf.int = TRUE)
    tidy(ivr, conf.int = TRUE, exponentiate = TRUE)
    
    head(augment(ivr))
    
    glance(ivr)
}

}
\seealso{
\code{\link{lm_tidiers}}
}
