% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{class}
\name{topmod-class}
\alias{topmod-class}
\title{Class "topmod"}
\description{
An updateable list keeping the best x models it encounters in any kind of
model iteration
}
\section{Objects from the Class}{
 Objects can be created by calls to
\code{\link{topmod}}, or indirectly by calls to \code{\link{bms}}.\cr

A 'topmod' object (as created by \code{topmod}) holds three basic vectors:
\code{lik} (for the (log) likelihood of models or similar), \code{bool()}
for a hexcode presentation of the model binaries (cf. \code{\link{bin2hex}})
and ncount() for the times the models have been drawn.\cr All these vectors
are sorted descendantly by \code{lik}, and are of the same length. The
maximum length is limited by the argument \code{nbmodels}.

If \code{tmo} is a topmod object, then a call to \code{tmo$addmodel} (e.g.
\code{tmo$addmodel(mylik=4,vec01=c(T,F,F,T))} updates the object \code{tmo}
by a model represented by \code{vec01} (here the one including the first and
fourth regressor) and the marginal (log) likelihood \code{lik} (here: 4).\cr
If this model is already part of \code{tmo}, then its respective
\code{ncount} entry is incremented by one; else it is inserted into a
position according to the ranking of \code{lik}.\cr In addition, there is
the possibility to save (the first moments of) coefficients of a model
(\code{betas}) and their second moments (\code{betas2}), as well as an
arbitrary vector of statistics per model (\code{fixed_vector}).\cr
}

\examples{

  tm= topmod(2,4,TRUE,0) #should keep a  maximum two models
  tm$addmodel(-2.3,c(1,1,1,1),1:4,5:8) #update with some model
  tm$addmodel(-2.2,c(0,1,1,1),1:3,5:7) #add another model
  tm$addmodel(-2.2,c(0,1,1,1),1:3,5:7) #add it again -> adjust ncount
  tm$addmodel(-2.5,c(1,0,0,1),1:2,5:6) #add another model
  
  #read out
  tm$lik()
  tm$ncount()
  tm$bool_binary()
  tm$betas()

}
\references{
\url{http://bms.zeugner.eu}
}
\seealso{
\code{\link{topmod}} to create \code{topmod} objects and a more
detailed description,
\code{\link{is.topmod}} to test for this class
}
\author{
Martin Feldkircher and Stefan Zeugner
}
\keyword{classes}
