% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_dmDSfit.R
\docType{class}
\name{dmDSfit-class}
\alias{dmDSfit-class}
\alias{design,dmDSfit-method}
\alias{proportions}
\alias{proportions,dmDSfit-method}
\alias{coefficients,dmDSfit-method}
\title{dmDSfit object}
\usage{
\S4method{design}{dmDSfit}(object, type = "full_model")

proportions(x, ...)

\S4method{proportions}{dmDSfit}(x)

\S4method{coefficients}{dmDSfit}(object, level = "gene")
}
\arguments{
\item{type}{Character indicating which design matrix should be returned.
Possible values \code{"precision"}, \code{"full_model"} or
\code{"null_model"}.}

\item{x, object}{dmDSprecision object.}

\item{...}{Other parameters that can be defined by methods using this 
generic.}

\item{level}{Character specifying which type of results to return. Possible
values \code{"gene"} or \code{"feature"}.}
}
\value{
\itemize{ \item \code{design(object)}: Get a matrix with the full design.
\item \code{proportions(x)}: Get a data frame with estimated feature ratios
for each sample. \item \code{coefficients(x)}: Get the DM or BB regression
coefficients. }
}
\description{
dmDSfit extends the \code{\linkS4class{dmDSprecision}} class by adding the 
full model Dirichlet-multinomial (DM) and beta-binomial (BB) likelihoods, 
regression coefficients and feature proportion estimates. Result of calling 
the \code{\link{dmFit}} function.
}
\section{Slots}{

\describe{
\item{\code{design_fit_full}}{Numeric matrix of the design used to fit the full 
model.}

\item{\code{fit_full}}{\code{\linkS4class{MatrixList}} containing estimated feature 
ratios in each sample based on the full Dirichlet-multinomial (DM) model.}

\item{\code{lik_full}}{Numeric vector of the per gene DM full model likelihoods.}

\item{\code{coef_full}}{\code{\linkS4class{MatrixList}} with the regression 
coefficients based on the DM model.}

\item{\code{fit_full_bb}}{\code{\linkS4class{MatrixList}} containing estimated 
feature ratios in each sample based on the full beta-binomial (BB) model.}

\item{\code{lik_full_bb}}{Numeric vector of the per gene BB full model likelihoods.}

\item{\code{coef_full_bb}}{\code{\linkS4class{MatrixList}} with the regression 
coefficients based on the BB model.}
}}

\examples{
# --------------------------------------------------------------------------
# Create dmDSdata object 
# --------------------------------------------------------------------------
## Get kallisto transcript counts from the 'PasillaTranscriptExpr' package

library(PasillaTranscriptExpr)
\donttest{
data_dir  <- system.file("extdata", package = "PasillaTranscriptExpr")

## Load metadata
pasilla_metadata <- read.table(file.path(data_dir, "metadata.txt"), 
header = TRUE, as.is = TRUE)

## Load counts
pasilla_counts <- read.table(file.path(data_dir, "counts.txt"), 
header = TRUE, as.is = TRUE)

## Create a pasilla_samples data frame
pasilla_samples <- data.frame(sample_id = pasilla_metadata$SampleName, 
  group = pasilla_metadata$condition)
levels(pasilla_samples$group)

## Create a dmDSdata object
d <- dmDSdata(counts = pasilla_counts, samples = pasilla_samples)

## Use a subset of genes, which is defined in the following file
gene_id_subset <- readLines(file.path(data_dir, "gene_id_subset.txt"))

d <- d[names(d) \%in\% gene_id_subset, ]

# --------------------------------------------------------------------------
# Differential transcript usage analysis - simple two group comparison 
# --------------------------------------------------------------------------

## Filtering
## Check what is the minimal number of replicates per condition 
table(samples(d)$group)

d <- dmFilter(d, min_samps_gene_expr = 7, min_samps_feature_expr = 3,
  min_gene_expr = 10, min_feature_expr = 10)

plotData(d)

## Create the design matrix
design_full <- model.matrix(~ group, data = samples(d))

## To make the analysis reproducible
set.seed(123)
## Calculate precision
d <- dmPrecision(d, design = design_full)

plotPrecision(d)

head(mean_expression(d))
common_precision(d)
head(genewise_precision(d))

## Fit full model proportions
d <- dmFit(d, design = design_full)

## Get fitted proportions
head(proportions(d))
## Get the DM regression coefficients (gene-level) 
head(coefficients(d))
## Get the BB regression coefficients (feature-level) 
head(coefficients(d), level = "feature")
}
}
\seealso{
\code{\linkS4class{dmDSdata}}, \code{\linkS4class{dmDSprecision}}, 
  \code{\linkS4class{dmDStest}}
}
\author{
Malgorzata Nowicka
}
