#ifndef GALLERYWIDGET_H
#define GALLERYWIDGET_H

#include <QWidget>

class imageViewer;

#define NUMTHUMBS 12

namespace Ui {
    class galleryWidget;
}

class galleryWidget : public QWidget
{
    Q_OBJECT

public:
    explicit galleryWidget(QWidget *parent = 0);
    ~galleryWidget();

  void init();
  void writeSettings();
  void readSettings();
  void putRxImage(QString fn);
  QString getTemplateFileName(int);
  const QStringList &getFilenames();
  QString getLastRxImage();

public slots:
    void slotLayoutChanged();


private:
    Ui::galleryWidget *ui;
    void initView();
    void shuffle(imageViewer *ar[],int &idx);
    imageViewer *rxThumbsArray[NUMTHUMBS];
    imageViewer *txThumbsArray[NUMTHUMBS];
    imageViewer *templateThumbsArray[NUMTHUMBS];
    int rxIndex;
    QStringList sl;
};

#endif // GALLERYWIDGET_H
