# Should work on most rpm based distros. Package names might differ here and there.
# Tested on RHEL7/CentOS7/RHEL8, make sure epel repository is enabled.
Name:          qiv
Version:       3.0.2
Release:       1
Summary:       A quick image viewer for X
Source0:       http://spiegl.de/qiv/download/%{name}-%{version}.tar.gz
License:       GPL
Url:           http://spiegl.de/qiv/

BuildRoot:     %{_tmppath}/%{name}-%{version}-%{release}-buildroot

BuildRequires: gtk3-devel
BuildRequires: libexif-devel
BuildRequires: file-devel
BuildRequires: pkgconfig
BuildRequires: lcms2-devel
BuildRequires: libtiff-devel
# This has most likely to be another jpeg package on distros other than RHEL/CentOS
BuildRequires: libjpeg-turbo-devel

Requires:      gtk3
Requires:      libexif
Requires:      file
Requires:      lcms2

Group:         Graphics

%description
Quick Image Viewer (qiv) is a very small and pretty fast GDK image
viewer. Features include zoom, maxpect, scale down, fullscreen,
brightness/contrast/gamma correction, slideshow, pan with keyboard and mouse,
rotate left/right, flip, delete (move to .qiv-trash/), jump to image x, jump
forward/backward x images, filename filter, and you can use qiv to set your
X11-Desktop background. With multi monitor support.

qiv also supports the assignment of external commands (like metacam) to unused
keys.
%global debug_package %{nil}
%prep
%setup -q -n %{name}-%{version}

%build
make CFLAGS="$RPM_OPT_FLAGS"

%install
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT/{%{_bindir},%{_mandir}/man1}

DISPLAY="" make PREFIX=$RPM_BUILD_ROOT%{_prefix} install
# Hmm. Any better ideas how to achieve this?
mkdir -p  %{_builddir}/%{name}-%{version}/examples/
cp -p %{_builddir}/%{name}-%{version}/contrib/gps2url.py %{_builddir}/%{name}-%{version}/examples
cp -p %{_builddir}/%{name}-%{version}/contrib/qiv-command.example %{_builddir}/%{name}-%{version}/examples/qiv-command

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc README Changelog README.COPYING README.INSTALL intro.jpg examples
%{_bindir}/qiv
%{_mandir}/man1/qiv.1*
%{_prefix}/share/applications/qiv.desktop
%{_prefix}/share/pixmaps/qiv.png

%changelog
* Wed Apr 23 2025 Thomas Wiegner <wiegner@gmx.de> - 3.0.2
- Update to 3.0.2
  + [tw] Set gdk backend to X11
  + [tw] Fix setting desktop image
  + [tw] Bring back background colour setting for fullscreen
         Fix small issue on fullscreen background painting
         Minor cleanup
  + [tw] Bring back gamma/brightness/contrast adjustments
  + [tw] Fix magnify window being empty on initial appearance
  + [tw] Replace some deprecated functions for gdk3 build
  + [tw] Fix compilation problem with newer gdk3 versions
         (fixes issue #2, patch by arenevier)
  + [tw] Migration to GDK3.
  + [tw] Intermediate version. Remove imlib2, use gdk2/gdkpixbuf
         for image handling.

* Mon Mar 3 2025 Thomas Wiegner <wiegner@gmx.de> - 2.3.4
- Update to 2.3.4
  + [tw] minor cleanup and gcc-15 fixes (debian #1097695)
  + [tw] add heic and webp entries to desktop and mime file
  + [tw] Correct libwmf-gtk recommends, remove "-l" from desktop file,
         increase debhelper compat level to 7
  + [tw] fix possible segfault on corrupt color profiles (Gabriel Vlasiu)
  + [as] qiv-command example: added more interesting tags in exiftool.tags.for.qiv-command
  + [as] qiv-command example: added gps2url and gimp
  + [tw] allow --help and --version without DISPLAY variable set
  + [tw] scale fonts according to highDPIfactor
  + [tw] fix some deprecation warnings
  + [as] fix small bug with --highDPIfactor and --scale_down
         and images smaller than screen size before enlarging
         but bigger than screensaver after enlarging
  + [as] new cmdline option --highDPIfactor: zoom factor to compensate for high (or also low) DPI screens
  + [as] statusline+window title: move not so interesting loading time to the end
  + [as] fix removing artist/comment text in fullscreen mode
  + [as] add ability (and options and toggles) to display EXIF artist name
  + [tw] add heif image support via gdk-pixbuf loader
         add example in qiv-command on how to run programs without blocking qiv
  + [tw] add webp support via imlib loader (Ralf Hoffmann)
  + [tw] fix wrong man path, fix clang-10 compiler warning, include debian #969338
  + [as] zoom in faster (+50% instead of +10%) if above 100%
  + [as] redefined GDK_SCROLL events to move image in fullscreen
  + [tw] replace deprecated gdk_draw functions with cairo functions
  + [tw] fix: don't ignore maxaspect and scale down options when
         reloading image due to watch option on. (Issue #8)

* Tue Oct 10 2017 Thomas Wiegner <wiegner@gmx.de> - 2.3.2
- qiv changes since v2.3.1:
  + [tw] fix: window sometimes recentered, when moved around with mouse
  + [as] fix Makefile for cross-compiling: Make pkg-config substitutable (Debian Bug#879108)
  + [tw] add specfile to build rpm for CentOS
  + [tw] add option --trashbin to use trash bin instead
         of .qiv-trash when deleting images
  + [as] add ability (and options) to display JPEG comments
  + [as] more sophisticated exiftool call in qiv-command example
  + [tw] fix inconsistent fixed-zoom behaviour
  + [tw] Don't try to rotate if file is not an image
  + [tw] get rid of some more XID collisions
  + [tw] Fix occasionally erratic behaviour of qiv statusbar
  + [tw] Fix xpm autodetection with libmagic
  + [tw] Fix small artefacts in pictures which might happen when
         running remote over slow link (patch by Derek Schrock)
  + [tw] update image after it is exposed in window mode
  + [js/tw] fix broken "-no-filter" option
            libmagic filter now works on symlinks
  + [tw] fix linking order in "make debug", did not
         work in some newer gcc versions
  + [as] turn on EXIF autorotation by default
  + [tw] Add option to sort files by modification time.
         (patch by Stefan Rüger)
  + [tw] In case of "watch" option, check image only every 1/10 sec,
         instead of every 200us. This was way too short for
         devices like RasPi etc. (Hamish)
  + [tw] Leave jumping mode on invalid input and process input key
         as if it was entered in non jumping mode (Sergey Pinaev)

