/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef STATUSEDITWGT_H
#define STATUSEDITWGT_H

#include <QWidget>
#include <QToolButton>
#include <QGridLayout>
#include <QComboBox>
#include <QLineEdit>
#include <QEvent>
#include <QMenu>

#include "userinfo.h"
#include "qchatsettings.h"

/**
        @author Anistratov Oleg <ower@users.sourceforge.net>
*/
class StatusEditWgt : public QWidget
{
  Q_OBJECT
  private:
   QGridLayout* m_grid;
   QToolButton* m_editStatusBtn;
   QLineEdit*   m_statusEdit;
   QComboBox*   m_statusCmbx;
   QMenu*       m_descriptionsMenu;
   QString      m_lastText;
   QString      m_description;

  public:
    StatusEditWgt(QWidget *parent = 0);
    ~StatusEditWgt(){};

    void retranslate();

    int status () const {return m_statusCmbx->itemData(m_statusCmbx->currentIndex()).toUInt();}
    void setStatus(int s){m_statusCmbx->setCurrentIndex(s);}
    const QString & description() const {return m_description;}

  public slots:
    void slot_setStatusDescription(const QString & d)
    {m_description = d; UserInfo::myInfo()->setStatusDescription(d); QChatSettings::settings()->setStatusDescription(d, status());}

    void slot_statusChanged       ();
    void showDescriptionsMenu     ();
    void setDescription(QAction*);
    void hideEditor();
    void slot_editStatusClicked();
    void changeStatus();

  protected:
    void changeEvent(QEvent *ev)
    {
      if(ev->type() == QEvent::LanguageChange)
        retranslate();
      else
        QWidget::changeEvent(ev);
    }

  signals:
    void statusChanged();
    void statusDescriptionChanged();
    void editing();
};

#endif
