//
// C++ Implementation: qtscriptPrg
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "qtscript_prg.hpp"

#include <main.h>
#include "scripting.hpp"
#include "scriptprg.hpp"
#include "messages.hpp"


qtscriptPrg::qtscriptPrg(const QString & program , const int thisid)
 : scriptPrg()
{
     isupdate=1;
     prgname = program;
#ifdef USE_SCRIPT_DEBUGGER
    debugger.attachTo(&engine);
    QMainWindow *debugWindow = debugger.standardWindow();
    debugWindow->resize(1024, 640);
#endif
     ScriptApi=QcakeScriptApi::theInstance();
     QScriptValue objectValue = engine.newQObject(ScriptApi);
     engine.globalObject().setProperty("QCakeApi", objectValue);
     engine.globalObject().setProperty("QCakeID", thisid);
}


qtscriptPrg::~qtscriptPrg()
{
}

int qtscriptPrg::compile(void)
{
  return run();
}

int qtscriptPrg::run(void)
{
 if(on==1){
    // load the standard js qcake library
    if(runFile(g_prjpath + "/data/js_stdlib.js","js_stdlib.js", FALSE)){
        return 1;
    }
    QFileInfo filename(prgname);
    if(runFile(prgname, filename.fileName(), g_debug)){
        return 1;
    }
    QScriptValue handler = engine.evaluate("function() { update(); }");
    qScriptConnect(this, SIGNAL(scr_update()), QScriptValue(), handler);
    isupdate=0;
  }
  return 0;
}

int qtscriptPrg::runFile(const QString &prgfile, const QString &name, bool debug)
{
  QFile scriptFile(prgfile);
  scriptFile.open(QIODevice::ReadOnly);
  #ifdef USE_SCRIPT_DEBUGGER
  if(debug == TRUE) {
    debugger.action(QScriptEngineDebugger::InterruptAction)->trigger();
  }
#endif
  QScriptValue result = engine.evaluate(scriptFile.readAll(),name);
  if (engine.hasUncaughtException()) {
     int line = engine.uncaughtExceptionLineNumber();
     qDebug() << prgfile << ":uncaught exception at line " << line << ":" << result.toString();
     QString msg;
     QTextStream(&msg) << prgfile << ":uncaught exception at line " << line << ":" << result.toString() << "\n";
     ErrorMsg errormsg(msg);
     scriptFile.close();
     return 1;
  }
  scriptFile.close();
  return 0;
}

void qtscriptPrg::update(void)
{
 if(on==1){
     isupdate++;
     if(isupdate == 1){
         emit scr_update();
     }
     isupdate--;
 }
}
