//
// C++ Implementation: CProjectEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CProjectEdit.hpp"

CProjectEditDlg::CProjectEditDlg( QWidget * parent)
: CQcakeDlg(parent)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));
   connect(ui.text, SIGNAL(textChanged(const QString)), this, SLOT(slotEditText(const QString)));
   connect(ui.path, SIGNAL(lostFocus()), this, SLOT(slotEditPath()));
   connect(ui.toolButton1, SIGNAL(clicked()), this, SLOT(slotEditPathDir()));

   tmppath = QDir::homePath () + '/';
   ui.path->setText( tmppath ) ;
   state=0;
}

CProjectEditDlg::~CProjectEditDlg() {
}


void CProjectEditDlg::slotGetData()
{
    qWarning( "CProjectEditDlg::slotGetData(): Geht !" );
    reject();
}

void CProjectEditDlg::slotEditData()
{
    qWarning( "CProjectEditDlg::slotEditData(): Geht !" );
    accept();
}
void CProjectEditDlg::slotEditText(const QString & text)
{
     Q_UNUSED(text);

     qWarning( "MyProjectEditDlg::slotEditText(): Geht !" );
     if(state == 0){
        ui.path->setText( tmppath + ui.text->text()) ;
     }
}

void CProjectEditDlg::slotEditPath()
{
     qWarning( "MyProjectEditDlg::slotEditPath(): Geht !" );
     state=1;
}

void CProjectEditDlg::slotEditPathDir()
{
    QString url=QFileDialog::getExistingDirectory();
    if(!url.isEmpty()){
        if(!url.endsWith("/")){
            url = url + "/";
        }
        tmppath =  url ;
        ui.path->setText( url  + ui.text->text()) ;
    }
    qWarning( "MyProjectEditDlg::slotEditPathDir(): Geht !" );
}

QString CProjectEditDlg::getfile()
{
     return ui.text->text();
}

QString CProjectEditDlg::getpath()
{
     return ui.path->text();
}
