//
// C++ Implementation: CNetworkEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CNetworkEdit.hpp"

CNetworkEditDlg::CNetworkEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CNetworkEditDlg::~CNetworkEditDlg() {
}

void CNetworkEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CNetworkEditDlg::slotGetData(FolderListItem *i)
{
    point=i;

    ui.local->setChecked(i->GetValue("local",i).toInt());
    ui.client->setChecked(i->GetValue("client",i).toInt());
    ui.server->setChecked(i->GetValue("server",i).toInt());
    ui.surl->setText(i->GetValue("surl",i));
    ui.sport->setText(i->GetValue("sport",i));
    ui.rport->setText(i->GetValue("rport",i));
    ui.nickname->setText(i->GetValue("nickname",i));

    qWarning( "CNetworkEditDlg::slotGetData(): Geht !" );
}

void CNetworkEditDlg::slotEditData()
{
    if(point != NULL){
        point->SetValue("local", ui.local->isChecked() ? "1" : "0");
        point->SetValue("client", ui.client->isChecked() ? "1" : "0");
        point->SetValue("server", ui.server->isChecked() ? "1" : "0");
        point->SetValue("surl",ui.surl->text());
        point->SetValue("sport",ui.sport->text());
        point->SetValue("rport",ui.rport->text());
        point->SetValue("nickname",ui.nickname->text());

        point->updategl();
    }
    qWarning( "CNetworkEditDlg::slotEditData(): Geht !" );
}
