import sys
import os
import unittest
from os.path import join
from distutils.sysconfig import get_python_lib
from site import addsitedir

root = sys.argv.pop(1)
site_packages = get_python_lib()
_path = sys.path[:]
sys.path[:] = []
addsitedir(join(root, site_packages[1:]))
addsitedir(join(root, site_packages[1:].replace('dist-packages', 'site-packages')))
sys.path.extend(_path)

os.environ['NORMALIZERS_PATH'] = os.path.join(root,
					'usr/share/logsparser/normalizers')
from logsparser.tests import test_normalizer
from logsparser.tests import test_lognormalizer
from logsparser.tests import test_log_samples
from logsparser.tests import test_commonElements
tests = (test_commonElements,
         test_normalizer,
         test_lognormalizer,
         test_log_samples,
         )
load = unittest.defaultTestLoader.loadTestsFromModule
suite = unittest.TestSuite(map(load, tests))
unittest.TextTestRunner().run(suite)
