"""
Splash Screen for Start-Up
"""
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: SplashScreen.py 82 2004-07-11 13:01:44Z henning $

from Tkinter import *
import IconImages
import __version__
import Pmw

class SplashScreen:

    def __init__(self, tkroot=None, 
                 title="PyCoCuMa Splash Screen", class_=None):
        if not tkroot:
            tkroot = Pmw.initialise()
            tkroot.withdraw()
        self.tkroot = tkroot
        if class_:
            self.top = Toplevel(tkroot, class_=class_)
        else:
            self.top = Toplevel(tkroot)
        if title:
            self.top.title(title)
            self.top.iconname(title)
        
        bgcolor = "#14143c"
        fgcolor = "#eaeafc"
        self.top["bg"] = bgcolor
        
        IconImages.createIconImages()
        
        frm = Frame(self.top, borderwidth=2, bg=bgcolor)
        frm.pack()
        lbl = Label(frm, image=IconImages.IconImages["pycocuma_title"],
                    padx=0, pady=0, borderwidth=0)
        lbl.grid(columnspan=2)
        self.lblStatus = Label(frm, text="Loading...",
                    justify=LEFT, font=("Helvetica", -12), bg=bgcolor, fg=fgcolor)
        self.lblStatus.grid(row=1,column=0,sticky=W)
        lbl = Label(frm, text="version %s" % __version__.__version__,
                    justify=RIGHT, font=("Helvetica", -12), bg=bgcolor, fg=fgcolor)
        lbl.grid(row=1,column=1,sticky=E)

        self.top.overrideredirect(1)
        self.top.withdraw()

    def centerWindow(self, relx=0.5, rely=0.3):
        "Center the Main Window on Screen"
        widget = self.top
        master = self.tkroot
        widget.update_idletasks() # Actualize geometry information
        if master.winfo_ismapped():
            m_width = master.winfo_width()
            m_height = master.winfo_height()
            m_x = master.winfo_rootx()
            m_y = master.winfo_rooty()
        else:
            m_width = master.winfo_screenwidth()
            m_height = master.winfo_screenheight()
            m_x = m_y = 0
        w_width = widget.winfo_reqwidth()
        w_height = widget.winfo_reqheight()
        x = m_x + (m_width - w_width) * relx
        y = m_y + (m_height - w_height) * rely
        if x+w_width > master.winfo_screenwidth():
            x = master.winfo_screenwidth() - w_width
        elif x < 0:
            x = 0
        if y+w_height > master.winfo_screenheight():
            y = master.winfo_screenheight() - w_height
        elif y < 0:
            y = 0
        widget.geometry("+%d+%d" % (x, y))
        widget.deiconify() # Become visible at the desired location

    def show(self): 
        self.centerWindow(relx=0.5,rely=0.5)
        self.top.update()

    def update(self, statusstr):
        self.lblStatus["text"] = statusstr
        self.top.update()

    def destroy(self):
        self.top.destroy()

if __name__ == "__main__":
    # Unit Test:
    dlg = SplashScreen()
    dlg.show()
    dlg.tkroot.mainloop()
