require 'spec_helper'

describe 'collectd::plugin::uuid', type: :class do
  on_supported_os(baseline_os_hash).each do |os, facts|
    context "on #{os} " do
      let :facts do
        facts
      end

      options = os_specific_options(facts)
      context ':ensure => present' do
        let :params do
          { ensure: 'present' }
        end

        it { is_expected.to contain_collectd__plugin('uuid') }
        it { is_expected.to contain_file('old_uuid.load').with_ensure('absent') }
        it { is_expected.to contain_file('older_uuid.load').with_ensure('absent') }
        it 'Will create 10-uuid.conf' do
          is_expected.to contain_file('uuid.load').with(
            ensure: 'present',
            path: "#{options[:plugin_conf_dir]}/10-uuid.conf",
            content: "#\ Generated by Puppet\n<LoadPlugin uuid>\n  Globals false\n</LoadPlugin>\n\n<Plugin \"uuid\">\n  UUIDFile \"/etc/uuid\"\n</Plugin>\n\n"
          )
        end
      end

      context ':ensure => absent' do
        let :params do
          { ensure: 'absent' }
        end

        it 'Will not create 10-uuid.conf' do
          is_expected.to contain_file('uuid.load').with(
            ensure: 'absent',
            path: "#{options[:plugin_conf_dir]}/10-uuid.conf"
          )
        end
      end
    end
  end
end
