/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RegOptimizer;
import weka.classifiers.functions.supportVector.RegSMOImproved;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class SMOreg
extends Classifier
implements WeightedInstancesHandler,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    private static final long serialVersionUID = -7149606251113102827L;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected int m_filterType = 0;
    protected NominalToBinary m_NominalToBinary;
    protected Filter m_Filter = null;
    protected ReplaceMissingValues m_Missing;
    protected boolean m_onlyNumeric;
    protected double m_C = 1.0;
    protected double m_x1 = 1.0;
    protected double m_x0 = 0.0;
    protected RegOptimizer m_optimizer = new RegSMOImproved();
    protected Kernel m_kernel = new PolyKernel();

    public String globalInfo() {
        return "SMOreg implements the support vector machine for regression. The parameters can be learned using various algorithms. The algorithm is selected by setting the RegOptimizer. The most popular algorithm (" + RegSMOImproved.class.getName().replaceAll(".*\\.", "") + ") is due to Shevade, Keerthi " + "et al and this is the default RegOptimizer.\n\n" + "For more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "S.K. Shevade and S.S. Keerthi and C. Bhattacharyya and K.R.K. Murthy");
        result.setValue(TechnicalInformation.Field.TITLE, "Improvements to the SMO Algorithm for SVM Regression");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "IEEE Transactions on Neural Networks");
        result.setValue(TechnicalInformation.Field.YEAR, "1999");
        result.setValue(TechnicalInformation.Field.PS, "http://guppy.mpe.nus.edu.sg/~mpessk/svm/ieee_smo_reg.ps.gz");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.TECHREPORT);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "A.J. Smola and B. Schoelkopf");
        additional.setValue(TechnicalInformation.Field.TITLE, "A tutorial on support vector regression");
        additional.setValue(TechnicalInformation.Field.NOTE, "NeuroCOLT2 Technical Report NC2-TR-1998-030");
        additional.setValue(TechnicalInformation.Field.YEAR, "1998");
        return result;
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe complexity constant C.\n\t(default 1)", "C", 1, "-C <double>"));
        result.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither.\n\t(default 0=normalize)", "N", 1, "-N"));
        result.addElement(new Option("\tOptimizer class used for solving quadratic optimization problem\n\t(default " + RegSMOImproved.class.getName() + ")", "I", 1, "-I <classname and parameters>"));
        result.addElement(new Option("\tThe Kernel to use.\n\t(default: weka.classifiers.functions.supportVector.PolyKernel)", "K", 1, "-K <classname and parameters>"));
        result.addElement(new Option("", "", 0, "\nOptions specific to optimizer ('-I') " + this.getRegOptimizer().getClass().getName() + ":"));
        Enumeration enm = this.getRegOptimizer().listOptions();
        while (enm.hasMoreElements()) {
            result.addElement((Option)enm.nextElement());
        }
        result.addElement(new Option("", "", 0, "\nOptions specific to kernel ('-K') " + this.getKernel().getClass().getName() + ":"));
        enm = this.getKernel().listOptions();
        while (enm.hasMoreElements()) {
            result.addElement((Option)enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setC(Double.parseDouble(tmpStr));
        } else {
            this.setC(1.0);
        }
        String nString = Utils.getOption('N', options);
        if (nString.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(nString), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        tmpStr = Utils.getOption('I', options);
        String[] tmpOptions = Utils.splitOptions(tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setRegOptimizer((RegOptimizer)Utils.forName(RegOptimizer.class, tmpStr, tmpOptions));
        } else {
            this.setRegOptimizer(new RegSMOImproved());
        }
        tmpStr = Utils.getOption('K', options);
        tmpOptions = Utils.splitOptions(tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setKernel(Kernel.forName(tmpStr, tmpOptions));
        } else {
            this.setKernel(new PolyKernel());
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-C");
        result.add("" + this.getC());
        result.add("-N");
        result.add("" + this.m_filterType);
        result.add("-I");
        result.add("" + this.getRegOptimizer().getClass().getName() + " " + Utils.joinOptions(this.getRegOptimizer().getOptions()));
        result.add("-K");
        result.add("" + this.getKernel().getClass().getName() + " " + Utils.joinOptions(this.getKernel().getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public Capabilities getCapabilities() {
        Capabilities result = this.getKernel().getCapabilities();
        result.setOwner(this);
        result.enableAllAttributeDependencies();
        if (result.handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        }
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int index;
        int i;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        Instances data = new Instances(instances, 0);
        for (i = 0; i < instances.numInstances(); ++i) {
            if (!(instances.instance(i).weight() > 0.0)) continue;
            data.add(instances.instance(i));
        }
        if (data.numInstances() == 0) {
            throw new Exception("No training instances left after removing instance with either a weight null or a missing class!");
        }
        instances = data;
        this.m_onlyNumeric = true;
        for (i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex() || instances.attribute(i).isNumeric()) continue;
            this.m_onlyNumeric = false;
            break;
        }
        this.m_Missing = new ReplaceMissingValues();
        this.m_Missing.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_Missing);
        if (this.getCapabilities().handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            if (!this.m_onlyNumeric) {
                this.m_NominalToBinary = new NominalToBinary();
                this.m_NominalToBinary.setInputFormat(instances);
                instances = Filter.useFilter(instances, this.m_NominalToBinary);
            } else {
                this.m_NominalToBinary = null;
            }
        } else {
            this.m_NominalToBinary = null;
        }
        double y0 = instances.instance(0).classValue();
        for (index = 1; index < instances.numInstances() && instances.instance(index).classValue() == y0; ++index) {
        }
        if (index == instances.numInstances()) {
            throw new Exception("All class values are the same. At least two class values should be different");
        }
        double y1 = instances.instance(index).classValue();
        if (this.m_filterType == 1) {
            this.m_Filter = new Standardize();
            ((Standardize)this.m_Filter).setIgnoreClass(true);
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else if (this.m_filterType == 0) {
            this.m_Filter = new Normalize();
            ((Normalize)this.m_Filter).setIgnoreClass(true);
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else {
            this.m_Filter = null;
        }
        if (this.m_Filter != null) {
            double z0 = instances.instance(0).classValue();
            double z1 = instances.instance(index).classValue();
            this.m_x1 = (y0 - y1) / (z0 - z1);
            this.m_x0 = y0 - this.m_x1 * z0;
        } else {
            this.m_x1 = 1.0;
            this.m_x0 = 0.0;
        }
        this.m_optimizer.setSMOReg(this);
        this.m_optimizer.buildClassifier(instances);
    }

    public double classifyInstance(Instance instance) throws Exception {
        this.m_Missing.input(instance);
        this.m_Missing.batchFinished();
        instance = this.m_Missing.output();
        if (!this.m_onlyNumeric && this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(instance);
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        double result = this.m_optimizer.SVMOutput(instance);
        return result * this.m_x1 + this.m_x0;
    }

    public String regOptimizerTipText() {
        return "The learning algorithm.";
    }

    public void setRegOptimizer(RegOptimizer regOptimizer) {
        this.m_optimizer = regOptimizer;
    }

    public RegOptimizer getRegOptimizer() {
        return this.m_optimizer;
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public void setKernel(Kernel value) {
        this.m_kernel = value;
    }

    public Kernel getKernel() {
        return this.m_kernel;
    }

    public String cTipText() {
        return "The complexity parameter C.";
    }

    public double getC() {
        return this.m_C;
    }

    public void setC(double v) {
        this.m_C = v;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_optimizer == null || !this.m_optimizer.modelBuilt()) {
            return "SMOreg: No model built yet.";
        }
        try {
            text.append(this.m_optimizer.toString());
        }
        catch (Exception e) {
            return "Can't print SMVreg classifier.";
        }
        return text.toString();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> result = new Vector<String>();
        result.addElement("measureKernelEvaluations");
        result.addElement("measureCacheHits");
        return result.elements();
    }

    public double getMeasure(String measureName) {
        if (measureName.equalsIgnoreCase("measureKernelEvaluations")) {
            return this.measureKernelEvaluations();
        }
        if (measureName.equalsIgnoreCase("measureCacheHits")) {
            return this.measureCacheHits();
        }
        throw new IllegalArgumentException("Measure '" + measureName + "' is not supported!");
    }

    protected double measureKernelEvaluations() {
        if (this.m_optimizer != null) {
            return this.m_optimizer.getKernelEvaluations();
        }
        return 0.0;
    }

    protected double measureCacheHits() {
        if (this.m_optimizer != null) {
            return this.m_optimizer.getCacheHits();
        }
        return 0.0;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8126 $");
    }

    public static void main(String[] args) {
        SMOreg.runClassifier(new SMOreg(), args);
    }
}

