/* Test Product<NNC_Polyhedron, Grid>::intersection_assign().
   Copyright (C) 2001-2010 Roberto Bagnara <bagnara@cs.unipr.it>
   Copyright (C) 2010-2016 BUGSENG srl (http://bugseng.com)

This file is part of the Parma Polyhedra Library (PPL).

The PPL is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

The PPL is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111-1307, USA.

For the most up-to-date information see the Parma Polyhedra Library
site: http://bugseng.com/products/ppl/ . */

#include "ppl_test.hh"
#include "partially_reduced_product_test.hh"

typedef NNC_Polyhedron DOMAIN1;
typedef Grid DOMAIN2;
typedef Domain_Product<DOMAIN1x, DOMAIN2x>::Constraints_Product Product;

namespace {

// intersection_assign()
bool
test01() {
  Variable A(0);
  Variable B(1);

  Product prp1(3);
  prp1.refine_with_constraint(A >= 0);
  prp1.refine_with_congruence((A %= 0) / 2);

  Product prp2(3);
  prp2.refine_with_constraint(A <= 0);
  prp2.refine_with_congruence((A %= 0) / 7);

  prp1.intersection_assign(prp2);

  Product known_prp(3);
  known_prp.refine_with_congruence((A %= 0) / 14);
  known_prp.refine_with_constraint(A >= 0);
  known_prp.refine_with_constraint(A <= 0);

  bool ok = (prp1 == known_prp);

  print_congruences(prp1, "*** prp1 congruences ***");
  print_constraints(prp1, "*** prp1 constraints ***");

  return ok;
}

// intersection_assign()
bool
test02() {
  Variable A(0);
  Variable B(1);

  Product prp1(3);
  prp1.refine_with_constraint(A >= 0);
  prp1.refine_with_congruence((A %= 0) / 2);
  prp1.refine_with_constraint(B <= 1);

  Product prp2(3);
  prp2.refine_with_constraint(A <= 0);
  prp2.refine_with_congruence((A %= 0) / 7);
  prp2.refine_with_constraint(B >= 1);

  prp1.intersection_assign(prp2);

  Product known_prp(3);
  known_prp.refine_with_constraint(A == 0);
  known_prp.refine_with_constraint(B == 1);

  bool ok = (prp1 == known_prp);

  print_congruences(prp1, "*** prp1 congruences ***");
  print_constraints(prp1, "*** prp1 constraints ***");

  return ok;
}

// intersection_assign()
bool
test03() {
  Variable A(0);
  Variable B(1);

  Product prp1(3);
  prp1.refine_with_constraint(A >= 0);
  prp1.refine_with_congruence((A %= 0) / 2);
  prp1.refine_with_constraint(B <= 1);

  Product prp2(3);
  prp2.refine_with_constraint(A <= 0);
  prp2.refine_with_congruence((A %= 0) / 7);
  prp2.refine_with_constraint(B >= 2);

  prp1.intersection_assign(prp2);

  prp1.intersection_assign(prp2);
  bool ok = prp1.is_empty();

  print_congruences(prp1, "*** prp1 congruences ***");
  print_constraints(prp1, "*** prp1 constraints ***");

  return ok;
}

} // namespace

BEGIN_MAIN
  DO_TEST(test01);
  DO_TEST(test02);
  DO_TEST(test03);
END_MAIN
