/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __MESSAGES__
#define __MESSAGES__

#include <src/global/global.h>

#include <src/messages/messages/sources/messageparametres.h>

typedef enum
{
	LANGUE_INCONNUE,
	LANGUE_EN,
	LANGUE_FR,
	LANGUE_GRRR,
	LANGUE_NEUNEU,
	LANGUE_SCHTROUMPF,
	LANGUE_WIN
} CONTENEUR_SCALAIRE(Langue);
/* Dfinition des diffrentes langues disponibles
 * pour l'affichage des messages de planfacile.
 */

typedef enum
{
	CHARSET_INCONNU,
	CHARSET_ASCII,
	CHARSET_ISO,
	CHARSET_UTF8
} CONTENEUR_SCALAIRE(Charset);
/* Dfinition des diffrents charsets disponibles
 * pour l'affichage des messages de planfacile.
 */

typedef enum
{
	MESSAGE_INCONNU,
	MESSAGE_AIDE,
	MESSAGE_AJOUT_RACINE,
	MESSAGE_AVERTISSEMENT,
	MESSAGE_COMMANDE_ECHAPPEMENT_INCORRECTE,
	MESSAGE_COMMANDE_INCORRECTE,
	MESSAGE_COMMANDE_MACRO_INCORRECTE,
	MESSAGE_COMMANDE_PARAMETRE_INCORRECTE,
	MESSAGE_COMMANDE_TEXTE_INCORRECTE,
	MESSAGE_DEPENDANCE_INCORRECTE,
	MESSAGE_DEPENDANCE_INUTILE,
	MESSAGE_DEPENDANCE_VIDE,
	MESSAGE_DEPENDANCE_VIDE_INUTILE,
	MESSAGE_DOUBLE_POINTS,
	MESSAGE_ERREUR,
	MESSAGE_ERREUR_SYNTAXE,
	MESSAGE_IDEE_GENERIQUE_MANQUANTE,
	MESSAGE_IDEE_GENERIQUE_REFERENCE_VIDE,
	MESSAGE_IDEE_MANQUANTE_MANQUANTE,
	MESSAGE_IDEE_MANQUANTE_REFERENCE_VIDE,
	MESSAGE_IDEE_NON_ATTEIGNABLE,
	MESSAGE_IDEE_REFERENCE_VIDE,
	MESSAGE_INCLUSION,
	MESSAGE_INDICE_IDEE_GENERIQUE_INCORRECT,
	MESSAGE_INDICE_IDEE_MANQUANTE_INCORRECT,
	MESSAGE_INDICE_REFERENCE_INCORRECT,
	MESSAGE_LOCALISATION,
	MESSAGE_MACRO_INCONNUE,
	MESSAGE_MEMOIRE_INSUFFISANTE,
	MESSAGE_NOM_NIVEAU_INCORRECT,
	MESSAGE_OPTION_DANS_MACRO,
	MESSAGE_OPTION_LIGNE_COMMANDE,
	MESSAGE_OUVERTURE_CHEMIN_INVALIDE,
	MESSAGE_OUVERTURE_ENTREE,
	MESSAGE_OUVERTURE_ENTREE_VIDE,
	MESSAGE_OUVERTURE_INEXISTANT,
	MESSAGE_OUVERTURE_REPERTOIRE_COURANT,
	MESSAGE_OUVERTURE_SORTIE,
	MESSAGE_OUVERTURE_STANDARD,
	MESSAGE_OUVERTURE_STANDARD_SUIVANTE,
	MESSAGE_OUVERTURE_TYPE_INCORRECT,
	MESSAGE_PARAMETRES_MACRO,
	MESSAGE_PERTINENCE_INCORRECTE,
	MESSAGE_POINT,
	MESSAGE_RACINE_NIVEAU_INCORRECT,
	MESSAGE_RACINE_NIVEAU_NON_DEFINI,
	MESSAGE_RECURSIVITE_FICHIER,
	MESSAGE_RECURSIVITE_MACRO,
	MESSAGE_REDEFINITION_ENTETE,
	MESSAGE_REDEFINITION_IDEE,
	MESSAGE_REDEFINITION_IDEE_GENERIQUE,
	MESSAGE_REDEFINITION_IDEE_GENERIQUE_DEFAUT,
	MESSAGE_REDEFINITION_IDEE_MANQUANTE,
	MESSAGE_REDEFINITION_IDEE_MANQUANTE_DEFAUT,
	MESSAGE_REDEFINITION_MACRO,
	MESSAGE_REDEFINITION_MESSAGE,
	MESSAGE_REDEFINITION_PIED,
	MESSAGE_REDEFINITION_RACINE,
	MESSAGE_REDEFINITION_REFERENCE,
	MESSAGE_REDEFINITION_REFERENCE_DEFAUT,
	MESSAGE_REDEFINITION_SECTION,
	MESSAGE_REDEFINITION_SECTION_DEFAUT,
	MESSAGE_REFERENCE_NIVEAU_INCORRECT,
	MESSAGE_REFERENCE_STYLE_MANQUANT,
	MESSAGE_SANS_IDEE_ORPHELINE,
	MESSAGE_SECTION_NIVEAU_INCORRECT,
	MESSAGE_SECTION_STYLE_MANQUANT,
	MESSAGE_STATISTIQUES,
	MESSAGE_UTILISATEUR,
	MESSAGE_UTILISATION_SORTIE,
	MESSAGE_VERBEUX,
	MESSAGE_VERBEUX_ANALYSE,
	MESSAGE_VERBEUX_ANALYSE_FININCLUSION,
	MESSAGE_VERBEUX_ANALYSE_INCLUSION,
	MESSAGE_VERBEUX_ANALYSE_SOURCE,
	MESSAGE_VERBEUX_IDEES,
	MESSAGE_VERBEUX_IDEES_AUTOMATIQUES,
	MESSAGE_VERBEUX_IDEES_DEPENDANCE,
	MESSAGE_VERBEUX_IDEES_GENERIQUE_DEFAUT,
	MESSAGE_VERBEUX_IDEES_GENERIQUE_EXPLICITE,
	MESSAGE_VERBEUX_IDEES_IDEE,
	MESSAGE_VERBEUX_IDEES_MANQUANTE_DEFAUT,
	MESSAGE_VERBEUX_IDEES_MANQUANTE_EXPLICITE,
	MESSAGE_VERBEUX_IDEES_PRESENTES,
	MESSAGE_VERBEUX_MACROS,
	MESSAGE_VERBEUX_MACROS_BOUCLE,
	MESSAGE_VERBEUX_MACROS_ITERATION,
	MESSAGE_VERBEUX_MACROS_NORMALE,
	MESSAGE_VERBEUX_MACROS_PARAMETRE,
	MESSAGE_VERBEUX_OPTIONS,
	MESSAGE_VERBEUX_OPTIONS_COMMENTAIRE,
	MESSAGE_VERBEUX_OPTIONS_ENREGISTREMENT,
	MESSAGE_VERBEUX_OPTIONS_MACRO,
	MESSAGE_VERBEUX_OPTIONS_OPTIONS,
	MESSAGE_VERBEUX_OPTIONS_RECHERCHE,
	MESSAGE_VERBEUX_OPTIONS_RECHERCHE_FIN,
	MESSAGE_VERBEUX_OPTIONS_RECHERCHE_NOUVELLE,
	MESSAGE_VERBEUX_OPTIONS_RECHERCHE_PREMIERE,
	MESSAGE_VERBEUX_OPTIONS_REDUCTION,
	MESSAGE_VERBEUX_PLAN,
	MESSAGE_VERBEUX_PLAN_ATTEIGNABLES,
	MESSAGE_VERBEUX_PLAN_CALCUL,
	MESSAGE_VERBEUX_PLAN_GRAPHE,
	MESSAGE_VERBEUX_PLAN_GRAPHE_DEPENDANCES,
	MESSAGE_VERBEUX_PLAN_GRAPHE_IDEES,
	MESSAGE_VERBEUX_PLAN_GRAPHE_VIDE,
	MESSAGE_VERBEUX_PLAN_RACINE,
	MESSAGE_VERBEUX_PLAN_TRANSFORMATION,
	MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEE,
	MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEEVIDE,
	MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCE,
	MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCEVIDE,
	MESSAGE_VERBEUX_RETOUCHES,
	MESSAGE_VERBEUX_RETOUCHES_DEFRAGMENTATION,
	MESSAGE_VERBEUX_RETOUCHES_INCLUDE,
	MESSAGE_VERBEUX_RETOUCHES_MACRO_BOUCLE,
	MESSAGE_VERBEUX_RETOUCHES_MACRO_NORMALE,
	MESSAGE_VERBEUX_RETOUCHES_PARAMETRE,
	MESSAGE_VERBEUX_RETOUCHES_STANDARD,
	MESSAGE_VERBEUX_SORTIE,
	MESSAGE_VERBEUX_SORTIE_GENERATION,
	MESSAGE_VERBEUX_SORTIE_GENERATION_DEPREF,
	MESSAGE_VERBEUX_SORTIE_GENERATION_ENTETE,
	MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREF,
	MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREFS,
	MESSAGE_VERBEUX_SORTIE_GENERATION_IDEE,
	MESSAGE_VERBEUX_SORTIE_GENERATION_IDEEVIDE,
	MESSAGE_VERBEUX_SORTIE_GENERATION_PIED,
	MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRR,
	MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRRVIDE,
	MESSAGE_VERBEUX_SORTIE_GENERATION_REFRED,
	MESSAGE_VERBEUX_SORTIE_GENERATION_REFREDVIDE,
	MESSAGE_VERBEUX_SORTIE_PRODUCTION,
	MESSAGE_VERBEUX_SORTIE_PRODUCTION_DOCUMENT,
	MESSAGE_VERBEUX_SORTIE_PRODUCTION_STATS,
	MESSAGE_VERBEUX_STYLES,
	MESSAGE_VERBEUX_STYLES_AUTRES,
	MESSAGE_VERBEUX_STYLES_ENTETE,
	MESSAGE_VERBEUX_STYLES_MESSAGE,
	MESSAGE_VERBEUX_STYLES_PIED,
	MESSAGE_VERBEUX_STYLES_RACINE,
	MESSAGE_VERBEUX_STYLES_REFERENCE_DEFAUT,
	MESSAGE_VERBEUX_STYLES_REFERENCE_EXPLICITE,
	MESSAGE_VERBEUX_STYLES_SECTION,
	MESSAGE_VERBEUX_STYLES_SECTION_DEFAUT,
	MESSAGE_VERBEUX_STYLES_SECTION_EXPLICITE,
	MESSAGE_VERBEUX_VERIFICATION,
	MESSAGE_VERBEUX_VERIFICATION_AVERTISSEMENT,
	MESSAGE_VERBEUX_VERIFICATION_DEFRAGMENTATION,
	MESSAGE_VERBEUX_VERIFICATION_ERREUR,
	MESSAGE_VIRGULE
} CONTENEUR_SCALAIRE(Message);
/* Dfinition des diffrents messages disponibles
 * pour l'affichage des messages de planfacile.
 */

#include <src/donnees/general/general.h>

Resultat messages_message(TRAVAIL(General) general , TRAVAIL_SCALAIRE(DescripteurFichier) sortie , TRAVAIL_SCALAIRE(Message) message , TRAVAIL(MessageParametres) messageparametres);
/* Ralise un affichage sur la sortie de message indique
 * dans la structure general. Cette structure contient
 * galement la localisation en vigueur.
 */

Resultat messages_localisation(TRAVAIL(General)  general);
/* Dtermine la localisation  partir de la variable
 * d'environnement $LANG. La dtermination sera
 * influence par le jeu de langues et de charsets
 * dfinis dans planfacile.
 */

Resultat messages_parametres(TRAVAIL_SCALAIRE(Message) message , REFERENCE_SCALAIRE(Chaine) parametres);
/* Renvoie les types des paramtres d'un message,
 * dans leur ordre d'apparition.
 * Le chaine en question n'a pas  tre libre.
 */

#endif
