/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __OPTIONS__
#define __OPTIONS__

#include <src/global/global.h>

typedef struct options CONTENEUR(Options);

struct options
{
	//Options non reprsentes :
	//-a : active tout
	//-n : dsactive tout
	//-o : nom du fichier de sortie.
	//-O : options dfinies  l'appel.
	STOCKAGE_SCALAIRE(Booleen) aide;
	//Option -h :
	//Dsactive par dfaut.
	//Affiche la signification des options.
	STOCKAGE_SCALAIRE(Booleen) licence;
	//Option -V :
	//Dsactive par dfaut.
	//Affiche les informations de licence.
	STOCKAGE_SCALAIRE(Entier) verbeux;
	//Option -v :
	//Dsactive par dfaut (=0).
	//Affiche des messages concernant le fonctionnement
	//de PlanFacile.
	STOCKAGE_SCALAIRE(Booleen) erreur;
	//Option -e :
	//Dsactive par dfaut.
	//Transforme tous les warnings en erreur.
	STOCKAGE_SCALAIRE(Booleen) copielocalisation;
	//Option -W :
	//Active par dfaut.
	//Dsactive l'enregistrement des localisations
	//de commandes et leur affichage.
	STOCKAGE_SCALAIRE(Booleen) localisationabsolue;
	//Option -w :
	//Dsactive par dfaut.
	//Enregistre les chemins absolus dans les
	//localisation fichier.
	STOCKAGE_SCALAIRE(Booleen) source;
	//Option -S :
	//Dsactive par dfaut.
	//Ignore les fichiers sources non ouvrables.
	STOCKAGE_SCALAIRE(Booleen) inclusion;
	//Option -I :
	//Dsactive par dfaut.
	//Ignore les inclusions rcursives de fichiers.
	STOCKAGE_SCALAIRE(Booleen) standard;
	//Option -s :
	//Dsactive par dfaut.
	//Rend planfacile plus svre concernant les
	//fichiers  ouvrir par #standard.
	STOCKAGE_SCALAIRE(Booleen) utilisateur;
	//Option -u :
	//Active par dfaut.
	//Affiche les warnings
	//dfinis par l'utilisateur.
	STOCKAGE_SCALAIRE(Booleen) commandes;
	//Option -C :
	//Dsactive par dfaut.
	//Lorsqu'une commande est place dans
	//un flux o elle ne devrait pas tre,
	//planfacile met un warning et ignore
	//la commande.
	STOCKAGE_SCALAIRE(Booleen) redefinitionidees;
	//Option -i :
	//Active par dfaut.
	//Avertit des redfinitions d'ides
	//par un warning.
	STOCKAGE_SCALAIRE(Booleen) ideereferencevide;
	//Option -Y :
	//Dsactive par dfaut.
	//Lorsqu'elle est prsente, les ides dont la
	//rfrence est vide sont ignores.
	STOCKAGE_SCALAIRE(Booleen) indiceincorrect;
	//Option -m :
	//Dsactive par dfaut.
	//Lorsqu'elle est prsente, les ides
	//manquantes comportant un indice incorrecte
	//sont ignores.
	STOCKAGE_SCALAIRE(Booleen) referenceincorrecte;
	//Option -g :
	//Dsactive par dfaut.
	//Lorsqu'elle est prsente, les ides
	//gnriques comportant une rfrence incorrecte
	//sont ignores.
	STOCKAGE_SCALAIRE(Booleen) ajoutracine;
	//Option -r :
	//Active par dfaut.
	//Lorsqu'elle est prsente, l'ajout ventuel
	//d'une ide racine est signale.
	STOCKAGE_SCALAIRE(Booleen) ideeautomatiquemanquante;
	//Option -A :
	//Dsactive par dfaut.
	//Lorqu'elle est prsente, les ides automatiques
	//ajoutes par le calcul du plan, mais non dfinies
	//sont ignores.
	STOCKAGE_SCALAIRE(Booleen) dependancesincorrectes;
	//Option -d :
	//Dsactive par dfaut.
	//Lorsqu'elle est prsente, les dpendances
	//dont la destination est incorrecte sont ignores.
	STOCKAGE_SCALAIRE(Booleen) dependancesinutiles;
	//Option -D :
	//Dsactive par dfaut.
	//Lorsqu'elle est prsente, les dpendances
	//qui ne servent pas pour la construction
	//du graphe sont indiques.
	STOCKAGE_SCALAIRE(Booleen) pertinenceincorrecte;
	//Option -p :
	//Dsactive par dfaut.
	//Lorsqu'elle est prsente, les ides
	//comportant une pertinence incorrecte
	//sont ignores.
	STOCKAGE_SCALAIRE(Booleen) indicereferenceincorrect;
	//Option -E :
	//Dsactive par dfaut.
	//Lorsqu'elle est prsente, les commandes
	//#extref comprennant un indice incorrect
	//sont ignores.
	STOCKAGE_SCALAIRE(Booleen) commentaires;
	//Option -c :
	//Dsactive par dfaut.
	//Lorqu'elle est prsente, les commentaires placs
	//dans des flux de texte sont placs dans le
	//document final, au format des messages.
	STOCKAGE_SCALAIRE(Booleen) redefinitionstyles;
	//Option -y :
	//Dsactive par dfaut.
	//Avertit des redfinitions de styles
	//par un warning.
	STOCKAGE_SCALAIRE(Booleen) niveauincorrect;
	//Option -l :
	//Dsactive par dfaut;
	//Lorsqu'elle est prsente, les
	//commandes de style comportant
	//un niveau incorrect sont
	//ignores.
	STOCKAGE_SCALAIRE(Booleen) sectionstylemanquant;
	//Option -G :
	//Dsactive par dfaut.
	//Lorsqu'elle est prsente, les ides dont
	//le niveau n'a pas de style pour le formattage
	//est ignore.
	STOCKAGE_SCALAIRE(Booleen) referencestylemanquant;
	//Option -N :
	//Dsactive par dfaut.
	//Lorsqu'elle est prsente, les rfrences dont
	//le niveau de destination n'a pas de style pour
	//le formattage est ignore.
	STOCKAGE_SCALAIRE(Booleen) nomsectionincorrect;
	//Option -T :
	//Dsactive par dfaut.
	//Lorsqu'elle est prsente, les commandes #sec
	//comprennant un niveau incorrect sont ignores.
	STOCKAGE_SCALAIRE(Booleen) redefinitionmacro;
	//Option -M :
	//Dsactive par dfaut.
	//Avertit des redfinitions de macros
	//par un warning.
	STOCKAGE_SCALAIRE(Booleen) macroinconnue;
	//Option -U :
	//Dsactive par dfaut.
	//Lorsqu'elle est prsente, les appels de
	//macros non dfinies seront ignores.
	STOCKAGE_SCALAIRE(Booleen) parametres;
	//Option -P :
	//Dsactive par dfaut.
	//Arrange le nombre de paramtres de macro
	// la dfinition de la macro.
	STOCKAGE_SCALAIRE(Booleen) recursivite;
	//Option -R :
	//Dsactive par dfaut.
	//Ignore les appels rcursifs de macros
	//et gnre un warning.
	STOCKAGE_SCALAIRE(Booleen) optionmacro;
	//Option -t :
	//Dsactive par dfaut.
	//Lorsqu'elle est prsente, les options
	//prsentes dans les dfinitions et les
	//appels de macro seront ignors.
};
/* Cette structure rassemble les options de la ligne
 * de commande d'appel  planfacile.
 * Ces options videmment influent sur le comportement
 * de planfacile.
 */

Resultat options_initialisation(TRAVAIL(Options) options);
/* Cre une structure d'options, avec les valeurs d'options
 * par dfaut.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation mmoire.
 */

Resultat options_changement_licence			(TRAVAIL(Options) options);
Resultat options_changement_aide			(TRAVAIL(Options) options);
Resultat options_changement_verbeux			(TRAVAIL(Options) options);
Resultat options_changement_inclusion			(TRAVAIL(Options) options);
Resultat options_changement_source			(TRAVAIL(Options) options);
Resultat options_changement_standard			(TRAVAIL(Options) options);
Resultat options_changement_macroinconnue		(TRAVAIL(Options) options);
Resultat options_changement_optionmacro			(TRAVAIL(Options) options);
Resultat options_changement_recursivite			(TRAVAIL(Options) options);
Resultat options_changement_redefinitionmacro		(TRAVAIL(Options) options);
Resultat options_changement_parametres			(TRAVAIL(Options) options);
Resultat options_changement_erreur			(TRAVAIL(Options) options);
Resultat options_changement_utilisateur			(TRAVAIL(Options) options);
Resultat options_changement_redefinitionstyles		(TRAVAIL(Options) options);
Resultat options_changement_niveauincorrect		(TRAVAIL(Options) options);
Resultat options_changement_redefinitionidees		(TRAVAIL(Options) options);
Resultat options_changement_ideereferencevide		(TRAVAIL(Options) options);
Resultat options_changement_referenceincorrecte		(TRAVAIL(Options) options);
Resultat options_changement_pertinenceincorrecte	(TRAVAIL(Options) options);
Resultat options_changement_indiceincorrect		(TRAVAIL(Options) options);
Resultat options_changement_commandes			(TRAVAIL(Options) options);
Resultat options_changement_dependancesinutiles		(TRAVAIL(Options) options);
Resultat options_changement_ajoutracine			(TRAVAIL(Options) options);
Resultat options_changement_copielocalisation		(TRAVAIL(Options) options);
Resultat options_changement_localisationabsolue		(TRAVAIL(Options) options);
Resultat options_changement_sectionstylemanquant	(TRAVAIL(Options) options);
Resultat options_changement_referencestylemanquant	(TRAVAIL(Options) options);
Resultat options_changement_ideeautomatiquemanquante	(TRAVAIL(Options) options);
Resultat options_changement_commentaires		(TRAVAIL(Options) options);
Resultat options_changement_dependancesincorrectes	(TRAVAIL(Options) options);
Resultat options_changement_indicereferenceincorrect	(TRAVAIL(Options) options);
Resultat options_changement_nomsectionincorrect		(TRAVAIL(Options) options);

/* Ces fonctions changent l'option concerne.
 * Renvoie RESULTAT_ERREUR si options est NULL.
 */

Resultat options_lecture_licence			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) licence			);
Resultat options_lecture_aide				(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) aide			);
Resultat options_lecture_verbeux			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Entier)  verbeux			);
Resultat options_lecture_inclusion			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) inclusion		);
Resultat options_lecture_source				(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) source			);
Resultat options_lecture_standard			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) standard		);
Resultat options_lecture_macroinconnue			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) macroinconnue		);
Resultat options_lecture_optionmacro			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) optionmacro		);
Resultat options_lecture_recursivite			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) recursivite		);
Resultat options_lecture_redefinitionmacro		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) redefinitionmacro	);
Resultat options_lecture_parametres			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) parametres		);
Resultat options_lecture_erreur				(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) erreur			);
Resultat options_lecture_utilisateur			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) utilisateur		);
Resultat options_lecture_redefinitionstyles		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) redefinitionstyles	);
Resultat options_lecture_niveauincorrect		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) niveauincorrect		);
Resultat options_lecture_redefinitionidees		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) redefinitionidees	);
Resultat options_lecture_ideereferencevide		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) ideereferencevide	);
Resultat options_lecture_referenceincorrecte		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) referenceincorrecte	);
Resultat options_lecture_pertinenceincorrecte		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) pertinenceincorrecte	);
Resultat options_lecture_indiceincorrect		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) indiceincorrect		);
Resultat options_lecture_commandes			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) commandes		);
Resultat options_lecture_dependancesinutiles		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) dependancesinutiles	);
Resultat options_lecture_ajoutracine			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) ajoutracine		);
Resultat options_lecture_copielocalisation		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) copielocalisation	);
Resultat options_lecture_localisationabsolue		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) localisationabsolue	);
Resultat options_lecture_sectionstylemanquant		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) sectionstylemanquant	);
Resultat options_lecture_referencestylemanquant		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) referencestylemanquant	);
Resultat options_lecture_ideeautomatiquemanquante	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) ideeautomatiquemanquante);
Resultat options_lecture_commentaires			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) commentaires		);
Resultat options_lecture_dependancesincorrectes		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) dependancesincorrectes	);
Resultat options_lecture_indicereferenceincorrect	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) indicereferenceincorrect);
Resultat options_lecture_nomsectionincorrect		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) nomsectionincorrect	);

/* Ces fonctions renvoient l'tat de l'option concerne.
 * Renvoie RESULTAT_ERREUR si options est NULL.
 */

Resultat options_copie(TRAVAIL(Options) options , TRAVAIL(Options) copie);
/* Copie une structure d'options.
 * Renvoie RESULTAT_ERREUR si options est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation mmoire choue.
 * Si la copie est non nulle, elle est dtruite avant la copie.
 */

Resultat options_destruction(TRAVAIL(Options) options);
/* Dtruit une structure d'options.
 */

#endif
