/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "options.h"

Resultat options_initialisation(TRAVAIL(Options) options)
{
	/* Cre une structure d'options, avec les valeurs d'options
	 * par dfaut.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation mmoire.
	 */
	if((S_T(options)=(STOCKAGE(Options))(malloc(SIZEOF(CONTENEUR(Options)))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	CHAMP(options , licence)			=FAUX;
	CHAMP(options , aide)				=FAUX;
	CHAMP(options , verbeux)			=0;
	CHAMP(options , inclusion)			=FAUX;
	CHAMP(options , source)				=FAUX;
	CHAMP(options , standard)			=FAUX;
	CHAMP(options , macroinconnue)			=FAUX;
	CHAMP(options , optionmacro)			=FAUX;
	CHAMP(options , recursivite)			=FAUX;
	CHAMP(options , redefinitionmacro)		=FAUX;
	CHAMP(options , parametres)			=FAUX;
	CHAMP(options , erreur)				=FAUX;
	CHAMP(options , utilisateur)			=VRAI;
	CHAMP(options , redefinitionstyles)		=FAUX;
	CHAMP(options , niveauincorrect)		=FAUX;
	CHAMP(options , redefinitionidees)		=VRAI;
	CHAMP(options , ideereferencevide)		=FAUX;
	CHAMP(options , referenceincorrecte)		=FAUX;
	CHAMP(options , pertinenceincorrecte)		=FAUX;
	CHAMP(options , indiceincorrect)		=FAUX;
	CHAMP(options , commandes)			=FAUX;
	CHAMP(options , dependancesinutiles)		=FAUX;
	CHAMP(options , ajoutracine)			=VRAI;
	CHAMP(options , copielocalisation)		=VRAI;
	CHAMP(options , localisationabsolue)		=FAUX;
	CHAMP(options , sectionstylemanquant)		=FAUX;
	CHAMP(options , referencestylemanquant)		=FAUX;
	CHAMP(options , ideeautomatiquemanquante)	=FAUX;
	CHAMP(options , commentaires)			=FAUX;
	CHAMP(options , dependancesincorrectes)		=FAUX;
	CHAMP(options , indicereferenceincorrect)	=FAUX;
	CHAMP(options , nomsectionincorrect)		=FAUX;
	return RESULTAT_OK;
}

Resultat options_changement_licence		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , licence))==T_S_(VRAI))
		CHAMP(options , licence)=FAUX;
	else
		CHAMP(options , licence)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_aide		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , aide))==T_S_(VRAI))
		CHAMP(options , aide)=FAUX;
	else
		CHAMP(options , aide)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_verbeux			(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_S_(CHAMP(options , verbeux))++;
	return RESULTAT_OK;
}
Resultat options_changement_inclusion		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , inclusion))==T_S_(VRAI))
		CHAMP(options , inclusion)=FAUX;
	else
		CHAMP(options , inclusion)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_source		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , source))==T_S_(VRAI))
		CHAMP(options , source)=FAUX;
	else
		CHAMP(options , source)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_standard		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , standard))==T_S_(VRAI))
		CHAMP(options , standard)=FAUX;
	else
		CHAMP(options , standard)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_macroinconnue	(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , macroinconnue))==T_S_(VRAI))
		CHAMP(options , macroinconnue)=FAUX;
	else
		CHAMP(options , macroinconnue)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_optionmacro		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , optionmacro))==T_S_(VRAI))
		CHAMP(options , optionmacro)=FAUX;
	else
		CHAMP(options , optionmacro)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_recursivite		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , recursivite))==T_S_(VRAI))
		CHAMP(options , recursivite)=FAUX;
	else
		CHAMP(options , recursivite)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_redefinitionmacro		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , redefinitionmacro))==T_S_(VRAI))
		CHAMP(options , redefinitionmacro)=FAUX;
	else
		CHAMP(options , redefinitionmacro)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_parametres		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , parametres))==T_S_(VRAI))
		CHAMP(options , parametres)=FAUX;
	else
		CHAMP(options , parametres)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_erreur		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , erreur))==T_S_(VRAI))
		CHAMP(options , erreur)=FAUX;
	else
		CHAMP(options , erreur)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_utilisateur		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , utilisateur))==T_S_(VRAI))
		CHAMP(options , utilisateur)=FAUX;
	else
		CHAMP(options , utilisateur)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_redefinitionstyles		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , redefinitionstyles))==T_S_(VRAI))
		CHAMP(options , redefinitionstyles)=FAUX;
	else
		CHAMP(options , redefinitionstyles)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_niveauincorrect		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , niveauincorrect))==T_S_(VRAI))
		CHAMP(options , niveauincorrect)=FAUX;
	else
		CHAMP(options , niveauincorrect)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_redefinitionidees		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , redefinitionidees))==T_S_(VRAI))
		CHAMP(options , redefinitionidees)=FAUX;
	else
		CHAMP(options , redefinitionidees)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_ideereferencevide		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , ideereferencevide))==T_S_(VRAI))
		CHAMP(options , ideereferencevide)=FAUX;
	else
		CHAMP(options , ideereferencevide)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_referenceincorrecte		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , referenceincorrecte))==T_S_(VRAI))
		CHAMP(options , referenceincorrecte)=FAUX;
	else
		CHAMP(options , referenceincorrecte)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_pertinenceincorrecte		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , pertinenceincorrecte))==T_S_(VRAI))
		CHAMP(options , pertinenceincorrecte)=FAUX;
	else
		CHAMP(options , pertinenceincorrecte)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_indiceincorrect		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , indiceincorrect))==T_S_(VRAI))
		CHAMP(options , indiceincorrect)=FAUX;
	else
		CHAMP(options , indiceincorrect)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_commandes		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , commandes))==T_S_(VRAI))
		CHAMP(options , commandes)=FAUX;
	else
		CHAMP(options , commandes)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_dependancesinutiles		(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , dependancesinutiles))==T_S_(VRAI))
		CHAMP(options , dependancesinutiles)=FAUX;
	else
		CHAMP(options , dependancesinutiles)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_ajoutracine			(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , ajoutracine))==T_S_(VRAI))
		CHAMP(options , ajoutracine)=FAUX;
	else
		CHAMP(options , ajoutracine)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_copielocalisation			(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , copielocalisation))==T_S_(VRAI))
		CHAMP(options , copielocalisation)=FAUX;
	else
		CHAMP(options , copielocalisation)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_localisationabsolue			(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , localisationabsolue))==T_S_(VRAI))
		CHAMP(options , localisationabsolue)=FAUX;
	else
		CHAMP(options , localisationabsolue)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_sectionstylemanquant			(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , sectionstylemanquant))==T_S_(VRAI))
		CHAMP(options , sectionstylemanquant)=FAUX;
	else
		CHAMP(options , sectionstylemanquant)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_referencestylemanquant			(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , referencestylemanquant))==T_S_(VRAI))
		CHAMP(options , referencestylemanquant)=FAUX;
	else
		CHAMP(options , referencestylemanquant)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_ideeautomatiquemanquante			(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , ideeautomatiquemanquante))==T_S_(VRAI))
		CHAMP(options , ideeautomatiquemanquante)=FAUX;
	else
		CHAMP(options , ideeautomatiquemanquante)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_commentaires				(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , commentaires))==T_S_(VRAI))
		CHAMP(options , commentaires)=FAUX;
	else
		CHAMP(options , commentaires)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_dependancesincorrectes				(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , dependancesincorrectes))==T_S_(VRAI))
		CHAMP(options , dependancesincorrectes)=FAUX;
	else
		CHAMP(options , dependancesincorrectes)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_indicereferenceincorrect				(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , indicereferenceincorrect))==T_S_(VRAI))
		CHAMP(options , indicereferenceincorrect)=FAUX;
	else
		CHAMP(options , indicereferenceincorrect)=VRAI;
	return RESULTAT_OK;
}

Resultat options_changement_nomsectionincorrect				(TRAVAIL(Options) options)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	if(T_S_(CHAMP(options , nomsectionincorrect))==T_S_(VRAI))
		CHAMP(options , nomsectionincorrect)=FAUX;
	else
		CHAMP(options , nomsectionincorrect)=VRAI;
	return RESULTAT_OK;
}

/* Ces fonctions changent l'option concerne.
 * Renvoie RESULTAT_ERREUR si options est NULL.
 */

Resultat options_lecture_licence	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) licence		)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(licence)=T_S_(CHAMP(options , licence));
	return RESULTAT_OK;
}

Resultat options_lecture_aide		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) aide		)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(aide)=T_S_(CHAMP(options , aide));
	return RESULTAT_OK;
}

Resultat options_lecture_verbeux			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Entier)  verbeux			)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(verbeux)=T_S_(CHAMP(options , verbeux));
	return RESULTAT_OK;
}

Resultat options_lecture_inclusion	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) inclusion		)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(inclusion)=T_S_(CHAMP(options , inclusion));
	return RESULTAT_OK;
}

Resultat options_lecture_source		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) source		)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(source)=T_S_(CHAMP(options , source));
	return RESULTAT_OK;
}

Resultat options_lecture_standard	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) standard		)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(standard)=T_S_(CHAMP(options , standard));
	return RESULTAT_OK;
}

Resultat options_lecture_macroinconnue	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) macroinconnue	)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(macroinconnue)=T_S_(CHAMP(options , macroinconnue));
	return RESULTAT_OK;
}

Resultat options_lecture_optionmacro	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) optionmacro	)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(optionmacro)=T_S_(CHAMP(options , optionmacro));
	return RESULTAT_OK;
}

Resultat options_lecture_recursivite	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) recursivite	)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(recursivite)=T_S_(CHAMP(options , recursivite));
	return RESULTAT_OK;
}

Resultat options_lecture_redefinitionmacro	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) redefinitionmacro	)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(redefinitionmacro)=T_S_(CHAMP(options , redefinitionmacro));
	return RESULTAT_OK;
}

Resultat options_lecture_parametres	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) parametres		)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(parametres)=T_S_(CHAMP(options , parametres));
	return RESULTAT_OK;
}

Resultat options_lecture_erreur		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) erreur		)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(erreur)=T_S_(CHAMP(options , erreur));
	return RESULTAT_OK;
}

Resultat options_lecture_utilisateur	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) utilisateur	)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(utilisateur)=T_S_(CHAMP(options , utilisateur));
	return RESULTAT_OK;
}

Resultat options_lecture_redefinitionstyles	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) redefinitionstyles	)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(redefinitionstyles)=T_S_(CHAMP(options , redefinitionstyles));
	return RESULTAT_OK;
}

Resultat options_lecture_niveauincorrect	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) niveauincorrect	)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(niveauincorrect)=T_S_(CHAMP(options , niveauincorrect));
	return RESULTAT_OK;
}

Resultat options_lecture_redefinitionidees	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) redefinitionidees	)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(redefinitionidees)=T_S_(CHAMP(options , redefinitionidees));
	return RESULTAT_OK;
}

Resultat options_lecture_ideereferencevide	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) ideereferencevide	)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(ideereferencevide)=T_S_(CHAMP(options , ideereferencevide));
	return RESULTAT_OK;
}

Resultat options_lecture_referenceincorrecte	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) referenceincorrecte	)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(referenceincorrecte)=T_S_(CHAMP(options , referenceincorrecte));
	return RESULTAT_OK;
}

Resultat options_lecture_pertinenceincorrecte	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) pertinenceincorrecte	)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(pertinenceincorrecte)=T_S_(CHAMP(options , pertinenceincorrecte));
	return RESULTAT_OK;
}

Resultat options_lecture_indiceincorrect	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) indiceincorrect	)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(indiceincorrect)=T_S_(CHAMP(options , indiceincorrect));
	return RESULTAT_OK;
}

Resultat options_lecture_commandes	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) commandes		)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(commandes)=T_S_(CHAMP(options , commandes));
	return RESULTAT_OK;
}

Resultat options_lecture_dependancesinutiles	(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) dependancesinutiles		)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(dependancesinutiles)=T_S_(CHAMP(options , dependancesinutiles));
	return RESULTAT_OK;
}

Resultat options_lecture_ajoutracine		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) ajoutracine			)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(ajoutracine)=T_S_(CHAMP(options , ajoutracine))	;
	return RESULTAT_OK;
}

Resultat options_lecture_copielocalisation		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) copielocalisation			)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(copielocalisation)=T_S_(CHAMP(options , copielocalisation))	;
	return RESULTAT_OK;
}

Resultat options_lecture_localisationabsolue		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) localisationabsolue			)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(localisationabsolue)=T_S_(CHAMP(options , localisationabsolue))	;
	return RESULTAT_OK;
}

Resultat options_lecture_sectionstylemanquant		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) sectionstylemanquant			)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(sectionstylemanquant)=T_S_(CHAMP(options , sectionstylemanquant))	;
	return RESULTAT_OK;
}

Resultat options_lecture_referencestylemanquant		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) referencestylemanquant			)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(referencestylemanquant)=T_S_(CHAMP(options , referencestylemanquant))	;
	return RESULTAT_OK;
}

Resultat options_lecture_ideeautomatiquemanquante		(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) ideeautomatiquemanquante			)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(ideeautomatiquemanquante)=T_S_(CHAMP(options , ideeautomatiquemanquante))	;
	return RESULTAT_OK;
}

Resultat options_lecture_commentaires			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) commentaires				)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(commentaires)=T_S_(CHAMP(options , commentaires))		;
	return RESULTAT_OK;
}

Resultat options_lecture_dependancesincorrectes			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) dependancesincorrectes				)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(dependancesincorrectes)=T_S_(CHAMP(options , dependancesincorrectes))		;
	return RESULTAT_OK;
}

Resultat options_lecture_indicereferenceincorrect			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) indicereferenceincorrect				)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(indicereferenceincorrect)=T_S_(CHAMP(options , indicereferenceincorrect))		;
	return RESULTAT_OK;
}

Resultat options_lecture_nomsectionincorrect			(TRAVAIL(Options) options , REFERENCE_SCALAIRE(Booleen) nomsectionincorrect				)
{
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	T_R_(nomsectionincorrect)=T_S_(CHAMP(options , nomsectionincorrect))		;
	return RESULTAT_OK;
}

/* Ces fonctions renvoient l'tat de l'option concerne.
 * Renvoie RESULTAT_ERREUR si options est NULL.
 */

Resultat options_copie(TRAVAIL(Options) options , TRAVAIL(Options) copie)
{
	/* Copie une structure d'options.
	 * Renvoie RESULTAT_ERREUR si options est NULL.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation mmoire choue.
	 * Si la copie est non nulle, elle est dtruite avant la copie.
	 */
	DEBUTZONESECURISEE
	if(S_T(options)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(options_destruction(copie));
	SECURISE(options_initialisation(copie));
	CHAMP(copie , licence)				=CHAMP(options , licence)			;
	CHAMP(copie , aide)				=CHAMP(options , aide)				;
	CHAMP(copie , verbeux)				=CHAMP(options , verbeux)			;
	CHAMP(copie , inclusion)			=CHAMP(options , inclusion)			;
	CHAMP(copie , source)				=CHAMP(options , source)			;
	CHAMP(copie , standard)				=CHAMP(options , standard)			;
	CHAMP(copie , macroinconnue)			=CHAMP(options , macroinconnue)			;
	CHAMP(copie , optionmacro)			=CHAMP(options , optionmacro)			;
	CHAMP(copie , recursivite)			=CHAMP(options , recursivite)			;
	CHAMP(copie , redefinitionmacro)		=CHAMP(options , redefinitionmacro)		;
	CHAMP(copie , parametres)			=CHAMP(options , parametres)			;
	CHAMP(copie , erreur)				=CHAMP(options , erreur)			;
	CHAMP(copie , utilisateur)			=CHAMP(options , utilisateur)			;
	CHAMP(copie , redefinitionstyles)		=CHAMP(options , redefinitionstyles)		;
	CHAMP(copie , niveauincorrect)			=CHAMP(options , niveauincorrect)		;
	CHAMP(copie , redefinitionidees)		=CHAMP(options , redefinitionidees)		;
	CHAMP(copie , ideereferencevide)		=CHAMP(options , ideereferencevide)		;
	CHAMP(copie , referenceincorrecte)		=CHAMP(options , referenceincorrecte)		;
	CHAMP(copie , pertinenceincorrecte)		=CHAMP(options , pertinenceincorrecte)		;
	CHAMP(copie , indiceincorrect)			=CHAMP(options , indiceincorrect)		;
	CHAMP(copie , commandes)			=CHAMP(options , commandes)			;
	CHAMP(copie , dependancesinutiles)		=CHAMP(options , dependancesinutiles)		;
	CHAMP(copie , ajoutracine)			=CHAMP(options , ajoutracine)			;
	CHAMP(copie , copielocalisation)		=CHAMP(options , copielocalisation)		;
	CHAMP(copie , localisationabsolue)		=CHAMP(options , localisationabsolue)		;
	CHAMP(copie , sectionstylemanquant)		=CHAMP(options , sectionstylemanquant)		;
	CHAMP(copie , referencestylemanquant)		=CHAMP(options , referencestylemanquant)	;
	CHAMP(copie , ideeautomatiquemanquante)		=CHAMP(options , ideeautomatiquemanquante)	;
	CHAMP(copie , commentaires)			=CHAMP(options , commentaires)			;
	CHAMP(copie , dependancesincorrectes)		=CHAMP(options , dependancesincorrectes)	;
	CHAMP(copie , indicereferenceincorrect)		=CHAMP(options , indicereferenceincorrect)	;
	CHAMP(copie , nomsectionincorrect)		=CHAMP(options , nomsectionincorrect)		;
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat options_destruction(TRAVAIL(Options) options)
{
	/* Dtruit une structure d'options.
	 */
	if(S_T(options)==NULL)
		return RESULTAT_OK;
	free(S_T(options));
	S_T(options)=NULL;
	return RESULTAT_OK;
}

