/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __COMMANDEFOOT__
#define __COMMANDEFOOT__

#include <src/global/global.h>

typedef struct commandefoot CONTENEUR(CommandeFoot);

#include <src/donnees/flux/flux.h>
#include <src/donnees/flux/actionflux.h>
#include <src/donnees/commandes/localisationfichier.h>

struct commandefoot
{
	STOCKAGE(LocalisationFichier) localisation;
	//Localisation de la commande de pied dans le source.
	STOCKAGE(Flux) pied;
	//Texte du pied du document.
	//Ce flux est de type FLUX_DOCUMENT.
};
/* Commande dsigne pour recevoir le pied du document  gnrer.
 */

Resultat commandefoot_initialisation(TRAVAIL(CommandeFoot) commandefoot);
/* Cre une commande de pied de document vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandefoot_definition_localisationfichier(TRAVAIL(CommandeFoot) commandefoot , TRAVAIL(LocalisationFichier) localisationfichier);
/* Indique la position d'une commande foot.
 * Renvoie RESULTAT_ERREUR si commandefoot est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandefoot_definition_pied(TRAVAIL(CommandeFoot) commandefoot , TRAVAIL(Flux) pied);
/* Assigne un pied de document  la commande correspondante.
 * Renvoie RESULTAT_ERREUR si commandefoot est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandefoot_lecture_localisationfichier(TRAVAIL(CommandeFoot) commandefoot , REFERENCE(LocalisationFichier) localisationfichier);
/* Indique la position d'une commande foot.
 * Renvoie RESULTAT_ERREUR si commandefoot est NULL.
 */

Resultat commandefoot_lecture_pied(TRAVAIL(CommandeFoot) commandefoot , REFERENCE(Flux) pied);
/* Lit un pied de document  la commande correspondante.
 * Renvoie RESULTAT_ERREUR si commandefoot est NULL.
 */

Resultat commandefoot_parcours(TRAVAIL(CommandeFoot) commandefoot , TRAVAIL(ActionFlux) action , TRAVAIL(General) general);
/* Ralise un parcours des flux inclus dans la commande spcifie.
 * Renvoie les mmes erreurs que flux_parcours,
 * ainsi que RESULTAT_ERREUR si commande est NULL,
 * rien ne se passe si action est NULL.
 */

Resultat commandefoot_copie(TRAVAIL(CommandeFoot) commandefoot , TRAVAIL(CommandeFoot) copie);
/* Cre une copie de la commande foot.
 * Renvoie RESULTAT_ERREUR si commandefoot est NULL, et
 * RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 * Si la copie est non vide, elle est au pralable supprime.
 */

Resultat commandefoot_destruction(TRAVAIL(CommandeFoot) commandefoot);
/* Dtruit une commande de pied de document.
 */

#endif
