# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python tools unit tests
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

import unittest
import sys
import gobject

from pgm.graph.image import Image
import pgm

class TestImage(unittest.TestCase):

    def test_image(self):
        img=Image()

        img.position=(1.0, 1.0, 1.0)
        self.assertEqual(img.x, 1.0)
        self.assertEqual(img.y, 1.0)
        self.assertEqual(img.z, 1.0)

        self.assertEqual(pgm.Image.get_position(img), (1.0, 1.0, 1.0))

        img.position_offset=(1.0, 1.0, 1.0)
        self.assertEqual(img.x_offset, 1.0)
        self.assertEqual(img.y_offset, 1.0)
        self.assertEqual(img.z_offset, 1.0)
        self.assertEqual(img.position, (1.0, 1.0, 1.0))
        self.assertEqual(pgm.Image.get_position(img), (2.0, 2.0, 2.0))

        img.y_offset = 2.0
        self.assertEqual(img.position_offset, (1.0, 2.0, 1.0))
        self.assertEqual(pgm.Image.get_position(img), (2.0, 3.0, 2.0))

        img.visible=True
        self.assertEqual(img.visible, True)
        self.assertEqual(pgm.Image.is_visible(img), True)

        img.parent_visibility=True
        self.assertEqual(img.parent_visibility, True)
        self.assertEqual(img.visible, True)
        self.assertEqual(pgm.Image.is_visible(img), True)

        img.parent_visibility=False
        self.assertEqual(img.parent_visibility, False)
        self.assertEqual(img.visible, False)
        self.assertEqual(pgm.Image.is_visible(img), False)

        img.visible=True
        self.assertEqual(img.visible, False)
        self.assertEqual(img.parent_visibility, False)
        self.assertEqual(pgm.Image.is_visible(img), False)

        img.parent_visibility=False
        self.assertEqual(img.visible, False)
        self.assertEqual(img.parent_visibility, False)
        self.assertEqual(pgm.Image.is_visible(img), False)

        img.parent_visibility=True
        self.assertEqual(img.visible, True)
        self.assertEqual(img.parent_visibility, True)
        self.assertEqual(pgm.Image.is_visible(img), True)

        img.parent_visibility=False
        self.assertEqual(img.parent_visibility, False)
        self.assertEqual(img.visible, False)
        self.assertEqual(pgm.Image.is_visible(img), False)

        img.visible=False
        img.parent_visibility=True
        img.parent_visibility=False
        img.parent_visibility=True
        self.assertEqual(img.visible, False)
        self.assertEqual(img.parent_visibility, True)
        self.assertEqual(pgm.Image.is_visible(img), False)

    def test_refcount(self):
        img = Image()

        if gobject.pygobject_version >= (2, 13, 0):
            initial_refcount = 2

            # pgm.Canvas.add takes one reference with the new toggle_ref stuff,
            # (when g_object_ref is called)
            add_refs = 1
        else:
            initial_refcount = 3
            add_refs = 0

        self.assertEqual(sys.getrefcount(img), initial_refcount)
        self.assertEqual(img.__gstrefcount__, 1)

        canvas = pgm.Canvas()
        canvas.add(pgm.DRAWABLE_MIDDLE, img)
        self.assertEqual(sys.getrefcount(img), initial_refcount + add_refs)
        self.assertEqual(img.__gstrefcount__, 2)

        canvas.add(pgm.DRAWABLE_MIDDLE, img)
        canvas.add(pgm.DRAWABLE_MIDDLE, img)
        self.assertEqual(sys.getrefcount(img), initial_refcount + add_refs)
        self.assertEqual(img.__gstrefcount__, 2)

        canvas.remove(img)
        self.assertEqual(sys.getrefcount(img), initial_refcount)
        self.assertEqual(img.__gstrefcount__, 1)

        canvas.remove(img)
        canvas.remove(img)
        self.assertEqual(sys.getrefcount(img), initial_refcount)
        self.assertEqual(img.__gstrefcount__, 1)

