#!/bin/bash
# git merge driver for debian/changelog and other as used in zendframework
# Inspired from https://gist.github.com/mezis/1605647
#
# - Add this to .git/config:
#
#   [merge "zen"]
#   name = zen merge driver
#   driver = ./debian/git-merge-zen.sh %O %A %B
#
# - Add this to .gitattributes:
#
#    debian/changelog	merge=zen
#    …
#
# - Replace __name__ and __Name__ bellow

dcname=eventmanager
ucname=EventManager

O=$1
A=$2
B=$3

# Change the package’s @@name@@
temp1=$(mktemp /tmp/merge-zen.XXXX)
temp2=$(mktemp /tmp/merge-zen.XXXX)
sed "s/@@name@@/$dcname/g;s/@@Name@@/$ucname/g" $O > $temp1
sed "s/@@name@@/$dcname/g;s/@@Name@@/$ucname/g" $B > $temp2

# merge
merge $A $temp1 $temp2

# Clean up
rm $temp1
rm $temp2
