#!/bin/bash
# Bundles required boost headers into percona-xtrabackup release tarball

set -ex

version=$1
boost_version=1_59_0

TMPDIR=$(mktemp -d)

echo "Installing to $TMPDIR for percona-xtrabackup $version"

mkdir -p $TMPDIR/lib

wget -O $TMPDIR/boost_${boost_version}.tar.gz http://jenkins.percona.com/downloads/boost/boost_${boost_version}.tar.gz
tar -xzf $TMPDIR/boost_${boost_version}.tar.gz --directory $TMPDIR/lib
mkdir -p $TMPDIR/lib/percona-xtrabackup-${version}
tar -xzf ../percona-xtrabackup_${version}.orig.tar.gz --strip-components=1 \
    --directory $TMPDIR/lib/percona-xtrabackup-${version}

(
    cd $TMPDIR/lib
    mkdir -p $TMPDIR/lib/percona-xtrabackup-${version}/boost/boost_${boost_version}
    mv boost_${boost_version}/boost $TMPDIR/lib/percona-xtrabackup-${version}/boost/boost_${boost_version}
    tar -cJf percona-xtrabackup_${version}.orig.tar.xz percona-xtrabackup-${version}
)

mv  $TMPDIR/lib/percona-xtrabackup_${version}.orig.tar.xz ..
rm -rf $TMPDIR
