#include "Platform.h"
#include <string.h>
#include <stdio.h>
#include "CGOReader.h"
#include "BaseCommunication.h"
#include "eca_defines.h"

#define base CEC30Reader

CCGOReader::CCGOReader(CReader *Owner,CBaseCommunication *Communicator)
			  :base(Owner,Communicator)
{
}

CCGOReader::~CCGOReader(void)
{
}

CJ_RESULT CCGOReader::BuildReaderInfo()
{
	CJ_RESULT Res;

	Res = base::BuildReaderInfo();

	m_ReaderInfo.HardwareMask |= 0;

	return Res;
}


uint16_t CCGOReader::HostToReaderShort(uint16_t Value)
{
   return InversByteOrderShort(htons(Value));
}

uint32_t CCGOReader::HostToReaderLong(uint32_t Value)
{
   return InversByteOrderLong(htonl(Value));
}



void CCGOReader::SetHWString(char *String)
{
   strcpy(String,"CGO_");
}

void CCGOReader::GetProductString(uint8_t *Product)
{
	memcpy(Product,"CJ-GO",5);
}


CJ_RESULT CCGOReader::CtSetContrast(EContrast eContrast,uint32_t *Result)
{
	CJ_RESULT Res;
	switch(eContrast)
	{
	case ContrastVeryLow:
		Res=_CtSetContrast(0,Result);
		break;
	case ContrastLow:
		Res=_CtSetContrast(70,Result);
		break;
	case ContrastMedium:
		Res=_CtSetContrast(120,Result);
		break;
	case ContrastHigh:
		Res=_CtSetContrast(160,Result);
		break;
	case ContrastVeryHigh:
		Res=_CtSetContrast(255,Result);
		break;
	default:
		Res=CJ_ERR_WRONG_PARAMETER;
	}
	return Res;
}


CJ_RESULT CCGOReader::CtSetBacklight(EBacklight eBacklight,uint32_t *Result)
{
	CJ_RESULT Res;
	switch(eBacklight)
	{
	case BacklightOff:
		Res=_CtSetBacklight(0,Result);
		break;
	case BacklightVeryLow:
		Res=_CtSetBacklight(70,Result);
		break;
	case BacklightLow:
		Res=_CtSetBacklight(100,Result);
		break;
	case BacklightMedium:
		Res=_CtSetBacklight(120,Result);
		break;
	case BacklightHigh:
		Res=_CtSetBacklight(160,Result);
		break;
	case BacklightVeryHigh:
		Res=_CtSetBacklight(255,Result);
		break;
	default:
		Res=CJ_ERR_WRONG_PARAMETER;
	}
	return Res;
}

bool CCGOReader::HastModulestoreInfo()
{
	return true;
}

CJ_RESULT CCGOReader::CtSetSilentMode(bool boolMode,bool *pboolMode,uint32_t *Result)
{
	if(pboolMode)
		*pboolMode=boolMode;
  if(Result)
		*Result=0;
	return CJ_SUCCESS;
}

CJ_RESULT CCGOReader::CtGetSilentMode(bool *pboolMode,uint32_t *Result)
{
	if(pboolMode)
		*pboolMode=0;
  if(Result)
		*Result=0;
	return CJ_SUCCESS;
}

CJ_RESULT CCGOReader::SpecialLess3_0_41()
{
	return CJ_SUCCESS;
}

bool CCGOReader::PinDirectSupported()
{
	return true;
}

#ifdef WITH_SECODER_INFO_OVERRIDE
CJ_RESULT CCGOReader::KTLightCall(uint8_t *sad, uint8_t *dad, uint8_t *cmd, uint16_t lenc, int32_t Lc, uint8_t *data_ptr, int32_t Le, uint8_t *response, uint16_t *lenr)
{
	static const uint8_t SECODER3_INFO_0[] = {
		"\x40\x07""Secoder"
		"\x80\x05""1.2.0"
		"\x80\x05""1.1.2"
		"\x81\x21""Reiner Kartenger\x7b""te GmbH & Co.KG."
	};
	static const uint8_t SECODER3_INFO_1[] = {
		"\x84\x02""de"
		"\x90\x01\x01"
		"\xa0\x13\x40\x03""tan\x80\x05""1.1.2\x83\x05""1.0.0"
		"\xa0\x13\x40\x03""aut\x80\x05""1.1.2\x83\x05""1.0.0"
		"\xa0\x13\x40\x03""sig\x80\x05""1.1.2\x83\x05""1.0.0"
		"\xa0\x13\x40\x03""gkp\x80\x05""1.1.2\x83\x05""1.0.0"
		"\xa0\x16\x40\x03""ctn\x80\x05""1.2.1\x83\x05""1.0.0\x84\x01\x33"
		"\x90\x00"
	};

	CJ_RESULT res;
	uint16_t InLenr = *lenr;
	uint8_t ReaderId[20 + 2];
	uint8_t SWImpVers[10 + 2];
	uint8_t ReaderPorp[9 + 2];
	int lenReaderId = 0;
	int lenSWImpVers = 0;
	int lenReaderProp = 0;
	uint8_t *Tag92 = NULL;
	uint8_t *Tag83 = NULL;
	uint8_t *Tag91 = NULL;
	uint8_t inCmd1 = *(cmd + 1);

	memset(ReaderId, 0, sizeof(ReaderId));
	memset(SWImpVers, 0, sizeof(SWImpVers));

	if ((res = base::KTLightCall(sad, dad, cmd, lenc, Lc, data_ptr, Le, response, lenr)) == CJ_SUCCESS)
	{
		if (inCmd1 == 0x70 && m_ReaderInfo.Version >= 0x21)
		{
			if (GetEnviroment("SecoderInfoOverride", 0x00000001) > 0)
			{
				if (GetEnviroment("SecoderInfoOverride_CGO", 0x00000001) > 0)
				{
					if (((Tag91 = GetTag(response, *lenr - 2, 0x91, &lenReaderProp)) != NULL) &&
						((Tag92 = GetTag(response, *lenr - 2, 0x92, &lenReaderId)) != NULL) &&
						((Tag83 = GetTag(response, *lenr - 2, 0x83, &lenSWImpVers)) != NULL) &&
						(lenReaderId <= 20) && (lenSWImpVers <= 10) && (lenReaderProp == 9))
					{
						lenReaderProp += 2;
						memcpy(ReaderPorp, Tag91 - 2, lenReaderProp);

						lenReaderId += 2;
						memcpy(ReaderId, Tag92 - 2, lenReaderId);

						lenSWImpVers += 2;
						memcpy(SWImpVers, Tag83 - 2, lenSWImpVers);

						if (InLenr >= (sizeof(SECODER3_INFO_0) + lenReaderProp + lenReaderId + lenSWImpVers + sizeof(SECODER3_INFO_1)))
						{
							memcpy(response, SECODER3_INFO_0, sizeof(SECODER3_INFO_0) - 1);
							memcpy(response + sizeof(SECODER3_INFO_0) - 1, ReaderPorp, lenReaderProp);
							memcpy(response + sizeof(SECODER3_INFO_0) - 1 + lenReaderProp, ReaderId, lenReaderId);
							memcpy(response + sizeof(SECODER3_INFO_0) - 1 + lenReaderProp + lenReaderId, SWImpVers, lenSWImpVers);
							memcpy(response + sizeof(SECODER3_INFO_0) - 1 + lenReaderProp + lenReaderId + lenSWImpVers, SECODER3_INFO_1, sizeof(SECODER3_INFO_1) - 1);
							*lenr = sizeof(SECODER3_INFO_0) - 1 + (USHORT)lenReaderProp + (USHORT)lenReaderId + (USHORT)lenSWImpVers + sizeof(SECODER3_INFO_1) - 1;
						}
						else
						{
							return CJ_ERR_RBUFFER_TO_SMALL;
						}
					}
				}
			}
		}
	}
	return res;
}

#include "eca_defines.h"

CJ_RESULT CCGOReader::CtSetMFT(const uint8_t* const pData, uint32_t DataLen, uint32_t* Result)
{
	UNREFERENCED_PARAMETER(pData);
	UNREFERENCED_PARAMETER(DataLen);
	UNREFERENCED_PARAMETER(Result);

	return CJ_ERR_NOT_SUPPORTED;
}

CJ_RESULT CCGOReader::CtGetMFT(cj_MFT_Info* const pData, uint32_t* const pNumElemnts)
{
	uint32_t nCount = 0;

	if (*pNumElemnts < 2)
	{
		*pNumElemnts = 0;
		return CJ_ERR_RBUFFER_TO_SMALL;
	}

	pData[nCount].FID = 1003;
	pData[nCount].Status = 1;
	strcpy((char*)pData[nCount].Name, "Secoder V 2.0");
	nCount++;

	pData[nCount].FID = 1;
	pData[nCount].Status = 1;
	strcpy((char*)pData[nCount].Name, "chipTAN 1.1");
	nCount++;

	*pNumElemnts = nCount;

	return CJ_SUCCESS;
}
#endif