// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef EXPRESSION_H
#define EXPRESSION_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: Expression
//
// Purpose:
//    This class contains an expression.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API Expression : public AttributeSubject
{
public:
    enum ExprType
    {
        Unknown,
        ScalarMeshVar,
        VectorMeshVar,
        TensorMeshVar,
        SymmetricTensorMeshVar,
        ArrayMeshVar,
        CurveMeshVar,
        Mesh,
        Material,
        Species
    };

    // These constructors are for objects of this class
    Expression();
    Expression(const Expression &obj);
protected:
    // These constructors are for objects derived from this class
    Expression(private_tmfs_t tmfs);
    Expression(const Expression &obj, private_tmfs_t tmfs);
public:
    virtual ~Expression();

    virtual Expression& operator = (const Expression &obj);
    virtual bool operator == (const Expression &obj) const;
    virtual bool operator != (const Expression &obj) const;
private:
    void Init();
    void Copy(const Expression &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectName();
    void SelectDefinition();
    void SelectOperatorName();
    void SelectMeshName();
    void SelectDbName();

    // Property setting methods
    void SetName(const std::string &name_);
    void SetDefinition(const std::string &definition_);
    void SetHidden(bool hidden_);
    void SetType(ExprType type_);
    void SetFromDB(bool fromDB_);
    void SetFromOperator(bool fromOperator_);
    void SetOperatorName(const std::string &operatorName_);
    void SetMeshName(const std::string &meshName_);
    void SetDbName(const std::string &dbName_);
    void SetAutoExpression(bool autoExpression_);

    // Property getting methods
    const std::string &GetName() const;
          std::string &GetName();
    const std::string &GetDefinition() const;
          std::string &GetDefinition();
    bool              GetHidden() const;
    ExprType          GetType() const;
    bool              GetFromDB() const;
    bool              GetFromOperator() const;
    const std::string &GetOperatorName() const;
          std::string &GetOperatorName();
    const std::string &GetMeshName() const;
          std::string &GetMeshName();
    const std::string &GetDbName() const;
          std::string &GetDbName();
    bool              GetAutoExpression() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string ExprType_ToString(ExprType);
    static bool ExprType_FromString(const std::string &, ExprType &);
protected:
    static std::string ExprType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    static int GetNumTypes();
    static const char * GetTypeString(const Expression::ExprType t);
    static Expression::ExprType GetTypeId(const std::string s);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_name = 0,
        ID_definition,
        ID_hidden,
        ID_type,
        ID_fromDB,
        ID_fromOperator,
        ID_operatorName,
        ID_meshName,
        ID_dbName,
        ID_autoExpression,
        ID__LAST
    };

private:
    std::string name;
    std::string definition;
    bool        hidden;
    int         type;
    bool        fromDB;
    bool        fromOperator;
    std::string operatorName;
    std::string meshName;
    std::string dbName;
    bool        autoExpression;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define EXPRESSION_TMFS "ssbibbsssb"

#endif
