//=======================================================================
// info.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef PACO_INFO_H
#define PACO_INFO_H

#include <vector>
#include <set>
#include <iosfwd>

namespace Paco {

class Log;

class Info
{
	public:

	Info(Log&);

	private:

	class Define
	{
		public:

		static char const FMT_SPEC = '%';
		static char const FMT_PC   = '$';

		Define(char const fmt, std::string const& var, std::string const& val);
	
		void resolve(std::string& str) const;
	
		private:
		
		char mFmt;
		std::string mVar;
		std::string mVal;

	};	// class Info::Define

	std::string 			mIcon;
	std::string 			mOpts;
	std::string 			mName;
	std::string 			mVersion;
	std::string 			mAuthor;
	std::string 			mSummary;
	std::string 			mUrl;
	std::string 			mLicense;
	std::string 			mDesc;
	std::string 			mPkg;
	std::string 			mBase;
	std::string 			mDesktopFile;
	std::vector<Define> 	mDef;
	std::set<std::string> 	mDirs;
	std::set<std::string>&	mFiles;

	std::string getIcon();
	void getDirs();
	void getInfoSpec();
	void getInfoAspec();
	void getInfoPC();
	void getInfoDesktop();
	void getConfigOpts();
	void getPCDefines(std::string const&);
	void getSpecDefines(std::string const&);
	void writeInfo() const;
	void printInfo() const;
	void getDescription(std::string const&, std::string const&);
	std::string& resolveDefines(std::string&) const;
	bool getInfoVar(std::string const&, std::string const&, std::string&) const;
	std::string searchFile(	std::string const&,
							std::string const& suffix = "") const;

};	// class Info

}	// namespace Paco


#endif	// PACO_INFO_H
