///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

/**
 * \file ScrPliptuginClassDescriptor.h
 * \brief Contains the definition of the Scripting::ScriptPluginClassDescriptor class.
 */

#ifndef __OVITO_SCRIPT_PLUGINCLASS_DESCRIPTOR_H
#define __OVITO_SCRIPT_PLUGINCLASS_DESCRIPTOR_H

#include <scripting/Scripting.h>
#include <core/plugins/PluginClassDescriptor.h>

namespace Scripting {

/**
 * \brief Describes a Python class defined by a script plugin.
 *
 * Each class provided by a script plug-in is decribed by such a descriptor structure
 * that is loaded from the plug-in's manifest file.
 *
 * \author Alexander Stukowski
 * \sa ScriptPlugin
 */
class SCRIPTING_DLLEXPORT ScriptPluginClassDescriptor : public PluginClassDescriptor
{
protected:

	/// \brief Creates an instance of the class described by this descriptor.
	/// \param isLoading This specifies whether the object is being loaded from a file or just
	///                  created from scratch at runtime.
	/// \return The new instance of the class. The pointer can safely be cast to the appropriate C++ class type.
	/// \throw Exception if the instance could not be created.
	virtual intrusive_ptr<PluginClass> createInstanceImpl(bool isLoading);

private:

	/// Constructor.
	ScriptPluginClassDescriptor(const QString& name, PluginClassDescriptor* baseClass, Plugin* plugin, const QDomElement& classNode, bool isAbstract, bool serializable);

	friend class ScriptPlugin;
};

};	// End of namespace

#endif // __OVITO_SCRIPT_PLUGINCLASS_DESCRIPTOR_H
