///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/actions/ActionManager.h>
#include "MainMenu.h"

namespace Core {

/******************************************************************************
* Constructor that builds the main menu.
******************************************************************************/
MainMenu::MainMenu(QWidget* parentWindow) : QMenuBar(parentWindow)
{
	// Build the file menu.
	_fileMenu = addMenu(tr("&File"));
	if(APPLICATION_MANAGER.experimentalMode()) {
		_fileMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_FILE_NEW));
		_fileMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_FILE_RESET));
		_fileMenu->addSeparator();
	}
	_fileMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_FILE_OPEN));
	_fileMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_FILE_SAVE));
	_fileMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_FILE_SAVEAS));
	_fileMenu->addSeparator();
	_fileMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_FILE_IMPORT));
	_fileMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_FILE_EXPORT));
	_fileMenu->addSeparator();
	_fileMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_EXIT));

	// Build the edit menu.
	_editMenu = addMenu(tr("&Edit"));
	_editMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_EDIT_UNDO));
	_editMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_EDIT_REDO));
	if(APPLICATION_MANAGER.experimentalMode()) {
		_editMenu->addSeparator();
		_editMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_EDIT_DELETE));
	}

	// Build the options menu.
	_optionsMenu = addMenu(tr("&Options"));
	_optionsMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_SETTINGS_DIALOG));

	// Build the help menu.
	_helpMenu = addMenu(tr("&Help"));
	_helpMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_HELP_SHOW_ONLINE_HELP));
	if(APPLICATION_MANAGER.experimentalMode()) {
		_helpMenu->addSeparator();
		_helpMenu->addAction(QWhatsThis::createAction(parentWindow));
	}
	_helpMenu->addSeparator();
	_helpMenu->addAction(ACTION_MANAGER.findActionProxy(ACTION_HELP_ABOUT));
}

};
