###############################################################################
# OpenVAS Vulnerability Test
# $Id: unbound_37459.nasl 8292 2010-07-05 13:17:44Z mime $
#
# Unbound DNS Server NSEC3 Signature Verification DNS Spoofing Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100416);
 script_bugtraq_id(37459);
 script_cve_id("CVE-2009-3602");
 script_version ("1.0-$Revision: 8292 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");

 script_name("Unbound DNS Server NSEC3 Signature Verification DNS Spoofing Vulnerability");

desc = "Overview:
Unbound DNS Server is prone to a DNS-spoofing vulnerability.

Successful exploits allow remote attackers to spoof delegation
responses so as to downgrade secure delegations to insecure status,
which may aid in further attacks.

Versions prior to Unbound 1.3.4 are vulnerable.

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37459
http://unbound.net/pipermail/unbound-users/2009-October/000852.html
http://unbound.net/index.html

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Unbound version is < 1.3.4");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("unbound_version.nasl");
 script_require_keys("unbound/version");
 exit(0);
}

include("version_func.inc");

udpPort = 53;
if(!get_udp_port_state(udpPort)){
  exit(0);
}

bindVer = get_kb_item("unbound/version");
if(!bindVer){
  exit(0);
}

if(version_is_less(version:bindVer, test_version:"1.3.4") ) {
  security_warning(port:udpPort, proto:"udp");
  exit(0);
}

exit(0);
